/*
 * Decompiled with CFR 0.152.
 */
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;

public class OraRacSqlNetHelper
extends Thread {
    public boolean done = false;
    private OraRacSqlNetTest test = null;
    public ArrayList names = null;
    public ArrayList values = null;
    public String ddString = "";
    private static final String DEBUG = "DEBUG    ";
    private static final String EG_TIME_FORMAT = "dd/MM/yyyy HH:mm:ss.SSS";
    private static final SimpleDateFormat MY_SDF = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss.SSS");

    public OraRacSqlNetHelper(OraRacSqlNetTest oraRacSqlNetTest) {
        this.test = oraRacSqlNetTest;
        this.start();
    }

    public void run() {
        Statement statement = null;
        ResultSet resultSet = null;
        Connection connection = null;
        try {
            long l = System.currentTimeMillis();
            try {
                String string = "";
                Properties properties = new Properties();
                properties.put("user", this.test.userName);
                properties.put("password", this.test.userPasswd);
                boolean bl = this.test.isSSLEnabled;
                this.printOut("Is SSL Enabled :" + bl);
                string = this.test.service ? "jdbc:oracle:thin:@//" + this.test.targetHost + ":" + this.test.portNo + "/" + this.test.serviceName : "jdbc:oracle:thin:@" + this.test.targetHost + ":" + this.test.portNo + ":" + this.test.oraSid;
                connection = bl ? this.newConnection(string, properties, this.test.sslParametersHT) : this.newConnection(string, properties);
            }
            catch (Exception exception) {
                this.printOut("Connection :false for test OraRacSqlNetTest and reportingName :" + this.test.reportingName);
                this.test.dbConnAvailable = 0;
                this.test.dbConnTime = -5.0;
                this.done = true;
            }
            if (connection == null) {
                this.printOut("Connection :false for test OraRacSqlNetTest and reportingName :" + this.test.reportingName);
                this.done = true;
                return;
            }
            long l2 = 0L;
            if (connection != null) {
                this.printOut("Connection :true for test OraRacSqlNetTest and reportingName :" + this.test.reportingName);
                this.test.dbConnAvailable = 100;
                long l3 = System.currentTimeMillis();
                this.test.dbConnTime = (double)(l3 - l) / 1000.0;
                l2 = System.currentTimeMillis();
                statement = connection.createStatement();
                if (statement != null) {
                    resultSet = statement.executeQuery(this.test.queryStmt);
                    this.printOut("create Statement :true for test OraRacSqlNetTest and reportingName :" + this.test.reportingName);
                }
            }
            if (resultSet != null) {
                this.test.noOfRecords = 0;
                this.test.qryProAvailable = 100;
                long l4 = System.currentTimeMillis();
                this.test.qryExeTime = (double)(l4 - l2) / 1000.0;
                this.names = new ArrayList();
                this.values = new ArrayList();
                try {
                    while (resultSet.next()) {
                        String string = resultSet.getString("NAME");
                        double d = resultSet.getDouble("value");
                        this.names.add(string);
                        this.values.add(new Double(d));
                        ++this.test.noOfRecords;
                    }
                }
                catch (Exception exception) {
                    this.test.noOfRecords = 0;
                }
            } else {
                this.test.qryProAvailable = -5;
                this.test.qryExeTime = -5.0;
            }
            this.test.availability = this.test.dbConnAvailable == 100 && this.test.qryProAvailable == 100 ? 100 : 0;
            resultSet.close();
            statement.close();
            connection.close();
            long l5 = System.currentTimeMillis();
            this.test.responseTime = this.test.availability == 100 ? (double)(l5 - l) / 1000.0 : -5.0;
            this.done = true;
        }
        catch (Exception exception) {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception exception3) {
                // empty catch block
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception4) {
                // empty catch block
            }
            this.names = null;
            this.values = null;
            this.done = true;
            this.ddString = EgInstallInfo.getStackTraceAsString((Exception)exception);
        }
    }

    private Connection newConnection(String string, Properties properties) throws SQLException {
        Connection connection = null;
        long l = System.currentTimeMillis();
        try {
            Class.forName("oracle.jdbc.driver.OracleDriver");
            connection = DriverManager.getConnection(string, properties);
        }
        catch (Exception exception) {
            this.printOut("Error  while getting connection for ORA SQLNET Test..." + exception.getMessage());
            this.ddString = EgInstallInfo.getStackTraceAsString((Exception)exception);
            long l2 = System.currentTimeMillis();
            long l3 = l2 - l;
            if (l3 >= 60000L) {
                this.printOut("ORA SQLNET  test got stuck while getting connection...");
                l = l2;
            }
            return null;
        }
        return connection;
    }

    private Connection newConnection(String string, Properties properties, Hashtable hashtable) throws SQLException {
        Connection connection = null;
        long l = System.currentTimeMillis();
        String string2 = "OraSqlNetHelper";
        try {
            Class.forName("oracle.jdbc.driver.OracleDriver");
            this.printOut("[ " + string2 + " ] : [ newConnection ] Hashtable sslParametersHT  :" + hashtable);
            if (!OraRacSqlNetHelper.isHashtableNull(hashtable)) {
                if (hashtable.containsKey("isSSLEnabled")) {
                    String string3 = hashtable.get("isSSLEnabled") + "";
                    if (string3.equalsIgnoreCase("true")) {
                        String string4 = hashtable.get("urlWithSSL") + "";
                        String string5 = hashtable.get("trustStorePath") + "";
                        String string6 = hashtable.get("trustStoreType") + "";
                        String string7 = hashtable.get("trustStorePassword") + "";
                        String string8 = hashtable.get("egReportName") + "";
                        String string9 = hashtable.get("eGTestName") + "";
                        string = string4;
                        properties.setProperty("javax.net.ssl.trustStore", string5);
                        properties.setProperty("javax.net.ssl.trustStoreType", string6);
                        properties.setProperty("javax.net.ssl.trustStorePassword", string7);
                        this.printOut("[ " + string2 + " ] :  [ " + string8 + "  ] : [ newConnection ] :isSSLEnabled     :" + string3);
                        this.printOut("[ " + string2 + " ] :  [ " + string8 + "  ] : [ newConnection ] :URL              :" + string);
                        this.printOut("[ " + string2 + " ] :  [ " + string8 + "  ] : [ newConnection ] :trustStorePath     :" + string5);
                        this.printOut("[ " + string2 + " ] :  [ " + string8 + "  ] : [ newConnection ] :trustStoreType     :" + string6);
                    } else {
                        this.printOut("[ " + string2 + " ] : [ newConnection ] : SSL not enabled.");
                    }
                } else {
                    this.printOut("[ " + string2 + " ] : [ newConnection ] : Hashtable doesnt contain key \"isSSLEnabled\" .");
                }
            } else {
                this.printOut("[ " + string2 + " ] : [ newConnection ] : Hashtable is null.");
            }
            connection = DriverManager.getConnection(string, properties);
        }
        catch (Exception exception) {
            this.printOut("Error  while getting connection for ORA SQLNET Test..." + exception.getMessage());
            this.ddString = EgInstallInfo.getStackTraceAsString((Exception)exception);
            long l2 = System.currentTimeMillis();
            long l3 = l2 - l;
            if (l3 >= 60000L) {
                this.printOut("ORA SQLNET  test got stuck while getting connection...");
                l = l2;
            }
            return null;
        }
        return connection;
    }

    protected static boolean isHashtableNull(Hashtable hashtable) {
        return hashtable == null || hashtable.isEmpty() || hashtable.size() < 1;
    }

    public void printOut(String string) {
        System.out.println(" >> [ " + MY_SDF.format(new Date()) + " ]  : [  OraSqlNetHelper  ] : [ " + DEBUG + " ] : >> " + string);
    }
}

