/*
 * Decompiled with CFR 0.152.
 */
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Kernel32Util;
import com.sun.jna.platform.win32.Wevtapi;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.platform.win32.Winevt;
import com.sun.jna.ptr.IntByReference;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.TimeZone;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class EventLogReader {
    private static final int BUFFER_EVENT = 16384;
    private static final int BUFFER_CHANNEL = 512;
    private static final int BUFFER_PROVIDER_NAME = 512;
    private static final String XPATH_PROVIDER_NAME = "Event/System/Provider/@Name";
    private static final int BUFFER_RECORD_ID = 64;
    private static final String XPATH_RECORD_ID = "Event/System/EventRecordID";
    private static final int BUFFER_SYSTEMTIME = 512;
    private static final String XPATH_RECORD_DATETIME = "Event/System/TimeCreated/@SystemTime";
    private static final String FAILURE_EVENT = "0x8010000000000000";
    private static final String SUCCESS_EVENT = "0x8020000000000000";
    private static final String INFORAMTION_LEVEL = "4";
    private static final String WARNING_LEVEL = "3";
    private static final String ERROR_LEVEL = "2";
    private static final String CRITICAL_LEVEL = "1";
    private static final String seperator = "~*~";
    private static final int logFileSizeLimit = 100000000;
    private static int fileCount = 1;

    public static void closeHandle(Winevt.EVT_HANDLE eVT_HANDLE) {
        if (eVT_HANDLE != null && !Wevtapi.INSTANCE.EvtClose(eVT_HANDLE)) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
    }

    public static String getUnicodeStringFromMemory(Memory memory, int n) {
        return StandardCharsets.UTF_16LE.decode(memory.getByteBuffer(0L, (long)n)).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getChannels() {
        Winevt.EVT_HANDLE eVT_HANDLE = Wevtapi.INSTANCE.EvtOpenChannelEnum(null, 0);
        if (eVT_HANDLE == null) {
            int n = Kernel32.INSTANCE.GetLastError();
            System.out.println("[EventLogReader] EvtOpenChannelEnum error: " + n);
            System.out.println("[EventLogReader] formatMessageFromLastErrorCode " + Kernel32Util.formatMessageFromLastErrorCode((int)n));
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            char[] cArray = new char[512];
            IntByReference intByReference = new IntByReference();
            while (true) {
                boolean bl;
                if (!(bl = Wevtapi.INSTANCE.EvtNextChannelPath(eVT_HANDLE, cArray.length, cArray, intByReference))) {
                    int n = Kernel32.INSTANCE.GetLastError();
                    if (n == 122) {
                        System.out.println("[EventLogReader] Insufficient buffer [channel name]: " + cArray.length + ", expected: " + intByReference.getValue());
                        cArray = new char[cArray.length * 2];
                        continue;
                    }
                    if (n == 259) {
                        break;
                    }
                    n = Kernel32.INSTANCE.GetLastError();
                    System.out.println("[EventLogReader] EvtNextChannelPath error: " + n);
                    System.out.println("[EventLogReader] formatMessageFromLastErrorCode " + Kernel32Util.formatMessageFromLastErrorCode((int)n));
                    String[] stringArray = null;
                    return stringArray;
                }
                arrayList.add(Native.toString((char[])cArray));
            }
        }
        finally {
            EventLogReader.closeHandle(eVT_HANDLE);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private static void useMemory(Winevt.EVT_VARIANT eVT_VARIANT, Memory memory, int n) {
        eVT_VARIANT.use(memory.share((long)(eVT_VARIANT.size() * n)));
        eVT_VARIANT.read();
    }

    public static Object[] getVariantsFromMemory(Memory memory, int n) {
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            Winevt.EVT_VARIANT eVT_VARIANT = new Winevt.EVT_VARIANT();
            eVT_VARIANT.use(memory.share((long)(eVT_VARIANT.size() * i)));
            eVT_VARIANT.read();
            objectArray[i] = eVT_VARIANT.getValue();
        }
        return objectArray;
    }

    public static String renderEventXml(Winevt.EVT_HANDLE eVT_HANDLE) {
        String string = null;
        Memory memory = new Memory(16384L);
        IntByReference intByReference = new IntByReference();
        boolean bl = Wevtapi.INSTANCE.EvtRender(null, eVT_HANDLE, 1, (int)memory.size(), (Pointer)memory, intByReference, new IntByReference());
        if (!bl) {
            int n = Kernel32.INSTANCE.GetLastError();
            if (n == 122) {
                System.out.println("[EventLogReader] Insufficient buffer [render event]: " + memory.size() + ", expected: " + intByReference.getValue());
                memory = new Memory((long)intByReference.getValue());
                bl = Wevtapi.INSTANCE.EvtRender(null, eVT_HANDLE, 1, (int)memory.size(), (Pointer)memory, intByReference, new IntByReference());
                if (!bl) {
                    System.out.println(new Win32Exception(Kernel32.INSTANCE.GetLastError()));
                    return string;
                }
            } else {
                n = Kernel32.INSTANCE.GetLastError();
                System.out.println("[EventLogReader] EvtRender error: " + n);
                System.out.println("[EventLogReader] formatMessageFromLastErrorCode " + Kernel32Util.formatMessageFromLastErrorCode((int)n));
                return string;
            }
        }
        string = EventLogReader.getUnicodeStringFromMemory(memory, intByReference.getValue());
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatEventXml(Winevt.EVT_HANDLE eVT_HANDLE, int n) {
        String string = EventLogReader.getProviderName(eVT_HANDLE);
        Winevt.EVT_HANDLE eVT_HANDLE2 = Wevtapi.INSTANCE.EvtOpenPublisherMetadata(null, string, null, n, 0);
        if (eVT_HANDLE2 == null) {
            int n2 = Kernel32.INSTANCE.GetLastError();
            System.out.println("[EventLogReader] EvtOpenPublisherMetadata error: " + n2);
            System.out.println("[EventLogReader] formatMessageFromLastErrorCode " + Kernel32Util.formatMessageFromLastErrorCode((int)n2));
            return null;
        }
        try {
            Object object;
            Object object2;
            String[] stringArray = new String[]{XPATH_PROVIDER_NAME, XPATH_RECORD_ID, XPATH_RECORD_DATETIME, "Event/System/Level", "Event/System/Task", "Event/System/Computer", "Event/System/Security/@UserID", "Event/System/EventID", "Event/EventData/Data", "Event/System/Channel", "Event/System/Keywords", "Event/System/Execution/@ProcessID", "Event/System/Execution/@ThreadID"};
            Object[] objectArray = EventLogReader.renderEventProperties(eVT_HANDLE, stringArray, 1024);
            String string2 = "<Security/>";
            String string3 = "";
            String string4 = "";
            String string5 = "";
            String string6 = "";
            String string7 = "";
            String string8 = "";
            String string9 = "";
            String string10 = "";
            String string11 = "";
            String string12 = "";
            String string13 = "";
            String string14 = "";
            if (objectArray[0] != null) {
                string3 = objectArray[0].toString();
            }
            if (objectArray[1] != null) {
                string4 = objectArray[1].toString();
            }
            if (objectArray[2] != null) {
                object2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
                ((DateFormat)object2).setTimeZone(TimeZone.getTimeZone("UTC"));
                object = ((WinBase.FILETIME)objectArray[2]).toDate();
                string5 = ((DateFormat)object2).format((Date)object).toString();
            }
            if (objectArray[3] != null) {
                string6 = objectArray[3].toString();
            }
            if (objectArray[4] != null) {
                string7 = objectArray[4].toString();
            }
            if (objectArray[5] != null) {
                string8 = objectArray[5].toString();
            }
            if (objectArray[6] != null) {
                string9 = Advapi32Util.convertSidToStringSid((WinNT.PSID)((WinNT.PSID)objectArray[6]));
                if (string9.trim().length() > 0) {
                    string9 = "<Security UserID='" + string9 + "'/>";
                }
            } else {
                string9 = string2;
            }
            string10 = objectArray[7] != null ? objectArray[7].toString() : "0";
            if (objectArray[9] != null) {
                string11 = objectArray[9].toString();
            }
            if (objectArray[10] != null) {
                string12 = Long.toHexString(Long.parseLong(objectArray[10].toString()));
            }
            if (objectArray[11] != null) {
                string13 = objectArray[11].toString();
            }
            if (objectArray[12] != null) {
                string14 = objectArray[12].toString();
            }
            object2 = EventLogReader.getMessage(eVT_HANDLE2, eVT_HANDLE);
            object = "<Event xmlns='http://schemas.microsoft.com/win/2004/08/events/event'><System><Provider Name='" + string3 + "'/><EventID Qualifiers='0'>" + string10 + "</EventID><Version>0</Version><Level>" + string6 + "</Level><Task>" + string7 + "</Task><Opcode>0</Opcode><Keywords>" + string12 + "</Keywords><TimeCreated SystemTime='" + string5 + "'/><EventRecordID>" + string4 + "</EventRecordID><Correlation/><Execution ProcessID='" + string13 + "' ThreadID='" + string14 + "'/><Channel>" + string11 + "</Channel><Computer>" + string8 + "</Computer>" + string9 + "</System><EventData><Data>" + (String)object2 + "</Data></EventData></Event>";
            System.out.println("[EventLogReader] formatEventXml eventStr " + (String)object);
            Object object3 = object;
            return object3;
        }
        finally {
            EventLogReader.closeHandle(eVT_HANDLE2);
        }
    }

    public static String getMessage(Winevt.EVT_HANDLE eVT_HANDLE, Winevt.EVT_HANDLE eVT_HANDLE2) {
        try {
            char[] cArray = new char[16384];
            IntByReference intByReference = new IntByReference();
            boolean bl = Wevtapi.INSTANCE.EvtFormatMessage(eVT_HANDLE, eVT_HANDLE2, 0, 0, null, 1, cArray.length, cArray, intByReference);
            if (!bl) {
                int n = Kernel32.INSTANCE.GetLastError();
                if (n == 122) {
                    System.out.println("[EventLogReader] Insufficient buffer [format event]: " + cArray.length + ", expected: " + intByReference.getValue());
                    cArray = new char[intByReference.getValue()];
                    bl = Wevtapi.INSTANCE.EvtFormatMessage(eVT_HANDLE, eVT_HANDLE2, 0, 0, null, 1, cArray.length, cArray, intByReference);
                    if (!bl) {
                        n = Kernel32.INSTANCE.GetLastError();
                        System.out.println("[EventLogReader] EvtFormatMessage error: " + n);
                        System.out.println("[EventLogReader] formatMessageFromLastErrorCode " + Kernel32Util.formatMessageFromLastErrorCode((int)n));
                        return "";
                    }
                } else {
                    return "";
                }
            }
            return Native.toString((char[])cArray);
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static String getProviderName(Winevt.EVT_HANDLE eVT_HANDLE) {
        Object[] objectArray = EventLogReader.renderEventProperties(eVT_HANDLE, new String[]{XPATH_PROVIDER_NAME}, 512);
        return objectArray[0].toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object[] renderEventProperties(Winevt.EVT_HANDLE eVT_HANDLE, String[] stringArray, int n) {
        Winevt.EVT_HANDLE eVT_HANDLE2 = Wevtapi.INSTANCE.EvtCreateRenderContext(stringArray.length, stringArray, 0);
        if (eVT_HANDLE2 == null) {
            int n2 = Kernel32.INSTANCE.GetLastError();
            System.out.println("[EventLogReader] EvtCreateRenderContext error: " + n2);
            System.out.println("[EventLogReader] formatMessageFromLastErrorCode " + Kernel32Util.formatMessageFromLastErrorCode((int)n2));
            return null;
        }
        Memory memory = new Memory((long)n);
        IntByReference intByReference = new IntByReference();
        IntByReference intByReference2 = new IntByReference();
        try {
            boolean bl = Wevtapi.INSTANCE.EvtRender(eVT_HANDLE2, eVT_HANDLE, 0, (int)memory.size(), (Pointer)memory, intByReference, intByReference2);
            if (!bl) {
                int n3 = Kernel32.INSTANCE.GetLastError();
                if (n3 == 122) {
                    System.out.println("[EventLogReader] Insufficient buffer [event properties]: " + memory.size() + ", expected: " + intByReference.getValue());
                    memory = new Memory((long)intByReference.getValue());
                    bl = Wevtapi.INSTANCE.EvtRender(eVT_HANDLE2, eVT_HANDLE, 0, (int)memory.size(), (Pointer)memory, intByReference, intByReference2);
                    if (!bl) {
                        n3 = Kernel32.INSTANCE.GetLastError();
                        System.out.println("[EventLogReader] EvtRender error: " + n3);
                        System.out.println("[EventLogReader] formatMessageFromLastErrorCode " + Kernel32Util.formatMessageFromLastErrorCode((int)n3));
                        Object[] objectArray = null;
                        return objectArray;
                    }
                } else {
                    n3 = Kernel32.INSTANCE.GetLastError();
                    System.out.println("[EventLogReader] EvtRender error: " + n3);
                    System.out.println("[EventLogReader] formatMessageFromLastErrorCode " + Kernel32Util.formatMessageFromLastErrorCode((int)n3));
                    Object[] objectArray = null;
                    return objectArray;
                }
            }
            Object[] objectArray = EventLogReader.getVariantsFromMemory(memory, intByReference2.getValue());
            return objectArray;
        }
        finally {
            EventLogReader.closeHandle(eVT_HANDLE2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getLastRecordID(String string) {
        Winevt.EVT_HANDLE eVT_HANDLE;
        long l;
        block6: {
            block5: {
                l = -1L;
                eVT_HANDLE = null;
                String string2 = "<QueryList><Query Id=\"0\" Path=\"" + string + "\"><Select Path=\"" + string + "\">*</Select></Query></QueryList>";
                eVT_HANDLE = Wevtapi.INSTANCE.EvtQuery(null, string, string2, 512);
                if (eVT_HANDLE != null) break block5;
                int n = Kernel32.INSTANCE.GetLastError();
                System.out.println("[EventLogReader] EvtSeek error: " + n);
                System.out.println("[EventLogReader] formatMessageFromLastErrorCode " + Kernel32Util.formatMessageFromLastErrorCode((int)n));
                long l2 = l;
                EventLogReader.closeHandle(eVT_HANDLE);
                return l2;
            }
            try {
                int n = 1;
                int n2 = 1000;
                Winevt.EVT_HANDLE[] eVT_HANDLEArray = new Winevt.EVT_HANDLE[n];
                IntByReference intByReference = new IntByReference();
                if (!Wevtapi.INSTANCE.EvtNext(eVT_HANDLE, n, eVT_HANDLEArray, n2, 0, intByReference)) break block6;
                Object[] objectArray = EventLogReader.renderEventProperties(eVT_HANDLEArray[0], new String[]{XPATH_RECORD_ID}, 64);
                l = (Long)objectArray[0];
                EventLogReader.closeHandle(eVT_HANDLEArray[0]);
            }
            catch (Exception exception) {
                try {
                    exception.printStackTrace();
                }
                catch (Throwable throwable) {
                    EventLogReader.closeHandle(eVT_HANDLE);
                    throw throwable;
                }
                EventLogReader.closeHandle(eVT_HANDLE);
            }
        }
        EventLogReader.closeHandle(eVT_HANDLE);
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getLastRecordForEvent(String string, String string2, String string3) {
        String string4;
        Winevt.EVT_HANDLE eVT_HANDLE;
        block7: {
            block6: {
                eVT_HANDLE = null;
                String string5 = "<QueryList><Query Id=\"0\" Path=\"" + string + "\"><Select Path=\"" + string + "\">*[System[(EventID=" + string3 + ")]]</Select></Query></QueryList>";
                string4 = null;
                eVT_HANDLE = Wevtapi.INSTANCE.EvtQuery(null, string, string5, 512);
                if (eVT_HANDLE != null) break block6;
                int n = Kernel32.INSTANCE.GetLastError();
                System.out.println("[EventLogReader] EvtSeek error: " + n);
                System.out.println("[EventLogReader] formatMessageFromLastErrorCode " + Kernel32Util.formatMessageFromLastErrorCode((int)n));
                String string6 = string4;
                EventLogReader.closeHandle(eVT_HANDLE);
                return string6;
            }
            try {
                String string7 = null;
                int n = 1;
                int n2 = 1000;
                Winevt.EVT_HANDLE[] eVT_HANDLEArray = new Winevt.EVT_HANDLE[n];
                IntByReference intByReference = new IntByReference();
                if (!Wevtapi.INSTANCE.EvtNext(eVT_HANDLE, n, eVT_HANDLEArray, n2, 0, intByReference)) break block7;
                string7 = string2.equalsIgnoreCase("xml") ? EventLogReader.renderEventXml(eVT_HANDLEArray[0]) : EventLogReader.formatEventXml(eVT_HANDLEArray[0], 1033);
                if (string7 != null && string7.trim().length() > 0) {
                    string7 = string7.trim();
                    string4 = EventLogReader.parseLine(string7);
                }
                EventLogReader.closeHandle(eVT_HANDLEArray[0]);
            }
            catch (Exception exception) {
                try {
                    exception.printStackTrace();
                }
                catch (Throwable throwable) {
                    EventLogReader.closeHandle(eVT_HANDLE);
                    throw throwable;
                }
                EventLogReader.closeHandle(eVT_HANDLE);
            }
        }
        EventLogReader.closeHandle(eVT_HANDLE);
        return string4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getLastRecord(String string, String string2) {
        String string3;
        Winevt.EVT_HANDLE eVT_HANDLE;
        block6: {
            block5: {
                eVT_HANDLE = null;
                String string4 = "<QueryList><Query Id=\"0\" Path=\"" + string + "\"><Select Path=\"" + string + "\">*</Select></Query></QueryList>";
                string3 = null;
                eVT_HANDLE = Wevtapi.INSTANCE.EvtQuery(null, string, string4, 512);
                if (eVT_HANDLE != null) break block5;
                int n = Kernel32.INSTANCE.GetLastError();
                System.out.println("[EventLogReader] EvtSeek error: " + n);
                System.out.println("[EventLogReader] formatMessageFromLastErrorCode " + Kernel32Util.formatMessageFromLastErrorCode((int)n));
                String string5 = string3;
                EventLogReader.closeHandle(eVT_HANDLE);
                return string5;
            }
            try {
                int n = 1;
                int n2 = 1000;
                Winevt.EVT_HANDLE[] eVT_HANDLEArray = new Winevt.EVT_HANDLE[n];
                IntByReference intByReference = new IntByReference();
                if (!Wevtapi.INSTANCE.EvtNext(eVT_HANDLE, n, eVT_HANDLEArray, n2, 0, intByReference)) break block6;
                string3 = string2.equalsIgnoreCase("xml") ? EventLogReader.renderEventXml(eVT_HANDLEArray[0]) : EventLogReader.formatEventXml(eVT_HANDLEArray[0], 1033);
                EventLogReader.closeHandle(eVT_HANDLEArray[0]);
            }
            catch (Exception exception) {
                try {
                    exception.printStackTrace();
                }
                catch (Throwable throwable) {
                    EventLogReader.closeHandle(eVT_HANDLE);
                    throw throwable;
                }
                EventLogReader.closeHandle(eVT_HANDLE);
            }
        }
        EventLogReader.closeHandle(eVT_HANDLE);
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList getLatestRecordsBasedOnMinutesAndLevel(String string, long l, String string2, String string3) {
        Winevt.EVT_HANDLE eVT_HANDLE;
        ArrayList<String> arrayList;
        block8: {
            long l2 = l * 60L * 1000L;
            arrayList = null;
            eVT_HANDLE = null;
            String string4 = "";
            string4 = string.equals(SUCCESS_EVENT) || string.equals(FAILURE_EVENT) ? "<QueryList><Query Id=\"0\" Path=\"" + string2 + "\"><Select Path=\"" + string2 + "\">*[System[Keywords=\"" + string + "\" and TimeCreated[timediff(@SystemTime) &lt;= " + l2 + "]]]</Select></Query></QueryList>" : "<QueryList><Query Id=\"0\" Path=\"" + string2 + "\"><Select Path=\"" + string2 + "\">*[System[Level=" + string + " and TimeCreated[timediff(@SystemTime) &lt;= " + l2 + "]]]</Select></Query></QueryList>";
            eVT_HANDLE = Wevtapi.INSTANCE.EvtQuery(null, string2, string4, 2);
            if (eVT_HANDLE != null) break block8;
            int n = Kernel32.INSTANCE.GetLastError();
            System.out.println("[EventLogReader] EvtQuery error: " + n);
            System.out.println("[EventLogReader] formatMessageFromLastErrorCode " + Kernel32Util.formatMessageFromLastErrorCode((int)n));
            ArrayList<String> arrayList2 = arrayList;
            EventLogReader.closeHandle(eVT_HANDLE);
            return arrayList2;
        }
        try {
            arrayList = new ArrayList<String>();
            int n = 10;
            int n2 = 1000;
            Winevt.EVT_HANDLE[] eVT_HANDLEArray = new Winevt.EVT_HANDLE[n];
            IntByReference intByReference = new IntByReference();
            String string5 = "";
            while (Wevtapi.INSTANCE.EvtNext(eVT_HANDLE, n, eVT_HANDLEArray, n2, 0, intByReference)) {
                for (int i = 0; i < intByReference.getValue(); ++i) {
                    Winevt.EVT_HANDLE eVT_HANDLE2 = eVT_HANDLEArray[i];
                    string5 = string3.equalsIgnoreCase("xml") ? EventLogReader.renderEventXml(eVT_HANDLE2) : EventLogReader.formatEventXml(eVT_HANDLE2, 1033);
                    if (string5 != null) {
                        arrayList.add(string5);
                    }
                    EventLogReader.closeHandle(eVT_HANDLE2);
                }
            }
        }
        catch (Exception exception) {
            try {
                exception.printStackTrace();
            }
            catch (Throwable throwable) {
                EventLogReader.closeHandle(eVT_HANDLE);
                throw throwable;
            }
            EventLogReader.closeHandle(eVT_HANDLE);
        }
        EventLogReader.closeHandle(eVT_HANDLE);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList getLatestRecordsBasedOnQuery(String string, String string2, String string3) {
        Winevt.EVT_HANDLE eVT_HANDLE;
        ArrayList<String> arrayList;
        block10: {
            arrayList = null;
            eVT_HANDLE = null;
            eVT_HANDLE = Wevtapi.INSTANCE.EvtQuery(null, string2, string, 2);
            if (eVT_HANDLE != null) break block10;
            int n = Kernel32.INSTANCE.GetLastError();
            System.out.println("[EventLogReader] EvtQuery error: " + n);
            System.out.println("[EventLogReader] formatMessageFromLastErrorCode " + Kernel32Util.formatMessageFromLastErrorCode((int)n));
            ArrayList<String> arrayList2 = arrayList;
            EventLogReader.closeHandle(eVT_HANDLE);
            return arrayList2;
        }
        try {
            arrayList = new ArrayList<String>();
            int n = 10;
            int n2 = 1000;
            Winevt.EVT_HANDLE[] eVT_HANDLEArray = new Winevt.EVT_HANDLE[n];
            IntByReference intByReference = new IntByReference();
            String string4 = "";
            int n3 = 0;
            Winevt.EVT_HANDLE eVT_HANDLE2 = null;
            while (Wevtapi.INSTANCE.EvtNext(eVT_HANDLE, n, eVT_HANDLEArray, n2, 0, intByReference)) {
                int n4 = intByReference.getValue();
                for (int i = 0; i < n4; ++i) {
                    ++n3;
                    eVT_HANDLE2 = eVT_HANDLEArray[i];
                    string4 = string3.equalsIgnoreCase("xml") ? EventLogReader.renderEventXml(eVT_HANDLE2) : (string3.equalsIgnoreCase("GroupPolicyCommand") ? EventLogReader.formatEventXmlGPPolicy(eVT_HANDLE2, 1033) : EventLogReader.formatEventXml(eVT_HANDLE2, 1033));
                    if (string4 != null) {
                        if (string3.equalsIgnoreCase("GroupPolicyCommand")) {
                            arrayList.add(string4);
                        } else {
                            arrayList.add(EventLogReader.parseLine(string4));
                        }
                    }
                    EventLogReader.closeHandle(eVT_HANDLE2);
                }
            }
        }
        catch (Exception exception) {
            try {
                exception.printStackTrace();
            }
            catch (Throwable throwable) {
                EventLogReader.closeHandle(eVT_HANDLE);
                throw throwable;
            }
            EventLogReader.closeHandle(eVT_HANDLE);
        }
        EventLogReader.closeHandle(eVT_HANDLE);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatEventXmlGPPolicy(Winevt.EVT_HANDLE eVT_HANDLE, int n) {
        String string = EventLogReader.getProviderName(eVT_HANDLE);
        Winevt.EVT_HANDLE eVT_HANDLE2 = Wevtapi.INSTANCE.EvtOpenPublisherMetadata(null, string, null, n, 0);
        if (eVT_HANDLE2 == null) {
            int n2 = Kernel32.INSTANCE.GetLastError();
            System.out.println("[EventLogReader] EvtOpenPublisherMetadata error: " + n2);
            System.out.println("[EventLogReader] formatMessageFromLastErrorCode " + Kernel32Util.formatMessageFromLastErrorCode((int)n2));
            return null;
        }
        try {
            char[] cArray = new char[16384];
            IntByReference intByReference = new IntByReference();
            boolean bl = Wevtapi.INSTANCE.EvtFormatMessage(eVT_HANDLE2, eVT_HANDLE, 0, 0, null, 9, cArray.length, cArray, intByReference);
            if (!bl) {
                int n3 = Kernel32.INSTANCE.GetLastError();
                if (n3 == 122) {
                    System.out.println("[EventLogReader] Insufficient buffer [format event]: " + cArray.length + ", expected: " + intByReference.getValue());
                    cArray = new char[intByReference.getValue()];
                    bl = Wevtapi.INSTANCE.EvtFormatMessage(eVT_HANDLE2, eVT_HANDLE, 0, 0, null, 9, cArray.length, cArray, intByReference);
                    if (!bl) {
                        n3 = Kernel32.INSTANCE.GetLastError();
                        System.out.println("[EventLogReader] EvtFormatMessage error: " + n3);
                        System.out.println("[EventLogReader] formatMessageFromLastErrorCode " + Kernel32Util.formatMessageFromLastErrorCode((int)n3));
                        String string2 = null;
                        return string2;
                    }
                } else {
                    if (n3 == 317 || n3 >= 12000 && n3 < 16000) {
                        Object object;
                        Object object2;
                        String[] stringArray = new String[]{XPATH_PROVIDER_NAME, XPATH_RECORD_ID, XPATH_RECORD_DATETIME, "Event/System/Level", "Event/System/Task", "Event/System/Computer", "Event/System/Security/@UserID", "Event/System/EventID", "Event/EventData/Data"};
                        Object[] objectArray = EventLogReader.renderEventProperties(eVT_HANDLE, stringArray, 1024);
                        System.out.println("[EventLogReader] formatEventXml ERROR values " + Arrays.asList(objectArray));
                        String string3 = "<Security/>";
                        String string4 = "";
                        String string5 = "";
                        String string6 = "";
                        String string7 = "";
                        String string8 = "";
                        String string9 = "";
                        String string10 = "";
                        String string11 = "";
                        if (objectArray[0] != null) {
                            string4 = objectArray[0].toString();
                        }
                        if (objectArray[1] != null) {
                            string5 = objectArray[1].toString();
                        }
                        if (objectArray[2] != null) {
                            object2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
                            ((DateFormat)object2).setTimeZone(TimeZone.getTimeZone("UTC"));
                            object = ((WinBase.FILETIME)objectArray[2]).toDate();
                            string6 = ((DateFormat)object2).format((Date)object).toString();
                        }
                        if (objectArray[3] != null) {
                            string7 = objectArray[3].toString();
                        }
                        if (objectArray[4] != null) {
                            string8 = objectArray[4].toString();
                        }
                        if (objectArray[5] != null) {
                            string9 = objectArray[5].toString();
                        }
                        if (objectArray[6] != null) {
                            string10 = objectArray[6].toString();
                            if (string10.trim().length() > 0) {
                                string10 = "<Security UserID='" + string10 + "'/>";
                            }
                        } else {
                            string10 = string3;
                        }
                        string11 = objectArray[7] != null ? objectArray[7].toString() : "0";
                        object2 = EventLogReader.getMessage(eVT_HANDLE2, eVT_HANDLE);
                        object = "<Event xmlns='http://schemas.microsoft.com/win/2004/08/events/event'><System><Provider Name='" + string4 + "'/><EventID Qualifiers='0'>" + string11 + "</EventID><Version>0</Version><Level>" + string7 + "</Level><Task>" + string8 + "</Task><Opcode>0</Opcode><Keywords>0x80000000000000</Keywords><TimeCreated SystemTime='" + string6 + "'/><EventRecordID>" + string5 + "</EventRecordID><Correlation/><Execution ProcessID='0' ThreadID='0'/><Channel>Application</Channel><Computer>" + string9 + "</Computer>" + string10 + "</System><EventData><Data>" + (String)object2 + "</Data></EventData></Event>";
                        System.out.println("[EventLogReader] formatEventXml eventStr " + (String)object);
                        Object object3 = object;
                        return object3;
                    }
                    n3 = Kernel32.INSTANCE.GetLastError();
                    System.out.println("[EventLogReader] EvtFormatMessage error: " + n3);
                    System.out.println("[EventLogReader] formatMessageFromLastErrorCode " + Kernel32Util.formatMessageFromLastErrorCode((int)n3));
                    String string12 = null;
                    return string12;
                }
            }
            String string13 = Native.toString((char[])cArray);
            return string13;
        }
        finally {
            EventLogReader.closeHandle(eVT_HANDLE2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String parseLine(String string) {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = null;
        InputSource inputSource = null;
        Document document = null;
        NodeList nodeList = null;
        NodeList nodeList2 = null;
        NodeList nodeList3 = null;
        Object var8_8 = null;
        Element element = null;
        String string2 = "";
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
            if (string == null || string.trim().length() == 0) {
                String string3 = string2;
                return string3;
            }
            inputSource = new InputSource(new StringReader(string.trim()));
            document = documentBuilder.parse(inputSource);
            if (document == null) {
                String string4 = string2;
                return string4;
            }
            nodeList = document.getElementsByTagName("Event");
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                element = (Element)nodeList.item(i);
                if (element == null) continue;
                nodeList2 = element.getElementsByTagName("System");
                nodeList3 = element.getElementsByTagName("EventData");
                String string5 = EventLogReader.getElementValue(nodeList2, "EventRecordID");
                String string6 = EventLogReader.getElementValue(nodeList2, "Level");
                String string7 = EventLogReader.getAttributeValue(nodeList2, "TimeCreated", "SystemTime");
                String string8 = EventLogReader.getAttributeValue(nodeList2, "Provider", "Name");
                String string9 = EventLogReader.getElementValue(nodeList2, "Task");
                String string10 = EventLogReader.getElementValue(nodeList2, "EventID");
                String string11 = "";
                String string12 = EventLogReader.getAttributeValue(nodeList2, "Security", "UserID");
                String string13 = EventLogReader.getElementValue(nodeList2, "Computer");
                String string14 = EventLogReader.getElementValue(nodeList2, "keywords");
                String string15 = EventLogReader.getElementValue(nodeList2, "Channel");
                String string16 = EventLogReader.getElementValue(nodeList3, "Data");
                if (string8 == null || string8.trim().length() == 0 || string8.trim().equals("-")) {
                    string8 = EventLogReader.getAttributeValue(nodeList2, "Provider", "Name");
                }
                if (string6 == null || string6.trim().length() == 0 || string6.trim().equals("-")) {
                    string6 = EventLogReader.getElementValue(nodeList2, "Level");
                    string6 = EventLogReader.getLevelName(string6);
                }
                long l = Long.parseLong(string5);
                if (string8.indexOf("Microsoft-Windows-") >= 0) {
                    int n2 = string8.indexOf("Microsoft-Windows-");
                    string8 = string8.substring((n2 += "Microsoft-Windows-".length() - 1) + 1, string8.length());
                }
                if (string9.equalsIgnoreCase("0")) {
                    string9 = "0";
                }
                if (string11 == null || string11.trim().length() == 0 || string11.equalsIgnoreCase("-")) {
                    string11 = string16;
                    if (string11 == null || string11.trim().length() == 0 || string11.equalsIgnoreCase("-")) {
                        string11 = "N/A";
                    } else {
                        string11 = EventLogReader.getMessage(string11);
                        System.out.println("[EventLogReader] after message change to string ==> " + string11);
                    }
                } else {
                    string11 = EventLogReader.getMessage(string11);
                }
                string12 = string12 == null || string12.length() == 0 || string12.equalsIgnoreCase("-") ? "N/A" : EventLogReader.getUserName(string12);
                if (string13 == null || string13.length() == 0) {
                    string13 = "N/A";
                }
                if (string12.length() > 127) {
                    string12 = string12.substring(0, 127);
                }
                if (string13.length() > 127) {
                    string13 = string13.substring(0, 127);
                }
                if (string11.length() > 2000) {
                    string11 = string11.substring(0, 1999);
                }
                if (string8.length() > 256) {
                    string8 = string8.substring(0, 255);
                }
                if (string9.length() > 32) {
                    string9 = string9.substring(0, 31);
                }
                if (string11 == null || string11.length() == 0) {
                    string11 = "N/A";
                }
                if (string15.toLowerCase().indexOf("security") >= 0) {
                    string14 = string14.equalsIgnoreCase("8010000000000000") ? "Audit Failure" : "Audit Success";
                    if (string6.equals("0")) {
                        string6 = INFORAMTION_LEVEL;
                    }
                }
                if (string6.equals(CRITICAL_LEVEL)) {
                    string6 = "Critical";
                } else if (string6.equals(ERROR_LEVEL)) {
                    string6 = "Error";
                } else if (string6.equals(WARNING_LEVEL)) {
                    string6 = "Warning";
                } else if (string6.equals(INFORAMTION_LEVEL)) {
                    string6 = "Information";
                } else if (string6.equals("5")) {
                    string6 = "Verbose";
                }
                string10 = string10.trim();
                string2 = string5 + seperator + string6 + seperator + string7 + seperator + string8 + seperator + string9 + seperator + string10 + seperator + string11 + seperator + string12 + seperator + string13 + seperator + string14;
                if (!string15.equalsIgnoreCase("Microsoft-Windows-AppLocker/EXE and DLL") && !string15.equalsIgnoreCase("Microsoft-Windows-AppLocker/MSI and Script")) continue;
                String string17 = EventLogReader.getEventFileHash(element);
                string2 = string2 + seperator + string17;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            inputSource = null;
            document = null;
            documentBuilder = null;
        }
        return string2;
    }

    protected static String getAttributeValue(NodeList nodeList, String string, String string2) {
        String string3 = "-";
        try {
            int n = nodeList.getLength();
            block2: for (int i = 0; i < n; ++i) {
                Node node = nodeList.item(i);
                if (node == null) continue;
                NodeList nodeList2 = node.getChildNodes();
                int n2 = nodeList2.getLength();
                for (int j = 0; j < n2; ++j) {
                    Node node2;
                    NamedNodeMap namedNodeMap;
                    Node node3 = nodeList2.item(j);
                    String string4 = node3.getNodeName();
                    if (string4 == null || !string4.equalsIgnoreCase(string) || (namedNodeMap = node3.getAttributes()) == null || (node2 = namedNodeMap.getNamedItem(string2)) == null) continue;
                    String string5 = node2.getNodeValue();
                    if (string5 == null || string5.trim().length() <= 0) continue block2;
                    string3 = string5.trim();
                    continue block2;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String getElementValue(NodeList nodeList, String string) {
        String string2 = "-";
        Node node = null;
        NodeList nodeList2 = null;
        Node node2 = null;
        try {
            int n = nodeList.getLength();
            block5: for (int i = 0; i < n; ++i) {
                node = nodeList.item(i);
                if (node == null) continue;
                nodeList2 = node.getChildNodes();
                int n2 = nodeList2.getLength();
                for (int j = 0; j < n2; ++j) {
                    String string3;
                    node2 = nodeList2.item(j);
                    String string4 = node2.getNodeName();
                    if (string4 == null || !string4.equalsIgnoreCase(string) || (string3 = node2.getTextContent()) == null || string3.trim().length() == 0) continue;
                    string2 = string3.trim();
                    continue block5;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            node = null;
            nodeList2 = null;
            node2 = null;
        }
        return string2;
    }

    private static String getUserName(String string) {
        String string2 = "N/A";
        try {
            if (string == null || string.trim().length() == 0 || string.equalsIgnoreCase("N/A") || string.equalsIgnoreCase("-")) {
                return string2;
            }
            String string3 = Advapi32Util.getAccountBySid((String)string).name;
            if (string3 != null && string3.trim().length() > 0) {
                string2 = string3;
            }
        }
        catch (Exception exception) {
            System.out.println("[EventFilterBase] getUserName() sidStr = " + string);
            string2 = "N/A";
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList getLatestRecordsBasedOnMinutes(long l, String string, String string2) {
        Winevt.EVT_HANDLE eVT_HANDLE;
        ArrayList<String> arrayList;
        block8: {
            long l2 = l * 60L * 1000L;
            arrayList = null;
            eVT_HANDLE = null;
            String string3 = "<QueryList><Query Id=\"0\" Path=\"" + string + "\"><Select Path=\"" + string + "\">*[System[TimeCreated[timediff(@SystemTime) &lt;= " + l2 + "]]]</Select></Query></QueryList>";
            eVT_HANDLE = Wevtapi.INSTANCE.EvtQuery(null, string, string3, 2);
            if (eVT_HANDLE != null) break block8;
            int n = Kernel32.INSTANCE.GetLastError();
            System.out.println("[EventLogReader] EvtQuery error: " + n);
            System.out.println("[EventLogReader] formatMessageFromLastErrorCode " + Kernel32Util.formatMessageFromLastErrorCode((int)n));
            ArrayList<String> arrayList2 = arrayList;
            EventLogReader.closeHandle(eVT_HANDLE);
            return arrayList2;
        }
        try {
            arrayList = new ArrayList<String>();
            int n = 10;
            int n2 = 1000;
            Winevt.EVT_HANDLE[] eVT_HANDLEArray = new Winevt.EVT_HANDLE[n];
            IntByReference intByReference = new IntByReference();
            String string4 = "";
            while (Wevtapi.INSTANCE.EvtNext(eVT_HANDLE, n, eVT_HANDLEArray, n2, 0, intByReference)) {
                for (int i = 0; i < intByReference.getValue(); ++i) {
                    Winevt.EVT_HANDLE eVT_HANDLE2 = eVT_HANDLEArray[i];
                    string4 = string2.equalsIgnoreCase("xml") ? EventLogReader.renderEventXml(eVT_HANDLE2) : EventLogReader.formatEventXml(eVT_HANDLE2, 1033);
                    if (string4 != null) {
                        arrayList.add(string4);
                    }
                    EventLogReader.closeHandle(eVT_HANDLE2);
                }
            }
        }
        catch (Exception exception) {
            try {
                exception.printStackTrace();
            }
            catch (Throwable throwable) {
                EventLogReader.closeHandle(eVT_HANDLE);
                throw throwable;
            }
            EventLogReader.closeHandle(eVT_HANDLE);
        }
        EventLogReader.closeHandle(eVT_HANDLE);
        return arrayList;
    }

    public static String createBookmarkBasedOnEventRecordID(String string, long l) {
        String string2 = "<BookmarkList><Bookmark Channel=\"%s\" RecordId=\"%d\" IsCurrent=\"True\"/></BookmarkList>";
        String string3 = String.format(string2, string, l);
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList getRecordsBasedOnRecordID(long l, String string, String string2) {
        Winevt.EVT_HANDLE eVT_HANDLE;
        Winevt.EVT_HANDLE eVT_HANDLE2;
        ArrayList<String> arrayList;
        block12: {
            block11: {
                String string3;
                block10: {
                    arrayList = null;
                    eVT_HANDLE2 = null;
                    eVT_HANDLE = null;
                    String string4 = "<QueryList><Query Id=\"0\" Path=\"" + string + "\"><Select Path=\"" + string + "\">*</Select></Query></QueryList>";
                    string3 = EventLogReader.createBookmarkBasedOnEventRecordID(string, l);
                    eVT_HANDLE2 = Wevtapi.INSTANCE.EvtQuery(null, string, string4, 2);
                    if (eVT_HANDLE2 != null) break block10;
                    int n = Kernel32.INSTANCE.GetLastError();
                    System.out.println("[EventLogReader] EvtQuery error: " + n);
                    System.out.println("[EventLogReader] formatMessageFromLastErrorCode " + Kernel32Util.formatMessageFromLastErrorCode((int)n));
                    ArrayList<String> arrayList2 = arrayList;
                    EventLogReader.closeHandle(eVT_HANDLE2);
                    EventLogReader.closeHandle(eVT_HANDLE);
                    return arrayList2;
                }
                eVT_HANDLE = Wevtapi.INSTANCE.EvtCreateBookmark(string3);
                if (eVT_HANDLE != null) break block11;
                int n = Kernel32.INSTANCE.GetLastError();
                System.out.println("[EventLogReader] EvtCreateBookmark error: " + n);
                System.out.println("[EventLogReader] formatMessageFromLastErrorCode " + Kernel32Util.formatMessageFromLastErrorCode((int)n));
                ArrayList<String> arrayList3 = arrayList;
                EventLogReader.closeHandle(eVT_HANDLE2);
                EventLogReader.closeHandle(eVT_HANDLE);
                return arrayList3;
            }
            if (Wevtapi.INSTANCE.EvtSeek(eVT_HANDLE2, 0L, eVT_HANDLE, 0, 4)) break block12;
            int n = Kernel32.INSTANCE.GetLastError();
            System.out.println("[EventLogReader] EvtSeek error: " + n);
            System.out.println("[EventLogReader] formatMessageFromLastErrorCode " + Kernel32Util.formatMessageFromLastErrorCode((int)n));
            ArrayList<String> arrayList4 = arrayList;
            EventLogReader.closeHandle(eVT_HANDLE2);
            EventLogReader.closeHandle(eVT_HANDLE);
            return arrayList4;
        }
        try {
            arrayList = new ArrayList<String>();
            int n = 10;
            int n2 = 1000;
            Winevt.EVT_HANDLE[] eVT_HANDLEArray = new Winevt.EVT_HANDLE[n];
            IntByReference intByReference = new IntByReference();
            String string5 = "";
            while (Wevtapi.INSTANCE.EvtNext(eVT_HANDLE2, n, eVT_HANDLEArray, n2, 0, intByReference)) {
                for (int i = 0; i < intByReference.getValue(); ++i) {
                    Winevt.EVT_HANDLE eVT_HANDLE3 = eVT_HANDLEArray[i];
                    string5 = string2.equalsIgnoreCase("xml") ? EventLogReader.renderEventXml(eVT_HANDLE3) : EventLogReader.formatEventXml(eVT_HANDLE3, 1033);
                    if (string5 != null) {
                        arrayList.add(string5);
                    }
                    EventLogReader.closeHandle(eVT_HANDLE3);
                }
            }
        }
        catch (Exception exception) {
            try {
                exception.printStackTrace();
            }
            catch (Throwable throwable) {
                EventLogReader.closeHandle(eVT_HANDLE2);
                EventLogReader.closeHandle(eVT_HANDLE);
                throw throwable;
            }
            EventLogReader.closeHandle(eVT_HANDLE2);
            EventLogReader.closeHandle(eVT_HANDLE);
        }
        EventLogReader.closeHandle(eVT_HANDLE2);
        EventLogReader.closeHandle(eVT_HANDLE);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getLastRecordTimeInUTCFomat(String string) {
        Winevt.EVT_HANDLE eVT_HANDLE;
        String string2;
        block6: {
            SimpleDateFormat simpleDateFormat;
            block5: {
                string2 = null;
                simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
                simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
                eVT_HANDLE = null;
                String string3 = "<QueryList><Query Id=\"0\" Path=\"" + string + "\"><Select Path=\"" + string + "\">*</Select></Query></QueryList>";
                Object var5_5 = null;
                eVT_HANDLE = Wevtapi.INSTANCE.EvtQuery(null, string, string3, 512);
                if (eVT_HANDLE != null) break block5;
                int n = Kernel32.INSTANCE.GetLastError();
                System.out.println("[EventLogReader] EvtSeek error: " + n);
                System.out.println("[EventLogReader] formatMessageFromLastErrorCode " + Kernel32Util.formatMessageFromLastErrorCode((int)n));
                String string4 = string2;
                EventLogReader.closeHandle(eVT_HANDLE);
                return string4;
            }
            try {
                int n = 1;
                int n2 = 1000;
                Winevt.EVT_HANDLE[] eVT_HANDLEArray = new Winevt.EVT_HANDLE[n];
                IntByReference intByReference = new IntByReference();
                if (!Wevtapi.INSTANCE.EvtNext(eVT_HANDLE, n, eVT_HANDLEArray, n2, 0, intByReference)) break block6;
                Object[] objectArray = EventLogReader.renderEventProperties(eVT_HANDLEArray[0], new String[]{XPATH_RECORD_DATETIME}, 512);
                Date date = ((WinBase.FILETIME)objectArray[0]).toDate();
                System.out.println("[EventLogReader] System date : " + date.toString());
                string2 = simpleDateFormat.format(date).toString();
                System.out.println("[EventLogReader] UTC format: " + string2);
                EventLogReader.closeHandle(eVT_HANDLEArray[0]);
            }
            catch (Exception exception) {
                try {
                    exception.printStackTrace();
                }
                catch (Throwable throwable) {
                    EventLogReader.closeHandle(eVT_HANDLE);
                    throw throwable;
                }
                EventLogReader.closeHandle(eVT_HANDLE);
            }
        }
        EventLogReader.closeHandle(eVT_HANDLE);
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getLastRecordTimeInUTCFomatEvntID(String string, String string2) {
        Winevt.EVT_HANDLE eVT_HANDLE;
        String string3;
        block6: {
            SimpleDateFormat simpleDateFormat;
            block5: {
                string3 = null;
                simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
                simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
                eVT_HANDLE = null;
                String string4 = "<QueryList><Query Id=\"0\" Path=\"" + string + "\"><Select Path=\"" + string + "\">*[System[(EventID=" + string2 + ")]]</Select></Query></QueryList>";
                Object var6_6 = null;
                eVT_HANDLE = Wevtapi.INSTANCE.EvtQuery(null, string, string4, 512);
                if (eVT_HANDLE != null) break block5;
                int n = Kernel32.INSTANCE.GetLastError();
                System.out.println("[EventLogReader] EvtSeek error: " + n);
                System.out.println("[EventLogReader] formatMessageFromLastErrorCode " + Kernel32Util.formatMessageFromLastErrorCode((int)n));
                String string5 = string3;
                EventLogReader.closeHandle(eVT_HANDLE);
                return string5;
            }
            try {
                int n = 1;
                int n2 = 1000;
                Winevt.EVT_HANDLE[] eVT_HANDLEArray = new Winevt.EVT_HANDLE[n];
                IntByReference intByReference = new IntByReference();
                if (!Wevtapi.INSTANCE.EvtNext(eVT_HANDLE, n, eVT_HANDLEArray, n2, 0, intByReference)) break block6;
                Object[] objectArray = EventLogReader.renderEventProperties(eVT_HANDLEArray[0], new String[]{XPATH_RECORD_DATETIME}, 512);
                Date date = ((WinBase.FILETIME)objectArray[0]).toDate();
                System.out.println("[EventLogReader] System date : " + date.toString());
                string3 = simpleDateFormat.format(date).toString();
                System.out.println("[EventLogReader] UTC format: " + string3);
                EventLogReader.closeHandle(eVT_HANDLEArray[0]);
            }
            catch (Exception exception) {
                try {
                    exception.printStackTrace();
                }
                catch (Throwable throwable) {
                    EventLogReader.closeHandle(eVT_HANDLE);
                    throw throwable;
                }
                EventLogReader.closeHandle(eVT_HANDLE);
            }
        }
        EventLogReader.closeHandle(eVT_HANDLE);
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        String string = "Application";
        try {
            System.out.println(EventLogReader.getLastRecord(string, "text"));
            ArrayList arrayList = EventLogReader.getRecordsBasedOnRecordID(7103776L, string, "xml");
            int n = arrayList.size();
            System.out.println("[SystemEventTest] text size " + n);
            for (int i = 0; i < n; ++i) {
                String string2 = (String)arrayList.get(i);
                System.out.println(i + " : " + string2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static String getTime() {
        String string = null;
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MM  HH:mm:ss.SSS");
            Calendar calendar = Calendar.getInstance();
            string = simpleDateFormat.format(calendar.getTime());
        }
        catch (Exception exception) {
            string = null;
        }
        return string;
    }

    private static String getLevelName(String string) {
        String string2 = "-";
        if (string == null || string.trim().length() == 0 || string.trim().equalsIgnoreCase("null")) {
            return string2;
        }
        try {
            string = string.trim();
            string2 = string.equals(INFORAMTION_LEVEL) || string.equals("0") ? "Information" : (string.equals(ERROR_LEVEL) ? "Error" : (string.equals(CRITICAL_LEVEL) ? "Critical" : (string.equals(WARNING_LEVEL) ? "Warning" : (string.equals("5") ? "Verbose" : string))));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string2;
    }

    private static String getMessage(String string) {
        String string2 = "N/A";
        try {
            StringBuffer stringBuffer = new StringBuffer();
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                if (string3 == null || string3.trim().length() == 0) continue;
                string3 = string3.trim();
                String string4 = "";
                boolean bl = false;
                StringTokenizer stringTokenizer2 = new StringTokenizer(string3, "\t");
                while (stringTokenizer2.hasMoreTokens()) {
                    bl = true;
                    String string5 = stringTokenizer2.nextToken();
                    if (string5 == null || string5.trim().length() == 0) continue;
                    if (string4.length() == 0) {
                        string4 = string5.trim();
                        continue;
                    }
                    string4 = string4 + " " + string5.trim();
                }
                if (bl) {
                    string3 = string4 = string4.trim();
                }
                stringBuffer.append(" " + string3.trim());
            }
            string2 = stringBuffer.toString();
            string2 = string2.trim();
            return string2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return string;
        }
    }

    private static String getEventFileHash(Element element) {
        String string = "-";
        try {
            NodeList nodeList = null;
            NodeList nodeList2 = element.getElementsByTagName("UserData");
            if (nodeList2 != null) {
                nodeList = element.getElementsByTagName("RuleAndFileData");
            }
            if (nodeList != null) {
                string = EventLogReader.getElementValue(nodeList, "FileHash");
            }
            return string;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return string;
        }
    }
}

