/*
 * Decompiled with CFR 0.152.
 */
package com.egurkha.util;

import com.eg.EgInstallInfo;
import com.eg.EgLangInfo;
import com.eg.EgMgrAppPid;
import com.eg.EgTesterInfo;
import com.eg.IniFile;
import com.egurkha.util.EgCheckConnUtil;
import com.egurkha.util.EgObjectReaderThread;
import com.egurkha.util.EgStreamReaderThread;
import com.egurkha.util.IniFile2;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;

public class EgUtilities {
    private static Hashtable cmdEncodings = new Hashtable();
    private boolean b_sopDebug = false;
    private boolean b_loggerDebug = false;
    PrintWriter logWriter;
    private static String s_entity = "EgUtilities";
    String s_logFileName;
    private static String s_os = System.getProperty("os.name");
    private static boolean isLinux = s_os.equalsIgnoreCase("LINUX");
    private static boolean isSolaris = s_os.equalsIgnoreCase("SUNOS");
    private static boolean isWindows = s_os.equalsIgnoreCase("WINDOWS") || s_os.toLowerCase().indexOf("win") >= 0;
    private static boolean isHpux = s_os.equalsIgnoreCase("HP-UX") || s_os.equalsIgnoreCase("HPUX") || s_os.startsWith("HP");
    private static boolean isAix = s_os.equalsIgnoreCase("AIX");
    private static boolean isOsf1 = s_os.equalsIgnoreCase("OSF1");
    private static String O365syncString = new String("O365SyncString");
    private static long inProgressO365Count = 0L;
    private static long maxO365Concurrent = 25L;
    static String path = EgInstallInfo.getInstallDir() + "\\agent\\config\\O365Config.ini";
    private static long lastmodifiedtime = 0L;
    private long time_diff = 0L;
    private long prev_time = 0L;
    private int time_flag = 0;
    private long timeout = 60000L;
    private Process p = null;
    private static boolean java15Version = System.getProperty("java.version").compareTo("1.5") > 0;
    private static String userLanguage = System.getProperty("user.language");
    private static String defaultEncoding = System.getProperty("file.encoding");
    public static boolean useUTF8 = false;
    public boolean hitDebug = false;
    public static String encoding = null;
    public static boolean useEncoding = false;
    private static String osLanguage = null;
    public static boolean isPSSignedScriptEnabled = false;
    private static boolean isShellSet = false;
    private static String shellName = "/usr/bin/sh";
    private static String cmdPath = "cmd.exe ";
    private static String cmdPathWithArgs = "cmd.exe /c ";

    private EgUtilities() {
        String string;
        if (osLanguage == null) {
            osLanguage = this.getOSLanguage();
            if (osLanguage.equalsIgnoreCase("ENU")) {
                osLanguage = this.getUserLanguage();
            }
            this.getEncoding();
        }
        if (isWindows && (string = System.getenv("windir")) != null && string.trim().length() > 0) {
            cmdPath = string + "\\System32\\cmd.exe";
            cmdPathWithArgs = cmdPath + " /c ";
        }
    }

    private void getEncoding() {
        if (osLanguage != null && !osLanguage.equals("ENU")) {
            String[] stringArray;
            File file = new File(EgInstallInfo.getInstallDir() + "/lib/eg_encode.ini");
            boolean bl = file.exists();
            if (!bl) {
                return;
            }
            IniFile iniFile = new IniFile(EgInstallInfo.getInstallDir() + "/lib/eg_encode.ini", false);
            String string = iniFile.getValue("ENCODING_FORMAT", osLanguage);
            if (string != null && string.length() > 0) {
                encoding = string = string.trim();
            }
            if ((stringArray = iniFile.getVariables(osLanguage)) != null && stringArray.length > 0) {
                for (int i = 0; i < stringArray.length; ++i) {
                    String string2 = iniFile.getValue(osLanguage, stringArray[i]);
                    cmdEncodings.put(stringArray[i], string2);
                }
            }
        }
    }

    public String getUserLanguage() {
        String string = System.getProperty("user.language");
        if (string.equalsIgnoreCase("en")) {
            String string2 = EgInstallInfo.getInstallDir() + "/lib/eg_lang_info.ini";
            try {
                File file = new File(string2);
                if (file.exists()) {
                    IniFile2 iniFile2 = new IniFile2(string2);
                    string = iniFile2.getValue("OS_INFO", "UI Language code");
                    if (string != null && string.length() > 0) {
                        return string;
                    }
                    string = System.getProperty("user.language");
                }
            }
            catch (Exception exception) {
                string = System.getProperty("user.language");
                return string;
            }
        }
        return string;
    }

    private EgUtilities(boolean bl) {
        String string;
        EgUtilities.getOSName();
        if (osLanguage == null) {
            osLanguage = this.getOSLanguage();
            this.getEncoding();
        }
        if (isWindows && (string = System.getenv("windir")) != null && string.trim().length() > 0) {
            cmdPath = string + "\\System32\\cmd.exe";
            cmdPathWithArgs = cmdPath + " /c ";
        }
    }

    public static EgUtilities createInstance() {
        return new EgUtilities();
    }

    public static EgUtilities createInstance(boolean bl) {
        return new EgUtilities(bl);
    }

    public void setTimeout(long l) {
        this.timeout = l;
    }

    public void setDebug(boolean bl) {
        this.b_sopDebug = bl;
    }

    public void setLogger(boolean bl) {
        this.b_loggerDebug = bl;
    }

    public void sop(String string) {
        if (this.b_sopDebug) {
            System.out.println(string);
        }
    }

    private void fsop(String string) {
        System.out.println(string);
    }

    public static String getOSName() {
        return s_os;
    }

    public String getOSLanguage() {
        Object object;
        Object object2;
        Object object3;
        String string = EgInstallInfo.getInstallDir() + "/agent/config/eg_osinfo.ini";
        try {
            object3 = new File(string);
            if (((File)object3).exists() && (object2 = ((IniFile2)(object = new IniFile2(string))).getValue("OSINFO", "Language")) != null && ((String)object2).length() > 0) {
                return object2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!isWindows) {
            return "";
        }
        object3 = EgInstallInfo.getInstallDir() + "/lib/eg_osinfo.exe";
        object = "";
        object2 = new File((String)object3);
        if (!((File)object2).exists()) {
            object3 = EgInstallInfo.getInstallDir() + "/bin/eg_osinfo.exe";
            object2 = new File((String)object3);
        }
        if (((File)object2).exists()) {
            Object object4;
            ArrayList arrayList = this.getExecOutputLines((String)object3);
            ArrayList arrayList2 = (ArrayList)arrayList.get(0);
            if (arrayList2 != null && arrayList2.size() > 0) {
                int n = arrayList2.size();
                for (int i = 0; i < n; ++i) {
                    object4 = (String)arrayList2.get(i);
                    if (!((String)object4).startsWith("Primary Language Code")) continue;
                    object = ((String)object4).substring(((String)object4).indexOf("=") + 1, ((String)object4).length());
                }
            }
            if (object != null && ((String)object).length() > 0) {
                try {
                    String string2 = EgInstallInfo.getInstallDir() + "/agent/config";
                    File file = new File(string2);
                    if (file.exists()) {
                        object4 = new IniFile2(string, true);
                        ((IniFile2)object4).setValue("OSINFO", "Language", (String)object);
                        ((IniFile2)object4).saveFile();
                        object4 = null;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            if (object == null) {
                return "";
            }
            return object;
        }
        if (object == null) {
            return "";
        }
        return object;
    }

    public String[] getIpAddressesOfHost() {
        if (isWindows) {
            return this.getIpAddressesOfHostOnWindows();
        }
        if (isLinux) {
            return this.getIpAddressesOfHostOnLinux();
        }
        if (isSolaris) {
            return this.getIpAddressesOfHostOnSolaris();
        }
        if (isAix) {
            return this.getIpAddressesOfHostOnAIX();
        }
        if (isHpux) {
            return this.getIpAddressesOfHostOnHPUX();
        }
        if (isOsf1) {
            return this.getIpAddressesOfHostOnOsf1();
        }
        return this.getIpAddressesOfHostOnUnix();
    }

    private String[] getIpAddressesOfHostOnUnix() {
        return this.getIpAddressesOfHostOnOsf1();
    }

    private String[] getIpAddressesOfHostOnOsf1() {
        String[] stringArray = null;
        String string = "ifconfig -a";
        BufferedReader bufferedReader = this.executeProgramOnUnix(string);
        if (bufferedReader != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            try {
                String string2;
                while ((string2 = bufferedReader.readLine()) != null) {
                    StringTokenizer stringTokenizer;
                    if (string2.indexOf("inet ") < 0 || (stringTokenizer = new StringTokenizer(string2)).countTokens() < 2) continue;
                    String string3 = stringTokenizer.nextToken();
                    String string4 = stringTokenizer.nextToken();
                    if (string4.equals("127.0.0.1")) continue;
                    string4.trim();
                    arrayList.add(string4);
                }
                stringArray = new String[arrayList.size()];
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = (String)arrayList.get(i);
                }
                bufferedReader.close();
            }
            catch (Exception exception) {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                return null;
            }
        }
        return stringArray;
    }

    private String[] getIpAddressesOfHostOnSolaris() {
        String[] stringArray = null;
        String string = "ifconfig -a";
        BufferedReader bufferedReader = this.executeProgramOnUnix(string);
        if (bufferedReader != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            try {
                String string2;
                while ((string2 = bufferedReader.readLine()) != null) {
                    StringTokenizer stringTokenizer;
                    if (string2.indexOf("inet ") < 0 || (stringTokenizer = new StringTokenizer(string2)).countTokens() < 2) continue;
                    String string3 = stringTokenizer.nextToken();
                    String string4 = stringTokenizer.nextToken();
                    if (string4.equals("127.0.0.1")) continue;
                    string4.trim();
                    this.sop("getIpAddressesOfHostOnSolaris:Val = " + string4);
                    arrayList.add(string4);
                }
                stringArray = new String[arrayList.size()];
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = (String)arrayList.get(i);
                }
                bufferedReader.close();
            }
            catch (Exception exception) {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                return null;
            }
        }
        return stringArray;
    }

    private String[] getIpAddressesOfHostOnLinux() {
        String[] stringArray = null;
        boolean bl = false;
        String string = "ifconfig -a";
        BufferedReader bufferedReader = this.executeProgramOnUnix(string);
        if (bufferedReader != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            try {
                String string2;
                while ((string2 = bufferedReader.readLine()) != null) {
                    StringTokenizer stringTokenizer;
                    if (string2.indexOf("inet addr") < 0 || (stringTokenizer = new StringTokenizer(string2, ":")).countTokens() < 2) continue;
                    String string3 = stringTokenizer.nextToken();
                    String string4 = stringTokenizer.nextToken();
                    int n = string4.indexOf(" ");
                    if (n < 0 || (string4 = new String(string4.substring(0, n))).equals("127.0.0.1")) continue;
                    string4.trim();
                    this.sop("getIpAddressesOfHostOnLinux:Val = " + string4);
                    arrayList.add(string4);
                }
                stringArray = new String[arrayList.size()];
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = (String)arrayList.get(i);
                    bl = true;
                }
                bufferedReader.close();
            }
            catch (Exception exception) {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                return null;
            }
        }
        if (!(bl || (stringArray = this.getIpAddressFromIpCmd()) != null && stringArray.length != 0)) {
            return null;
        }
        return stringArray;
    }

    private String[] getIpAddressesOfHostOnWindows() {
        String[] stringArray = null;
        boolean bl = false;
        String string = cmdPathWithArgs + "ipconfig";
        BufferedReader bufferedReader = this.executeProgramOnWindows(string);
        if (bufferedReader != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            String string2 = EgLangInfo.getAgentCommandSearch((String)string, (String)"IP Address");
            String string3 = EgLangInfo.getAgentCommandSearch((String)string, (String)"IPv4 Address");
            try {
                String string4 = bufferedReader.readLine();
                if (string4 != null) {
                    boolean bl2 = false;
                    while ((string4 = bufferedReader.readLine()) != null) {
                        StringTokenizer stringTokenizer;
                        if (string4.indexOf(string2) < 0 && string4.indexOf(string3) < 0 || (stringTokenizer = new StringTokenizer(string4, ":")).countTokens() < 2) continue;
                        String string5 = stringTokenizer.nextToken();
                        String string6 = new String(stringTokenizer.nextToken().trim());
                        if (string6.equals("127.0.0.1") || arrayList.indexOf(string6) >= 0) continue;
                        this.sop("getIpAddressesOfHostOnWindows:IP = " + string6);
                        arrayList.add(string6);
                    }
                    stringArray = new String[arrayList.size()];
                    for (int i = 0; i < stringArray.length; ++i) {
                        stringArray[i] = (String)arrayList.get(i);
                        this.sop("ipAddresses " + i + " " + stringArray[i]);
                    }
                }
                bufferedReader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return stringArray;
    }

    private String[] getIpAddressesOfHostOnHPUX() {
        String[] stringArray = null;
        String string = "netstat -in";
        BufferedReader bufferedReader = this.executeProgramOnUnix(string);
        if (bufferedReader != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            try {
                String string2;
                while ((string2 = bufferedReader.readLine()) != null) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string2 = string2.trim());
                    if (stringTokenizer.countTokens() < 2) continue;
                    String string3 = stringTokenizer.nextToken();
                    string3 = stringTokenizer.nextToken();
                    string3 = stringTokenizer.nextToken();
                    String string4 = stringTokenizer.nextToken();
                    if (string4.equalsIgnoreCase("address") || string4.equals("127.0.0.1")) continue;
                    string4.trim();
                    arrayList.add(string4);
                }
                stringArray = new String[arrayList.size()];
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = (String)arrayList.get(i);
                }
                bufferedReader.close();
            }
            catch (Exception exception) {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                return null;
            }
        }
        return stringArray;
    }

    private String[] getIpAddressesOfHostOnAIX() {
        String[] stringArray = null;
        String string = "ifconfig -a";
        BufferedReader bufferedReader = this.executeProgramOnUnix(string);
        if (bufferedReader != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            try {
                String string2;
                while ((string2 = bufferedReader.readLine()) != null) {
                    StringTokenizer stringTokenizer;
                    if (string2.indexOf("inet ") < 0 || (stringTokenizer = new StringTokenizer(string2)).countTokens() < 2) continue;
                    String string3 = stringTokenizer.nextToken();
                    String string4 = stringTokenizer.nextToken();
                    if (string4.equals("127.0.0.1")) continue;
                    string4.trim();
                    arrayList.add(string4);
                }
                stringArray = new String[arrayList.size()];
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = (String)arrayList.get(i);
                }
                bufferedReader.close();
            }
            catch (Exception exception) {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                return null;
            }
        }
        return stringArray;
    }

    private static void closeStreams(Process process) {
        if (process == null) {
            return;
        }
        try {
            process.getInputStream().close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            process.getOutputStream().close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            process.getErrorStream().close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            process.destroy();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public BufferedReader executeProgramOnUnix(String string) {
        Runtime runtime = Runtime.getRuntime();
        this.sop("executeProgramOnUnix:pgm = " + string);
        try {
            this.p = runtime.exec(string);
            if (this.p == null) {
                return null;
            }
            if (useUTF8) {
                return new BufferedReader(new InputStreamReader(this.p.getInputStream(), "UTF-8"));
            }
            return new BufferedReader(new InputStreamReader(this.p.getInputStream()));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public BufferedReader executeProgramOnUnix(String[] stringArray) {
        Runtime runtime = Runtime.getRuntime();
        if (stringArray == null || stringArray.length == 0) {
            this.sop("executeProgramOnUnix:pgm[] is null");
            return null;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            this.sop("executeProgramOnUnix:pgm[] = " + stringArray[i]);
        }
        try {
            this.p = runtime.exec(stringArray);
            if (this.p == null) {
                return null;
            }
            if (useUTF8) {
                return new BufferedReader(new InputStreamReader(this.p.getInputStream(), "UTF-8"));
            }
            return new BufferedReader(new InputStreamReader(this.p.getInputStream()));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public BufferedReader[] executeProgramOnUnix(String string, boolean bl) {
        Runtime runtime = Runtime.getRuntime();
        this.sop("executeProgramOnUnix:pgm = " + string);
        try {
            this.p = runtime.exec(string);
            BufferedReader[] bufferedReaderArray = new BufferedReader[2];
            if (useUTF8) {
                bufferedReaderArray[1] = new BufferedReader(new InputStreamReader(this.p.getErrorStream(), "UTF-8"));
                bufferedReaderArray[0] = new BufferedReader(new InputStreamReader(this.p.getInputStream(), "UTF-8"));
            } else {
                bufferedReaderArray[1] = new BufferedReader(new InputStreamReader(this.p.getErrorStream()));
                bufferedReaderArray[0] = new BufferedReader(new InputStreamReader(this.p.getInputStream()));
            }
            return bufferedReaderArray;
        }
        catch (Exception exception) {
            this.p = null;
            exception.printStackTrace();
            return null;
        }
    }

    public InputStream[] executeProgramOnUnix(String[] stringArray, Object object) {
        ObjectOutputStream objectOutputStream = null;
        Runtime runtime = Runtime.getRuntime();
        try {
            this.p = runtime.exec(stringArray);
            if (object != null) {
                objectOutputStream = new ObjectOutputStream(this.p.getOutputStream());
                objectOutputStream.writeObject(object);
                objectOutputStream.close();
            }
            InputStream[] inputStreamArray = new InputStream[2];
            inputStreamArray[1] = this.p.getErrorStream();
            inputStreamArray[0] = this.p.getInputStream();
            return inputStreamArray;
        }
        catch (Exception exception) {
            this.p = null;
            exception.printStackTrace();
            return null;
        }
    }

    public InputStream[] executeProgramOnUnix(String string, Object object) {
        ObjectOutputStream objectOutputStream = null;
        Runtime runtime = Runtime.getRuntime();
        this.sop("executeProgramOnUnix:pgm = " + string);
        try {
            this.p = runtime.exec(string);
            if (object != null) {
                objectOutputStream = new ObjectOutputStream(this.p.getOutputStream());
                objectOutputStream.writeObject(object);
                objectOutputStream.flush();
                objectOutputStream.close();
            }
            InputStream[] inputStreamArray = new InputStream[2];
            inputStreamArray[1] = this.p.getErrorStream();
            inputStreamArray[0] = this.p.getInputStream();
            return inputStreamArray;
        }
        catch (Exception exception) {
            this.p = null;
            exception.printStackTrace();
            return null;
        }
    }

    public BufferedReader[] executeProgramOnUnix(String[] stringArray, boolean bl) {
        Runtime runtime = Runtime.getRuntime();
        try {
            this.p = runtime.exec(stringArray);
            BufferedReader[] bufferedReaderArray = new BufferedReader[2];
            if (useUTF8) {
                bufferedReaderArray[1] = new BufferedReader(new InputStreamReader(this.p.getErrorStream(), "UTF-8"));
                bufferedReaderArray[0] = new BufferedReader(new InputStreamReader(this.p.getInputStream(), "UTF-8"));
            } else {
                bufferedReaderArray[1] = new BufferedReader(new InputStreamReader(this.p.getErrorStream()));
                bufferedReaderArray[0] = new BufferedReader(new InputStreamReader(this.p.getInputStream()));
            }
            return bufferedReaderArray;
        }
        catch (Exception exception) {
            this.p = null;
            exception.printStackTrace();
            return null;
        }
    }

    public BufferedReader executeProgramOnUnix(String string, String[] stringArray) {
        Runtime runtime = Runtime.getRuntime();
        this.sop("executeProgramOnUnix:pgm= " + string);
        for (int i = 0; i < stringArray.length; ++i) {
            this.sop("executeProgramOnUnix:envp[] = " + stringArray[i]);
        }
        try {
            this.p = runtime.exec(string, stringArray);
            this.sop("executeProgramOnUnix:Process = " + this.p);
            if (this.p == null) {
                this.logToLogFile("ERROR", s_entity, "Exec Failed");
                return null;
            }
            if (useUTF8) {
                return new BufferedReader(new InputStreamReader(this.p.getInputStream(), "UTF-8"));
            }
            return new BufferedReader(new InputStreamReader(this.p.getInputStream()));
        }
        catch (Exception exception) {
            this.logToLogFile("ERROR", s_entity, "Exec Failed");
            exception.printStackTrace();
            return null;
        }
    }

    public BufferedReader[] executeProgramOnUnix(String string, String[] stringArray, boolean bl) {
        Runtime runtime = Runtime.getRuntime();
        this.sop("executeProgramOnUnix:pgm= " + string);
        for (int i = 0; i < stringArray.length; ++i) {
            this.sop("executeProgramOnUnix:envp[] = " + stringArray[i]);
        }
        try {
            this.p = runtime.exec(string, stringArray);
            this.sop("executeProgramOnUnix:Process = " + this.p);
            if (this.p == null) {
                this.logToLogFile("ERROR", s_entity, "Exec Failed");
                return null;
            }
            BufferedReader[] bufferedReaderArray = new BufferedReader[2];
            if (useUTF8) {
                bufferedReaderArray[1] = new BufferedReader(new InputStreamReader(this.p.getErrorStream(), "UTF-8"));
                bufferedReaderArray[0] = new BufferedReader(new InputStreamReader(this.p.getInputStream(), "UTF-8"));
            } else {
                bufferedReaderArray[1] = new BufferedReader(new InputStreamReader(this.p.getErrorStream()));
                bufferedReaderArray[0] = new BufferedReader(new InputStreamReader(this.p.getInputStream()));
            }
            return bufferedReaderArray;
        }
        catch (Exception exception) {
            this.logToLogFile("ERROR", s_entity, "Exec Failed");
            exception.printStackTrace();
            return null;
        }
    }

    public BufferedReader[] executeProgramOnWindows(String string, boolean bl) {
        Runtime runtime = Runtime.getRuntime();
        String string2 = (string = string.trim()).toUpperCase();
        if (!string2.startsWith("CMD")) {
            string = cmdPathWithArgs + string;
        }
        this.sop("executeProgramOnWindows:pgm = " + string);
        try {
            if (this.hitDebug) {
                System.out.println("[EgUtilities].executeProgramOnWindows() before exec(pgm) ");
                System.out.println("[EgUtilities].executeProgramOnWindows() COMMAND => " + string);
            }
            this.p = runtime.exec(string);
            if (this.hitDebug) {
                System.out.println("[EgUtilities].executeProgramOnWindows() after exec(pgm) ");
            }
            BufferedReader[] bufferedReaderArray = new BufferedReader[2];
            if (useEncoding) {
                bufferedReaderArray[1] = new BufferedReader(new InputStreamReader(this.p.getErrorStream(), encoding));
                bufferedReaderArray[0] = new BufferedReader(new InputStreamReader(this.p.getInputStream(), encoding));
            } else {
                bufferedReaderArray[1] = new BufferedReader(new InputStreamReader(this.p.getErrorStream()));
                bufferedReaderArray[0] = new BufferedReader(new InputStreamReader(this.p.getInputStream()));
            }
            return bufferedReaderArray;
        }
        catch (Exception exception) {
            this.p = null;
            exception.printStackTrace();
            return null;
        }
    }

    public InputStream[] executeProgramOnWindows(String string, Object object) {
        ObjectOutputStream objectOutputStream = null;
        Runtime runtime = Runtime.getRuntime();
        String string2 = (string = string.trim()).toUpperCase();
        if (!string2.startsWith("CMD")) {
            string = cmdPathWithArgs + string;
        }
        this.sop("executeProgramOnWindows:pgm = " + string);
        try {
            if (this.hitDebug) {
                System.out.println("[EgUtilities].executeProgramOnWindows() before exec(pgm) ");
                System.out.println("[EgUtilities].executeProgramOnWindows() COMMAND => " + string);
            }
            this.p = runtime.exec(string);
            if (object != null) {
                objectOutputStream = new ObjectOutputStream(this.p.getOutputStream());
                objectOutputStream.writeObject(object);
                objectOutputStream.flush();
                objectOutputStream.close();
            }
            if (this.hitDebug) {
                System.out.println("[EgUtilities].executeProgramOnWindows() after exec(pgm) ");
            }
            InputStream[] inputStreamArray = new InputStream[]{this.p.getInputStream(), this.p.getErrorStream()};
            return inputStreamArray;
        }
        catch (Exception exception) {
            this.p = null;
            exception.printStackTrace();
            return null;
        }
    }

    public BufferedReader[] executeProgramOnWindows(String string, boolean bl, String string2) {
        Runtime runtime = Runtime.getRuntime();
        String string3 = (string = string.trim()).toUpperCase();
        if (!string3.startsWith("CMD")) {
            string = cmdPathWithArgs + string;
        }
        this.sop("executeProgramOnWindows:pgm = " + string);
        try {
            this.p = runtime.exec(string);
            BufferedReader[] bufferedReaderArray = new BufferedReader[2];
            bufferedReaderArray[1] = new BufferedReader(new InputStreamReader(this.p.getErrorStream(), string2));
            bufferedReaderArray[0] = new BufferedReader(new InputStreamReader(this.p.getInputStream(), string2));
            return bufferedReaderArray;
        }
        catch (Exception exception) {
            this.p = null;
            exception.printStackTrace();
            return null;
        }
    }

    public BufferedReader executeProgramOnWindows(String string) {
        Runtime runtime = Runtime.getRuntime();
        String string2 = (string = string.trim()).toUpperCase();
        if (!string2.startsWith("CMD")) {
            string = cmdPathWithArgs + string;
        }
        this.sop("executeProgramOnWindows:pgm = " + string);
        try {
            this.p = runtime.exec(string);
            if (this.p == null) {
                return null;
            }
            if (useEncoding) {
                return new BufferedReader(new InputStreamReader(this.p.getInputStream(), encoding));
            }
            return new BufferedReader(new InputStreamReader(this.p.getInputStream()));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public BufferedReader executeProgramOnWindows(String string, String string2) {
        Runtime runtime = Runtime.getRuntime();
        String string3 = (string = string.trim()).toUpperCase();
        if (!string3.startsWith("CMD")) {
            string = cmdPathWithArgs + string;
        }
        this.sop("executeProgramOnWindows:pgm = " + string);
        try {
            this.p = runtime.exec(string);
            if (this.p == null) {
                return null;
            }
            return new BufferedReader(new InputStreamReader(this.p.getInputStream(), string2));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void killProcesses(ArrayList arrayList) {
        if (arrayList == null || arrayList.size() < 1) {
            return;
        }
        String string = "";
        String string2 = EgInstallInfo.getInstallDir() + "/bin/processkill -p ";
        if (this.hitDebug) {
            System.out.println("[EgUtilities].killProcesses() Going to kill " + arrayList);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            String string3 = (String)arrayList.get(i);
            if (string3 == null || string3.length() == 0) continue;
            string = isWindows ? string2 + string3 : "kill -9 " + string3;
            try {
                this.getCommandOutputLines(string);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.hitDebug) {
            System.out.println("[EgUtilities].killProcesses() PROCESS KILLED");
        }
    }

    public ArrayList getPid(ArrayList arrayList) {
        String string = "";
        if (!isWindows) {
            return null;
        }
        string = "cscript.exe " + EgInstallInfo.getInstallDir() + "/lib/apppid.vbs none";
        if (arrayList == null || arrayList.size() == 0) {
            return new ArrayList();
        }
        ArrayList arrayList2 = this.getCommandOutputLines(string);
        if (arrayList2 == null) {
            return null;
        }
        int n = arrayList2.size();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        String string2 = "";
        int n2 = arrayList.size();
        block0: for (int i = 0; i < n; ++i) {
            String string3 = (String)arrayList2.get(i);
            if (string3 == null) continue;
            string3 = string3.trim().toLowerCase();
            for (int j = 0; j < n2; ++j) {
                ArrayList arrayList4;
                string2 = (String)arrayList.get(j);
                if (string2 == null || string2.trim().length() == 0 || string3.indexOf(string2 = string2.toLowerCase()) < 0 || (arrayList4 = EgUtilities.myTokenizer(string3, "#~#")) == null || arrayList4.size() < 3) continue;
                String string4 = (String)arrayList4.get(1);
                if (string4 == null) continue block0;
                arrayList3.add(string4);
                continue block0;
            }
        }
        return arrayList3;
    }

    public ArrayList getPid(String string) {
        String string2 = "";
        string = string.toUpperCase();
        if (isWindows) {
            string2 = "cscript.exe " + EgInstallInfo.getInstallDir() + "/lib/apppid.vbs none";
        } else {
            string2 = "ps -e -o pid,args";
            if (isHpux) {
                string2 = EgInstallInfo.getInstallDir() + "/bin/processlist.sh";
            }
        }
        ArrayList arrayList = this.getCommandOutputLines(string2);
        if (arrayList == null) {
            return null;
        }
        int n = arrayList.size();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (int i = 0; i < n; ++i) {
            String string3;
            String string4 = (String)arrayList.get(i);
            if (string4 == null) continue;
            string4 = string4.trim();
            string4 = string4.toUpperCase();
            if (this.hitDebug) {
                System.out.println("Apppid Line ==> " + string4);
            }
            if (string4.indexOf(string) < 0) continue;
            if (isWindows) {
                ArrayList arrayList3 = EgUtilities.myTokenizer(string4, "#~#");
                if (arrayList3 == null || arrayList3.size() < 3 || (string3 = (String)arrayList3.get(1)) == null) continue;
                try {
                    string3 = string3.trim();
                    Long.parseLong(string3);
                    arrayList2.add(string3);
                }
                catch (Exception exception) {}
                continue;
            }
            int n2 = string4.indexOf(" ");
            if (n2 < 0) continue;
            string3 = string4.substring(0, n2);
            if ((string4 = string4.substring(n2 + 1)).indexOf(string) < 0) continue;
            try {
                string3 = string3.trim();
                Long.parseLong(string3);
                arrayList2.add(string3);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.hitDebug) {
            System.out.println("[EgUtilities].getPid() ===> Return pidVal ===>" + arrayList2);
        }
        return arrayList2;
    }

    public ArrayList getExecOutputLines(String string, long l, String string2) {
        long l2 = l;
        long l3 = 0L;
        ArrayList<ArrayList> arrayList = new ArrayList<ArrayList>();
        BufferedReader[] bufferedReaderArray = null;
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList arrayList3 = new ArrayList();
        boolean bl = false;
        if (string != null && string.indexOf("java") >= 0) {
            bl = true;
        }
        try {
            ArrayList<String> arrayList4;
            bufferedReaderArray = isWindows ? this.executeProgramOnWindows(string, true) : (isLinux || isSolaris || isAix || isHpux || isOsf1 ? this.executeProgramOnUnix(string, true) : this.executeProgramOnUnix(string, true));
            if (bufferedReaderArray == null || bufferedReaderArray.length == 0) {
                return null;
            }
            EgStreamReaderThread egStreamReaderThread = new EgStreamReaderThread(bufferedReaderArray[0]);
            EgStreamReaderThread egStreamReaderThread2 = new EgStreamReaderThread(bufferedReaderArray[1]);
            if (egStreamReaderThread != null) {
                egStreamReaderThread.start();
            }
            long l4 = 3L;
            while (egStreamReaderThread != null && !egStreamReaderThread.done) {
                Thread.sleep(l4 * 1000L);
                if ((l3 += l4) <= l2) continue;
                egStreamReaderThread.done = true;
                egStreamReaderThread.join(1000L);
                try {
                    egStreamReaderThread.interrupt();
                    Thread.currentThread();
                    Thread.yield();
                    egStreamReaderThread.stop();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.p != null) {
                    ArrayList arrayList5;
                    if (string2 != null && string2.length() > 0 && (arrayList5 = this.getPid(string2)) != null && arrayList5.size() > 0) {
                        this.killProcesses(arrayList5);
                    }
                    EgUtilities.closeStreams(this.p);
                    this.p = null;
                }
                if (this.p != null) {
                    // empty if block
                }
                egStreamReaderThread = null;
                egStreamReaderThread2 = null;
                return null;
            }
            if (egStreamReaderThread2 != null) {
                egStreamReaderThread2.start();
            }
            while (egStreamReaderThread2 != null && !egStreamReaderThread2.done) {
                Thread.sleep(2000L);
                if ((l3 += 2L) <= l2) continue;
                egStreamReaderThread2.done = true;
                egStreamReaderThread2.join(1000L);
                egStreamReaderThread2.interrupt();
                Thread.currentThread();
                Thread.yield();
                egStreamReaderThread2.stop();
                if (this.p != null) {
                    EgUtilities.closeStreams(this.p);
                    if (string2 != null && string2.length() > 0 && (arrayList4 = this.getPid(string2)) != null && arrayList4.size() > 0) {
                        this.killProcesses(arrayList4);
                        arrayList2 = new ArrayList<String>();
                    }
                    this.p = null;
                }
                egStreamReaderThread2 = null;
            }
            if (this.p != null) {
                this.p.waitFor();
            }
            if (egStreamReaderThread != null) {
                egStreamReaderThread.join();
                arrayList2 = egStreamReaderThread.getData();
            }
            if (egStreamReaderThread2 != null) {
                egStreamReaderThread2.join();
                arrayList3 = egStreamReaderThread2.getData();
            }
            if (arrayList2 != null) {
                if (bl) {
                    arrayList4 = new ArrayList<String>();
                    for (int i = 0; i < arrayList2.size(); ++i) {
                        String string3 = (String)arrayList2.get(i);
                        if (string3.indexOf("[warning]") >= 0 && string3.indexOf("Duplicate cpuset controllers") >= 0) continue;
                        arrayList4.add(string3);
                    }
                    arrayList2 = arrayList4;
                }
                arrayList.add(arrayList2);
            }
            if (arrayList3 != null) {
                arrayList.add(arrayList3);
            }
            if (this.p != null) {
                EgUtilities.closeStreams(this.p);
                this.p = null;
            }
            return arrayList;
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Exception exception) {
            if (this.p != null) {
                EgUtilities.closeStreams(this.p);
                this.p = null;
            }
            exception.printStackTrace();
        }
        return null;
    }

    public ArrayList getExecOutputLines(String string, long l, String string2, boolean bl) {
        this.hitDebug = bl;
        long l2 = l;
        long l3 = 0L;
        ArrayList<ArrayList> arrayList = new ArrayList<ArrayList>();
        BufferedReader[] bufferedReaderArray = null;
        boolean bl2 = false;
        if (string != null && string.indexOf("java") >= 0) {
            bl2 = true;
        }
        if (this.hitDebug) {
            System.out.println("[EgUtilities] Command to Execute ==> " + string);
        }
        try {
            ArrayList arrayList2;
            if (isWindows) {
                if (this.hitDebug) {
                    System.out.println("[EgUtilities] Before calling executeProgram on Windows ");
                }
                bufferedReaderArray = this.executeProgramOnWindows(string, true);
                if (this.hitDebug) {
                    System.out.println("[EgUtilities] After calling executeProgram on Windows ");
                }
            } else {
                bufferedReaderArray = isLinux || isSolaris || isAix || isHpux || isOsf1 ? this.executeProgramOnUnix(string, true) : this.executeProgramOnUnix(string, true);
            }
            if (bufferedReaderArray == null || bufferedReaderArray.length == 0) {
                return null;
            }
            EgStreamReaderThread egStreamReaderThread = new EgStreamReaderThread(bufferedReaderArray[0], this.hitDebug);
            EgStreamReaderThread egStreamReaderThread2 = new EgStreamReaderThread(bufferedReaderArray[1], this.hitDebug);
            egStreamReaderThread.start();
            long l4 = 3L;
            while (!egStreamReaderThread.done) {
                if (this.hitDebug) {
                    System.out.println("[EgUtilities] ===> out stream while loop");
                }
                Thread.sleep(l4 * 1000L);
                l3 += l4;
                if (this.hitDebug) {
                    System.out.println("[EgUtilities] ===>Timeout happened in Out stream " + l3 + " seconds over");
                }
                if (l3 > l2) {
                    if (this.hitDebug) {
                        System.out.println("[EgUtilities] =============TIMEOUT COMPLETED=============== FOR COMMAND ==> " + string);
                    }
                    egStreamReaderThread.done = true;
                    egStreamReaderThread.join(1000L);
                    try {
                        egStreamReaderThread.interrupt();
                        Thread.currentThread();
                        Thread.yield();
                        egStreamReaderThread.stop();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (this.p != null) {
                        if (string2 != null && string2.length() > 0) {
                            if (this.hitDebug) {
                                System.out.println("[EgUtilities] ===> Call getPid() ");
                            }
                            ArrayList arrayList3 = this.getPid(string2);
                            if (this.hitDebug) {
                                System.out.println("[EgUtilities] ===> Pid Value " + arrayList3);
                            }
                            if (arrayList3 != null && arrayList3.size() > 0) {
                                this.killProcesses(arrayList3);
                            }
                        }
                        if (this.hitDebug) {
                            System.out.println("[EgUtilities] ===> Out Stream Process Destroyed ");
                        }
                        EgUtilities.closeStreams(this.p);
                        this.p = null;
                    }
                    if (this.p != null && this.hitDebug) {
                        System.out.println("[EgUtilities] ===> Out Stream Process have not been Destroyed");
                    }
                    egStreamReaderThread = null;
                    egStreamReaderThread2 = null;
                    return null;
                }
                if (!this.hitDebug) continue;
                System.out.println("[EgUtilities] ===> out stream while loop end");
            }
            egStreamReaderThread2.start();
            while (!egStreamReaderThread2.done) {
                if (this.hitDebug) {
                    System.out.println("[EgUtilities] ===> Error stream while loop");
                }
                Thread.sleep(2000L);
                if ((l3 += 2L) <= l2) continue;
                if (this.hitDebug) {
                    System.out.println("[EgUtilities] ===> Timeout happened in error stream");
                }
                egStreamReaderThread2.done = true;
                egStreamReaderThread2.join(1000L);
                egStreamReaderThread2.interrupt();
                Thread.currentThread();
                Thread.yield();
                egStreamReaderThread2.stop();
                if (this.p != null) {
                    EgUtilities.closeStreams(this.p);
                    if (string2 != null && string2.length() > 0) {
                        if (this.hitDebug) {
                            System.out.println("[EgUtilities] ===> Call getPid() ");
                        }
                        arrayList2 = this.getPid(string2);
                        if (this.hitDebug) {
                            System.out.println("[EgUtilities] ===> Pid Value " + arrayList2);
                        }
                        if (arrayList2 != null && arrayList2.size() > 0) {
                            this.killProcesses(arrayList2);
                        }
                    }
                    if (this.hitDebug) {
                        System.out.println("[EgUtilities] ===> Error Stream Process Destroyed ");
                    }
                    this.p = null;
                }
                egStreamReaderThread2 = null;
            }
            if (this.hitDebug) {
                System.out.println("[EgUtilities] ===> Wait For");
            }
            this.p.waitFor();
            arrayList2 = null;
            ArrayList arrayList4 = null;
            if (egStreamReaderThread != null) {
                egStreamReaderThread.join();
                arrayList2 = egStreamReaderThread.getData();
            }
            if (egStreamReaderThread2 != null) {
                egStreamReaderThread2.join();
                arrayList4 = egStreamReaderThread2.getData();
            }
            if (arrayList2 != null) {
                if (bl2) {
                    ArrayList arrayList5 = new ArrayList();
                    for (int i = 0; i < arrayList2.size(); ++i) {
                        String string3 = (String)arrayList2.get(i);
                        if (string3.indexOf("[warning]") >= 0 && string3.indexOf("Duplicate cpuset controllers") >= 0) continue;
                        arrayList5.add(string3);
                    }
                    arrayList2 = arrayList5;
                }
                arrayList.add(arrayList2);
            }
            if (arrayList4 != null) {
                arrayList.add(arrayList4);
            }
            if (this.p != null) {
                EgUtilities.closeStreams(this.p);
                this.p = null;
            }
            return arrayList;
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Exception exception) {
            if (this.p != null) {
                EgUtilities.closeStreams(this.p);
                this.p = null;
            }
            exception.printStackTrace();
        }
        this.hitDebug = false;
        return null;
    }

    public ArrayList getExecOutputLines(String string, long l, String string2, boolean bl, boolean bl2) {
        this.hitDebug = bl;
        long l2 = l;
        long l3 = 0L;
        ArrayList<ArrayList> arrayList = new ArrayList<ArrayList>();
        BufferedReader[] bufferedReaderArray = null;
        boolean bl3 = false;
        if (string != null && string.indexOf("java") >= 0) {
            bl3 = true;
        }
        try {
            ArrayList arrayList2;
            if (isWindows) {
                if (this.hitDebug) {
                    System.out.println("[EgUtilities] Before calling executeProgram on Windows ");
                }
                bufferedReaderArray = this.executeProgramOnWindows(string, true);
                if (this.hitDebug) {
                    System.out.println("[EgUtilities] After calling executeProgram on Windows ");
                }
            } else if (isLinux || isSolaris || isAix || isHpux || isOsf1) {
                bufferedReaderArray = this.executeProgramOnUnix(string, true);
                if (this.hitDebug) {
                    System.out.println("[EgUtilities] s_cmd : " + string + " br_output : " + bufferedReaderArray);
                }
            } else {
                bufferedReaderArray = this.executeProgramOnUnix(string, true);
            }
            if (bufferedReaderArray == null || bufferedReaderArray.length == 0) {
                return null;
            }
            EgStreamReaderThread egStreamReaderThread = new EgStreamReaderThread(bufferedReaderArray[0], this.hitDebug);
            EgStreamReaderThread egStreamReaderThread2 = new EgStreamReaderThread(bufferedReaderArray[1], this.hitDebug);
            egStreamReaderThread.start();
            long l4 = 3L;
            while (!egStreamReaderThread.done) {
                if (this.hitDebug) {
                    System.out.println("[EgUtilities] ===> out stream while loop");
                }
                Thread.sleep(l4 * 1000L);
                l3 += l4;
                if (this.hitDebug) {
                    System.out.println("[EgUtilities] ===>Timeout happened in Out stream " + l3 + " seconds over");
                }
                if (l3 > l2) {
                    ArrayList arrayList3;
                    if (this.hitDebug) {
                        System.out.println("[EgUtilities] =============TIMEOUT COMPLETED=============== FOR COMMAND ==> " + string);
                    }
                    egStreamReaderThread.done = true;
                    egStreamReaderThread.join(1000L);
                    try {
                        egStreamReaderThread.interrupt();
                        Thread.currentThread();
                        Thread.yield();
                        egStreamReaderThread.stop();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (this.p != null) {
                        if (string2 != null && string2.length() > 0) {
                            if (this.hitDebug) {
                                System.out.println("[EgUtilities] ===> Call getPid() ");
                            }
                            arrayList3 = this.getPid(string2);
                            if (this.hitDebug) {
                                System.out.println("[EgUtilities] ===> Pid Value " + arrayList3);
                            }
                            if (arrayList3 != null && arrayList3.size() > 0) {
                                this.killProcesses(arrayList3);
                            }
                        }
                        if (this.hitDebug) {
                            System.out.println("[EgUtilities] ===> Out Stream Process Destroyed ");
                        }
                        EgUtilities.closeStreams(this.p);
                        this.p = null;
                    }
                    if (this.p != null && this.hitDebug) {
                        System.out.println("[EgUtilities] ===> Out Stream Process have not been Destroyed");
                    }
                    arrayList3 = null;
                    if (this.hitDebug) {
                        System.out.println(bl2 + " [EgUtilities] 444 stdOutStream : " + egStreamReaderThread);
                    }
                    if (bl2 && egStreamReaderThread != null) {
                        egStreamReaderThread.join();
                        arrayList3 = egStreamReaderThread.getData();
                        if (this.hitDebug) {
                            System.out.println(" [EgUtilities] al_out_data : " + arrayList3);
                        }
                    }
                    egStreamReaderThread = null;
                    egStreamReaderThread2 = null;
                    return arrayList3;
                }
                if (!this.hitDebug) continue;
                System.out.println("[EgUtilities] ===> out stream while loop end");
            }
            egStreamReaderThread2.start();
            while (!egStreamReaderThread2.done) {
                if (this.hitDebug) {
                    System.out.println("[EgUtilities] ===> Error stream while loop");
                }
                Thread.sleep(2000L);
                if ((l3 += 2L) <= l2) continue;
                if (this.hitDebug) {
                    System.out.println("[EgUtilities] ===> Timeout happened in error stream");
                }
                egStreamReaderThread2.done = true;
                egStreamReaderThread2.join(1000L);
                egStreamReaderThread2.interrupt();
                Thread.currentThread();
                Thread.yield();
                egStreamReaderThread2.stop();
                if (this.p != null) {
                    EgUtilities.closeStreams(this.p);
                    if (string2 != null && string2.length() > 0) {
                        if (this.hitDebug) {
                            System.out.println("[EgUtilities] ===> Call getPid() ");
                        }
                        arrayList2 = this.getPid(string2);
                        if (this.hitDebug) {
                            System.out.println("[EgUtilities] ===> Pid Value " + arrayList2 + " proName : " + string2);
                        }
                        if (arrayList2 != null && arrayList2.size() > 0) {
                            this.killProcesses(arrayList2);
                        }
                    }
                    if (this.hitDebug) {
                        System.out.println("[EgUtilities] ===> Error Stream Process Destroyed ");
                    }
                    this.p = null;
                }
                egStreamReaderThread2 = null;
            }
            if (this.hitDebug) {
                System.out.println("[EgUtilities] ===> Wait For");
            }
            this.p.waitFor();
            arrayList2 = null;
            ArrayList arrayList4 = null;
            if (egStreamReaderThread != null) {
                egStreamReaderThread.join();
                arrayList2 = egStreamReaderThread.getData();
            }
            if (egStreamReaderThread2 != null) {
                egStreamReaderThread2.join();
                arrayList4 = egStreamReaderThread2.getData();
            }
            if (arrayList2 != null) {
                if (bl3) {
                    ArrayList arrayList5 = new ArrayList();
                    for (int i = 0; i < arrayList2.size(); ++i) {
                        String string3 = (String)arrayList2.get(i);
                        if (string3.indexOf("[warning]") >= 0 && string3.indexOf("Duplicate cpuset controllers") >= 0) continue;
                        arrayList5.add(string3);
                    }
                    arrayList2 = arrayList5;
                }
                arrayList.add(arrayList2);
            }
            if (arrayList4 != null) {
                arrayList.add(arrayList4);
            }
            if (this.p != null) {
                EgUtilities.closeStreams(this.p);
                this.p = null;
            }
            return arrayList;
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Exception exception) {
            if (this.p != null) {
                EgUtilities.closeStreams(this.p);
                this.p = null;
            }
            exception.printStackTrace();
        }
        return null;
    }

    public ArrayList getExecOutputLines(String string, long l, String string2, int n) {
        long l2 = l;
        long l3 = 0L;
        ArrayList<ArrayList> arrayList = new ArrayList<ArrayList>();
        BufferedReader[] bufferedReaderArray = null;
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList arrayList3 = new ArrayList();
        boolean bl = false;
        if (string != null && string.indexOf("java") >= 0) {
            bl = true;
        }
        try {
            ArrayList<String> arrayList4;
            bufferedReaderArray = isWindows ? this.executeProgramOnWindows(string, true) : (isLinux || isSolaris || isAix || isHpux || isOsf1 ? this.executeProgramOnUnix(string, true) : this.executeProgramOnUnix(string, true));
            if (bufferedReaderArray == null || bufferedReaderArray.length == 0) {
                return null;
            }
            EgStreamReaderThread egStreamReaderThread = new EgStreamReaderThread(bufferedReaderArray[0]);
            EgStreamReaderThread egStreamReaderThread2 = new EgStreamReaderThread(bufferedReaderArray[1]);
            if (egStreamReaderThread != null) {
                egStreamReaderThread.start();
            }
            long l4 = 50L;
            while (egStreamReaderThread != null && !egStreamReaderThread.done) {
                Thread.sleep(l4);
                if ((l3 += l4) <= l2) continue;
                egStreamReaderThread.done = true;
                egStreamReaderThread.join(100L);
                try {
                    egStreamReaderThread.interrupt();
                    Thread.currentThread();
                    Thread.yield();
                    egStreamReaderThread.stop();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.p != null) {
                    ArrayList arrayList5;
                    if (string2 != null && string2.length() > 0 && (arrayList5 = this.getPid(string2)) != null && arrayList5.size() > 0) {
                        this.killProcesses(arrayList5);
                    }
                    EgUtilities.closeStreams(this.p);
                    this.p = null;
                }
                if (this.p != null) {
                    // empty if block
                }
                egStreamReaderThread = null;
                egStreamReaderThread2 = null;
                return null;
            }
            if (egStreamReaderThread2 != null) {
                egStreamReaderThread2.start();
            }
            while (egStreamReaderThread2 != null && !egStreamReaderThread2.done) {
                Thread.sleep(100L);
                if ((l3 += 100L) <= l2) continue;
                egStreamReaderThread2.done = true;
                egStreamReaderThread2.join(100L);
                egStreamReaderThread2.interrupt();
                Thread.currentThread();
                Thread.yield();
                egStreamReaderThread2.stop();
                if (this.p != null) {
                    EgUtilities.closeStreams(this.p);
                    if (string2 != null && string2.length() > 0 && (arrayList4 = this.getPid(string2)) != null && arrayList4.size() > 0) {
                        this.killProcesses(arrayList4);
                        arrayList2 = new ArrayList<String>();
                    }
                    this.p = null;
                }
                egStreamReaderThread2 = null;
            }
            if (this.p != null) {
                this.p.waitFor();
            }
            if (egStreamReaderThread != null) {
                egStreamReaderThread.join();
                arrayList2 = egStreamReaderThread.getData();
            }
            if (egStreamReaderThread2 != null) {
                egStreamReaderThread2.join();
                arrayList3 = egStreamReaderThread2.getData();
            }
            if (arrayList2 != null) {
                if (bl) {
                    arrayList4 = new ArrayList<String>();
                    for (int i = 0; i < arrayList2.size(); ++i) {
                        String string3 = (String)arrayList2.get(i);
                        if (string3.indexOf("[warning]") >= 0 && string3.indexOf("Duplicate cpuset controllers") >= 0) continue;
                        arrayList4.add(string3);
                    }
                    arrayList2 = arrayList4;
                }
                arrayList.add(arrayList2);
            }
            if (arrayList3 != null) {
                arrayList.add(arrayList3);
            }
            if (this.p != null) {
                EgUtilities.closeStreams(this.p);
                this.p = null;
            }
            return arrayList;
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Exception exception) {
            if (this.p != null) {
                EgUtilities.closeStreams(this.p);
                this.p = null;
            }
            exception.printStackTrace();
        }
        return null;
    }

    public ArrayList getExecOutputLines(String string) {
        ArrayList arrayList = new ArrayList();
        BufferedReader[] bufferedReaderArray = null;
        boolean bl = false;
        if (string != null && string.indexOf("java") >= 0) {
            bl = true;
            if (this.hitDebug) {
                System.out.println(new Date() + " EgUtilitis getExecOutputLines() isJava= " + bl + " s_cmd : " + string);
            }
        }
        try {
            ArrayList<String> arrayList2;
            Object object;
            Object object2;
            if (isWindows) {
                if (osLanguage != null && !osLanguage.equals("ENU")) {
                    if (encoding != null) {
                        arrayList = this.getExecOutputLines(string, encoding);
                        return arrayList;
                    }
                    if (cmdEncodings != null && cmdEncodings.size() > 0) {
                        object2 = cmdEncodings.keys();
                        while (object2.hasMoreElements()) {
                            object = (String)object2.nextElement();
                            if (string.indexOf((String)object) < 0 || (arrayList2 = (String)cmdEncodings.get(object)) == null) continue;
                            arrayList = this.getExecOutputLines(string, (String)((Object)arrayList2));
                            return arrayList;
                        }
                        bufferedReaderArray = this.executeProgramOnWindows(string, true);
                    } else {
                        bufferedReaderArray = this.executeProgramOnWindows(string, true);
                    }
                } else {
                    bufferedReaderArray = this.executeProgramOnWindows(string, true);
                }
            } else {
                bufferedReaderArray = isLinux || isSolaris || isAix || isHpux || isOsf1 ? this.executeProgramOnUnix(string, true) : this.executeProgramOnUnix(string, true);
            }
            if (bufferedReaderArray == null || bufferedReaderArray.length == 0) {
                return null;
            }
            object2 = new EgStreamReaderThread(bufferedReaderArray[0]);
            object = new EgStreamReaderThread(bufferedReaderArray[1]);
            ((Thread)object2).start();
            ((Thread)object).start();
            try {
                this.p.waitFor();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ((Thread)object2).join();
            ((Thread)object).join();
            arrayList2 = ((EgStreamReaderThread)object2).getData();
            ArrayList arrayList3 = ((EgStreamReaderThread)object).getData();
            if (bl) {
                ArrayList<String> arrayList4 = new ArrayList<String>();
                for (int i = 0; i < arrayList2.size(); ++i) {
                    String string2 = (String)arrayList2.get(i);
                    if (string2.indexOf("[warning]") >= 0 && string2.indexOf("Duplicate cpuset controllers") >= 0) {
                        if (!this.hitDebug) continue;
                        System.out.println(new Date() + " EgUtilitis getExecOutputLines() isJava= " + bl + " Skipped outputline : " + string2);
                        continue;
                    }
                    arrayList4.add(string2);
                }
                arrayList2 = arrayList4;
            }
            arrayList.add(arrayList2);
            arrayList.add(arrayList3);
            if (this.p != null) {
                EgUtilities.closeStreams(this.p);
                this.p = null;
            }
            return arrayList;
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Exception exception) {
            if (this.p != null) {
                EgUtilities.closeStreams(this.p);
                this.p = null;
            }
            exception.printStackTrace();
        }
        return null;
    }

    public ArrayList getExecOutputObject(String string, Object object) {
        ArrayList<ArrayList> arrayList = new ArrayList<ArrayList>();
        InputStream[] inputStreamArray = null;
        try {
            inputStreamArray = isWindows ? this.executeProgramOnWindows(string, object) : (isLinux || isSolaris || isAix || isHpux || isOsf1 ? this.executeProgramOnUnix(string, object) : this.executeProgramOnUnix(string, object));
            if (inputStreamArray == null || inputStreamArray.length == 0) {
                return null;
            }
            EgObjectReaderThread egObjectReaderThread = new EgObjectReaderThread(inputStreamArray[0]);
            EgStreamReaderThread egStreamReaderThread = new EgStreamReaderThread(inputStreamArray[1]);
            egObjectReaderThread.start();
            egStreamReaderThread.start();
            this.p.waitFor();
            egObjectReaderThread.join();
            egStreamReaderThread.join();
            ArrayList arrayList2 = egObjectReaderThread.getData();
            ArrayList arrayList3 = egStreamReaderThread.getData();
            arrayList.add(arrayList2);
            arrayList.add(arrayList3);
            if (this.p != null) {
                EgUtilities.closeStreams(this.p);
                this.p = null;
            }
            return arrayList;
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Exception exception) {
            if (this.p != null) {
                EgUtilities.closeStreams(this.p);
                this.p = null;
            }
            exception.printStackTrace();
        }
        return null;
    }

    public ArrayList getExecOutputLines(String string, String string2) {
        ArrayList<ArrayList> arrayList = new ArrayList<ArrayList>();
        BufferedReader[] bufferedReaderArray = null;
        if (string2 == null || string2.length() == 0) {
            string2 = defaultEncoding;
        }
        boolean bl = false;
        if (string != null && string.indexOf("java") >= 0) {
            bl = true;
        }
        try {
            bufferedReaderArray = isWindows ? this.executeProgramOnWindows(string, true, string2) : (isLinux || isSolaris || isAix || isHpux || isOsf1 ? this.executeProgramOnUnix(string, true) : this.executeProgramOnUnix(string, true));
            EgStreamReaderThread egStreamReaderThread = new EgStreamReaderThread(bufferedReaderArray[0]);
            EgStreamReaderThread egStreamReaderThread2 = new EgStreamReaderThread(bufferedReaderArray[1]);
            egStreamReaderThread.start();
            egStreamReaderThread2.start();
            this.p.waitFor();
            egStreamReaderThread.join();
            egStreamReaderThread2.join();
            ArrayList arrayList2 = egStreamReaderThread.getData();
            ArrayList arrayList3 = egStreamReaderThread2.getData();
            if (EgStreamReaderThread.reRun) {
                bufferedReaderArray = this.executeProgramOnWindows(string, true);
                egStreamReaderThread = new EgStreamReaderThread(bufferedReaderArray[0]);
                egStreamReaderThread2 = new EgStreamReaderThread(bufferedReaderArray[1]);
                egStreamReaderThread.start();
                egStreamReaderThread2.start();
                this.p.waitFor();
                egStreamReaderThread.join();
                egStreamReaderThread2.join();
                arrayList2 = egStreamReaderThread.getData();
                arrayList3 = egStreamReaderThread2.getData();
            }
            if (bl) {
                ArrayList arrayList4 = new ArrayList();
                for (int i = 0; i < arrayList2.size(); ++i) {
                    String string3 = (String)arrayList2.get(i);
                    if (string3.indexOf("[warning]") >= 0 && string3.indexOf("Duplicate cpuset controllers") >= 0) continue;
                    arrayList4.add(string3);
                }
                arrayList2 = arrayList4;
            }
            arrayList.add(arrayList2);
            arrayList.add(arrayList3);
            if (this.p != null) {
                EgUtilities.closeStreams(this.p);
                this.p = null;
            }
            return arrayList;
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Exception exception) {
            if (this.p != null) {
                EgUtilities.closeStreams(this.p);
                this.p = null;
            }
            exception.printStackTrace();
        }
        return null;
    }

    public ArrayList getExecOutputLines(String[] stringArray) {
        Object object;
        ArrayList arrayList = new ArrayList();
        BufferedReader[] bufferedReaderArray = null;
        boolean bl = false;
        if (stringArray != null) {
            try {
                object = Arrays.asList(stringArray).toString();
                if (object != null && ((String)object).indexOf("java") >= 0) {
                    bl = true;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        try {
            if (isWindows) {
                if (osLanguage != null && !osLanguage.equals("ENU")) {
                    arrayList = this.getExecOutputLines(stringArray, encoding);
                    return arrayList;
                }
                bufferedReaderArray = this.executeProgramOnWindows(stringArray[0], true);
            } else if (isLinux || isSolaris || isAix || isHpux) {
                bufferedReaderArray = this.executeProgramOnUnix(stringArray, true);
            }
            if (bufferedReaderArray == null || bufferedReaderArray.length == 0) {
                return null;
            }
            object = new EgStreamReaderThread(bufferedReaderArray[0]);
            EgStreamReaderThread egStreamReaderThread = new EgStreamReaderThread(bufferedReaderArray[1]);
            ((Thread)object).start();
            egStreamReaderThread.start();
            this.p.waitFor();
            ((Thread)object).join();
            egStreamReaderThread.join();
            ArrayList<String> arrayList2 = ((EgStreamReaderThread)object).getData();
            ArrayList arrayList3 = egStreamReaderThread.getData();
            if (bl) {
                ArrayList<String> arrayList4 = new ArrayList<String>();
                for (int i = 0; i < arrayList2.size(); ++i) {
                    String string = (String)arrayList2.get(i);
                    if (string.indexOf("[warning]") >= 0 && string.indexOf("Duplicate cpuset controllers") >= 0) continue;
                    arrayList4.add(string);
                }
                arrayList2 = arrayList4;
            }
            arrayList.add(arrayList2);
            arrayList.add(arrayList3);
            if (this.p != null) {
                EgUtilities.closeStreams(this.p);
                this.p = null;
            }
            return arrayList;
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Exception exception) {
            if (this.p != null) {
                EgUtilities.closeStreams(this.p);
                this.p = null;
            }
            exception.printStackTrace();
        }
        return null;
    }

    public ArrayList getExecOutputLines(String[] stringArray, String string) {
        Object object;
        ArrayList<ArrayList> arrayList = new ArrayList<ArrayList>();
        BufferedReader[] bufferedReaderArray = null;
        if (string == null || string.equals("")) {
            string = defaultEncoding;
        }
        boolean bl = false;
        if (stringArray != null) {
            try {
                object = Arrays.asList(stringArray).toString();
                if (object != null && ((String)object).indexOf("java") >= 0) {
                    bl = true;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        try {
            if (isWindows) {
                bufferedReaderArray = this.executeProgramOnWindows(stringArray[0], true, string);
            } else if (isLinux || isSolaris || isAix || isHpux) {
                bufferedReaderArray = this.executeProgramOnUnix(stringArray, true);
            }
            object = new EgStreamReaderThread(bufferedReaderArray[0]);
            EgStreamReaderThread egStreamReaderThread = new EgStreamReaderThread(bufferedReaderArray[1]);
            ((Thread)object).start();
            egStreamReaderThread.start();
            this.p.waitFor();
            ((Thread)object).join();
            egStreamReaderThread.join();
            ArrayList arrayList2 = ((EgStreamReaderThread)object).getData();
            ArrayList arrayList3 = egStreamReaderThread.getData();
            if (EgStreamReaderThread.reRun) {
                bufferedReaderArray = this.executeProgramOnWindows(stringArray[0], true);
                object = new EgStreamReaderThread(bufferedReaderArray[0]);
                egStreamReaderThread = new EgStreamReaderThread(bufferedReaderArray[1]);
                ((Thread)object).start();
                egStreamReaderThread.start();
                this.p.waitFor();
                ((Thread)object).join();
                egStreamReaderThread.join();
                arrayList2 = ((EgStreamReaderThread)object).getData();
                arrayList3 = egStreamReaderThread.getData();
            }
            if (bl) {
                ArrayList arrayList4 = new ArrayList();
                for (int i = 0; i < arrayList2.size(); ++i) {
                    String string2 = (String)arrayList2.get(i);
                    if (string2.indexOf("[warning]") >= 0 && string2.indexOf("Duplicate cpuset controllers") >= 0) continue;
                    arrayList4.add(string2);
                }
                arrayList2 = arrayList4;
            }
            arrayList.add(arrayList2);
            arrayList.add(arrayList3);
            if (this.p != null) {
                EgUtilities.closeStreams(this.p);
                this.p = null;
            }
            return arrayList;
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Exception exception) {
            if (this.p != null) {
                EgUtilities.closeStreams(this.p);
                this.p = null;
            }
            exception.printStackTrace();
        }
        return null;
    }

    public ArrayList getExecOutputLinesForUnix(String string, String[] stringArray) {
        ArrayList<ArrayList> arrayList = new ArrayList<ArrayList>();
        BufferedReader[] bufferedReaderArray = null;
        boolean bl = false;
        if (string != null && string.indexOf("java") >= 0) {
            bl = true;
        }
        try {
            bufferedReaderArray = this.executeProgramOnUnix(string, stringArray, true);
            if (bufferedReaderArray == null || bufferedReaderArray.length == 0) {
                return null;
            }
            EgStreamReaderThread egStreamReaderThread = new EgStreamReaderThread(bufferedReaderArray[0]);
            EgStreamReaderThread egStreamReaderThread2 = new EgStreamReaderThread(bufferedReaderArray[1]);
            egStreamReaderThread.start();
            egStreamReaderThread2.start();
            this.p.waitFor();
            ArrayList<String> arrayList2 = egStreamReaderThread.getData();
            ArrayList arrayList3 = egStreamReaderThread2.getData();
            if (bl) {
                ArrayList<String> arrayList4 = new ArrayList<String>();
                for (int i = 0; i < arrayList2.size(); ++i) {
                    String string2 = (String)arrayList2.get(i);
                    if (string2.indexOf("[warning]") >= 0 && string2.indexOf("Duplicate cpuset controllers") >= 0) continue;
                    arrayList4.add(string2);
                }
                arrayList2 = arrayList4;
            }
            arrayList.add(arrayList2);
            arrayList.add(arrayList3);
            if (this.p != null) {
                EgUtilities.closeStreams(this.p);
                this.p = null;
            }
            return arrayList;
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Exception exception) {
            if (this.p != null) {
                EgUtilities.closeStreams(this.p);
                this.p = null;
            }
            exception.printStackTrace();
        }
        return null;
    }

    public void setLogFile(String string) {
        this.s_logFileName = string;
    }

    private boolean openLogFile() {
        if (this.s_logFileName == null || this.s_logFileName.equals("")) {
            return false;
        }
        try {
            this.logWriter = new PrintWriter(new FileWriter(this.s_logFileName, true));
            return true;
        }
        catch (Exception exception) {
            System.err.println("Cannot open log file ");
            return false;
        }
    }

    private boolean closeLogFile() {
        try {
            if (this.logWriter != null) {
                this.logWriter.close();
                this.logWriter = null;
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void logToLogFile(String string, String string2, String string3) {
        if (!this.b_loggerDebug) {
            return;
        }
        if (!this.openLogFile() || this.logWriter == null) {
            System.out.println("First open the log file by calling openLogFile(filename) method");
            System.err.println("First open the log file by calling openLogFile(filename) method");
            return;
        }
        String string4 = this.getDateInDefaultFormat();
        String string5 = new String(string4 + " " + string + " " + string2 + ": " + string3);
        this.logWriter.println(string5);
        this.logWriter.flush();
        this.closeLogFile();
    }

    public String getDateInDefaultFormat() {
        return this.getDateInFormat(null);
    }

    public String getDateInFormat(String string) {
        String string2 = "dd/MM/yyyy HH:mm:ss";
        if (string != null && string.length() > 0) {
            string2 = string;
        }
        String string3 = null;
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2);
            string3 = simpleDateFormat.format(new Date());
        }
        catch (Exception exception) {
            return null;
        }
        return string3;
    }

    public String replace(String string, String string2, String string3) {
        if (string == null || string2 == null || string2.length() == 0 || string3 == null) {
            return string;
        }
        String string4 = string;
        int n = 0;
        int n2 = string4.indexOf(string2, n);
        if (n2 < 0) {
            return string;
        }
        int n3 = string2.length();
        int n4 = string3.length() - n3;
        n4 = n4 < 0 ? 0 : n4;
        StringBuilder stringBuilder = new StringBuilder(string.length() + (n4 *= 16));
        while (n2 >= 0) {
            stringBuilder.append(string, n, n2).append(string3);
            n = n2 + n3;
            n2 = string4.indexOf(string2, n);
        }
        stringBuilder.append(string, n, string.length());
        return stringBuilder.toString();
    }

    public long getSystemUTCDate() {
        long l = -1L;
        try {
            l = System.currentTimeMillis();
            if (l > this.prev_time) {
                this.prev_time = l;
                this.time_flag = 0;
            } else {
                while (this.prev_time > l) {
                    l = System.currentTimeMillis();
                    if (l > this.prev_time) {
                        this.prev_time = l;
                        this.time_flag = 0;
                        return l;
                    }
                    ++this.time_flag;
                    if (this.time_flag <= 20) continue;
                    this.time_flag = -1;
                    this.prev_time = 0L;
                    this.fsop("getSystemUTCDate:Invalid SystemTime from java");
                    return -1L;
                }
            }
            return l;
        }
        catch (Exception exception) {
            this.fsop("getSystemUTCDate:GONE CASE IN System.currentTimeMillis");
            this.time_flag = -1;
            return -1L;
        }
    }

    public long egetUTCDate() {
        long l = this.getSystemUTCDate();
        if (l == -1L) {
            this.fsop("egetUTCDate:Invalid Date");
            return -1L;
        }
        return l + this.time_diff;
    }

    public void suspendForPeriod(long l) {
        long l2 = this.egetUTCDate() + l;
        while (l > 0L) {
            if (l < 100L) {
                l = 100L;
            }
            try {
                Thread.currentThread();
                Thread.sleep(l);
            }
            catch (Exception exception) {
                // empty catch block
            }
            long l3 = this.egetUTCDate();
            l = l2 - l3;
        }
    }

    public boolean checkForTimeout(EgCheckConnUtil egCheckConnUtil, long l) {
        long l2;
        long l3 = 0L;
        long l4 = 250L;
        this.timeout = l;
        do {
            this.suspendForPeriod(l4);
            if (egCheckConnUtil.done) {
                return true;
            }
            if ((l3 += l4) >= this.timeout) {
                egCheckConnUtil.interrupt();
                Thread.currentThread();
                Thread.yield();
                egCheckConnUtil.stop();
                return false;
            }
            l2 = l4;
            if (this.timeout - l3 >= l2) continue;
            l2 = this.timeout - l3;
        } while ((l4 = l2) > 0L);
        egCheckConnUtil.interrupt();
        Thread.currentThread();
        Thread.yield();
        egCheckConnUtil.stop();
        return false;
    }

    public void printHashtable(Hashtable hashtable) {
        if (hashtable == null || hashtable.size() == 0) {
            this.fsop("The Hashtable is null or empty");
            return;
        }
        Enumeration enumeration = hashtable.keys();
        this.fsop("Key:Value pairs follow below for the hastable");
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)hashtable.get(string);
            this.fsop(string + ":" + string2);
        }
    }

    public boolean isNumber(String string) {
        if (string.indexOf(".") < 0) {
            return false;
        }
        try {
            Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    public boolean isIPAddress(String string) {
        String string2;
        int n;
        if (string == null || string.length() == 0) {
            return false;
        }
        int n2 = 0;
        int n3 = string.length();
        for (n = 0; n < n3; ++n) {
            string2 = "" + string.charAt(n);
            if (!string2.equals(".")) continue;
            ++n2;
        }
        if (n2 != 3) {
            return false;
        }
        for (n = 0; n < n3; ++n) {
            string2 = "" + string.charAt(n);
            if (string2.equals("0") || string2.equals("1") || string2.equals("2") || string2.equals("3") || string2.equals("4") || string2.equals("5") || string2.equals("6") || string2.equals("7") || string2.equals("8") || string2.equals("9") || string2.equals(".")) continue;
            return false;
        }
        return true;
    }

    public boolean setSystemOut(String string) {
        try {
            System.setOut(new PrintStream(new FileOutputStream(string, true)));
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean setSystemErr(String string) {
        try {
            System.setErr(new PrintStream(new FileOutputStream(string, true)));
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public int indexOfIgnoreCase(String string, String string2) {
        if (string == null || string.length() == 0) {
            return -1;
        }
        if (string2 == null || string2.length() == 0) {
            return -1;
        }
        string = string.toUpperCase();
        string2 = string2.toUpperCase();
        int n = string.indexOf(string2);
        return n;
    }

    public void destroyProcess() {
        if (this.p != null) {
            EgUtilities.closeStreams(this.p);
            this.p = null;
        }
    }

    public ArrayList getExecOutputLinesForUnix(String string) {
        ArrayList<ArrayList> arrayList = new ArrayList<ArrayList>();
        BufferedReader[] bufferedReaderArray = null;
        try {
            boolean bl = false;
            if (string != null && string.indexOf("java") >= 0) {
                bl = true;
            }
            if ((bufferedReaderArray = this.executeProgramOnUnix(string, true)) == null || bufferedReaderArray.length == 0) {
                return null;
            }
            EgStreamReaderThread egStreamReaderThread = new EgStreamReaderThread(bufferedReaderArray[0]);
            EgStreamReaderThread egStreamReaderThread2 = new EgStreamReaderThread(bufferedReaderArray[1]);
            egStreamReaderThread.start();
            egStreamReaderThread2.start();
            this.p.waitFor();
            egStreamReaderThread.join();
            egStreamReaderThread2.join();
            ArrayList<String> arrayList2 = egStreamReaderThread.getData();
            ArrayList arrayList3 = egStreamReaderThread2.getData();
            if (bl) {
                ArrayList<String> arrayList4 = new ArrayList<String>();
                for (int i = 0; i < arrayList2.size(); ++i) {
                    String string2 = (String)arrayList2.get(i);
                    if (string2.indexOf("[warning]") >= 0 && string2.indexOf("Duplicate cpuset controllers") >= 0) continue;
                    arrayList4.add(string2);
                }
                arrayList2 = arrayList4;
            }
            arrayList.add(arrayList2);
            arrayList.add(arrayList3);
            if (this.p != null) {
                EgUtilities.closeStreams(this.p);
                this.p = null;
            }
            return arrayList;
        }
        catch (Exception exception) {
            if (this.p != null) {
                EgUtilities.closeStreams(this.p);
                this.p = null;
            }
            exception.printStackTrace();
            return null;
        }
    }

    public ArrayList getCommandOutputLines(String string) {
        return this.getCommandOutputLines(string, false);
    }

    public ArrayList getCommandOutputLines(String string, boolean bl) {
        String[] stringArray = null;
        if (bl || string.indexOf("|") > 0) {
            ArrayList<String> arrayList;
            block11: {
                boolean bl2 = false;
                if (string.indexOf("java") >= 0) {
                    bl2 = true;
                }
                String string2 = this.getShell();
                stringArray = new String[]{string2, "-c", string};
                arrayList = new ArrayList<String>();
                Runtime runtime = Runtime.getRuntime();
                BufferedReader bufferedReader = null;
                Process process = null;
                try {
                    process = runtime.exec(stringArray);
                    bufferedReader = useUTF8 ? new BufferedReader(new InputStreamReader(process.getInputStream(), "UTF-8")) : new BufferedReader(new InputStreamReader(process.getInputStream()));
                    String string3 = null;
                    while ((string3 = bufferedReader.readLine()) != null) {
                        if (bl2 && string3.indexOf("[warning]") >= 0 && string3.indexOf("Duplicate cpuset controllers") >= 0) continue;
                        arrayList.add(string3);
                    }
                    bufferedReader.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    if (bufferedReader != null) {
                        try {
                            bufferedReader.close();
                        }
                        catch (Exception exception2) {
                            // empty catch block
                        }
                    }
                    if (process == null) break block11;
                    try {
                        EgUtilities.closeStreams(process);
                    }
                    catch (Exception exception3) {
                        // empty catch block
                    }
                }
            }
            return arrayList;
        }
        ArrayList arrayList = this.getExecOutputLines(string);
        if (arrayList == null || arrayList.size() == 0) {
            return null;
        }
        return (ArrayList)arrayList.get(0);
    }

    public ArrayList getCommandOutputLines(String string, boolean bl, boolean bl2) {
        String[] stringArray = null;
        if (bl2 && (string.indexOf("|") > 0 || bl)) {
            Object object;
            ArrayList<Object> arrayList;
            ArrayList<Object> arrayList2;
            block12: {
                boolean bl3 = false;
                if (string.indexOf("java") >= 0) {
                    bl3 = true;
                }
                String string2 = this.getShell();
                stringArray = new String[]{string2, "-c", string};
                arrayList2 = new ArrayList<Object>();
                arrayList = new ArrayList<Object>();
                Runtime runtime = Runtime.getRuntime();
                BufferedReader bufferedReader = null;
                Process process = null;
                try {
                    process = runtime.exec(stringArray);
                    bufferedReader = useUTF8 ? new BufferedReader(new InputStreamReader(process.getInputStream(), "UTF-8")) : new BufferedReader(new InputStreamReader(process.getInputStream()));
                    object = null;
                    while ((object = bufferedReader.readLine()) != null) {
                        if (bl3 && ((String)object).indexOf("[warning]") >= 0 && ((String)object).indexOf("Duplicate cpuset controllers") >= 0) continue;
                        arrayList2.add(object);
                    }
                    bufferedReader = useUTF8 ? new BufferedReader(new InputStreamReader(process.getErrorStream(), "UTF-8")) : new BufferedReader(new InputStreamReader(process.getErrorStream()));
                    object = null;
                    while ((object = bufferedReader.readLine()) != null) {
                        arrayList.add(object);
                    }
                    bufferedReader.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    if (bufferedReader != null) {
                        try {
                            bufferedReader.close();
                        }
                        catch (Exception exception2) {
                            // empty catch block
                        }
                    }
                    if (process == null) break block12;
                    try {
                        EgUtilities.closeStreams(process);
                    }
                    catch (Exception exception3) {
                        // empty catch block
                    }
                }
            }
            object = new ArrayList<ArrayList<Object>>();
            ((ArrayList)object).add(arrayList2);
            ((ArrayList)object).add(arrayList);
            return object;
        }
        ArrayList arrayList = this.getExecOutputLines(string);
        if (arrayList == null || arrayList.size() == 0) {
            return null;
        }
        return arrayList;
    }

    public ArrayList getCommandOutputLines(String string, boolean bl, boolean bl2, boolean bl3) {
        String[] stringArray = null;
        if (bl2 && bl) {
            Object object;
            ArrayList<Object> arrayList;
            ArrayList<Object> arrayList2;
            block12: {
                boolean bl4 = false;
                if (string.indexOf("java") >= 0) {
                    bl4 = true;
                }
                String string2 = this.getShell();
                stringArray = new String[]{string2, "-c", string};
                arrayList2 = new ArrayList<Object>();
                arrayList = new ArrayList<Object>();
                Runtime runtime = Runtime.getRuntime();
                BufferedReader bufferedReader = null;
                Process process = null;
                try {
                    process = runtime.exec(stringArray);
                    bufferedReader = useUTF8 ? new BufferedReader(new InputStreamReader(process.getInputStream(), "UTF-8")) : new BufferedReader(new InputStreamReader(process.getInputStream()));
                    object = null;
                    while ((object = bufferedReader.readLine()) != null) {
                        if (bl4 && ((String)object).indexOf("[warning]") >= 0 && ((String)object).indexOf("Duplicate cpuset controllers") >= 0) continue;
                        arrayList2.add(object);
                    }
                    bufferedReader = useUTF8 ? new BufferedReader(new InputStreamReader(process.getErrorStream(), "UTF-8")) : new BufferedReader(new InputStreamReader(process.getErrorStream()));
                    object = null;
                    while ((object = bufferedReader.readLine()) != null) {
                        arrayList.add(object);
                    }
                    bufferedReader.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    if (bufferedReader != null) {
                        try {
                            bufferedReader.close();
                        }
                        catch (Exception exception2) {
                            // empty catch block
                        }
                    }
                    if (process == null) break block12;
                    try {
                        EgUtilities.closeStreams(process);
                    }
                    catch (Exception exception3) {
                        // empty catch block
                    }
                }
            }
            object = new ArrayList<ArrayList<Object>>();
            ((ArrayList)object).add(arrayList2);
            ((ArrayList)object).add(arrayList);
            return object;
        }
        ArrayList arrayList = this.getExecOutputLines(string);
        if (arrayList == null || arrayList.size() == 0) {
            return null;
        }
        return arrayList;
    }

    public String getShell() {
        if (!isShellSet) {
            File file = new File("/bin/sh");
            try {
                if (file.exists()) {
                    shellName = "/bin/sh";
                    isShellSet = true;
                    return shellName;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            file = new File("/usr/bin/sh");
            try {
                if (file.exists()) {
                    shellName = "/usr/bin/sh";
                    isShellSet = true;
                    return shellName;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ArrayList arrayList = this.getExecOutputLines("/usr/bin/which sh");
            if (arrayList == null || arrayList.size() == 0) {
                System.out.println("Could not get shell....");
                return " ";
            }
            ArrayList arrayList2 = (ArrayList)arrayList.get(0);
            if (arrayList2 == null || arrayList2.size() == 0) {
                return " ";
            }
            shellName = (String)arrayList2.get(0);
            isShellSet = true;
            return shellName;
        }
        return shellName;
    }

    public static void main(String[] stringArray) {
        EgUtilities egUtilities = new EgUtilities();
        String[] stringArray2 = egUtilities.getIpAddressesOfHost();
        for (int i = 0; i < stringArray2.length; ++i) {
            System.out.println(stringArray2[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getSyncExecOutputLinesForPSCommand(String string) {
        block8: {
            try {
                long l = 0L;
                File file = new File(path);
                if (!file.exists()) {
                    file.createNewFile();
                }
                if ((l = file.lastModified()) <= lastmodifiedtime) break block8;
                lastmodifiedtime = l;
                IniFile iniFile = new IniFile(path, true);
                String string2 = iniFile.getValue("O365_Settings", "ConcurrentScriptsCount");
                if (string2 != "") {
                    int n = Integer.parseInt(string2.trim());
                    if ((long)n != maxO365Concurrent) {
                        maxO365Concurrent = n;
                    }
                    break block8;
                }
                String string3 = path;
                synchronized (string3) {
                    iniFile.setValue(new String("O365_Settings"), new String("ConcurrentScriptsCount"), new String(String.valueOf(maxO365Concurrent)));
                    iniFile.saveFile();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.lock();
        ArrayList arrayList = this.getExecOutputLinesForPSCommand(string);
        this.unlock();
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock() {
        while (true) {
            if (inProgressO365Count < maxO365Concurrent) {
                String string = O365syncString;
                synchronized (string) {
                    if (inProgressO365Count < maxO365Concurrent) {
                        ++inProgressO365Count;
                        return;
                    }
                }
            }
            try {
                Thread.sleep(50L);
            }
            catch (Exception exception) {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock() {
        String string = O365syncString;
        synchronized (string) {
            if (--inProgressO365Count < 0L) {
                inProgressO365Count = 0L;
            }
        }
    }

    public ArrayList getExecOutputLinesForPSCommand(String string) {
        return this.getExecOutputLinesForPSCommand("none", string);
    }

    public ArrayList getExecOutputLinesForPSCommand(String string, String string2, long l) {
        return this.getExecOutputLinesForPSCommand("none", string, string2, l);
    }

    private String[] setArgumentsForPSCommand(String string, String string2) {
        String string3 = "RemoteSigned";
        String[] stringArray = new String[]{cmdPath, " /c", " powershell", " -PSConsoleFile ", "\"" + string + "\"", " -InputFormat none -ExecutionPolicy " + string3 + " -Command ", "\"" + string2 + "\""};
        return stringArray;
    }

    private String[] setArgumentsForPSCommand(String string) {
        String string2 = "RemoteSigned";
        String[] stringArray = new String[]{cmdPath, " /c", " powershell -InputFormat none -ExecutionPolicy " + string2 + " -Command ", "\"" + string + "\""};
        return stringArray;
    }

    public ArrayList getExecOutputLinesForPSCommand(String string, String string2) {
        ArrayList<ArrayList> arrayList = new ArrayList<ArrayList>();
        BufferedReader[] bufferedReaderArray = null;
        try {
            bufferedReaderArray = this.executeProgramOnPowerShell(string, string2);
            if (bufferedReaderArray == null || bufferedReaderArray.length == 0) {
                return null;
            }
            EgStreamReaderThread egStreamReaderThread = new EgStreamReaderThread(bufferedReaderArray[0]);
            EgStreamReaderThread egStreamReaderThread2 = new EgStreamReaderThread(bufferedReaderArray[1]);
            egStreamReaderThread.start();
            egStreamReaderThread2.start();
            this.p.waitFor();
            egStreamReaderThread.join();
            egStreamReaderThread2.join();
            ArrayList arrayList2 = egStreamReaderThread.getData();
            ArrayList arrayList3 = egStreamReaderThread2.getData();
            arrayList.add(arrayList2);
            arrayList.add(arrayList3);
            if (this.p != null) {
                EgUtilities.closeStreams(this.p);
                this.p = null;
            }
            return arrayList;
        }
        catch (Exception exception) {
            if (this.p != null) {
                EgUtilities.closeStreams(this.p);
                this.p = null;
            }
            exception.printStackTrace();
            return null;
        }
    }

    public ArrayList getExecOutputLinesForPSCommand(String string, String string2, String string3, long l) {
        long l2 = l;
        long l3 = 0L;
        ArrayList<ArrayList> arrayList = new ArrayList<ArrayList>();
        BufferedReader[] bufferedReaderArray = null;
        try {
            bufferedReaderArray = this.executeProgramOnPowerShell(string, string2);
            if (bufferedReaderArray == null || bufferedReaderArray.length == 0) {
                return null;
            }
            EgStreamReaderThread egStreamReaderThread = new EgStreamReaderThread(bufferedReaderArray[0]);
            EgStreamReaderThread egStreamReaderThread2 = new EgStreamReaderThread(bufferedReaderArray[1]);
            egStreamReaderThread.start();
            egStreamReaderThread2.start();
            long l4 = 1L;
            while (!egStreamReaderThread.done && !egStreamReaderThread2.done) {
                ArrayList arrayList2;
                Thread.sleep(l4 * 1000L);
                l4 = 2L;
                if ((l3 += l4) <= l2) continue;
                egStreamReaderThread.done = true;
                egStreamReaderThread2.done = true;
                egStreamReaderThread.join(1000L);
                egStreamReaderThread2.join(1000L);
                try {
                    egStreamReaderThread.interrupt();
                    Thread.currentThread();
                    Thread.yield();
                    egStreamReaderThread.stop();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    egStreamReaderThread2.interrupt();
                    Thread.currentThread();
                    Thread.yield();
                    egStreamReaderThread2.stop();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.p != null) {
                    try {
                        EgUtilities.closeStreams(this.p);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (string3 != null && string3.length() > 0 && (arrayList2 = this.getPid(string3)) != null && arrayList2.size() > 0) {
                        this.killProcesses(arrayList2);
                    }
                    this.p = null;
                }
                if (this.p != null) {
                    // empty if block
                }
                egStreamReaderThread = null;
                egStreamReaderThread2 = null;
                arrayList2 = new ArrayList();
                arrayList2.add("Command execution was timed out");
                arrayList.add(arrayList2);
                return arrayList;
            }
            this.p.waitFor();
            ArrayList arrayList3 = null;
            ArrayList arrayList4 = null;
            if (egStreamReaderThread != null) {
                egStreamReaderThread.join();
                arrayList3 = egStreamReaderThread.getData();
            }
            if (egStreamReaderThread2 != null) {
                egStreamReaderThread2.join();
                arrayList4 = egStreamReaderThread2.getData();
            }
            if (arrayList3 != null) {
                arrayList.add(arrayList3);
            }
            if (arrayList4 != null) {
                arrayList.add(arrayList4);
            }
            if (this.p != null) {
                EgUtilities.closeStreams(this.p);
                this.p = null;
            }
            return arrayList;
        }
        catch (Exception exception) {
            if (this.p != null) {
                EgUtilities.closeStreams(this.p);
                this.p = null;
            }
            exception.printStackTrace();
            return null;
        }
    }

    public BufferedReader[] executeProgramOnPowerShell(String string, String string2) {
        string2 = string2.trim();
        String[] stringArray = null;
        stringArray = "none".equalsIgnoreCase(string) ? this.setArgumentsForPSCommand(string2) : this.setArgumentsForPSCommand(string, string2);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer = stringBuffer.append(stringArray[i]);
        }
        Runtime runtime = Runtime.getRuntime();
        String string3 = stringBuffer.toString();
        try {
            this.p = runtime.exec(string3);
            this.p.getOutputStream().close();
            BufferedReader[] bufferedReaderArray = new BufferedReader[2];
            bufferedReaderArray[1] = new BufferedReader(new InputStreamReader(this.p.getErrorStream(), "UTF-8"));
            bufferedReaderArray[0] = new BufferedReader(new InputStreamReader(this.p.getInputStream(), "UTF-8"));
            return bufferedReaderArray;
        }
        catch (Exception exception) {
            this.p = null;
            exception.printStackTrace();
            return null;
        }
    }

    public ArrayList getExecOutputLinesFor32BitPSCommand(String string) {
        return this.getExecOutputLinesFor32BitPSCommand("none", string, "none");
    }

    public ArrayList getExecOutputLinesFor32BitPSCommand(String string, String string2) {
        return this.getExecOutputLinesFor32BitPSCommand(string, string2, "none");
    }

    public ArrayList getExecOutputLinesFor32BitPSCommand(String string, String string2, String string3) {
        ArrayList<ArrayList> arrayList = new ArrayList<ArrayList>();
        BufferedReader[] bufferedReaderArray = null;
        try {
            bufferedReaderArray = this.executeProgramOnPowerShell32Bit(string, string2, string3);
            if (bufferedReaderArray == null || bufferedReaderArray.length == 0) {
                return null;
            }
            EgStreamReaderThread egStreamReaderThread = new EgStreamReaderThread(bufferedReaderArray[0]);
            EgStreamReaderThread egStreamReaderThread2 = new EgStreamReaderThread(bufferedReaderArray[1]);
            egStreamReaderThread.start();
            egStreamReaderThread2.start();
            this.p.waitFor();
            egStreamReaderThread.join();
            egStreamReaderThread2.join();
            ArrayList arrayList2 = egStreamReaderThread.getData();
            ArrayList arrayList3 = egStreamReaderThread2.getData();
            arrayList.add(arrayList2);
            arrayList.add(arrayList3);
            if (this.p != null) {
                EgUtilities.closeStreams(this.p);
                this.p = null;
            }
            return arrayList;
        }
        catch (Exception exception) {
            if (this.p != null) {
                EgUtilities.closeStreams(this.p);
                this.p = null;
            }
            exception.printStackTrace();
            return null;
        }
    }

    private String[] setArgumentsFor32BitPSCommand(String string, String string2) {
        String string3 = "";
        String string4 = "";
        String string5 = System.getProperty("os.arch");
        String string6 = System.getenv("windir");
        String string7 = "RemoteSigned";
        if (string5 != null && string6 != null) {
            if (string5.indexOf("64") >= 0) {
                string3 = string6 + "/Syswow64/WindowsPowerShell/v1.0/powershell.exe";
                string4 = string6 + "/Syswow64/cmd.exe";
            } else {
                string3 = string6 + "/System32/WindowsPowerShell/v1.0/powershell.exe";
                string4 = string6 + "/System32/cmd.exe";
            }
            if (string2.equalsIgnoreCase("none")) {
                String[] stringArray = new String[]{string4, " /c ", string3, " -InputFormat none -ExecutionPolicy " + string7 + " -Command ", "\"" + string + "\""};
                return stringArray;
            }
            String[] stringArray = new String[]{string4, " /c ", string2, " " + string3, " -InputFormat none -ExecutionPolicy " + string7 + " -Command ", "\"" + string + "\""};
            return stringArray;
        }
        String[] stringArray = new String[]{cmdPath, " /c ", "powershell -InputFormat none -ExecutionPolicy " + string7 + " -Command ", "\"" + string + "\""};
        return stringArray;
    }

    private String[] setArgumentsFor32BitPSCommand(String string, String string2, String string3) {
        String string4 = "";
        String string5 = "";
        String string6 = System.getProperty("os.arch");
        String string7 = System.getenv("windir");
        String string8 = "RemoteSigned";
        if (string6 != null && string7 != null) {
            if (string6.indexOf("64") >= 0) {
                string4 = string7 + "/Syswow64/WindowsPowerShell/v1.0/powershell.exe";
                string5 = string7 + "/Syswow64/cmd.exe";
            } else {
                string4 = string7 + "/System32/WindowsPowerShell/v1.0/powershell.exe";
                string5 = string7 + "/System32/cmd.exe";
            }
            if (string3.equalsIgnoreCase("none")) {
                String[] stringArray = new String[]{string5, " /c ", string4, " -PSConsoleFile ", "\"" + string + "\"", " -InputFormat none -ExecutionPolicy " + string8 + " -Command ", "\"" + string2 + "\""};
                return stringArray;
            }
            String[] stringArray = new String[]{string5, " /c ", string3, " " + string4, " -PSConsoleFile ", "\"" + string + "\"", " -InputFormat none -ExecutionPolicy " + string8 + " -Command ", "\"" + string2 + "\""};
            return stringArray;
        }
        String[] stringArray = new String[]{cmdPath, " /c ", "powershell", " -PSConsoleFile ", "\"" + string + "\"", " -InputFormat none -ExecutionPolicy " + string8 + " -Command ", "\"" + string2 + "\""};
        return stringArray;
    }

    public BufferedReader[] executeProgramOnPowerShell32Bit(String string, String string2, String string3) {
        string2 = string2.trim();
        String[] stringArray = null;
        stringArray = "none".equalsIgnoreCase(string) ? this.setArgumentsFor32BitPSCommand(string2, string3) : this.setArgumentsFor32BitPSCommand(string, string2, string3);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer = stringBuffer.append(stringArray[i]);
        }
        Runtime runtime = Runtime.getRuntime();
        String string4 = stringBuffer.toString();
        try {
            this.p = runtime.exec(string4);
            this.p.getOutputStream().close();
            BufferedReader[] bufferedReaderArray = new BufferedReader[2];
            bufferedReaderArray[1] = new BufferedReader(new InputStreamReader(this.p.getErrorStream(), "UTF-8"));
            bufferedReaderArray[0] = new BufferedReader(new InputStreamReader(this.p.getInputStream(), "UTF-8"));
            return bufferedReaderArray;
        }
        catch (Exception exception) {
            this.p = null;
            exception.printStackTrace();
            return null;
        }
    }

    public boolean killJavaProcesses(String string) {
        block8: {
            ArrayList arrayList;
            ArrayList arrayList2;
            block9: {
                EgTesterInfo egTesterInfo = new EgTesterInfo(string);
                arrayList2 = egTesterInfo.getJavaProcesses();
                if (arrayList2 == null || arrayList2.size() <= 0) break block8;
                if (!isWindows) break block9;
                EgMgrAppPid egMgrAppPid = new EgMgrAppPid();
                Hashtable hashtable = egMgrAppPid.execute();
                Set set = hashtable.keySet();
                Iterator iterator = set.iterator();
                boolean bl = false;
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    String string3 = (String)hashtable.get(string2);
                    for (int i = 0; i < arrayList2.size(); ++i) {
                        if (string3.indexOf("java") < 0 || string3.indexOf((String)arrayList2.get(i)) < 0) continue;
                        this.getExecOutputLines("taskkill.exe /PID " + string2 + " /F");
                    }
                }
                break block8;
            }
            String string4 = "ps auxww | grep \"java\"";
            File file = new File("/usr/ucb/ps");
            if (file.exists()) {
                string4 = "/usr/ucb/ps -axww | grep \"java\"";
            }
            if ((arrayList = this.getCommandOutputLines(string4)) == null || arrayList.size() <= 0) break block8;
            for (int i = 0; i < arrayList.size(); ++i) {
                Object object;
                String string5 = ((String)arrayList.get(i)).trim();
                String string6 = "";
                if (string5 != null && string5.indexOf(" ") > 0 && ((StringTokenizer)(object = new StringTokenizer(string5))).countTokens() > 2) {
                    string6 = ((StringTokenizer)object).nextToken();
                    try {
                        Long.parseLong(string6);
                    }
                    catch (Exception exception) {
                        string6 = ((StringTokenizer)object).nextToken();
                    }
                }
                object = string5.substring(string5.indexOf(" ") + 1);
                for (int j = 0; j < arrayList2.size(); ++j) {
                    if (((String)object).indexOf("java") < 0 || ((String)object).indexOf((String)arrayList2.get(j)) < 0) continue;
                    this.getExecOutputLines("kill -9 " + string6);
                }
            }
        }
        return true;
    }

    public static boolean isMatch(String string, String string2) {
        int n;
        if (string == null && string2 == null) {
            return true;
        }
        if (string != null && string2 == null) {
            return true;
        }
        if (string == null && string2 != null) {
            return true;
        }
        if (string2.equals("*")) {
            return true;
        }
        int n2 = string2.indexOf("*");
        if (n2 < 0) {
            return string.equalsIgnoreCase(string2);
        }
        String string3 = string.toLowerCase();
        String string4 = string2.toLowerCase();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!string4.startsWith("*")) {
            bl2 = true;
        }
        if (!string4.endsWith("*")) {
            bl3 = true;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string4, "*");
        int n3 = stringTokenizer.countTokens();
        String string5 = new String(string3);
        String[] stringArray = new String[n3];
        if (n3 <= 0) {
            return false;
        }
        for (n = 0; n < n3; ++n) {
            stringArray[n] = stringTokenizer.nextToken();
        }
        n = 0;
        if (bl2 && !string5.startsWith(stringArray[0])) {
            return false;
        }
        if (bl3 && !string5.endsWith(stringArray[n3 - 1])) {
            return false;
        }
        for (int i = 0; i < n3; ++i) {
            n = string5.indexOf(stringArray[i]);
            if (n < 0) {
                return false;
            }
            bl = true;
            string5 = string5.substring(n += stringArray[i].length());
        }
        return bl;
    }

    public static boolean isMatch(String string, String string2, boolean bl) {
        int n;
        String string3 = string;
        String string4 = string2;
        if (string == null && string2 == null) {
            return true;
        }
        if (string != null && string2 == null) {
            return true;
        }
        if (string == null && string2 != null) {
            return true;
        }
        if (string2.equals("*")) {
            return true;
        }
        int n2 = string2.indexOf("*");
        if (n2 < 0) {
            return string.equalsIgnoreCase(string2);
        }
        if (bl) {
            string3 = string.toLowerCase();
            string4 = string2.toLowerCase();
        }
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (!string4.startsWith("*")) {
            bl3 = true;
        }
        if (!string4.endsWith("*")) {
            bl4 = true;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string4, "*");
        int n3 = stringTokenizer.countTokens();
        String string5 = new String(string3);
        String[] stringArray = new String[n3];
        if (n3 <= 0) {
            return false;
        }
        for (n = 0; n < n3; ++n) {
            stringArray[n] = stringTokenizer.nextToken();
        }
        n = 0;
        if (bl3 && !string5.startsWith(stringArray[0])) {
            return false;
        }
        if (bl4 && !string5.endsWith(stringArray[n3 - 1])) {
            return false;
        }
        for (int i = 0; i < n3; ++i) {
            n = string5.indexOf(stringArray[i]);
            if (n < 0) {
                return false;
            }
            bl2 = true;
            string5 = string5.substring(n += stringArray[i].length());
        }
        return bl2;
    }

    public ArrayList getExecOutputLines(String string, long l, String string2, String string3) {
        long l2 = l;
        long l3 = 0L;
        ArrayList<ArrayList> arrayList = new ArrayList<ArrayList>();
        BufferedReader[] bufferedReaderArray = null;
        if (string3 == null || string3.equals("")) {
            string3 = defaultEncoding;
        }
        try {
            boolean bl = false;
            if (string != null && string.indexOf("java") >= 0) {
                bl = true;
            }
            if ((bufferedReaderArray = isWindows ? this.executeProgramOnWindows(string, true, string3) : (isLinux || isSolaris || isAix || isHpux || isOsf1 ? this.executeProgramOnUnix(string, true) : this.executeProgramOnUnix(string, true))) == null || bufferedReaderArray.length == 0) {
                return null;
            }
            EgStreamReaderThread egStreamReaderThread = new EgStreamReaderThread(bufferedReaderArray[0]);
            EgStreamReaderThread egStreamReaderThread2 = new EgStreamReaderThread(bufferedReaderArray[1]);
            egStreamReaderThread.start();
            egStreamReaderThread2.start();
            long l4 = 1L;
            while (!egStreamReaderThread.done && !egStreamReaderThread2.done) {
                ArrayList arrayList2;
                Thread.sleep(l4 * 1000L);
                l4 = 2L;
                if ((l3 += l4) <= l2) continue;
                egStreamReaderThread.done = true;
                egStreamReaderThread2.done = true;
                egStreamReaderThread.join(1000L);
                egStreamReaderThread2.join(1000L);
                try {
                    egStreamReaderThread.interrupt();
                    Thread.currentThread();
                    Thread.yield();
                    egStreamReaderThread.stop();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    egStreamReaderThread2.interrupt();
                    Thread.currentThread();
                    Thread.yield();
                    egStreamReaderThread2.stop();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.p != null) {
                    try {
                        EgUtilities.closeStreams(this.p);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (string2 != null && string2.length() > 0 && (arrayList2 = this.getPid(string2)) != null && arrayList2.size() > 0) {
                        this.killProcesses(arrayList2);
                    }
                    this.p = null;
                }
                if (this.p != null) {
                    // empty if block
                }
                egStreamReaderThread = null;
                egStreamReaderThread2 = null;
                arrayList2 = new ArrayList();
                arrayList2.add("Command execution was timed out");
                arrayList.add(arrayList2);
                return arrayList;
            }
            this.p.waitFor();
            ArrayList<String> arrayList3 = null;
            ArrayList arrayList4 = null;
            if (egStreamReaderThread != null) {
                egStreamReaderThread.join();
                arrayList3 = egStreamReaderThread.getData();
            }
            if (egStreamReaderThread2 != null) {
                egStreamReaderThread2.join();
                arrayList4 = egStreamReaderThread2.getData();
            }
            if (arrayList3 != null) {
                if (bl) {
                    ArrayList<String> arrayList5 = new ArrayList<String>();
                    for (int i = 0; i < arrayList3.size(); ++i) {
                        String string4 = (String)arrayList3.get(i);
                        if (string4.indexOf("[warning]") >= 0 && string4.indexOf("Duplicate cpuset controllers") >= 0) continue;
                        arrayList5.add(string4);
                    }
                    arrayList3 = arrayList5;
                }
                arrayList.add(arrayList3);
            }
            if (arrayList4 != null) {
                arrayList.add(arrayList4);
            }
            if (this.p != null) {
                EgUtilities.closeStreams(this.p);
                this.p = null;
            }
            return arrayList;
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Exception exception) {
            if (this.p != null) {
                EgUtilities.closeStreams(this.p);
                this.p = null;
            }
            exception.printStackTrace();
        }
        return null;
    }

    private static ArrayList myTokenizer(String string, String string2) {
        if (string == null || string.length() == 0) {
            return new ArrayList();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        String string3 = null;
        int n = 0;
        int n2 = string.indexOf(string2);
        int n3 = string2.length();
        while (n2 >= 0) {
            string3 = string.substring(n, n2).trim();
            arrayList.add(string3);
            n = n2 + n3;
            n2 = string.indexOf(string2, n);
        }
        string3 = string.substring(n).trim();
        arrayList.add(string3);
        return arrayList;
    }

    public ArrayList getExecOutputLinesFromeGRunas(String string) {
        ArrayList arrayList = new ArrayList();
        BufferedReader[] bufferedReaderArray = null;
        try {
            if (isWindows) {
                Object object;
                Object object2;
                Object object3;
                if (osLanguage != null && !osLanguage.equals("ENU")) {
                    if (encoding != null) {
                        arrayList = this.getExecOutputLinesFromeGRunas(string, encoding);
                        return arrayList;
                    }
                    if (cmdEncodings != null && cmdEncodings.size() > 0) {
                        object3 = cmdEncodings.keys();
                        while (object3.hasMoreElements()) {
                            object2 = (String)object3.nextElement();
                            if (string.indexOf((String)object2) < 0 || (object = (String)cmdEncodings.get(object2)) == null) continue;
                            arrayList = this.getExecOutputLinesFromeGRunas(string, encoding);
                            return arrayList;
                        }
                        bufferedReaderArray = this.executeProgramForeGRunAs(string, true);
                    } else {
                        bufferedReaderArray = this.executeProgramForeGRunAs(string, true);
                    }
                } else {
                    bufferedReaderArray = this.executeProgramForeGRunAs(string, true);
                }
                if (bufferedReaderArray == null || bufferedReaderArray.length == 0) {
                    return null;
                }
                object3 = new EgStreamReaderThread(bufferedReaderArray[0]);
                object2 = new EgStreamReaderThread(bufferedReaderArray[1]);
                ((Thread)object3).start();
                ((Thread)object2).start();
                this.p.waitFor();
                ((Thread)object3).join();
                ((Thread)object2).join();
                object = ((EgStreamReaderThread)object3).getData();
                ArrayList arrayList2 = ((EgStreamReaderThread)object2).getData();
                arrayList.add(object);
                arrayList.add(arrayList2);
                if (this.p != null) {
                    EgUtilities.closeStreams(this.p);
                    this.p = null;
                }
            }
            return arrayList;
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Exception exception) {
            if (this.p != null) {
                EgUtilities.closeStreams(this.p);
                this.p = null;
            }
            exception.printStackTrace();
        }
        return null;
    }

    public ArrayList getExecOutputLinesFromeGRunas(String string, String string2) {
        ArrayList<ArrayList> arrayList = new ArrayList<ArrayList>();
        BufferedReader[] bufferedReaderArray = null;
        if (string2 == null || string2.equals("")) {
            string2 = defaultEncoding;
        }
        try {
            if (isWindows) {
                bufferedReaderArray = this.executeProgramForeGRunAs(string, true, string2);
                EgStreamReaderThread egStreamReaderThread = new EgStreamReaderThread(bufferedReaderArray[0]);
                EgStreamReaderThread egStreamReaderThread2 = new EgStreamReaderThread(bufferedReaderArray[1]);
                egStreamReaderThread.start();
                egStreamReaderThread2.start();
                this.p.waitFor();
                egStreamReaderThread.join();
                egStreamReaderThread2.join();
                ArrayList arrayList2 = egStreamReaderThread.getData();
                ArrayList arrayList3 = egStreamReaderThread2.getData();
                if (EgStreamReaderThread.reRun) {
                    bufferedReaderArray = this.executeProgramForeGRunAs(string, true);
                    egStreamReaderThread = new EgStreamReaderThread(bufferedReaderArray[0]);
                    egStreamReaderThread2 = new EgStreamReaderThread(bufferedReaderArray[1]);
                    egStreamReaderThread.start();
                    egStreamReaderThread2.start();
                    this.p.waitFor();
                    egStreamReaderThread.join();
                    egStreamReaderThread2.join();
                    arrayList2 = egStreamReaderThread.getData();
                    arrayList3 = egStreamReaderThread2.getData();
                }
                arrayList.add(arrayList2);
                arrayList.add(arrayList3);
                if (this.p != null) {
                    EgUtilities.closeStreams(this.p);
                    this.p = null;
                }
            }
            return arrayList;
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Exception exception) {
            if (this.p != null) {
                EgUtilities.closeStreams(this.p);
                this.p = null;
            }
            exception.printStackTrace();
        }
        return null;
    }

    public BufferedReader[] executeProgramForeGRunAs(String string, boolean bl) {
        Runtime runtime = Runtime.getRuntime();
        String string2 = (string = string.trim()).toUpperCase();
        if (!string2.startsWith("CMD")) {
            string = cmdPathWithArgs + string;
        }
        if (string.toLowerCase().indexOf(".ps1") > 0 && string.toLowerCase().indexOf("powershell") == -1) {
            return null;
        }
        this.sop("getExecOutputLinesFromeGRunas:pgm = " + string);
        try {
            if (this.hitDebug) {
                System.out.println("[EgUtilities].getExecOutputLinesFromeGRunas() before exec(pgm) ");
                System.out.println("[EgUtilities].getExecOutputLinesFromeGRunas() COMMAND => " + string);
            }
            this.p = runtime.exec(string);
            this.p.getOutputStream().close();
            if (this.hitDebug) {
                System.out.println("[EgUtilities].getExecOutputLinesFromeGRunas() after exec(pgm) ");
            }
            BufferedReader[] bufferedReaderArray = new BufferedReader[2];
            bufferedReaderArray[1] = new BufferedReader(new InputStreamReader(this.p.getErrorStream(), "UTF-8"));
            bufferedReaderArray[0] = new BufferedReader(new InputStreamReader(this.p.getInputStream(), "UTF-8"));
            return bufferedReaderArray;
        }
        catch (Exception exception) {
            this.p = null;
            exception.printStackTrace();
            return null;
        }
    }

    public BufferedReader[] executeProgramForeGRunAs(String string, boolean bl, String string2) {
        Runtime runtime = Runtime.getRuntime();
        String string3 = (string = string.trim()).toUpperCase();
        if (!string3.startsWith("CMD")) {
            string = cmdPathWithArgs + string;
        }
        if (string.toLowerCase().indexOf(".ps1") > 0 && string.toLowerCase().indexOf("powershell") == -1) {
            return null;
        }
        this.sop("executeProgramForeGRunAs:pgm = " + string);
        try {
            this.p = runtime.exec(string);
            this.p.getOutputStream().close();
            BufferedReader[] bufferedReaderArray = new BufferedReader[2];
            bufferedReaderArray[1] = new BufferedReader(new InputStreamReader(this.p.getErrorStream(), "UTF-8"));
            bufferedReaderArray[0] = new BufferedReader(new InputStreamReader(this.p.getInputStream(), "UTF-8"));
            return bufferedReaderArray;
        }
        catch (Exception exception) {
            this.p = null;
            exception.printStackTrace();
            return null;
        }
    }

    public String[] getIpAddressFromIpCmd() {
        String[] stringArray = null;
        String string = "ip addr";
        BufferedReader bufferedReader = this.executeProgramOnUnix(string);
        if (bufferedReader != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            try {
                String string2;
                while ((string2 = bufferedReader.readLine()) != null) {
                    int n;
                    StringTokenizer stringTokenizer;
                    if (string2.indexOf("inet") < 0 || string2.indexOf("inet6") >= 0 || (stringTokenizer = new StringTokenizer(string2)).countTokens() < 2) continue;
                    String string3 = stringTokenizer.nextToken();
                    String string4 = stringTokenizer.nextToken();
                    if (string4 == null || string4.trim().length() == 0 || (n = (string4 = string4.trim()).indexOf("/")) < 0 || (string4 = string4.substring(0, n)).equals("127.0.0.1")) continue;
                    arrayList.add(string4);
                }
                stringArray = new String[arrayList.size()];
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = (String)arrayList.get(i);
                }
                bufferedReader.close();
            }
            catch (Exception exception) {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                return null;
            }
        }
        return stringArray;
    }

    public ArrayList getExecOutputLinesFor32BitCmd(String string) {
        ArrayList arrayList = new ArrayList();
        BufferedReader[] bufferedReaderArray = null;
        try {
            Object object;
            Object object2;
            Object object3;
            if (osLanguage != null && !osLanguage.equals("ENU")) {
                if (encoding != null) {
                    arrayList = this.getExecOutputLinesFor32BitCmd(string, encoding);
                    return arrayList;
                }
                if (cmdEncodings != null && cmdEncodings.size() > 0) {
                    object3 = cmdEncodings.keys();
                    while (object3.hasMoreElements()) {
                        object2 = (String)object3.nextElement();
                        if (string.indexOf((String)object2) < 0 || (object = (String)cmdEncodings.get(object2)) == null) continue;
                        arrayList = this.getExecOutputLinesFor32BitCmd(string, (String)object);
                        return arrayList;
                    }
                    bufferedReaderArray = this.executeProgramOnWindows32Bit(string, true);
                } else {
                    bufferedReaderArray = this.executeProgramOnWindows32Bit(string, true);
                }
            } else {
                bufferedReaderArray = this.executeProgramOnWindows32Bit(string, true);
            }
            if (bufferedReaderArray == null || bufferedReaderArray.length == 0) {
                return null;
            }
            object3 = new EgStreamReaderThread(bufferedReaderArray[0]);
            object2 = new EgStreamReaderThread(bufferedReaderArray[1]);
            ((Thread)object3).start();
            ((Thread)object2).start();
            try {
                this.p.waitFor();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ((Thread)object3).join();
            ((Thread)object2).join();
            object = ((EgStreamReaderThread)object3).getData();
            ArrayList arrayList2 = ((EgStreamReaderThread)object2).getData();
            arrayList.add(object);
            arrayList.add(arrayList2);
            if (this.p != null) {
                EgUtilities.closeStreams(this.p);
                this.p = null;
            }
            return arrayList;
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Exception exception) {
            if (this.p != null) {
                EgUtilities.closeStreams(this.p);
                this.p = null;
            }
            exception.printStackTrace();
        }
        return null;
    }

    public ArrayList getExecOutputLinesFor32BitCmd(String string, String string2) {
        ArrayList<ArrayList> arrayList = new ArrayList<ArrayList>();
        BufferedReader[] bufferedReaderArray = null;
        if (string2 == null || string2.equals("")) {
            string2 = defaultEncoding;
        }
        try {
            bufferedReaderArray = this.executeProgramOnWindows32Bit(string, true, string2);
            EgStreamReaderThread egStreamReaderThread = new EgStreamReaderThread(bufferedReaderArray[0]);
            EgStreamReaderThread egStreamReaderThread2 = new EgStreamReaderThread(bufferedReaderArray[1]);
            egStreamReaderThread.start();
            egStreamReaderThread2.start();
            this.p.waitFor();
            egStreamReaderThread.join();
            egStreamReaderThread2.join();
            ArrayList arrayList2 = egStreamReaderThread.getData();
            ArrayList arrayList3 = egStreamReaderThread2.getData();
            if (EgStreamReaderThread.reRun) {
                bufferedReaderArray = this.executeProgramOnWindows32Bit(string, true);
                egStreamReaderThread = new EgStreamReaderThread(bufferedReaderArray[0]);
                egStreamReaderThread2 = new EgStreamReaderThread(bufferedReaderArray[1]);
                egStreamReaderThread.start();
                egStreamReaderThread2.start();
                this.p.waitFor();
                egStreamReaderThread.join();
                egStreamReaderThread2.join();
                arrayList2 = egStreamReaderThread.getData();
                arrayList3 = egStreamReaderThread2.getData();
            }
            arrayList.add(arrayList2);
            arrayList.add(arrayList3);
            if (this.p != null) {
                EgUtilities.closeStreams(this.p);
                this.p = null;
            }
            return arrayList;
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Exception exception) {
            if (this.p != null) {
                EgUtilities.closeStreams(this.p);
                this.p = null;
            }
            exception.printStackTrace();
        }
        return null;
    }

    public BufferedReader[] executeProgramOnWindows32Bit(String string, boolean bl) {
        Runtime runtime = Runtime.getRuntime();
        string = string.trim();
        String string2 = "";
        String string3 = System.getProperty("os.arch");
        String string4 = System.getenv("windir");
        if (string3 != null && string4 != null) {
            string2 = string3.indexOf("64") >= 0 ? string4 + "/Syswow64/cmd.exe" : string4 + "/System32/cmd.exe";
        }
        string = string2 != null && string2.length() > 0 ? string2 + " /c " + string : cmdPathWithArgs + string;
        try {
            this.p = runtime.exec(string);
            BufferedReader[] bufferedReaderArray = new BufferedReader[2];
            bufferedReaderArray[1] = new BufferedReader(new InputStreamReader(this.p.getErrorStream(), "UTF-8"));
            bufferedReaderArray[0] = new BufferedReader(new InputStreamReader(this.p.getInputStream(), "UTF-8"));
            return bufferedReaderArray;
        }
        catch (Exception exception) {
            this.p = null;
            exception.printStackTrace();
            return null;
        }
    }

    public BufferedReader[] executeProgramOnWindows32Bit(String string, boolean bl, String string2) {
        Runtime runtime = Runtime.getRuntime();
        string = string.trim();
        String string3 = "";
        String string4 = System.getProperty("os.arch");
        String string5 = System.getenv("windir");
        if (string4 != null && string5 != null) {
            string3 = string4.indexOf("64") >= 0 ? string5 + "/Syswow64/cmd.exe" : string5 + "/System32/cmd.exe";
        }
        string = string3 != null && string3.length() > 0 ? string3 + " /c " + string : cmdPathWithArgs + string;
        try {
            this.p = runtime.exec(string);
            BufferedReader[] bufferedReaderArray = new BufferedReader[2];
            bufferedReaderArray[1] = new BufferedReader(new InputStreamReader(this.p.getErrorStream(), "UTF-8"));
            bufferedReaderArray[0] = new BufferedReader(new InputStreamReader(this.p.getInputStream(), "UTF-8"));
            return bufferedReaderArray;
        }
        catch (Exception exception) {
            this.p = null;
            exception.printStackTrace();
            return null;
        }
    }

    public ArrayList getExecOutputLinesForNewPSCommand(String string) {
        ArrayList<ArrayList> arrayList = new ArrayList<ArrayList>();
        BufferedReader[] bufferedReaderArray = null;
        try {
            bufferedReaderArray = this.executeProgramOnPwsh(string);
            if (bufferedReaderArray == null || bufferedReaderArray.length == 0) {
                return null;
            }
            EgStreamReaderThread egStreamReaderThread = new EgStreamReaderThread(bufferedReaderArray[0]);
            EgStreamReaderThread egStreamReaderThread2 = new EgStreamReaderThread(bufferedReaderArray[1]);
            egStreamReaderThread.start();
            egStreamReaderThread2.start();
            this.p.waitFor();
            egStreamReaderThread.join();
            egStreamReaderThread2.join();
            ArrayList arrayList2 = egStreamReaderThread.getData();
            ArrayList arrayList3 = egStreamReaderThread2.getData();
            arrayList.add(arrayList2);
            arrayList.add(arrayList3);
            if (this.p != null) {
                EgUtilities.closeStreams(this.p);
                this.p = null;
            }
            return arrayList;
        }
        catch (Exception exception) {
            if (this.p != null) {
                EgUtilities.closeStreams(this.p);
                this.p = null;
            }
            exception.printStackTrace();
            return null;
        }
    }

    public ArrayList getExecOutputLinesForNewPSCommand(String string, String string2, long l) {
        long l2 = l;
        long l3 = 0L;
        ArrayList<ArrayList> arrayList = new ArrayList<ArrayList>();
        BufferedReader[] bufferedReaderArray = null;
        try {
            bufferedReaderArray = this.executeProgramOnPwsh(string);
            if (bufferedReaderArray == null || bufferedReaderArray.length == 0) {
                return null;
            }
            EgStreamReaderThread egStreamReaderThread = new EgStreamReaderThread(bufferedReaderArray[0]);
            EgStreamReaderThread egStreamReaderThread2 = new EgStreamReaderThread(bufferedReaderArray[1]);
            egStreamReaderThread.start();
            egStreamReaderThread2.start();
            long l4 = 1L;
            while (!egStreamReaderThread.done && !egStreamReaderThread2.done) {
                ArrayList arrayList2;
                Thread.sleep(l4 * 1000L);
                l4 = 2L;
                if ((l3 += l4) <= l2) continue;
                egStreamReaderThread.done = true;
                egStreamReaderThread2.done = true;
                egStreamReaderThread.join(1000L);
                egStreamReaderThread2.join(1000L);
                try {
                    egStreamReaderThread.interrupt();
                    Thread.currentThread();
                    Thread.yield();
                    egStreamReaderThread.stop();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    egStreamReaderThread2.interrupt();
                    Thread.currentThread();
                    Thread.yield();
                    egStreamReaderThread2.stop();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.p != null) {
                    try {
                        EgUtilities.closeStreams(this.p);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (string2 != null && string2.length() > 0 && (arrayList2 = this.getPid(string2)) != null && arrayList2.size() > 0) {
                        this.killProcesses(arrayList2);
                    }
                    this.p = null;
                }
                if (this.p != null) {
                    // empty if block
                }
                egStreamReaderThread = null;
                egStreamReaderThread2 = null;
                arrayList2 = new ArrayList();
                arrayList2.add("Command execution was timed out");
                arrayList.add(arrayList2);
                return arrayList;
            }
            this.p.waitFor();
            ArrayList arrayList3 = null;
            ArrayList arrayList4 = null;
            if (egStreamReaderThread != null) {
                egStreamReaderThread.join();
                arrayList3 = egStreamReaderThread.getData();
            }
            if (egStreamReaderThread2 != null) {
                egStreamReaderThread2.join();
                arrayList4 = egStreamReaderThread2.getData();
            }
            if (arrayList3 != null) {
                arrayList.add(arrayList3);
            }
            if (arrayList4 != null) {
                arrayList.add(arrayList4);
            }
            if (this.p != null) {
                EgUtilities.closeStreams(this.p);
                this.p = null;
            }
            return arrayList;
        }
        catch (Exception exception) {
            if (this.p != null) {
                EgUtilities.closeStreams(this.p);
                this.p = null;
            }
            exception.printStackTrace();
            return null;
        }
    }

    public BufferedReader[] executeProgramOnPwsh(String string) {
        string = string.trim();
        String[] stringArray = this.setArgumentsForPwshCommand(string);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer = stringBuffer.append(stringArray[i]);
        }
        Runtime runtime = Runtime.getRuntime();
        String string2 = stringBuffer.toString();
        try {
            this.p = runtime.exec(string2);
            this.p.getOutputStream().close();
            BufferedReader[] bufferedReaderArray = new BufferedReader[2];
            bufferedReaderArray[1] = new BufferedReader(new InputStreamReader(this.p.getErrorStream(), "UTF-8"));
            bufferedReaderArray[0] = new BufferedReader(new InputStreamReader(this.p.getInputStream(), "UTF-8"));
            return bufferedReaderArray;
        }
        catch (Exception exception) {
            this.p = null;
            exception.printStackTrace();
            return null;
        }
    }

    private String[] setArgumentsForPwshCommand(String string) {
        String string2 = "RemoteSigned";
        String[] stringArray = new String[]{cmdPath, " /c", " pwsh -InputFormat none -ExecutionPolicy " + string2 + " -Command ", "\"" + string + "\""};
        return stringArray;
    }

    public static String findAndReplaceInfoString(String string, String string2, String string3) {
        if (string == null || string2 == null || string2.length() == 0 || string3 == null) {
            return string;
        }
        String string4 = string;
        int n = 0;
        int n2 = string4.indexOf(string2, n);
        if (n2 < 0) {
            return string;
        }
        int n3 = string2.length();
        int n4 = string3.length() - n3;
        n4 = n4 < 0 ? 0 : n4;
        StringBuilder stringBuilder = new StringBuilder(string.length() + (n4 *= 16));
        while (n2 >= 0) {
            stringBuilder.append(string, n, n2).append(string3);
            n = n2 + n3;
            n2 = string4.indexOf(string2, n);
        }
        stringBuilder.append(string, n, string.length());
        return stringBuilder.toString();
    }

    public static String decodeSecurityChar(String string) {
        try {
            string = EgUtilities.findAndReplaceInfoString(string, "|lbr|", "(");
            string = EgUtilities.findAndReplaceInfoString(string, "|rbr|", ")");
            string = EgUtilities.findAndReplaceInfoString(string, "|lsbr|", "[");
            string = EgUtilities.findAndReplaceInfoString(string, "|rsbr|", "]");
            string = EgUtilities.findAndReplaceInfoString(string, "|per|", "%");
            string = EgUtilities.findAndReplaceInfoString(string, "|eq|", "=");
            string = EgUtilities.findAndReplaceInfoString(string, "|squot|", "'");
            string = EgUtilities.findAndReplaceInfoString(string, "|ampsnd|", "&");
            string = EgUtilities.findAndReplaceInfoString(string, "|scol|", ";");
            string = EgUtilities.findAndReplaceInfoString(string, "|dqt|", "\"");
            string = EgUtilities.findAndReplaceInfoString(string, "|slash|", "\\");
            string = EgUtilities.findAndReplaceInfoString(string, "|fslash|", "/");
            string = EgUtilities.findAndReplaceInfoString(string, "|colon|", ":");
            string = EgUtilities.findAndReplaceInfoString(string, "|dot|", ".");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }
}

