/*
 * Decompiled with CFR 0.152.
 */
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.platform.win32.Advapi32;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.BaseTSD;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Psapi;
import com.sun.jna.platform.win32.Tlhelp32;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Vector;

public class EgJNAUtilities {
    public static final double bytesToMB = 1048576.0;

    public double getTotalMemory() {
        double d = 0.0;
        try {
            Psapi.PERFORMANCE_INFORMATION pERFORMANCE_INFORMATION = new Psapi.PERFORMANCE_INFORMATION();
            Psapi.INSTANCE.GetPerformanceInfo(pERFORMANCE_INFORMATION, pERFORMANCE_INFORMATION.size());
            BaseTSD.SIZE_T sIZE_T = pERFORMANCE_INFORMATION.PageSize;
            long l = sIZE_T.longValue();
            BaseTSD.SIZE_T sIZE_T2 = pERFORMANCE_INFORMATION.PhysicalTotal;
            long l2 = sIZE_T2.longValue();
            long l3 = l2 * l;
            d = (double)l3 / 1048576.0;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getDiskSpace() {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            int n = 255;
            char[] cArray = new char[n];
            WinNT.HANDLE hANDLE = Kernel32.INSTANCE.FindFirstVolume(cArray, n);
            if (WinBase.INVALID_HANDLE_VALUE.equals((Object)hANDLE)) {
                return arrayList;
            }
            try {
                do {
                    int n2;
                    String string;
                    char[] cArray2 = new char[16];
                    char[] cArray3 = new char[n];
                    char[] cArray4 = new char[n];
                    IntByReference intByReference = new IntByReference();
                    WinNT.LARGE_INTEGER lARGE_INTEGER = new WinNT.LARGE_INTEGER(0L);
                    WinNT.LARGE_INTEGER lARGE_INTEGER2 = new WinNT.LARGE_INTEGER(0L);
                    WinNT.LARGE_INTEGER lARGE_INTEGER3 = new WinNT.LARGE_INTEGER(0L);
                    String string2 = Native.toString((char[])cArray);
                    Kernel32.INSTANCE.GetVolumeInformation(string2, cArray3, n, null, null, intByReference, cArray2, 16);
                    int n3 = intByReference.getValue();
                    Kernel32.INSTANCE.GetVolumePathNamesForVolumeName(string2, cArray4, n, null);
                    String string3 = Native.toString((char[])cArray4);
                    if (string3.isEmpty()) continue;
                    String string4 = Native.toString((char[])cArray3);
                    String string5 = Native.toString((char[])cArray2);
                    if (Kernel32.INSTANCE.GetDriveType(string3) != 3) continue;
                    Kernel32.INSTANCE.GetDiskFreeSpaceEx(string2, lARGE_INTEGER, lARGE_INTEGER2, lARGE_INTEGER3);
                    double d = lARGE_INTEGER2.getValue();
                    double d2 = lARGE_INTEGER.getValue();
                    double d3 = 0.0;
                    double d4 = 0.0;
                    if (d >= d2) {
                        d3 = d - d2;
                    }
                    if (d > 0.0 && d3 > 0.0) {
                        d4 = d3 / d * 100.0;
                    }
                    d /= 1048576.0;
                    d3 /= 1048576.0;
                    d2 /= 1048576.0;
                    if (d4 >= 100.0) {
                        d4 = 100.0;
                    }
                    if ((string = string3).endsWith("\\") && (n2 = string.lastIndexOf("\\")) > 0) {
                        string = string.substring(0, n2);
                    }
                    if (!string.endsWith(":")) {
                        string = string + ":";
                    }
                    String string6 = string + "" + d + ":" + d2 + ":" + d3 + ":" + d4;
                    arrayList.add(string6);
                } while (Kernel32.INSTANCE.FindNextVolume(hANDLE, cArray, n));
            }
            finally {
                Kernel32.INSTANCE.FindVolumeClose(hANDLE);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return arrayList;
    }

    private boolean readVirtualMemoryToStructure(WinNT.HANDLE hANDLE, Pointer pointer, Structure structure) {
        int n = structure.size();
        int n2 = CustomNtDll.INSTANCE.ZwReadVirtualMemory(hANDLE.getPointer(), pointer, structure.getPointer(), n, null);
        if (n2 != 0) {
            return false;
        }
        structure.read();
        return n2 == 0;
    }

    private boolean readVirtualMemoryToMemory(WinNT.HANDLE hANDLE, Pointer pointer, Memory memory) {
        int n = (int)memory.size();
        int n2 = CustomNtDll.INSTANCE.ZwReadVirtualMemory(hANDLE.getPointer(), pointer, (Pointer)memory, n, null);
        if (n2 != 0) {
            return false;
        }
        return n2 == 0;
    }

    private String getCommandLine(WinNT.HANDLE hANDLE) {
        String string = "";
        CustomNtDll.PROCESS_BASIC_INFORMATION pROCESS_BASIC_INFORMATION = new CustomNtDll.PROCESS_BASIC_INFORMATION();
        IntByReference intByReference = new IntByReference();
        int n = pROCESS_BASIC_INFORMATION.size();
        try {
            int n2 = CustomNtDll.INSTANCE.ZwQueryInformationProcess(hANDLE, 0, pROCESS_BASIC_INFORMATION.getPointer(), n, intByReference);
            if (n2 == 0) {
                Memory memory;
                CustomNtDll.RTL_USER_PROCESS_PARAMETERS rTL_USER_PROCESS_PARAMETERS;
                CustomNtDll.PEB64 pEB64;
                pROCESS_BASIC_INFORMATION.read();
                if (pROCESS_BASIC_INFORMATION.PebBaseAddress != null && this.readVirtualMemoryToStructure(hANDLE, pROCESS_BASIC_INFORMATION.PebBaseAddress, pEB64 = new CustomNtDll.PEB64()) && pEB64.ProcessParameters != null && this.readVirtualMemoryToStructure(hANDLE, pEB64.ProcessParameters, rTL_USER_PROCESS_PARAMETERS = new CustomNtDll.RTL_USER_PROCESS_PARAMETERS()) && this.readVirtualMemoryToMemory(hANDLE, rTL_USER_PROCESS_PARAMETERS.CommandLine.Buffer, memory = new Memory((long)rTL_USER_PROCESS_PARAMETERS.CommandLine.MaximumLength))) {
                    string = memory.getWideString(0L);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getProcesses() {
        int n = 1024;
        int n2 = 983040;
        int n3 = 0x100000;
        int n4 = n2 | n3 | 0xFFF;
        ArrayList<String> arrayList = new ArrayList<String>();
        Tlhelp32.PROCESSENTRY32.ByReference byReference = new Tlhelp32.PROCESSENTRY32.ByReference();
        WinNT.HANDLE hANDLE = Kernel32.INSTANCE.CreateToolhelp32Snapshot(Tlhelp32.TH32CS_SNAPPROCESS, new WinDef.DWORD(0L));
        try {
            String string = null;
            WinNT.HANDLE hANDLE2 = null;
            boolean bl = Kernel32.INSTANCE.Process32First(hANDLE, (Tlhelp32.PROCESSENTRY32)byReference);
            while (bl) {
                hANDLE2 = Kernel32.INSTANCE.OpenProcess(n4, false, byReference.th32ProcessID.intValue());
                if (hANDLE2 == null) {
                    hANDLE2 = Kernel32.INSTANCE.OpenProcess(n, false, byReference.th32ProcessID.intValue());
                }
                if (hANDLE2 != null) {
                    int n5 = 8;
                    WinNT.HANDLEByReference hANDLEByReference = new WinNT.HANDLEByReference();
                    if (!Advapi32.INSTANCE.OpenProcessToken(hANDLE2, n5, hANDLEByReference)) {
                        Kernel32.INSTANCE.CloseHandle(hANDLE2);
                    } else {
                        Advapi32Util.Account account = null;
                        try {
                            account = Advapi32Util.getTokenAccount((WinNT.HANDLE)hANDLEByReference.getValue());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (hANDLEByReference.getValue() != null) {
                            Kernel32.INSTANCE.CloseHandle(hANDLEByReference.getValue());
                        }
                        if (account == null) {
                            Kernel32.INSTANCE.CloseHandle(hANDLE2);
                        } else {
                            String string2 = account.name;
                            String string3 = account.domain;
                            String string4 = "";
                            if (string2 != null && string2.length() > 0) {
                                string4 = string2;
                            }
                            if (string3 != null && string3.length() > 0) {
                                string4 = string3 + "\\" + string4;
                            }
                            char[] cArray = new char[1024];
                            IntByReference intByReference = new IntByReference(cArray.length);
                            String string5 = this.getCommandLine(hANDLE2);
                            if (string5 != null && string5.length() > 0) {
                                string = string4 + ";" + byReference.th32ProcessID.intValue() + ";" + string5 + ";" + new String(byReference.szExeFile).trim();
                                arrayList.add(string);
                            } else {
                                String string6 = new String(cArray, 0, intByReference.getValue());
                                string = string4 + ";" + byReference.th32ProcessID.intValue() + ";" + string6 + ";" + new String(byReference.szExeFile).trim();
                                arrayList.add(string);
                            }
                            Kernel32.INSTANCE.CloseHandle(hANDLE2);
                        }
                    }
                }
                bl = Kernel32.INSTANCE.Process32Next(hANDLE, (Tlhelp32.PROCESSENTRY32)byReference);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            Kernel32.INSTANCE.CloseHandle(hANDLE);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList getProcessesInstances() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Tlhelp32.PROCESSENTRY32.ByReference byReference = new Tlhelp32.PROCESSENTRY32.ByReference();
        WinNT.HANDLE hANDLE = Kernel32.INSTANCE.CreateToolhelp32Snapshot(Tlhelp32.TH32CS_SNAPPROCESS, new WinDef.DWORD(0L));
        try {
            Object var4_4 = null;
            boolean bl = Kernel32.INSTANCE.Process32First(hANDLE, (Tlhelp32.PROCESSENTRY32)byReference);
            while (bl) {
                String string = new String(byReference.szExeFile);
                if (string != null && string.trim().length() > 0) {
                    if ((string = string.trim()).equalsIgnoreCase("[System Process]")) {
                        string = "Idle";
                    }
                    arrayList.add(string);
                }
                bl = Kernel32.INSTANCE.Process32Next(hANDLE, (Tlhelp32.PROCESSENTRY32)byReference);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            Kernel32.INSTANCE.CloseHandle(hANDLE);
        }
        arrayList.add("_Total");
        return arrayList;
    }

    public String[] getWinProcesseInstances() {
        int n;
        Object object;
        int n2;
        ArrayList arrayList = this.getProcessesInstances();
        int n3 = 0;
        if (arrayList != null) {
            n3 = arrayList.size();
        }
        if (n3 == 0) {
            return null;
        }
        Vector<String[]> vector = new Vector<String[]>();
        for (n2 = 0; n2 < n3; ++n2) {
            object = (String[])arrayList.get(n2);
            n = object.toLowerCase().indexOf(".exe");
            if (n > 0) {
                object = object.substring(0, n);
            }
            int n4 = 0;
            String string = (String)object + "#";
            for (int i = 0; i < vector.size(); ++i) {
                String string2 = (String)vector.get(i);
                if (!string2.equalsIgnoreCase((String)object) && !string2.startsWith(string)) continue;
                ++n4;
            }
            if (n4 > 0) {
                object = (String)object + "#" + n4;
            }
            vector.addElement((String[])object);
        }
        if (vector == null || vector.size() == 0) {
            return null;
        }
        n2 = vector.size();
        object = new String[n2];
        for (n = 0; n < n2; ++n) {
            String string;
            object[n] = string = (String)vector.get(n);
        }
        return object;
    }

    public static void main(String[] stringArray) {
        EgJNAUtilities egJNAUtilities = new EgJNAUtilities();
        System.out.println("TotalMemory " + egJNAUtilities.getTotalMemory());
        System.out.println("DiskSpace " + egJNAUtilities.getDiskSpace());
        System.out.println("Processes " + egJNAUtilities.getProcesses());
        System.out.println("Processes Instances " + Arrays.asList(egJNAUtilities.getWinProcesseInstances()));
    }
}

