/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgInstallInfo;
import java.util.ArrayList;
import java.util.Hashtable;

public class CitrixPVSNetwork {
    public static String syncString = new String("PVSNetworkTest");
    private static CitrixPVSNetwork citrixPVSNetworkObj = null;
    private static String object = "Citrix PVS Network";
    private static String[] counters = new String[]{"Server Reconnect", "UDP Retry"};
    private ArrayList outputList = new ArrayList();
    private ArrayList outList = new ArrayList();
    private ArrayList errList = new ArrayList();
    private String[] instances = null;
    private double[][] values = null;
    private EgPerfInstrumentation egPerfUtil = null;
    private static long lastRunTime = 0L;
    private static long cachePeriod = 10000L;
    private static ArrayList lastResults = new ArrayList();
    private static Hashtable prevHash = new Hashtable();

    private CitrixPVSNetwork() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CitrixPVSNetwork getInstance() {
        if (citrixPVSNetworkObj == null) {
            String string = syncString;
            synchronized (string) {
                if (citrixPVSNetworkObj == null) {
                    citrixPVSNetworkObj = new CitrixPVSNetwork();
                }
            }
        }
        return citrixPVSNetworkObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getCitrixPVSNetworkData() {
        String string = syncString;
        synchronized (string) {
            long l = System.currentTimeMillis();
            if (l - lastRunTime < cachePeriod && lastResults != null) {
                return lastResults;
            }
            this.outputList = new ArrayList();
            this.outList = new ArrayList();
            this.errList = new ArrayList();
            this.outputList.add(this.outList);
            this.outputList.add(this.errList);
            this.instances = EgPerfInstrumentation.discoverInstances(object);
            if (this.instances == null || this.instances.length == 0) {
                lastResults = this.outputList;
                lastRunTime = System.currentTimeMillis();
                prevHash = new Hashtable();
                return this.outputList;
            }
            if (this.egPerfUtil == null) {
                this.egPerfUtil = new EgPerfInstrumentation();
            }
            this.values = this.egPerfUtil.getCounterValue(object, this.instances, counters);
            if (this.values == null || this.values.length == 0) {
                this.stopTest();
                this.instances = null;
                lastResults = this.outputList;
                lastRunTime = System.currentTimeMillis();
                prevHash = new Hashtable();
                return this.outputList;
            }
            Hashtable hashtable = new Hashtable();
            int n = this.instances.length;
            for (int i = 0; i < n; ++i) {
                String string2 = this.instances[i];
                double d = this.values[i][0];
                double d2 = this.values[i][1];
                ArrayList<Double> arrayList = new ArrayList<Double>();
                arrayList.add(new Double(d));
                arrayList.add(new Double(d2));
                hashtable.put(string2, arrayList);
                double d3 = -5.0;
                double d4 = -5.0;
                ArrayList arrayList2 = (ArrayList)prevHash.get(string2);
                if (arrayList2 != null && arrayList2.size() >= 2) {
                    double d5 = (Double)arrayList2.get(0);
                    double d6 = (Double)arrayList2.get(1);
                    d3 = d - d5;
                    d4 = d2 - d6;
                }
                if (d3 < 0.0) {
                    d3 = -5.0;
                }
                if (d4 < 0.0) {
                    d4 = -5.0;
                }
                String string3 = string2 + "=" + d3 + "#" + d4;
                this.outList.add(string3);
            }
            prevHash = (Hashtable)hashtable.clone();
            this.outputList.set(0, this.outList);
            lastResults = this.outputList;
            lastRunTime = System.currentTimeMillis();
            return this.outputList;
        }
    }

    private void stopTest() {
        if (this.egPerfUtil != null) {
            this.egPerfUtil.stop();
        }
        this.egPerfUtil = null;
    }

    public static void main(String[] stringArray) {
        Object object;
        CitrixPVSNetwork citrixPVSNetwork = CitrixPVSNetwork.getInstance();
        if (stringArray.length == 0) {
            try {
                object = System.getenv("EGVMAGENT_INSTALL_DIR");
                if (object != null && ((String)object).trim().length() > 0) {
                    EgInstallInfo.setInstallDir((String)object);
                }
            }
            catch (Exception exception) {}
        } else {
            EgInstallInfo.setInstallDir(stringArray[0]);
        }
        object = citrixPVSNetwork.getCitrixPVSNetworkData();
        System.out.println(object);
    }
}

