/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgInstallInfo;
import java.util.ArrayList;

public class CitrixMCSStorageDriver {
    public static String syncString = new String("CitrixMCSStorageDriver");
    private static CitrixMCSStorageDriver sDriverObj = null;
    private static final String object = "Citrix MCS Storage Driver";
    private static final String[] counters = new String[]{"Cache disk bytes/sec read", "Cache disk bytes/sec written", "Cache disk reads/sec", "Cache disk writes/sec", "Cache disk size", "Cache disk Used", "Cache memory bytes/sec read", "Cache memory bytes/sec written", "Cache memory reads/sec", "Cache memory writes/sec", "Cache memory target size", "Cache memory used", "Storage driver read requests", "Storage driver write requests", "System disk bytes/sec read", "System disk bytes/sec written", "System disk reads/sec", "System disk writes/sec"};
    private ArrayList outputList = new ArrayList();
    private ArrayList outList = new ArrayList();
    private ArrayList errList = new ArrayList();
    private double[] values = null;
    private EgPerfInstrumentation egPerfUtil = null;
    private static long lastRunTime = 0L;
    private static long cachePeriod = 10000L;
    private static ArrayList lastResults = new ArrayList();

    private CitrixMCSStorageDriver() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CitrixMCSStorageDriver getInstance() {
        if (sDriverObj == null) {
            String string = syncString;
            synchronized (string) {
                if (sDriverObj == null) {
                    sDriverObj = new CitrixMCSStorageDriver();
                }
            }
        }
        return sDriverObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getCtxMCSStorageDriverData() {
        String string = syncString;
        synchronized (string) {
            long l = System.currentTimeMillis();
            if (l - lastRunTime < cachePeriod && lastResults != null) {
                return lastResults;
            }
            this.outputList = new ArrayList();
            this.outList = new ArrayList();
            this.errList = new ArrayList();
            this.outputList.add(this.outList);
            this.outputList.add(this.errList);
            if (this.egPerfUtil == null) {
                this.egPerfUtil = new EgPerfInstrumentation();
            }
            this.values = this.egPerfUtil.getCounterValue(object, counters);
            if (this.values == null || this.values.length == 0) {
                this.stopTest();
                lastResults = this.outputList;
                lastRunTime = System.currentTimeMillis();
                return this.outputList;
            }
            String string2 = "Citrix MCS Storage Driver=" + this.values[0] + "#" + this.values[1] + "#" + this.values[2] + "#" + this.values[3] + "#" + this.values[4] + "#" + this.values[5] + "#" + this.values[6] + "#" + this.values[7] + "#" + this.values[8] + "#" + this.values[9] + "#" + this.values[10] + "#" + this.values[11] + "#" + this.values[12] + "#" + this.values[13] + "#" + this.values[14] + "#" + this.values[15] + "#" + this.values[16] + "#" + this.values[17];
            this.outList.add(string2);
            this.outputList.set(0, this.outList);
            lastResults = this.outputList;
            lastRunTime = System.currentTimeMillis();
            return this.outputList;
        }
    }

    private void stopTest() {
        if (this.egPerfUtil != null) {
            this.egPerfUtil.stop();
        }
        this.egPerfUtil = null;
    }

    public static void main(String[] stringArray) {
        Object object;
        CitrixMCSStorageDriver citrixMCSStorageDriver = CitrixMCSStorageDriver.getInstance();
        if (stringArray.length == 0) {
            try {
                object = System.getenv("EGVMAGENT_INSTALL_DIR");
                if (object != null && ((String)object).trim().length() > 0) {
                    EgInstallInfo.setInstallDir((String)object);
                }
            }
            catch (Exception exception) {}
        } else {
            EgInstallInfo.setInstallDir(stringArray[0]);
        }
        object = citrixMCSStorageDriver.getCtxMCSStorageDriverData();
        System.out.println(object);
    }
}

