#!/bin/bash

read_values() {
    # Read IGEL Custom Partition parameter values
    NUM_PARAMETER=$(numinstances custom_partition.parameter%)
    if [ -n "$NUM_PARAMETER" ] ; then
        if [ "$NUM_PARAMETER" -gt 0 ] ; then
            for i in $(seq 0 $((NUM_PARAMETER-1))) ; do
            case "$(get custom_partition.parameter${i}.name)" in
                
		EG_Component_Name)
		   EG_Component_Name="$(get custom_partition.parameter${i}.value)"
		   ;;
		EG_Manager)
                   EG_Manager="$(get custom_partition.parameter${i}.value)"
                   ;;
                EG_Manager_Port)
                  EG_Manager_Port="$(get custom_partition.parameter${i}.value)"
                   ;;
                EG_Manager_SSL)
                   EG_Manager_SSL="$(get custom_partition.parameter${i}.value)"
                   ;;
                EG_Proxy_Set)
                   EG_Proxy_Set="$(get custom_partition.parameter${i}.value)"
		   ;;
                EG_Proxy_Host)
	           EG_Proxy_Host="$(get custom_partition.parameter${i}.value)"
		   ;;
		EG_Proxy_Port)
		   EG_Proxy_Port="$(get custom_partition.parameter${i}.value)"
		   ;;
	        EG_Proxy_User_Name)
		   EG_Proxy_User_Name="$(get custom_partition.parameter${i}.value)"
		   ;;
                EG_Proxy_Password)
		   EG_Proxy_Password="$(get custom_partition.parameter${i}.value)"
		   ;;
		EG_Remoteagent_IP)
		   EG_Remoteagent_IP="$(get custom_partition.parameter${i}.value)"
                   ;;
		EG_Remoteagent_Port)
		   EG_Remoteagent_Port="$(get custom_partition.parameter${i}.value)"
                   ;;

	   esac
            done
        fi
    fi
}


eg_values() {

      echo $EG_Component_Name > /custom/egvmagent/lib/egvmagent_nick.ini
      
      if [ -z "$EG_Manager" ]
       then 
          echo ManagerIP=null > /custom/egvmagent/lib/eg_managersetup.ini
       else
          echo ManagerIP=$EG_Manager > /custom/egvmagent/lib/eg_managersetup.ini
      fi     
      if [ -z "$EG_Manager_Port" ]
       then 
          echo ManagerPort=null >> /custom/egvmagent/lib/eg_managersetup.ini
       else
	  echo ManagerPort=$EG_Manager_Port >> /custom/egvmagent/lib/eg_managersetup.ini
      fi
      if [ -z "$EG_Manager_SSL" ]
        then
           echo isSSL=false >> /custom/egvmagent/lib/eg_managersetup.ini
        else
           echo isSSL=$EG_Manager_SSL >> /custom/egvmagent/lib/eg_managersetup.ini
      fi
      if [ -z "$EG_Proxy_Set" ]
       then
          echo ProxySet=false >> /custom/egvmagent/lib/eg_managersetup.ini
       else
          echo ProxySet=$EG_Proxy_Set >> /custom/egvmagent/lib/eg_managersetup.ini
      fi
      if [ -z "$EG_Proxy_Host" ]
       then
          echo proxyHost=null >> /custom/egvmagent/lib/eg_managersetup.ini
       else
          echo proxyHost=$EG_Proxy_Host >> /custom/egvmagent/lib/eg_managersetup.ini
      fi
      if [ -z "$EG_Proxy_Port" ]
       then 
          echo proxyPort=null >> /custom/egvmagent/lib/eg_managersetup.ini
       else
          echo proxyPort=$EG_Proxy_Port >> /custom/egvmagent/lib/eg_managersetup.ini
      fi
      if [ -z "$EG_Proxy_User_Name" ]
       then
          echo proxyUserName=null >> /custom/egvmagent/lib/eg_managersetup.ini
       else
          echo proxyUserName=$EG_Proxy_User_Name >> /custom/egvmagent/lib/eg_managersetup.ini
      fi
      if [ -z "$EG_Proxy_Password" ]
       then
          echo proxyPassword=null >> /custom/egvmagent/lib/eg_managersetup.ini
       else
          echo proxyPassword=$EG_Proxy_Password >> /custom/egvmagent/lib/eg_managersetup.ini
      fi
      if [ "$EG_Manager_SSL" = true ]
       then
          echo url=https'\'://$EG_Manager'\':$EG_Manager_Port/final/servlet >> /custom/egvmagent/lib/eg_managersetup.ini
       else
          echo url=http'\'://$EG_Manager'\':$EG_Manager_Port/final/servlet >> /custom/egvmagent/lib/eg_managersetup.ini
       fi
      if [ -z "$EG_Remoteagent_IP" ]
       then 

          echo RemoteAgentIP=null >> /custom/egvmagent/lib/eg_managersetup.ini
          echo IsRemoteAgentConfigured=false >> /custom/egvmagent/lib/eg_managersetup.ini

       else

          echo RemoteAgentIP=$EG_Remoteagent_IP >> /custom/egvmagent/lib/eg_managersetup.ini
          echo IsRemoteAgentConfigured=true >> /custom/egvmagent/lib/eg_managersetup.ini
      fi
      if [ -z "$EG_Remoteagent_Port" ]
       then
          echo RemoteAgentPort=$EG_Remoteagent_Port >> /custom/egvmagent/lib/eg_managersetup.ini
       else
          echo RemoteAgentPort=null >> /custom/egvmagent/lib/eg_managersetup.ini
      fi
}
##################################################################
# main 
##################################################################

read_values

eg_values

exit

