/*
 * Decompiled with CFR 0.152.
 */
import com.egurkha.util.EgUtilities;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Random;
import java.util.StringTokenizer;

public class CtxXcXAICASessions {
    private static String whoami = "CtxXcXAICASessions";
    private static long lastRunTime = 0L;
    private static long lastVdaRunTime = 0L;
    private static long ctxProcsRefresh = 30000L;
    private static EgUtilities egutil = EgUtilities.createInstance();
    private static Hashtable allSessionHash = new Hashtable();
    private static Hashtable vdaInfoHash = new Hashtable();
    private static Hashtable vdaPolicyInfoHash = new Hashtable();
    private static ArrayList querySessionList = new ArrayList();
    private static Hashtable sessionIdUserHash = new Hashtable();
    private static final String ctxRegCmd = "sudo /opt/Citrix/VDA/bin/ctxreg list -k ";
    private static final String ctxSessionCmd = "sudo /opt/Citrix/VDA/bin/ctxreg list -k HKLM\\Software\\Citrix\\Ica";
    private static final String ctxVdaCmd = "sudo /opt/Citrix/VDA/bin/ctxreg list -k HKLM\\Software\\Citrix\\VirtualDesktopAgent\\State";
    private static final String ctxVdaPolicyCmd = "sudo /opt/Citrix/VDA/bin/ctxreg read -k HKLM\\Software\\Citrix\\VirtualDesktopAgent\\Policy -v RegisteredDdcFqdn";
    private static final String ctxQueryCmd = "/opt/Citrix/VDA/bin/ctxquery -f uNSadItnl";

    public Hashtable getSessionInfo() {
        Hashtable hashtable = null;
        try {
            hashtable = (Hashtable)allSessionHash.clone();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (hashtable == null) {
            hashtable = new Hashtable();
        }
        return hashtable;
    }

    public Hashtable getVDAInfo() {
        Hashtable hashtable = null;
        try {
            hashtable = (Hashtable)vdaInfoHash.clone();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (hashtable == null) {
            hashtable = new Hashtable();
        }
        return hashtable;
    }

    public Hashtable getVDAPolicyInfo() {
        Hashtable hashtable = null;
        try {
            hashtable = (Hashtable)vdaPolicyInfoHash.clone();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (hashtable == null) {
            hashtable = new Hashtable();
        }
        return hashtable;
    }

    public ArrayList getQuerySessionInfo() {
        ArrayList arrayList = null;
        try {
            arrayList = (ArrayList)querySessionList.clone();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (arrayList == null) {
            arrayList = new ArrayList();
        }
        return arrayList;
    }

    public Hashtable getSessionIdUserInfo() {
        Hashtable hashtable = null;
        try {
            hashtable = (Hashtable)sessionIdUserHash.clone();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (hashtable == null) {
            hashtable = new Hashtable();
        }
        return hashtable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        long l = System.currentTimeMillis();
        if (l - lastRunTime < ctxProcsRefresh) {
            return;
        }
        String string = whoami;
        synchronized (string) {
            ArrayList arrayList;
            if (l - lastRunTime < ctxProcsRefresh) {
                return;
            }
            this.getQuerySessionDetails();
            int n = (int)this.getRandom(50.0, 70.0, new Random());
            if (l - lastVdaRunTime >= (long)n * ctxProcsRefresh) {
                System.out.println("[CtxXcXAICASessions] discover VDA and VDA Policy at : " + new Date());
                this.getVDADetails();
                this.getVDAPolicyDetails();
                lastVdaRunTime = System.currentTimeMillis();
            }
            if ((arrayList = egutil.getExecOutputLines(ctxSessionCmd)) == null || arrayList.size() < 2) {
                System.out.println("[CtxXcXAICASessions] Failed to runsudo /opt/Citrix/VDA/bin/ctxreg list -k HKLM\\Software\\Citrix\\Ica");
                allSessionHash = new Hashtable();
                return;
            }
            if ((arrayList = (ArrayList)arrayList.get(0)) == null || arrayList.size() == 0) {
                System.out.println("[CtxXcXAICASessions] out is NULL or size is ZERO ");
                allSessionHash = new Hashtable();
                return;
            }
            allSessionHash = new Hashtable();
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            String string2 = "";
            String string3 = "";
            String string4 = "";
            String string5 = "";
            int n2 = arrayList.size();
            for (int i = 0; i < n2; ++i) {
                string3 = (String)arrayList.get(i);
                if (string3 == null || string3.trim().length() == 0) continue;
                if ((string3 = string3.trim()).indexOf("HKLM\\Software\\Citrix\\Ica\\Session\\") >= 0 && string3.indexOf("\\Connection\\") > 0) {
                    int n3 = string3.indexOf("\\Session\\");
                    int n4 = string3.indexOf("\\Connection\\");
                    if (n4 <= n3) continue;
                    string2 = string3.substring(n3 + 9, n4);
                    continue;
                }
                if (string3.indexOf("HKLM\\Software\\Citrix\\Ica\\Session\\") >= 0 && string3.indexOf("\\Graphics\\") > 0) continue;
                if (string3.indexOf("HKLM\\Software\\Citrix\\Ica\\Session\\") >= 0) {
                    if (hashtable != null && hashtable.size() > 0 && string2 != null && string2.trim().length() > 0) {
                        allSessionHash.put(string2, hashtable);
                    }
                    hashtable = new Hashtable();
                    string2 = "";
                    continue;
                }
                ArrayList arrayList2 = this.getVarAndVal(string3);
                if (arrayList2 == null || arrayList2.size() < 2) continue;
                string4 = (String)arrayList2.get(0);
                string5 = arrayList2.get(1);
                hashtable.put(string4, string5);
            }
            lastRunTime = System.currentTimeMillis();
        }
    }

    private void getVDADetails() {
        ArrayList arrayList = egutil.getExecOutputLines(ctxVdaCmd);
        if (arrayList == null || arrayList.size() < 2) {
            vdaInfoHash = new Hashtable();
            return;
        }
        if ((arrayList = (ArrayList)arrayList.get(0)) == null || arrayList.size() == 0) {
            vdaInfoHash = new Hashtable();
            return;
        }
        vdaInfoHash = new Hashtable();
        String string = "";
        String string2 = "";
        String string3 = "";
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            ArrayList arrayList2;
            string = (String)arrayList.get(i);
            if (string == null || string.trim().length() == 0 || (arrayList2 = this.getVarAndVal(string = string.trim())) == null || arrayList2.size() < 2) continue;
            string2 = (String)arrayList2.get(0);
            string3 = arrayList2.get(1);
            vdaInfoHash.put(string2, string3);
        }
    }

    private void getVDAPolicyDetails() {
        ArrayList arrayList = egutil.getExecOutputLines(ctxVdaPolicyCmd);
        if (arrayList == null || arrayList.size() < 2) {
            vdaPolicyInfoHash = new Hashtable();
            return;
        }
        if ((arrayList = (ArrayList)arrayList.get(0)) == null || arrayList.size() == 0) {
            vdaPolicyInfoHash = new Hashtable();
            return;
        }
        vdaPolicyInfoHash = new Hashtable();
        String string = "";
        String string2 = "";
        String string3 = "";
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            string = (String)arrayList.get(i);
            if (string == null || string.trim().length() == 0) continue;
            string = string.trim();
            string2 = "RegisteredDdcFqdn";
            string3 = string;
            vdaPolicyInfoHash.put(string2, string3);
        }
    }

    private void getQuerySessionDetails() {
        ArrayList arrayList = egutil.getExecOutputLines(ctxQueryCmd);
        if (arrayList == null || arrayList.size() < 2) {
            querySessionList = new ArrayList();
            sessionIdUserHash = new Hashtable();
            return;
        }
        if ((arrayList = (ArrayList)arrayList.get(0)) == null || arrayList.size() == 0) {
            querySessionList = new ArrayList();
            sessionIdUserHash = new Hashtable();
            return;
        }
        querySessionList = new ArrayList();
        sessionIdUserHash = new Hashtable();
        String string = "";
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            string = (String)arrayList.get(i);
            if (string == null || string.trim().length() == 0) continue;
            string = string.trim();
            if (i == 0) continue;
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            if (stringTokenizer.countTokens() >= 2) {
                String string2 = stringTokenizer.nextToken().trim();
                String string3 = stringTokenizer.nextToken().trim();
                sessionIdUserHash.put(string3, string2);
            }
            querySessionList.add(string);
        }
    }

    private ArrayList getVarAndVal(String string) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (string == null || string.trim().length() == 0) {
            return arrayList;
        }
        int n = (string = string.trim()).indexOf("=");
        if (n < 0) {
            return arrayList;
        }
        String string2 = string.substring(0, n).trim();
        String string3 = string.substring(n + 1).trim();
        int n2 = string2.indexOf("]");
        if (n2 < 0) {
            return arrayList;
        }
        if ((string2 = string2.substring(n2 + 1).trim()).startsWith("\"") && string2.endsWith("\"")) {
            string2 = string2.substring(1, string2.length() - 1).trim();
        }
        if (string3.startsWith("\"") && string3.endsWith("\"")) {
            string3 = string3.substring(1, string3.length() - 1).trim();
        }
        if (string.indexOf("[REG_DWORD]") >= 0) {
            double d = this.getDoubleValueForHexaDecimal(string3);
            arrayList.add(string2);
            arrayList.add(new Double(d));
        } else if (string.indexOf("[REG_SZ]") >= 0) {
            String string4 = this.getValueForString(string3);
            arrayList.add(string2);
            arrayList.add(string4);
        }
        return arrayList;
    }

    private double getDoubleValueForHexaDecimal(String string) {
        double d = -5.0;
        if (string == null || string.trim().length() == 0) {
            return d;
        }
        string = string.trim();
        try {
            Integer n = Integer.decode(string);
            if (n != null) {
                d = n.intValue();
            }
        }
        catch (Exception exception) {
            d = -5.0;
        }
        return d;
    }

    private String getValueForString(String string) {
        String string2 = "-";
        if (string == null || string.trim().length() == 0) {
            return string2;
        }
        string2 = string.trim();
        return string2;
    }

    private double getRandom(double d, double d2, Random random) {
        double d3 = -5.0;
        double d4 = d2 - d;
        double d5 = d4 * random.nextDouble();
        d3 = d5 + d;
        return d3;
    }

    public static void main(String[] stringArray) {
        CtxXcXAICASessions ctxXcXAICASessions = new CtxXcXAICASessions();
        ctxXcXAICASessions.execute();
        System.out.println("getSessionInfo " + ctxXcXAICASessions.getSessionInfo());
        System.out.println("getVDAInfo " + ctxXcXAICASessions.getVDAInfo());
        System.out.println("getVDAPolicyInfo " + ctxXcXAICASessions.getVDAPolicyInfo());
        System.out.println("getQuerySessionInfo " + ctxXcXAICASessions.getQuerySessionInfo());
        System.out.println("getSessionIdUserInfo " + ctxXcXAICASessions.getSessionIdUserInfo());
    }
}

