/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.glassfish.gmbal;

import com.sun.org.glassfish.gmbal.AMXMBeanInterface;
import com.sun.org.glassfish.gmbal.GmbalException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.Descriptor;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;
import javax.management.modelmbean.ModelMBeanInfo;

public class AMXClient
implements AMXMBeanInterface {
    public static final ObjectName NULL_OBJECTNAME = AMXClient.makeObjectName("null:type=Null,name=Null");
    private MBeanServerConnection server;
    private ObjectName oname;

    private static ObjectName makeObjectName(String string) {
        try {
            return new ObjectName(string);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            return null;
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AMXClient)) {
            return false;
        }
        AMXClient aMXClient = (AMXClient)object;
        return this.oname.equals(aMXClient.oname);
    }

    public int hashCode() {
        int n = 5;
        n = 47 * n + (this.oname != null ? this.oname.hashCode() : 0);
        return n;
    }

    public String toString() {
        return "AMXClient[" + this.oname + "]";
    }

    private <T> T fetchAttribute(String string, Class<T> clazz) {
        try {
            Object object = this.server.getAttribute(this.oname, string);
            if (NULL_OBJECTNAME.equals(object)) {
                return null;
            }
            return clazz.cast(object);
        }
        catch (JMException jMException) {
            throw new GmbalException("Exception in fetchAttribute", jMException);
        }
        catch (IOException iOException) {
            throw new GmbalException("Exception in fetchAttribute", iOException);
        }
    }

    public AMXClient(MBeanServerConnection mBeanServerConnection, ObjectName objectName) {
        this.server = mBeanServerConnection;
        this.oname = objectName;
    }

    private AMXClient makeAMX(ObjectName objectName) {
        if (objectName == null) {
            return null;
        }
        return new AMXClient(this.server, objectName);
    }

    @Override
    public String getName() {
        return this.fetchAttribute("Name", String.class);
    }

    @Override
    public Map<String, ?> getMeta() {
        try {
            ModelMBeanInfo modelMBeanInfo = (ModelMBeanInfo)((Object)this.server.getMBeanInfo(this.oname));
            Descriptor descriptor = modelMBeanInfo.getMBeanDescriptor();
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            for (String string : descriptor.getFieldNames()) {
                hashMap.put(string, descriptor.getFieldValue(string));
            }
            return hashMap;
        }
        catch (MBeanException mBeanException) {
            throw new GmbalException("Exception in getMeta", mBeanException);
        }
        catch (RuntimeOperationsException runtimeOperationsException) {
            throw new GmbalException("Exception in getMeta", runtimeOperationsException);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw new GmbalException("Exception in getMeta", instanceNotFoundException);
        }
        catch (IntrospectionException introspectionException) {
            throw new GmbalException("Exception in getMeta", introspectionException);
        }
        catch (ReflectionException reflectionException) {
            throw new GmbalException("Exception in getMeta", reflectionException);
        }
        catch (IOException iOException) {
            throw new GmbalException("Exception in getMeta", iOException);
        }
    }

    @Override
    public AMXClient getParent() {
        ObjectName objectName = this.fetchAttribute("Parent", ObjectName.class);
        return this.makeAMX(objectName);
    }

    public AMXClient[] getChildren() {
        ObjectName[] objectNameArray = this.fetchAttribute("Children", ObjectName[].class);
        return this.makeAMXArray(objectNameArray);
    }

    private AMXClient[] makeAMXArray(ObjectName[] objectNameArray) {
        AMXClient[] aMXClientArray = new AMXClient[objectNameArray.length];
        int n = 0;
        for (ObjectName objectName : objectNameArray) {
            aMXClientArray[n++] = this.makeAMX(objectName);
        }
        return aMXClientArray;
    }

    public Object getAttribute(String string) {
        try {
            return this.server.getAttribute(this.oname, string);
        }
        catch (MBeanException mBeanException) {
            throw new GmbalException("Exception in getAttribute", mBeanException);
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            throw new GmbalException("Exception in getAttribute", attributeNotFoundException);
        }
        catch (ReflectionException reflectionException) {
            throw new GmbalException("Exception in getAttribute", reflectionException);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw new GmbalException("Exception in getAttribute", instanceNotFoundException);
        }
        catch (IOException iOException) {
            throw new GmbalException("Exception in getAttribute", iOException);
        }
    }

    public void setAttribute(String string, Object object) {
        Attribute attribute = new Attribute(string, object);
        this.setAttribute(attribute);
    }

    public void setAttribute(Attribute attribute) {
        try {
            this.server.setAttribute(this.oname, attribute);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw new GmbalException("Exception in setAttribute", instanceNotFoundException);
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            throw new GmbalException("Exception in setAttribute", attributeNotFoundException);
        }
        catch (InvalidAttributeValueException invalidAttributeValueException) {
            throw new GmbalException("Exception in setAttribute", invalidAttributeValueException);
        }
        catch (MBeanException mBeanException) {
            throw new GmbalException("Exception in setAttribute", mBeanException);
        }
        catch (ReflectionException reflectionException) {
            throw new GmbalException("Exception in setAttribute", reflectionException);
        }
        catch (IOException iOException) {
            throw new GmbalException("Exception in setAttribute", iOException);
        }
    }

    public AttributeList getAttributes(String[] stringArray) {
        try {
            return this.server.getAttributes(this.oname, stringArray);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw new GmbalException("Exception in getAttributes", instanceNotFoundException);
        }
        catch (ReflectionException reflectionException) {
            throw new GmbalException("Exception in getAttributes", reflectionException);
        }
        catch (IOException iOException) {
            throw new GmbalException("Exception in getAttributes", iOException);
        }
    }

    public AttributeList setAttributes(AttributeList attributeList) {
        try {
            return this.server.setAttributes(this.oname, attributeList);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw new GmbalException("Exception in setAttributes", instanceNotFoundException);
        }
        catch (ReflectionException reflectionException) {
            throw new GmbalException("Exception in setAttributes", reflectionException);
        }
        catch (IOException iOException) {
            throw new GmbalException("Exception in setAttributes", iOException);
        }
    }

    public Object invoke(String string, Object[] objectArray, String[] stringArray) throws MBeanException, ReflectionException {
        try {
            return this.server.invoke(this.oname, string, objectArray, stringArray);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw new GmbalException("Exception in invoke", instanceNotFoundException);
        }
        catch (IOException iOException) {
            throw new GmbalException("Exception in invoke", iOException);
        }
    }

    public MBeanInfo getMBeanInfo() {
        try {
            return this.server.getMBeanInfo(this.oname);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw new GmbalException("Exception in invoke", instanceNotFoundException);
        }
        catch (IntrospectionException introspectionException) {
            throw new GmbalException("Exception in invoke", introspectionException);
        }
        catch (ReflectionException reflectionException) {
            throw new GmbalException("Exception in invoke", reflectionException);
        }
        catch (IOException iOException) {
            throw new GmbalException("Exception in invoke", iOException);
        }
    }

    public ObjectName objectName() {
        return this.oname;
    }
}

