/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jnlp;

import com.sun.deploy.model.LocalApplicationProperties;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.trace.Trace;
import com.sun.javaws.util.JNLPUtils;
import com.sun.jnlp.ApiDialog;
import com.sun.jnlp.CheckServicePermission;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.jnlp.ClipboardService;

public final class ClipboardServiceImpl
implements ClipboardService {
    private static ClipboardServiceImpl _sharedInstance = null;
    private Clipboard _sysClipboard = null;
    private ApiDialog _readDialog = new ApiDialog();
    private ApiDialog _writeDialog = new ApiDialog();

    private ClipboardServiceImpl() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        if (toolkit != null) {
            this._sysClipboard = toolkit.getSystemClipboard();
        }
    }

    public static synchronized ClipboardServiceImpl getInstance() {
        if (_sharedInstance == null) {
            _sharedInstance = new ClipboardServiceImpl();
        }
        return _sharedInstance;
    }

    public Transferable getContents() {
        if (!this.askUser(false)) {
            return null;
        }
        return AccessController.doPrivileged(new PrivilegedAction<Transferable>(){

            @Override
            public Transferable run() {
                return ClipboardServiceImpl.this._sysClipboard.getContents(null);
            }
        });
    }

    public void setContents(final Transferable transferable) {
        if (!this.askUser(true)) {
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                if (transferable != null) {
                    DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
                    if (dataFlavorArray == null || dataFlavorArray[0] == null) {
                        return null;
                    }
                    try {
                        if (transferable.getTransferData(dataFlavorArray[0]) == null) {
                            return null;
                        }
                    }
                    catch (IOException iOException) {
                        Trace.ignoredException((Exception)iOException);
                    }
                    catch (UnsupportedFlavorException unsupportedFlavorException) {
                        Trace.ignoredException((Exception)unsupportedFlavorException);
                    }
                }
                ClipboardServiceImpl.this._sysClipboard.setContents(transferable, null);
                return null;
            }
        });
    }

    private synchronized boolean askUser(boolean bl) {
        if (!this.hasClipboard()) {
            return false;
        }
        if (CheckServicePermission.hasClipboardPermissions()) {
            return true;
        }
        String string = ResourceManager.getString((String)"api.clipboard.title");
        if (bl) {
            String string2 = ResourceManager.getString((String)"api.clipboard.message.write");
            String string3 = ResourceManager.getString((String)"api.clipboard.write.always");
            return ClipboardServiceImpl.askUser(this._writeDialog, string, string2, string3, "jnlp.api.always.ClipboardService.write");
        }
        String string4 = ResourceManager.getString((String)"api.clipboard.message.read");
        String string5 = ResourceManager.getString((String)"api.clipboard.read.always");
        return ClipboardServiceImpl.askUser(this._readDialog, string, string4, string5, "jnlp.api.always.ClipboardService.read");
    }

    private static boolean askUser(ApiDialog apiDialog, String string, String string2, String string3, final String string4) {
        Object object;
        final LocalApplicationProperties localApplicationProperties = JNLPUtils.getLocalApplicationProperties();
        if (localApplicationProperties != null && (object = localApplicationProperties.get(string4)) != null) {
            return true;
        }
        object = apiDialog.askUser(string, string2, string3);
        if (object == ApiDialog.DialogResult.ALWAYS) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    localApplicationProperties.put(string4, "skip");
                    try {
                        localApplicationProperties.store();
                    }
                    catch (Throwable throwable) {
                        Trace.ignored((Throwable)throwable);
                    }
                    return null;
                }
            });
        }
        return object == ApiDialog.DialogResult.OK || object == ApiDialog.DialogResult.ALWAYS;
    }

    private boolean hasClipboard() {
        return this._sysClipboard != null;
    }
}

