<%@ page import="java.net.Inet4Address"%>
<%@ page import="java.net.InetAddress"%>
<%@ page import="java.util.ArrayList"%>
<%@ page import="java.io.*"%>
<%@ page import="java.util.zip.GZIPOutputStream"%>
<%@ page import="com.eg.*"%>

<%
	String pageMethod = request.getMethod();
	if(pageMethod.equalsIgnoreCase("GET"))
	{
%>

<html>
<head>
	<title>eG RUM Geo Location Details</title>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<script>
		<%@include file="/WEB-INF/js/jquery.js" %>
	</script>

	<style>
		body{
		font-family: Arial, Helvetica, sans-serif;
		}
		.formLabel
		{
		align: left;
		}
		.formLabel > label{
		padding-right:30px;
		}
		/*.formLabel > input{
		padding-left:30px;
		}*/
		.submit{
		width : 100px;
		height : 25px;
		background-color: #ddddddd;
		}
		.container {
		border-radius: 5px;
		background-color: #D8D8D8;
		padding: 20px;
		max-width: 50%; 
		margin: 0 auto;
		height:200px;
		}
		.resultTable {
		font-family: Arial, Helvetica, sans-serif;
		border-collapse: collapse;
		width: 50%;
		}

		.resultTable td, .resultTable th {
		border: 1px solid #A4A4A4;
		padding: 5px;
		}

		.resultTable tr:nth-child(even){background-color: #f2f2f2;}

		.resultTable tr:hover {background-color: #A4A4A4;}

		.resultTable th {
		padding-top: 6px;
		padding-bottom: 6px;
		text-align: left;
		background-color: grey;
		color: white;
		}

		/* The alert message box */
		.alert {
			padding: 20px;
			background-color: #ff9800;
			color: white;
			margin-bottom: 15px;
		}

		.container .leftpanel{
			width: 250px;
			border-right: 1px solid #ffffff;
			float:left;
			margin-right: 45px;
		}

		.container.rightpanel{
			float:right;
		}

		.success {
			padding: 20px;
			background-color: #009900;
			color: white;
			margin-bottom: 15px;
		}

		.exclamation{
			font-size: 25px;
			vertical-align: middle;
		}

		.exclamation-error{
			font-size: 25px;
			vertical-align: middle;
			color:red!important;
		}

		.vertical { 
			border-left: 1px solid black; 
			height: 200px; 
			position:absolute; 
			left: 50%; 
		}

		.vertical-divider:after {
			clear: both;
			content: " ";
			display: block;
			height: 0;
			visibility: hidden;
		}

		.x-mask-msg {
			z-index:20001;
			position:absolute;
			top:0;
			left:0;
			padding:2px;
			border:0px solid;
			border-color:#abb2bd;
			background-image:none;
			background-color:#ffffff;
			-webkit-box-shadow: 0px 0px 5px 0px rgba(100,100,100,0.35);
			-moz-box-shadow: 0px 0px 5px 0px rgba(100,100,100,0.35);
			box-shadow: 0px 0px 5px 0px rgba(100,100,100,0.35);
		}

		.x-mask-msg div {
			padding:6px 10px 6px 42px;
			background-image:url("./images/preloader_light.gif");
			background-repeat:no-repeat;
			background-position:6px 7px;
			cursor:wait;
			border-width:0px;
			background-color:#ffffff;
			color:#0e0e0e;
			font-size:12px;
		}

		#outer-div{
			position: fixed;
			top: 0;
			left: 0;
			right: 0;
			bottom: 0;
			/*background-color: transparent; */
			background-color: #0000004d;
			z-index: 9999999999;
			height: 100%;
			opacity: 3;
		}

	</style>

	<script>
		$(window).on('load', function() {
			hideLoading();
		})

		function showLoading(){
			setTimeout(function() {
				$('#outer-div').show();
				$('#status-popup').show();
				$('#preloader-popup').show();
			}, 1);
		}

		function hideLoading(){
			setTimeout(function() {
				$('#outer-div').hide();
				$('#status-popup').hide();
				$('#preloader-popup').hide();
			}, 1);
		}
	</script>
	<script>
	!function(n){"use strict";function t(n,t){var r=(65535&n)+(65535&t);return(n>>16)+(t>>16)+(r>>16)<<16|65535&r}function r(n,t){return n<<t|n>>>32-t}function e(n,e,o,u,c,f){return t(r(t(t(e,n),t(u,f)),c),o)}function o(n,t,r,o,u,c,f){return e(t&r|~t&o,n,t,u,c,f)}function u(n,t,r,o,u,c,f){return e(t&o|r&~o,n,t,u,c,f)}function c(n,t,r,o,u,c,f){return e(t^r^o,n,t,u,c,f)}function f(n,t,r,o,u,c,f){return e(r^(t|~o),n,t,u,c,f)}function i(n,r){n[r>>5]|=128<<r%32,n[14+(r+64>>>9<<4)]=r;var e,i,a,d,h,l=1732584193,g=-271733879,v=-1732584194,m=271733878;for(e=0;e<n.length;e+=16)i=l,a=g,d=v,h=m,g=f(g=f(g=f(g=f(g=c(g=c(g=c(g=c(g=u(g=u(g=u(g=u(g=o(g=o(g=o(g=o(g,v=o(v,m=o(m,l=o(l,g,v,m,n[e],7,-680876936),g,v,n[e+1],12,-389564586),l,g,n[e+2],17,606105819),m,l,n[e+3],22,-1044525330),v=o(v,m=o(m,l=o(l,g,v,m,n[e+4],7,-176418897),g,v,n[e+5],12,1200080426),l,g,n[e+6],17,-1473231341),m,l,n[e+7],22,-45705983),v=o(v,m=o(m,l=o(l,g,v,m,n[e+8],7,1770035416),g,v,n[e+9],12,-1958414417),l,g,n[e+10],17,-42063),m,l,n[e+11],22,-1990404162),v=o(v,m=o(m,l=o(l,g,v,m,n[e+12],7,1804603682),g,v,n[e+13],12,-40341101),l,g,n[e+14],17,-1502002290),m,l,n[e+15],22,1236535329),v=u(v,m=u(m,l=u(l,g,v,m,n[e+1],5,-165796510),g,v,n[e+6],9,-1069501632),l,g,n[e+11],14,643717713),m,l,n[e],20,-373897302),v=u(v,m=u(m,l=u(l,g,v,m,n[e+5],5,-701558691),g,v,n[e+10],9,38016083),l,g,n[e+15],14,-660478335),m,l,n[e+4],20,-405537848),v=u(v,m=u(m,l=u(l,g,v,m,n[e+9],5,568446438),g,v,n[e+14],9,-1019803690),l,g,n[e+3],14,-187363961),m,l,n[e+8],20,1163531501),v=u(v,m=u(m,l=u(l,g,v,m,n[e+13],5,-1444681467),g,v,n[e+2],9,-51403784),l,g,n[e+7],14,1735328473),m,l,n[e+12],20,-1926607734),v=c(v,m=c(m,l=c(l,g,v,m,n[e+5],4,-378558),g,v,n[e+8],11,-2022574463),l,g,n[e+11],16,1839030562),m,l,n[e+14],23,-35309556),v=c(v,m=c(m,l=c(l,g,v,m,n[e+1],4,-1530992060),g,v,n[e+4],11,1272893353),l,g,n[e+7],16,-155497632),m,l,n[e+10],23,-1094730640),v=c(v,m=c(m,l=c(l,g,v,m,n[e+13],4,681279174),g,v,n[e],11,-358537222),l,g,n[e+3],16,-722521979),m,l,n[e+6],23,76029189),v=c(v,m=c(m,l=c(l,g,v,m,n[e+9],4,-640364487),g,v,n[e+12],11,-421815835),l,g,n[e+15],16,530742520),m,l,n[e+2],23,-995338651),v=f(v,m=f(m,l=f(l,g,v,m,n[e],6,-198630844),g,v,n[e+7],10,1126891415),l,g,n[e+14],15,-1416354905),m,l,n[e+5],21,-57434055),v=f(v,m=f(m,l=f(l,g,v,m,n[e+12],6,1700485571),g,v,n[e+3],10,-1894986606),l,g,n[e+10],15,-1051523),m,l,n[e+1],21,-2054922799),v=f(v,m=f(m,l=f(l,g,v,m,n[e+8],6,1873313359),g,v,n[e+15],10,-30611744),l,g,n[e+6],15,-1560198380),m,l,n[e+13],21,1309151649),v=f(v,m=f(m,l=f(l,g,v,m,n[e+4],6,-145523070),g,v,n[e+11],10,-1120210379),l,g,n[e+2],15,718787259),m,l,n[e+9],21,-343485551),l=t(l,i),g=t(g,a),v=t(v,d),m=t(m,h);return[l,g,v,m]}function a(n){var t,r="",e=32*n.length;for(t=0;t<e;t+=8)r+=String.fromCharCode(n[t>>5]>>>t%32&255);return r}function d(n){var t,r=[];for(r[(n.length>>2)-1]=void 0,t=0;t<r.length;t+=1)r[t]=0;var e=8*n.length;for(t=0;t<e;t+=8)r[t>>5]|=(255&n.charCodeAt(t/8))<<t%32;return r}function h(n){return a(i(d(n),8*n.length))}function l(n,t){var r,e,o=d(n),u=[],c=[];for(u[15]=c[15]=void 0,o.length>16&&(o=i(o,8*n.length)),r=0;r<16;r+=1)u[r]=909522486^o[r],c[r]=1549556828^o[r];return e=i(u.concat(d(t)),512+8*t.length),a(i(c.concat(e),640))}function g(n){var t,r,e="";for(r=0;r<n.length;r+=1)t=n.charCodeAt(r),e+="0123456789abcdef".charAt(t>>>4&15)+"0123456789abcdef".charAt(15&t);return e}function v(n){return unescape(encodeURIComponent(n))}function m(n){return h(v(n))}function p(n){return g(m(n))}function s(n,t){return l(v(n),v(t))}function C(n,t){return g(s(n,t))}function A(n,t,r){return t?r?s(t,n):C(t,n):r?m(n):p(n)}"function"==typeof define&&define.amd?define(function(){return A}):"object"==typeof module&&module.exports?module.exports=A:n.md5=A}(this);
	</script>
	<script>
		function setPwd()
		{
			var pwd = document.getElementById('password').value;
			document.getElementById('q').value = md5(pwd);
		}
		function getIpDetails()
		{
			setPwd();
			document.getElementById("resultGeoDiv").innerHTML ="";
			var ip=document.getElementById("ip").value;
			var pwd=document.getElementById("q").value;
			if(!ip  || ip.trim().length == 0){
				document.getElementById("resultDiv").innerHTML = '<p class="alert"><span>&#10071;</span> Enter the IP Address.</p>';
				return false;
			}
			if(ip){
				var arrIp = ip.split(".");
				if (arrIp.length !== 4) 
				{
					document.getElementById("resultDiv").innerHTML = '<p class="alert"><span>&#10071;</span> Enter the Valid Ip Address.</p>';
					return false;
				}
			    for (let oct of arrIp) {
					if ( isNaN(oct) || Number(oct) < 0 || Number(oct) > 255)
					{
						document.getElementById("resultDiv").innerHTML = '<p class="alert"><span>&#10071;</span> Enter the Valid Ip Address.</p>';
						return false;
					}
				}
			}
			if(!pwd || pwd.trim().length == 0){
				document.getElementById("resultDiv").innerHTML = '<p class="alert"><span>&#10071;</span> Enter the Password to get Geo Details.</p>';
				return false;
			}
			var parameters ="ip="+ip+"&q="+pwd;
			var url = "/rumcollector/GeoLocationDetails.jsp";

			var xmlhttp;
			if (window.XMLHttpRequest)
			{
				xmlhttp=new XMLHttpRequest();
			}
			else
			{
				xmlhttp=new ActiveXObject("Microsoft.XMLHTTP");
			}
			xmlhttp.open("POST",url,true);
			xmlhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
			xmlhttp.onreadystatechange = function(elements)
			{
				if (xmlhttp.readyState == 4)
				{
					var abc = xmlhttp.responseText;
					document.getElementById("resultDiv").innerHTML = abc;
				}
			}
			xmlhttp.send(parameters);//parameters
		}
		function pwdKeyPress(e){
			 if (e.keyCode == 13) {
				 getIpDetails();
			 }
			 return true;
		}

		function loadGeoMap(loadgeofile){
		
			document.getElementById("resultDiv").innerHTML ="";
			document.getElementById("resultGeoDiv").innerHTML ="";
			var fileName= document.getElementById("mmdbfile").value;
			var reg = /(.*?)\.(mmdb|zip)$/;
			
			if(!fileName.match(reg)) {
				document.getElementById("resultGeoDiv").innerHTML = '<p class="alert"><span class="exclamation-error">&#33;</span> Please upload a valid GeoLite2-City.mmdb file</p>';
				return false;
			}

			var geopwd = document.getElementById('geopassword').value;

			if(!geopwd || geopwd.trim().length == 0){
				document.getElementById("resultGeoDiv").innerHTML = '<p class="alert"><span class="exclamation-error">&#33;</span> Enter the Password to upload GeoLite2-City.mmdb file.</p>';
				return false;
			}
			var fileSize=parseInt($('#mmdbfile')[0].files[0].size);
			if(fileSize >= 104857600){
				document.getElementById("resultGeoDiv").innerHTML = '<p class="alert"><span class="exclamation-error">&#33;</span> Uploaded file size is limited to 100 MB</p>';
				return false;
			}

			var pwd= md5(geopwd);
			var url = "/rumcollector/GeoLocationDetails.jsp";

			var mmdbfile = document.getElementById("mmdbfile").files[0];
			var formdata = new FormData();
			formdata.append("loadgeofile", loadgeofile);
			formdata.append("q", pwd);
			formdata.append("fileName", fileName);
			formdata.append("mmdbfile", mmdbfile);

			var xmlhttp;
			if (window.XMLHttpRequest) {
				xmlhttp=new XMLHttpRequest();
			}
			else {
				xmlhttp=new ActiveXObject("Microsoft.XMLHTTP");
			}
			xmlhttp.open("POST",url,true);
			xmlhttp.setRequestHeader("enctype", "multipart/form-data");
			xmlhttp.setRequestHeader("Content-Encoding", "gzip");
			xmlhttp.onreadystatechange = function(elements) {
				if (xmlhttp.readyState == 4) {
					hideLoading();
					var abc = xmlhttp.responseText;
					document.getElementById("resultGeoDiv").innerHTML = abc;
					document.getElementById("mmdbfile").value = "";
					document.getElementById('geopassword').value = "";
				}
			}
			xmlhttp.send(formdata);//parameters
			showLoading();
		}
	</script>
</head>
<body>

	<div class="container">
		<div class="leftpanel">
			<h3> Enter the details :</h3>
			<div>
				<div class="formLabel">
					<label>Public IP Address : </label>
				</div>
				<input id="ip" type="text" required placeholder='xxx.xxx.xxx.xxx'/>
			</div>
			<br/>
			<div>
				<div class="formLabel">
					<label class="formLabel">Password : </label>
				</div>
				<input id="password" type="password" onkeypress="pwdKeyPress(event);"/>
				<input name="q" id="q" type="hidden" value=""/>
			</div>
			<br/>
			<div>
				<input type="submit" value="Submit" class="submit" id="submit" onClick="getIpDetails()"/>
				<a href="GeoLocationDetails.jsp"><input type="button" value="Clear" class="submit"/></a>
			</div>
		</div>

		<div class="rightpanel">
		<h3> Upload new verion of MMDB file :</h3>

		<table cellpadding="0" cellspacing="0" border="0">
			<tr><td height="15"></td></tr>
			<tr>
				<td>Upload MMDB File : </td>
				<td width="5"></td>
				<td><input type="file" id="mmdbfile" name="mmdbfile"/></td>
				<td width="5"></td>
				<td></td>
			</tr>
			<tr><td height="15" colspan="3"></td></tr>
			<tr>
				<td>Password : </td>
				<td width="5"></td>
				<td><input type="password" id="geopassword" name="geopassword" value=""/></td>
				<td><input type="hidden" value="" name="geoq" id="geoq" /></td>
				<td>&nbsp;</td>
			</tr>
			<tr><td height="15" colspan="3"></td></tr>	
			<tr>
				<td></td>
				<td width="5"></td>
				<td><input type="button" id="egommdd" name="geommdb" value="Upload" class="submit" onClick="loadGeoMap('geommdb');"/></td>
				<td></td>
				<td>&nbsp;</td>
			</tr>
		</table>
	</div>
</div>
<div id="resultDiv"></div>
<div id="resultGeoDiv"></div>

<!--Loading div start -->
<div id="outer-div">
	<div id="preloader-popup" class="x-mask-msg" style="z-index: 19001;left:45%;top:35%;">
		<div id="status-popup">Loading...</div>
	</div>
</div>
<!--Loading div ends -->

</body>
</html>	
<%

}
else{
	
	String contentType = request.getContentType();
	String password = request.getParameter("q");

	GeoLocationDetails geoObj = GeoLocationDetails.getInstance();

	if(contentType!=null && contentType.equalsIgnoreCase("application/x-www-form-urlencoded")){
		String ip = request.getParameter("ip");
		if(ip != null && ip.length() > 0)
		{
			if (password == null || (password != null && !password.equalsIgnoreCase(GeoLocationDetails.getCredentials()))) {
%>
				<p class="alert"><span class="exclamation">&#10071;</span>The given credential is incorrect. Please provide a valid credential.</p>
<%	
				return;
			}
					//InetAddress addr = InetAddresses.forString(ip);
					// // Convert to int
					//long address = InetAddresses.coerceToInteger(addr) & 0xFFFFFFFFL;
					//int intAddress = InetAddresses.coerceToInteger(addr) ;
			ArrayList geoDetails = geoObj.getGeoLocDetails(ip);
%>
				<h2>Geo Location Details :</h2>
				<table class="resultTable">
					  <tr>
						<th>GeoDetails</th>
						<th>Values</th>
					  </tr>
					  <tr>
						<td>IP</td>
						<td><%=ip%></td>
					  </tr>
					  <tr>
						<td>Country</td>
						<td><%=geoDetails.get(0)%></td>
					  </tr>
					  <tr>
						<td>Country Code</td>
						<td><%=geoDetails.get(1)%></td>
					  </tr>
					  <tr>
						<td>Region</td>
						<td><%=geoDetails.get(2)%></td>
					  </tr>
					  <tr>
						<td>City</td>
						<td><%=geoDetails.get(3)%></td>
					  </tr>
					  <tr>
						<td>Latitude</td>
						<td><%=geoDetails.get(4)%></td>
					  </tr>
					  <tr>
						<td>Longitude</td>
						<td><%=geoDetails.get(5)%></td>
					  </tr>
				</table>
<%
		}
	}
	else if(contentType!=null && contentType.indexOf("multipart/form-data")!=-1) {
		if (password == null || (password != null && !password.equalsIgnoreCase(GeoLocationDetails.getCredentials()))){
%>
				<p class="alert"><span class="exclamation-error">&#33;</span> The given credential is incorrect. Please provide a valid credential.</p>
<%
				return;
		}
		String loadgeofile = request.getParameter("loadgeofile");
		if(loadgeofile.equalsIgnoreCase("geommdb")) {
			String fileName = request.getParameter("fileName");
			if(fileName.indexOf(".mmdb") == -1 && fileName.indexOf(".zip")== -1){
%>
				<p class="alert"><span class="exclamation-error">&#33;</span> Please upload a valid MMDB file.</p> 
<%
				return;
			}

			int mmdbFileStatus=geoObj.getMmdbFileUploadStatus();;
			if(mmdbFileStatus==1) {
%>
				<p class="alert"><span class="exclamation">&#33;</span> Currenty someone uploading the MMDB file from client IP : <%=geoObj.getMmdbFileUploadingIp()%>, So please wait until the upload process is completed</p>
<%	
				return;
			}

			int fileStatus = -1;
			String remoteHost = request.getRemoteHost();
			Part filePart = request.getPart("mmdbfile");
			InputStream inputStream = filePart.getInputStream();
			String header = filePart.getHeader("content-disposition");
			
			fileStatus = geoObj.uploadMMDBFile(remoteHost, header, inputStream);
			
			String message = "";
			String className = "";
			if(fileStatus==1){
				message = "Successfully updated the geomap mmdb file";
				className = "success";
			}
			else if(fileStatus==0){
				message = "Geomap mmdb file not modified";
				className = "alert";
			}
			else if(fileStatus==-1){
				message = "Error in updating geomap mmdb file";
				className = "alert";
			}
			else if(fileStatus==-2){
				message = "Uploaded zip does not contain the mmdb file";
				className = "alert";
			}
%>
				<p class="<%=className%>"><span class="exclamation">&#33;</span> <%=message%></p>
<%
				return;
			}
		}
	}
%>



