package com.ibc;

import com.ibc.sap.*;
import com.ibc.object.*;
import com.ibc.sap.logic.*;
import com.ibc.session.*;
import com.ibc.connectionPooling.*;
import com.ibc.objectPooling.*;
import com.ibc.resources.*;

import com.eg.EgConMonHelper;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.RequestDispatcher;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpSession;
import javax.servlet.ServletContext;
import javax.servlet.ServletConfig;

public class JvmDemoServlet extends HttpServlet
{
	ServletContext context;

	public static boolean cpuFlag = false;
	public static boolean blockedFlag = false;
	public static boolean waitedFlag = false;
	public static boolean deadFlag = false;
	public static boolean memoryFlag = false;
	public static boolean isJmapSupported = false;

	public void init(ServletConfig config) throws ServletException
	{
		super.init(config);
		context = config.getServletContext();
		isJmapSupported = (System.getProperty("java.version").startsWith("1.6")) ? true : false;
	}

	public void service(HttpServletRequest request, HttpServletResponse response) throws IOException,ServletException
	{

		String param = request.getParameter("param");
		//System.out.println("param : "+param);
		boolean result = false;

		try
		{
			int i = 0;
			if(param != null && param.length() > 0)
				i = Integer.parseInt(param);

			switch (i)
			{
				case 1:
					result = startDemo("cpu");
					if(result)
						cpuFlag = true;
					break;
				case 2:
					result = startDemo("blocked");
					if(result)
						blockedFlag = true;
					break;
				case 3:
					result = startDemo("waited");
					if(result)
						waitedFlag = true;
					break;
				case 4:
					result = startDemo("memory");
					if(result)
						memoryFlag = true;
					break;
				case 5:
					result = stopDemo("cpu");
					if(result)
						cpuFlag = false;
					break;
				case 6:
					result = stopDemo("blocked");
					if(result)
						blockedFlag = false;
					break;
				case 7:
					result = stopDemo("waited");
					if(result)
						waitedFlag = false;
					break;
				case 8:
					result = stopDemo("memory");
					memoryFlag = false;
					break;
				case 9:
					result = startDemo("dead");
					deadFlag = true;
					break;
			}
		}
		catch (Exception ex)
		{
			ex.printStackTrace();
		}

		try
		{
			if (result)
			{
				context.getRequestDispatcher("/admin/EgJvmDemo.jsp?whoami="+EgConMonHelper.whoami+"&pwd="+EgConMonHelper.pwd).forward(request, response);
			}
			else
			{
				return;
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
	}

	private boolean startDemo(String s)
	{
		if(s != null)
		{
			if(s.equals("cpu"))
			{
				return cpuDemo("start");
			}
			else if(s.equals("blocked"))
			{
				return blockedDemo("start");
			}
			else if(s.equals("waited"))
			{
				return waitedDemo("start");
			}
			else if(s.equals("memory"))
			{
				return memoryDemo("start");
			}
			else if(s.equals("dead"))
			{
				return deadDemo("start");
			}
			else
			{
				boolean b1, b2, b3 = false;
				b1 = cpuDemo("start");
				b2 = blockedDemo("start");
				b3 = waitedDemo("start");
				if(b1 && b2 && b3)
					return true;
			}
		}
		return false;
	}

	private boolean stopDemo(String s)
	{
		if(s != null)
		{
			if(s.equals("cpu"))
			{
				return cpuDemo("stop");
			}
			else if(s.equals("blocked"))
			{
				return blockedDemo("stop");
			}
			else if(s.equals("waited"))
			{
				return waitedDemo("stop");
			}
			else if(s.equals("memory"))
			{
				return memoryDemo("stop");
			}
			else
			{
				boolean b1, b2, b3 = false;
				b1 = cpuDemo("stop");
				b2 = blockedDemo("stop");
				b3 = waitedDemo("stop");
				return true;
			}
		}
		return false;
	}

	private boolean cpuDemo(String s)
	{
		if(s != null && s.equals("start"))
		{
			LogicBuilder.finish = false;
			SapBusinessConnector sap = new SapBusinessConnector();
			//System.out.println("INFO : "+new java.util.Date() +" : Started CPU demo ...");
			return true;
		}
		else if(s != null && s.equals("stop"))
		{
			LogicBuilder.finish = true;
			//System.out.println("INFO : "+new java.util.Date() +" : Stopped CPU demo ... ");
			return true;
		}
		return false;
	}

	private boolean blockedDemo(String s)
	{
		if(s != null && s.equals("start"))
		{
			ObjectManager.last = false;
			DbConnection.finish1 = false;
			ObjectManager db1 = new ObjectManager();
			try
			{
				Thread.sleep(2000);
			}
			catch (Exception e)
			{
				e.printStackTrace();
			}
			DatabaseConnectorThread db = new DatabaseConnectorThread();
			//System.out.println("INFO : "+new java.util.Date() +" : Started BLOCKED demo ...");
			return true;
		}
		else if(s != null && s.equals("stop"))
		{
			ObjectManager.last = true;
			DbConnection.finish1 = true;
			//System.out.println("INFO : "+new java.util.Date() +" : Stopped BLOCKED demo ... ");
			return true;
		}
		return false;
	}

	private boolean waitedDemo(String s)
	{
		SessionController sc = SessionController.getInstance();
		if(s != null && s.equals("start"))
		{
			SessionController.isWait = true;
			//sc.startThread();
			//System.out.println("INFO : "+new java.util.Date() +" : Started WAITED demo ...");
			return true;
		}
		else if(s != null && s.equals("stop"))
		{
			SessionController.isWait = false;
			sc.notifyThread();
			//System.out.println("INFO : "+new java.util.Date() +" : Stopped WAITED demo ... ");
			return true;
		}
		return false;
	}

	private boolean deadDemo(String s)
	{
		if(s != null && s.equals("start"))
		{
			ResourceRunner rr = new ResourceRunner();
			return true;
		}
		else
		{
			//Deadlock Cannn't be Stopped..............
		}
		return false;
	}

	private boolean memoryDemo(String s)
	{
		ObjectHandler oh = new ObjectHandler();
		if(s != null && s.equals("start"))
		{
			oh.start();
			//System.out.println("INFO : "+new java.util.Date() +" : Started MEMORY demo ...");
			return true;
		}
		else if(s != null && s.equals("stop"))
		{
			ObjectContainer.finish2 = true;
			//System.out.println("INFO : "+new java.util.Date() +" : Stopped MEMORY demo ... ");
			return true;
		}
		return false;
	}
}
