package com.eginnovations.cordova.plugin;

import org.apache.cordova.CallbackContext;
import org.apache.cordova.CordovaArgs;
import org.apache.cordova.CordovaInterface;
import org.apache.cordova.CordovaPlugin;
import org.apache.cordova.CordovaWebView;
import org.apache.cordova.PluginResult;
import org.json.JSONArray;
import org.json.JSONException;

import com.eg.agent.android.AppPlatform;
import com.eg.agent.android.BaseAndroidAgent;
import com.eg.agent.android.DataController;
import com.eg.agent.android.MobileAgentUpload;
import com.eg.agent.android.eGAndroidAgent;
import com.eg.agent.android.analytics.Attributes;
import com.eg.agent.android.instrumentation.crash.EgExceptionHandler;

import android.util.Log;

/**
 * This class echoes a string called from JavaScript.
 */
public class eGCordovaPlugin extends CordovaPlugin {

	private final static String TAG = eGCordovaPlugin.class.getSimpleName();


	@Override
	public void initialize(CordovaInterface cordova, CordovaWebView webView) {
		super.initialize(cordova, webView);
		String appToken = preferences.getString("ANDROID_APP_TOKEN", null);
		String managerURL = preferences.getString("MANAGER_URL", null);
		String logLevel = preferences.getString("LOG_LEVEL", null);
		String ssl = preferences.getString("SSL", "true");
		String unsigned = preferences.getString("UNSIGNED", "true");
		int logLvl = 1;
		if (logLevel != null && logLevel.trim().length() > 0) {
			try {
				logLvl = Integer.parseInt(logLevel);
			} catch (Exception e) {
			}
		}
		if (appToken == null || appToken.isEmpty() || "x".equals(appToken)) {
			Log.e(TAG, "Failed to load application token! The Android agent is not configured for Cordova.");
		} else if (managerURL == null || managerURL.isEmpty() || "x".equals(managerURL)) {
			Log.e(TAG, "Failed to load eG Manager URL! The Android agent is not configured for Cordova.");
		} else {
			eGAndroidAgent.withCollectorHost(appToken, managerURL).withLoggingEnabled(true).withLogLevel(logLvl)
					.usingSsl(Boolean.valueOf(ssl)).unsigned(Boolean.valueOf(unsigned))
					.start(this.cordova.getActivity().getApplication());
			final String pluginVersion = preferences.getString("PLUGIN_VERSION", "1.0.0");

			eGAndroidAgent.setAppliactionPlatform(AppPlatform.Cordova);
			eGAndroidAgent.setAttribute(Attributes.APPLICATION_PLATFORM_VERSION_ATTRIBUTE, pluginVersion);
			Thread.UncaughtExceptionHandler mDefaultHandler = Thread.getDefaultUncaughtExceptionHandler();
			Thread.setDefaultUncaughtExceptionHandler(new EgExceptionHandler(true, mDefaultHandler));
		}

	}

	public boolean execute(String action, JSONArray args, final CallbackContext callbackContext) throws JSONException {
		return execute(action, args.join(","), callbackContext);
	}

	@Override
	public boolean execute(String action, CordovaArgs args, CallbackContext callbackContext) throws JSONException {
		return execute(action, args.toString(), callbackContext);
	}

	@Override
	public boolean execute(String action, final String rawArgs, CallbackContext callbackContext) throws JSONException {
		Log.d(TAG, "eGCordovaPlugin:execute:::action:::" + action + ", rawArgs:::" + rawArgs + ", callbackContext:::"
				+ callbackContext);
		boolean keepCallBack = true;
		if (action.equals("reportException")) {
			DataController.recordHandledException(new Exception(rawArgs));
			return false;
		} else if (action.equals("reportError")) {
			this.cordova.getActivity().runOnUiThread(new Runnable() {
				@Override
				public void run() {
					throw new RuntimeException(rawArgs);
				}
			});

			return false;
		} else if (action.equals("generateTestCrash")) {
			this.cordova.getActivity().runOnUiThread(new Runnable() {
				@Override
				public void run() {
					throw new RuntimeException("This is a crash");
				}
			});
			return false;
		} else if (action.equals("getDevInfo")) {
			this.cordova.getThreadPool().execute(new Runnable() {
				@Override
				public void run() {
					PluginResult result = new PluginResult(PluginResult.Status.OK, getDevInfo());
					result.setKeepCallback(keepCallBack);
					callbackContext.sendPluginResult(result);
				}
			});
			return true;
		} else if (action.equals("getAppinfo")) {
			this.cordova.getThreadPool().execute(new Runnable() {
				@Override
				public void run() {
					PluginResult result = new PluginResult(PluginResult.Status.OK, getAppinfo());
					result.setKeepCallback(keepCallBack);
					callbackContext.sendPluginResult(result);
				}
			});
			return true;
		} else if (action.equals("getResInfo")) {
			this.cordova.getThreadPool().execute(new Runnable() {
				@Override
				public void run() {
					PluginResult result = new PluginResult(PluginResult.Status.OK, getResInfo());
					result.setKeepCallback(keepCallBack);
					callbackContext.sendPluginResult(result);
				}
			});
			return true;
		} else if (action.equals("getCurrentActivityName")) {
			this.cordova.getThreadPool().execute(new Runnable() {
				@Override
				public void run() {
					PluginResult result = new PluginResult(PluginResult.Status.OK, getCurrentActivityName());
					result.setKeepCallback(keepCallBack);
					callbackContext.sendPluginResult(result);
				}
			});
			return true;
		} else if (action.equals("getUserCountry")) {
			this.cordova.getThreadPool().execute(new Runnable() {
				@Override
				public void run() {
					PluginResult result = new PluginResult(PluginResult.Status.OK, getUserCountry());
					result.setKeepCallback(keepCallBack);
					callbackContext.sendPluginResult(result);
				}
			});
			return true;
		} else if (action.equals("getDeviceName")) {
			this.cordova.getThreadPool().execute(new Runnable() {
				@Override
				public void run() {
					PluginResult result = new PluginResult(PluginResult.Status.OK, getDeviceName());
					result.setKeepCallback(keepCallBack);
					callbackContext.sendPluginResult(result);
				}
			});
			return true;
		} else if (action.equals("getBaseOs")) {
			this.cordova.getThreadPool().execute(new Runnable() {
				@Override
				public void run() {
					PluginResult result = new PluginResult(PluginResult.Status.OK, getBaseOs());
					result.setKeepCallback(keepCallBack);
					callbackContext.sendPluginResult(result);
				}
			});
			return true;
		} else if (action.equals("getAppName")) {
			this.cordova.getThreadPool().execute(new Runnable() {
				@Override
				public void run() {
					PluginResult result = new PluginResult(PluginResult.Status.OK, getAppName());
					result.setKeepCallback(keepCallBack);
					callbackContext.sendPluginResult(result);
				}
			});
			return true;
		} else if (action.equals("getOSVersion")) {
			this.cordova.getThreadPool().execute(new Runnable() {
				@Override
				public void run() {
					PluginResult result = new PluginResult(PluginResult.Status.OK, getOSVersion());
					result.setKeepCallback(keepCallBack);
					callbackContext.sendPluginResult(result);
				}
			});
			return true;
		}  else if (action.equals("isEnabled")) {
			this.cordova.getThreadPool().execute(new Runnable() {
				@Override
				public void run() {
					PluginResult result = new PluginResult(PluginResult.Status.OK, isEnabled());
					result.setKeepCallback(keepCallBack);
					callbackContext.sendPluginResult(result);
				}
			});
			return true;
		}else if (action.equals("setUserName")) {
			this.cordova.getThreadPool().execute(new Runnable() {
				@Override
				public void run() {
//					System.out.println("setUserName Args::"+rawArgs.split(",")[0]);
					setUserName(rawArgs.split(",")[0]);

				}
			});
			return true;
		}else if (action.equals("setAttribute")) {
			this.cordova.getThreadPool().execute(new Runnable() {
				@Override
				public void run() {
//					System.out.println("setAttribute Args:0:"+rawArgs.split(",")[0]);
//					System.out.println("setAttribute Args:1:"+rawArgs.split(",")[1]);
					setAttribute(rawArgs.split(",")[0], rawArgs.split(",")[1]);

				}
			});
			return true;
		}else if (action.equals("getUserInfo")) {
			this.cordova.getThreadPool().execute(new Runnable() {
				@Override
				public void run() {
					PluginResult result = new PluginResult(PluginResult.Status.OK, getUserInfo());
					result.setKeepCallback(keepCallBack);
					callbackContext.sendPluginResult(result);
				}
			});
			return true;
		}

		return super.execute(action, rawArgs, callbackContext);
	}

	public String getOSVersion() {
		return BaseAndroidAgent.getInstance().getDeviceInformation().getOsVersion();
	}

	public String getDevInfo() {
		Log.d(TAG, "eGCordovaPlugin:getDevInfo::::" + MobileAgentUpload.getDevInfo());
		return MobileAgentUpload.getDevInfo();
	}

	public String getAppinfo() {
		return MobileAgentUpload.getAppinfo();
	}

	public String getResInfo() {
		return MobileAgentUpload.getResInfo();
	}

	public String getCurrentActivityName() {
		return this.cordova.getActivity().getLocalClassName();
	}

	public String getUserCountry() {
		return BaseAndroidAgent.getUserCountry(this.cordova.getContext());
	}

	public String getDeviceName() {
		return BaseAndroidAgent.getInstance().getDeviceInformation().getDeviceName();
	}

	public String getBaseOs() {
		return "Android";
	}

	public boolean isEnabled() {
		return eGAndroidAgent.isStarted();
	}

	public String getAppName() {
		return BaseAndroidAgent.getInstance().getApplicationInformation().getAppName();
	}

	public void setUserName(String name) {
		name = name.replace("[", "");
		name = name.replace("]", "");
		name = name.replace("\"", "");
		eGAndroidAgent.setUserName(name);
	}

	public void setAttribute(String key, String value) {
		key = key.replace("[", "");
		key = key.replace("]", "");
		key = key.replace("\"", "");
		value = value.replace("[", "");
		value = value.replace("]", "");
		value = value.replace("\"", "");
		eGAndroidAgent.setAttribute(key, value);
	}

	public String getUserInfo() {
		return MobileAgentUpload.getUserInfo();
	}
}
