import 'package:flutter/foundation.dart';
import 'package:flutter/services.dart';

import 'eginnovations_platform_interface.dart';

/// An implementation of [EginnovationsPlatform] that uses method channels.
class MethodChannelEginnovations extends EginnovationsPlatform {
  /// The method channel used to interact with the native platform.
  @visibleForTesting
  final methodChannel = const MethodChannel('eginnovations');

  @override
  Future<String?> getPlatformVersion() async {
    final version = await methodChannel.invokeMethod<String>('getPlatformVersion');
    return version;
  }
}
