
#import "EGPluginCallValidator.h"




EGPluginMethodName * const kRunMethodName            = @"run";
EGPluginMethodName * const kStopMethodName           = @"stop";
EGPluginMethodName * const kStartMethodName          = @"start";
EGPluginMethodName * const kIsStartedMethodName      = @"isStarted";
EGPluginMethodName * const kSetMetadataMethodName    = @"setMetadata";
EGPluginMethodName * const kRemoveMetadataMethodName = @"removeMetadata";
EGPluginMethodName * const kHTTPRequestMethodName    = @"http-request";
EGPluginMethodName * const kHTTPResponseMethodName   = @"http-response";
EGPluginMethodName * const kLogEventMethodName       = @"log-event";
EGPluginMethodName * const kLogScreenName            = @"reportScreenChange";

EGPluginMethodArgumentName * const kAPIKeyArgument = @"apiKey";
EGPluginMethodArgumentName * const kEnabledMonitorsArgument = @"enabledMonitors";
EGPluginMethodArgumentName * const kMetadataArgument = @"metadata";

EGPluginMethodArgumentName * const kUIDArgument = @"uid";
EGPluginMethodArgumentName * const kURLArgument = @"url";
EGPluginMethodArgumentName * const kMethodArgument = @"method";
EGPluginMethodArgumentName * const kBodyArgument = @"body";
EGPluginMethodArgumentName * const kHeadersArgument = @"headers";
EGPluginMethodArgumentName * const kCodeArgument = @"code";
EGPluginMethodArgumentName * const kTookMSArgument = @"tookMs";
EGPluginMethodArgumentName * const kLevelArgument = @"level";
EGPluginMethodArgumentName * const kTagArgument = @"tag";
EGPluginMethodArgumentName * const kMessageArgument = @"message";

@interface EGPluginCallValidator ()

@property (strong, nonatomic) NSArray <EGPluginMethodName *> *controlMethodNames;
@property (strong, nonatomic) NSArray <EGPluginMethodName *> *eventMethodNames;
@property (strong, nonatomic) NSDictionary <EGPluginMethodName *, NSArray <EGPluginMethodArgumentName *> *> *methodParameters;

@end

@implementation EGPluginCallValidator

- (instancetype)init {
    if (self = [super init]) {
        _controlMethodNames = @[kRunMethodName,
                                kStopMethodName,
                                kStartMethodName,
                                kIsStartedMethodName,
                                kSetMetadataMethodName,
                                kRemoveMetadataMethodName];
        _eventMethodNames = @[kHTTPRequestMethodName, kHTTPResponseMethodName, kLogEventMethodName];
        _methodParameters = @{ kHTTPRequestMethodName : @[ @"uid",
                                                           @"url",
                                                           @"method",
                                                           @"body",
                                                           @"headers" ],
                               kHTTPResponseMethodName : @[ @"uid",
                                                            @"code",
                                                            @"body",
                                                            @"headers",
                                                            @"tookMs" ],
                               kLogEventMethodName : @[ @"level",
                                                        @"tag",
                                                        @"message" ],
                               kRunMethodName : @[ @"apiKey",
                                                   @"enabledMonitors",
                                                   @"metadata"],
                               kSetMetadataMethodName : @[@"key",
                                                          @"value"],
                               kRemoveMetadataMethodName : @[@"key"],
        };
    }
  
    return self;
}

#pragma mark - Validation API -

- (BOOL)controlMethodSupported:(EGPluginMethodName *)methodName {
    return [self.controlMethodNames containsObject:methodName];
}

- (BOOL)eventMethodSupported:(EGPluginMethodName *)methodName {
    return [self.eventMethodNames containsObject:methodName];
}

- (BOOL)argumentsValid:(EGPluginMethodArgumentsList *)arguments
                  call:(EGPluginMethodName *)methodName
                 error:(NSError **)error {
    __block BOOL isValid = YES;
    __block NSError *strongError = nil;
    [self.methodParameters[methodName] enumerateObjectsUsingBlock:^(EGPluginMethodArgumentName *argName, NSUInteger idx, BOOL *stop) {
        if (![arguments.allKeys containsObject:argName]) {
            isValid = NO;
            strongError = [self errorForMissingArgument:argName inCall:methodName];
            *stop = YES;
        }
    }];

    *error = strongError;

    return isValid;
}

#pragma mark - Private API -

- (NSError *)errorForMissingArgument:(EGPluginMethodArgumentName *)argName inCall:(EGPluginMethodName *)methodName {
    NSString *errorMessage = [NSString stringWithFormat:@"%@ call: '%@' argument is missing", methodName, argName];
    NSError *error = [NSError errorWithDomain:@"" code:0 userInfo:@{ NSLocalizedDescriptionKey : errorMessage }];
    
    return error;
}

@end
