'use strict'

const path = require('path');
const appInfo = require('./lib/app-info');
appInfo.setBasePath(global.basePath || module.parent.path || (module.parent.filename && path.dirname(module.parent.filename)));
appInfo.startingFile = global.startingFile || module.parent.filename;
const logger = require('./lib/logger');
_preStartupLogs();

if (appInfo.pm2Details && !appInfo.pm2Details.isTragetApp) {
  if (!appInfo.pm2Details.isDaemon) {
    logger.info("Node.js process arg", process.argv);
    logger.info("This is a PM2 process (not a Daemon) and it is not need to monitor so exiting the eG Monitor...!");
    return;
  }

  logger.info("This is a PM2 Daemon process...!");
}

const Agent = require('./lib/agent');
module.exports = new Agent();

function _preStartupLogs() {
  if (!global.preStartupLogs || !global.preStartupLogs.length) return;

  global.preStartupLogs.forEach(log => {
    if (log.type === 'error') {
      logger.error(log.appendMsg || '', log.msg || '', log.obj || '');
    } else if (log.type === 'warn') {
      logger.warn(log.appendMsg || '', log.msg || '', log.obj || '');
    } else {
      logger.info(log.appendMsg || '', log.msg || '', log.obj || '');
    }
  });
}
