var isCreateSocketValid = function (createSocket) { return typeof createSocket !== "undefined" && createSocket !== null; };
var isHostValid = function (host) { return typeof host === "string" && host && host !== ""; };
var isPortValid = function (port) { return typeof port === "number" && port >= 1 && port <= 65535; };
var onCommandValid = function (fn) { return typeof fn === "function"; };
/**
 * Ensures the options are sane to run this baby.  Throw if not.  These
 * are basically sanity checks.
 */
var validate = function (options) {
    var createSocket = options.createSocket, host = options.host, port = options.port, onCommand = options.onCommand;
    if (!isCreateSocketValid(createSocket)) {
        throw new Error("invalid createSocket function");
    }
    if (!isHostValid(host)) {
        throw new Error("invalid host");
    }
    if (!isPortValid(port)) {
        throw new Error("invalid port");
    }
    if (!onCommandValid(onCommand)) {
        throw new Error("invalid onCommand handler");
    }
};
export default validate;
