/// <reference types="node" />
var hasHirezNodeTimer = false &&
    typeof process === "object" &&
    process &&
    process.hrtime &&
    typeof process.hrtime === "function";
// the default timer
// eslint-disable-next-line @typescript-eslint/no-unused-vars
var defaultPerformanceNow = function (started) { return Date.now(); };
// try to find the browser-based performance timer
var nativePerformance = typeof window !== "undefined" &&
    window &&
    (window.performance || window.msPerformance || window.webkitPerformance);
// the function we're trying to assign
var performanceNow = defaultPerformanceNow;
// accepts an already started time and returns the number of milliseconds
var delta = function (started) { return performanceNow() - started; };
if (hasHirezNodeTimer) {
    performanceNow = process.hrtime;
    delta = function (started) { return performanceNow(started)[1] / 1000000; };
}
else if (global.nativePerformanceNow) {
    // react native 47
    performanceNow = global.nativePerformanceNow;
}
else if (nativePerformance) {
    // browsers + safely check for react native < 47
    performanceNow = function () { return nativePerformance.now && nativePerformance.now(); };
}
/**
 * Starts a lame, low-res timer.  Returns a function which when invoked,
 * gives you the number of milliseconds since passing.  ish.
 */
export var start = function () {
    //  record the start time
    var started = performanceNow();
    return function () { return delta(started); };
};
