<%
/********************************************************************
*   File Name     :   ErExternalMonitorReport.jsp
*	Purpose		  :	  Displays External Agent and Measurement Details
*	Version		  :   7.0
*	Author		  :   Ezhilarasi S
*   Creation Date :	  14/Aug/2018
********************************************************************/
%>
<%@ include file="ErTracker.jsp" %>
<%@ page import="com.eg.IniFile"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %> 
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<html>
	<head>
		<title><egui:intnl text="reporter.common.eG Reporter"/></title>
		<egui:skin ui="reporter" />
		<meta charset="utf-8">
		<link rel="stylesheet" href="/final/styles/jscrollpane/jquery.jscrollpane.css" />
		<script src="/final/jquery/jquery.js"></script>
		<script src="/final/styles/jscrollpane/jquery.jscrollpane.js" ></script>
		<script src="/final/styles/jscrollpane/jquery.mousewheel.js" ></script>
		<script src="/final/styles/jscrollpane/mwheelIntent.js" ></script>
		<script src="/final/reporter/scripts/eg_DateUtil.js"></script>
		<script src="/final/reporter/scripts/er_validator.js"></script>
		<script src="../scripts/<%=script_src%>"></script>
		<script type="text/javascript" src="/final/Highcharts/js/highstock.js"></script>		
		<script type="text/javascript" src="/final/Highcharts/js/modules/exporting.js"></script>
		<script type="text/javascript" src="/final/Highcharts/js/highcharts-more.js"></script>
		<script src="../reporter/scripts/ErHighChart.js"></script>
		<script src="../reporter/scripts/ErHighChartBar.js"></script>
		<script src="../reporter/scripts/ErHighChartColumns.js"></script>
		<%	
		Map ParamMap = request.getParameterMap();	
		HashMap tmp_map = new HashMap();
		if(ParamMap!=null && ParamMap.size()>0){
			Iterator itr = ParamMap.keySet().iterator();
			while(itr.hasNext()){
				String map_key = (String)itr.next();
				Object map_value = ParamMap.get(map_key);
				if(map_value instanceof String[])
				{
					Set map_valSet=new HashSet(Arrays.asList((String[])map_value));
					String[] strArry=(String[])map_valSet.toArray(new String[map_valSet.size()]);
					tmp_map.put(map_key,strArry);
				}
				else
				{
					tmp_map.put(map_key,ParamMap.get(map_key));
				}				
			}
		}
		String queryStr=(String)ErUtils.prepareQueryString(tmp_map);
		String currentDateFormat = strUserDateFormat;
		String isSubmit = (request.getParameter("isSubmit")!=null) ? request.getParameter("isSubmit") : "";
		String favoriteID =  request.getParameter("FavoriteId"); 
		String scheduleID =  request.getParameter("schedule_id"); 
		String isModifyFavorite =  request.getParameter("fromFavoriteModify");
		String isModifySchedule =  request.getParameter("fromScheduleModify");
		String erFavorite =  request.getParameter("er_favorite");
		String reportFor=request.getParameter("reportFor");
		String drillDown=request.getParameter("drillDown");
		String cancelDrillDown=request.getParameter("cancelDrillDown");
		String isDrillDown="false";
		if(drillDown != null && drillDown.equalsIgnoreCase("true"))
			isDrillDown="true";			
		if(cancelDrillDown != null && cancelDrillDown.equalsIgnoreCase("true"))
			isDrillDown="false";			
		Map tRequestMap=new HashMap();
		String method="init";
		IniFile inifile=new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_report.ini",true);
		try
		{
			if(method.equalsIgnoreCase("init"))
			{
				List vList=new ArrayList(Arrays.asList(inifile.getVariables("ExternalMonitor_Report")));
				List detailList=new ArrayList(Arrays.asList(inifile.getVariables("ExternalMonitor_Report_detail")));
				for(int v=0;v<vList.size();v++)
				{
					String eachName=(String)vList.get(v);
					tRequestMap.put(eachName,inifile.getValue("ExternalMonitor_Report",eachName));
				}
				for(int d=0;d<detailList.size();d++)
				{
					String eachDetailName=(String)detailList.get(d);
					tRequestMap.put(eachDetailName,inifile.getValue("ExternalMonitor_Report_detail",eachDetailName));
				}
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		session.setAttribute("tRequestMap",tRequestMap);
		String testForInfoCombo=iniFile.getValue("ExternalMonitor_Report","TestRequiredInfoCombo");
		Map testWithInfoLabel=null;
		if(testForInfoCombo != null && testForInfoCombo.length()>0)
		{
			testWithInfoLabel=new HashMap();
			String[] testArry=testForInfoCombo.split(",");
			for(int t=0;t<testArry.length;t++)
			{
				String eachTest=testArry[t];
				if(eachTest != null && eachTest.indexOf("$") != -1)
				{
					String eachTestLabel=eachTest.substring(eachTest.indexOf("$")+1);
					eachTest=eachTest.substring(0,eachTest.indexOf("$"));
					testWithInfoLabel.put(eachTest,eachTestLabel);
				}
			}
		}
		boolean applicationComboHidden=true;
		if(reportFor != null && testWithInfoLabel != null && testWithInfoLabel.get(reportFor) != null)
			applicationComboHidden=false;		
		boolean enableMultiCompType=false;
		String compTypeMultiSelect=iniFile.getValue("ExternalMonitor_Report","compTypeMultiSelect");
		if(compTypeMultiSelect != null && compTypeMultiSelect.equalsIgnoreCase("yes"))
			enableMultiCompType=true;
		String isEnableBack =  ("true".equalsIgnoreCase(request.getParameter("enableBack")))? "true" : "false";
		String infoLabel="Web Page";
		if(reportFor != null && testWithInfoLabel.get(reportFor) != null)
		{	
			infoLabel=(String)testWithInfoLabel.get(reportFor);
		}
		//
		if(reportFor != null && reportFor.equalsIgnoreCase("GenericLogonSimTest"))
		{
			session.setAttribute("Source","Web App Simulation");
		}
		else if(reportFor != null && reportFor.equalsIgnoreCase("CitraTest"))
		{
			session.setAttribute("Source","Client Session Simulation");
		}
		else if(reportFor != null && reportFor.equalsIgnoreCase("NetworkTest"))
		{
			session.setAttribute("Source","Network Access");
		}
		else if(reportFor != null && reportFor.equalsIgnoreCase("HttpTest"))
		{
			session.setAttribute("Source","HTTP Access");
		}
		else if(reportFor != null && reportFor.equalsIgnoreCase("MsSqlNetTest"))
		{
			session.setAttribute("Source","SQL Performance");
		}
		else if(reportFor != null && reportFor.equalsIgnoreCase("OraSqlNetTest"))
		{
			session.setAttribute("Source","Oracle Performance");
		}
		else if(request.getParameter("er_reportFrom")!=null)
		{
			String er_reportFrom = request.getParameter("er_reportFrom");
			if(er_reportFrom!=null)
			{
				session.setAttribute("Source", er_reportFrom);
			}
		}
		else
		{
			session.setAttribute("Source","");
		}
		%>
		<script>
			var mgrDateFormat = getExtjsDateFormat('<%=currentDateFormat%>');
			var currentDateFormat='<%=currentDateFormat%>';
			var appConstants=new Object();
			appConstants.forGrdReportConfirmMsg = '<egui:intnl text="reporter.common.Foreground report generation will take some time Do you want to proceed"/>'+'?';
			appConstants.erUtils = null;
			appConstants.defaultLoadData = null;
			appConstants.LoadingMask = null;
			appConstants.appController = null;
			appConstants.appObj = null;
			appConstants.favoriteID ='<%=favoriteID%>';
			appConstants.er_RmDispName = 'ExternalMonitorReport';
			appConstants.scheduleID ='<%=scheduleID%>';
			appConstants.isModifyFavorite = '<%=isModifyFavorite%>';
			appConstants.isModifySchedule = '<%=isModifySchedule%>';
			appConstants.erFavorite = '<%=erFavorite%>';
			appConstants.isSubmit = '<%=isSubmit%>'
			appConstants.isEnableBack = true;
			appConstants.isShowSubmitBtn = true;
			appConstants.reportFor='<%=reportFor%>';
			appConstants.isDrillDown='<%=isDrillDown%>';
			appConstants.enableMultiCompType = <%=enableMultiCompType%>;
			appConstants.applicationComboHidden=<%=applicationComboHidden%>;
			appConstants.infoLabel='<%=infoLabel%>';
			appConstants.reportBasesOnLabel='<%=trackerMappingInfo.getTextDescription("reporter.common.Check Maintenance")%>';
			appConstants.queryStr = '<%=queryStr.replace("\\","\\\\")%>';
			
			if((appConstants.isModifyFavorite.toUpperCase() == 'YES') || (appConstants.isModifySchedule.toUpperCase() == 'YES'))
			{
				appConstants.isShowSubmitBtn = false;
			}
			if('true'=='<%=isEnableBack.toLowerCase()%>')
			{
				appConstants.isEnableBack = false;
			}
			function reportForHighChart(id,detailData)
			{
				var chartData = {};
				chartData = jQuery.extend(true, {}, getHighChartsBarInstance(id,"",""), chartData);
				chartData.setData(detailData,'<%=currentDateFormat%>','');
				chartData.drawChart();		
			}
			function linkURL(urlKey){
				var QString = urlKey;
				document.location=QString;
			}
		</script>
		<egui:loadApp baseDir="/final/reporter/scripts" appName="ExternalMonitorApp" appFile="app.js"/>
		<script>
			Ext.onReady(function(){
				appConstants.initLdgMask = new Ext.LoadMask(Ext.getBody(),{msg : "Loading ..."});
				Ext.Ajax.extraParams = {"com.eg.CSRF_NONCE" : csrfToken};
				Ext.data.Connection.prototype.extraParams = {"com.eg.CSRF_NONCE" : csrfToken};
				Ext.data.ScriptTagProxy.prototype.extraParams = {"com.eg.CSRF_NONCE" : csrfToken};
			});
		</script>
	</head>
</html>