<%
/**************************************************************************************************
* File name			: ErEsxUptimeReportData.jsp
* Purpose			: Genarates Servers' Uptime Reports
* Version			: 1.0
* Creation			: 2/9/2009
* Last Modified 	:
* Author			: R.Sivakumar
**************************************************************************************************/
%>

<%@ include file = "ErReporterTracker.jsp" %>
<%@ page import = "egurkha.reporter.*" %>
<%@ page import = "egurkha.reporter.uptime.*" %>
<%@ page import = "com.egurkha.ini.*" %>
<%@ page import = "com.egurkha.*" %>
<%@ page import = "com.eg.EgDateInfo" %>
<%@ page import = "com.eg.EgDiscInfo" %>
<%@ page import = "com.eg.EgTopoInfo" %>
<%@ page import = "com.eg.EgURLEncoder" %>
<%@ page import = "java.net.URLDecoder" %>
<%@ page import = "com.egurkha.util.DateTimeTokenizer" %>
<%@ page import = "com.egurkha.util.DateUtil" %>
<%@ page import = "java.text.*" %>
<%@ page import = "com.eg.EgInstallInfo"%>
<%@ page import = "com.eg.EgMappingInfo"%>
<%@ page import = "com.eg.IniFile"%>
<%@ page import = "com.egurkha.pdfmaker.*" %>
<%@ page import = "com.eg.EgConfigInfo"%>
<%@ page import = "com.eg.EgTestInfo"%>
<%@ page import = "net.sf.json.*" %>
<%@ page import = "com.eg.MappingNameSorter"%>
<%@ page import = "com.eg.EgName" %>
<%@ page import="com.egurkha.util.StringUtils"%>

<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%
	String skinColor="";
	skinColor = thisuser.getReporterSkin();
%>
<%!
public String getDisplayString(String input, String defaultString) {
	String displayString = "";
	if (input.equals("-")) {
		displayString = input;
	} else {
		StringTokenizer st = new StringTokenizer(input);
		while(st.hasMoreTokens()) {
			if(displayString.equals("")) {
				displayString = st.nextToken();
			} else {
				displayString += " " + st.nextToken();
			}
			displayString += st.nextToken();
		}
		
		if(displayString.equals("")) {
			displayString = defaultString;
		} else if(displayString.equals("0m")) {
			displayString = defaultString;
		}
	}
	return displayString;
}
%>

<%
	String titleToDisplay=request.getParameter("er_RmDispName");					

	response.setContentType("application/json");
	JSONObject rootJson = new JSONObject();
	JSONObject screenLabelJson = new JSONObject();
	JSONObject hiddenfieldsJson=new JSONObject();
	JSONObject loopJsonObj = new JSONObject();


	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	String bggroundStr = (String)request.getAttribute("bggroundStr");
	String status = (String)request.getAttribute("status");

	//Back Button - Start

	HashMap backreqMap = (HashMap)session.getAttribute("backQuery");
	String backQnumber = request.getParameter("backQnumber");
	String servlet2 = request.getParameter("backServletName");

	ErHelperUtils erhelputils = null;

	if( servlet2!=null && !servlet2.equals(""))
		erhelputils = new ErHelperUtils(backreqMap,backQnumber,servlet2);
	else
		erhelputils = new ErHelperUtils(backreqMap,backQnumber);

	boolean enableBack=erhelputils.isBackButtonEnable();

	String backButtonEnable = request.getParameter("back");
	rootJson.put("ID","backQnumber="+erhelputils.getBackID()+"&"+erhelputils.getQueryString());
	if(backButtonEnable != null && backButtonEnable.equalsIgnoreCase("True"))
	{
		status = (String)request.getParameter("status");
		request.setAttribute("ResultDataMap",null);
		request.setAttribute("Pdfdata",null);
		bggroundStr = (String)request.getParameter("bggroundStr");
	}
	//Back Button - End

	User this_user = UserRegistry.getInstance().getUser(session.getId());
	UBean = new ErUserData(this_user.getLoginID(),false);
	ErUserData erdata = new ErUserData(UBean.getUserId(),false); //boolean arg given to check Ent or asplite
	com.egurkha.ini.IniUI ui = (com.egurkha.ini.IniUI)com.egurkha.ini.IniUI.getInstance();
	EgDateInfo egDt = new EgDateInfo();
	EgTestInfo tokInfo = new EgTestInfo("manager");
	UserRegistry mregistry = UserRegistry.getInstance();
	User muser = mregistry.getUser(session.getId());
	String thisLanguage = ui.getDefaultLanguage();
	if (muser!=null)
	{
		String userLang = muser.getLanguage();
		if (userLang!=null && !userLang.equalsIgnoreCase("NULL"))
		{
			thisLanguage = userLang;
		}
	}
	MappingNameSorter sorter = new MappingNameSorter(thisLanguage);
	EgMappingInfo intlmap = new EgMappingInfo(thisuser.getLanguage());
	String loginid = thisuser.getEncodedLoginID();
	ErComponentsUtils compUtil = new ErComponentsUtils(loginid);
	String mngrIProc = new IniFile(new EgConfigInfo("manager").getDbFile()).getValue("DB_PROPERTIES","ManagerUrl");
	
	ErUtils erUtils = new ErUtils();
	String protocol = request.getScheme();
	String font = ui.getFontName();
	String userid = UBean.getUserId();
	long msecsPerHour = (long) 1000 * 60 * 60;

	String uiFile = "eg_ui.ini";
	String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
	com.eg.IniFile egUI = new com.eg.IniFile(s_iniFile_dir + uiFile);
	String currentDateFormat = strUserDateFormat;

	Map resultDataMap = (Map) request.getAttribute("ResultDataMap");
	EgPdfData pdfdata = (EgPdfData) request.getAttribute("Pdfdata");
	if(pdfdata !=null)
	{
		session.setAttribute(ErUptimePdfGenerator.UPTIME_REPORT,pdfdata);
	}
	session.setAttribute("uptimePrintData",resultDataMap);

	/** For Save CSV Data Format */
	List list = new LinkedList();		//Add List of Data
	Vector v_measure = new Vector();	//User ColumnName
	List list_data = new LinkedList();	//ColumnData
	Hashtable h_tabrc = new Hashtable();//SubTable Data
	Hashtable h_tab = new Hashtable();	//SunTitle with SubTable Data
	
	String er_type = request.getParameter("er_type");
	if(er_type == null) {
		er_type="Yes";
	}

	String er_show = request.getParameter("er_show");
	if(er_show == null || er_show.equals("")) {
		er_show = "%Uptime/%Downtime";
	}

	if(er_show!=null && er_show.indexOf("|pct|") > -1)
	{
		er_show = StringUtils.replace(er_show,"|pct|","%");
	}
	String queryString = null;
	String s_st_time = request.getParameter("startdate");
	String s_en_time = request.getParameter("enddate");
	String s_st_hr   = request.getParameter("starthr");
	String s_en_hr   = request.getParameter("endhr");
	String strmin    = request.getParameter("startmin");
	String enmin     = request.getParameter("endmin");
	String er_timeline = request.getParameter("er_timeline");
	String er_time    = request.getParameter("er_time");
	String s_inidate  = request.getParameter("inidate");
	String fromDash = request.getParameter("isDash");
	String reqFromSchedule = request.getParameter("fromSchedule");
	String schedule_id = request.getParameter("schedule_id");
	String fromScheduleModify = request.getParameter("fromScheduleModify");
	String fromFavoriteModify = request.getParameter("fromFavoriteModify");
	String favorite_id = request.getParameter("id");
	String er_favorite = request.getParameter("er_favorite");
	String stmin="00";

	String dispCsvStartDate = s_st_time+" "+s_st_hr+":"+strmin;
	String dispCsvEndDate = s_en_time+" "+s_en_hr+":"+enmin;

	EgTimeZoneConverter converterStart=null;
	EgTimeZoneConverter converterEnd=null;
	String dispDate = null;
	String comFormat = null;
	String st_dateTime="";
	String en_dateTime="";
	if(s_st_time!=null)
	{
		if(DateUtil.isDate(s_st_time,"MM/dd/yyyy"))
		{
			comFormat = "MM/dd/yyyy";
		}
		else
		{
			comFormat = currentDateFormat;
		}
		dispDate = 	DateUtil.changeDateFormat(s_st_time,comFormat,currentDateFormat);
		converterStart = new EgTimeZoneConverter(dispDate+" "+s_st_hr+":"+strmin,thisuser);
		st_dateTime=converterStart.getDateTime();
	}
	if(s_en_time!=null)
	{
		if(DateUtil.isDate(s_en_time,"MM/dd/yyyy"))
		{
			comFormat = "MM/dd/yyyy";
		}
		else
		{
			comFormat = currentDateFormat;
		}
		dispDate = 	DateUtil.changeDateFormat(s_en_time,comFormat,currentDateFormat);
		converterEnd = new EgTimeZoneConverter(dispDate+" "+s_en_hr+":"+enmin,thisuser);
		en_dateTime=converterEnd.getDateTime();
	}

	String divStatus = request.getParameter("divStatus");
	String srcForImg="";
	if(divStatus==null)
	{
	divStatus="none";
	}

	if(divStatus.equals("none"))
	{
		srcForImg="/final/images/moreoption.png";
	}
	else if(divStatus.equals("block"))
	{
		srcForImg="/final/images/lessoption.png";
	}
	
	if(er_timeline == null)
	{
		er_timeline = "2 weeks";
	}

	Vector v_comp_popup = new Vector();
	Vector v_comp_popup_disp = new Vector();

	Vector v_site = new Vector();
	String datafrom = request.getParameter("er_datafrom");
	String er_service = request.getParameter("er_service");
	if(datafrom==null|| datafrom.equals(""))
	{
		datafrom = request.getParameter("er_dataFrom");
	}
	if(datafrom == null || datafrom.equals(""))
	{
		datafrom="Component";
	}

	String includezone = request.getParameter("er_dataZone");
	if (includezone == null || (includezone !=null && includezone.equals("")))
	{
		includezone="yes";
	}

	boolean subZone = true;
	if(includezone.equalsIgnoreCase("No")) {
		subZone = false;
	}

	Vector v_zones=new Vector();
	Vector v_segment=new Vector();
	Vector v_other=new Vector();
	Vector v_comptype=new Vector();

	String s_site = request.getParameter("er_site");//site specific code
		//  for - reports by segment,Service default loading setup

		if(datafrom!=null && (datafrom.equalsIgnoreCase("Segment")||datafrom.equalsIgnoreCase("Service")||datafrom.equalsIgnoreCase("Zone")))
		{
			if(er_service!=null)
			{
				s_site=er_service;
			}
		}
		//
	String s_comp = request.getParameter("er_component");
	String s_combination = request.getParameter("er_combination");

	String[] selectedCompArray = request.getParameterValues("er_component");
	List selectedCompList = new ArrayList();
	if(selectedCompArray != null) {
		for(int i=0; i<selectedCompArray.length; i++) {
			selectedCompArray[i] = erUtils.specialCharDecode(selectedCompArray[i]);
		}
		selectedCompList = Arrays.asList(selectedCompArray);
	}
	
	Vector v_component = new Vector();
	EgDiscInfo discInfo = new EgDiscInfo("manager");
	List nwDevices = discInfo.getAllNetworkDevices();
	EgReportInfo reportinfo = new EgReportInfo("manager");
	String confrimation = reportinfo.getValue("BACKGROUND_PROCESS","NeedConfirmation");
	String strbgrepportName = reportinfo.getValue("BACKGROUND_PROCESS","EnableBackgroundReport");
	String limitforbg = reportinfo.getValue("BACKGROUND_PROCESS","MinDurationForReport");
	String[] reportTypes = new String[0];

	//Read the uptimeFor from [ESX_UPTIME_REPORT]
	String uptimeFor = reportinfo.getValue("ESX_UPTIME_REPORT","UptimeFor");
	if(uptimeFor != null) {
		if(uptimeFor.indexOf("##")== -1) {
			if(uptimeFor.indexOf("*") != -1) {
					reportTypes = new String[1];
					reportTypes[0] = uptimeFor.substring(0, uptimeFor.indexOf("*"));
				}
		} else {
			StringTokenizer st = new StringTokenizer(uptimeFor, "##");
			reportTypes = new String[st.countTokens()];
			int i = 0;
			while(st.hasMoreTokens()) {
				String labelTable = st.nextToken();
				if(labelTable.indexOf("*") != -1) {
					reportTypes[i++] = labelTable.substring(0, labelTable.indexOf("*"));
				}
			}
		}
	}

	String s_comptype = request.getParameter("er_comptype");
	String er_uptimetest = request.getParameter("er_uptimetest");
	String onlyCompTpye = request.getParameter("onlyCompTpye");
	String wvdReportFrom = request.getParameter("wvdReportFrom");
	if(er_uptimetest == null) {
		er_uptimetest = reportTypes[0];
	}
	String uptimeType = "";
	String sub = "ESX_UPTIME_REPORT";
	if(er_uptimetest.equalsIgnoreCase("Physical Servers")) {
		uptimeType = "Esx";
		sub = "ESX_UPTIME_REPORT";
	} else if(er_uptimetest.equalsIgnoreCase("Virtual Machines")) {
		uptimeType = "EsxGuest";
		sub = "VMG_UPTIME_REPORT";
	}
	String reportFrom = request.getParameter("reportFrom");
	if(reportFrom != null && reportFrom.equalsIgnoreCase("igelReport"))
	{
		sub = "IGEL_UPTIME_REPORT";
		uptimeType = "EsxGuest";
		er_uptimetest = "Virtual Machines";
	}
	ArrayList onlyCompTypeLst=null;
	if(onlyCompTpye != null && !"null".equalsIgnoreCase(onlyCompTpye) && !"undefined".equalsIgnoreCase(onlyCompTpye))
	{
		onlyCompTypeLst = new ArrayList();
		onlyCompTypeLst=erUtils.egTokenizer(onlyCompTpye, ",");
	}
	if(onlyCompTypeLst != null && onlyCompTypeLst.size() > 0 && onlyCompTypeLst.contains("Cloud_VMs"))
	{
		sub = "VMG_UPTIME_REPORT";
		uptimeType = "EsxGuest";
		er_uptimetest = "Virtual Machines";
	}
	if(onlyCompTypeLst != null && onlyCompTypeLst.size() > 0 && onlyCompTypeLst.contains("WVD_RDS_server"))
	{
		sub = "WVD_UPTIME_REPORT";
		if(wvdReportFrom != null && wvdReportFrom.equalsIgnoreCase("sessionHost"))
		{
			uptimeType = "EsxGuest";
			er_uptimetest = "Virtual Servers";
		}
		else
		{
			uptimeType = "Esx";
			er_uptimetest = "Physical Servers";
		}
	}
	
	String showDetails = request.getParameter("er_show_details");

	EgCrawler crawlerBean = new EgCrawler(new IniFile(s_iniFile_dir+"eg_topology.ini"));
	EgTopoInfo topoInfo = new EgTopoInfo("manager");
	ErEsxVMutils eresx = new ErEsxVMutils();
	String seperateMenuComps = reportinfo.getValue("MISC","SeperateMenuComponent");
	ArrayList seperateMenuCompsLst=erUtils.egTokenizer(seperateMenuComps, ",");
	ArrayList aListSupportedComponentType = new ArrayList();
	List listComp = eresx.getEsxElements(thisuser,"All ComponentTypes","Component",subZone,sub,onlyCompTpye);
	for(int i=0; i<listComp.size(); i++) 
	{
		String compType = ((String)listComp.get(i)).substring(0, ((String)listComp.get(i)).indexOf(":"));
		if(!aListSupportedComponentType.contains(compType)) 
		{
			aListSupportedComponentType.add(compType);
		}
	}
	if(onlyCompTypeLst != null && onlyCompTypeLst.size() > 0)
	{
		Vector v_comptypeNew = new Vector();
		for(int i=0; i<listComp.size(); i++)
		{
			String compType = ((String)listComp.get(i)).substring(0, ((String)listComp.get(i)).indexOf(":"));
			if(onlyCompTypeLst.contains(compType))
			{
				if(!v_comptypeNew.contains(compType))
				{
					v_comptypeNew.add(compType);
				}
			}
		}
		aListSupportedComponentType = new ArrayList();
		aListSupportedComponentType.addAll(v_comptypeNew);
	}
	if(onlyCompTpye==null || onlyCompTpye.equalsIgnoreCase("null"))
	{
		if(seperateMenuCompsLst != null && seperateMenuCompsLst.size() > 0 && aListSupportedComponentType != null && aListSupportedComponentType.size() > 0)
		{
			for(int i=0; i<aListSupportedComponentType.size(); i++) 
			{
				String componentType = (String)aListSupportedComponentType.get(i);
				if(seperateMenuCompsLst.contains(componentType))
				{
					aListSupportedComponentType.remove(componentType);
				}
			}
		}
	}
	Hashtable htAllGroups = eresx.getGroups(null,aListSupportedComponentType, thisuser, loginid, "Yes",true);
	ArrayList v_option = eresx.getOptions(htAllGroups);
	if(datafrom!=null && (datafrom.equals("Service") || datafrom.equals("Segment")))
	{
		List listElements = new ArrayList();
		List listComponents = new ArrayList();
		if(s_comptype != null && !s_comptype.equals("-1") && !s_comptype.equals("NotApplicable")) {
			listElements = eresx.getEsxElements(thisuser,s_comptype,datafrom,subZone,sub,onlyCompTpye);
		} else {
			listElements = eresx.getEsxElements(thisuser,"All ComponentTypes",datafrom,subZone,sub,onlyCompTpye);
		}
		if(s_site != null && !s_site.equals("-1")) {
			ArrayList tempList  = new ArrayList();
			if(s_comptype != null && !s_comptype.equals("-1") && !s_comptype.equals("NotApplicable")) {
				tempList.add(s_comptype);
			} else {
				tempList.addAll(reportinfo.getComponent(sub,false));
			}
			listComponents = reportinfo.getComponentPresent(datafrom, s_site, tempList, subZone);
		}
		for(int i=0; i<listComponents.size(); i++) {
			String compType = ((String)listComponents.get(i)).substring( ((String)listComponents.get(i)).lastIndexOf(":")+1);
			if(!v_comptype.contains(compType)) {
				v_comptype.add(compType);
			}
		}
		v_component.addAll(listComponents);
		v_site.addAll(listElements);
	}
	else if(datafrom!=null && datafrom.equals("Zone"))
	{
		List listElements = new ArrayList();
		List listComponents = new ArrayList();
		if(s_comptype != null && !s_comptype.equals("-1") && !s_comptype.equals("NotApplicable")) {
			listElements = eresx.getEsxElements(thisuser,s_comptype,datafrom,subZone,sub,onlyCompTpye);
		} else {
			listElements = eresx.getEsxElements(thisuser,"All ComponentTypes",datafrom,subZone,sub,onlyCompTpye);
		}
		v_site.addAll(listElements);
		if(s_site != null && !s_site.equals("-1")) {
			ArrayList tempList  = new ArrayList();
			if(s_comptype != null && !s_comptype.equals("-1") && !s_comptype.equals("NotApplicable")) {
				tempList.add(s_comptype);
			} else {
				tempList.addAll(reportinfo.getComponent(sub,false));
			}
			if(s_site.equals("--Default--")) {
				ArrayList allComponents = eresx.getEsxElements(thisuser,"All ComponentTypes","Component",true,sub,onlyCompTpye);
				ArrayList zoneList = eresx.getEsxElements(thisuser,"All ComponentTypes",datafrom,true,sub,onlyCompTpye);
				for(int i=0; i<zoneList.size(); i++) {
					if(zoneList.get(i).equals("--Default--")) {
						continue;
					}
					ArrayList zoneComponents = reportinfo.getComponentPresent(datafrom, (String)zoneList.get(i), tempList, subZone);
					allComponents.removeAll(zoneComponents);
				}
				listComponents = allComponents;
			} else {
				listComponents = reportinfo.getComponentPresent(datafrom, s_site, tempList, false);
			}
			v_component.addAll(listComponents);
			for(int i=0; i<listComponents.size(); i++) {
				String compType = ((String)listComponents.get(i)).substring(0, ((String)listComponents.get(i)).indexOf(":"));
				if(!v_comptype.contains(compType)) {
					v_comptype.add(compType);
				}
			}
		}
	} else if(datafrom==null || (datafrom!=null && datafrom.equals("Component")))	
	{
		//List listElements = new ArrayList();
		List listElements = eresx.getEsxElements(thisuser,"All ComponentTypes",datafrom,subZone,sub,onlyCompTpye);
		for(int i=0; i<listElements.size(); i++) {
			String compType = ((String)listElements.get(i)).substring(0, ((String)listElements.get(i)).indexOf(":"));
			if(!v_comptype.contains(compType)) {
				v_comptype.add(compType);
			}
		}
		if(onlyCompTypeLst != null && onlyCompTypeLst.size() > 0)
		{
			Vector v_comptypeNew = new Vector();
			for(int i=0; i<listElements.size(); i++)
			{
				String compType = ((String)listElements.get(i)).substring(0, ((String)listElements.get(i)).indexOf(":"));
				if(onlyCompTypeLst.contains(compType))
				{
					if(!v_comptypeNew.contains(compType))
					{
						v_comptypeNew.add(compType);
					}
				}
			}
			v_comptype = new Vector();
			v_comptype.addAll(v_comptypeNew);
		}
		if(s_comptype != null && !s_comptype.equals("-1") && !s_comptype.equals("NotApplicable")) {
			listElements = eresx.getEsxElements(thisuser,s_comptype,datafrom,subZone,sub);
		}
		v_component.addAll(listElements);
	}
	if(onlyCompTpye==null || onlyCompTpye.equalsIgnoreCase("null"))
	{
		if(seperateMenuCompsLst != null && seperateMenuCompsLst.size() > 0 && v_component != null && v_component.size() > 0)
		{
			for(int i=0; i<v_component.size(); i++) 
			{
				String v_comp = (String)v_component.get(i);
				String componentType = v_comp.substring(0,v_comp.indexOf(":"));
				if(seperateMenuCompsLst.contains(componentType))
				{
					v_component.remove(v_comp);
					v_comptype.remove(componentType);
				}
			}
		}
	}
	//If component type is chosen then remove the components that are not of chosen type

	Collections.sort(v_comptype);
	ArrayList aSortedList = new ArrayList();
	for(int m=0;m<v_comptype.size();m++)
	{
		String s=(String)v_comptype.get(m);
		String component = intlmap.getComponentTypeDescription(s);
		aSortedList.add(component);
		Collections.sort(aSortedList,String.CASE_INSENSITIVE_ORDER);
	}
	if (v_comptype!=null && v_comptype.size()==1)
		s_comptype=intlmap.getReverseComponentTypeDescription((String)aSortedList.get(0));

	if(v_comptype!=null && !v_comptype.contains(s_comptype))
		s_comptype="-1";
		if(s_comptype != null && !s_comptype.equals("-1") &&
		!s_comptype.equals("NotApplicable") && v_comptype.contains(s_comptype)) {
		List removeList = new ArrayList();
		for(int i=0; i<v_component.size(); i++) {
			String v_comp = (String)v_component.get(i);
			if(-1 == v_comp.indexOf(s_comptype)) {
				removeList.add(v_comp);
			}
		}
		System.out.println("removeList -----after removing-->>> "+removeList);
		v_component.removeAll(removeList);
	}
	if (selectedCompList.isEmpty() && !(v_component.isEmpty())) {
		selectedCompList.addAll(v_component);
	}
	
	Vector v_time = new Vector();
	v_time.add("00");
	v_time.add("01");
	v_time.add("02");
	v_time.add("03");
	v_time.add("04");
	v_time.add("05");
	v_time.add("06");
	v_time.add("07");
	v_time.add("08");
	v_time.add("09");
	v_time.add("10");
	v_time.add("11");
	v_time.add("12");
	v_time.add("13");
	v_time.add("14");
	v_time.add("15");
	v_time.add("16");
	v_time.add("17");
	v_time.add("18");
	v_time.add("19");
	v_time.add("20");
	v_time.add("21");
	v_time.add("22");
	v_time.add("23");

	Vector v_min = new Vector();
	v_min.add("00");
	v_min.add("05");
	v_min.add("10");
	v_min.add("15");
	v_min.add("20");
	v_min.add("25");
	v_min.add("30");
	v_min.add("35");
	v_min.add("40");
	v_min.add("45");
	v_min.add("50");
	v_min.add("55");
	v_min.add("59");

	ErReportHelper erh = new ErReportHelper();
	int maxInfo = erh.getMaxInfos("INFOS","Showtop");
	String timefrom1=(erh.getTimeFrame("TIMEFRAME","From")==null) ? "00:00" :erh.getTimeFrame("TIMEFRAME","From");
	String timeto1=(erh.getTimeFrame("TIMEFRAME","To")==null) ? "23:59" :erh.getTimeFrame("TIMEFRAME","To");
	
	String timefrom="";
	String minfrom="";
	String timeto="";
	String minto="";
	StringTokenizer st=new StringTokenizer(timefrom1,":");
	if(st.hasMoreTokens())
	{
		timefrom=st.nextToken();
		minfrom=st.nextToken();
	}
	st=new StringTokenizer(timeto1,":");
	if(st.hasMoreTokens())
	{
		timeto = st.nextToken();
		minto = st.nextToken();
	}

	String timefrom2 = request.getParameter("timefrom");
	String minfrom2 = request.getParameter("minfrom");
	String timeto2 = request.getParameter("timeto");
	String minto2 = request.getParameter("minto");
	if (timefrom2!=null)
		timefrom=timefrom2;
	if (minfrom2!=null)
		minfrom=minfrom2;
	if (timeto2!=null)
		timeto=timeto2;
	if (minto2!=null)
		minto=minto2;

	String excludeweekend = request.getParameter("er_excwe");
	if (excludeweekend==null || excludeweekend.equals(""))
		excludeweekend="No";

	String Maintenance_Period = request.getParameter("er_maintenance");
	if(Maintenance_Period == null || Maintenance_Period.equals(""))
		Maintenance_Period = "No";
	String Days=(erh.getExcludeWeekends("EXCLUDE_WEEKEND","Days")==null)
	? "Saturday,Sunday" :erh.getExcludeWeekends("EXCLUDE_WEEKEND","Days");
	request.setAttribute("Weekends",Days);
	String returnfrom = request.getParameter("isreturn");

	//Date calculation according to time select
	String[] options = {"Any","1 day", "2 days", "3 days", "4 days", "5 days", "6 days","1 week","2 weeks","3 weeks","4 weeks","1 month"};//,"3 months"

	String startDateTime="";
	String endDateTime="";
	if(er_timeline!=null&&!er_timeline.equals("Any"))
	{
		int blankSpaceIndex = er_timeline.indexOf(DateTimeTokenizer.BLANK_SPACE);
		if (blankSpaceIndex > 0)
		{
			SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy HH:mm");
			java.util.Date today =  egDt.egetRealDate();
			endDateTime = sdf.format(today);

			long value = Integer.parseInt(er_timeline.substring(0, blankSpaceIndex));
			String unit = er_timeline.substring(blankSpaceIndex+1).toLowerCase();
			if (unit.startsWith("h"))
			{//hours
				value *= 3600;
			}
			else if (unit.startsWith("d"))
			{//days
				value *= (24 * 3600);
			}
			else if (unit.startsWith("w"))
			{//weeks
				value *= (7 * 24 * 3600);
			}
			else if (unit.startsWith("mo"))
			{//months
				java.util.Date dt_temp = egDt.egetRealDate();
				Calendar cal_temp = new GregorianCalendar();
				cal_temp.setTime(dt_temp);
				//cal_temp.add(Calendar.DATE,-1);
				cal_temp.add(Calendar.HOUR_OF_DAY,0);
				java.util.Date dt_temp1 = cal_temp.getTime();
				long l_temp = dt_temp1.getTime();
				int  totalDays=24*(ErUtils.getMaxDaysInMonth());
				startDateTime = egDt.egetDate(l_temp -(long)( (value*totalDays * msecsPerHour)));
				startDateTime = DateUtil.changeDateFormat(startDateTime,"dd/MM/yyyy HH:mm","MM/dd/yyyy HH:mm");
			}
			if (unit!=null&&!unit.startsWith("mo"))
			{
				java.util.Date start = new java.util.Date();
				java.util.Date startTmp=new java.util.Date(endDateTime);
				start.setTime(startTmp.getTime() - (value * 1000));
				startDateTime = sdf.format(start);
			}
		}
		if ((startDateTime != null) && (endDateTime != null))
		{
			s_inidate="MM/dd/yyyy";
			try
			{
				int shr=Integer.parseInt(startDateTime.substring(startDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE)+1, startDateTime.indexOf(":")));
				int en_hr=Integer.parseInt(endDateTime.substring(endDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE)+1, endDateTime.indexOf(":")));
				s_en_time=endDateTime.substring(0, endDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE));
				s_st_time=startDateTime.substring(0, startDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE));
				s_st_hr = String.valueOf(shr);
				s_en_hr = String.valueOf(en_hr);
				strmin="00";
				enmin="00";
			}
			catch(Exception e)
			{
			System.out.println("Eception caught :"+e);
			e.printStackTrace();
			}
		}
	}

	String disable="";
	if(er_timeline!=null&&!er_timeline.equals("Any"))
	{
		disable ="disabled";
	}
	if(er_timeline!=null&&er_timeline.equals("Any"))
	{
		String StrDate="";
		try
		{
			java.text.SimpleDateFormat df=new java.text.SimpleDateFormat("MM/dd/yyyy k 'at' hh:mm");
			StrDate =df.format(new java.util.Date());
		}
		catch(Exception ee)
		{
			System.out.println("Exception is"+ee);
		}
		String SDate =StrDate.substring(0,StrDate.indexOf(" "));
		String shour =StrDate.substring(StrDate.indexOf(" "),StrDate.lastIndexOf(""));
		shour = shour.substring(0,3);
		if(s_st_time==null)
		{
			s_st_time=SDate;
			s_inidate="MM/dd/yyyy";
		}
		if(s_en_time==null)
		{
			s_en_time=SDate;
		}
		if(s_st_hr==null)
		{
			shour =shour.trim();
			int starthr = Integer.parseInt(shour);
			starthr = starthr-1;
			s_st_hr=String.valueOf(starthr);
		}
		if(s_en_hr==null)
		{
			shour =shour.trim();
			s_en_hr =shour;
		}
		//s_st_hr = "0";
		//s_en_hr = "0";
		strmin="00";
		enmin="00";
	}
%>
<%
	String s_reporttype=request.getParameter("reporttype");
	if(s_reporttype == null)
		s_reporttype="esx_uptime";


	hiddenfieldsJson.put("currTime","");
	hiddenfieldsJson.put("er_rtype","Uptime");
	hiddenfieldsJson.put("font",font);
	hiddenfieldsJson.put("reporttype",s_reporttype);
	hiddenfieldsJson.put("er_trgttype","Esx");
	hiddenfieldsJson.put("eruserid",userid);
	//hiddenfieldsJson.put("er_combination","");
	hiddenfieldsJson.put("er_trenddata","No");
	hiddenfieldsJson.put("inidate",currentDateFormat);
	//hiddenfieldsJson.put("er_datafrom",datafrom);
	hiddenfieldsJson.put("uptimeType",uptimeType);
	hiddenfieldsJson.put("getMaxDaysInMonth",String.valueOf(ErUtils.getMaxDaysInMonth()));
	hiddenfieldsJson.put("fromSchedule",reqFromSchedule);
	hiddenfieldsJson.put("schedule_id",schedule_id);
	hiddenfieldsJson.put("er_ViewName","ErEsxUptimeReportData.jsp");
	hiddenfieldsJson.put("forwardto","ErEsxUptimeReportDataJson");
	hiddenfieldsJson.put("er_bgreportfrom","Virtualization_Uptime");
	hiddenfieldsJson.put("bgenabled",strbgrepportName);
	hiddenfieldsJson.put("limitforbg",limitforbg);
	hiddenfieldsJson.put("savereport","save");
	hiddenfieldsJson.put("servletName","com.eg.ErUptimeServletC");
	hiddenfieldsJson.put("userID",urs);
	hiddenfieldsJson.put("divStatus",divStatus);
	if(fromScheduleModify!=null)
		hiddenfieldsJson.put("fromScheduleModify",fromScheduleModify);
	else
		hiddenfieldsJson.put("fromScheduleModify","null");
	if(fromFavoriteModify!=null)
		hiddenfieldsJson.put("fromFavoriteModify",fromFavoriteModify);
	else
		hiddenfieldsJson.put("fromFavoriteModify","null");
	hiddenfieldsJson.put("favorite_id", favorite_id);
	hiddenfieldsJson.put("er_favorite", er_favorite);
	if(onlyCompTpye != null)
	{
		hiddenfieldsJson.put("onlyCompTpye",onlyCompTpye);
	}

	String isSubmitted =request.getParameter("isSubmit");
	rootJson.put("isSubmit",isSubmitted);

%>

<%
	String strwidth = "90%";
	if(backreqMap == null || backreqMap != null && backreqMap.size() == 0)
		strwidth="100%";
	if (!StringUtils.isNull(titleToDisplay)){ 
		list.add(titleToDisplay);
	}
	else
	{
		list.add(intlmap.getTextDescription("reporter.common.VIRTUALIZATION REPORT")+" - "+intlmap.getTextDescription("reporter.uptime.UPTIME"));
	}
	rootJson.put("reportTitle",intlmap.getTextDescription("reporter.common.VIRTUALIZATION REPORT")+" - "+intlmap.getTextDescription("reporter.uptime.UPTIME"));

%>
<%
					String fromFavSch = request.getParameter("fromFavSch");
					if(backreqMap != null && backreqMap.size() > 0 &&  enableBack && request.getParameter("enableBack")!=null && request.getParameter("enableBack").equalsIgnoreCase("true") && (fromFavSch!=null && fromFavSch.equalsIgnoreCase("true")))
					{
							rootJson.put("ID","backQnumber="+erhelputils.getBackID()+"&"+erhelputils.getQueryString());

					}
%>
							<%
								queryString = request.getQueryString();
								HashMap resultMap_temp = (HashMap)request.getAttribute("ResultDataMap");
								List uptimeList_temp = null;
								if(resultMap_temp != null)
									uptimeList_temp = (List)resultMap_temp.get("COMPONENT_LIST");
								if(resultDataMap != null && resultDataMap.size() != 0 && resultMap_temp !=null && uptimeList_temp != null && uptimeList_temp.size() > 0)
								{
							%>
<%
									if(er_type.equalsIgnoreCase("No"))
									{
%>

<%
									}
								}
								else
								{
%>

							<%
								}
							%>

<%
					String strGraphChecked="";
					String strDataChecked="";
					if(er_type == null || er_type.equals("Yes"))
					{
						strGraphChecked = "checked";
						strDataChecked = "";
					}
					else
					{
						strGraphChecked = "";
						strDataChecked = "checked";
					}
		screenLabelJson.put("reporter.common.Report Type",intlmap.getTextDescription("reporter.common.Report Type"));
		JSONArray reporttypeArray =  new JSONArray();

		loopJsonObj = new JSONObject();
		loopJsonObj.put("displayField",intlmap.getTextDescription("reporter.common.Graph"));
		loopJsonObj.put("valueField", "Yes");
		reporttypeArray.add(loopJsonObj);

		loopJsonObj = new JSONObject();
		loopJsonObj.put("displayField",intlmap.getTextDescription("reporter.common.Data"));
		loopJsonObj.put("valueField", "No");
		reporttypeArray.add(loopJsonObj);	

		rootJson.put("reportTypeCombo",reporttypeArray);
		rootJson.put("selectedreportType",er_type);


%>
							<%
								screenLabelJson.put("reporter.uptime.Uptime for",intlmap.getTextDescription("reporter.uptime.Uptime for"));
								screenLabelJson.put("reporter.uptime.Analyze by",intlmap.getTextDescription("reporter.uptime.Analyze by"));

								JSONArray uptimeForArr =  new JSONArray();
								for(int i=0; i<reportTypes.length; i++) 
								{
									String selected = "";
									if(er_uptimetest.equals(reportTypes[i])) {
										selected = " selected ";
										rootJson.put("selectedUptimeFor",er_uptimetest);
									}
										loopJsonObj = new JSONObject();
										String aString = reportTypes[i];
										if(reportTypes[i] !=null && reportTypes[i].equalsIgnoreCase("Physical Servers"))
										{
											aString = "Hypervisors";
										}
										loopJsonObj.put("displayField",intlmap.getComponentTypeDescription("reporter.uptime."+aString));
										loopJsonObj.put("valueField",reportTypes[i]);
										uptimeForArr.add(loopJsonObj);

									
							%>
							<%
								}
								rootJson.put("uptimeForCombo",uptimeForArr);
							%>
							<%
								JSONArray optionArray =  new JSONArray();
								String selected = "";
								for(int i=0; i<v_option.size(); i++) {
									if(v_option.get(i).equals(datafrom)) {
										rootJson.put("selectedOption",datafrom);
										selected = " selected ";
									} else {
										selected = "";
									}
									loopJsonObj = new JSONObject();
									loopJsonObj.put("displayField",intlmap.getTextDescription("reporter.compliance.eventlog."+v_option.get(i)));
									loopJsonObj.put("valueField",v_option.get(i));
									optionArray.add(loopJsonObj);

							%>
							<%
								}
								rootJson.put("optionCombo",optionArray);
							%>
<%
		screenLabelJson.put("reporter.common.Show Details",intlmap.getTextDescription("reporter.common.Show Details"));
		JSONArray showDetailsArr =  new JSONArray();

		loopJsonObj = new JSONObject();
		loopJsonObj.put("displayField",intlmap.getTextDescription("reporter.common.Yes"));
		loopJsonObj.put("valueField", "Yes");
		showDetailsArr.add(loopJsonObj);

		loopJsonObj = new JSONObject();
		loopJsonObj.put("displayField",intlmap.getTextDescription("reporter.common.No"));
		loopJsonObj.put("valueField", "No");
		showDetailsArr.add(loopJsonObj);	

		rootJson.put("showDetailsCombo",showDetailsArr);
					
			String shownyes="";
			String shownno="";
			if(showDetails !=null && showDetails.equals("Yes")){
				shownyes="checked";
				rootJson.put("showDetails","Yes");
			}
			else{
				shownno="checked";
				rootJson.put("showDetails","No");
	
			}
					if(er_type != null && er_type.equals("No"))
					{
%>
					<%

	
					%>
<%
					} else {
%>
<%
					}
		screenLabelJson.put("reporter.comparison.Include Subzone",intlmap.getTextDescription("reporter.comparison.Include Subzone"));
		JSONArray subzoneCombo =  new JSONArray();

		loopJsonObj = new JSONObject();
		loopJsonObj.put("displayField",intlmap.getTextDescription("reporter.common.Yes"));
		loopJsonObj.put("valueField", "Yes");
		subzoneCombo.add(loopJsonObj);

		loopJsonObj = new JSONObject();
		loopJsonObj.put("displayField",intlmap.getTextDescription("reporter.common.No"));
		loopJsonObj.put("valueField", "No");
		subzoneCombo.add(loopJsonObj);	

		rootJson.put("subzoneCombo",subzoneCombo);
						String checkincludey="";
						String checkincluden="";
						if(includezone!=null && includezone.equalsIgnoreCase("yes"))
						{
							checkincludey="checked";
							checkincluden="";
							rootJson.put("subzone","Yes");
						}
						else
						{
							checkincludey="";
							checkincluden="checked";
							rootJson.put("subzone","No");

						}

				if(datafrom!=null &&  !datafrom.equalsIgnoreCase("Component"))
				{
			screenLabelJson.put("reporter.common.group",intlmap.getTextDescription("reporter.compliance.eventlog."+datafrom));
			JSONArray groupArray =  new JSONArray();
					
%>

<%
						String defaultSiteText = "Please choose a " + datafrom;
						selected = "";
						if(v_site.size() == 0) {
							defaultSiteText = "Not Applicable";
							selected = " selected ";
						}	
%>
<%
							if(v_site.size() == 0) {
							loopJsonObj = new JSONObject();
							loopJsonObj.put("displayField",intlmap.getTextDescription("reporter.common.Not Applicable"));
							loopJsonObj.put("valueField", "-1");
							groupArray.add(loopJsonObj);

%>
<%
							} else {
								loopJsonObj = new JSONObject();
								loopJsonObj.put("displayField",intlmap.getTextDescription("reporter.uptime."+defaultSiteText));
								loopJsonObj.put("valueField", "-1");
								groupArray.add(loopJsonObj);

								for(int k=0;v_site.size()>k;k++){
									loopJsonObj = new JSONObject();
									if(v_site.get(k).equals("--Default--"))
									{
										loopJsonObj.put("displayField",intlmap.getTextDescription("reporter.uptime."+v_site.get(k)));
										loopJsonObj.put("valueField",v_site.get(k));
									}
									else
									{
									loopJsonObj.put("displayField",v_site.get(k));
									loopJsonObj.put("valueField",v_site.get(k));
									}
									groupArray.add(loopJsonObj);
								}
								rootJson.put("selectedGroup",s_site);
%>
<%
							}
							rootJson.put("groupCombo",groupArray);
%>
<%


%>
<%
				}
%>
<%
						screenLabelJson.put("reporter.consolidated.Component Type",intlmap.getTextDescription("reporter.consolidated.Component Type"));
						JSONArray comptypeArray = new JSONArray();
						rootJson.put("selectedCompType",s_comptype);
						if(v_comptype.size()==0)
						{
							loopJsonObj = new JSONObject();
							loopJsonObj.put("displayField",intlmap.getTextDescription("reporter.common.Not Applicable"));
							loopJsonObj.put("valueField", "-1");
							comptypeArray.add(loopJsonObj);

%>
<%
						}
						else if (v_comptype.size()==1)
						{
							loopJsonObj = new JSONObject();
							loopJsonObj.put("displayField",intlmap.getComponentTypeDescription((String)v_comptype.get(0)));
							loopJsonObj.put("valueField", v_comptype.get(0));
							comptypeArray.add(loopJsonObj);

%>
<%
						}
						else
						{
							loopJsonObj = new JSONObject();
							loopJsonObj.put("displayField",intlmap.getComponentTypeDescription("reporter.common.All"));
							loopJsonObj.put("valueField","-1");
							comptypeArray.add(loopJsonObj);
							
				
%>
<%

							for(int n=0;n<aSortedList.size();n++)
							{
								String dispValue=(String)aSortedList.get(n);
								String s = intlmap.getReverseComponentTypeDescription(dispValue);
								selected = "";
								if(s_comptype!=null && s_comptype.equalsIgnoreCase(s))
								{
									selected = " selected ";
								}
								else
								{
									selected = "";
								}
								loopJsonObj = new JSONObject();
								loopJsonObj.put("displayField",intlmap.getComponentTypeDescription(s));
								loopJsonObj.put("valueField",s);
								comptypeArray.add(loopJsonObj);

%>
<%
							} // for loop
						}
						rootJson.put("compTypeCombo",comptypeArray);
%>
<%
					/*
					Map compMap = new HashMap();
					for(int i=0; i<v_component.size(); i++)
					{
						String compString = (String)v_component.get(i);
						String strcompname = "";
						if(datafrom.equals("Service") || datafrom.equals("Segment") ) {
							strcompname=compString.substring(0,compString.indexOf(":"));
						} else {
							strcompname=compString.substring(compString.indexOf(":")+1,compString.lastIndexOf(":"));
						}
						if(!compMap.containsKey(strcompname)) {
							compMap.put(strcompname, compString);
						}
					}
					v_component = new Vector(compMap.values());
					*/
					if(er_uptimetest !=null && er_uptimetest.equalsIgnoreCase("Physical Servers"))
					{
						screenLabelJson.put("reporter.uptime.Physical Server",intlmap.getTextDescription( "reporter.uptime." + "Hypervisors"));
					}
					else
					{
						screenLabelJson.put("reporter.uptime.Physical Server",intlmap.getTextDescription( "reporter.uptime." + er_uptimetest));
					}
					if(reportFrom != null && reportFrom.equalsIgnoreCase("igelReport"))
					{
						screenLabelJson.put("reporter.uptime.Physical Server",intlmap.getTextDescription( "reporter.uptime.IGEL Endpoints"));
					}
					screenLabelJson.put("reporter.uptime.CompEmptyText",intlmap.getTextDescription( "reporter.uptime.Search Components"));
					if(onlyCompTypeLst != null && onlyCompTypeLst.size() > 0 && onlyCompTypeLst.contains("WVD_RDS_server"))
					{
						screenLabelJson.put("reporter.uptime.Physical Server",intlmap.getTextDescription( "reporter.uptime.Host Pool"));
						screenLabelJson.put("reporter.uptime.CompEmptyText",intlmap.getTextDescription( "reporter.uptime.Search Host Pool"));
					}
					if(onlyCompTypeLst != null && onlyCompTypeLst.size() > 0 && (onlyCompTypeLst.contains("Cloud_VMs") || onlyCompTypeLst.contains("Physical_Desktops")))
					{
						screenLabelJson.put("reporter.uptime.Physical Server",intlmap.getTextDescription( "reporter.uptime.Machines"));
					}
						JSONArray compArray = new JSONArray();
						JSONArray selectedcomp = new JSONArray();
						JSONObject componentMapping = new JSONObject();
						Hashtable allUnManagedComp = compUtil.getUserUnManagedComponents();
						Hashtable allUnmanagedCompType = compUtil.getUserUnManagedComponent_Type();
						JSONArray unmanageComponentJSONAray = new JSONArray();

%>
							<%
								if(uptimeType.equalsIgnoreCase("EsxGuest")) {
									ErUptimeReportBean bean1 = new ErUptimeReportBean();
									String testName = "VmgUptimeTest";
									if(reportFrom != null && reportFrom.equalsIgnoreCase("igelReport"))
									{
										testName = "IGELUptimeTest";
									}
									if(onlyCompTypeLst != null && onlyCompTypeLst.size() > 0 && onlyCompTypeLst.contains("WVD_RDS_server"))
									{
										testName = "WVDUptimeTest";
									}
									List guestList = new ArrayList();
									if(onlyCompTypeLst != null && onlyCompTypeLst.size() > 0 && onlyCompTypeLst.contains("WVD_RDS_server") && wvdReportFrom != null && wvdReportFrom.equalsIgnoreCase("sessionHost"))
									{
										if(selectedCompList != null && selectedCompList.size() > 0)
										{
											Vector v_componentTemp = new Vector();
											String firstComp = (String)selectedCompList.get(0);
											if(firstComp.equalsIgnoreCase("all"))
											{
												v_componentTemp.addAll(v_component);
											}
											else
											{
												v_componentTemp.addAll(selectedCompList);
											}
											guestList = bean1.getGuestList(v_componentTemp, datafrom,testName);
										}
									}
									else
									{
										guestList = bean1.getGuestList(v_component, datafrom,testName);
									}
									Vector guestVector = new Vector();
									guestVector.addAll(guestList);
									Collections.sort(guestVector, String.CASE_INSENSITIVE_ORDER);
									if(selectedCompArray == null || selectedCompArray.length == 0) {
										selectedCompArray = new String[guestVector.size()];
										selectedCompArray = ( String[]) guestVector.toArray(selectedCompArray);
									}
									
									if(guestVector!=null && !guestVector.isEmpty())
									{
										if(onlyCompTypeLst != null && onlyCompTypeLst.size() > 0 && onlyCompTypeLst.contains("WVD_RDS_server") && wvdReportFrom != null && wvdReportFrom.equalsIgnoreCase("sessionHost"))
										{
											loopJsonObj = new JSONObject();
											loopJsonObj.put("displayField", intlmap.getTextDescription("reporter.common.All Session Hosts"));
											loopJsonObj.put("valueField","all");
											compArray.add(loopJsonObj);
										}
										boolean haveUnmanagedComp=false;
										for(int i = 0;guestVector.size()>i;i++)
										{
											String s_guest= (String)guestVector.get(i);
											loopJsonObj = new JSONObject();
											loopJsonObj.put("displayField",s_guest);
											loopJsonObj.put("valueField",s_guest);
											if(allUnmanagedCompType!=null && allUnmanagedCompType.get(s_guest)!=null)
											{
												haveUnmanagedComp=true;
												loopJsonObj.put("groupField",intlmap.getTextDescription("reporter.common.UnManaged/Deleted Components"));
												unmanageComponentJSONAray.add(loopJsonObj);
											}
											else
											{
												//loopJsonObj.put("groupField",intlmap.getTextDescription("reporter.common.Managed Components"));
												compArray.add(loopJsonObj);
											}
											componentMapping.put(s_guest,s_guest);
											
										}
										if(haveUnmanagedComp && compArray!=null)
										{
											for(int u=0;u<compArray.size();u++)
											{
												loopJsonObj = (JSONObject)compArray.get(u);
												if(loopJsonObj.get("groupField")==null)
												{
													String valueF = (String)loopJsonObj.get("valueField");
													if(valueF != null && valueF.equalsIgnoreCase("All"))
													{
														continue;
													}
													loopJsonObj.put("groupField",intlmap.getTextDescription("reporter.common.Managed Components"));
												}
											}
										}
										compArray.addAll(unmanageComponentJSONAray);
									}else{
											loopJsonObj = new JSONObject();
											loopJsonObj.put("displayField",intlmap.getTextDescription("reporter.common.Not Applicable"));
											loopJsonObj.put("valueField", "-1");
											compArray.add(loopJsonObj);
											componentMapping.put("-1",intlmap.getTextDescription("reporter.common.Not Applicable"));

									}
									if(onlyCompTypeLst != null && onlyCompTypeLst.size() > 0 && onlyCompTypeLst.contains("WVD_RDS_server") && wvdReportFrom != null && wvdReportFrom.equalsIgnoreCase("sessionHost"))
									{
										String[] er_sessionHost = request.getParameterValues("er_sessionHost");
										List sessionHostList = null;
										if(er_sessionHost==null || er_sessionHost.length==0)
										{
											sessionHostList = new ArrayList();
											if(guestVector.isEmpty())
											{
												sessionHostList.add("-1");
											}
											else
											{
												sessionHostList.add("all");
											}
										}
										else
										{
											sessionHostList = Arrays.asList(er_sessionHost);
										}
										//
										rootJson.put("sessionHostSelected",sessionHostList);
										rootJson.put("sessionHostCombo",compArray);
										compArray = new JSONArray();
										selectedcomp = new JSONArray();
										componentMapping = new JSONObject();
										Vector temp_comp = new Vector();
										ArrayList sortedNameList1 = new ArrayList();
										sortedNameList1 = sorter.getSortedCompTypeList(v_component);
										boolean haveUnmanagedComp=false;
										for(int n=0;n<sortedNameList1.size();n++)
										{
											EgName nameObj =(EgName) sortedNameList1.get(n);
											String dispValue = nameObj.getLocalName();
											String sCompType = nameObj.getActualName();
											String s=(String)v_component.get(n);
											String strcompname = "";
											if(datafrom.equals("Service") || datafrom.equals("Segment") ) {
												strcompname=sCompType.substring(0,sCompType.indexOf(":"));
											} else {
												strcompname=sCompType.substring(sCompType.indexOf(":")+1, sCompType.lastIndexOf(":"));
											}
											selected = "";
											if(selectedCompList.size() == 0 || selectedCompList.contains("-1") || selectedCompList.contains(v_component.get(n)))
											{
												selected = " selected ";
												selectedcomp.add(v_component.get(n));
											}
											if(!temp_comp.contains(strcompname))
											{
												temp_comp.add(strcompname);
												v_comp_popup.add(sCompType);
												v_comp_popup_disp.add(strcompname);
												if(n==0)
												{
													loopJsonObj = new JSONObject();
													loopJsonObj.put("displayField","All Host Pools");
													loopJsonObj.put("valueField","all");
													compArray.add(loopJsonObj);
												}
												loopJsonObj = new JSONObject();
												loopJsonObj.put("displayField",strcompname);
												loopJsonObj.put("valueField",sCompType);
												if(allUnmanagedCompType!=null && allUnmanagedCompType.get(sCompType)!=null)
												{
													haveUnmanagedComp=true;
													loopJsonObj.put("groupField",intlmap.getTextDescription("reporter.common.UnManaged/Deleted Components"));
													unmanageComponentJSONAray.add(loopJsonObj);
												}
												else
												{
													//loopJsonObj.put("groupField",intlmap.getTextDescription("reporter.common.Managed Components"));
													compArray.add(loopJsonObj);
												}
												componentMapping.put(sCompType,strcompname);
											}
										}
										if(haveUnmanagedComp && compArray!=null)
										{
											for(int u=0;u<compArray.size();u++)
											{
												loopJsonObj = (JSONObject)compArray.get(u);
												if(loopJsonObj.get("groupField")==null)
												{
													String valueF = (String)loopJsonObj.get("valueField");
													if(valueF != null && valueF.equalsIgnoreCase("All"))
													{
														continue;
													}
													loopJsonObj.put("groupField",intlmap.getTextDescription("reporter.common.Managed Components"));
												}
											}
										}
										compArray.addAll(unmanageComponentJSONAray);
										String[] er_componentTemp = request.getParameterValues("er_component");
										selectedCompList = new ArrayList();
										if(er_componentTemp==null || er_componentTemp.length==0)
										{
											selectedCompList = new ArrayList();
											selectedCompList.add("all");
										}
										else
										{
											if(er_componentTemp != null) 
											{
												for(int i=0; i<er_componentTemp.length; i++) {
													selectedCompList.add(erUtils.specialCharDecode(er_componentTemp[i]));
												}
											}
										}
										if(v_component.size() == 0)
										{
											loopJsonObj = new JSONObject();
											loopJsonObj.put("displayField",intlmap.getTextDescription("reporter.common.Not Applicable"));
											loopJsonObj.put("valueField", "-1");
											compArray.add(loopJsonObj);
											componentMapping.put("-1",intlmap.getTextDescription("reporter.common.Not Applicable"));
											selectedCompList.add("-1");
										}
										rootJson.put("selectedComp",selectedCompList);
										rootJson.put("componentCombo",compArray);
										rootJson.put("combination",componentMapping);
									}
									else
									{
										rootJson.put("selectedComp",selectedCompArray);
										rootJson.put("componentCombo",compArray);
										rootJson.put("combination",componentMapping);
									}

							%>
<%
								} else {
									if(v_component.size() == 0)
									{
										v_comp_popup.add("-1");
										v_comp_popup_disp.add("Not Applicable");

										loopJsonObj = new JSONObject();
										loopJsonObj.put("displayField",intlmap.getTextDescription("reporter.common.Not Applicable"));
										loopJsonObj.put("valueField", "-1");
										compArray.add(loopJsonObj);
										componentMapping.put("-1",intlmap.getTextDescription("reporter.common.Not Applicable"));

%>
<%
									}
									Vector temp_comp = new Vector();
								
										ArrayList sortedNameList1 = new ArrayList();
										sortedNameList1 = sorter.getSortedCompTypeList(v_component);
										boolean haveUnmanagedComp=false;
										for(int n=0;n<sortedNameList1.size();n++)
									{
											EgName nameObj =(EgName) sortedNameList1.get(n);
											String dispValue = nameObj.getLocalName();
											String sCompType = nameObj.getActualName();
										String s=(String)v_component.get(n);
										String strcompname = "";
										if(datafrom.equals("Service") || datafrom.equals("Segment") ) {
											strcompname=sCompType.substring(0,sCompType.indexOf(":"));
										} else {
											strcompname=sCompType.substring(sCompType.indexOf(":")+1, sCompType.lastIndexOf(":"));
										}
										selected = "";
										if(selectedCompList.size() == 0 || selectedCompList.contains("-1") || selectedCompList.contains(v_component.get(n)))
										{
											selected = " selected ";
											selectedcomp.add(v_component.get(n));
										}
										if(!temp_comp.contains(strcompname))
										{
										temp_comp.add(strcompname);
										v_comp_popup.add(sCompType);
										v_comp_popup_disp.add(strcompname);

										loopJsonObj = new JSONObject();
										loopJsonObj.put("displayField",strcompname);
										loopJsonObj.put("valueField",sCompType);
										if(allUnmanagedCompType!=null && allUnmanagedCompType.get(sCompType)!=null)
										{
											haveUnmanagedComp=true;
											loopJsonObj.put("groupField",intlmap.getTextDescription("reporter.common.UnManaged/Deleted Components"));
											unmanageComponentJSONAray.add(loopJsonObj);
										}
										else
										{
											//loopJsonObj.put("groupField",intlmap.getTextDescription("reporter.common.Managed Components"));
											compArray.add(loopJsonObj);
										}
										componentMapping.put(sCompType,strcompname);

%>
<%
										}
									}
									if(haveUnmanagedComp && compArray!=null)
									{
										for(int u=0;u<compArray.size();u++)
										{
											loopJsonObj = (JSONObject)compArray.get(u);
											if(loopJsonObj.get("groupField")==null)
											{
												String valueF = (String)loopJsonObj.get("valueField");
												if(valueF != null && valueF.equalsIgnoreCase("All"))
												{
													continue;
												}
												loopJsonObj.put("groupField",intlmap.getTextDescription("reporter.common.Managed Components"));
											}
										}
									}
									compArray.addAll(unmanageComponentJSONAray);
									rootJson.put("selectedComp",selectedcomp);
									rootJson.put("componentCombo",compArray);
									rootJson.put("combination",componentMapping);
								}
%>
			
<%

						String show_maint_yes = "";
						String show_maint_no = "";
						if(Maintenance_Period != null && Maintenance_Period.equalsIgnoreCase("Yes")){
							show_maint_yes = "CHECKED";
							rootJson.put("maintanance","Yes");
						}else{
							show_maint_no = "CHECKED";
							rootJson.put("maintanance","No");

						}
		screenLabelJson.put("reporter.common.Include Maintenance",intlmap.getTextDescription("reporter.common.Include Maintenance"));
		JSONArray maintananceArray =  new JSONArray();

		loopJsonObj = new JSONObject();
		loopJsonObj.put("displayField",intlmap.getTextDescription("reporter.thin.Yes"));
		loopJsonObj.put("valueField", "Yes");
		maintananceArray.add(loopJsonObj);

		loopJsonObj = new JSONObject();
		loopJsonObj.put("displayField",intlmap.getTextDescription("reporter.thin.No"));
		loopJsonObj.put("valueField", "No");
		maintananceArray.add(loopJsonObj);	

		rootJson.put("maintananceCombo",maintananceArray);


	screenLabelJson.put("reporter.common.Exclude weekends",intlmap.getTextDescription("reporter.common.Exclude weekends"));
	JSONArray exclweekArray  =  new JSONArray();
	loopJsonObj = new JSONObject();
	loopJsonObj.put("displayField",intlmap.getTextDescription("reporter.common.Yes")+" ("+Days+") ");
	loopJsonObj.put("valueField", "Yes");
	exclweekArray.add(loopJsonObj);
	loopJsonObj = new JSONObject();
	loopJsonObj.put("displayField",intlmap.getTextDescription("reporter.common.No"));
	loopJsonObj.put("valueField", "No");
	exclweekArray.add(loopJsonObj);
	rootJson.put("excludeWeekCombo",exclweekArray);
	rootJson.put("excludeWeek",excludeweekend);
	screenLabelJson.put("MappedExcludeDays", intlmap.getTextDescription("reporter.common.Excludes")+" "+Days);


%>

					<%
						int colSpan = 4;
						if(er_type != null && er_type.equals("Yes")) {
							colSpan = 1;
						}
					%>
<%
								if(excludeweekend.equalsIgnoreCase("Yes") )
								{
%>
<%
								}
								else
								{
%>
<%
								}
%>
<%
	screenLabelJson.put("reporter.uptime.Chart",intlmap.getTextDescription("reporter.uptime.Chart"));
	JSONArray chartTypeArray  =  new JSONArray();
	loopJsonObj = new JSONObject();
	loopJsonObj.put("displayField",intlmap.getTextDescription("reporter.uptime.% Uptime/% Downtime"));
	loopJsonObj.put("valueField", "%Uptime/%Downtime");
	chartTypeArray.add(loopJsonObj);

	loopJsonObj.put("displayField",intlmap.getTextDescription("reporter.uptime.Uptime/Downtime"));
	loopJsonObj.put("valueField", "Uptime/Downtime");
	chartTypeArray.add(loopJsonObj);

	loopJsonObj.put("displayField",intlmap.getTextDescription("reporter.uptime.Reboots"));
	loopJsonObj.put("valueField", "Reboots");
	chartTypeArray.add(loopJsonObj);
	
	rootJson.put("chartCombo",chartTypeArray);
	rootJson.put("selectedChart",er_show);


					if(er_type == null || er_type.equals("Yes")) 
					{
%>
<%							
							selected = "";
							if(er_show!=null && er_show.equalsIgnoreCase("%Uptime/%Downtime"))
							{
								selected = " selected ";
							} else {
								selected = "";
							}
%>
<%							
							if(er_show!=null && er_show.equalsIgnoreCase("Uptime/Downtime"))
							{
								selected = " selected ";
							} else {
								selected = "";
							}
%>
<%
							if(er_show!=null && er_show.equalsIgnoreCase("Reboots"))
							{
								selected = " selected ";
							} else {
								selected = "";
							}
%>
<%
					}
%>
<%

				Vector v_sortby=new	Vector();
				v_sortby.add("Component");
				if(!er_show.equalsIgnoreCase("Reboots"))
				{
					v_sortby.add("Uptime");
					v_sortby.add("Downtime");
				}
				v_sortby.add("Reboots");

				List sortByValue = new ArrayList();
				sortByValue.add(new Integer(ErUptimeDowntimeBeanComparator.COMPONENT));
				if(!er_show.equalsIgnoreCase("Reboots"))
				{
					sortByValue.add(new Integer(ErUptimeDowntimeBeanComparator.UPTIME));
					sortByValue.add(new Integer(ErUptimeDowntimeBeanComparator.DOWNTIME));
				}
				sortByValue.add(new Integer(ErUptimeDowntimeBeanComparator.REBOOT));
				
				String sortby=request.getParameter("er_sortby");
				if (sortby==null ||	sortby.equals(""))
				{
					if(er_show.equalsIgnoreCase("Reboots")) {
						sortby=String.valueOf(ErUptimeDowntimeBeanComparator.REBOOT);
					} else {
						sortby=String.valueOf(ErUptimeDowntimeBeanComparator.DOWNTIME);
					}
				}
%>
<%
							screenLabelJson.put("reporter.comparison.Sort by", intlmap.getTextDescription("reporter.comparison.Sort by"));
							JSONArray sortArray = new JSONArray();

							for(int n=0;n<v_sortby.size();n++)
							{
								String s=(String)v_sortby.get(n);
								String value = sortByValue.get(n).toString();
								selected = "";
								if(sortby!=null && sortby.equalsIgnoreCase(value))
								{
									selected = " selected ";
								}
								else
								{
									selected = "";
								}

								loopJsonObj = new JSONObject();
								loopJsonObj.put("displayField",intlmap.getTextDescription("reporter.uptime."+s));
								loopJsonObj.put("valueField", value);
								sortArray.add(loopJsonObj);

%>
<%
							}
							rootJson.put("sortCombo",sortArray);
							rootJson.put("sortby",sortby);
%>
<%
					screenLabelJson.put("reporter.comparison.Show", intlmap.getTextDescription("reporter.comparison.Show"));
					JSONArray priorityArray = new JSONArray();

					String priority=request.getParameter("er_priority");
					if(priority==null || priority.equals(""))
						priority="TOP  - " +maxInfo;
					
					Vector v_show=new Vector();
					v_show.add("TOP  - " +maxInfo/4);
					v_show.add("TOP  - " +maxInfo/2);
					v_show.add("TOP  - " +maxInfo);
					v_show.add("ALL");
					v_show.add("LAST  - " +maxInfo);
					v_show.add("LAST  - " +maxInfo/2);
					v_show.add("LAST  - " +maxInfo/4);

						for(int n=0;n<v_show.size();n++)
						{
							String s=(String)v_show.get(n);
							selected = "";
							
							if(priority!=null && priority.equalsIgnoreCase(s))
							{
								selected = " selected ";
							}
							else
							{
								selected = "";
							}
								loopJsonObj = new JSONObject();
								loopJsonObj.put("displayField",intlmap.getTextDescription("reporter.common."+s));
								loopJsonObj.put("valueField", s);
								priorityArray.add(loopJsonObj);									
						}
						rootJson.put("priorityCombo",priorityArray);
						rootJson.put("priority",priority);

						screenLabelJson.put("reporter.common.Time period", intlmap.getTextDescription("reporter.common.Time period"));
						screenLabelJson.put("reporter.common.Hrs", intlmap.getTextDescription("reporter.common.Hrs"));
						screenLabelJson.put("reporter.common.Mins", intlmap.getTextDescription("reporter.common.Mins"));
						rootJson.put("selectedTimeFrom",timefrom);
						rootJson.put("selectedMinsFrom",minfrom);
						rootJson.put("selectedTimeTo",timeto);
						rootJson.put("selectedMinsTo",minto);

%>
						<%@  include file ="ErTimeFormatJSON.jsp"%> 
<%

	hiddenfieldsJson.put("userTimeline",strUsrTimeline);
	screenLabelJson.put("reporter.common.Timeline", intlmap.getTextDescription("reporter.common.Timeline"));
	screenLabelJson.put("reporter.common.From", intlmap.getTextDescription("reporter.common.From"));
	screenLabelJson.put("reporter.common.To", intlmap.getTextDescription("reporter.common.To"));
	screenLabelJson.put("reporter.common.Hr", intlmap.getTextDescription("reporter.common.Hr"));
	screenLabelJson.put("reporter.common.Graph", intlmap.getTextDescription("reporter.common.Graph"));

	rootJson.put("timelineCombo",timelineComboArray);
	//rootJson.put("timelineHourCombo",timelineHourComboArray);
	rootJson.put("selectedTimeline",er_timeline);
	rootJson.put("startDate",startDateJSON);
	rootJson.put("endDate",endDateJSON);
	rootJson.put("startHour",startHourJSON);
	rootJson.put("endHour",endHourJSON);
	rootJson.put("startmin",startMin);
	rootJson.put("endmin",endMin);
	rootJson.put("selectedGraphMode",selectedGraphMode);
	
	rootJson.put("startDateForDisplay",startDateForDisplay);
	rootJson.put("startHourForDisplay",startHourForDisplay);
	rootJson.put("startMinForDisplay",startMinForDisplay);
	rootJson.put("endDateForDisplay",endDateForDisplay);
	rootJson.put("endHourForDisplay",endHourForDisplay);
	rootJson.put("endMinForDisplay",endMinForDisplay);
    
//
String pdfStartDate = startDateForDisplay+" "+startHourForDisplay+":"+startMinForDisplay;
String pdfEndDate = endDateForDisplay+" "+endHourForDisplay+":"+endMinForDisplay;
//
	
	screenLabelJson.put("reporter.common.Report Generation", intlmap.getTextDescription("reporter.common.Report Generation"));
	screenLabelJson.put("reporter.common.SUBMIT", intlmap.getTextDescription("reporter.common.SUBMIT"));
	screenLabelJson.put("reporter.common.Report Name", intlmap.getTextDescription("reporter.common.Report Name"));
	JSONArray reportGenerationComboArray =  new JSONArray();
	JSONObject tmpobj=new JSONObject();
	tmpobj.put("displayField", strbackground);
	tmpobj.put("valueField", "background");
	reportGenerationComboArray.add(tmpobj);
	tmpobj=new JSONObject();
	tmpobj.put("displayField", strforeground);
	tmpobj.put("valueField", "foreground");
	reportGenerationComboArray.add(tmpobj);
	rootJson.put("reportGenerationCombo",reportGenerationComboArray);
	
	
	String er_reportgenration = request.getParameter("er_reportgenration");
	String er_background ="";
	String er_foreground ="";
	if (er_reportgenration != null && er_reportgenration.equals("background"))
	{
		er_background = "selected";
		er_foreground = "";
		rootJson.put("reportGeneration","background");

	}
	else
	{
		er_background = "";
		er_foreground = "selected";
		rootJson.put("reportGeneration","foreground");

	}
	String bg_reportname = request.getParameter("bg_reportname");
	if(bg_reportname == null)
	{
		bg_reportname = "";
	}
	if(strbgrepportName != null && strbgrepportName.equalsIgnoreCase("Yes"))
	{
%>
<%
		if (er_reportgenration != null && er_reportgenration.equals("background"))
		{
%>
<%
		}
		else
		{
%>
<%
		}
%>

 <%
	}
%>

<%
				if(reqFromSchedule!=null && reqFromSchedule.equalsIgnoreCase("Yes"))
				{
%>
<%
				}
				else
				{
%>
<%
				}
%>
<%
if(bggroundStr != null && !bggroundStr.equals(""))
{
	rootJson.put("backgroundReportStatus",status);

%>
<%
	String strreportName ="Virtualization_Uptime";
	if((status != null && (status.equalsIgnoreCase("duplicate")) || (bggroundStr!=null && bggroundStr.equalsIgnoreCase("User background report generationlimit is finished"))))
	{
		strreportName ="All Report Types";

%>

<%
	}
		if(strreportName!=null && strreportName.indexOf(" ") > -1)
		{
			strreportName = com.eg.EgURLEncoder.encode(strreportName, "UTF-8");
		}
		String bgroundResponseTxt=bggroundStr;
		if(status != null && !status.equalsIgnoreCase("exceedLimit"))
		{
			bgroundResponseTxt=erbgreport.getlangsupportedString(bggroundStr,bgString,urs);
		}
		rootJson.put("bgroundResponseTxt",bgroundResponseTxt);
		rootJson.put("bgroundReportsURL","/final/servlet/com.eg.ErStartBackGroundReportC?back=true&er_bgreportfrom="+strreportName+"&userID="+com.eg.EgURLEncoder.encode(urs, "UTF-8")+"&savereport=search&er_filterby=Report_Name&forwardto=ErBackGoundProcess");
		rootJson.put("backgroundAnchor", intlmap.getTextDescription("reporter.common.Click here to see a list of generated and processing reports"));

%>
 <%
	}

	JSONObject selectionDetails=new JSONObject();

 							rootJson.put("selectionDetailstitle", intlmap.getTextDescription("reporter.common.Selection Details for")+" "+er_uptimetest);


%>
			
<%
							if(er_uptimetest != null && er_uptimetest.equalsIgnoreCase("Physical Servers"))
							{
								er_uptimetest = "Hypervisors";
							}
							if(wvdReportFrom == null)
							{
								selectionDetails.put(intlmap.getTextDescription("reporter.uptime.Uptime For"),er_uptimetest);
							}
							selectionDetails.put(intlmap.getTextDescription("reporter.uptime.Analyze by"),datafrom);
							//selectionDetails.put(intlmap.getTextDescription("reporter.consolidated.Component Type"),s_comptype);
							selectionDetails.put(intlmap.getTextDescription("reporter.consolidated.Component Type"),s_comptype.equals("-1")?"All":intlmap.getComponentTypeDescription(s_comptype));

							//selectionDetails.put(intlmap.getTextDescription("reporter.comparison.Sort by"),sortby);
							selectionDetails.put(intlmap.getTextDescription("reporter.common.Exclude weekends"),excludeweekend);
							selectionDetails.put(intlmap.getTextDescription("reporter.common.Time Period "),timefrom2+":"+minfrom2+"  "+intlmap.getTextDescription("reporter.common.to")+" </span>  "+timeto2+":"+minto2);

							selectionDetails.put((String)intlmap.getTextDescription("reporter.common.Timeline"),pdfStartDate+" "+intlmap.getTextDescription("reporter.common.hrs")+"  <span class='font_bold'>"+intlmap.getTextDescription("reporter.common.to")+" </span>"+pdfEndDate+" "+intlmap.getTextDescription("reporter.common.hrs"));
							 
							rootJson.put("selectionDetails",selectionDetails);

%>

<%
			String isSubmit = request.getParameter("isSubmit");
			if(isSubmit != null && isSubmit.equalsIgnoreCase("true") && (bggroundStr == null || bggroundStr != null && bggroundStr.equals(""))) 
			{
				HashMap resultMap = (HashMap)request.getAttribute("ResultDataMap");
				session.setAttribute("ResultVal",resultMap);
				List uptimeList = null;
				if(resultMap != null)
					uptimeList = (List)resultMap.get("COMPONENT_LIST");
				if(resultMap !=null && uptimeList != null && uptimeList.size() > 0)
				{
					String detailsTitle = "";
					if(er_show.equalsIgnoreCase("Reboots"))
					{
						detailsTitle = er_uptimetest + " Reboots";
					}
					else
					{
						if(er_uptimetest !=null && er_uptimetest.equalsIgnoreCase("Physical Servers"))
						{
							//detailsTitle = intlmap.getTextDescription("reporter.common.Hypervisors Uptime");
							detailsTitle = intlmap.getTextDescription("reporter.common.Hypervisors");
						}
						else
						{
							//detailsTitle = er_uptimetest + " "+intlmap.getTextDescription("reporter.common.Uptime");
							detailsTitle = er_uptimetest;
						}
					}
					if(wvdReportFrom != null && wvdReportFrom.equalsIgnoreCase("sessionHost"))
					{
						detailsTitle = "Session Hosts";
					}
					if(wvdReportFrom != null && wvdReportFrom.equalsIgnoreCase("HostPool"))
					{
						detailsTitle = "Host Pool";
					}
					if(er_type == null || er_type.equals("No")) {
						detailsTitle += " Report";
					} else if(er_type != null && er_type.equals("Yes") && wvdReportFrom==null) {
						detailsTitle += " Chart ";
					}
					if(onlyCompTypeLst != null && onlyCompTypeLst.size() > 0 && (onlyCompTypeLst.contains("Cloud_VMs") || onlyCompTypeLst.contains("Physical_Desktops")))
					{
						detailsTitle = intlmap.getTextDescription("reporter.common.Machines");
					}
					String detailsSubTitle = "";
					String detailsSubTitle1 = "";
					String detailsSubTitle2 = "";
					String detailsSubTitle3 = "";
					if(!datafrom.equals("Component")) {
						detailsTitle += " for";
						detailsSubTitle = s_site;
						detailsSubTitle1 = datafrom;
					}
					if(s_comptype != null && !s_comptype.equals("-1") && !s_comptype.equals("NotApplicable")) {
						detailsSubTitle2 = " - ";
						detailsSubTitle3 = s_comptype;
					}
					if(er_type == null || er_type.equals("No"))
					{
						String s_title = "";
						s_title=intlmap.getTextDescription("reporter.uptime." + detailsTitle )+ " " +detailsSubTitle;
						if(detailsSubTitle1!="")
							s_title+= " "+intlmap.getTextDescription("reporter.uptime." + detailsSubTitle1);
						s_title+=detailsSubTitle3 == "" ? "" : " " +detailsSubTitle2;
						if(detailsSubTitle3 != "")
						{
							s_title+= " " +intlmap.getComponentTypeDescription(detailsSubTitle3);
						}
						JSONObject reportDataJson = new JSONObject();
						JSONObject gridObj=new JSONObject();
						JSONArray gridColumns=new JSONArray();
						JSONObject gridColumnsMapping=new JSONObject();
						JSONArray gridDataArray=new JSONArray();
						gridObj.put("title",s_title);
						gridColumns.add(er_uptimetest);
						gridColumns.add("uptime");
						gridColumns.add("uptime_pct");
						gridColumns.add("downtime");
						gridColumns.add("downtime_pct");
						gridColumns.add("reboots");
						gridColumns.add("details");
						if(onlyCompTypeLst != null && onlyCompTypeLst.size() > 0 && onlyCompTypeLst.contains("WVD_RDS_server"))
						{
							String gridTitle = "Session Host";
							if(wvdReportFrom != null && wvdReportFrom.equalsIgnoreCase("HostPool"))
							{
								gridTitle = "Host Pool";
							}
							gridColumnsMapping.put(er_uptimetest,intlmap.getTextDescription("reporter.uptime." + gridTitle));
						}
						else
						{
							if(er_uptimetest!=null && er_uptimetest.equalsIgnoreCase("Physical Servers"))
							{
								gridColumnsMapping.put(er_uptimetest,intlmap.getTextDescription("reporter.uptime.Hypervisors"));
							}
							else
							{
								gridColumnsMapping.put(er_uptimetest,intlmap.getTextDescription("reporter.uptime." + er_uptimetest));
							}
						}
						gridColumnsMapping.put("uptime",intlmap.getTextDescription("reporter.uptime.Uptime")+"("+intlmap.getTextDescription("reporter.uptime.yMdhm")+")*");
						gridColumnsMapping.put("uptime_pct",intlmap.getTextDescription("reporter.uptime. % Uptime"));
						gridColumnsMapping.put("downtime",intlmap.getTextDescription("reporter.uptime.Downtime")+"("+intlmap.getTextDescription("reporter.uptime.yMdhm")+")*");
						gridColumnsMapping.put("downtime_pct",intlmap.getTextDescription("reporter.uptime. % DownTime"));
						gridColumnsMapping.put("reboots",intlmap.getTextDescription("reporter.uptime.Reboots"));
						gridColumnsMapping.put("details",intlmap.getTextDescription("reporter.uptime.Details"));

							String weekend=request.getParameter("er_excwe");
							String csv_wk="";
							if(weekend!=null && weekend.equalsIgnoreCase("Yes"))
									csv_wk=intlmap.getTextDescription("reporter.common.Exclude weekends")+" : " +reportinfo.getExcludeWeekend(sub);
							list.add(intlmap.getTextDescription("reporter.common.Time period")+":"+intlmap.getTextDescription("reporter.common.From")+" "+request.getParameter("timefrom")+":"+request.getParameter("minfrom")+intlmap.getTextDescription("reporter.common.Hrs")+" "+intlmap.getTextDescription("reporter.common.To")+" "+request.getParameter("timeto")+":"+request.getParameter("minto")+intlmap.getTextDescription("reporter.common.Hrs")+","+'"'+csv_wk+'"');
							Vector v_date = new Vector();
							v_date.add("\""+intlmap.getTextDescription("reporter.common.Start Date")+" : "+st_dateTime+"\"");
							v_date.add("\""+intlmap.getTextDescription("reporter.common.End Date")+" : "+en_dateTime+"\"");
							list.add(v_date);

							s_title = "";
							s_title = intlmap.getTextDescription("reporter.uptime. Uptime Report")+detailsSubTitle+intlmap.getTextDescription("reporter.uptime. Uptime Report "+detailsSubTitle1)+detailsSubTitle2+" "+intlmap.getComponentTypeDescription(detailsSubTitle3);
							if(onlyCompTypeLst != null && onlyCompTypeLst.size() > 0 && onlyCompTypeLst.contains("WVD_RDS_server"))
							{
								String csvCol = "Session Host";
								if(wvdReportFrom != null && wvdReportFrom.equalsIgnoreCase("HostPool"))
								{
									csvCol = "Host Pool";
								}
								v_measure.add(intlmap.getTextDescription("reporter.uptime."+csvCol+""));
							}
							else
							{
								v_measure.add(intlmap.getTextDescription("reporter.uptime.Server"));
							}
							v_measure.add(intlmap.getTextDescription("reporter.uptime.Uptime (yMdhm)"));
							v_measure.add(intlmap.getTextDescription("reporter.uptime.% Uptime"));
							v_measure.add(intlmap.getTextDescription("reporter.uptime.Downtime (yMdhm)"));
							v_measure.add(intlmap.getTextDescription("reporter.uptime.% Downtime"));
							v_measure.add(intlmap.getTextDescription("reporter.uptime.Reboots"));

							if(uptimeList !=null)
							{
								for(int i=0; i<uptimeList.size(); i++)
								{
									JSONArray data =  new JSONArray();
									ErUptimeDowntimeBean uptimeBean = (ErUptimeDowntimeBean) uptimeList.get(i);
									String sUpTime = uptimeBean.getUpTime();
									list_data.add(uptimeBean.getComponent());
									list_data.add(getDisplayString(uptimeBean.getUpTime(), "-"));
									list_data.add(uptimeBean.getPerUpTime());
									list_data.add(getDisplayString(uptimeBean.getDownTime(), "-"));
									list_data.add(uptimeBean.getPerDownTime());
									String sNoOfReboots = "-";
									if (sUpTime.equals("-")) {
										list_data.add(sNoOfReboots);
									} else {
										list_data.add(uptimeBean.getNoOfReboots()+"");
										sNoOfReboots = uptimeBean.getNoOfReboots()+"";
									}
									data.add(uptimeBean.getComponent());
									data.add(getDisplayString(uptimeBean.getUpTime(), "0"));
									data.add(uptimeBean.getPerUpTime());
									data.add(getDisplayString(uptimeBean.getDownTime(), "0"));
									data.add(uptimeBean.getPerDownTime());
									data.add(sNoOfReboots);

%>
								<%
									if(!sNoOfReboots.equals("-") && uptimeBean.isShowDetails()) {
									data.add("details.gif"+"~"+com.eg.EgURLEncoder.encode(uptimeBean.getComponent(), "UTF-8"));

								%>

										
								<%
									} else {
									data.add("-");
								%>
								<%
									}
								%>
<%								gridDataArray.add(data);
								}
							}
							h_tabrc.put(v_measure,list_data);
							h_tab.put(s_title,h_tabrc);
							list.add(h_tab);
							list_data.add("\n");
							v_measure = new Vector();
							list_data = new LinkedList();
							s_title = new String();
							h_tabrc = new Hashtable();
							h_tab = new Hashtable();
%>

<%
						gridObj.put("columns",gridColumns);
						gridObj.put("mappedColumns",gridColumnsMapping);
						gridObj.put("dataArray",gridDataArray);
						rootJson.put("reportData",gridObj);
						rootJson.put("footerText",intlmap.getTextDescription("reporter.uptime.y - year, M - month, D - day, h - hour, m - min"));
					}
					if(er_type != null && er_type.equals("Yes"))
					{
						JSONObject chartObj = new JSONObject();
						JSONObject overviewData = new JSONObject();
						String s_title = "";
						s_title=intlmap.getTextDescription("reporter.uptime." + detailsTitle )+ " "+detailsSubTitle;
						if(detailsSubTitle1!="")
							s_title+=" "+intlmap.getTextDescription("reporter.uptime." + detailsSubTitle1);
						s_title+=detailsSubTitle3 == "" ? "" : " "+detailsSubTitle2;
						if(detailsSubTitle3 != "")
						{
							s_title+=" " +intlmap.getComponentTypeDescription(detailsSubTitle3);
						}
						if(wvdReportFrom != null)
							s_title = priority+" "+detailsTitle+" with High Downtime";
						int totalNoOfServers      = uptimeList.size();
						int fullUptimeServerCount = 0;
						int downtimeServerCount   = 0;
						long perServerDownTime    = 0;
						long totalDownTimeMin     = 0;
						long avgDownTimeMin       = 0;
						String serverUptime       = "0";
						String serverDowntime     = "0";
						String compontentName     = "";
						double totalDownPercentage=0;

						for(int cnt=0;cnt<totalNoOfServers;cnt++)	
						{
							ErUptimeDowntimeBean uptimeBean = (ErUptimeDowntimeBean) uptimeList.get(cnt);
							perServerDownTime = uptimeBean.getDownTimeMills();
							if(perServerDownTime==0)
							{
								fullUptimeServerCount++;
							}
							else
							{
								 totalDownTimeMin+=perServerDownTime/60000;
								 downtimeServerCount++;
								 //totalDownPercentage +=Double.valueOf(uptimeBean.getPerDownTime());
								 totalDownPercentage +=Double.valueOf(uptimeBean.getDownTimeMills()+"");
							 }
						}
						if(totalDownTimeMin!=0 && downtimeServerCount!=0)
						{
							avgDownTimeMin=totalDownTimeMin/downtimeServerCount;
						}
						//chartObj.put("title",s_title);
						chartObj.put("chartTitle",s_title);
						String uptimeForStr = intlmap.getTextDescription("reporter.common.Servers");
						if(er_uptimetest.equalsIgnoreCase("Virtual Machines")) 
						{
							uptimeForStr = intlmap.getTextDescription("reporter.common.VMs");;
						}
						if(onlyCompTypeLst != null && onlyCompTypeLst.size() > 0 && (onlyCompTypeLst.contains("Cloud_VMs") || onlyCompTypeLst.contains("Physical_Desktops")))
						{
							uptimeForStr = intlmap.getTextDescription("reporter.common.Machines");
						}
						if(reportFrom != null && reportFrom.equalsIgnoreCase("igelReport"))
						{
							uptimeForStr = "Endpoint";
						}
						if(wvdReportFrom != null && wvdReportFrom.equalsIgnoreCase("sessionHost"))
						{
							uptimeForStr = "Session Hosts";
						}
						if(wvdReportFrom != null && wvdReportFrom.equalsIgnoreCase("HostPool"))
						{
							uptimeForStr = "Host Pool";
						}
						overviewData.put("totalNoOfServers",totalNoOfServers+"");
						overviewData.put("ServersTxt","Total "+uptimeForStr);
						overviewData.put("fullUptimeServerCount",fullUptimeServerCount+"");
						overviewData.put("fullUptimeTxt",uptimeForStr+" with no downtime");
						overviewData.put("downtimeServerCount",downtimeServerCount+"");
						overviewData.put("downtimeTxt",uptimeForStr+" with downtime");
						overviewData.put("avgDownTimeMin",avgDownTimeMin+"");
						overviewData.put("avgDownTimeTxt","Average downtime");



						ErFusionChartBean chartbean = new ErFusionChartBean();
						HashMap barChartParam = (HashMap) resultMap.get("SERVERS_BARCHART");
						session.setAttribute("SERVERS_BARCHART",barChartParam);
						String yAxisMinMax = ""; 
						if(barChartParam != null && !barChartParam.isEmpty()) 
						{
							String numberSuffix = "";
							if(er_show.equalsIgnoreCase("%Uptime/%Downtime")) {
								numberSuffix = "%";
								yAxisMinMax = "yAxisMaxvalue='100' yAxisMinValue='0' numDivLines='5'";
							}
							else if(er_show.equalsIgnoreCase("Uptime/Downtime")) 
							{
								numberSuffix = " sec";
							}

							IniFile eg_report = new IniFile(EgInstallInfo.getInstallDir() +"/manager/config/eg_report.ini");
							String uptimeColor = eg_report.getValue("UPTIME_REPORTS", "FusionColorForUptime");
							if(uptimeColor == null) 
							{
								uptimeColor = "";
							}

							String downtimeColor = eg_report.getValue("UPTIME_REPORTS", "FusionColorForDowntime");
							if(downtimeColor == null) {
								downtimeColor = "";
							}

							String rebootColor = eg_report.getValue("UPTIME_REPORTS", "FusionColorForReboot");
							if(rebootColor == null) {
								rebootColor = "";
							}

							String er_mode = request.getParameter("er_mode");
							boolean use3DGraphs = ui.use3DGraphs(IniUI.REPORTER);
							if(er_mode==null || er_mode.equals(""))
							{
								if(use3DGraphs)
									er_mode="3D";
								else
									er_mode="2D";
							}
							String barLabels = (String) barChartParam.get("barLabels");
							st = new StringTokenizer(barLabels, ",");

							String barwidth = "";
							String gap = "";
							
							int countlabels = st.countTokens();
							int heightForapplet = chartbean.getbarHeightforCount(countlabels);
							if(heightForapplet>0)
							{
								heightForapplet = (heightForapplet - (countlabels*15));
							}
							if(countlabels <= 4)
							{
								if(er_mode!=null && er_mode.equalsIgnoreCase("3D")){
									barwidth = "82";
									gap = "20";
								}
								else{
									if(countlabels == 1)
										gap = "70";
									else
										gap ="45";
								}
							}
							else
							{
								if(er_mode!=null && er_mode.equalsIgnoreCase("3D")){
									barwidth = "42";
									gap = "10";
								}
								else
								{
									gap = "20";
								}
							}

							String strXML = "";
							JSONArray xAxisDataLabel = new JSONArray();
							JSONArray  barUptimeDataSet= new JSONArray();
							JSONArray  barDowntimeDataSet= new JSONArray();
							Vector labelList=new Vector();
							String yAxisLabel= (String) barChartParam.get("rangeAxisLabel");

							strXML += "<chart labelDisplay='WRAP' plotGradientColor='' alpha='0' caption='' shownames='1' showvalues='1' showSum='0' placeValuesInside='1' decimals='2' overlapBars='0' showShadow='0' baseFontColor='000000' showplotborder='0' showBorder = '0' canvasborderalpha='0' showcanvasborder='0' showAlternateHGridColor='0' showAlternateVGridColor='0' divLineIsDashed='0' formatNumberScale = '0' bgcolor='FFFFFF' numberSuffix='" + numberSuffix + "' " + yAxisMinMax + ">";
							strXML += "<categories> ";
							
							while (st.hasMoreTokens() ){
								String strremovedspace=st.nextToken();
								if(strremovedspace.indexOf(" - ") >-1)
								{
									strremovedspace = strremovedspace.substring(strremovedspace.indexOf(" "),strremovedspace.lastIndexOf(" ")+1);
								}
								while(strremovedspace.indexOf("\\n") >=0){
									String Comp = strremovedspace.substring(0,strremovedspace.indexOf("\\n")).trim();
									String str = strremovedspace.substring(strremovedspace.indexOf("\\n")+2,strremovedspace.length());
									strremovedspace = Comp+str;
								}
								//strremovedspace = chartbean.getDisplayLabel1(strremovedspace);
									labelList.add(strremovedspace);
								String displayValue = strremovedspace;
								if(strremovedspace.length() >39)
									strremovedspace = strremovedspace.substring(0,39)+"...";
								strXML += "<category label='"+ strremovedspace +"' toolText='"+ displayValue +"' /> ";
								xAxisDataLabel.add(displayValue);
							}
							strXML += "</categories>";

							String downtimeValues = (String) barChartParam.get("sampleValues_1");

							strXML += "<dataset seriesName='"+ (downtimeValues == null ? "Reboots" : "Uptime") +"' color='"+ (downtimeValues == null ? rebootColor : uptimeColor) +"' alpha='100' anchorAlpha='0' lineThickness='2' showAnchors='1' >";
							String uptimeValues = (String) barChartParam.get("sampleValues_0");
							st = new StringTokenizer(uptimeValues, ",");
							int i=0;
							while (st.hasMoreTokens() ){
								String strValue = st.nextToken();
									if(strValue.equalsIgnoreCase("0"))
									{
										strValue = "";
									}
								//strXML += "<set value='"+ strValue +"' alpha='100' link='" + com.eg.EgURLEncoder.encode(barChartParam.get("url_0_"+i++).toString(), "UTF-8") + "' /> ";
								String strurl="url_0_"+i;
								strXML += "<set value='"+ strValue +"' alpha='100' link='javascript:linkURL(&apos;"+strurl+"&apos;)'/>";
						String url= (String) barChartParam.get("url_0_"+i);

								 // karthikeyan
						if(strValue.length()==0)
						{
							strValue = "0";
							  JSONObject obj = new JSONObject();
							   obj.put("name",labelList.get(i));
							   obj.put("y",Double.valueOf(strValue));
							   obj.put("url",url);
							   JSONObject dataLabelObj = new JSONObject();
								dataLabelObj.put("enabled",false);
								obj.put("dataLabels",dataLabelObj);
							   barUptimeDataSet.add(obj);
						}
						else if(Double.valueOf(strValue)<13)
								{
							  JSONObject obj = new JSONObject();
							   obj.put("name",labelList.get(i));
							   obj.put("y",Double.valueOf(strValue));
							   obj.put("url",url);
								JSONObject dataLabelObj = new JSONObject();
								dataLabelObj.put("enabled",false);
								obj.put("dataLabels",dataLabelObj);
							   barUptimeDataSet.add(obj);

								}
						else
								{
							  JSONObject obj = new JSONObject();
							   obj.put("name",labelList.get(i));
							   obj.put("y",Double.valueOf(strValue));
							   if(!reportFrom.equalsIgnoreCase("igelReport"))
							   {
									obj.put("url",url);
							   }
							   barUptimeDataSet.add(obj);
								}
							i++;
								//


							}
							strXML += "</dataset>";

							
							if(downtimeValues != null) {
								strXML += "<dataset seriesName='Downtime'  color='" + downtimeColor + "'>";
								
								st = new StringTokenizer(downtimeValues, ",");
								i = 0;
								while (st.hasMoreTokens() ){
									String strValue = st.nextToken();
									if(strValue.equalsIgnoreCase("0"))
									{
										strValue = "";
									}
									String strurl="url_1_"+i;
									strXML += "<set value='"+ strValue +"' alpha='100' link='javascript:linkURL(&apos;"+strurl+"&apos;)'/>";
						String url= (String) barChartParam.get("url_1_"+i);

										   // karthikeyan
						   if(strValue.length()==0)
						{
							strValue = "0";
							 JSONObject obj = new JSONObject();
							   obj.put("name",labelList.get(i));
							   obj.put("y",Double.valueOf(strValue));
							   obj.put("url",url);
								JSONObject dataLabelObj = new JSONObject();
								dataLabelObj.put("enabled",false);
								obj.put("dataLabels",dataLabelObj);
								barDowntimeDataSet.add(obj);
						}
						else if(Double.valueOf(strValue)<13)
						{
							JSONObject obj = new JSONObject();
							obj.put("name",labelList.get(i));
							obj.put("y",Double.valueOf(strValue));
							obj.put("url",url);
							JSONObject dataLabelObj = new JSONObject();
							dataLabelObj.put("enabled",false);
							obj.put("dataLabels",dataLabelObj);
							barDowntimeDataSet.add(obj);
						}
						else
						{
							JSONObject obj = new JSONObject();
							obj.put("name",labelList.get(i));
							obj.put("y",Double.valueOf(strValue));
							obj.put("url",url);
							barDowntimeDataSet.add(obj);
						}
							i++;
							//

								//strXML += "<set value='"+ strValue +"' link='" + com.eg.EgURLEncoder.encode(barChartParam.get("url_1_"+i++).toString(), "UTF-8") + "' /> ";
							}
							strXML += "</dataset>";
							}
							if(downtimeValues != null) {
								strXML += "<!-- <styles> <definition> <style name='myValuesFont' type='font' size='10' color='FFFFFF' bold='1' bgColor='ffffff' /> </definition> <application> <apply toObject='DataValues' styles='myValuesFont' /> </application> </styles> -->";
							}
							strXML += "</chart>";
							String swf = "/final/FusionCharts/swf/StackedBar" +  (er_mode != null && er_mode.equalsIgnoreCase("2D") ? "2" : "3" ) + "D.swf";
							chartObj.put("swfpath",swf);
							chartObj.put("XML",strXML);
							chartObj.put("chartHeight",String.valueOf(heightForapplet));
																				// high chart stacked  bar
							//
							int barheight=330;
							/*int barheight=100;
							if(barUptimeDataSet.size()<=5)
							{
							  barheight=290;
							}
							else if(barUptimeDataSet.size()==6)
							{
								 barheight+=barUptimeDataSet.size()*27;
							}
							else if(barUptimeDataSet.size()>6)
							{
								barheight+=barUptimeDataSet.size()*25;
							}

							else if(barDowntimeDataSet.size()<=5)
							{
								barheight=290;
							}
							else if(barDowntimeDataSet.size()==6)
							{
								barheight+=barDowntimeDataSet.size()*27;
							}
							else if(barDowntimeDataSet.size()>6)
							{
								barheight+=barDowntimeDataSet.size()*25;
							}*/
							int tempheight = (barUptimeDataSet.size() * 27)+100;
							if (tempheight > 330)
								barheight = tempheight;

							int barchwidth=600;

							chartObj.put("xAxisLabel",xAxisDataLabel);
							chartObj.put("yAxisLabel",yAxisLabel);
							if(yAxisLabel!=null && yAxisLabel.indexOf("%")>-1)
							{
								chartObj.put("ymax", 100);
								chartObj.put("percentEnableTick",true);
							}
							JSONArray dataSet = new JSONArray();

							JSONObject s1=new JSONObject();
							s1.put("name","Uptime");
							s1.put("color", "#"+(downtimeValues == null ? rebootColor : uptimeColor));
							s1.put("showInLegend", new Boolean(true));
							s1.put("data",barUptimeDataSet);
							
							 dataSet.add(s1);
							
							 //
							 JSONObject s2=new JSONObject();
							s2.put("name","Downtime");
							s2.put("color","#"+downtimeColor);
							s2.put("showInLegend",new Boolean(true));
							s2.put("data",barDowntimeDataSet);
							
							 dataSet.add(s2);
							 //

							chartObj.put("DataSet",dataSet);
							chartObj.put("title","");
							chartObj.put("chartType","bar");
							chartObj.put("chartHeight",new Integer(barheight));
							chartObj.put("chartWidth",new Integer(barchwidth));
							chartObj.put("LegendPosition","top");
							chartObj.put("legend",new Boolean(true));
							chartObj.put("inside",new Boolean(true));
							chartObj.put("chartSubType","stacked");
							chartObj.put("drildown","newtab");
							chartObj.put("isVsxUptime",new Boolean(true));
							chartObj.put("isUptimeAnalyticsReport","true");

							//Pie Chart
							JSONObject overviewPieChat     = new JSONObject();
                            				JSONArray xAxisDataLabelPie    = new JSONArray();
							
							JSONArray dataPie              = new JSONArray();
							JSONObject allDataPie          = new JSONObject();
							JSONArray data1Pie              = new JSONArray();
							JSONObject objPie              = null;

							double totalTime = 0;
							String totalTime_temp = resultDataMap.get("TOTAL_TIME")+"";
							if(totalTime_temp!=null && totalTime_temp.length()>0)
								totalTime = Double.parseDouble(totalTime_temp);
							double avgDownPercentage = 0;
							if(totalDownPercentage!=0 && downtimeServerCount!=0 )
							{
									  //avgDownPercentage= totalDownPercentage/downtimeServerCount;
									  avgDownPercentage= totalDownPercentage/totalNoOfServers;
									  avgDownPercentage= (avgDownPercentage/totalTime)*100;
							}
							double uptimePercentage = 100-avgDownPercentage;
							JSONObject obj = new JSONObject();
							if(uptimePercentage!=0)
							{
								String UpPercentageStr =erUtils.round(uptimePercentage, 2);
								xAxisDataLabelPie.add(""+UpPercentageStr);
								obj = new JSONObject();
								obj.put("name","Uptime");
								obj.put("y",Double.valueOf(UpPercentageStr));
								obj.put("visible","true");
											obj.put("color","#"+uptimeColor);
								dataPie.add(obj);
							}
							if(avgDownPercentage!=0)
							{
								String downPercentageStr =erUtils.round(avgDownPercentage, 2);
								xAxisDataLabelPie.add(""+downPercentageStr);
								obj = new JSONObject();
								obj.put("name","Downtime");
								obj.put("y",Double.valueOf(downPercentageStr));
								//obj.put("visible","true");
										obj.put("color","#"+downtimeColor);
								dataPie.add(obj);
							}
							allDataPie.put("data",dataPie);
							data1Pie.add(allDataPie);
							overviewPieChat.put("xAxisLabel",xAxisDataLabelPie);
							overviewPieChat.put("yAxisLabel","(%)");
							overviewPieChat.put("DataSet",data1Pie);
							overviewPieChat.put("formatForLegendOnlyPercentage",true);

							overviewPieChat.put("title","");
							overviewPieChat.put("chartType","pie");
							overviewPieChat.put("chartHeight", 300);
							overviewPieChat.put("chartWidth",600);
							overviewPieChat.put("legend", true);//To show legend in pie chart
							overviewPieChat.put("ymax", 100);
							overviewPieChat.put("percentEnableTick",true);
							overviewPieChat.put("uptime", "uptimechart");
							overviewPieChat.put("LegendPosition", "top");
                              
							rootJson.put("overviewPieChat",overviewPieChat);
		
						}
						else 
						{
					
						}
							
						queryString = ErUtils.prepareQueryString(request.getParameterMap());
						String qString  = "";
						if(queryString!=null)
						{
							StringTokenizer strtok = new StringTokenizer(queryString,"&");
							while(strtok.hasMoreTokens())
							{
								String parameter = strtok.nextToken();
								int ind = parameter.indexOf("=");
								if (ind < 0)
									continue;
								String reqparam =parameter.substring(0,ind);
								String value = parameter.substring(ind+1);
								
								if(reqparam!=null&&reqparam.equals("startdate"))
								{
									value=com.eg.EgURLEncoder.encode(value, "UTF-8");
								}
								if(reqparam!=null&&reqparam.equals("enddate"))
								{
									value=com.eg.EgURLEncoder.encode(value, "UTF-8");
								}
								if(reqparam!=null&&reqparam.equals("inidate"))
								{
									value=com.eg.EgURLEncoder.encode(value, "UTF-8");
								}
								if(reqparam!=null&&reqparam.equals("er_uptimetest"))
								{
									value=com.eg.EgURLEncoder.encode(value, "UTF-8");
								}
								if(reqparam!=null&&reqparam.equals("er_priority"))
								{
									value=com.eg.EgURLEncoder.encode(value, "UTF-8");
								}
								
								/*if(reqparam!=null&&reqparam.equals("er_component"))
								{
									value=com.eg.EgURLEncoder.encode(value, "UTF-8");
								}
								if(reqparam!=null&&reqparam.equals("er_uptimetest"))
								{
									value=com.eg.EgURLEncoder.encode(value, "UTF-8");
								}
								if(reqparam!=null&&reqparam.equals("er_combination"))
								{
									value=com.eg.EgURLEncoder.encode(value, "UTF-8");
								}
								if(reqparam!=null&&reqparam.equals("er_site"))
								{
									value=com.eg.EgURLEncoder.encode(value, "UTF-8");
								}
								if(reqparam!=null&&reqparam.equals("startdate"))
								{
									value=com.eg.EgURLEncoder.encode(value, "UTF-8");
								}
								if(reqparam!=null&&reqparam.equals("enddate"))
								{
									value=com.eg.EgURLEncoder.encode(value, "UTF-8");
								}
								if(reqparam!=null&&reqparam.equals("inidate"))
								{
									value=com.eg.EgURLEncoder.encode(value, "UTF-8");
								}
								if(reqparam!=null&&reqparam.equals("pdfTime"))
								{
									value=com.eg.EgURLEncoder.encode(value, "UTF-8");
								}
								if(reqparam!=null&&reqparam.equals("er_priority"))
								{
									value=com.eg.EgURLEncoder.encode(value, "UTF-8");
								}*/
								qString += reqparam+"="+value+"&";
							}
						}
						queryString="/final/servlet/com.eg.ErUptimeServletC?"+qString.substring(0,qString.length())+"&er_view=imageprint&er_width=450&er_height=225";
						session.setAttribute("querygraph",queryString);
						rootJson.put("reportData",chartObj);
						rootJson.put("overviewData",overviewData);
					}
%>
<%
					boolean canShowDetails = false;
					if((er_type == null || er_type.equals("No")) && showDetails != null && showDetails.equalsIgnoreCase("Yes"))
					{
						for(int i=0; i<uptimeList.size(); i++)
						{
							ErUptimeDowntimeBean uptimeBean = (ErUptimeDowntimeBean) uptimeList.get(i);
							if(uptimeBean.getNoOfReboots() > 0) 
							{
								canShowDetails = true;
								break;
							}
						}
					}

					if(canShowDetails) 
					{
						JSONObject detailedData =  new JSONObject();
						JSONArray columnDetails  =  new JSONArray();
						JSONArray dataArray  =  new JSONArray();
						List uptimeData = (List)resultDataMap.get("UPTIME_DATA");
						SimpleDateFormat sdf = new SimpleDateFormat(currentDateFormat+" HH:mm:ss");
						String s_title = intlmap.getTextDescription("reporter.uptime.Reboot Details for") +" "+ er_uptimetest;
						v_measure.add(er_uptimetest);
						v_measure.add(intlmap.getTextDescription("reporter.Shutdown At"));
						v_measure.add(intlmap.getTextDescription("reporter.uptime.Rebooted At"));
						v_measure.add(intlmap.getTextDescription("reporter.uptime.Downtime")+ " (" + intlmap.getTextDescription("reporter.uptime.mins") + ")");
						v_measure.add(intlmap.getTextDescription("reporter.uptime.UptimeBeforeReboot")+" (" + intlmap.getTextDescription("reporter.uptime.yMdhm") + ")");
						columnDetails.add(er_uptimetest);
						columnDetails.add(intlmap.getTextDescription("reporter.Shutdown At"));
						columnDetails.add(intlmap.getTextDescription("reporter.uptime.Rebooted At"));
						columnDetails.add(intlmap.getTextDescription("reporter.uptime.Downtime")+ " (" + intlmap.getTextDescription("reporter.uptime.mins") + ")");
						columnDetails.add(intlmap.getTextDescription("reporter.uptime.UptimeBeforeReboot")+" (" + intlmap.getTextDescription("reporter.uptime.yMdhm") + ")");
						
						detailedData.put("title",s_title);
%>
<%
						for(int i=0; i<uptimeList.size(); i++)
						{
							ErUptimeDowntimeBean uptimeBean = (ErUptimeDowntimeBean) uptimeList.get(i);
							if(uptimeBean.getNoOfReboots() > 0) 
							{
								boolean compFound = false;
								ErUptimeData data = null;
								for(int j=0; j<uptimeData.size(); j++) {
									data = (ErUptimeData)uptimeData.get(j);
									if(data.getTrgtHost().equals(uptimeBean.getComponent())) {
										compFound = true;
										break;
									}
								}
								List detailBeanList = new ArrayList();
								if(compFound) {
									List rebootList = data.getFilteredReboot();
									List shutdownList = data.getFilteredShutdown();
									List durationList = data.getFilteredDuration();
									List lastUpTimesList = data.getLastUpTimesList();

									for(int j=0; j<shutdownList.size(); j++) {
										ErRebootDetailBean detailBean = new ErRebootDetailBean();
										detailBean.setShutdown((Calendar)shutdownList.get(j));
										detailBean.setReboot((Calendar)rebootList.get(j));
										detailBean.setDuration((String)durationList.get(j));
										detailBean.setLastUpTime(
											getDisplayString((String)lastUpTimesList.get(j),"0"));
										detailBeanList.add(detailBean);
									}
									Collections.sort(detailBeanList);
								}
								if(detailBeanList.size() > 0) 
								{
%>

<%
									list_data.add(uptimeBean.getComponent());
									for(int j=0; j<detailBeanList.size(); j++) 
									{
										JSONArray rowofData =  new JSONArray();
										ErRebootDetailBean bean = (ErRebootDetailBean)detailBeanList.get(j);
										String shutTime = sdf.format(bean.getShutdown().getTime());
										String rebootTime = sdf.format(bean.getReboot().getTime());
										String usr_shutTime="";
										String usr_rebootTime="";
										if(shutTime!=null)
										{
											converterStart = new EgTimeZoneConverter(shutTime,thisuser);
											usr_shutTime = converterStart.getDateTime();
										}
										if(rebootTime!=null)
										{
											converterEnd = new EgTimeZoneConverter(rebootTime,thisuser);
											usr_rebootTime = converterEnd.getDateTime();
										}
										if(j > 0)
											list_data.add("");
										list_data.add(usr_shutTime);
										list_data.add(usr_rebootTime);										list_data.add(bean.getDuration());
										list_data.add(bean.getLastUpTime());

										rowofData.add(uptimeBean.getComponent());
										rowofData.add(usr_shutTime);
										rowofData.add(usr_rebootTime);
										rowofData.add(bean.getDuration());
										rowofData.add(bean.getLastUpTime());

%>
<%
									dataArray.add(rowofData);
									}
								}
							} // reboot > 0 if loop
						} // uptimelist for loop
%>
<%
					h_tabrc.put(v_measure,list_data);
					h_tab.put(s_title,h_tabrc);
					list.add(h_tab);
					list_data.add("\n");
					v_measure = new Vector();
					list_data = new LinkedList();
					s_title = new String();
					h_tabrc = new Hashtable();
					h_tab = new Hashtable();
%>

<%
						detailedData.put("columnDetails",columnDetails);
						detailedData.put("dataArray",dataArray);
						rootJson.put("rebootTable",detailedData);
					} // show details if loop
				} // uptimelist not empty loop
				else
				{
%>
			
		<%
			if(er_type == null || er_type.equalsIgnoreCase("Yes")) {
		%>
		<%
			} else  {
		%>
		<%
			}
		%>
<%
				}
				if(list!= null && !list.isEmpty())
				{
					session.setAttribute("listData",list);
				}
			}
%>
<%
HashMap resultMap = (HashMap)request.getAttribute("ResultDataMap");
if(resultMap !=null)
{
	JSONObject barurl =  new JSONObject();
	HashMap barChartParam = (HashMap) resultMap.get("SERVERS_BARCHART");
	if(barChartParam != null && barChartParam.get("sampleValues_0") !=null)
	{
		String uptimeValuesurl = (String)barChartParam.get("sampleValues_0");
		StringTokenizer sturlUptime = new StringTokenizer(uptimeValuesurl, ",");
		int i=0;
		while (sturlUptime.hasMoreTokens() )
		{
			String strUptimeValue = sturlUptime.nextToken();
			if(strUptimeValue.equalsIgnoreCase("0"))
			{
				strUptimeValue = "";
			}
			String urlhidden = "url_0_"+i++;
			String hiddenurlval = barChartParam.get(urlhidden).toString();
				barurl.put(urlhidden,hiddenurlval);
			%>
			<%
		}
	}
	if(barChartParam != null && barChartParam.get("sampleValues_1") !=null)
	{
		String downtimeValuesurl = (String)barChartParam.get("sampleValues_1");
		StringTokenizer sturlDowntime = new StringTokenizer(downtimeValuesurl, ",");
		int j=0;
		while (sturlDowntime.hasMoreTokens() )
		{
			String strDownTimeValue = sturlDowntime.nextToken();
			if(strDownTimeValue.equalsIgnoreCase("0"))
			{
				strDownTimeValue = "";
			}
			String urlhidden = "url_1_"+j++;
			String hiddenurlval = barChartParam.get(urlhidden).toString();
			barurl.put(urlhidden,hiddenurlval);
			%>
			<%
		}
	}
	rootJson.put("charUrlMap",barurl);
}
%>

<%

	String dataProcess = mngrIProc+"/final/reporter/ErUptimePrintData.jsp;jsessionid="+ session.getId()+"?er_comptype="+request.getParameter("er_comptype")+"&er_datafrom="+datafrom+"&er_type="+er_type+"&er_site="+s_site+"&er_uptimetest="+com.eg.EgURLEncoder.encode(er_uptimetest,"UTF-8")+"&er_show_details="+showDetails+"&startdate="+s_st_time+"&enddate="+s_en_time+"&timefrom="+timefrom2+"&minfrom="+minfrom2+"&timeto="+timeto2+"&minto="+minto2+"&starthr="+s_st_hr+"&endhr="+s_en_hr+"&er_timeline="+com.eg.EgURLEncoder.encode(er_timeline,"UTF-8")+"&startmin="+startMin+"&endmin="+endMin+"&inidate="+s_inidate+"&pgTittle=VIRTUALIZATION&";
	session.setAttribute("MAIL_URL",dataProcess);
	session.setAttribute("PDF_URL", mngrIProc+"/final/reporter/ErUptimePrintData.jsp");

	queryString=(String)ErUtils.prepareQueryString(request.getParameterMap());
	String qString="";
	if(queryString!=null)
	{
		StringTokenizer strtok = new StringTokenizer(queryString,"&");
		while(strtok.hasMoreTokens())
		{
			String parameter = strtok.nextToken();
			int ind = parameter.indexOf("=");
			//if (ind < 0 || parameter.indexOf("responseType")>-1)
			if (ind < 0)
				continue;
			String reqparam =parameter.substring(0,ind);
			String value = parameter.substring(ind+1);
			if(reqparam!=null&&reqparam.equals("er_show"))
			{
				value=com.eg.EgURLEncoder.encode(value,"UTF-8");
			}
			if(reqparam!=null&&reqparam.equals("er_component"))
			{
				value=com.eg.EgURLEncoder.encode(value, "UTF-8");
			}
			if(reqparam!=null&&reqparam.equals("er_combination"))
			{
				value=com.eg.EgURLEncoder.encode(value, "UTF-8");
			}
			if(reqparam!=null&&reqparam.equals("er_site"))
			{
				value=com.eg.EgURLEncoder.encode(value, "UTF-8");
			}
			if(reqparam!=null&&reqparam.equals("startdate"))
			{
				value=com.eg.EgURLEncoder.encode(value, "UTF-8");
			}
			if(reqparam!=null&&reqparam.equals("enddate"))
			{
				value=com.eg.EgURLEncoder.encode(value, "UTF-8");
			}
			if(reqparam!=null&&reqparam.equals("inidate"))
			{
				value=com.eg.EgURLEncoder.encode(value, "UTF-8");
			}
			if(reqparam!=null&&reqparam.equals("pdfTime"))
			{
				value=com.eg.EgURLEncoder.encode(value, "UTF-8");
			}
			if(reqparam!=null&&reqparam.equals("er_uptimetest"))
			{
				value=com.eg.EgURLEncoder.encode(value, "UTF-8");
			}
			qString += reqparam+"="+value+"&";
		}
		if(!qString.contains("er_RmDispName"))
				qString=qString+"er_RmDispName=Uptime&";		
		if(request.getParameter("isSubmit")!=null)
		{
			session.setAttribute("reportLastAccessedURL","/final/reporter/ErEsxUptimeReportData.jsp?isSubmit=true&" + qString);
		}
		else 
		{
			session.setAttribute("reportLastAccessedURL","/final/reporter/ErEsxUptimeReportData.jsp?" + qString);
		}
		rootJson.put("saveQString",qString);
	}
	
	

	//For Setting the PDf File Name
	String report_Type = request.getParameter("er_type");

	HashMap paramVal =new HashMap();
	if(report_Type!=null && report_Type.equalsIgnoreCase("Yes"))
		paramVal.put("fileName","VirtualisationUptimeReport_Graph");
	else if(report_Type!=null && report_Type.equalsIgnoreCase("No"))
		paramVal.put("fileName","VirtualisationUptimeReport_Data");
	session.setAttribute("parameters", paramVal);
%>
<%
	//Back Button - Start
	ArrayList listbackvar = new  ArrayList();

	if(request.getParameter("isSubmit")!=null)
	{
		listbackvar.add("/servlet/com.eg.ErUptimeServletC?");
		listbackvar.add("status="+status+"&bggroundStr="+bggroundStr+"&"+queryString);
		session.setAttribute("favSchBackDisplay","Yes");
	}
	else 
	{
		listbackvar.add("ErEsxUptimeReportData.jsp");
		listbackvar.add(queryString);
		session.setAttribute("favSchBackDisplay","No");
	}

	String backadded = erhelputils.getBackID();
	backreqMap = erhelputils.setBackQueryMap(backreqMap,backadded,listbackvar);
	session.setAttribute("backQuery",backreqMap);

	rootJson.put("hiddenfields",hiddenfieldsJson);
	rootJson.put("screenLabels",screenLabelJson);
	out.println(rootJson.toString());
	
	//Back Button - End
%>
