<%
/*
	Author			:	James Thomas
	Creation Date	:	06th September 2006
	Purpose			:	Grouping and Displaying components with their states and types.
						We can display components with states according to their total count in descending order and server types in ascending order	
	Design Changes	:	Jaiwin

	New Sort		:	Now sortting done by JSP not in script , By Satheesh.S on 10-5-2012.

*/	
%>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %> 
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ include file="EgLoginTracker.jsp" %>
<%@ page errorPage="EgErrorSmall.jsp" %>
<%@ page import="com.egurkha.*"	%>
<%@ page import="com.egurkha.ini.*"	%>
<%@ page import="com.eg.EgURLEncoder"%>
<%@ page import="com.egurkha.monitor.Dashboard"	%>
<%@ page import="java.util.*" %>
<%@ page import="com.eg.EgMappingInfo"%>
<%@ page import="com.egurkha.monitor.ZoneDashboardData"%>
<%@ page import="com.egurkha.monitor.ZoneDashboardResult"%>
<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader ("Expires", -1);

	ZoneDashboardData d = (ZoneDashboardData) session.getAttribute("zoneDashboardData");
	ZoneDashboardResult r = (ZoneDashboardResult) session.getAttribute("zoneDashboardResult");
	int max_rows = IniUI.getInstance().getPermittedRowsForSorting();
	IniUI ui = (IniUI)IniUI.getInstance();
%>
<html>
<head>
<egui:skin ui="monitor"/>
<script language="JavaScript">
function sortTable(col)
{
	var previousOrder = document.getElementById('sortTypeId').value;
	var urlParam="";
	var loadPageUrl="/final/monitor/zoneServerTypes.jsp?";

	if(col==0)
	{
		if(previousOrder==null || previousOrder=="" || previousOrder=="undefined")
		{
			urlParam=loadPageUrl+"colindex=ctype&order=desc&imgsrc=arrow_down_black_small&compDisp=block&countImg=&countDisp=none";
		}
		else if(previousOrder!=null && previousOrder!=undefined && previousOrder=="desc")
		{
			urlParam=loadPageUrl+"colindex=ctype&order=desc&imgsrc=arrow_up_black_small&compDisp=block&countImg=&countDisp=none";
		}
		else 
		{
			urlParam=loadPageUrl+"colindex=ctype&order=asc&imgsrc=arrow_down_black_small&compDisp=block&countImg=&countDisp=none";
		}
		parent.document.getElementById('zst').src=urlParam;
	}
	else
	{
		if(previousOrder=="" || previousOrder=="undefined" || previousOrder==null)
		{
		 	urlParam=loadPageUrl+"colindex=ccount&order=asc&compDisp=none&countImg=arrow_up_black_small&countDisp=block";
		}
		else if(previousOrder!=null && previousOrder!=undefined && previousOrder=="desc")
		{
			urlParam=loadPageUrl+"colindex=ccount&order=desc&imgsrc=&compDisp=none&countImg=arrow_down_black_small&countDisp=block";
		}
		else 
		{
			urlParam=loadPageUrl+"colindex=ccount&order=asc&imgsrc=&compDisp=none&countImg=arrow_up_black_small&countDisp=block";
		}
		parent.document.getElementById('zst').src=urlParam;
	}
}
</script>
</head>
<body topmargin="0" marginheight="0" leftmargin="0" marginwidth="0"  style="overflow:auto" scroll="auto">
<div id="large1">
<center>
		<table width="100%"   cellpadding="0" cellspacing="0" border="0" align="center" valign="top">
<%
	ArrayList keyList=null;
	Hashtable serversWithTypesAndStates=null;
	String	colIndex=request.getParameter("colindex");
	String	sortingOrder=request.getParameter("order");
	String	compImg=request.getParameter("imgsrc");
	String	compDisp=request.getParameter("compDisp");
	String	countImg=request.getParameter("countImg");
	String	countDisp=request.getParameter("countDisp");
	serversWithTypesAndStates = (Hashtable) r.serversWithTypesAndStates;
	String orderByServerCount = ui.getValue("SERVER_DISP_DETAILS", "SORTPERCOUNT");
	if(compImg==null && compDisp==null && countImg==null && countDisp==null )
	{
		if(orderByServerCount !=null && orderByServerCount.equalsIgnoreCase("true"))
		{
			compImg="arrow_up_black_small";
			compDisp="none";
			countImg="arrow_down_black_small";
			countDisp="block";
		}
		else
		{
			compImg="arrow_down_black_small";
			compDisp="block";
			countImg="arrow_down_black_small";
			countDisp="none";
		}
	}

	if(countDisp!=null && countDisp.equalsIgnoreCase("block"))
	{
		countDisp="";
	}
	else if(countDisp!=null && !countDisp.equalsIgnoreCase("block"))
	{
		countDisp="display:none;";
	}

	if(compDisp!=null && compDisp.equalsIgnoreCase("block"))
	{
		compDisp="";
	}
	else if(compDisp!=null && !compDisp.equalsIgnoreCase("block"))
	{
		compDisp="display:none;";
	}
	if (serversWithTypesAndStates == null || serversWithTypesAndStates.size() == 0)
	{
%>
		<jsp:forward page="empty.jsp" >
			<jsp:param name="reason" value="No components have been enabled for monitoring"/>
		</jsp:forward>
<%
	}
%>
	<tr>
		<td id="table_header" nowrap align="center" width="120" height="25" style="padding:6px;"><a id="link1" style="text-decoration:none;color:#000000;" href="javascript:void(0);" onclick="sortTable(0);"><egui:intnl text="monitor.zonehome.Server Type"/></a>&nbsp;<img id="img0" src="/final/monitor/eg_images/<%=compImg%>.gif" style="<%=compDisp%>cursor:hand;" align="center" valign="absmiddle" onclick="sortTable(0);"></td>
		<td id="table_header" nowrap width="50" style="padding-left:2px;">
		<a id="link2" style="text-decoration:none;color:#000000;" href="javascript:void(0);" onclick="this.blur();sortTable(1);"><egui:intnl text="monitor.zonehome.Count"/></a>&nbsp;<img id="img1" src="/final/monitor/eg_images/<%=countImg%>.gif" style="<%=countDisp%>cursor:hand;"  align="center" valign="absmiddle"  onclick="this.blur();sortTable(1);"></td>
		<td id="table_header" nowrap align="center"><egui:intnl text="monitor.zonehome.Status"/></td>
	</tr>
	<tbody id="rsTable">
<%
	keyList = new ArrayList();
	Hashtable backgroundColor = new Hashtable();
	Enumeration keys = serversWithTypesAndStates.keys();
	String states[]={"GOOD","UNKNOWN","LOW","INTERMEDIATE","HIGH"};
	String sortOrder="desc";
    // sortting done by JSP not in script , By Satheesh.S on 10-5-2012.

	if(colIndex==null || colIndex.trim().length()==0 || colIndex.trim().equals("undefined"))
	{
		if((orderByServerCount!=null && orderByServerCount.toLowerCase().trim().equalsIgnoreCase("true")))
		{
			sortOrder="";
			keyList.addAll(r.sortedKeysByComponentCount);
		}
		else
		{
			keyList.addAll(r.sortedKeysByServerType);
			Collections.reverse(keyList);
		}
	}
	else
	{
		EgMappingInfo _mapping = new EgMappingInfo(d.user.getLanguage());
		ArrayList sortedList = new ArrayList();
		sortedList.addAll(getSortByOrder(_mapping,colIndex,serversWithTypesAndStates));
		
		if(colIndex!=null && colIndex.equalsIgnoreCase("ctype") && sortingOrder!=null && sortingOrder.equalsIgnoreCase("asc"))
		{
			sortOrder="desc";
			keyList.addAll(sortedList);
			Collections.reverse(keyList);
		}
		else if(colIndex!=null && colIndex.equalsIgnoreCase("ctype") && sortingOrder!=null && sortingOrder.equalsIgnoreCase("desc"))
		{
			sortOrder="asc";
			keyList.addAll(sortedList);
		}
		else if(colIndex!=null && colIndex.equalsIgnoreCase("ccount") && sortingOrder!=null && sortingOrder.equalsIgnoreCase("asc"))
		{
			sortOrder="desc";
			keyList.addAll(sortedList);
			Collections.reverse(keyList);
		}
		else if(colIndex!=null && colIndex.equalsIgnoreCase("ccount") && sortingOrder!=null && sortingOrder.equalsIgnoreCase("desc"))
		{
			sortOrder="asc";
			keyList.addAll(sortedList);
		}
	}
	backgroundColor.put("0id", "GOOD_bg");
	backgroundColor.put("1id", "UNKNOWN_bg");
	backgroundColor.put("2id", "LOW_bg");
	backgroundColor.put("3id", "INTERMEDIATE_bg");
	backgroundColor.put("4id", "HIGH_bg");
	backgroundColor.put("0state", "GOOD");
	backgroundColor.put("1state", "UNKNOWN");
	backgroundColor.put("2state", "LOW");
	backgroundColor.put("3state", "INTERMEDIATE");
	backgroundColor.put("4state", "HIGH");
	long maxCount=0L;

	for(int i=0; i<keyList.size(); i++)
	{
		String serverType = keyList.get(i).toString();
		Health health = (Health) serversWithTypesAndStates.get(serverType);
		long size=0L;
		for (int b=0; b<states.length; b++)
		{
			long thisCount = health.getValue(State.getState(states[b]));
			size+=thisCount;
		}
		maxCount = Math.max(maxCount, size);
	}

	for(int i=0; i<keyList.size(); i++)
	{
		String serverType = keyList.get(i).toString();
		Health health = (Health) serversWithTypesAndStates.get(serverType);
		if(!serverType.startsWith("Agg_"))
		{
%>
			<tr>
			<td nowrap align="left" height="25" width="120"  id="cell_border1"  valign="middle" style="padding-left:4px;" >
				<a href="../servlet/com.eg.EgMonitorController?monCmd=componentList&from=ZoneDashboard&action=componentType&searchIndComps=true&test=print&zoneName=<%=EgURLEncoder.encode(d.zoneName,"UTF-8")%>&componentType=<%=EgURLEncoder.encode(serverType,"UTF-8")%>" target="_parent" class="eg_monlink" >
				<egui:intnl type='<%=serverType%>'/></a>
			</td>
			<td nowrap align="center" height="25" width="50"  id="cell_border2" valign="middle" class="eg_8">
				
				<%=health.getTotal()%>
				</td>
			<td nowrap id="cell_border1" width="100%" height="25" valign="middle" align="left" style="padding-right:0px;padding-left:0px;border-right-width:0px" >
			<%
				long size = 0L;
				for (int b=0; b<states.length; b++)
				{
					long thisCount = health.getValue(State.getState(states[b]));
					size+=thisCount;
				}
				maxCount = Math.max(maxCount, size);
				int tableWidth = (int)(health.getTotal()*100)/(int)maxCount;
				tableWidth = tableWidth<1?1:tableWidth;
			%>
				<table width="<%=tableWidth%>%" height="15" border="0" cellspacing="0" cellpadding="0" valign="middle">
				
			</td>
			<%
				
				for(int j=0;j<states.length;j++)	
				{			
					size = health.getValue(State.getState(states[j]));
					if(size==0)
						continue;
					long tdWidth = (long) size*100/(long)health.getTotal();
			%>
				<a href="../servlet/com.eg.EgMonitorController?monCmd=componentList&from=ZoneDashboard&action=componentTypeState&test=print&searchIndComps=true&zoneName=<%=EgURLEncoder.encode(d.zoneName,"UTF-8")%>&componentType=<%=EgURLEncoder.encode(serverType,"UTF-8")%>&stateName=<%=backgroundColor.get(j+"state")%>" target="_parent">
				<span>
					<td nowrap align="center" valign="middle" width="<%=tdWidth%>%" id="<%=backgroundColor.get(j+"id")%>" class="mouse" onClick="loadURL('../servlet/com.eg.EgMonitorController?monCmd=componentList&from=ZoneDashboard&action=componentTypeState&test=print&zoneName=<%=EgURLEncoder.encode(d.zoneName,"UTF-8")%>&searchIndComps=true&componentType=<%=EgURLEncoder.encode(serverType,"UTF-8")%>&stateName=<%=backgroundColor.get(j+"state")%>' )">
						<font face="Arial,Verdana" style="font-family:Verdana,Arial; font-size: 8pt; font-weight:normal; letter-spacing:1px;">&nbsp;<%=size%>&nbsp;</font>
					</td>
				</span>
				</a>
				<%
				}
				%>
				</tr>
				</table>
			</tr>
		<%
		}
		else
		{
			%>
			<tr>
			<td nowrap align="left" height="25" width="120"  id="cell_border1"  valign="middle" style="padding-left:4px;" >
				<a href="../servlet/com.eg.EgMonitorController?monCmd=componentList&from=ZoneDashboard&action=componentType&searchIndComps=true&test=print&zoneName=<%=EgURLEncoder.encode(d.zoneName,"UTF-8")%>&componentType=<%=EgURLEncoder.encode(serverType,"UTF-8")%>&who=james&menuName=agg" target="_parent" class="eg_monlink" >
				<egui:intnl type='<%=serverType%>'/></a>
			</td>
			<td nowrap align="center" height="25" width="50"  id="cell_border2" valign="middle" class="eg_8">
				
				<%=health.getTotal()%>
				</td>
			<td nowrap id="cell_border1" width="100%" height="25" valign="middle" align="left" style="padding-right:0px;padding-left:0px;border-right-width:0px" >
			<%
				long size = 0L;
				for (int b=0; b<states.length; b++)
				{
					long thisCount = health.getValue(State.getState(states[b]));
					size+=thisCount;
				}
				maxCount = Math.max(maxCount, size);
				int tableWidth = (int)(health.getTotal()*100)/(int)maxCount;
				tableWidth = tableWidth<1?1:tableWidth;
			%>
				<table width="<%=tableWidth%>%" height="15" border="0" cellspacing="0" cellpadding="0" valign="middle">
				
			</td>
			<%
				
				for(int j=0;j<states.length;j++)	
				{			
					size = health.getValue(State.getState(states[j]));
					if(size==0)
						continue;
					long tdWidth = (long) size*100/(long)health.getTotal();
			%>
				<a href="../servlet/com.eg.EgMonitorController?monCmd=componentList&from=ZoneDashboard&action=componentTypeState&test=print&searchIndComps=true&zoneName=<%=EgURLEncoder.encode(d.zoneName,"UTF-8")%>&componentType=<%=EgURLEncoder.encode(serverType,"UTF-8")%>&stateName=<%=backgroundColor.get(j+"state")%>&who=james&menuName=agg" target="_parent">
				<span>
					<td nowrap align="center" valign="middle" width="<%=tdWidth%>%" id="<%=backgroundColor.get(j+"id")%>" class="mouse" onClick="loadURL('../servlet/com.eg.EgMonitorController?monCmd=componentList&from=ZoneDashboard&action=componentTypeState&test=print&zoneName=<%=EgURLEncoder.encode(d.zoneName,"UTF-8")%>&searchIndComps=true&componentType=<%=EgURLEncoder.encode(serverType,"UTF-8")%>&stateName=<%=backgroundColor.get(j+"state")%>&who=james&menuName=agg' )">
						<font face="Arial,Verdana" style="font-family:Verdana,Arial; font-size: 8pt; font-weight:normal; letter-spacing:1px;">&nbsp;<%=size%>&nbsp;</font>
					</td>
				</span>
				</a>
				<%
				}
				%>
				</tr>
				</table>
			</tr>
			<%
		}
	}
		%>
		</tbody>
	</table>	
</center>
</div>
<input type="hidden" name="sorttype" id="sortTypeId" value="<%=sortOrder%>">
</body>
<script language="javascript">
function loadURL(myURL)
{
	if(window.parent!=null)
	{
		window.parent.location.href=myURL;
	}
}
</script>
</html>
<%!
	
	// sortting done by JSP not in script , By Satheesh.S on 10-5-2012.

	public ArrayList getSortByOrder(EgMappingInfo _mapping,String colType, Hashtable serverTypesandStates)
	{
		ArrayList sortedResult = new ArrayList();
		if(colType!=null && colType.toLowerCase().trim().equalsIgnoreCase("ccount"))
		{
			ArrayList arrayList = new ArrayList();
			Hashtable supportTable = new Hashtable();
			Hashtable tempServersWithTypesAndStates = new Hashtable();
			Enumeration keys1 = serverTypesandStates.keys();
			while(keys1.hasMoreElements())
			{
				Object serverType = keys1.nextElement();
				Health health = (Health) serverTypesandStates.get(serverType);
				tempServersWithTypesAndStates.put(serverType,new Long(health.getTotal()));
				String supportServerType = _mapping.getComponentTypeDescription(serverType.toString());
				supportTable.put(supportServerType,serverType);
			}
			Enumeration tempElementsFirst = tempServersWithTypesAndStates.elements();
			ArrayList tempList = new ArrayList();
			while(tempElementsFirst.hasMoreElements())
			{
				tempList.add(tempElementsFirst.nextElement());
			}
			Object objects[]=tempList.toArray();
			Arrays.sort(objects);
			ArrayList tempKeyList = new ArrayList();

			for(int i=0;i<objects.length;i++)
			{
				Object currentObject=objects[i];
				while(true)
				{
					if(!tempServersWithTypesAndStates.contains(currentObject))
						break;
					int size = tempServersWithTypesAndStates.size();

					for(int j=size;j>=0;j--)
					{
						Enumeration tempElementsSecond = tempServersWithTypesAndStates.keys();

						while(tempElementsSecond.hasMoreElements())
						{
							Object key = tempElementsSecond.nextElement();
							if(tempServersWithTypesAndStates.get(key).equals(currentObject))
							{
								tempKeyList.add(key);
								arrayList.add(_mapping.getComponentTypeDescription(key.toString()));
								tempServersWithTypesAndStates.remove(key);
							}
						}
					}
					if(tempKeyList.size()>0)
					{
						tempKeyList.clear();
						Collections.sort(arrayList,String.CASE_INSENSITIVE_ORDER);
						for(int k=0;k<arrayList.size();k++)
						tempKeyList.add(supportTable.get(arrayList.get(k)));
						Collections.reverse(tempKeyList);
						sortedResult.addAll(tempKeyList);
					}
					tempKeyList.clear();
					arrayList.clear();
				}
			}
			Collections.reverse(sortedResult);
		}
		else
		{
			ArrayList arrayList = new ArrayList();
			Hashtable supportTable = new Hashtable();
			Enumeration serverTypekeys = serverTypesandStates.keys();
			while(serverTypekeys.hasMoreElements())
			{
				String serverType = (String)serverTypekeys.nextElement();
				String supportServerType = _mapping.getComponentTypeDescription(serverType);
				supportTable.put(supportServerType,serverType);
				arrayList.add(supportServerType);
			}
			Collections.sort(arrayList,String.CASE_INSENSITIVE_ORDER);
			for(int i=0;i<arrayList.size();i++)
			{
				Object supportServerType = arrayList.get(i);
				sortedResult.add(supportTable.get(supportServerType));
			}
		}
		return sortedResult;
	}
%>