<%@ include file = "EgMonitorTracker.jsp" %>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %> 
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ page import="java.util.*"%>
<%@ page import="com.egurkha.*"%>
<%@ page import = "com.eg.EgURLEncoder"%>
<%@ page import="com.egurkha.ini.*" %>
<%@ page import="com.egurkha.util.*" %>
<%@ page import="com.egurkha.monitor.ZoneDashboardData"%>
<%@ page import="com.egurkha.monitor.ZoneDashboardResult"%>
<%@ page import="net.sf.json.*"%>
<%@ page import = "com.eg.EgMappingInfo"%>
<%@ page import="com.fasterxml.jackson.databind.ObjectMapper"%>
<%@ page import="com.fasterxml.jackson.databind.node.ArrayNode"%>
<%@ page import="com.fasterxml.jackson.databind.node.ObjectNode"%>
<%@ page import="com.fasterxml.jackson.databind.JsonNode"%>
<%@ page import = "com.eg.EgAggregateInfo"%>
<%@ page import = "java.io.*"%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json");

	ZoneDashboardData d = (ZoneDashboardData) session.getAttribute("zoneDashboardData");
	ZoneDashboardResult r = (ZoneDashboardResult) session.getAttribute("zoneDashboardResult");
	
	IniUI ui = (IniUI)IniUI.getInstance();
	UserRegistry registry = UserRegistry.getInstance();
	User user = registry.getUser(session.getId());
	
	String thisLanguage = ui.getDefaultLanguage();
	if (user!=null)
	{
		String userLang = user.getLanguage();
		if (userLang!=null && !userLang.equalsIgnoreCase("NULL"))
		{
			thisLanguage=userLang;
		}
	}
	EgAggregateInfo aggregateInfo = new EgAggregateInfo("manager");
	//EgMappingInfo mappingInfo = new EgMappingInfo(thisLanguage);
	ObjectMapper mapper = new ObjectMapper();
	ObjectNode json  = mapper.createObjectNode();
	ArrayNode  summaryArray = mapper.createArrayNode();

	//request.setAttribute("jsonObject",json);
	//request.setAttribute("category","zone");
	//request.setAttribute("itemName",d.zoneName);

	ArrayList aggregateArrayZone = aggregateInfo.getAggregateComponentsOfElement("zone",d.zoneName);
	if(aggregateArrayZone != null && aggregateArrayZone.size() > 0)
	{
		json.put("aggregateTab","true");
	}
	else
	{
		json.put("aggregateTab","false");
	}

	%>
		<%//@ include file="aggregateTabHandler.jsp" %>
	<%
	
	ObjectNode  summaryObj = mapper.createObjectNode();
	summaryObj.put("text",mappingInfo.getTextDescription("monitor.zonehome.Total Measurements"));
	summaryObj.put("value",String.valueOf(r.measureCount));
	summaryObj.put("iconCss","summaryTotalMeasurements");
	summaryArray.add(summaryObj);
	
	summaryObj = mapper.createObjectNode();
	summaryObj.put("text",mappingInfo.getTextDescription("monitor.zonehome.Monitored Entities"));
	summaryObj.put("value",String.valueOf(r.totalComponents));
	summaryObj.put("iconCss","summaryTotalComponents");
	
	String zoneNameCheck = r.zoneName;
	if(zoneNameCheck != null && zoneNameCheck.trim().length () >0)
		zoneNameCheck = com.egurkha.util.StringUtils.replaceWithSpecialCharEncode(zoneNameCheck);
	
	String url = "/final/servlet/com.eg.EgMonitorController?monCmd=componentList&from=TreeMenu&action=component&searchIndComps=checked&view=metric&viewId=components&viewPageTitle=Components&viewTreeTitle=Component&filterBy=zone&subFilter="+EgURLEncoder.encode(zoneNameCheck,"UTF-8")+"&fromHomepage="+d.fromHomepage+"&fromPageView=zoneDashboard&fromDashboard="+d.fromDashboard+"&parentZone="+d.parentZone;
	summaryObj.put("AllCompLink",url);
	summaryArray.add(summaryObj);
	
	summaryObj = mapper.createObjectNode();
	summaryObj.put("text",mappingInfo.getTextDescription("monitor.zonehome.Open Problems"));
	summaryObj.put("value",String.valueOf(r.alarmCount));
	summaryObj.put("iconCss","summaryOpenProblems");
	summaryObj.put("alarmsLink","/final/monitor/EgAlarms.jsp?fromPage=zoneDashboard&zoneName="+r.zoneName);
	summaryArray.add(summaryObj);
	
if((r.maximumDuration != null && r.maximumDuration.length() >0) && (r.averageDuration != null && r.averageDuration.length()>0))
{
	summaryObj = mapper.createObjectNode();
	summaryObj.put("text",mappingInfo.getTextDescription("monitor.zonehome.Average Duration"));
	summaryObj.put("value",r.averageDuration);
	summaryObj.put("iconCss","summaryAverageDuration");
	summaryArray.add(summaryObj);
	
	summaryObj = mapper.createObjectNode();
	summaryObj.put("text",mappingInfo.getTextDescription("monitor.zonehome.Maximum Duration"));
	summaryObj.put("value",r.maximumDuration);
	summaryObj.put("iconCss","summaryMaximumDuration");
	String maxAlarmsIDs = r.maxDurationAlarmIDs;
	try
	{
		maxAlarmsIDs = EgURLEncoder.encode(maxAlarmsIDs,"UTF-8");
	}
	catch (UnsupportedEncodingException e) 
	{
		throw new AssertionError("UTF-8 is unknown");
	}
	summaryObj.put("alarmsLink","/final/monitor/EgAlarms.jsp?alarmType=longestAlarms&fromPage=zoneDashboard&zoneName="+r.zoneName+"&maxDurationAlarmIds="+maxAlarmsIDs);
	summaryArray.add(summaryObj);
}
else
{
	summaryObj = mapper.createObjectNode();
	summaryObj.put("text",mappingInfo.getTextDescription("monitor.zonehome.Average Duration"));
	summaryObj.put("value","0");
	summaryObj.put("iconCss","summaryAverageDuration");
	summaryArray.add(summaryObj);
	
	summaryObj = mapper.createObjectNode();
	summaryObj.put("text",mappingInfo.getTextDescription("monitor.zonehome.Maximum Duration"));
	summaryObj.put("value","0");
	summaryObj.put("iconCss","summaryMaximumDuration");
	summaryObj.put("alarmsLink","/final/monitor/EgAlarms.jsp?alarmType=longestAlarms&fromPage=zoneDashboard&maxDurationAlarmIds=&zoneName="+r.zoneName);
	summaryArray.add(summaryObj);
} 

	json.put("summaryArray",summaryArray);
	
	response.getWriter().write(json.toString());
%>