<%
/**********************************************************
*	Name				:	serviceTree.jsp
*	Purpose				:	Tree for serviceDashboard
*	Version				:	eG 4.0
*	Author				:	Ahamed Y and modified by S.Saravanan 
*	Creation Date		:	25 Feb 2008 modified on 29 Nov 2011
**********************************************************/
%>
<%@ include file = "EgMonitorTracker.jsp" %>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld"%>
<%@page import="com.egurkha.monitor.*"%>
<%@page import="java.util.*"%>
<%@page import="java.lang.StringBuffer"%>
<%@ page import = "com.egurkha.ini.IniUI" %>
<%@ page import = "com.eg.EgStateZone"%>
<%@ page import = "com.eg.EgInstallInfo"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ page import="net.sf.json.*"%>

<%
response.setHeader("Cache-Control","no-store");
response.setHeader("Pragma","no-cache");
response.setDateHeader("Expires", -1);
response.setContentType("application/json");
	String stateCalc = request.getParameter("stateCalc");
	if(stateCalc != null && stateCalc.equalsIgnoreCase("yes")){
		JSONObject json = new JSONObject();
		String servicename = request.getParameter("serviceName");
		if(servicename != null && servicename.trim().length() > 0){
			String servicestate = (String)EgStateZone.getState("Service:"+servicename+":NULL");
			if(servicestate==null || servicestate.trim().length()==0)
				servicestate ="GOOD";
			json.put("state",servicestate);
		}else{
			json.put("state","NULL");
		}
		response.getWriter().write(json.toString());
	}else{
		String treeTitle = request.getParameter("treeTitle");
		String str = request.getParameter("str");
		String node = request.getParameter("node");
		String closeSameLevelStr = request.getParameter("closeSameLevel");
		if(treeTitle == null)
			treeTitle = "Tree";
		boolean closeSameLevel = false;
		if("true".equalsIgnoreCase(closeSameLevelStr) ) 
		{
			closeSameLevel = true;
		}
		if(str == null)
			str = "";
		String nodeURLParams = request.getParameter("nodeURLParams");
		if(str.equalsIgnoreCase("sessionID"))
		{
			str = session.getId();
		}
		IniUI ui = (IniUI) IniUI.getInstance();
		String refreshTime = ui.getRefreshTime("EgDashboard");

		Hashtable treeTable = new Hashtable();
		String className = request.getParameter("tree");
		String width = request.getParameter("width");
		ServicesTree treeObj = getTreeInstance(className, node);

		//JSONObject json = treeObj.getTreeJson(str);
		com.eg.IniFile iniFileforComp = new com.eg.IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_dashboardConfig.ini", false);
		String serviceDashboardType = iniFileforComp.getValue("SERVICE_DASHBOARD_TYPE","Citrix_dashboard_view");
		if(serviceDashboardType != null && serviceDashboardType.trim().length()>0 && (serviceDashboardType.equalsIgnoreCase("yes") || serviceDashboardType.equalsIgnoreCase("true")))
		{
			JSONObject json = treeObj.getTreeJsonCitirxRum(str);
			response.getWriter().write(json.toString());
		}
		else
		{
			JSONObject json = treeObj.getTreeJson(str);
			response.getWriter().write(json.toString());
		}
		
		
	}
	

%>
<%!
	public ServicesTree getTreeInstance(String className, String nodeName)
	{
		ServicesTree treeObj;
		LayerModelTree lTree;
		ServicesTreeModel servicesTree;
		try
		{
	 		Class invoker = Class.forName("com.egurkha.monitor." + className);
			Object invokerIns =invoker.newInstance();
			if(className.equals("LayerModelTree"))
			{
				if(nodeName != null && !nodeName.equals(""))
				{
					lTree = (LayerModelTree)invokerIns;
					lTree.setSelectedNode(nodeName);
				}
			}
			if(className.equals("ServicesTreeModel"))
			{
				if(nodeName != null && !nodeName.equals(""))
				{
					servicesTree = (ServicesTreeModel)invokerIns;
					servicesTree.setSelectedNode(nodeName);
				}
			}
			treeObj = (ServicesTree)invokerIns;
		}
		catch (java.lang.ClassNotFoundException c)
		{
			c.printStackTrace();
			return null;
		}
		catch (java.lang.InstantiationException c)
		{
			c.printStackTrace();
			return null;
		}
		catch (java.lang.IllegalAccessException c)
		{
			c.printStackTrace();
			return null;
		}
		return treeObj;
	}
%>
