<%@ include file="EgMonitorTracker.jsp" %>
<%@ page import="com.eg.*"%>
<%@ page import="com.egurkha.util.StringUtils" %>
<%@ page import="com.egurkha.admin.AuditLogThread"%>
<%@ page import ="egurkha.EgUIUtils"%>
<%@ page import="java.util.*" %>
<%@ page import="net.sf.json.*" %>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);

	String sessionId = session.getId();
	String user_command=request.getParameter("user_command");
	//String s_component_types=request.getParameter("s_component_types");
	String s_components=request.getParameter("s_components");
	String s_output_required=request.getParameter("s_output_required");
	s_output_required=(s_output_required == null || s_output_required.trim().length()==0)?"N":s_output_required.trim();
	EgDiscInfo discObj = new EgDiscInfo("manager");
	Hashtable nickIpMap = discObj.getNickIpMap();
	Hashtable selectedIpNick=new Hashtable();
	ArrayList selectedNicks=new ArrayList();
	if(s_components != null)
	{
		s_components=s_components.trim();
		if(s_components.length()>0 && !s_components.equalsIgnoreCase("null"))
		{
			ArrayList componentList = StringUtils.myTokenizer(s_components,",");
			for(int i=0;i<componentList.size();i++)
			{
				String comp=(String)componentList.get(i);
				String nick=comp.substring(comp.indexOf(":")+1);
				nick=nick.substring(0,nick.indexOf(":"));
				if(nick.indexOf(" - ")>0)
				{
					selectedNicks.add(nick);
				}
				else if(nickIpMap.containsKey(nick))
				{
					String ip = (String)nickIpMap.get(nick);
					if(!selectedIpNick.containsKey(ip))
					{
						selectedIpNick.put(ip,nick);
						if(!selectedNicks.contains(nick))
						{
							selectedNicks.add(nick);
						}
					}
				}
			}
			componentList.clear();
		}
	}
	JSONObject json = new JSONObject();
	if(!selectedNicks.isEmpty())
	{
		//String agentID=(String)selectedNicks.get(0);
		ArrayList RC_OUTPUT=null;
		StringBuffer sbResults = null;

		StringBuffer sbResultsCommand = null;
		json.put("errorMessage","-");

		AuditLogThread auditLogThread = new AuditLogThread();
		auditLogThread.setValue("User_id",u_ser.getLoginID());
		auditLogThread.setValue("Host_ip",u_ser.getUserIP(sessionId));
		auditLogThread.setValue("Session_id",sessionId);
		auditLogThread.setValue("Category","Monitor");
		auditLogThread.setValue("Module","Remote Control");
		auditLogThread.setValue("Activity","Execute Tasks/Commands");

		long timeOut=300000L;
		EgControlInfo controlInfo = new EgControlInfo("manager");
		String timeOutStr = controlInfo.getValue("CONTROL_DEFAULTS","TimeOut");
		try
		{
			timeOut = (Math.abs(Long.parseLong(timeOutStr.trim())) * 1000);
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			if(timeOut<300000)
			{
				timeOut=300000;
			}
		}
		String timeout=""+timeOut;
		String passWord="-";
		user_command = EgUIUtils.decodeSecurityChar(user_command);
		auditLogThread.setCurrentValue("02~~Command",user_command);
		if(s_output_required.equals("Y")) {
			auditLogThread.setCurrentValue("03~~Output Required","Yes");
		}
		else {
			auditLogThread.setCurrentValue("03~~Output Required","No");
		}

		if(user_command.startsWith("dir"))
		{
			int dirIndex = user_command.indexOf("dir ");
			String tmpArgument = user_command.substring(dirIndex+4);
			if(tmpArgument.indexOf("\"") < 0)
				tmpArgument = "\""+tmpArgument+"\"";
			tmpArgument = EgCrypt.encrypt(tmpArgument);
			user_command = "dir "+tmpArgument;
		}
		else if(user_command.startsWith("ls -alt"))
		{
			int lsIndex = user_command.indexOf("ls -alt ");
			String tmpArgument = user_command.substring(lsIndex+8);
			tmpArgument = EgCrypt.encrypt(tmpArgument);
			user_command = "ls -alt "+tmpArgument;
		}
		else if(user_command.indexOf("ping") > -1)// && agentOS.equals("HPUX"))
		{
			user_command = user_command + " -n 5";
		}
		String val = timeout+"@#@"+passWord+"@#@"+user_command;
		Hashtable helperThreadTable=new Hashtable();
		Hashtable outputHt=new Hashtable();
		Iterator itr = selectedNicks.iterator();
		while(itr.hasNext())
		{
			String compNick = (String)itr.next();
			if(EgStateManager.notRunningAgents.contains(compNick))
			{
				outputHt.put(compNick,"Agent is not running");
				continue;
			}
			auditLogThread.setCurrentValue("01~~Agent Name",compNick);
			String rcaAgentId=compNick;
			if(rcaAgentId.indexOf(" - ")>0)
			{
				rcaAgentId=compNick.replace(" - ","$");
			}
			RemoteControlTaskHelperThread helperThread = new RemoteControlTaskHelperThread(rcaAgentId,val,s_output_required,sessionId);
			helperThreadTable.put(compNick,helperThread);
		}
		itr = selectedNicks.iterator();
		while(itr.hasNext())
		{
			String compNick = (String)itr.next();
			RemoteControlTaskHelperThread helperThread = (RemoteControlTaskHelperThread) helperThreadTable.get(compNick);
			if(helperThread != null)
			{
				while(true)
				{
					if(helperThread.completed)
					{
						if(helperThread.isTaskCompleted)
						{
							ArrayList localList = helperThread.getOuput();
							if(localList != null && !localList.isEmpty())
							{
								outputHt.put(compNick,localList);
							}
							else if(s_output_required.equalsIgnoreCase("y"))
							{
								outputHt.put(compNick,"No output received");
							}
							else if(s_output_required.equalsIgnoreCase("n"))
							{
								outputHt.put(compNick,"Command executed");
							}
						}
						else if(!helperThread.isAgentReady)
						{
							outputHt.put(compNick,"Agent is not ready");
						}
						break;
					}
					else
					{
						Thread.currentThread().sleep(500);
					}
				}
			}
		}
		JSONArray rows = new JSONArray();
		itr = selectedNicks.iterator();
		while(itr.hasNext())
		{
			String compNick = (String)itr.next();
			if(outputHt.containsKey(compNick))
			{
				Object obj=outputHt.get(compNick);
				if(s_output_required.equalsIgnoreCase("y"))
				{
					sbResults = new StringBuffer(1024);
					sbResultsCommand = new StringBuffer(1024);
					if(obj instanceof ArrayList)
					{
						ArrayList result = (ArrayList)obj;
						int max=150;
						int lcount=result.size();
						sbResults.append("<ul class=\'agentlist\'>");
						for(int i=0;i<lcount;i++)
						{
							String value = (String)result.get(i);
							int ind=0;
							while((ind=value.indexOf('<')) > -1 )
							{
								String sub1 = value.substring(0,ind);
								String sub2 = value.substring(ind+1,value.length());
								value = sub1 + "&lt;" + sub2;
							}
							while((ind=value.indexOf('>')) > -1 )
							{
								String sub1 = value.substring(0,ind);
								String sub2 = value.substring(ind+1,value.length());
								value = sub1 + "&gt;" + sub2;
							}
							if(value.length() >300 )
							{
								max=130;
							}
							while(value.length() > max)
							{
								String value_now=StringUtils.replace(value.substring(0,max)," ","&nbsp;");
								sbResults.append("<li class=\'x-boundlist-item\'>"+value_now+"</li>");
								sbResultsCommand.append(value.substring(0,max));
								value =value.substring(max,value.length());
							}
							if(value.length() <= max)
							{
								String value_now=StringUtils.replace(value," ","&nbsp;");
								sbResults.append("<li class=\'x-boundlist-item\'>"+value_now+ "</li>");
								sbResultsCommand.append(value);
							}
							max = 150;
						}
						sbResults.append("</ul>");
						JSONObject row = new JSONObject();
						row.put("agentName",compNick);
						row.put("outputReceived","Yes");
						row.put("status","Command executed");
						row.put("commandOutput",sbResults.toString());
						row.put("commandOutputRaw",sbResultsCommand.toString());
						rows.add(row);
						auditLogThread.setCurrentValue("04~~Command was executed successfully for agent",compNick);
					}
					else if(obj instanceof String)
					{
						String str = (String)obj;
						JSONObject row = new JSONObject();
						row.put("agentName",compNick);
						row.put("outputReceived","Yes");
						row.put("status",str);
						row.put("commandOutput","-");
						row.put("commandOutputRaw","-");
						rows.add(row);
						auditLogThread.setCurrentValue("04~~Command was executed successfully but output not received from agent",compNick);
					}
				}
				else if(s_output_required.equalsIgnoreCase("n"))
				{
					sbResults = new StringBuffer(1024);
					String str=(String)obj;
					JSONObject row = new JSONObject();
					row.put("agentName",compNick);
					if(str.equalsIgnoreCase("Command executed"))
					{
						row.put("outputReceived","Yes");
						row.put("status","Command executed");
						auditLogThread.setCurrentValue("04~~Command was executed successfully for agent",compNick);
					}
					else if(str.equalsIgnoreCase("Agent is not ready"))
					{
						row.put("outputReceived","No");
						row.put("status",str);
						auditLogThread.setCurrentValue("04~~Command was not successfully executed for agent",compNick);
					}
					else if(str.equalsIgnoreCase("Agent is not running"))
					{
						row.put("outputReceived","No");
						row.put("status",str);
						auditLogThread.setCurrentValue("04~~Command was not executed for agent",compNick);
					}
					row.put("commandOutput","-");
					row.put("commandOutputRaw","-");
					rows.add(row);
				}
			}
		}
		if(sbResults!=null)
			json.put("output",sbResults.toString());
		else
			json.put("output","-");
		json.put("rows",rows);
		auditLogThread.setValue("Description","Command has been executed");
		auditLogThread.sendItToDB();
	}
	response.setContentType("application.json;charset=UTF-8");
	response.getWriter().write(json.toString());
%>
