<%
/*****************************************************************************************************
 *	Name			:	EgQInsightDesignView.jsp
 *	Version			:	eG 3.1
 *	Purpose			:	Display tier,server and metric information and values.
 *	Creation Date	:	19-01-2004.
 *	Author			:	Bala Murali
 *	Last Modified	:	
 *****************************************************************************************************/
%>
<%@ taglib prefix="egui" uri="/WEB-INF/eg-taglib.tld" %>
<%@ include file="EgTracker.jsp" %>
<%@page  errorPage="EgError.jsp" %>
<%@ page import = "com.egurkha.User" %>
<%@ page import = "com.egurkha.UserRegistry" %>
<%@ page import = "com.eg.EgURLEncoder" %>
<%@ page import = "com.egurkha.monitor.EgQInsightView" %>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);

	String s_insightName  = request.getParameter("view_name");
	if(s_insightName != null)
	s_insightName=s_insightName.replace("'","~#~");
	String sessionID = session.getId();
	UserRegistry registry = UserRegistry.getInstance();
	User this_user = registry.getUser(sessionID);
	EgQInsightView ins_view = this_user.getQInsightView(s_insightName);
	int num_tiers = ins_view.getNoOfTiers();
	int num_servers = ins_view.getNoOfServersPerTier();
	int num_metrics = ins_view.getNoOfMetricsPerServer();
	List all_servers = this_user.getServers(false);
	String monHomePage=this_user.getMonitorHomePage();
	if(num_tiers == 0 || num_servers==0 || num_metrics==0)
	{
%>
		<jsp:forward page="EgQInsightLayout.jsp"/>
<%
	}

	int tierHeight =20;
	int tierWidth = 230;
	int serverHeight=16;
	int metricHeight=18;
	int serverWidth = 240;
	
	for(int t_pos=0; t_pos< num_tiers; t_pos++)
	{
		for(int s_pos=0;s_pos<num_servers;s_pos++)
		{
			boolean isServerUsed = ins_view.isServerUsed(t_pos,s_pos);
			if( isServerUsed)
			{							
				String [] server_info= ins_view.getServerInfo(t_pos,s_pos);
				String saved_comp = server_info[EgQInsightView.SERVER_COMP_IDX].trim();
				String saved_comp_type = saved_comp.substring(saved_comp.lastIndexOf(":")+1);
				String saved_server_name =( ins_view.getServerName(t_pos,s_pos)).trim();
				String sid="";
				StringTokenizer stk = new StringTokenizer(saved_comp,":");
				int len =stk.countTokens();
				String nick = stk.nextToken();
				String port = stk.nextToken();
				if(len==4)
					sid = ":"+stk.nextToken();
				String comp_t= stk.nextToken();
				String comp_new = comp_t+":"+nick+":"+port+sid;
				if(!all_servers.contains(comp_new))
				{
					ins_view.removeServer(t_pos,s_pos);
				}
			}
		}
	}
%>

<html>
<head>
	<title> &nbsp; eG Manager &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; </title>
	<meta name="Author" content="balamurali" />
<!-- 	<link rel=stylesheet href="../eg_styles/eg_monitorstyle.css" /> -->
	<egui:skin ui="monitor"/>
	<script language="javascript1.3">
	function setTitle(title)
	{
		if(window.parent.setTitle!=null)
		{
			window.parent.setTitle(title);
		}
	}
	</script>
</head>
<body leftmargin="6" topmargin="6" marginheight="6" marginwidth="6"  style="overflow:auto" onLoad="javascript:window.parent.setTitle('DESIGN VIEW [<%=s_insightName%>]')">
<form name="design" action="" method="POST" style="margin:0px; padding:0px">
<table width="100%" height="100%" align="center" cellspacing="0" cellpadding="0" border="0" id="cell_b   order3">
<tr>
	<td>
		<table align="center"  cellspacing="0" cellpadding="0" border="0"  >
<%
		for(int t_pos=0; t_pos< num_tiers; t_pos++)
		{
			boolean isTierUsed = ins_view.isTierUsed(t_pos);
			String t_name = ins_view.getTierName(t_pos);
%>		
			<tr>
				<td  align="left" >
					<table  border="0" cellspacing="0" cellpadding="0" >
					<tr>
						<td id="qin_subleft" width="14" height="22"></td>
						<td width="<%=tierWidth-25%>" height="<%=tierHeight%>" id="tier_head">
							<a class="eg_navlink_head" href ="EgQInsightTier.jsp?view_name=<%=EgURLEncoder.encode(s_insightName,"UTF-8")%>&tier_position=<%=(t_pos+1)%>&tier_name=<%=t_name%>" hspace="0" vspace="0" >
							<%
								if(isTierUsed)
								{
									out.print(t_name);
								}
								else
								{
									%>
										[<egui:intnl text='monitor.quickinsight.Add tier'/>]
									<%
								}

							%>
							<%//=(isTierUsed?t_name:"[Add tier]")%>
						</a>
						</td>
						<td width="25" align="right" id="tier_head" style="border-left-width:0px" >
<%
						if(isTierUsed)
						{
%>
							<a class="eg_navlink_head" href = "EgQIEasyServerConfig.jsp?view_name=<%=EgURLEncoder.encode(s_insightName,"UTF-8")%>&tier_position=<%=(t_pos+1)%>&tier_name=<%=t_name%>"> <img src="/final/monitor/eg_images/gray/config-servers.gif" align="absmiddle" border="0"></a>
<%
						}
%>
						</td>
						<td id="qin_subright" width="14" height="22"></td>
					</tr>
					</table>
				</td>	
			</tr>			
			<tr>
				<td colspan="2"  width="<%=serverWidth*num_servers%>" id="tier_border">
					<table  cellspacing="0" cellpadding="0" border="0" height="100%">
					<tr>
<%	
					for(int s_pos=0;s_pos<num_servers;s_pos++)
					{
						boolean isServerUsed = ins_view.isServerUsed(t_pos,s_pos);
						String s_name =ins_view.getServerName(t_pos,s_pos); 
						boolean last = false;
						int x= num_servers-1;
						if(s_pos==x)
							last=true;
						
%>			
						<td  style="background-color:white">
							<table align="left" cellspacing="0" cellpadding="0" border="0" width="100%" height="100%">
							<tr>
								<td  align="center"  width="<%=serverWidth%>"  id="tier_cellhead" nowrap style="<%=last?"border-right-width:0px":""%>">
								<table width="100%" border="0" cellspacing="0" cellpadding="0">
								<tr>
								<td width="88%" align="center" height="<%=serverHeight%>">
<%
								if(isTierUsed)
								{
%>								
									<a class="qin_link" href="EgQInsightServer.jsp?view_name=<%=EgURLEncoder.encode(s_insightName,"UTF-8")%>&tier_position=<%=(t_pos+1)%>&server_position=<%=(s_pos+1)%>">
										<%
											if(isServerUsed)
											{
												out.print(s_name);
											}
											else
											{
												%>
												[<egui:intnl text='monitor.quickinsight.Add server'/>]
												<%
											}

										%>
									<%//=(isServerUsed?s_name:"[Add server]")%>
									</a>
									</td>
									<td width="10%" align="right">
<%
									if(isServerUsed)
									{
%>											
										<span align="right"><a class="qin_link" href = "EgQICopyServerMetrics.jsp?view_name=<%=EgURLEncoder.encode(s_insightName,"UTF-8")%>&tier_position=<%=(t_pos+1)%>&server_position=<%=(s_pos+1)%>"><img  src="/final/monitor/eg_images/eg_layout/copy-metrics.gif" border="0"></a>&nbsp;</span>
<%
									}
								}
%>
								</td>
								</tr>
								</table>
								</td>
							</tr>
<%
							for(int m_pos=0;m_pos<num_metrics;m_pos++)
							{
								String modify = "false";
								String m_name = ins_view.getMetricName(t_pos,s_pos,m_pos);
								if(m_name!=null)
									modify = "true";
%>
								<tr>
									<td id="tier_celltext"  style="<%=last?"border-right-width:0px":""%>" width="<%=serverWidth%>" >&nbsp;
<%
									if(isServerUsed)
									{			
										
%>
										<a class="eg_navlink_text" href ="EgQInsightMetric.jsp?view_name=<%=EgURLEncoder.encode(s_insightName,"UTF-8")%>&tier_position=<%=(t_pos+1)%>&server_position=<%=(s_pos+1)%>&metric_position=<%=(m_pos+1)%>">
											<%
												if(m_name==null)
												{
													%>
													[<egui:intnl text='monitor.quickinsight.Add metric'/>]
													<%
												}
												else
												{
													out.print(m_name);
												}
											%>
											<%//=(m_name==null?"[Add metric]":m_name)%>
										</a> 
<%
									}
%>
									</td>
								</tr>
<%			
							}
%>		
							</table>
						</td>	
<%
					}
%>	
					</tr>
					</table>
				</td>
			</tr>	
			<tr><td class="eg_blankspace" height="5">&nbsp;</td></tr>
<%
		}
%>	
		</table>
	</td>
</tr>
</table>
</form>
</body>
</html>
<%
	if(monHomePage!=null && monHomePage.trim().length()>0 && monHomePage.equals("Quick Insight"))
	{
		if(request.getQueryString()!=null)
		{
			session.setAttribute("monitorLastSession","/final/monitor/qinsight/EgQInsightHome.jsp?currentLoadingPage=EgQInsightDesignView&view_name="+s_insightName+"&"+request.getQueryString());
		}
		else
		{
			session.setAttribute("monitorLastSession","/final/monitor/qinsight/EgQInsightHome.jsp?currentLoadingPage=EgQInsightDesignView&view_name="+s_insightName);
		}
	}
%>