<%
/*
	Author			:	James Thomas
	Creation Date	:	06th September 2006
	Purpose			:	To display zones, services, services and independent components
	Design Changes	:	Jaiwin
						20/12/2011  Sri Devi G User - VM Changes
*/	
%>

<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %> 
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ page errorPage="EgProbsM.jsp" %>
<%@ include file="EgLoginTracker.jsp" %>
<%@ page import = "com.egurkha.*" %>
<%@ page import = "com.egurkha.monitor.*" %>
<%@ page import = "com.eg.EgURLEncoder" %>
<%@ page import = "java.util.Hashtable" %>
<%@ page import="com.egurkha.monitor.DashboardData"%>
<%@ page import="com.egurkha.monitor.DashboardResult"%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);

	DashboardData d = (DashboardData) session.getAttribute("dashboardData");
	DashboardResult r = (DashboardResult) session.getAttribute("dashboardResult");

	int columnWidth = 100;
	String states[]={"GOOD","UNKNOWN","LOW","INTERMEDIATE","HIGH"};
	IniUI ui = (IniUI)IniUI.getInstance();
	
	String showServiceGroups=ui.getValue("MONITOR_DASHBOARD","ShowServiceGroups");
	boolean isShowServiceGroups=false;
	if(showServiceGroups!=null && (showServiceGroups.equalsIgnoreCase("yes") || showServiceGroups.equalsIgnoreCase("true")))
	{
		isShowServiceGroups=true;
	}

	Health zonesHealth = (Health) r.zonesHealth;
	Health servicesHealth = (Health) r.servicesHealth;
	Health serviceGroupHealth = (Health) r.serviceGroupHealth;
	Health segmentsHealth = (Health) r.segmentsHealth;
	Health independentComponentsHealth = (Health) r.independentComponentsHealth;
	Health aggregateComponentsHealth = (Health) r.aggregateComponentsHealth;
	Health vmsHealth = (Health) r.vmsHealth;

	long zonesTotal = zonesHealth.getTotal();
	long servicesTotal = servicesHealth.getTotal();
	long serviceGroupTotal = serviceGroupHealth.getTotal();
	long segmentsTotal = segmentsHealth.getTotal();
	long independentComponentsTotal = independentComponentsHealth.getTotal();
	long aggregateComponentsTotal = aggregateComponentsHealth.getTotal();
	long vmsTotal = vmsHealth.getTotal();
	if (zonesTotal == 0  && servicesTotal == 0 && serviceGroupTotal == 0 && segmentsTotal == 0 && independentComponentsTotal == 0 && aggregateComponentsTotal == 0 && vmsTotal == 0)
	{
%>
		<jsp:forward page="empty.jsp" >
			<jsp:param name="reason" value="No components have been enabled for monitoring"/>
		</jsp:forward>
<%
	}

	Hashtable backgroundColorAndState = new Hashtable();
	backgroundColorAndState.put("0id", "GOOD_bg");
	backgroundColorAndState.put("1id", "UNKNOWN_bg");
	backgroundColorAndState.put("2id", "LOW_bg");
	backgroundColorAndState.put("3id", "INTERMEDIATE_bg");
	backgroundColorAndState.put("4id", "HIGH_bg");
	backgroundColorAndState.put("0state", "GOOD");
	backgroundColorAndState.put("1state", "UNKNOWN");
	backgroundColorAndState.put("2state", "LOW");
	backgroundColorAndState.put("3state", "INTERMEDIATE");
	backgroundColorAndState.put("4state", "HIGH");
%>

<html>
<head>

<title>&nbsp;Elements Status</title>
 <egui:skin ui="monitor"/>
</head>
<body topmargin="0" marginheight="0" leftmargin="0" marginwidth="0"  style="overflow:auto">
<jsp:useBean id="trans" scope ="page" class="egurkha.TransactionBean" />
<table width="100%"  cellpadding="0" cellspacing="0" border="0"><col width="30%"><col width="10%"><col width="60%">
<tr>
	<td nowrap align="left" height="25"   id="cell_border1" >&nbsp;<a <%=(zonesTotal>0)? "href=\"../servlet/com.eg.EgMonitorController?monCmd=zoneList&from=MainDashboard&action=zone\" target=\"_parent\"":"#"%> class="eg_monlink">&nbsp;<egui:intnl text="monitor.home.Zones"/></a>
	</td>
	<td nowrap align="center" height="25"  id="cell_border2">
		<%=zonesTotal%>
	</td>
	<td nowrap align="left" height="25"  id="cell_border1" style="border-right-width:0px;"> <!-- style="padding-right:5px;padding-left:5px"  style="border-right-width:0px" -->
		<table width="<%=columnWidth%>%" border="0"   cellspacing="0" cellpadding="0" height="15">
		<tr>
<%
			for (int i=0; i<states.length; i++)
			{
				long stateCount = zonesHealth.getValue(State.getState(states[i]));
				if (stateCount==0)
				continue;
%>
			<a href="../servlet/com.eg.EgMonitorController?monCmd=zoneList&from=MainDashboard&action=zoneState&stateName=<%=backgroundColorAndState.get(i+"state")%>" target="_parent" >		
				<span>
					<td   align="center" valign="middle" class="mouse" width="<%=(stateCount*100/zonesHealth.getTotal())%>%" id="<%=backgroundColorAndState.get(i+"id")%>" onclick="loadURL('../servlet/com.eg.EgMonitorController?monCmd=zoneList&from=MainDashboard&action=zoneState&stateName=<%=backgroundColorAndState.get(i+"state")%>');">
					<font face="Verdana,Arial" style="font-family: Verdana,Arial; font-size: 11px; font-weight:normal; letter-spacing: 1px;">&nbsp;<%=stateCount%>&nbsp;</font>
					</td>
				</span>


			</a>
<%
			}
%>
			</tr>
<%
			if(zonesTotal==0)
			{
%>
		<tr><td align="center"><!--egui:intnl text='monitor.zonehome.None'/-->&nbsp;</td></tr>
<%
			}
%>
		</table>
	</td>
</tr>
<%
		if(isShowServiceGroups)
		{
%>
<tr>
	<td nowrap align="left" height="25"  id="cell_border1" >&nbsp;<a <%=(serviceGroupTotal>0)? "href=\"../servlet/com.eg.EgMonitorController?monCmd=serviceList&from=serviceGroup&action=serviceGroup\" target=\"_parent\"":"#"%> class="eg_monlink">&nbsp;<egui:intnl text="monitor.home.Service Groups"/></a>
	</td>
	<td nowrap align="center" height="25"  id="cell_border2" >
		<%=serviceGroupTotal%>
	</td>
	<td nowrap align="left" height="25"  id="cell_border1" style="border-right-width:0px"> <!-- style="padding-right:5px;padding-left:5px"  style="border-right-width:0px"  -->
		<table width="<%=columnWidth%>%" border="0" cellspacing="0" cellpadding="0" height="15">
		<tr>
<%
			for (int i=0; i<states.length; i++)
			{
				long stateCount = serviceGroupHealth.getValue(State.getState(states[i]));
				if (stateCount==0)
					continue;
%>
			<a href="../servlet/com.eg.EgMonitorController?monCmd=serviceList&from=serviceGroup&action=serviceState&stateName=<%=backgroundColorAndState.get(i+"state")
			%>" target="_parent">
					<span>
						<td  align="center" valign="middle" class="mouse" width="<%=(stateCount*100/serviceGroupHealth.getTotal())%>%" id="<%=backgroundColorAndState.get(i+"id")%>" onclick="loadURL('../servlet/com.eg.EgMonitorController?monCmd=serviceList&from=serviceGroup&action=serviceState&stateName=<%=backgroundColorAndState.get(i+"state")%>');"><font face="Verdana,Arial" style="font-family: Verdana,Arial; font-size: 11px; font-weight: normal; letter-spacing: 1px;">&nbsp;<%=stateCount%>&nbsp;</font>
						</td>
					</span>
			</a>
<%
			}
%>
			</tr>
<%
			if(serviceGroupTotal==0)
			{
%>
		<tr><td align="center"><!--egui:intnl text='monitor.zonehome.None'/-->&nbsp;</td></tr>
<%
			}
%>
		</table>
	</td>
</tr>
<%
		}
%>
<tr>
	<td nowrap align="left" height="25"  id="cell_border1" >&nbsp;<a <%=(servicesTotal>0)? "href=\"../servlet/com.eg.EgMonitorController?monCmd=serviceList&from=MainDashboard&action=service\" target=\"_parent\"":"#"%> class="eg_monlink">&nbsp;<egui:intnl text="monitor.home.Services"/></a>
	</td>
	<td nowrap align="center" height="25"  id="cell_border2" >
		<%=servicesTotal%>
	</td>
	<td nowrap align="left" height="25"  id="cell_border1" style="border-right-width:0px"> <!-- style="padding-right:5px;padding-left:5px"  style="border-right-width:0px"  -->
		<table width="<%=columnWidth%>%" border="0" cellspacing="0" cellpadding="0" height="15">
		<tr>
<%
			for (int i=0; i<states.length; i++)
			{
				long stateCount = servicesHealth.getValue(State.getState(states[i]));
				if (stateCount==0)
					continue;
%>
			<a href="../servlet/com.eg.EgMonitorController?monCmd=serviceList&from=MainDashboard&action=serviceState&stateName=<%=backgroundColorAndState.get(i+"state")
			%>" target="_parent">
				<span>
					<td  align="center" valign="middle" class="mouse" width="<%=(stateCount*100/servicesHealth.getTotal())%>%" id="<%=backgroundColorAndState.get(i+"id")%>" onclick="loadURL('../servlet/com.eg.EgMonitorController?monCmd=serviceList&from=MainDashboard&action=serviceState&stateName=<%=backgroundColorAndState.get(i+"state")%>');"><font face="Verdana,Arial" style="font-family: Verdana,Arial; font-size: 11px; font-weight: normal; letter-spacing: 1px;">&nbsp;<%=stateCount%>&nbsp;</font>
					</td>
				</span>
			</a>
<%
			}
%>
			</tr>
<%
		if(servicesTotal==0)
		{
%>
		<tr><td align="center"><!--egui:intnl text='monitor.zonehome.None'/-->&nbsp;</td></tr>
<%
		}
%>
		</table>
	</td>
</tr>
<tr>
	<td  id="cell_border1"  nowrap align="left"  height="25">&nbsp;<a class="eg_monlink"
		<%=(segmentsTotal>0)?"href=\"../servlet/com.eg.EgMonitorController?monCmd=segmentList&from=MainDashboard&action=segment\"":"#"%> target="_parent" >&nbsp;<egui:intnl text="monitor.home.Segments"/></a>
	</td>
	<td nowrap align="center" height="25" id="cell_border2">			
	<%=segmentsTotal%></td>
	<td nowrap align="left" height="25"  id="cell_border1" style="border-right-width:0px"> <!-- style="padding-right:5px;padding-left:5px"  style="border-right-width:0px" -->
		<table width="<%=columnWidth%>%" border="0" cellspacing="0" cellpadding="0" height="15">
		<tr>
<%
			for (int i=0; i<states.length; i++)
			{
				long stateCount = segmentsHealth.getValue(State.getState(states[i]));
				if (stateCount==0)
					continue;
%>
			<a href="../servlet/com.eg.EgMonitorController?monCmd=segmentList&from=MainDashboard&action=segmentState&stateName=<%=backgroundColorAndState.get(i+"state")%>" target="_parent">			
				<span>
					<td  align="center" valign="middle" class="mouse" 	width="<%=(stateCount*100/segmentsHealth.getTotal())%>%" id="<%=backgroundColorAndState.get(i+"id")%>" onclick="loadURL('../servlet/com.eg.EgMonitorController?monCmd=segmentList&from=MainDashboard&action=segmentState&stateName=<%=backgroundColorAndState.get(i+"state")%>');"><font face="Verdana,Arial" style="text-align:center;font-family: Verdana,Arial; font-size: 11px; font-weight: normal; letter-spacing: 1px;">&nbsp;<%=stateCount%>&nbsp;
					</font>
					</td>
				</span>
			</a>
<%
			}
%>
			</tr>
<%
		if(segmentsTotal==0)
		{
%>
		<tr><td align="center"><!--egui:intnl text='monitor.zonehome.None'/-->&nbsp;</td></tr>
<%
		}
%>
		</table>
	</td>
</tr>
<%
if(!(aggregateComponentsTotal==0))
{
%>

<tr>
	<td nowrap align="left" height="25" id="cell_border1" style="border-bottom-width:1px">&nbsp;<a <%=(aggregateComponentsTotal>0)?"href=\"../servlet/com.eg.EgMonitorController?monCmd=componentList&from=MainDashboard&searchStateString=All States&action=search&searchIndComps=checked&menuName=agg\"":"#"%> target="_parent" class="eg_monlink">&nbsp;<egui:intnl text="monitor.home.Aggregates"/></a>
	</td>
	<td nowrap align="center" height="25"  id="cell_border2">
				<%=aggregateComponentsTotal%></td>
	<td nowrap align="center" height="25" id="cell_border1" style="border-right-width:0px"> <!-- style="padding-right:5px;padding-left:5px"  style="border-bottom-width:0px" style= "border-right-width:0px" -->
		<table width="<%=columnWidth%>%" border="0" cellspacing="0" cellpadding="0" height="15">
		<tr>
<%
			for (int i=0; i<states.length; i++)
			{
				long stateCount = aggregateComponentsHealth.getValue(State.getState(states[i]));;
				if (stateCount==0)
				continue;
%>
		<a href="../servlet/com.eg.EgMonitorController?monCmd=componentList&from=MainDashboard&action=componentState&menuName=agg&searchIndComps=checked&action=componentState&stateName=<%=backgroundColorAndState.get(i+"state")%>" target="_parent">
		<span>
			<td  align="center" valign="middle" class="mouse"  width="<%=(stateCount*100/aggregateComponentsHealth.getTotal())%>%" id="<%=backgroundColorAndState.get(i+"id")%>" onclick="loadURL('../servlet/com.eg.EgMonitorController?monCmd=componentList&from=MainDashboard&action=componentState&searchIndComps=true&menuName=agg&action=action=componentState&stateName=<%=backgroundColorAndState.get(i+"state")%>');">
			<font face="Verdana,Arial" style="text-align:center;font-family: Verdana,Arial; font-size: 11px; font-weight: normal; letter-spacing: 1px;">&nbsp;<%=stateCount%>&nbsp;</font>
			</td>
		</span>
		</a>
<%
			}
%>
		</tr>
<%
		if(aggregateComponentsTotal==0)
		{
%>
		<tr><td align="center"><!--egui:intnl text='monitor.zonehome.None'/-->&nbsp;</td></tr>
<%
		}
%>
		</table>
	</td>
</tr>
<%
}
%>
<tr>
	<td nowrap align="left" height="25" id="cell_border1"  style="border-bottom-width:1px">&nbsp;<a <%=(independentComponentsTotal>0)?"href=\"../servlet/com.eg.EgMonitorController?monCmd=componentList&from=Maindashboard&searchStateString=All States&action=search&searchIndComps=checked\"":"#"%> target="_parent" class="eg_monlink">&nbsp;<egui:intnl text="monitor.home.Components"/></a>
	</td>
	<td nowrap align="center" height="25"  id="cell_border2" style="border-bottom-width:1px">
				<%=independentComponentsTotal%></td>
	<td nowrap align="center" height="25"  id="cell_border1" style="border-bottom-width:1px;border-right-width:1px"> <!-- style="padding-right:5px;padding-left:5px"  style="border-bottom-width:1px" style= "border-right-width:0px" -->
		<table width="<%=columnWidth%>%" border="0" cellspacing="0" cellpadding="0" height="15">
		<tr>
<%
			for (int i=0; i<states.length; i++)
			{
				long stateCount = independentComponentsHealth.getValue(State.getState(states[i]));;
				if (stateCount==0)
				continue;
%>
		<a href="../servlet/com.eg.EgMonitorController?monCmd=componentList&from=MainDashboard&action=componentState&searchIndComps=true&stateName=<%=backgroundColorAndState.get(i+"state")%>" target="_parent">
			<span>
				<td  align="center" valign="middle" class="mouse"  width="<%=(stateCount*100/independentComponentsHealth.getTotal())%>%" id="<%=backgroundColorAndState.get(i+"id")%>" onclick="loadURL('../servlet/com.eg.EgMonitorController?monCmd=componentList&from=MainDashboard&searchIndComps=true&action=componentState&stateName=<%=backgroundColorAndState.get(i+"state")%>');">
				<font face="Verdana,Arial" style="font-family: Verdana,Arial; font-size: 11px; font-weight: normal; letter-spacing: 1px;">&nbsp;<%=stateCount%>&nbsp;</font>
				</td>
			</span>
		</a>
<%
			}
%>
		</tr>
<%
		if(independentComponentsTotal==0)
		{
%>
		<tr><td align="center"><!--egui:intnl text='monitor.zonehome.None'/-->&nbsp;</td></tr>
<%
		}
		%>
		</table>
	</td>
</tr>
<% if(vmsTotal > 0)
{
%>
<tr>
	<td nowrap align="left" height="25" id="cell_border1"  style="border-bottom-width:1px">&nbsp;<a <%=(vmsTotal>0)?"href=\"EgVmwareDesktop.jsp?from=MainDashboard&stateName=all\"":"#"%> target="_parent" class="eg_monlink">&nbsp;<egui:intnl text="monitor.home.Virtual Machines"/></a>
	</td>
	<td nowrap align="center" height="25"  id="cell_border2" style="border-bottom-width:1px">
				<%=vmsTotal%></td>
	<td nowrap align="center" height="25"  id="cell_border1" style="border-bottom-width:0px;border-right-width:0px"> <!-- style="padding-right:5px;padding-left:5px"  style="border-bottom-width:1px" style= "border-right-width:0px" -->
		<table width="<%=columnWidth%>%" border="0" cellspacing="0" cellpadding="0" height="15">
		<tr>
<%
			for (int i=0; i<states.length; i++)
			{
				long stateCount = vmsHealth.getValue(State.getState(states[i]));;
				if (stateCount==0)
				continue;
%>
		<a href="EgVmwareDesktop.jsp?from=MainDashboard&stateName=<%=backgroundColorAndState.get(i+"state")%>" target="_parent">
			<span>
				<td  align="center" valign="middle" class="mouse"  width="<%=(stateCount*100/vmsHealth.getTotal())%>%" id="<%=backgroundColorAndState.get(i+"id")%>" onclick="loadURL('EgVmwareDesktop.jsp?from=MainDashboard&stateName=<%=backgroundColorAndState.get(i+"state")%>');">
				<font face="Verdana,Arial" style="font-family: Verdana,Arial; font-size: 11px; font-weight: normal; letter-spacing: 1px;">&nbsp;<%=stateCount%>&nbsp;</font>
				</td>
			</span>
		</a>
<%
			}
%>
		</tr>

		</table>
	</td>
</tr>
<%
}
%>
</table>
</body>
<script language="javascript">
function loadURL(myURL)
{
	if(window.parent!=null)
	{
		window.parent.location.href=myURL;
	}
}
</script>
</html>