Ext.define('vmdatastoretopology.controller.Main', {
    extend: 'Ext.app.Controller',
    views: ['Main'],
    refs: [
    	{selector: 'main',ref: 'main'},
    	{selector: 'userdesktopdata', ref:'userdesktopdata'},
    	{selector: 'userdata', ref: 'userdata'},
    	{selector: 'maximizeview', ref: 'maximizeview'},
    	{selector: 'vmdata', ref: 'vmdata'}
    ],
    init: function ()
    {
		setInterval("execute()",refreshFrequency);
        this.control({
			'main':
			{
				'afterrender': this.afterMainRendered
			},
			'main button[id="backbtn"]':
			{
				'click':this.onBackBtnClick
			},
			'main button[id="pdf"]':
			{
				'click':this.onPdfClick
			}
		});
    },
	refreshTopology : function()
	{
		var me = this;
		Ext.getBody().mask('Loading...');
		$.ajax({
			url:url,
			type:'POST',
			success: function(result){
				var mainPanel = Ext.ComponentQuery.query('[itemId="mainPanel"]')[0];
				var topologyExist = Ext.ComponentQuery.query('[itemId="topologyPanel"]')[0];
				if($.isEmptyObject(result) || (!$.isEmptyObject(result) && result.hasOwnProperty("error-info")))
				{
					if(!pdfHide)
						Ext.getCmp('pdf').hide();

					var msg = "No information available for this VM/Server!";
					if(result.hasOwnProperty("error-info") && !Ext.isEmpty(result["error-info"]))
						msg = result["error-info"];

					mainPanel.removeAll(true);
					mainPanel.add({
						xtype:'panel',
						border:false,
						header:false,
						html:'<div style="height:100%;width:100%;display:table"><div class="msgFont" style="display:table-cell;vertical-align:middle"> <div class="iconInformation" style="margin:0px auto"></div><div style="text-align:center">'+msg+'</div></div></div>'
					});					
				}
				else 
				{
					if(!pdfHide)
						Ext.getCmp('pdf').show();
					if(Ext.isEmpty(topologyExist))
					{
						mainPanel.removeAll(true);
						mainPanel.add({
							xtype:'topologyPanel',
							id:'topologyPanel',
							itemId:'topologyPanel',
							topoData:result
						});
					}
					else
						topologyExist.drawTopology(result, false);					
				}
				Ext.getBody().unmask();
			}
		});		
	},	
	afterMainRendered: function()
	{
		var me = this;
		Ext.getBody().mask('Loading...');
		$.ajax({
			url:url,
			type:'POST',
			success: function(result){
				var mainPanel = Ext.ComponentQuery.query('[itemId="mainPanel"]')[0];
				mainPanel.setTitle("Storage Topology for VM - "+vmName);
				
				if($.isEmptyObject(result) || (!$.isEmptyObject(result) && result.hasOwnProperty("error-info")))
				{
					if(!pdfHide)
						Ext.getCmp('pdf').hide();
					var msg = "No information available for this VM/Server!";
					if(result.hasOwnProperty("error-info") && !Ext.isEmpty(result["error-info"]))
						msg = result["error-info"];

					mainPanel.add({
						xtype:'panel',
						border:false,
						header:false,
						html:'<div style="height:100%;width:100%;display:table"><div class="msgFont" style="display:table-cell;vertical-align:middle"> <div class="iconInformation" style="margin:0px auto"></div><div style="text-align:center">'+msg+'</div></div></div>'
					});
				}
				else
				{
					if(!pdfHide)
						Ext.getCmp('pdf').show();
					mainPanel.add({
						xtype:'topologyPanel',
						id:'topologyPanel',
						itemId:'topologyPanel',
						topoData:result
					});
				}
				Ext.getBody().unmask();
			}
		});
	},	
	onPdfClick:function()
	{
		var topologyObj = Ext.getCmp("topologyPanel");
		if(Ext.isEmpty(win))
		{
			var win = Ext.create('Ext.window.Window', {
				title: 'Message',
				height:80,
				width:200,
				modal:true,
				layout: 'fit',
				listeners: {
					show: function(win) {
						if (this.modal) {
							var dom = Ext.dom.Query.select('.x-mask');
							var el = Ext.get(dom[0]);
							el.addCls('windowModal');
							
						}
					},
					hide: function(win) {
						if (this.modal) {
							var dom = Ext.dom.Query.select('.x-mask');
							var el = Ext.get(dom[0]);
							el.removeCls('windowModal');
							
						}
					},
				},
				html:'<div style="height:100%;width:100%;display:table"><div class="msgFont" style="display:table-cell;vertical-align:middle"> <div style="text-align:center">Downloading PDF...</div></div></div>'
			});
		}
		win.show();
		//topologyObj.resize(null,topologyObj.getWidth(),topologyObj.getHeight())		
		Ext.get('topologytitle').show();
		//out$.saveSvg(document.getElementById('topologyPanel-body-SVG'),"savePDF")
		//out$.saveSvgAsPng('/final/images/savePDF (1).svg',"savePDF")
		//out$.download('ss','/final/images/savePDF (1).svg')
		svg_to_pdf(document.querySelector("svg"), function (pdf) {	
			 var mainPanelTitle = Ext.ComponentQuery.query('[itemId="mainPanel"]')[0].title;
			 var minTitle = mainPanelTitle.substring(mainPanelTitle.indexOf("for ")+4);
			 download_pdf(minTitle+'.pdf', pdf.output('dataurlstring'));
			 Ext.get('topologytitle').hide();
			 win.hide();
		});
		 
	},
	onBackBtnClick:function()
	{		
		document.location="/final/servlet/com.eg.EgMonitorController?monCmd=dashboard";
		return;		
	}	
});