
<%
/*******************************************************************************
*	File name		: egXenBrokerOverview.jsp
*	Purpose			: This is the main page for Xen DDC Application Dashboard
*	Version			: eG 5.4
*	Creation Date	: 22/07/2011
********************************************************************************/
%>

<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ page import ="java.text.SimpleDateFormat" %>
<%@ page import ="com.egurkha.monitor.*" %>
<%@ page import = "com.eg.EgURLEncoder"%>
<%@ page import = "com.eg.EgSpecsInfo"%>
<%@ include file = "EgLoginTracker.jsp"%>
<%@ page import = "com.eg.EgDbInfo" %>
<%@ page errorPage="EgProbsM.jsp"%>

<%
	response.setHeader("catch-control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires",-1);
%>

<%
try
{
	String compName = "";
	String compType = "";
	String tab = "";
	String hostName = "";
	String portNo = "";
	String sid = "";
	String defaultMsmtHost="";
	String fromRequest = "";
	String defGroupInfo = "All";
	String isFormServer = "yes";
	tab = request.getParameter("tab");
	compName = request.getParameter("hostName");
	compType = request.getParameter("compType");
	fromRequest = request.getParameter("formserver");


	String screenWidth=request.getParameter("screenWidth");
	String screenHeight=request.getParameter("screenHeight");
	

	if(fromRequest != null && fromRequest.equals("no"))
	{
		isFormServer="";
	}
	if(compName != null && !compName.equals("") )
	{
		StringTokenizer st=new StringTokenizer(compName,":");
		if( st.hasMoreTokens() )
			hostName = st.nextToken();

		if( st.hasMoreTokens() )
			portNo = st.nextToken();

		if( st.hasMoreTokens() )
			sid = st.nextToken();
	}

	String s_iniFile_dir = EgInstallInfo.getInstallDir()+"/manager/config/";
	IniFile iniObj = new IniFile(s_iniFile_dir+"eg_serverdashboard.ini");
	IniFile egUI = new IniFile(s_iniFile_dir +"eg_ui.ini");
	IniFile egAgent = new IniFile(s_iniFile_dir +"eg_agents.ini");

	EgXenDDCHelper ddcHelper = new EgXenDDCHelper();
 	EgDbInfo MeasureDisplay = new EgDbInfo("manager");
	EgSpecsInfo specsInfo = new EgSpecsInfo("manager");
	EgServerDashboardModel  egDashboard = new  EgServerDashboardModel();
	MonitorDAOFactory	monitorDaoFactory = MonitorDAOFactory.getInstance();
	EgServerDashBoardDAO dashboardDAO = monitorDaoFactory.getServerDashBoardDAO();
	
	Vector group = new Vector();
	Vector controller = new Vector();
	Vector groupNames = new Vector();
	ArrayList headerList = null;
	ArrayList statusList = null;

	Hashtable allTestInfos = dashboardDAO.getDescriptorsForAllTest(compName,compType,tab);
	Hashtable allMsmtHosts = dashboardDAO.getMsmtHostForAllTest(compName,compType,tab);
	ArrayList enabledTests = specsInfo.getEnabledTests(compType,false);
	Vector runningtests = dashboardDAO.getRunningTestsForServer(compName,compType,tab);
	runningtests.retainAll(enabledTests);

	Hashtable alarmCount = egDashboard.getAlarmCount(compName,compType,"Application");
	egDashboard.setAllAlarmDetails();
	session.setAttribute("DashboardModelObject",egDashboard);
	Hashtable alarmDetails = egDashboard.getAlarmDetails();
	int openproblems=0;
	Integer critical = (Integer) alarmCount.get("HIGH");
	Integer major = (Integer) alarmCount.get("INTERMEDIATE");
	Integer minor = (Integer) alarmCount.get("LOW");

	if(allMsmtHosts != null )
	{
		defaultMsmtHost = (String) allMsmtHosts.get("XDGroupTest");
	}
	if(defaultMsmtHost==null)
	{
		defaultMsmtHost = (String) allMsmtHosts.get("XDCtrlGroupTest");
	}
	String UseCutOffFactor = iniObj.getValue("Dashboard_Settings","UseCutOffFactor");
	StringBuffer buffer=new StringBuffer();
	buffer.append("XDGroupTest");
	buffer.append("::");
	buffer.append(compName);
	String keyFormat = buffer.toString();

	String inivars = (String) egAgent.getValue(defaultMsmtHost,keyFormat);
	String isFormServerenabled = "";
	if( inivars != null && inivars.length()> 0 )
	{
		StringTokenizer stt = new StringTokenizer(inivars,",");
		while(stt.hasMoreTokens())
		{
			String reqVal = (String) stt.nextToken();
			if( reqVal.indexOf("-isFarmServer") > 0 )
			{
				String formserver = reqVal.substring(reqVal.indexOf("-isFarmServer")+1);
				isFormServerenabled = formserver.substring(formserver.indexOf(" ")+1,formserver.indexOf("-"));
			}
		}
	}

	isFormServerenabled = isFormServerenabled.trim();

	String urlToLoadDashboard = "/final/monitor/egXenBrokerOverview.jsp?compType="+compType+"&hostName="+compName+"&tab="+tab+"&screenWidth="+screenWidth+"&screenHeight="+screenHeight;
	urlToLoadDashboard = response.encodeURL(urlToLoadDashboard);
%>
<img src="/final/monitor/eg_images/spacer.gif" border="0" style="display:none" onload="javascript:loadAccording();"/>

<div class="xenMainDiv" align="center" style="border:0px solid orange;" valign="middle" id="xenMainDiv">

	<div class="layer_headbg1 xenTopDiv" style="border-top-width:0px;border-left-width:0px;border-right-width:0px;width:100%;height:30px;visibility:visible;display:hidden;" >
		<table width="100%" height="30" border="0" cellspacing="0" cellpadding="0" >
			<tr>
				<td class="eg_8bold" align="left">
					<div onclick="javascript:goBack();" style="visibility:hidden;display:none;" id="HomeDiv" class="eg_8bold mouse" style="padding-top:3px;padding-left:5px"><img src="/final/images/ddc_mainpage.png"></div>
				</td>
				<td class="eg_8bold" align="left" width="10%" style="padding-left:5px">
<%
	Vector siteInfo = (Vector) allTestInfos.get("XDSiteTest");
	if( siteInfo != null && siteInfo.size() > 0 )
	{
		out.println(com.egurkha.util.StringUtils.replace((String)siteInfo.get(0), "+", ""));
	}
%>
				</td>
<%
	if( alarmCount != null && alarmCount.size() > 0  && ( critical.intValue() + major.intValue() + minor.intValue() ) > 0 )
	{
		String criticalDesc = (String) alarmDetails.get("HIGH");
		String majorDesc = (String) alarmDetails.get("INTERMEDIATE");
		String minorDesc = (String) alarmDetails.get("LOW"); 
		openproblems = critical.intValue()+major.intValue()+minor.intValue();
%>
				<td class="eg_8bold" width="20%" align="right">
					<egui:intnl text="monitor.dashboard.Application Alerts"/>&nbsp;&nbsp;
				</td>
				<td align="left" width="20%" style="padding-top:4px">
					<table border="0" cellpadding="0" cellspacing="0">
						<tr>
							<td width="5"><img class="png" src="/final/monitor/eg_images/<%=monitor_Skin%>/data_bar_left.png" width="5" height="20"></td>
							<td width="90" background="/final/monitor/eg_images/<%=monitor_Skin%>/data_bar_bg.png" width="75%"  class="eg_8bold"><egui:intnl text="monitor.dashboard.Open Alerts"/></td>
							<td class="whiteColor eg_75bold" width="60" background="/final/monitor/eg_images/<%=monitor_Skin%>/data_bar_bgdark.png" align="center" valign="middle" > <%=openproblems%> </td>
							<td width="5"><img class="png" src="/final/monitor/eg_images/<%=monitor_Skin%>/data_bar_bgdarkright.png" width="5" height="20"></td>
						</tr>
					</table>
				</td>
				<td align="left" width="30%" style="padding-top:4px">
					<table border="0" cellpadding="0" cellspacing="0"> <col width="5px"> <col width="90px"><col width="30px" ><col width="30px"><col width="30px">
						<tr>
							<td width="5"><img class="png" src="/final/monitor/eg_images/<%=monitor_Skin%>/data_bar_left.png" width="5" height="20"></td>
							<td width="90" background="/final/monitor/eg_images/<%=monitor_Skin%>/data_bar_bg.png" width="75%" >&nbsp;<egui:intnl text="monitor.dashboard.Distribution"/> </td>
<%
		if( critical != null && critical.intValue() > 0 )
		{
%>
							<td valign="middle" align="center" id="HIGH_alarmsbg" class="whitefont lineright_light"  style="cursor: pointer" onclick= "javascript:showAlert(event,'<%=criticalDesc%>','<%=critical.intValue()%>','HIGH')"> <%=critical.intValue()%> </td>
<%
		}
		else
		{
%>
							<td valign="middle" align="center" id="HIGH_alarmsbg" class="whitefont lineright_light"> <%=critical.intValue()%> </td>
<%
		}
		if( major != null && major.intValue() > 0 )
		{
%>
							<td valign="center" align="center" id="INTERMEDIATE_alarmsbg" class="whitefont lineright_light" style="cursor:pointer"onclick="javascript:showAlert(event,'<%=majorDesc%>','<%=major.intValue()%>','INTERMEDIATE')"><%=major.intValue()%></td>
<%
		}
		else
		{
%>
							<td valign="middle" align="center" id="INTERMEDIATE_alarmsbg" class="whitefont lineright_light"> <%=major.intValue()%></td>
<%
		}
		if( minor !=null && minor.intValue() > 0 )
		{
%>
							<td valign="center" align="center" id="LOW_alarmsbg" class="whitefont lineright_light" style="font-color:white;cursor: pointer" onclick="javascript:showAlert(event,'<%=minorDesc%>','<%=minor.intValue()%>','LOW')"><%=minor.intValue()%> </td>
<%
		}
		else
		{
%>
							<td valign="middle" align="center" id="LOW_alarmsbg" class="eg_75 lineright_light"><%=minor.intValue()%></td>
<%
		}
%>
						</tr>
					</table>
				</td>
<%
		if( isFormServerenabled != null && isFormServerenabled.equalsIgnoreCase("yes") )
		{
%>
				<td class="eg_75bold" align="right">
					<div class="topButton eg_75bold" id="farmserverDiv mouse" style="margin-right:0px;border:0px solid #000000;visibility:visible;display:block;width:210px;text-align:right;align:right;height:30px" >
<%
				if( isFormServer !=null && !isFormServer.equals("") )
				{
%>
						<a  class="eg_75bold" onclick="javascript:loadDashboard('<%=urlToLoadDashboard+"&formserver=no"%>');"><div style="padding:8px;border:0px solid #000000;display:block;float:left">&nbsp;<egui:intnl text="monitor.dashboard.Show Controller Level Details"/></div></a>
					
<%
				}
				else
				{
%>
					
						<a  class="eg_75bold" onclick="javascript:loadDashboard('<%=urlToLoadDashboard+"&formserver="+isFormServerenabled%>');"><div style="padding:8px;border:0px solid #000000;display:block;float:left">&nbsp;<egui:intnl text="monitor.dashboard.Show Farm Level Details "/></div></a>
					
<%
				}
%>
					</div>
				</td>
<%
		}
	}
	else
	{
%>
				<td align="center" valign="middle" style="width:200px">&nbsp;</td>
				<td align="center" valign="middle" style="width:50%;padding-top:4px">
					<table border="0" cellpadding="0" cellspacing="0">
						<tr>
							<td align="center" width="20%" valign="middle" class="egwhite_75bold"><img class="png" src="/final/monitor/eg_images/<%=monitor_Skin%>/icon_exclamation.png" width="20" height="20"></td>
							<td class="eg_75bold"><egui:intnl text="monitor.dashboard.No alarms found"/>!</td>
						</tr>
					</table>
				</td>
<%
		if( isFormServerenabled != null && isFormServerenabled.equalsIgnoreCase("yes") )
		{
%>
				<td class="eg_75bold" align="right">
					<div id="farmserverDiv mouse" class="topButton" style="margin-right:0px;border:0px solid #ff0000;visibility:visible;display:block;width:210px;text-align:right;align:right;height:30px" >
<%
				if( isFormServer !=null && !isFormServer.equals("") )
				{
%>
						<a onclick="javascript:loadDashboard('<%=urlToLoadDashboard+"&formserver=no"%>');"><div style="padding:8px;border:0px solid green;display:block;float:left" class="eg_75bold">&nbsp;<egui:intnl text="monitor.dashboard.Show Controller Level Details"/></div></a>

<%
				}
				else
				{
%>
						<a onclick="javascript:loadDashboard('<%=urlToLoadDashboard+"&formserver="+isFormServerenabled%>');"><div style="padding:8px;border:0px solid #000000;display:block;float:left" class="eg_75bold">&nbsp;<egui:intnl text="monitor.dashboard.Show Farm Level Details "/></div></a>
					
<%
				}
		}
%>
					</div>
				</td>
<%
	}
%>
			</tr>
		</table>
	</div>

	<div id="loadDashboardDiv" class="loadDashboardDiv div_scroll " style="border:0px solid #ff0000;height:500px;width:100%;padding:6px;margin:0px;display:block;visibility:visible">

		<div class="machinesDiv linesquare eg_whitebg" style="float:left;padding:0px;width:100%"> 
			<div class="machinesDivHead eg_medium" style="display:block;visibility:visible;height:20px;width:100%;border-top:0px;border-right:0px;border-left:0px;">
				<div class="eg_8bold" style="float:left;padding:2px"><egui:intnl text="monitor.dashboard.Machines"/></div>
				<div style="float:right;padding:2px 10px 2px 4px;"><img src="/final/images/<%=monitor_Skin%>/icon_slideup.png" class="mouse minimize1"></div>
			</div>
			<div class="machinesDivContent" style="height:160px;padding:5px;margin:0px;text-align:left;position:relative;display:block;width:100%;">
				<div style="float:left;poistion:relative;width:33%;height:155px;" class="div_scroll linesquare">
<%
	String msmtHost = "";
	String allCount = "";
	Hashtable machinesCategoryTable = null;
	Vector machineCategoryColumnNames = ddcHelper.getMachineCategoryColumnNames();

	if ((isFormServerenabled != null  && !isFormServerenabled.equals("") && isFormServerenabled.equalsIgnoreCase("yes")) && (isFormServer!=null && isFormServer.equalsIgnoreCase("yes")))
	{
		isFormServer="yes";
	}
	else
	{
		isFormServer="no";
	}
	if (allMsmtHosts != null )
	{
		if ((isFormServer != null && isFormServerenabled !=null )&& ( isFormServer.equalsIgnoreCase("Yes") || isFormServer.equalsIgnoreCase("true")) && isFormServerenabled.equalsIgnoreCase("yes"))
		{
			
			msmtHost = (String) allMsmtHosts.get("XDGroupTest");
			machinesCategoryTable = (Hashtable) ddcHelper.getMachineCategoryDetails(compType,hostName,portNo,msmtHost,"Application_machine_category_Form");
		}
		else
		{
			msmtHost = (String) allMsmtHosts.get("XDCtrlGroupTest");
			machinesCategoryTable = (Hashtable) ddcHelper.getMachineCategoryDetails(compType,hostName,portNo,msmtHost,"Application_machine_category");
		}
		
	}
	
	if (( machinesCategoryTable != null && machineCategoryColumnNames != null ) && ( !machinesCategoryTable.isEmpty() && machineCategoryColumnNames.size()>0 ))
	{
%>

					<table cellpadding="0" width="100%" cellspacing="0" border="0" id="mouseEventMachine">
						<thead>
							<tr>
								<td width="70%" class="layer_headbg padding4" style="border-top:0;border-left:0;"><egui:intnl text="monitor.dashboard.Category"/></td>
								<td width="30%" class="layer_headbg padding4" style="border-top:0;border-left:0;border-right:0;"><egui:intnl text="monitor.dashboard.Number"/></td>
							</tr>
						</thead>
						<tbody>
<%
		Iterator itr = machineCategoryColumnNames.iterator();
		int v_itr=0; 
		while(itr.hasNext())
		{
			String numberPass = "";
			String category = (String) itr.next();
			Vector values = (Vector) machinesCategoryTable.get(category);
			String url = response.encodeURL("/final/monitor/XenBlocks.jsp?");

			if ( category.equals("All") && values != null && values.size() > 0 )
			{
				allCount = (String) values.get(1);
			}
			if ( values != null && values.size() > 0 )
			{
				numberPass = (String) values.get(1);
			}
			url+="category="+category+"&hostName="+compName+"&compType="+compType+"&tab=Application&xennext=yes&totalDesktops="+numberPass+"&formserver="+isFormServer+"&screenWidth="+screenWidth+"&screenHeight="+screenHeight;
			String mappingName=iniObj.getValue("Dashboard_TableColumn_mapping",category);
			String trBackground="eg_lightlight";
			String position="odd";
			if(v_itr%2==0)
			{
				trBackground="eg_whitebg";
				position="even";
			}
			if ( !category .equals("Current_sessions") || !category .equals("Logout_sessions") || !category .equals("TOT_DISCONNECT_SESSIONS"))
			{

%>
						<tr  id="selectedtr<%=v_itr%>" >

								<td align="left"  valign="top" class="padding4 leftmouse" onclick="javascript:loadGraphForXen('<%=url%>','<%=v_itr%>')" ><%=mappingName%></td>

<%
			}
			else
			{
%>
							<tr class="<%=position%>" id="selectedtr<%=v_itr%>" >
								<td align="left"  valign="top" class="padding4"><%=mappingName%></td>
<%
			}

			if ( values != null && values.size() > 0)
			{
				for (int i=0;i<values.size();i=i+2)
				{
					String info = (String) values.get(i);
					String number = (String) values.get(i+1);
					String machinePageUrl = response.encodeURL("/final/monitor/XenBlocks.jsp?");
					machinePageUrl+="category="+category+"&count=machinepage&hostName="+compName+"&compType="+compType+"&tab=Application&totalDesktops="+number+"&formserver="+isFormServer+"&screenWidth="+screenWidth+"&screenHeight="+screenHeight;
					
					if(!category.equalsIgnoreCase("Never_reg_desktops"))
					{

%>
								<td align="left"  valign="top" class="padding4"><a class="eg_monlink" href="javascript:void(0);" onclick="javascript:gotoMachines('<%=machinePageUrl%>')"><%=number%></a></td>
<%
					}
					else
					{
%>
								<td align="left"  valign="top" class="padding4"><%=number%></td>
<%
					}
				}
			}
			else
			{
%>
								<td align="left"  valign="top" class="padding4">-</td>
<%
			}
%>
							</tr>
						</tbody>

<%
			v_itr++;
		}
%>
					</table>
<%
	}
	else
	{
%>
					<table cellpadding="0" width="100%" cellspacing="0" border="0" height="100%" class="eg_whitebg">
						<tr>
							<td align="center" valign="middle" style="width:100%" height="100%" class="eg_75bold"> <img src="/final/monitor/eg_images/<%=monitor_Skin%>/exclamation-icon.gif"> <br> <egui:intnl text="monitor.dashboard.No Measures Available"/>!
							</td>
						</tr>
					</table>
<%
	}
%>
				</div>
				<div  style="float:left;border:0px solid green;width:65%;height:155px;valign:left;padding-right:5px;visibility:visible;display:block" valign="top" id="GraphBlock">
					<jsp:include page="<%="XenBlocks.jsp?category=All&xennext=yes&hostName="+compName+"&compType="+compType+"&tab=Application&totalDesktops="+allCount+"&formserver="+isFormServer+"&screenWidth="+screenWidth+"&screenHeight="+screenHeight%>"/>
				</div> 
			</div>
		</div>
		<div class="clr" style="height:6px;width:100%;"></div>
<%
	groupNames.add("Desktop Group");
	Hashtable tempData = (Hashtable) ddcHelper.getGroupDetails(hostName,portNo,msmtHost,tab,compType,false,isFormServer);
	TreeMap groupData= new TreeMap(tempData);
	Vector tmpNames = (Vector) ddcHelper.getGroupColumnNames();
	groupNames.addAll(tmpNames);
%>

		<div class="usageDiv linesquare eg_whitebg" style="margin:0px;padding:0px;visibility:visible:display:block" >
			<div class="usageDivHead eg_medium" style="display:block;visibility:visible;height:20px;width:100%;border-top:0px;border-right:0px;border-left:0px;">
				<div class="eg_8bold" style="float:left;padding:2px"><egui:intnl text="monitor.dashboard.Desktop Details"/></div>
				<div style="float:right;padding:2px 10px 2px 4px;"><img src="/final/images/<%=monitor_Skin%>/icon_slideup.png" class="mouse minimize2"></div>
			</div>

			<div class="usageDivContent" style="height:160px;padding:5px;margin:0px;text-align:left;position:relative;display:block;width:100%;visibility:visible;">

				<div style="float:left;width:300px;visibility:visible;display:block;height:155px;" id="groupblock"  class="groupblock div_scroll linesquare" align="left">
					<table cellpadding="0" cellspacing="0" border="0" width="100%" id="mouseEvent">
						<thead>
							<tr>
<%
	if( groupData != null && groupData.size() > 0 )
	{
		if( groupNames != null && groupNames.size() > 0 )
		{
			for (int i=0;i<groupNames.size();i++)
			{
				String ColName = (String) groupNames.get(i);
				String mappingName = iniObj.getValue("Dashboard_TableColumn_mapping",ColName);
				if( ColName.equalsIgnoreCase("Usage") )
					ColName = "Usage  %";
				String thBorderRight="border-top:0;border-left:0;border-right:0;";
				if(i<groupNames.size()-1)
					thBorderRight="border-top:0;border-left:0;";

%>
								<td class="layer_headbg padding4" style="<%=thBorderRight%>" >&nbsp;<%=mappingName%></td>
<%
			}
		}
%>
							</tr>
						</thead>
<%
	
		Iterator itr = groupData.keySet().iterator();
		String colorName = iniObj.getValue(compType,"Application_group_color");
		StringTokenizer ct = new StringTokenizer(colorName,",");
		Vector v_color = new Vector();
		while(ct.hasMoreTokens())
		{
			String color = (String) ct.nextToken();
			v_color.add(color);
		}

		int i = 0;
		while(itr.hasNext())
		{
%>
						<tbody>
<%	
			String groupColor = "";
			String groupInfo = (String) itr.next();
			if( v_color !=null && i<v_color.size() )
			{
				groupColor = (String) v_color.get(i);
			}
			else
			{
				i = 0;
				groupColor = (String) v_color.get(i);
			}
			String applycolor="";
			if( groupColor.startsWith("#") )
			{
				applycolor=groupColor;
				groupColor = com.egurkha.util.StringUtils.replace(groupColor, "#", "$");
			}
			String dispInfo = com.egurkha.util.StringUtils.replace(groupInfo, "+", "");
			if( dispInfo.startsWith("-") )
			{
				dispInfo = "";
			}
			String url = response.encodeURL("/final/monitor/XenBlocks.jsp?");
			String usageGraphUrl = response.encodeURL("/final/monitor/XenBlocks.jsp?count=groupUsage");
			usageGraphUrl+="&hostName="+compName+"&compType="+compType+"&tab=Application";
			usageGraphUrl+="&category="+dispInfo+"&color="+groupColor+"&formserver="+isFormServer+"&screenWidth="+screenWidth+"&screenHeight="+screenHeight;
			String colorid=applycolor;
			String trBackground="eg_lightlight";
			String position="odd";
			if(i%2==0)
			{
				trBackground="eg_whitebg";
				position="even";
			}
%>
						<tr  id="selectedtrgroup<%=i%>" >

<%
		
			if( dispInfo.equalsIgnoreCase("All") )
			{
%>
								<td valign="middle" class="padding4" nowrap>
									<div style="float:left;margin:0px;padding:0px;width:12px;height:12px;background-color:<%=colorid%>" class="linesquare_white" ><img src="/final/monitor/eg_images/spacer.gif" height="12" width="12" border="0"></div>
									<a class="eg_monlink" href="javascript:void(0);" onclick="javascript:gotoMachines('<%=url+"gname="+dispInfo+"&count=group&fromComparision=false&hostName="+compName+"&compType="+compType+"&tab=Application&formserver="+isFormServer+"&screenWidth="+screenWidth+"&screenHeight="+screenHeight%>');"><span class="eg_75bold" style="padding-left:4px"><%=dispInfo%></span></a>
								</td>
<%
			}
			else
			{
%>
								<td valign="middle"  class="padding4">
									<div style="float:left;margin:0px;padding:0px;width:12px;height:12px;background-color:<%=colorid%>" class="eg_blankspace linesquare_white" width="12" height="12"><img src="/final/monitor/eg_images/spacer.gif" height="12" width="12"></div>
									<a class="eg_monlink" href="javascript:void(0);" onclick="javascript:gotoMachines('<%=url+"gname="+dispInfo+"&count=group&fromComparision=false&hostName="+compName+"&compType="+compType+"&tab=Application&formserver="+isFormServer+"&screenWidth="+screenWidth+"&screenHeight="+screenHeight%>');"><span class="eg_75bold" style="padding-left:4px"><%=dispInfo%></span></a>
								</td>

			
<%
			}
			group = (Vector) groupData.get(groupInfo);
			if( group != null && group.size() > 0 )
			{
				
				for (int k=0;k<group.size();k++)
				{
					String groupVal = (String) group.get(k);
					String measVal = MeasureDisplay.formatValue(groupVal);
					if( measVal.equals("0") )
						measVal = "-";
					if( measVal.startsWith("-") )
					{
						measVal = "-";
					}
%>
								<td align="center"  class="padding4 mouse"  onclick="javascript:changeDesktopUsage('<%=usageGraphUrl%>','<%=i%>');"><%=measVal%></td>
<%
				}
			}
%>
							</tr>
						</tbody>
<%
		i++;
		}
%>
				</table>
<%
	}
	else
	{
%>
						<table style="border-bottom-width:0px;" class="eg_whitebg" align="center">
							<tr>
								<td align="center" valign="middle" colspan="7" style="text-align:center;border:0px;" height="130" class="eg_75bold">
									<center><img align="center" src="/final/monitor/eg_images/<%=monitor_Skin%>/exclamation-icon.gif"> <br> <egui:intnl text="monitor.dashboard.No Data Available"/>!</center>
								</td>
							</tr>
						</table>
<%
	}
%>
					
				</div>
				<div style="margin:0px;float:left;border:0px solid orange;visibility:visible;display:block;text-align:center" id="usageDiv">
					<jsp:include page="<%="XenBlocks.jsp?category=All&xennext=No&count=groupUsage&hostName="+compName+"&compType="+compType+"&tab=Application&color=$9A32CD&formserver="+isFormServer+"&screenWidth="+screenWidth+"&screenHeight="+screenHeight%>" />
				</div>
			</div>
		</div>

		<div class="clr" style="height:6px;width:100%;"></div>

		<div class="ctrDiv linesquare" style="margin:0px;padding:0px;visibility:visible:display:block" >
			<div class="ctrDivHead eg_medium" style="display:block;visibility:visible;height:20px;width:100%;border-top:0px;border-right:0px;border-left:0px;">
				<div class="eg_8bold" style="float:left;padding:2px"><egui:intnl text="monitor.dashboard.Desktop Controller service"/></div>
				<div style="float:right;padding:2px 10px 2px 4px;"><img src="/final/images/<%=monitor_Skin%>/icon_slideup.png" class="mouse minimize3"></div>
			</div>

			<div class="ctrDivContent eg_whitebg" style="height:160px;padding:5px;margin:0px;text-align:left;position:relative;display:block;visibility:visible;">
				<div class="controllerBlockDiv div_scroll linesquare" style="width:800px;margin:0px;padding:0px;visibility:visible;display:block;" >
					<table  id="myTableData" cellspacing="0" border="0" align="left" width="100%" bordercolor="green">
						<thead>
							<tr>
<%
	String serviceHeaders = (String) iniObj.getValue(compType,tab+"_controller_header");
	if( serviceHeaders != null )
	{
		headerList = new ArrayList();
		StringTokenizer st1 = new StringTokenizer(serviceHeaders,",");
		while(st1.hasMoreTokens())
		{
			String header = (String) st1.nextToken();
			String messy = MeasureDisplay.getMeasureForColumn("XDCtxBrokerTest",header);
			String mappingheader = iniObj.getValue("Dashboard_TableColumn_mapping",header);

			if( mappingheader != null && !mappingheader.equals("") )
			{
				header = mappingheader;
			}

			headerList.add(header);

			String thBorderRight="border-top:0;border-left:0;border-right:0;";
			int tokCount=st1.countTokens();
			if(tokCount>0)
				thBorderRight="border-top:0;border-left:0;";

%>
								<td class="layer_headbg padding4" style="<%=thBorderRight%>"  nowrap><egui:intnl text="<%=header%>" /></td>
<%
			
		}
	}
%>
							</tr>
						</thead>
						<tbody>
<%
	String serviceVal = (String) iniObj.getValue(compType,tab+"_controller");
	if( serviceVal != null  )
	{
		statusList = (ArrayList) ddcHelper.getControllerServiceDetails(compType,tab,"XDSiteTest",portNo,allMsmtHosts,hostName);

		StringTokenizer st = new StringTokenizer(serviceVal,",");
		int j = 0;
		while(st.hasMoreTokens())
		{
			String testname = (String)st.nextToken();
			ArrayList valueList = (ArrayList) ddcHelper.getControllerServiceDetails(compType,tab,testname,portNo,allMsmtHosts,hostName);
			String msmtHostForCutOFVector = "";
			if ( allMsmtHosts != null )
				msmtHostForCutOFVector = (String)allMsmtHosts.get(testname);
			Vector temp_infos=dashboardDAO.getDescriptorsForTest(compName,compType,testname,tab);
			String info_for_cutofffactor="";
			if(temp_infos!=null && !temp_infos.isEmpty())
				info_for_cutofffactor=(String)temp_infos.get(0);
			boolean isTestExceededCutOffFactor = false;
			if(UseCutOffFactor!=null && !UseCutOffFactor.equals("") && UseCutOffFactor.equalsIgnoreCase("Yes"))
			{
				if(egDashboard.isTestHasCutOffFactor(testname))
				{
					isTestExceededCutOffFactor = dashboardDAO.isTestExceededCutOffFactor(compType,hostName,portNo,sid,testname,msmtHostForCutOFVector,info_for_cutofffactor);
				}
			}
			String status = "";
			String statusVal = "";
			if( statusList != null && statusList.size() > 0 )
			{
				status = (String) statusList.get(j);
			}
			if( status != null && !status.equals("") )
			{
				statusVal = MeasureDisplay.formatValue(status);
			}
			String img = "";
			String title="Down";
			if( statusVal.equals("1") )
			{
				img = "up-arrow.png";
				title="Up";
			}
			else
			{
				img = "down-arrow.png";
			}

			String trBackground="eg_lightlight";
			if(j%2==0)
			{
				trBackground="eg_whitebg";
			}

%>
							<tr class="<%=trBackground%>" >
								<td class="padding4"><egui:intnl test="<%=testname%>" /></td>
								<td class="padding4" align="center"><img src="/final/monitor/eg_images/<%=img%>" title="<%=title%>"></td>
<%
			j++;
			if( valueList != null && valueList.size() > 0 && !isTestExceededCutOffFactor )
			{
				for (int i=0;i<valueList.size();i++)
				{
					String val = (String)valueList.get(i);
					String measVal = MeasureDisplay.formatValue(val);
					if( measVal.startsWith("-") )
					{
						measVal = "-";
					}
%>
								<td class="padding4" align="center" ><%=measVal%></td>
<%
				}
			}
			else if ( headerList != null && headerList.size() > 0 )
			{
				for (int i=0;i<headerList.size()-2;i++)
				{
%>
								<td class="padding4" align="center" >-</td>
<%
				}
			}
%>
							</tr>
<%
		}
	}
%>
						</tbody>
					</table>
				</div>
						<!-- </td> -->
						<!-- <td>
							<div style="width:400px;height:100;border:0px;padding-left:18px;padding-top:10px;">
								<table border="0" cellpadding="0" cellspacing="0" style="width:400px;height:100;" class="exampleData">
									<thead>
										<tr>
											<th width="200"><egui:intnl text="monitor.dashboard.Category"/></th>
											<th width="200"><egui:intnl text="monitor.dashboard.Number"/></th>
										</tr>
									</thead>
									<tbody>
<%
	String iniEntry = "";
	Vector LoginandOutDetails = new Vector();
	if ( isFormServer != null && ( isFormServer.equalsIgnoreCase("Yes") || isFormServer.equalsIgnoreCase("true") ))
	{
		iniEntry = (String) iniObj.getValue(compType,tab+"_LoginDisconnect_form");
	}
	else
	{
		iniEntry = (String) iniObj.getValue(compType,tab+"_LoginDisconnect");
	}

	if ( iniEntry != null && iniEntry.length() > 0 )
	{
		StringTokenizer stok = new StringTokenizer(iniEntry,",");
		while(stok.hasMoreTokens())
		{
			String testWithMeasures = (String) stok.nextToken();
			String test = testWithMeasures.substring(0,testWithMeasures.indexOf(":"));
			String measure = testWithMeasures.substring(testWithMeasures.indexOf(":")+1);
			String mappingName = iniObj.getValue("Dashboard_TableColumn_mapping",measure);
			String mHost = "";
			if ( allMsmtHosts != null )
			{
				mHost = (String) allMsmtHosts.get(test);
			}
			Vector valueVector=dashboardDAO.getCurrentForAllInfos(hostName,portNo,test,measure,mHost,"",false,"");
			if ( valueVector != null && valueVector.size() > 0 )
			{
				for(int i=0;i<valueVector.size();i=i+2)
				{
					String data = (String)valueVector.get(i);
					String value = (String)valueVector.get(i+1);
					String measVal = MeasureDisplay.formatValue(value);
					String messy = MeasureDisplay.getMeasureForColumn(test,measure);
					String iniVar = test + ":" + messy + ":" + measVal;
					String iniValue = egUI.getValue("Measure_value_display",iniVar);
					if( iniValue != null && iniValue.length() > 0)
					{
						measVal=iniValue;
					}
					if(measVal.startsWith("-"))
					{
						measVal="-";
					}
%>
									<tr>
											<td class="eg_whitebg" align="left"><%=mappingName%></td>
											<td class="eg_whitebg" align="left"><%=measVal%></td>
									</tr>
<%
				}
			}
		}
	}
%>
									</tbody>
								</table>
							</div>
						</td> -->
					<!-- </tr>
				</table>
			</div> -->
			</div>
		</div>

		<div class="clr" style="height:6px;width:100%;"></div>

		<div class="infraDiv linesquare" style="margin:0px;padding:0px;visibility:visible:display:block" >
			<div class="infraDivHead eg_medium" style="display:block;visibility:visible;height:20px;width:100%;border-top:0px;border-right:0px;border-left:0px;">
				<div class="eg_8bold" style="float:left;padding:2px"><egui:intnl text="monitor.dashboard.Infrastructure"/></div>
				<div style="float:right;padding:2px 10px 2px 4px;"><img src="/final/images/<%=monitor_Skin%>/icon_slideup.png" class="mouse minimize4"></div>
			</div>

			<div class="infraDivContent eg_whitebg" style="height:130px;padding:4px;margin:0px;text-align:left;position:relative;display:block;visibility:visible;">

				<div class="hostConnectionDiv div_scroll linesquare" style="width:400px;float:left;height:125px;" align="left">
					<table cellpadding="0" cellspacing="0" border="0" width="100%">
						<thead>
							<tr>
								<td class="layer_headbg padding4" style="border-top:0;border-right:0;border-left:0;"><egui:intnl text="monitor.Host"/></td>
								<td class="layer_headbg padding4" style="border-top:0;border-right:0;"><egui:intnl text="monitor.Connection"/></td>
							</tr>
						</thead>
						<tbody>

<%
	String mHost = "";
	if( allMsmtHosts != null )
	{
		mHost = (String) allMsmtHosts.get("XDControllerTest");
	}
	Vector brokerConnection = null;
	String hostVal = (String) iniObj.getValue(compType,tab+"_Infra_host");
	if( hostVal != null && hostVal.length() > 0 )
	{
		brokerConnection = new Vector();
		StringTokenizer strtok = new StringTokenizer(hostVal,",");
		while(strtok.hasMoreTokens())
		{
			String testWithMeasure = (String) strtok.nextToken();
			String test = testWithMeasure.substring(0,testWithMeasure.indexOf(":"));
			String measure = testWithMeasure.substring(testWithMeasure.indexOf(":")+1);
			brokerConnection = dashboardDAO.getCurrentForAllInfos(hostName,portNo,test,measure,mHost,"",false,"");
			Vector infosForCutOffFactorHyper = new Vector();
			if(UseCutOffFactor!=null && !UseCutOffFactor.equals("") && UseCutOffFactor.equalsIgnoreCase("Yes"))
			{
				if(egDashboard.isTestHasCutOffFactor(test))
				{
					if( brokerConnection != null && brokerConnection.size() > 0 )
					{
						for (int d=0;d<brokerConnection.size();d++)
						{
							boolean isTestExceededCutOffFactor = dashboardDAO.isTestExceededCutOffFactor(compType,hostName,portNo,test,mHost,(String)brokerConnection.get(d));
							if( !isTestExceededCutOffFactor )
							{
								infosForCutOffFactorHyper.add(brokerConnection.get(d));
							}
						}
					}
				}
				if( infosForCutOffFactorHyper != null  ) 
				{
					brokerConnection=infosForCutOffFactorHyper;
				}
			}
			if( brokerConnection != null && brokerConnection.size() > 0 )
			{
				for (int i=0;i<brokerConnection.size();i=i+2)
				{
					String brok = (String)brokerConnection.get(i);
					
					String trBackground="eg_lightlight";
					if(i%2==0)
					{
						trBackground="eg_whitebg";
					}

%>
							<tr class="<%=trBackground%>" >
								<td class="padding4"><%=com.egurkha.util.StringUtils.replace(brok, "+", "")%></td>
<%
					String img = "";
					String displayNum = (String)brokerConnection.get(i+1);
					String measVal = MeasureDisplay.formatValue(displayNum);
					String messy = MeasureDisplay.getMeasureForColumn(test,measure);
					String iniVar = test + ":" + messy + ":" + measVal;
					String iniValue = egUI.getValue("Measure_value_display",iniVar);
					String title="Off";
					if( iniValue != null && iniValue.length() > 0)
					{
						measVal = iniValue;
					}
					if(measVal.equalsIgnoreCase("On"))
					{
						img = "right_small.png";
						title="On";
					}
					else
					{
						img = "-";
					}
%>
								<td class="padding4" ><img class="png" src="/final/images/<%=img%>" title="<%=title%>"> </td>
							</tr>
<%
				}
			}
			else
			{
%>
								<td class="padding4" >-</td>
								<td class="padding4">-</td>
							</tr>
<%
			}
		}
	}
%>
						</tbody>
					</table>
				</div>

				<div class="controllerStateDiv div_scroll linesquare" style="width:400px;float:right;height:125px;" align="left">
					<table border="0"  cellspacing="0" cellpadding="0" width="100%" >
						<thead>
							<tr>
								<td class="layer_headbg padding4" style="border-top:0;border-right:0;border-left:0;"><egui:intnl text="monitor.dashboard.Controller"/>
								</td>
								<td class="layer_headbg padding4" style="border-top:0;border-right:0;"><egui:intnl text="monitor.dashboard.State"/></td>
							</tr>
						</thead>
						<tbody>
<%
	Vector ctrlData = null;
	String ctrlVal = (String)iniObj.getValue(compType,tab+"_Infra_controller");
	boolean isFactor = true;
	if( ctrlVal != null && ctrlVal.length() > 0 )
	{
		ctrlData=new Vector();
		StringTokenizer stoken=new StringTokenizer(ctrlVal,",");
		while(stoken.hasMoreTokens())
		{
			String testWithMeasure=(String)stoken.nextToken();
			String test=testWithMeasure.substring(0,testWithMeasure.indexOf(":"));
			if(enabledTests!=null && !enabledTests.contains(test))
				continue;
			String measure=testWithMeasure.substring(testWithMeasure.indexOf(":")+1);
			Vector valueVector=dashboardDAO.getCurrentForAllInfos(hostName,portNo,test,measure,mHost,"",false,"");
			if(valueVector!=null && valueVector.size() >0)
			{
				for(int i=0;i<valueVector.size();i=i+2)
				{
					String ctrlName=(String)valueVector.get(i);
					String state=(String)valueVector.get(i+1);
					String measVal=MeasureDisplay.formatValue(state);
					String messy = MeasureDisplay.getMeasureForColumn(test,measure);
					String iniVar=test+":"+messy+":"+measVal;
					String iniValue=egUI.getValue("Measure_value_display",iniVar);
					boolean isTestExceededCutOffFactor = false;
					if(UseCutOffFactor!=null && !UseCutOffFactor.equals("") && UseCutOffFactor.equalsIgnoreCase("Yes"))
					{
						if(egDashboard.isTestHasCutOffFactor(test))
						{
							isTestExceededCutOffFactor = dashboardDAO.isTestExceededCutOffFactor(compType,hostName,portNo,sid,test,mHost,ctrlName);
							if ( isTestExceededCutOffFactor )
								continue;
						}
					}
					isFactor = false;
					if( iniValue != null && iniValue.length() > 0)
					{
						measVal=iniValue;
					}
					if(measVal.startsWith("-"))
					{
						measVal="-";
					}
					String trBackground="eg_lightlight";
					if(i%2==0)
					{
						trBackground="eg_whitebg";
					}

%>
							<tr class="<%=trBackground%>" >
								<td class="padding4"><%=com.egurkha.util.StringUtils.replace(ctrlName, "+", "")%></td>
								<td class="padding4"><%=measVal%></td>
							</tr>
<%
					
				}
			}
			if( valueVector == null || valueVector.isEmpty() || isFactor )
			{
%>
							<tr class="eg_whitebg" >
								<td class="padding4">&nbsp;-</td>
								<td class="padding4">&nbsp;-</td>
							</tr>
<%
			}
		}
	}
%>
						</tbody>
					</table>
				</div>
			</div>
		</div>
	</div>

<!-- Infrastructure Block ends-->
	<div id="MachineListDiv" style="visibility:hidden;display:none;border:0px solid red;valign:top;padding:10px" valign="top">
		<div id="backDiv" style="width:100%;border:0px solid green"></div>
	</div>

	<div id="macdetails" class="macdetails" style="visibility:hidden;display:none;width:100%;border:0px solid green;padding:10px" border="0" valign="top"> 
	</div>

</div>
<%
	if(request.getQueryString()!=null)
	{
		if(session!=null)
		{
			session.setAttribute("monitorLastSession","/final/servlet/com.eg.EgDashboardController?from=list&"+request.getQueryString()+"&comptype="+request.getParameter("compType")+"&host="+request.getParameter("hostName")+"&tab="+tab+"&graphType=&toDashBoardLayer=true");
			session.setAttribute("monitorDashBrdLastCompName",request.getParameter("hostName"));
		}
	}
	else
	{
		if(session!=null)
		{
			session.setAttribute("monitorLastSession","/final/servlet/com.eg.EgDashboardController?from=list&tab="+tab+"&toDashBoardLayer=true");
			session.setAttribute("monitorDashBrdLastCompName",request.getParameter("hostName"));
		}
	}
}
catch(Throwable e)
{
	e.printStackTrace();
}
%>