<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ include file = "EgServerDashboardTracker.jsp"%>
<%@ page errorPage = "EgProbsM.jsp"%>
<%@ page import="com.egurkha.monitor.*"%>
<%@ page import="com.eg.*"%>
<%@ page import="java.text.*"%>
<%@ page import="com.egurkha.util.DateTimeTokenizer"%>
<%@ page import = "com.eg.EgSpecsInfo"%>
<%@ page import="com.egurkha.util.MathUtils"%>
<%@ page import="egurkha.reporter.ErUtils"%>
<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>
<%
try
{
	String ua = request.getHeader( "User-Agent" );
	boolean isFirefox = ( ua != null && ua.indexOf( "Firefox/" ) != -1 );
	boolean isMSIE = ( ua != null && ua.indexOf( "MSIE" ) != -1 );
	boolean isIE6=( ua != null && ua.indexOf("MSIE 6.0") != -1 );
	String s_iniFile_dir=EgInstallInfo.getInstallDir()+"/manager/config/";
	IniFile iniObj=new IniFile(s_iniFile_dir+"eg_serverdashboard.ini");
	IniFile uiIni=new IniFile(s_iniFile_dir+"eg_ui.ini");

	EgTablesInfo tablesInfo=new EgTablesInfo("manager");
	EgSpecsInfo specsInfo = new EgSpecsInfo("manager");
	EgDbInfo dbInfo=new EgDbInfo("manager");
	EgTesterInfo testerInfo=new EgTesterInfo("manager");

	EgMappingInfo mappingInfo=new EgMappingInfo(trackerLanguage);
	EgMeasureGraphExt measureGraphInfo = new EgMeasureGraphExt();
	DateTimeTokenizer dtd = new DateTimeTokenizer();

	EgServerDashboardModel  egDashboard=new  EgServerDashboardModel();
	EgServerDashboardMGraphModel measureGraph=new EgServerDashboardMGraphModel();
	EgFusionChartUtil fusionChart=new EgFusionChartUtil();

	MonitorDAOFactory monitorDaoFactory = MonitorDAOFactory.getInstance();
	EgServerDashBoardDAO dashboardDAO=monitorDaoFactory.getServerDashBoardDAO();

	ErUtils  erutils=new  ErUtils();
	IniUI ui = IniUI.getInstance();

	SimpleDateFormat sf1=new SimpleDateFormat("dd/MM/yyyy");
	SimpleDateFormat testTableDateFmt=new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
	EgServerDashboardMGraphModel mGraphModel=new EgServerDashboardMGraphModel();

	String subject=request.getParameter("subject");
	String tab=request.getParameter("tab");
	String selectedJDBC=request.getParameter("selectedInfo");

	EgUserRole userRole = u_ser.getUserRole();
	long perm = EgUserPermission.ADMIN;
	boolean adminPermission = userRole.hasAdminRole(perm);

	if(tab==null)
		tab="Application";

	String compName=request.getParameter("hostName");
	String compType=request.getParameter("compType");
	String subsystem=request.getParameter("subsystem");
	String graphType=request.getParameter("graphType");

	boolean isfromSuper = session.getAttribute("fromSuper") != null && session.getAttribute("fromSuper").toString().equalsIgnoreCase("yes");

	String hostName="";
	String portNo="";
	String sid="";
	String startTime="";
	String endTime="";
	String startHour="";
	String endHour="";
	String startMin="";
	String endMin="";
	String startDateTime="";
	String endDateTime="";
	String state="";
	String info="";
	String msmtHost="";
	String test="";
	String measure="";
	String site=request.getParameter("site");

	if(site==null || site.trim().length()==0)
		site="NULL";

	if(compName!=null && !compName.equals(""))
	{
		StringTokenizer st=new StringTokenizer(compName,":");
		if(st.hasMoreTokens())
			hostName=st.nextToken();

		if(st.hasMoreTokens())
			portNo=st.nextToken();

		if(st.hasMoreTokens())
			sid=st.nextToken();
	}

	String screenWidth=request.getParameter("screenWidth");
	String screenHeight=request.getParameter("screenHeight");
	double screenWidthInDouble=1024.0;
	double screenHeightInDouble=768.0;
	if(screenWidth!=null && !screenWidth.equals(""))
	{
		screenWidthInDouble=Double.parseDouble(screenWidth);
	}
	if(screenHeight!=null && !screenHeight.equals(""))
	{
		screenHeightInDouble=Double.parseDouble(screenHeight);
	}
	Hashtable allMsmtHosts=dashboardDAO.getMsmtHostForAllTest(compName,compType,tab);
	Hashtable allTestInfos=dashboardDAO.getDescriptorsForAllTest(compName,compType,tab);

	ArrayList enabledTests=specsInfo.getEnabledTests(compType,false);

	subject=compType;

	egDashboard.setSubject(subject);

	Vector runningtests=dashboardDAO.getRunningTestsForServer(compName,compType,tab);
	runningtests.retainAll(enabledTests);

	String defaultMGraphDuration=iniObj.getValue("Default_MeasureGraph_Duration","duration");
	String UseCutOffFactor=iniObj.getValue("Dashboard_Settings","UseCutOffFactor");
	state=egDashboard.getServerState(hostName,compType,tab);

	String s_disabledBlocks=iniObj.getValue("Disabled_blocks",tab+"_Overview");
	Vector disabledBlocks=egDashboard.getTokensAsVector(s_disabledBlocks,",");

	java.util.Date endDate=new java.util.Date();
	java.util.Date startDate=new java.util.Date(endDate.getTime()-(60*60*1000));

	String defaultSparklineDuration=iniObj.getValue("Default_SparkLineGraph_Duration","duration");
	if(defaultSparklineDuration==null || (defaultSparklineDuration!=null && defaultSparklineDuration.equals("")))
		defaultSparklineDuration="1 hour";
	String sparkLineStartTime="";
	String sparkLineEndTime="";
	String sparkLineStartHour="";
	String sparkLineEndHour="";
	Vector sparkLineTimes=egDashboard.getStartEndDateTimeForMeasure(defaultSparklineDuration);
	if(sparkLineTimes!=null && sparkLineTimes.size()>=4)
	{
		sparkLineStartTime=(String)sparkLineTimes.get(0);
		sparkLineEndTime=(String)sparkLineTimes.get(1);
		sparkLineStartHour=(String)sparkLineTimes.get(2);
		sparkLineEndHour=(String)sparkLineTimes.get(3);
	}
	int count=0;
	double defaultDialGraphWidth=270;  // default dial graph width for calculation
	double defaultDialGraphHeight=130;  // default dial graph height for calculation
	double dialGraphWidth=240;  
	double dialGraphHeight=140;
	double dialGraphWidthTo1024PxInPercent=defaultDialGraphWidth/1000;
	double dialGraphHeightToDefaultWidthInPercent=defaultDialGraphHeight/defaultDialGraphWidth;
	double defaultGauageOuterRadius=90; // default dial graph width for calculation
	double defaultGaugeXPos=123; // default dial graph Gauge X position for calculation
	double defaultGaugeYPos=106; // default dial graph Gauge Y position for calculation 
	String gauageOuterRadius="75";
	String gaugeXPos="97";
	String gaugeYPos="106";
	String gaugeInnerRadius="45";
	if(screenWidthInDouble>0)
	{
		dialGraphWidth=screenWidthInDouble*dialGraphWidthTo1024PxInPercent;
		dialGraphWidth=MathUtils.round(dialGraphWidth,0);
		dialGraphHeight=dialGraphWidth*dialGraphHeightToDefaultWidthInPercent;
		dialGraphHeight=MathUtils.round(dialGraphHeight,0);
		double gauageOutRadiusToDefaultWidthInPercent=defaultGauageOuterRadius/defaultDialGraphWidth;
		double gauageOuterRadiusInDouble=dialGraphWidth*gauageOutRadiusToDefaultWidthInPercent;
		gauageOuterRadius=erutils.round(gauageOuterRadiusInDouble,0);
		gaugeInnerRadius=erutils.round((gauageOuterRadiusInDouble-30),0);
		double gauageXPosToDefaultWidthInPercent=defaultGaugeXPos/defaultDialGraphWidth;
		double gauageYPosToDefaultHeightInPercent=defaultGaugeYPos/defaultDialGraphHeight;
		double gaugeXPosInDouble=dialGraphWidth*gauageXPosToDefaultWidthInPercent;
		gaugeXPos=erutils.round(gaugeXPosInDouble,0);
		double gaugeYPosInDouble=dialGraphHeight*gauageYPosToDefaultHeightInPercent;
		gaugeYPos=erutils.round(gaugeYPosInDouble,0);
	}
	double defaultPieGraphWidth=240; // default pie graph width for calculation
	double defaultPieGraphHeight=130;  // default pie graph height for calculation
	double defaultPieRadius=50;  // default pie graph radius for calculation
	double pieGraphWidth=240;
	double pieGraphHeight=130;
	String pieRadius="40"; //default radius for 240 width
	double pieGraphWidthTo1024PxInPercent=defaultPieGraphWidth/1024;
	pieGraphWidth=screenWidthInDouble*pieGraphWidthTo1024PxInPercent;
	pieGraphWidth=MathUtils.round(pieGraphWidth,0);
	double pieGraphHeightToDefaultWidthInPercent=defaultPieGraphHeight/defaultPieGraphWidth;
	pieGraphHeight=pieGraphWidth*pieGraphHeightToDefaultWidthInPercent;
	pieGraphHeight=MathUtils.round(pieGraphHeight,0);
	double pieRadiusToDefaultWidthInPercent=defaultPieRadius/defaultPieGraphWidth;
	double pieRadiusInDouble=pieGraphWidth*pieRadiusToDefaultWidthInPercent;
	pieRadius=erutils.round(pieRadiusInDouble,0);
	if(subsystem!=null && subsystem.equalsIgnoreCase("JVM"))
	{
		boolean isJVMThreadStackTrace=false;
		if(graphType!=null && graphType.equals("jvmthreadstacktrace"))
			isJVMThreadStackTrace=true;
		if(!isJVMThreadStackTrace)
		{
			graphType="JVM";
%>
<div style="margin-left:5px;margin-top:5px;float:left;width:98%; border:0px solid green">
	<table width="100%" border="0"  cellpadding="0" cellspacing="0" bordercolor="blue">
		<tr>
			<td height="20px"  align="center" class="eg_75bold gradient_header"><egui:intnl text="monitor.dashboard.Weblogic RockitJVM Details"/></td>
		</tr>
		<tr>
			<td class="vmborder">
<%
			HashMap hsObj=new HashMap();
			Vector healthChartAttributes=new Vector();
			double freeHeapSizeMeasure=0.0;
			double usedHeapSizeMeasure=0.0;
			boolean isTestHas_CutOffFactor=false;
			msmtHost=(String)allMsmtHosts.get("WLJVMRockitTest");
			String usedHeapSizeDBColumn=dbInfo.getColumnForMeasure("WLJVMRockitTest","Used_heap");
			String freeHeapSizeDBColumn=dbInfo.getColumnForMeasure("WLJVMRockitTest","Free_heap");
			String usedHeapSize=dashboardDAO.getCurrentMeasure(hostName,portNo,"+","WLJVMRockitTest",usedHeapSizeDBColumn,msmtHost);
			String freeHeapSize=dashboardDAO.getCurrentMeasure(hostName,portNo,"+","WLJVMRockitTest",freeHeapSizeDBColumn,msmtHost);
			if((usedHeapSize!=null && !usedHeapSize.equals("") && !usedHeapSize.equalsIgnoreCase("null")) && (freeHeapSize!=null && !freeHeapSize.equals("") && !freeHeapSize.equalsIgnoreCase("null")))
			{
				usedHeapSizeMeasure=Double.parseDouble(usedHeapSize);
				freeHeapSizeMeasure=Double.parseDouble(freeHeapSize);
				double totalHeapSizeMeasure=usedHeapSizeMeasure+freeHeapSizeMeasure;
				usedHeapSizeMeasure=((usedHeapSizeMeasure/totalHeapSizeMeasure)*100);
				freeHeapSizeMeasure=((freeHeapSizeMeasure/totalHeapSizeMeasure)*100);
				usedHeapSize=erutils.round(usedHeapSizeMeasure,2);
				freeHeapSize=erutils.round(freeHeapSizeMeasure,2);
				if((usedHeapSize!=null && !usedHeapSize.equals("") && !usedHeapSize.equalsIgnoreCase("null")))
				{
					hsObj.put("Used_heap",usedHeapSize);
					hsObj.put("Free_heap",freeHeapSize);
				}
			}
			if(UseCutOffFactor!=null && !UseCutOffFactor.equals("") && UseCutOffFactor.equalsIgnoreCase("Yes"))
			{
				if(egDashboard.isTestHasCutOffFactor("WLJVMRockitTest"))
				{
					boolean isTestExceededCutOffFactor=dashboardDAO.isTestExceededCutOffFactor(compType,hostName,portNo,sid,"WLJVMRockitTest",msmtHost,"+");
					if(isTestExceededCutOffFactor)
					{
						isTestHas_CutOffFactor=true;
					}
				}
			}
			healthChartAttributes.add("palette='2'");
			healthChartAttributes.add("decimals='2'");
			healthChartAttributes.add("enableRotation='1'");
			healthChartAttributes.add("bgColor='99CCFF,FFFFFF'");
			healthChartAttributes.add("bgAlpha='0,0'");
			healthChartAttributes.add("bgRatio='0,100'");
			healthChartAttributes.add("bgAngle='360'");
			healthChartAttributes.add("showBorder='0'");
			healthChartAttributes.add("startingAngle='80'");
			healthChartAttributes.add("chartLeftMargin ='20'");
			healthChartAttributes.add("chartTopMargin ='10'");
			healthChartAttributes.add("chartBottomMargin ='10'");
			healthChartAttributes.add("chartRightMargin ='10'");
			healthChartAttributes.add("showToolTipShadow ='1'");
			healthChartAttributes.add("pieSliceDepth='7'");
			healthChartAttributes.add("numberSuffix='%'");
			healthChartAttributes.add("showToolTipShadow ='1'");
			healthChartAttributes.add("pieOuterFaceAlpha  ='75'");
			healthChartAttributes.add("pieInnerFaceAlpha  ='100'");
			healthChartAttributes.add("pieYScale  ='60'");
			healthChartAttributes.add("smartLineColor  ='000000'");
			healthChartAttributes.add("smartLabelClearance  ='2'");
			healthChartAttributes.add("captionPadding  ='0'");
			healthChartAttributes.add("bgSWFAlpha  ='0'");
			healthChartAttributes.add("enableSmartLabels='1'");
			healthChartAttributes.add("pieRadius='"+pieRadius+"'");
			healthChartAttributes.add("labelDistance='6'");
			healthChartAttributes.add("isSmartLineSlanted='1'");
			healthChartAttributes.add("exportEnabled='0'");
			healthChartAttributes.add("exportAction='download'");
			healthChartAttributes.add("exportAtClient='0'");
			healthChartAttributes.add("exportHandler='/final/FusionCharts/jsp/FCExporter.jsp'");
			String xmlData="";
			if(hsObj!=null && !hsObj.isEmpty())
				xmlData=fusionChart.getXMLForHeap(hsObj,healthChartAttributes,"Overview");
			if(xmlData!=null && !xmlData.equals("") && !isTestHas_CutOffFactor)
			{
%>
							<div style="float:left;border:0px green solid;padding:2px;width:200px;height:140px">
				<table  cellpadding="2" cellspacing="0" border="0" bordercolor="red" >
					<tr>
						<td class="eg_75bold" align="center"><egui:intnl text="monitor.dashboard.Heap Usage"/></td>
					</tr>
					<tr>
						<td>
							<table cellpadding="0" cellspacing="0"  border="0" bordercolor="green">
								<tr>
									<td align="center" valign="top" >
										<!-- <object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" codebase="//fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0" width="<%=pieGraphWidth%>" height="<%=pieGraphHeight%>" id="StackedColumn3D" flashVars="&dataXML=<chart><set value='1'/><set value='2'/></chart>" >
										<param name="FlashVars" value="&dataXML=<%=xmlData%>&chartWidth=<%=pieGraphWidth%>&chartHeight=<%=pieGraphHeight%>">
										<param name="quality" value="high" />
										<param name="movie" value="/final/FusionCharts/swf/Pie3D.swf" />
										<param name="WMode" value="Transparent">
										<embed wmode="transparent" src="/final/FusionCharts/swf/Pie3D.swf" flashVars="&dataXML=<%=xmlData%>" quality="high" width="<%=pieGraphWidth%>" height="<%=pieGraphHeight%>" name="Column3D" type="application/x-shockwave-flash" pluginspage="//www.macromedia.com/go/getflashplayer" />
										</object> -->

										<div id="chartPieContainer"  style="height:100%;"></div>
										<script type="text/javascript">
											if  ( FusionCharts( "myPieChartId" ) )
													FusionCharts( "myPieChartId" ).dispose();
											var myChart = new FusionCharts( "/final/FusionCharts/swf/Pie3D.swf","myPieChartId", "<%=pieGraphWidth%>", "<%=pieGraphHeight%>","0","1");
											myChart.setXMLData("<%=xmlData%>");
											myChart.render("chartPieContainer");
										</script>
									</td>
								</tr>
							</table>
						</td>
					</tr>
				</table>
							</div>
<%
			}
			else
			{
%>
							<div style="float:left;border:0px green solid;padding:2px;width:200px;height:140px">
				<table  cellpadding="0" cellspacing="0" border="0">
					<tr>
						<td class="eg_75bold jvm_he  ader" align="center"><egui:intnl text="monitor.dashboard.Heap Status"/></td>
					</tr>
					<tr>
						<td>
							<table width="100%" cellpadding="0" cellspacing="0" border="0" >
								<tr>
									<td align="center" valign="top" >
										<img src="/final/monitor/eg_images/<%=monitor_Skin%>/exclamation-icon.gif"> <br > <egui:intnl text="monitor.dashboard.No measures available"/>!
									</td>
								</tr>
							</table>
						</td>
					</tr>
				</table>
							</div>

<%
			}
			String jvmDetailsGaugeTestMeasures=iniObj.getValue(subject,"Application_JVM_Weblogic_JVMGaugeMetrics");
			String isThresholdNeed=iniObj.getValue("Dashboard_Settings","ApplyThreshold");
			StringTokenizer stkGaugeTestMeasures=new StringTokenizer(jvmDetailsGaugeTestMeasures,",");
			int jvmTDCount=1;
			while(stkGaugeTestMeasures.hasMoreTokens())
			{
				String testWithMeasure=stkGaugeTestMeasures.nextToken();
				String jvmDetailsTest=testWithMeasure.substring(0,testWithMeasure.indexOf(":"));
				String jvmDetailsMeasure=testWithMeasure.substring(testWithMeasure.indexOf(":")+1,testWithMeasure.length());
				Vector chartAttributesForJVM=new Vector();
				chartAttributesForJVM.add("palette='2'");
				chartAttributesForJVM.add("bgColor='FFFFFF'");
				chartAttributesForJVM.add("bgAlpha='0'");
				chartAttributesForJVM.add("upperLimit='100'");
				chartAttributesForJVM.add("lowerLimit='0'");
				chartAttributesForJVM.add("baseFontColor='333333'");
				chartAttributesForJVM.add("majorTMNumber='6'");
				chartAttributesForJVM.add("majorTMColor='FFFFFF'");
				chartAttributesForJVM.add("majorTMHeight='8'");
				chartAttributesForJVM.add("minorTMNumber='6'");
				chartAttributesForJVM.add("minorTMColor='FFFFFF'");
				chartAttributesForJVM.add("minorTMHeight='3'");
				chartAttributesForJVM.add("majorTMThickness='1'");
				chartAttributesForJVM.add("markerRadius='30'");
				chartAttributesForJVM.add("showGaugeBorder='0'");
				chartAttributesForJVM.add("toolTipBgColor='ffffff'");
				chartAttributesForJVM.add("toolTipBorderColor='555555'");
				chartAttributesForJVM.add("gaugeOuterRadius='"+gauageOuterRadius+"'");
				chartAttributesForJVM.add("gaugeInnerRadius='"+gaugeInnerRadius+"'");
				chartAttributesForJVM.add("gaugeOriginX='"+gaugeXPos+"'");
				chartAttributesForJVM.add("gaugeOriginY='"+gaugeYPos+"'");
				chartAttributesForJVM.add("annRenderDelay='1'");
				chartAttributesForJVM.add("gaugeFillRatio='3'");
				chartAttributesForJVM.add("pivotRadius='6'");
				chartAttributesForJVM.add("showPivotBorder='1'");
				chartAttributesForJVM.add("pivotBorderColor='000000'");
				chartAttributesForJVM.add("pivotBorderThickness='5'");
				chartAttributesForJVM.add("pivotFillMix='FFFFFF,000000'");
				chartAttributesForJVM.add("pivotFillType='linear'");
				chartAttributesForJVM.add("showShadow='0'");
				chartAttributesForJVM.add("showBorder='0'");
				chartAttributesForJVM.add("baseFontSize='8.75'");
				chartAttributesForJVM.add("chartLeftMargin='35'");
				chartAttributesForJVM.add("chartRightMargin='35'");
				chartAttributesForJVM.add("chartTopMargin='25'");
				chartAttributesForJVM.add("chartBottomMargin='25'");
				chartAttributesForJVM.add("  gaugeFillMix='{dark-10},{light-70},{dark-10}'  tickValueDistance='10' ");
				chartAttributesForJVM.add("clickURL='javascript:dialOnclick(&apos;customizedDial"+jvmTDCount+"&apos;)'");
				String xmlForJVM=fusionChart.getXMLDataForCustomziedGauge(jvmDetailsTest,jvmDetailsMeasure,compType,hostName,portNo,"","NULL",msmtHost,isThresholdNeed,chartAttributesForJVM,"000000",true,"",true,dialGraphWidth,dialGraphHeight,defaultDialGraphWidth,defaultDialGraphHeight);
				String layerName=dashboardDAO.getLayerForTest(compType,jvmDetailsTest,jvmDetailsMeasure);
				String compTypeForAlarm=compType;
				if(layerName!=null && (layerName.equalsIgnoreCase("HOST") || layerName.equalsIgnoreCase("NETWORK") || layerName.equalsIgnoreCase("TCP")))
					compTypeForAlarm="Host_system";
				String info_for_cutOffFastor="";
				isTestHas_CutOffFactor=false;
				Vector temp_info=dashboardDAO.getDescriptorsForTest(compName,compType,jvmDetailsTest,tab);
				if(temp_info!=null && !temp_info.isEmpty())
					info_for_cutOffFastor=(String)temp_info.get(0);
				if(UseCutOffFactor!=null && !UseCutOffFactor.equals("") && UseCutOffFactor.equalsIgnoreCase("Yes"))
				{
					if(egDashboard.isTestHasCutOffFactor(jvmDetailsTest))
					{
						boolean isTestExceededCutOffFactor=dashboardDAO.isTestExceededCutOffFactor(compType,hostName,portNo,sid,jvmDetailsTest,msmtHost,info_for_cutOffFastor);
						if(isTestExceededCutOffFactor)
						{
							isTestHas_CutOffFactor=true;
						}
					}
				}
				String measureState=egDashboard.getTestMeasureState(compName,compTypeForAlarm,layerName,jvmDetailsTest+"-+",jvmDetailsMeasure);
				String layerPageUrl=response.encodeURL("/final/monitor/egDashBoardLayers.jsp?")+"qctr=2&fromPage=componentList&host="+compName+"&comptype="+compType+"&layer="+layerName+"&site="+site+"&test="+jvmDetailsTest+"-+&tstate="+measureState+"&msmt_host=";
				if(xmlForJVM!=null && !xmlForJVM.equals("") && !isTestHas_CutOffFactor)
				{
%>
							<div style="float:left;border:0px green solid;padding:2px;">
								<table cellpadding="0" cellspacing="0" border="0">
					<tr>
						<td class="eg_75bold jv  m_header"  align="center" ><%=mappingInfo.getMeasureDescription(jvmDetailsTest,jvmDetailsMeasure)%>(<%=tablesInfo.getUnitForMeasure(jvmDetailsTest,jvmDetailsMeasure)%>)</td>
					</tr>
					<tr>
									<td align="center" valign="middle" >
											<!-- <object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" codebase="//fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0" width="<%=dialGraphWidth%>" height="<%=dialGraphHeight%>" id="StackedColumn3D" >
											<param name="movie" value="/final/FusionCharts/swf/AngularGauge.swf" />
											<param name="FlashVars" value="&dataXML=<%=xmlForJVM%>&chartWidth=<%=dialGraphWidth%>&chartHeight=<%=dialGraphHeight%>">
											<param name="quality" value="high" />
											<param name="WMode" value="Transparent">
											<embed wmode="transparent" src="/final/FusionCharts/swf/AngularGauge.swf" flashVars="&dataXML=<%=xmlForJVM%>" quality="high" width="<%=dialGraphWidth%>" height="<%=dialGraphHeight%>" name="Column3D" type="application/x-shockwave-flash" pluginspage="//www.macromedia.com/go/getflashplayer" />
										</object> -->

										<div id="chartAngularGaugeContainer<%=jvmTDCount%>"  style="height:100%;"></div>
										<script type="text/javascript">
											if  ( FusionCharts( "myAngularGaugeChartId<%=jvmTDCount%>" ) )
													FusionCharts( "myAngularGaugeChartId<%=jvmTDCount%>" ).dispose();
											var myChart = new FusionCharts( "/final/FusionCharts/swf/AngularGauge.swf","myAngularGaugeChartId<%=jvmTDCount%>", "<%=dialGraphWidth%>", "<%=dialGraphHeight%>","0","1");
											myChart.setXMLData("<%=xmlForJVM%>");
											myChart.render("chartAngularGaugeContainer<%=jvmTDCount%>");
										</script>

										<input type="hidden" id="customizedDial<%=jvmTDCount%>" value="<%=layerPageUrl%>"/>
									</td>
								</tr>
							</table>
							</div>
<%
				}
				else
				{
%>
							<div style="float:left;border:0px green solid;padding:2px;width:200px;height:140px">
				<table   cellpadding="0" cellspacing="0" border="0">
					<tr>
						<td class="eg_75bold jvm_he  ader"  align="center" ><%=mappingInfo.getMeasureDescription(jvmDetailsTest,jvmDetailsMeasure)%>(<%=tablesInfo.getUnitForMeasure(jvmDetailsTest,jvmDetailsMeasure)%>)</td>
					</tr>
					<tr>
									<td align="center" valign="middle">
										<img src="/final/monitor/eg_images/<%=monitor_Skin%>/exclamation-icon.gif"> <br > <egui:intnl text="monitor.dashboard.No measures available"/>!
									</td>
								</tr>
							</table>
							</div>
<%
				}
				jvmTDCount++;
			}
		//	String jvmmeasureValue="";
			String digitalChartMeasures=iniObj.getValue(subject,"Application_JVM_Weblogic_DigitalGraphs");
			if(digitalChartMeasures!=null && !digitalChartMeasures.equals(""))
			{
				String jvmmeasureValue="";
				int digitalChartWidth=100;
				StringTokenizer stkDigitalCharts=new StringTokenizer(digitalChartMeasures,",");
				while(stkDigitalCharts.hasMoreTokens())
				{
					String tempTestMeasure=stkDigitalCharts.nextToken();
					test=tempTestMeasure.substring(0,tempTestMeasure.indexOf(":"));
					measure=tempTestMeasure.substring(tempTestMeasure.indexOf(":")+1);

					msmtHost=(String)allMsmtHosts.get(test);

					String measureMapping=iniObj.getValue("Dashboard_Digital_mapping",test+":"+measure);

					if(measureMapping==null || measureMapping.trim().equals(""))
						measureMapping=mappingInfo.getMeasureDescription(test,measure);
					String measureForDB=dbInfo.getColumnForMeasure(test,measure);
					Vector topInfoWithMeasure=dashboardDAO.getCurrentForTop(hostName,portNo,test,measureForDB,msmtHost,true,1,true);
					String topInfo="";
					isTestHas_CutOffFactor=false;
					if(UseCutOffFactor!=null && !UseCutOffFactor.equals("") && UseCutOffFactor.equalsIgnoreCase("Yes"))
					{
						if(topInfoWithMeasure!=null && topInfoWithMeasure.size()>=2)
						{
							topInfo=(String)topInfoWithMeasure.get(0);
							jvmmeasureValue=(String)topInfoWithMeasure.get(1);
							if(egDashboard.isTestHasCutOffFactor(test))
							{
								boolean isTestExceededCutOffFactor=dashboardDAO.isTestExceededCutOffFactor(compType,hostName,portNo,test,msmtHost,topInfo);
								if(isTestExceededCutOffFactor)
									isTestHas_CutOffFactor=true;
							}
						}
					}
					boolean isMeasureAvailable=true;
					if(!testerInfo.getAllowNegativeValues(test,measure) && (jvmmeasureValue!=null && (jvmmeasureValue.startsWith("-") || jvmmeasureValue.trim().equals("") || jvmmeasureValue.equalsIgnoreCase("null"))))
						isMeasureAvailable=false;

					if(jvmmeasureValue!=null && jvmmeasureValue.length()>0)
						digitalChartWidth=(jvmmeasureValue.length()>7)?(jvmmeasureValue.length()*18):100;

					String layerName=dashboardDAO.getLayerForTest(compType,test,measure);
					String compTypeForAlarm=compType;
					if(layerName!=null && (layerName.equalsIgnoreCase("HOST") || layerName.equalsIgnoreCase("NETWORK") || layerName.equalsIgnoreCase("TCP")))
						compTypeForAlarm="Host_system";

					String measureState=egDashboard.getTestMeasureState(compName,compTypeForAlarm,layerName,test+"-+"+topInfo,measure);
					String layerPageUrl=response.encodeURL("/final/monitor/egDashBoardLayers.jsp?")+"qctr=2&fromPage=componentList&host="+compName+"&comptype="+compType+"&layer="+layerName+"&site="+site+"&test="+test+"-+"+topInfo+"&tstate="+measureState+"&msmt_host=";

					String toolTipmeasureValue=jvmmeasureValue;
					if(isMeasureAvailable && !isTestHas_CutOffFactor)
					{
%>
							<div style="float:left;border:0px green solid;width:200px;height:140px;padding:2px">
				<table width="100%" height="100%" cellpadding="0" cellspacing="0" border="0" bordercolor="red">
					<tr>
						<td align="center" valign="middle">
											<span class="eg_75bold" alt="<%=toolTipmeasureValue%>" title="<%=toolTipmeasureValue%>"><%=measureMapping%>(<%=tablesInfo.getUnitForMeasure(test,measure)%>)</span><br><br>
							<a href="javascript:void();" class="eg_monlink" onclick="javascript:goToLayerModel('<%=layerPageUrl%>');" border="0">
								<img border="0" src="../servlet/com.egurkha.monitor.egDigitalChart?width=<%=digitalChartWidth%>&height=40&value=<%=jvmmeasureValue%>&forecolor=00FF00&background=999999&background1=999999" title="<%="("+toolTipmeasureValue+")"%>" />
							</a>
						</td>
					</tr>
				</table>
							</div>
<%
					}
					else
					{
%>
							<div style="float:left;border:0px green solid;width:200px;height:140px;padding:2px">
				<table width="100%" height="100%" cellpadding="0" cellspacing="0" border="0" bordercolor="red">
					<tr>
						<td align="center" valign="middle">
											<span class="eg_75bold" alt="<%=toolTipmeasureValue%>" title="<%=toolTipmeasureValue%>"><%=measureMapping%>(<%=tablesInfo.getUnitForMeasure(test,measure)%>)</span><br><br>
							<img src="/final/monitor/eg_images/<%=monitor_Skin%>/exclamation-icon.gif"> <br > <egui:intnl text="monitor.dashboard.No measures available"/>!
						</td>
					</tr>
				</table>
							</div>
<%
					}
				jvmTDCount++;
				}
			}
%>
			</td>
		</tr>
	</table>
</div>
<%
			String tableTitleForThreadSummary=iniObj.getValue("Dashboard_Comparison_TableTitle","JvmThreadTest");
			if(tableTitleForThreadSummary!=null && tableTitleForThreadSummary.equals(""))
			{
				tableTitleForThreadSummary=mappingInfo.getTestDescription("JvmThreadTest");
			}
%>
<div style="margin-left:5px;margin-top:5px;float:left;width:98%;height:140px;border:0px solid #2B7F82">
	<table width="100%" border="0"  cellpadding="0" cellspacing="0">
		<tr>
			<td height="20px"  align="center" class="eg_75bold gradient_header"><egui:intnl text="monitor.dashboard.Weblogic JVM Details"/></td>
		</tr>
		<tr>
			<td valign="top" class="vmborder">

<%
			Vector runingTestList=egDashboard.getRunningTest(compName,compType,"Application");
			if(runingTestList!=null && runingTestList.contains("WebLogicTest"))
			{
				HashMap MeasureValues=new HashMap();
				Vector jvmHeapAttributes=new Vector();
				freeHeapSizeMeasure=0.0;
				double totalHeapSizeMeasure=0.0;
				msmtHost=(String)allMsmtHosts.get("WebLogicTest");
				String totalHeapSizeDBColumn=dbInfo.getColumnForMeasure("WebLogicTest","Total_heap_size");
				freeHeapSizeDBColumn=dbInfo.getColumnForMeasure("WebLogicTest","Free_heap_size");
				String totalHeapSize=dashboardDAO.getCurrentMeasure(hostName,portNo,"+","WebLogicTest",totalHeapSizeDBColumn,msmtHost);
				freeHeapSize=dashboardDAO.getCurrentMeasure(hostName,portNo,"+","WebLogicTest",freeHeapSizeDBColumn,msmtHost);
				if((totalHeapSize!=null && !totalHeapSize.equals("") && !totalHeapSize.equalsIgnoreCase("null")) && (freeHeapSize!=null && !freeHeapSize.equals("") && !freeHeapSize.equalsIgnoreCase("null")))
				{
					totalHeapSizeMeasure=Double.parseDouble(totalHeapSize);
					freeHeapSizeMeasure=Double.parseDouble(freeHeapSize);
					usedHeapSizeMeasure=totalHeapSizeMeasure-freeHeapSizeMeasure;
					usedHeapSizeMeasure=((usedHeapSizeMeasure/totalHeapSizeMeasure)*100);
					freeHeapSizeMeasure=((freeHeapSizeMeasure/totalHeapSizeMeasure)*100);
					usedHeapSize=erutils.round(usedHeapSizeMeasure,2);
					freeHeapSize=erutils.round(freeHeapSizeMeasure,2);
					if((usedHeapSize!=null && !usedHeapSize.equals("") && !usedHeapSize.equalsIgnoreCase("null")))
					{
						MeasureValues.put("Used_heap",usedHeapSize);
						MeasureValues.put("Free_heap",freeHeapSize);
					}
				}
				if(UseCutOffFactor!=null && !UseCutOffFactor.equals("") && UseCutOffFactor.equalsIgnoreCase("Yes"))
				{
					if(egDashboard.isTestHasCutOffFactor("WebLogicTest"))
					{
						boolean isTestExceededCutOffFactor=dashboardDAO.isTestExceededCutOffFactor(compType,hostName,portNo,sid,"WebLogicTest",msmtHost,"+");
						if(isTestExceededCutOffFactor)
						{
							isTestHas_CutOffFactor=true;
						}
					}
				}
				jvmHeapAttributes.add("palette='2'");
				jvmHeapAttributes.add("decimals='2'");
				jvmHeapAttributes.add("enableRotation='1'");
				jvmHeapAttributes.add("bgColor='99CCFF,FFFFFF'");
				jvmHeapAttributes.add("bgAlpha='0,0'");
				jvmHeapAttributes.add("bgRatio='0,100'");
				jvmHeapAttributes.add("bgAngle='360'");
				jvmHeapAttributes.add("showBorder='0'");
				jvmHeapAttributes.add("startingAngle='80'");
				jvmHeapAttributes.add("chartLeftMargin ='20'");
				jvmHeapAttributes.add("chartTopMargin ='10'");
				jvmHeapAttributes.add("chartBottomMargin ='10'");
				jvmHeapAttributes.add("chartRightMargin ='10'");
				jvmHeapAttributes.add("showToolTipShadow ='1'");
				jvmHeapAttributes.add("pieSliceDepth='7'");
				jvmHeapAttributes.add("numberSuffix='%'");
				jvmHeapAttributes.add("showToolTipShadow ='1'");
				jvmHeapAttributes.add("pieOuterFaceAlpha  ='75'");
				jvmHeapAttributes.add("pieInnerFaceAlpha  ='100'");
				jvmHeapAttributes.add("pieYScale  ='60'");
				jvmHeapAttributes.add("smartLineColor  ='000000'");
				jvmHeapAttributes.add("smartLabelClearance  ='2'");
				jvmHeapAttributes.add("captionPadding  ='0'");
				jvmHeapAttributes.add("bgSWFAlpha  ='0'");
				jvmHeapAttributes.add("enableSmartLabels='1'");
				jvmHeapAttributes.add("pieRadius='"+pieRadius+"'");
				jvmHeapAttributes.add("labelDistance='6'");
				jvmHeapAttributes.add("isSmartLineSlanted='1'");
				jvmHeapAttributes.add("exportEnabled='0'");
				jvmHeapAttributes.add("exportAction='download'");
				jvmHeapAttributes.add("exportAtClient='0'");
				jvmHeapAttributes.add("exportHandler='/final/FusionCharts/jsp/FCExporter.jsp'");
				String xmlDataForJVMHeap="";
				if(MeasureValues!=null && !MeasureValues.isEmpty())
					xmlDataForJVMHeap=fusionChart.getXMLForHeap(MeasureValues,jvmHeapAttributes,"Overview");
%>
				<div style="float:left;border:0px green solid;width:200px;height:140px;padding:2px">
					<table   cellpadding="0" cellspacing="0" border="0">
						<tr>
							<td class="eg_75bold jvm_he  ader"  align="center" ><egui:intnl text='monitor.dashboard.Weblogic JVM Heap Usage'/></td>
						</tr>
						<tr>

<%
				if(xmlDataForJVMHeap!=null && !xmlDataForJVMHeap.equals("") && !isTestHas_CutOffFactor)
				{
%>

						<td align="left" valign="middle">
							<!-- <object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" codebase="//fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0" width="<%=pieGraphWidth%>" height="<%=pieGraphHeight%>" id="StackedColumn3D" flashVars="&dataXML=<chart><set value='1'/><set value='2'/></chart>" >
								<param name="FlashVars" value="&dataXML=<%=xmlDataForJVMHeap%>&chartWidth=<%=pieGraphWidth%>&chartHeight=<%=pieGraphHeight%>">
								<param name="quality" value="high" />
								<param name="movie" value="/final/FusionCharts/swf/Pie3D.swf" />
								<param name="WMode" value="Transparent">
								<embed wmode="transparent" src="/final/FusionCharts/swf/Pie3D.swf" flashVars="&dataXML=<%=xmlDataForJVMHeap%>" quality="high" width="<%=pieGraphWidth%>" height="<%=pieGraphHeight%>" name="Column3D" type="application/x-shockwave-flash" pluginspage="//www.macromedia.com/go/getflashplayer" />
							</object> -->

							<div id="chart2Pie3DContainer"  style="height:100%;"></div>
							<script type="text/javascript">
								if  ( FusionCharts( "my2Pie3DChartId" ) )
										FusionCharts( "my2Pie3DChartId" ).dispose();
								var myChart = new FusionCharts( "/final/FusionCharts/swf/Pie3D.swf","my2Pie3DChartId", "<%=pieGraphWidth%>", "<%=pieGraphHeight%>","0","1");
								myChart.setXMLData("<%=xmlDataForJVMHeap%>");
								myChart.render("chart2Pie3DContainer");
							</script>
						</td>

<%
				}
				else
				{

%>
						<td align="center" valign="middle" height="125px">
							<img class="png" src="/final/monitor/eg_images/<%=monitor_Skin%>/icon_exclamation.png"><br> <egui:intnl text="monitor.dashboard.No Measures Available"/>!
						</td>
<%
				}
%>
						</tr>
					</table>
				</div>
<%
			}
			else
			{
%>
				<div style="float:left;border:0px green solid;width:200px;height:140px;padding:2px">
					<table   cellpadding="0" cellspacing="0" border="0">
						<tr>
							<td align="center" valign="middle" height="150px">
								<img class="png" src="/final/monitor/eg_images/<%=monitor_Skin%>/icon_exclamation.png"><br> <egui:intnl text="monitor.dashboard.No Measures Available"/>!
						</td>
						</tr>
					</table>
				</div>
<%
			}
			String jvmDetailsTest="JvmCpuTest";
			String jvmDetailsMeasure="Jvm_cpu_utilization";
			Vector chartAttributesForJVM=new Vector();
			chartAttributesForJVM.add("palette='2'");
			chartAttributesForJVM.add("bgColor='FFFFFF'");
			chartAttributesForJVM.add("bgAlpha='0'");
			chartAttributesForJVM.add("upperLimit='100'");
			chartAttributesForJVM.add("lowerLimit='0'");
			chartAttributesForJVM.add("baseFontColor='333333'");
			chartAttributesForJVM.add("majorTMNumber='6'");
			chartAttributesForJVM.add("majorTMColor='FFFFFF'");
			chartAttributesForJVM.add("majorTMHeight='8'");
			chartAttributesForJVM.add("minorTMNumber='6'");
			chartAttributesForJVM.add("minorTMColor='FFFFFF'");
			chartAttributesForJVM.add("minorTMHeight='3'");
			chartAttributesForJVM.add("majorTMThickness='1'");
			chartAttributesForJVM.add("markerRadius='30'");
			chartAttributesForJVM.add("showGaugeBorder='0'");
			chartAttributesForJVM.add("toolTipBgColor='ffffff'");
			chartAttributesForJVM.add("toolTipBorderColor='555555'");
			chartAttributesForJVM.add("gaugeOuterRadius='"+gauageOuterRadius+"'");
			chartAttributesForJVM.add("gaugeInnerRadius='"+gaugeInnerRadius+"'");
			chartAttributesForJVM.add("gaugeOriginX='"+gaugeXPos+"'");
			chartAttributesForJVM.add("gaugeOriginY='"+gaugeYPos+"'");
			chartAttributesForJVM.add("annRenderDelay='1'");
			chartAttributesForJVM.add("gaugeFillRatio='3'");
			chartAttributesForJVM.add("pivotRadius='6'");
			chartAttributesForJVM.add("showPivotBorder='1'");
			chartAttributesForJVM.add("pivotBorderColor='000000'");
			chartAttributesForJVM.add("pivotBorderThickness='5'");
			chartAttributesForJVM.add("pivotFillMix='FFFFFF,000000'");
			chartAttributesForJVM.add("pivotFillType='linear'");
			chartAttributesForJVM.add("showShadow='0'");
			chartAttributesForJVM.add("showBorder='0'");
			chartAttributesForJVM.add("baseFontSize='8.75'");
			chartAttributesForJVM.add("chartLeftMargin='35'");
			chartAttributesForJVM.add("chartRightMargin='35'");
			chartAttributesForJVM.add("chartTopMargin='25'");
			chartAttributesForJVM.add("chartBottomMargin='25'");
			chartAttributesForJVM.add("  gaugeFillMix='{dark-10},{light-70},{dark-10}'  tickValueDistance='10' ");	chartAttributesForJVM.add("clickURL='javascript:dialOnclick(&apos;customizedDial"+jvmTDCount+"&apos;)'");
			msmtHost=(String)allMsmtHosts.get(jvmDetailsTest);
			String xmlForJVM=fusionChart.getXMLDataForCustomziedGauge(jvmDetailsTest,jvmDetailsMeasure,compType,hostName,portNo,"","NULL",msmtHost,isThresholdNeed,chartAttributesForJVM,"000000",true,"",true,dialGraphWidth,dialGraphHeight,defaultDialGraphWidth,defaultDialGraphHeight);
%>
				<div style="float:left;border:0px green solid;padding:2px">
					<table cellpadding="0" cellspacing="0" border="0" height="100%">
						<tr>
<%
			isTestHas_CutOffFactor=false;
			if(UseCutOffFactor!=null && !UseCutOffFactor.equals("") && UseCutOffFactor.equalsIgnoreCase("Yes"))
			{
				if(egDashboard.isTestHasCutOffFactor(jvmDetailsTest))
				{
					boolean isTestExceededCutOffFactor=dashboardDAO.isTestExceededCutOffFactor(compType,hostName,portNo,sid,jvmDetailsTest,msmtHost,"+");
					if(isTestExceededCutOffFactor)
					{
						isTestHas_CutOffFactor=true;
					}
				}
			}
			if(xmlForJVM!=null && !xmlForJVM.equals("") && !isTestHas_CutOffFactor)
			{
				String layerName=dashboardDAO.getLayerForTest(compType,jvmDetailsTest,jvmDetailsMeasure);
				String compTypeForAlarm=compType;
				if(layerName!=null && (layerName.equalsIgnoreCase("HOST") || layerName.equalsIgnoreCase("NETWORK") || layerName.equalsIgnoreCase("TCP")))
					compTypeForAlarm="Host_system";

				String measureState=egDashboard.getTestMeasureState(compName,compTypeForAlarm,layerName,jvmDetailsTest+"-+",jvmDetailsMeasure);
				String layerPageUrl=response.encodeURL("/final/monitor/egDashBoardLayers.jsp?")+"qctr=2&fromPage=componentList&host="+compName+"&comptype="+compType+"&layer="+layerName+"&site="+site+"&test="+jvmDetailsTest+"-+&tstate="+measureState+"&msmt_host=";
%>

							<td align="center" valign="top" ><span class="eg_75bold"><egui:intnl text='monitor.dashboard.JVM CPU Utilization'/></span><br><br>

							<!-- <object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" codebase="//fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0" width="<%=dialGraphWidth%>" height="<%=dialGraphHeight%>" id="StackedColumn3D" >
							<param name="movie" value="/final/FusionCharts/swf/AngularGauge.swf" />
							<param name="FlashVars" value="&dataXML=<%=xmlForJVM%>&chartWidth=<%=dialGraphWidth%>&chartHeight=<%=dialGraphHeight%>">
							<param name="quality" value="high" />
							<param name="WMode" value="Transparent">
							<embed wmode="transparent" src="/final/FusionCharts/swf/AngularGauge.swf" flashVars="&dataXML=<%=xmlForJVM%>" quality="high" width="<%=dialGraphWidth%>" height="<%=dialGraphHeight%>" name="Column3D" type="application/x-shockwave-flash" pluginspage="//www.macromedia.com/go/getflashplayer" />
							</object> -->

							<div id="chart2AngularGaugeContainer<%=jvmTDCount%>"  style="height:100%;"></div>
							<script type="text/javascript">
								if  ( FusionCharts( "my2AngularGaugeChartId<%=jvmTDCount%>" ) )
										FusionCharts( "my2AngularGaugeChartId<%=jvmTDCount%>" ).dispose();
								var myChart = new FusionCharts( "/final/FusionCharts/swf/AngularGauge.swf","my2AngularGaugeChartId<%=jvmTDCount%>", "<%=dialGraphWidth%>", "<%=dialGraphHeight%>","0","1");
								myChart.setXMLData("<%=xmlForJVM%>");
								myChart.render("chart2AngularGaugeContainer<%=jvmTDCount%>");
							</script>

							<input type="hidden" id="customizedDial<%=jvmTDCount%>" value="<%=layerPageUrl%>"/>
						</td>
<%
			}
			else
			{
%>
							<td align="center" valign="top" ><span class="eg_75bold"><egui:intnl text='monitor.dashboard.JVM CPU Utilization'/></span><br><br>
										<img src="/final/monitor/eg_images/<%=monitor_Skin%>/exclamation-icon.gif"> <br > <egui:intnl text="monitor.dashboard.No measures available"/>!
									</td>
<%
			}
%>
								</tr>
							</table>
				</div>
<%
			if(enabledTests.contains("JvmThreadTest"))
			{
				int tablescount=0;
				int imgcnt=0;
				int stColPos=1;
				int endColPos=0;
				int divCount=0;
				String weblogicJVMThreadSummary=iniObj.getValue(subject,"Application_JVM_Weblogic_Thread_Details");
				Vector measures=new Vector();
				String measuresForDB="";
				String testName="JvmThreadTest";
				String tableTitle=iniObj.getValue("Dashboard_Comparison_TableTitle",testName);
				if(tableTitle!=null && tableTitle.equals(""))
				{
					tableTitle=mappingInfo.getTestDescription(testName);
				}
				StringTokenizer stkMeas=new StringTokenizer(weblogicJVMThreadSummary,",");
				while(stkMeas.hasMoreTokens())
				{
					String tempStr=stkMeas.nextToken();
					if(tempStr!=null && tempStr.indexOf(":")!=-1)
					{
						testName=tempStr.substring(0,tempStr.indexOf(":"));
						String tempMeasure=tempStr.substring(tempStr.indexOf(":")+1);
						measures.add(tempMeasure);
						measuresForDB+=dbInfo.getColumnForMeasure(testName,tempMeasure);
						if(stkMeas.hasMoreTokens())
							measuresForDB+=",";
					}
				}

				msmtHost=(String)allMsmtHosts.get(testName);
				if(msmtHost==null)
					msmtHost="";

				Vector allValuesForInfo=dashboardDAO.getCurrentForAllInfos(hostName,portNo,testName,measuresForDB,msmtHost);
				allValuesForInfo.remove("+");
%>

				<div  style="float:left;width:400px;height:140px;padding:2px">
					<table cellpadding="2" cellspacing="0" border="0" width="100%">
						<tr>
							<td class="eg_75bold jvm_he  ader"  align="center" ><%=tableTitleForThreadSummary%></td>
						</tr>
						<tr>
							<td valign="top" width="100%" height="100%" class="tableborder_jvm">
								<div class="div_scroll" style="height:<%=pieGraphHeight%>px;border:0px solid #ff0000;" >
<%
				boolean isMeasureAvailable=false;
				if(allValuesForInfo!=null && !allValuesForInfo.isEmpty())
				{
%>
									<table border="0" bordercolor="red" cellpadding="2" cellspacing="0" width="100%" ><col width="55%"><col width="30%"><col width="15%">
<%
					for(int i=0;i<allValuesForInfo.size();i++)
					{
						measure=(String)measures.get(i);
						String measureForDB=dbInfo.getColumnForMeasure(testName,measure);
						String graph_values=dashboardDAO.getGraphValuesForSpark(hostName,"+",sid,testName,measureForDB,sparkLineStartTime+" "+sparkLineStartHour+":"+endDate.getMinutes()+":00",sparkLineEndTime+" "+sparkLineEndHour+":"+endDate.getMinutes()+":00");
						String urlForMaximize="/final/servlet/com.egurkha.monitor.EgDashboardTimelineMeasures?measure="+measureForDB+"&state="+state+"&starttime="+startTime+"&port="+portNo+"&comptype="+compType+"&mode=3D&site="+site+"&host="+hostName+"&monitorSkin="+monitor_Skin+"&msmt_host="+msmtHost+"&gtype=1&starthr="+startHour+"&test="+testName+"&info=*&layer=HOST&endtime="+endTime+"&endhr="+endHour+"&showRange=Range&gformat=graph&fromDashboard=true&timeline_compare="+defaultMGraphDuration+"&width=880&height=320&threshold=no&title=true&minmaxavgRequired=true&priority=TOP+-+10&module="+tab;

						String urlForSummary="/final/monitor/egSummary.jsp?hostName="+compName+"&compType="+compType+"&subsystem="+EgURLEncoder.encode("JVM Thread","UTF-8")+"&ddmeasure="+measure+"&fullview=true&subject="+subject+"&tab=Application";

						String summaryTitle="Thread Details";

						String value=(String)allValuesForInfo.get(i);
						if(value!=null && value.trim().equals(""))
						{
							value = "-";
						}
						else if(!testerInfo.getAllowNegativeValues(testName,measure) && (value!=null && value.startsWith("-")))
						{
							value=ui.getValue("MEASURE_LOOKUP",value);
							if(value!=null && value.indexOf(":")>0)
							{
								value=value.substring(value.indexOf(":")+1,value.length());
							}
						}
						if(UseCutOffFactor!=null && !UseCutOffFactor.equals("") && UseCutOffFactor.equalsIgnoreCase("Yes"))
						{
							if(egDashboard.isTestHasCutOffFactor(testName))
							{
								boolean isTestExceededCutOffFactor=dashboardDAO.isTestExceededCutOffFactor(compType,hostName,portNo,sid,testName,msmtHost,"+");
								if(isTestExceededCutOffFactor)
									continue;
							}
						}
						isMeasureAvailable=true;
						Vector spartLineAttributes=new Vector();
						spartLineAttributes.add("palette='2'");
						spartLineAttributes.add("setAdaptiveYMin='0'");
						spartLineAttributes.add("bgAlpha='0,0'");
						spartLineAttributes.add("showHighAnchor ='0'");
						spartLineAttributes.add("showLowAnchor ='0'");
						spartLineAttributes.add("showOpenValue ='0'");
						spartLineAttributes.add("showCloseValue ='0'");
						spartLineAttributes.add("showHighLowValue ='0'");
						spartLineAttributes.add("showOpenAnchor ='0'");
						spartLineAttributes.add("showCloseAnchor ='0'");
						spartLineAttributes.add("lineColor='"+iniObj.getValue("Dashboard_Graph_colors","Sparkline")+"'");
						spartLineAttributes.add("clickURL='javascript:sparklineOnclick(&apos;comparesparkurl"+testName+":"+measure+i+"&apos;)'");

						Vector sparkValues=egDashboard.getTokensAsVector(graph_values,",");

						String sparkXML=fusionChart.getXMLForSpark(sparkValues,spartLineAttributes);
%>
									<tr>
											<td >
										<a class="<%=(testName.equals("JvmThreadTest"))?"mouse eg_monlink":"eg_monlink"%>" onclick="javascript:<%=(testName.equals("JvmThreadTest"))?"loadPageinFrame('"+urlForSummary+"',event,'"+summaryTitle+"');":"void(0);"%>"><egui:intnl measure='<%=testName+":"+measure%>'/></a></td>
											<td >
<%
						if(graph_values!=null  && graph_values.length()>0)
						{
%>
											<!-- <object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" codebase="//fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0" width="100" height="20" id="StackedColumn3D" >
												<param name="movie" value="/final/FusionCharts/swf/SparkLine.swf" />
												<param name="FlashVars" value="&dataXML=<%=sparkXML%>&chartWidth=100&chartHeight=20">
												<param name="quality" value="high" />
												<param name="WMode" value="Transparent">
												<embed wmode="transparent" src="/final/FusionCharts/swf/SparkLine.swf" flashVars="&dataXML=<%=sparkXML%>" quality="high" width="100" height="20" name="Column3D" type="application/x-shockwave-flash" pluginspage="//www.macromedia.com/go/getflashplayer" />
											</object> -->

											<div id="chartSparkLineContainer<%=i%>"  style="height:100%;"></div>
											<script type="text/javascript">
												if  ( FusionCharts( "mySparkLineChartId<%=i%>" ) )
														FusionCharts( "mySparkLineChartId<%=i%>" ).dispose();
												var myChart = new FusionCharts( "/final/FusionCharts/swf/SparkLine.swf","mySparkLineChartId<%=i%>", "100", "20","0","1");
												myChart.setXMLData("<%=xmlForJVM%>");
												myChart.render("chartSparkLineContainer<%=i%>");
											</script>

											<input type="hidden" id="comparesparkurl<%=testName+":"+measure%><%=i%>"  value="<%=urlForMaximize%>"/>
<%
						}
						else
						{
%>
								&nbsp;
<%
						}
%>
										</td>
											<td ><%=value%></td>
									</tr>
<%
					}
%>
								</table>
<%
				}
				if(!isMeasureAvailable)
				{
%>
								<table border="0" cellpadding="0" cellspacing="0" width="100%" height="100%" class="tableborder_jvm">
									<tr>
											<td align="center" valign="middle"><img src="/final/monitor/eg_images/<%=monitor_Skin%>/exclamation-icon.gif"> <br > <egui:intnl text="monitor.dashboard.No measures available"/>!</td>
									</tr>
								</table>
<%
				}
%>

							</div>
						</td>
					</tr>
				</table>
</div>
<%
			}
			else
			{
%>
				<div style="float:left;border:0px green solid;width:500px;height:140px;padding:2px">
							<table width="100%" cellpadding="0" cellspacing="0" border="0" >
								<tr>
									<td align="center" valign="top" >
										<img src="/final/monitor/eg_images/<%=monitor_Skin%>/exclamation-icon.gif"> <br > <egui:intnl text="monitor.dashboard.No measures available"/>!
									</td>
								</tr>
							</table>
				</div>
<%
			}
%>
			</td>
		</tr>
	</table>
</div>
<!--   This div added for table end space  --------jaiwin -->
<div style="border:0px solid #ff0000;margin:1px;padding:0px;height:6px;width:700px" ><span class="eg_blankspace">&nbsp;</span></div>
<%
		}
		else if(isJVMThreadStackTrace)
		{
			String ddtest="JvmThreadTest";
			if(enabledTests!=null && enabledTests.contains(ddtest))
			{
				long HOUR=60*60*1000;
				long DAY=24*60*60*1000;
				SimpleDateFormat  sdf=new SimpleDateFormat("MM/dd/yyyy HH:mm");
				java.util.Date end_Date=new java.util.Date();
				java.util.Date start_Date=new java.util.Date(end_Date.getTime()-(HOUR));
				java.util.Date start_DateForDay=new java.util.Date(end_Date.getTime()-(DAY));

				String s_startTime=sdf.format(start_Date);
				String s_startTimeForDay=sdf.format(start_DateForDay);
				String s_endTime=sdf.format(end_Date);
				String s_startDate=s_startTime.substring(0,s_startTime.indexOf(" "));
				String s_endDate=s_endTime.substring(0,s_endTime.indexOf(" "));
				String tmp_startHr=s_startTime.substring(s_startTime.indexOf(" ")+1,s_startTime.length());
				String tmp_endHr=s_endTime.substring(s_endTime.indexOf(" ")+1,s_endTime.length());
				String s_startHr=tmp_startHr.substring(0,tmp_startHr.indexOf(":"));
				String s_startMin=tmp_startHr.substring(tmp_startHr.indexOf(":")+1,tmp_startHr.length());
				String s_endHr=tmp_endHr.substring(0,tmp_endHr.indexOf(":"));
				String  s_endMin=tmp_endHr.substring(tmp_endHr.indexOf(":")+1,tmp_endHr.length());

				boolean isRunningTest=false;
				if(runningtests!=null && runningtests.size()>0)
					isRunningTest= runningtests.contains(ddtest);
				
				String ddmeasure=request.getParameter("ddmeasure");
				String threadType=request.getParameter("threadType");

				if(threadType!=null && threadType.indexOf(":")>0)
					ddmeasure=threadType.substring(threadType.indexOf(":")+1);

				if(ddmeasure==null || ddmeasure.trim().equals(""))
					ddmeasure="Live_threads";


				String traceFontColor="eg_75bold";//:"whitefont";
				String traceFontColorBold="eg_75bold";//:"egwhite_75bold";
				msmtHost=(String)allMsmtHosts.get(ddtest);
				ArrayList al=egDashboard.getDiagnosisData("Application",compName,compType,ddtest,ddmeasure,s_startDate,s_startHr,s_startMin,s_endDate,s_endHr,s_endMin,msmtHost);
%>
<div id="summaryContentDiv" style="width:500px;height:200px;border:0px solid red">
<table border="0" cellspacing="0" cellpadding="0" style="padding-left:6px"><col width="250px"><col width="160px"><col width="160px"><col width="50%">
	<tr>
		<td style="padding:2px;padding-left:12px" class="<%=traceFontColorBold%>"><egui:intnl text="monitor.dashboard.Thread Analysis"/></td>
		<td style="padding:2px;" align=right class="<%=traceFontColorBold%>"><egui:intnl text="monitor.dashboard.Analysis By"/></td>
		<td style="padding:2px;" >
			<select id="threadType" onchange="javascript:changeSummary('Weblogic JVM');" style="width:160px">
<%
					String threadsummary=iniObj.getValue(subject,"Application_JVM_Weblogic_ThreadStackTrace_Summary");
					StringTokenizer str=new StringTokenizer(threadsummary,",");
					while(str.hasMoreTokens())
					{
						String option=(String)str.nextToken();
						if(threadType!=null && threadType.equals(option))
						{
%>
				<option value="<%=option%>" selected><egui:intnl  measure="<%=option%>"/></option>
<%
						}
						else
						{
%>
				<option value="<%=option%>"><egui:intnl  measure="<%=option%>"/></option>
<%
						}
					}
%>
			</select>
			</td>
<%
				
					if(msmtHost!=null)
					{
						EgAgentInfo agentInfo=new EgAgentInfo("manager");
						String 	modeVal=agentInfo.getParamValue("JvmThreadTest",hostName,portNo,"+",msmtHost,"mode");
						boolean isSnmpMode=(modeVal!=null && modeVal.equalsIgnoreCase("true"));
			
						SimpleDateFormat  sdf_dd=new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
						String s_startTime_DD=sdf_dd.format(start_Date);
						String Url=response.encodeURL("/final/monitor/ThreadDetails.jsp?")+"site=NULL&host="+com.eg.EgURLEncoder.encode(hostName,"UTF-8")+"&port="+portNo+"&test="+ddtest+"&msmt_host="+com.eg.EgURLEncoder.encode(msmtHost,"UTF-8")+"&flag=1&firsttime=true&sdate=&sdate="+com.eg.EgURLEncoder.encode(s_startTime_DD,"UTF-8")+"&s_measure="+com.eg.EgURLEncoder.encode(ddmeasure,"UTF-8")+"&s_st_time="+com.eg.EgURLEncoder.encode(s_startDate,"UTF-8")+"&s_en_time="+com.eg.EgURLEncoder.encode(s_endDate,"UTF-8")+"&s_st_hr="+com.eg.EgURLEncoder.encode(s_startHr,"UTF-8")+"&s_en_hr="+com.eg.EgURLEncoder.encode(s_endHr,"UTF-8")+"&s_st_min="+s_startMin+"&s_end_min="+s_endMin;
%>
		
		<td style="padding:2px" align="left" width="40%">
<%
						if(!isSnmpMode && (al!=null && al.size()>1))
						{
%>
					<a><img src="/final/monitor/eg_images/stack_trace.gif" border="0" style="text-align:bottom" onclick="javascript:loadPageinFrame('<%=Url%>',event,'Thread Analysis',true);"> </a> 
<%
						}
					}
%>	
		</td>
	</tr>
	<tr>
		<td colspan="4" style="padding:2px" align="center">
		<div id="weblogicThreadStacktrace" class="div_scroll tableBox" style="overflow-x:hidden;height:270px;width:900px;">
			<table border="0" cellpadding="2" cellspacing="0" width="100%" height="100%">
<%
				if(al!=null && al.size()>1)
				{
					String date=(String)al.get(0);
					ArrayList data=(ArrayList)al.get(1);
					for(int  j=0;j<data.size();j=j+1)
					{
						ArrayList all=(ArrayList)data.get(j);
						for(int j1=0;j1<all.size();j1=j1+12)
						{
							Vector samples=new Vector();
							Vector legendLabels=new  Vector();
							String  cpu_pct=erutils.round (Double.parseDouble((String)all.get(j1+4)),2);
							String  waited_pct=erutils.round (Double.parseDouble((String)all.get(j1+7)),2);
							String  blocked_pct=erutils.round (Double.parseDouble((String)all.get(j1+10)),2);
							double idle_pct=100-(Double.parseDouble(cpu_pct)+Double.parseDouble(waited_pct)+Double.parseDouble(blocked_pct));
							String idle_str=new Double(idle_pct).toString();
							idle_str=erutils.round(Double.parseDouble(idle_str),2);
							if(cpu_pct!=null && !cpu_pct.equals("0") && !cpu_pct.equals("0.0"))
							{
								samples.add(cpu_pct);
								legendLabels.add("CPU");
							}
							if(waited_pct!=null && !waited_pct.equals("0") && !waited_pct.equals("0.0"))
							{
								samples.add(waited_pct);
								legendLabels.add("Blocked ");
							}
							if(blocked_pct!=null && !blocked_pct.equals("0") && !blocked_pct.equals("0.0"))
							{
								samples.add(blocked_pct);
								legendLabels.add("Waited ");
							}
							if(idle_str!=null && !idle_str.equals("0") && !idle_str.equals("0.0"))
							{
								samples.add(idle_str);
								legendLabels.add("Idle ");
							}

							Vector threadChartAttributes=new Vector();

							threadChartAttributes.add("palette='3'");
							threadChartAttributes.add("decimals='1'");
							threadChartAttributes.add("enableRotation='0'");
							threadChartAttributes.add("bgColor='4F4F4F,EF8A62'");
							threadChartAttributes.add("bgAlpha='0,0'");
							threadChartAttributes.add("bgRatio='0,100'");
							threadChartAttributes.add("bgAngle='90'");
							threadChartAttributes.add("showBorder='0'");
							threadChartAttributes.add("startingAngle='10'");
							threadChartAttributes.add("baseFontColor='70595F'");
							threadChartAttributes.add("toolTipBgColor ='ffffff'");
							threadChartAttributes.add("baseFontSize ='9'");
							threadChartAttributes.add("baseFont ='arial'");
							threadChartAttributes.add("chartLeftMargin ='3'");
							threadChartAttributes.add("chartTopMargin ='0'");
							threadChartAttributes.add("chartBottomMargin ='0'");
							threadChartAttributes.add("chartRightMargin ='3'");
							threadChartAttributes.add("showToolTipShadow ='1'");
							threadChartAttributes.add("pieSliceDepth='8'");
							threadChartAttributes.add("numberSuffix='%'");
							threadChartAttributes.add("showToolTipShadow ='1'");
							threadChartAttributes.add("pieOuterFaceAlpha  ='55'");
							threadChartAttributes.add("pieOuterFaceAlpha  ='100'");
							threadChartAttributes.add("pieYScale  ='55'");
							threadChartAttributes.add("smartLineColor  ='F4DA03'");
							threadChartAttributes.add("captionPadding  ='0'");
							threadChartAttributes.add("bgSWFAlpha  ='0'");
							threadChartAttributes.add("enableSmartLabels='1'");
							threadChartAttributes.add("plotBorderColor='D8DAEB'");
							threadChartAttributes.add("plotBorderThickness='1'");
							threadChartAttributes.add("plotBorderAlpha ='40'");
							threadChartAttributes.add("toolTipBgColor ='555555'");
							threadChartAttributes.add("pieInnerFaceAlpha  ='100'");
							threadChartAttributes.add("toolTipBorderColor ='ffff00'");
							threadChartAttributes.add("pieRadius ='27'");
							threadChartAttributes.add("exportEnabled='0'");
							threadChartAttributes.add("exportAction='download'");
							threadChartAttributes.add("exportAtClient='0'");
							threadChartAttributes.add("exportHandler='/final/FusionCharts/jsp/FCExporter.jsp'");

							String s_jvmThreadColor=iniObj.getValue("Dashboard_Graph_colors","JVMThread");
							Vector colors=egDashboard.getTokensAsVector(s_jvmThreadColor,",");

							String threadXML=fusionChart.getXMLForPIE(samples,colors,legendLabels,threadChartAttributes);
%>
				<tr>
					<td class="whiteColor eg_cellbgdark <%=traceFontColorBold%>" colspan="2"><%=(String)all.get(j1)%>&nbsp;</td>
				</tr>
				<tr>
<%
							if(isRunningTest && samples!=null && samples.size()>0)
							{
%>
					<td valign="top" class="linebottom_light" width="275">
						<!-- <object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" codebase="//fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0" width="275" height="120" id="StackedColumn3D" >
						<param name="movie" value="/final/FusionCharts/swf/Pie3D.swf" />
						<param name="FlashVars" value="&dataXML=<%=threadXML%>&chartWidth=275&chartHeight=120">
						<param name="quality" value="high" />
						<param name="WMode" value="transparent" />
						<embed wmode="transparent" src="/final/FusionCharts/swf/Pie3D.swf" flashVars="&dataXML=<%=threadXML%>" width="275" height="120" name="Column3D" type="application/x-shockwave-flash" pluginspage="//www.macromedia.com/go/getflashplayer" />
						</object> -->

						<div id="chart3Pie3DContainer<%=j%>^<%=j1%>"  style="height:100%;"></div>
						<script type="text/javascript">
							if  ( FusionCharts( "my3Pie3DChartId<%=j%>^<%=j1%>" ) )
									FusionCharts( "my3Pie3DChartId<%=j%>^<%=j1%>" ).dispose();
							var myChart = new FusionCharts( "/final/FusionCharts/swf/Pie3D.swf","my3Pie3DChartId<%=j%>^<%=j1%>", "275", "120","0","1");
							myChart.setXMLData("<%=threadXML%>");
							myChart.render("chart3Pie3DContainer<%=j%>^<%=j1%>");
						</script>
					</td>
<%
							}
							else
							{
%>
					<td class="linebottom_light" align="center"><img class="png" src="/final/monitor/eg_images/gray/icon_exclamation.png"/><br> <egui:intnl text="monitor.dashboard.No Measures available"/></td>
<%
							}
					
							StringTokenizer lines=new StringTokenizer((String)all.get(j1+11),";");
%>
					<td class="linebottom_light" valign="top">
<%
							int colorCount = 0;
							while(lines.hasMoreTokens())
							{
%>
						<table border="0" cellpadding="2" cellspacing="0" width="100%" class="<%=traceFontColor%>">

<%
								String lin=(String)lines.nextToken();
								if(lin!=null && lin.equals("-"))
								{
%>
							<tr>
									<td valign="center" id="linebottom" style="font-size:7pt" class="<%=traceFontColor%>"><egui:intnl text="monitor.dashboard.No Stack Trace Available"/>!</td>

							</tr>
<%
								}
								else
								{
%>
							<tr>
								<td valign="top" id="linebottom" style="font-size:7pt" class="<%=traceFontColor%>"> <%=lin%></td>

							</tr>

<%
								}
%>

						</table>
<%
								colorCount++;
							}
%>
					</td>
				</tr>
<%
						}
					}
				}
				else
				{
%>
				<tr>
					<td align="center" width="100%" height="100%">
						<table width="100%" height="100px" cellpadding="0" cellspacing="0" border="0">
							<tr>
								<td align="center" valign="middle" class="<%=traceFontColor%>"><img class="png" src="/final/monitor/eg_images/gray/icon_exclamation.png"/><br> <egui:intnl text="monitor.dashboard.No detailed Measures available"/>!</td>
							</tr>
						</table>
					</td>
				</tr>
<%
				}
%>
			</table>
		</div>
		</td>
	</tr>
</table>
</div>
<%
			}
			else
			{
%>
<div id="summaryContentDiv" style="width:100%;height:200px;border:0px solid red">
	<table border="0" cellspacing="0" cellpadding="0" width="100%" height="100%">
		<tr>
			<td align="center">
				<table border="0" cellspacing="0" cellpadding="0" width="100%" height="100%">
					<tr>
						<td align="center" style="padding:2px;padding-left:12px" class="eg_75bold"><egui:intnl text="monitor.dashboard.Thread Analysis"/></td>
					</tr>
					<tr>
						<td align="center" valign="middle"><img class="png" src="/final/monitor/eg_images/gray/icon_exclamation.png"/><br> <egui:intnl text="monitor.dashboard.No detailed Measures available"/></td>
					</tr>
				</table>
			</td>
		</tr>
	</table>
</div>
<%
			}
		}
	}
	else if(subsystem!=null && (subsystem.equalsIgnoreCase("Weblogic Service") || subsystem.equalsIgnoreCase("weblogic threads")) )
	{
		String s_comparisiontable="";
		if(subsystem.equalsIgnoreCase("Weblogic Service"))
		{
			graphType="weblogic service";
			s_comparisiontable=iniObj.getValue(subject,tab+"_Weblogic service_comparisiontable");
		}
		else if(subsystem.equalsIgnoreCase("weblogic threads"))
		{
			graphType="weblogic threads";
			s_comparisiontable=iniObj.getValue(subject,tab+"_Weblogic Threads_comparisiontable");
		}
		if(s_comparisiontable!=null && !s_comparisiontable.trim().equals(""))
		{
			EgAgentInfo agentInfo = new EgAgentInfo("manager");
			int tablescount=0;
			int imgcnt=0;
			int stColPos=1;
			int endColPos=0;
			int divCount=0;
			String defaultComparisonTableRowLength=iniObj.getValue("Default_ComparisonTable_Rows","ComparisonTableSize");
			String priority="";
			if(defaultComparisonTableRowLength!=null && (!defaultComparisonTableRowLength.equals("") &&  !defaultComparisonTableRowLength.equalsIgnoreCase("all")))
				priority=defaultComparisonTableRowLength;
			Vector comparisionVector=egDashboard.getTokensAsVector(s_comparisiontable,"#");
			Iterator comparionTableItr=comparisionVector.iterator();
			while(comparionTableItr.hasNext())
			{
				String s_alltestmeasure=(String)comparionTableItr.next();
				String colspan="1";

				info="+";
				String fullViewTableURL=response.encodeURL("/final/monitor/egCustomDashboardp.jsp")+"?"+"compName="+EgURLEncoder.encode(compName,"UTF-8")+"&compType="+compType+"&subject="+EgURLEncoder.encode(subject,"UTF-8")+"&site="+site+"&tab=Application&defaultMGraphDuration="+defaultMGraphDuration+"&defaultSparklineDuration="+defaultSparklineDuration+"&divCount="+divCount+"&blockType=comparisontable&tableIdx="+tablescount+"&subsystem="+EgURLEncoder.encode(subsystem,"UTF-8");

				Vector allMeasures=egDashboard.getTokensAsVector(s_alltestmeasure,",");

				String tempTestName="";
				if(allMeasures.size()>0)
				{
					tempTestName=(String)allMeasures.get(0);
					if(tempTestName!=null && tempTestName.indexOf(":")!=-1)
						tempTestName=tempTestName.substring(0,tempTestName.indexOf(":"));
				}
				String tableTitle=iniObj.getValue("Dashboard_Comparison_TableTitle",tempTestName);
				if(tableTitle!=null && tableTitle.equals(""))
				{
					tableTitle=mappingInfo.getTestDescription(tempTestName);
				}

				Vector allInfos=(Vector)allTestInfos.get(tempTestName);

				boolean hasInfos=(allInfos!=null && allInfos.size()>0 && !(allInfos.size()==1 && allInfos.contains("+")));
				int colCountForFullTable=5;
				String sortByMeas="";
				if(hasInfos && enabledTests.contains(tempTestName))
				{
					
					Vector measures=new Vector();
					String measuresForDB="";
					String testName="";
					String defaultSortColumn=iniObj.getValue("Default_ComparisonTable_ColumnIndexForSorting",tempTestName);

					for(int i=0;i<allMeasures.size();i++)
					{
						String tempStr=(String)allMeasures.get(i);
						if(tempStr!=null && tempStr.indexOf(":")!=-1)
						{
							testName=tempStr.substring(0,tempStr.indexOf(":"));
							String tempMeasure=tempStr.substring(tempStr.indexOf(":")+1);
							measures.add(tempMeasure);
							measuresForDB+=dbInfo.getColumnForMeasure(testName,tempMeasure);
							if(defaultSortColumn!=null && defaultSortColumn.equals(measure))
								sortByMeas=measure;
							if(allMeasures.size()>i+1)
								measuresForDB+=",";
						}
					}

					msmtHost=(String)allMsmtHosts.get(testName);
					if(msmtHost==null)
						msmtHost="";
				
					String s_infomapping=iniObj.getValue("Dashboard_Info_Mapping",testName);
					if(testName.equals("WLServletTest") || testName.equals("WLEJBPoolsTest") || testName.equals("WLEJBTransTest"))
					{
						String groupingRequired=agentInfo.getParamValue(testName,msmtHost,portNo,info, msmtHost,"autoDiscovery");
						if(groupingRequired!=null && groupingRequired.equals("true"))
						{
							s_infomapping="Bean name";
						}
						else
						{
							s_infomapping="Group name";
						}
					}
					if(s_infomapping==null || s_infomapping.trim().length()==0)
					{
						s_infomapping="Info";
					}
					String rsTableName="rsTable"+(tablescount+1);
					int totalMeasureCols=measures.size();
					Vector allValuesForInfo=dashboardDAO.getCurrentForAllInfos(hostName,portNo,testName,measuresForDB,msmtHost,sortByMeas,true,priority);
					endColPos+=(totalMeasureCols+1);
					boolean isValuesAvailableForInfo=(allValuesForInfo!=null && !allValuesForInfo.isEmpty());
					if(!disabledBlocks.contains(testName) && isValuesAvailableForInfo)
					{
%>
	<div style="margin-left:5px;margin-top:5px;float:left;width: ;height:250px;border:0px solid #2B7F82" id="div<%=++divCount%>" >
		
		<table border="0" cellpadding="0"  cellspacing="0" height="100%"  valign="top">
			<tr>
				<td valign="top" class="gradient_header" height="20px">
					<table border="0" cellpadding="2"  cellspacing="0" width="100%"><col width="95%"><col width="15px"><col width="15px">
						<tr>
							<td class="eg_75bold" height="20px" style="padding-left:4px;border-right-width:0px"><%=tableTitle%></td>
<%
						if(adminPermission==true)
						{
%>
							<td class="eg_75bold" style="padding-right:4px;border-right-width:0px;border-left-width:0px" valign="middle" align="right" onclick="javascript:showMaximizedView('<%=fullViewTableURL%>','event','');"> <img id="img<%=divCount%>" class="png" src="/final/monitor/eg_images/<%=monitor_Skin%>/icon_maximize_div.png"/> <img class="png" src="/final/monitor/eg_images/spacer.gif" style="display:none" border="0" onload="javascript:divonload('<%=divCount%>','<%=tab+"_"+subsystem+"_"+testName%>');"/> </td>
<%
						}
						else
						{
%>
							<td class="eg_75bold" style="padding-right:4px;border-right-width:0px;border-left-width:0px" valign="middle" align="right" >&nbsp;</td>
							<td class="eg_75bold" style="padding-right:4px;border-left-width:0px" valign="middle" align="right" onclick="javascript:showMaximizedView('<%=fullViewTableURL%>','event','');"> <img id="img<%=divCount%>" class="png" src="/final/monitor/eg_images/<%=monitor_Skin%>/icon_maximize_div.png"/> </td>
<%
						}
%>
						</tr>
					</table>
				</td>
			</tr>
			<tr>
				<td class="vmborder" style="padding:0px" valign="top">
				<div id="compTable<%=(tablescount+1)%>" class="div_scroll" style="height:230px;border:0px solid #ff0000;">
<%
				boolean isTestHas_CutOffFactor=false;
				int defaultColumnSortIndex=0;
				int defaultColumnSortImageIndex=stColPos;
				if(UseCutOffFactor!=null && !UseCutOffFactor.equals("") && UseCutOffFactor.equalsIgnoreCase("Yes"))
				{
					if(egDashboard.isTestHasCutOffFactor(testName))
					{
						if(allValuesForInfo!=null && !allValuesForInfo.isEmpty())
						{
							for(int d=0;d<allValuesForInfo.size();d+=measures.size()+1)
							{
								boolean isTestExceededCutOffFactor=dashboardDAO.isTestExceededCutOffFactor(compType,hostName,portNo,sid,testName,msmtHost,(String)allValuesForInfo.get(d));
								if(isTestExceededCutOffFactor)
									isTestHas_CutOffFactor=true;
							}
						}			
					}
				}
				if(!isTestHas_CutOffFactor)
				{
%>
					<table cellspacing="0" cellpadding="2" class="tableborder_jvm"  border="0" width="100%">
						<tr>
							<td class="eg_75bold tdborder2_jvm" style="padding-top:0px;padding-bottom:0px">
								<table cellspacing="0" cellpadding="0"   border="0" width="100%">
									<tr>
										<td ><a class="eg_monlink" href="" onclick="this.blur();return sortTable('<%=rsTableName%>','0',<%=stColPos%>,<%=endColPos%>,'<%=(imgcnt+1)%>');"><span class="eg_75bold"><egui:intnl text ='<%="monitor.dashboard."+s_infomapping%>'/>
										</a></span></td>
										<td style="width:15px" ><img id="imgdd<%=(imgcnt+1)%>" src="/final/monitor/eg_images/arrow_down_black_small.gif" onclick="this.blur();return sortTable('<%=rsTableName%>',0,<%=stColPos%>,<%=endColPos%>,'<%=(imgcnt+1)%>');" style="display:none"/></td>
									</tr>
								</table>
							</td>
<%
						imgcnt=imgcnt+1;
						
						for(int i=0;i<totalMeasureCols;i++)
						{
							measure=(String)measures.get(i);

							String tableHeader=iniObj.getValue("Dashboard_TableColumn_mapping",testName+":"+measure);
							if(defaultSortColumn!=null && defaultSortColumn.equals(measure))
							{
								defaultColumnSortIndex=i+1;
								defaultColumnSortImageIndex=imgcnt+1;
							}
							if(tableHeader!=null && tableHeader.equals(""))
							{
								tableHeader=mappingInfo.getMeasureDescription(testName,measure);
							}

							String units = tablesInfo.getUnitForMeasure(testName,measure);

							if(units!=null && units.equalsIgnoreCase("MB"))
								units="GB";
%>
							<td class="eg_75bold tdborder2_jvm" >
								<table cellspacing="0" cellpadding="0"   border="0" width="100%">
									<tr>
										<td ><a class="eg_monlink" href="" onclick="this.blur();return sortTable('<%=rsTableName%>',<%=(i+1)%>,<%=stColPos%>,<%=endColPos%>,<%=(imgcnt+1)%>);">
										<span class="eg_75bold"><%=tableHeader%><br>(<%=units%>)</span></a></td>
										<td style="width:15px" ><img id="imgdd<%=(imgcnt+1)%>" src="/final/monitor/eg_images/arrow_up_black_small.gif" onclick="this.blur();return sortTable('<%=rsTableName%>',<%=(i+1)%>,<%=stColPos%>,<%=endColPos%>,<%=(imgcnt+1)%>);" style="display:none"/></td>
									</tr>
								</table>
							</td>
<%						
							imgcnt++;

						}
%>
						</tr>
						<tbody name="<%=rsTableName%>" id="<%=rsTableName%>">
<%
						for(int i=0;i<allValuesForInfo.size();i+=measures.size()+1)
						{
							info=(String)allValuesForInfo.get(i);
							info=com.egurkha.util.StringUtils.replace(info,"+","");
%>
						<tr>
							<td class="tdborder_jvm" valign="top"><%=info%></td>
<%
							for(int j=1;j<=measures.size();j++)
							{
								measure=(String)measures.get(j-1);
								String value=(String)allValuesForInfo.get(j+i);
								String units = tablesInfo.getUnitForMeasure(testName,measure);

								if(value!=null && (value.trim().equals("") || value.equalsIgnoreCase("null")))
								{
									value = "-";
								}
								else if(!testerInfo.getAllowNegativeValues(testName,measure) && (value!=null && value.startsWith("-")))
								{
									value=ui.getValue("MEASURE_LOOKUP",value);
									if(value!=null && value.indexOf(":")>0)
									{
										value=value.substring(value.indexOf(":")+1,value.length());
									}
								}

								if((value!=null && !value.equals("-")) && (units!=null && units.equalsIgnoreCase("MB")))
								{
									double floatVal=(Double.parseDouble(value))/1024;
									floatVal=com.egurkha.util.MathUtils.round(floatVal,2);
									value=floatVal+"";
								}
								else if((value!=null && !value.equals("-")) && (units!=null && units.equalsIgnoreCase("boolean")))
								{
									if(value.equals("0"))
										value="No";
									else if(value.equals("1"))
										value="Yes";
								}
%>
							<td class="tdborder_jvm" valign="top"><%=value%></td>
<%
							}
%>
						</tr>
<%
						}
%>
						</tbody>
					</table>
<%
					}
					else
					{
%>
					<table cellspacing="0" cellpadding="2" border="0" width="100%"  height="100%">
						<tr>
							<td align="center" valign="middle"  width="100%" height="100%">
								<img src="/final/monitor/eg_images/<%=monitor_Skin%>/exclamation-icon.gif"> <br> <egui:intnl text="monitor.dashboard.No Measures Available"/>!
							</td>
						</tr>
					</table>
<%
					}
%>
					<img src="/final/monitor/eg_images/spacer.gif" height="0px" width="0px" border="0px" onload="this.blur();return sortTable('<%=rsTableName%>',<%=defaultColumnSortIndex%>,<%=stColPos%>,<%=endColPos%>,<%=defaultColumnSortImageIndex%>);" style="visibility:hidden;display:none;">
				</div>
				</td>
			</tr>
		</table>
	</div>
<%
						stColPos=imgcnt+1;
					}
					else if(isValuesAvailableForInfo)
					{
%>
	<div style="margin-left:5px;margin-top:5px;float:left;width:<%=(allMeasures.size()>5 || tempTestName.equalsIgnoreCase("MsSqlSpaceTest") || tempTestName.equalsIgnoreCase("EsxNetworkTest") || tempTestName.equalsIgnoreCase("NetworkInterfaceTest"))?"99%":"49%"%>;height:152px;border:0px solid #2B7F82" id="div<%=++divCount%>" >
		<table border="0" cellspacing="0" cellpadding="2" width="100%">
			<tr>
				<td width="100%">
					<table border="0" cellpadding="0" cellspacing="0" width="100%" height="120">
						<tr>
							<td align="center" height="100%" valign="middle"><img src="/final/monitor/eg_images/<%=monitor_Skin%>/exclamation-icon.gif"> <br > <egui:intnl text="monitor.dashboard.No measures available"/>!</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
	</div>

<%					}
				}
				else if(enabledTests.contains(tempTestName))
				{
					Vector measures=new Vector();
					String measuresForDB="";
					String testName="";

					for(int i=0;i<allMeasures.size();i++)
					{
						String tempStr=(String)allMeasures.get(i);
						if(tempStr!=null && tempStr.indexOf(":")!=-1)
						{
							testName=tempStr.substring(0,tempStr.indexOf(":"));
							String tempMeasure=tempStr.substring(tempStr.indexOf(":")+1);
							measures.add(tempMeasure);
							measuresForDB+=dbInfo.getColumnForMeasure(testName,tempMeasure);
							if(allMeasures.size()>i+1)
								measuresForDB+=",";
						}
					}

					msmtHost=(String)allMsmtHosts.get(testName);
					if(msmtHost==null)
						msmtHost="";

					Vector allValuesForInfo=dashboardDAO.getCurrentForAllInfos(hostName,portNo,testName,measuresForDB,msmtHost);
					allValuesForInfo.remove("+");
					if(!disabledBlocks.contains(testName))
					{
%>
	<div style="margin-left:5px;margin-top:5px;float:left;width:49%;height:250px;border:0px solid #2B7F82" id="div<%=++divCount%>" >
		<table border="0" cellpadding="0"  cellspacing="0" height="100%" width="100%"  valign="top">
			<tr>
				<td width="100%" valign="top" class="gradient_header" height="20px">
					<table border="0" cellpadding="2"  cellspacing="0" width="100%"><col width="95%"><col width="15px"><col width="15px">
						<tr>
							<td class="eg_75bold"  style="padding-left:4px;border-right-width:0px"><%=tableTitle%></td>
				
<%
						if(adminPermission==true)
						{
%>
							<td class="eg_75bold" style="padding-right:4px;border-right-width:0px;border-left-width:0px" valign="middle" align="right" onclick="maximizeDiv(<%=divCount%>,'<%=tab+"_"+subsystem+"_"+testName%>','WeblogicSubSystemOverview')"> <img id="img<%=divCount%>" class="png" src="/final/monitor/eg_images/<%=monitor_Skin%>/icon_maximize_div.png"/><img  src="/final/monitor/eg_images/spacer.gif"  border="0" style="display:none" onload="javascript:divonload('<%=divCount%>','<%=tab+"_"+subsystem+"_"+testName%>');"/> </td>
<%
						}
						else
						{
%>
							<td class="eg_75bold" style="padding-right:4px;border-right-width:0px;border-left-width:0px" valign="middle" align="right">&nbsp;</td>
							<td class="eg_75bold" style="padding-right:4px;border-left-width:0px" valign="middle" align="right" onclick="maximizeDiv(<%=divCount%>,'<%=tab+"_"+subsystem+"_"+testName%>','WeblogicSubSystemOverview')"> <img id="img<%=divCount%>" class="png" src="/final/monitor/eg_images/<%=monitor_Skin%>/icon_maximize_div.png"/> </td>
<%
						}
%>
						</tr>
					</table>
				</td>
			</tr>
			<tr>
				<td class="vmborder" style="padding:0px">
					<div id="compTable<%=(tablescount+1)%>" class="div_scroll" style="height:228px;border:0px solid #ff0000;" >
					<table border="0" cellpadding="2" cellspacing="0" width="100%" height="100%"><col width="40%"><col width="30%"><col width="30%">
	<%	
						boolean isMeasureAvailable=false;
						if(allValuesForInfo!=null && !allValuesForInfo.isEmpty())
						{
							for(int i=0;i<allValuesForInfo.size();i++)
							{
								measure=(String)measures.get(i);
								String measureForDB=dbInfo.getColumnForMeasure(testName,measure);
								String graph_values=dashboardDAO.getGraphValuesForSpark(hostName,"+",sid,testName,measureForDB,sparkLineStartTime+" "+sparkLineStartHour+":"+endDate.getMinutes()+":00",sparkLineEndTime+" "+sparkLineEndHour+":"+endDate.getMinutes()+":00");
								String urlForMaximize="/final/servlet/com.egurkha.monitor.EgDashboardTimelineMeasures?measure="+measureForDB+"&state="+state+"&starttime="+startTime+"&port="+portNo+"&comptype="+compType+"&mode=3D&site="+site+"&host="+hostName+"&monitorSkin="+monitor_Skin+"&msmt_host="+msmtHost+"&gtype=1&starthr="+startHour+"&test="+testName+"&info=*&layer=HOST&endtime="+endTime+"&endhr="+endHour+"&showRange=Range&gformat=graph&fromDashboard=true&timeline_compare="+defaultMGraphDuration+"&width=880&height=320&threshold=no&title=true&minmaxavgRequired=true&priority=TOP+-+10&module="+tab;

								String urlForSummary="/final/monitor/egSummary.jsp?hostName="+compName+"&compType="+compType+"&subsystem=JVM Thread&ddmeasure="+measure+"&fullview=true&subject="+subject;

								String summaryTitle="Thread Details";
								String value=(String)allValuesForInfo.get(i);
								if(value!=null && value.trim().equals(""))
								{
									value = "-";
								}
								else if(!testerInfo.getAllowNegativeValues(testName,measure) && (value!=null && value.startsWith("-")))
								{
									value=ui.getValue("MEASURE_LOOKUP",value);
									if(value!=null && value.indexOf(":")>0)
									{
										value=value.substring(value.indexOf(":")+1,value.length());
									}
								}
								if(UseCutOffFactor!=null && !UseCutOffFactor.equals("") && UseCutOffFactor.equalsIgnoreCase("Yes"))
								{
									if(egDashboard.isTestHasCutOffFactor(testName))
									{
										boolean isTestExceededCutOffFactor=dashboardDAO.isTestExceededCutOffFactor(compType,hostName,portNo,sid,testName,msmtHost,"+");
										if(isTestExceededCutOffFactor)
											continue;
									}
								}
								isMeasureAvailable=true;
								Vector spartLineAttributes=new Vector();
								spartLineAttributes.add("palette='2'");
								spartLineAttributes.add("setAdaptiveYMin='0'");
								spartLineAttributes.add("bgAlpha='0,0'");
								spartLineAttributes.add("showHighAnchor ='0'");
								spartLineAttributes.add("showLowAnchor ='0'");
								spartLineAttributes.add("showOpenValue ='0'");
								spartLineAttributes.add("showCloseValue ='0'");
								spartLineAttributes.add("showHighLowValue ='0'");
								spartLineAttributes.add("showOpenAnchor ='0'");
								spartLineAttributes.add("showCloseAnchor ='0'");
								spartLineAttributes.add("lineColor='"+iniObj.getValue("Dashboard_Graph_colors","Sparkline")+"'");
								spartLineAttributes.add("clickURL='javascript:sparklineOnclick(&apos;comparesparkurl"+testName+":"+measure+i+"&apos;)'");

								Vector sparkValues=egDashboard.getTokensAsVector(graph_values,",");

								String sparkXML=fusionChart.getXMLForSpark(sparkValues,spartLineAttributes);
%>
						<tr>
							<td width="40%">
							<a class="<%=(testName.equals("JvmThreadTest"))?"mouse eg_monlink":"eg_monlink"%>" onclick="javascript:<%=(testName.equals("JvmThreadTest"))?"loadPageinFrame('"+urlForSummary+"',event,'"+summaryTitle+"');":"void(0);"%>"><egui:intnl measure='<%=testName+":"+measure%>'/></a></td>
							<td width="30%">
<%
								if(graph_values!=null  && graph_values.length()>0)
								{
%>
								<!-- <object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" codebase="//fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0" width="100" height="20" id="StackedColumn3D" >
									<param name="movie" value="/final/FusionCharts/swf/SparkLine.swf" />
									<param name="FlashVars" value="&dataXML=<%=sparkXML%>&chartWidth=100&chartHeight=20">
									<param name="quality" value="high" />
									<param name="WMode" value="Transparent">
									<embed wmode="transparent" src="/final/FusionCharts/swf/SparkLine.swf" flashVars="&dataXML=<%=sparkXML%>" quality="high" width="100" height="20" name="Column3D" type="application/x-shockwave-flash" pluginspage="//www.macromedia.com/go/getflashplayer" />
								</object> -->

								<div id="chart2SparkLineContainer<%=i%>"  style="height:100%;"></div>
								<script type="text/javascript">
									if  ( FusionCharts( "my2SparkLineChartId<%=i%>" ) )
											FusionCharts( "my2SparkLineChartId<%=i%>" ).dispose();
									var myChart = new FusionCharts( "/final/FusionCharts/swf/SparkLine.swf","my2SparkLineChartId<%=i%>", "100", "20","0","1");
									myChart.setXMLData("<%=sparkXML%>");
									myChart.render("chart2SparkLineContainer<%=i%>");
								</script>

								<input type="hidden" id="comparesparkurl<%=testName+":"+measure%><%=i%>"  value="<%=urlForMaximize%>"/>
<%
								}
								else
								{
%>
								&nbsp;
<%
								}
%>
							</td>
							<td width="30%"><%=value%></td>
						</tr>
<%
							}
						}
						if(!isMeasureAvailable)
						{
%>
						<tr>
							<td width="100%"  height="100%" valign="middle">
								<table border="0" cellpadding="0" cellspacing="0" width="100%">
									<tr>
										<td align="center"><img src="/final/monitor/eg_images/<%=monitor_Skin%>/exclamation-icon.gif"> <br > <egui:intnl text="monitor.dashboard.No measures available"/>!</td>
									</tr>
								</table>
							</td>
						</tr>
<%
						}
%>
					</table>
					</div>
				</td>
			</tr>
		</table>
	</div>
<%
					}
				}
				else
				{
%>
	<div style="margin-left:5px;margin-top:5px;float:left;width:49%;height:260px;border:0px solid #2B7F82" id="div<%=++divCount%>" >
		<table border="0" cellpadding="0"  cellspacing="0" height="100%" width="100%"  valign="top">
			<tr>
				<td width="100%" valign="top" class="gradient_header">
					<table border="0" cellpadding="2"  cellspacing="0" width="100%"><col width="95%"><col width="15px"><col width="15px">
						<tr>
							<td class="eg_75bold" height="20px" style="padding-left:4px;border-right-width:0px"><%=tableTitle%></td>
				
<%
					if(adminPermission==true)
					{
%>
							<td class="eg_75bold" valign="middle" style="padding-right:4px;border-right-width:0px;border-left-width:0px" align="right"> <img src="/final/monitor/eg_images/spacer.gif"  border="0" style="display:none" /> </td>
<%
					}
					else
					{
%>
							<td class="eg_75bold" valign="middle" style="padding-right:4px;border-right-width:0px;border-left-width:0px" align="right">&nbsp;</td>
							<td class="eg_75bold" valign="middle" style="padding-right:4px;border-left-width:0px" align="right"><img src="/final/monitor/eg_images/spacer.gif"  border="0" style="display:none" /> </td>
<%
					}
%>
						</tr>
					</table>
				</td>
			</tr>
			<tr>
				<td style="padding:0px" class="vmborder">
					<table border="0" cellpadding="0" cellspacing="0" width="100%" height="120">
						<tr>
							<td align="center" height="100%" valign="middle"><img src="/final/monitor/eg_images/<%=monitor_Skin%>/exclamation-icon.gif"> <br > <egui:intnl text="monitor.dashboard.No measures available"/>!</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
	</div>
<%
				}
				tablescount++;
			}
		}
%>
	<!--   This div added for table end space  --------jaiwin -->
	<div style="border:0px solid #ff0000;margin:1px;padding:0px;height:6px;width:700px" ><span class="eg_blankspace">&nbsp;</span></div>
<%
	
	}
	else if(subsystem!=null && !subsystem.equalsIgnoreCase("JVM"))
	{
		graphType="weblogic databases";
		Vector jdbInfos=(Vector)allTestInfos.get("WLJDBCTest");

		if(runningtests!=null && runningtests.contains("WLJDBCTest") && jdbInfos!=null && !jdbInfos.isEmpty())
		{
			
%>

<table border="0" bordercolor="green" cellpadding="0" cellspacing="0" width="100%" height="100%" >
	<tr>
		<td id="treeViewTd"  width="180" align="left" valign="top" style="padding-top:8px;padding-left:8px;padding-right:0px;padding-bottom:0px;" border="0" class="eg_cellbglits1">
			<table width="180" cellpadding="0" cellspacing="0" border="0">
				<tr>
					<td>
						<div id="citrixUserDiv" style="height:300px;width:178;border:0px solid #ff0000;background-color:transparent">
							<table width="100%" cellspacing="0" cellpadding="0" border="0">
								<tr>
									<td class="whiteTopLeft eg_blankspace" width="8"> <img src="/final/monitor/eg_images/spacer.gif" height="8" width="8"> </td>
									<td class="eg_whitebg eg_blankspace" width="100%"><img src="/final/monitor/eg_images/spacer.gif" height="8"></td>
									<td width="8" class="whiteTopRight eg_blankspace"><img src="/final/monitor/eg_images/spacer.gif" height="8"></td>
								</tr>
							</table>
						
							<div id="citrixUserDivInner" class="eg_whitebg div_scroll" style="height:300px;width:178;border:0px solid green;">
								<div class="dtree">
									<div id="dd0" class="clip" style="border: 0px solid rgb(255, 0, 0);">
										<div class="dTreeNode" style="font-size: 7.5pt; color: rgb(0, 0, 0);" oncontextmenu="return false;">
											<img src="/final/monitor/eg_images/users.png" alt="" border="0"/>
											<span><b><egui:intnl text='monitor.dashboard.Data Source'/></b></span>
										</div>
<%
			if(selectedJDBC==null || selectedJDBC.equals("null") || selectedJDBC.equals(""))
			{
				selectedJDBC=(String)jdbInfos.get(0);
				selectedJDBC=com.egurkha.util.StringUtils.replace(selectedJDBC,"+","");
				
			}
			else if(selectedJDBC!=null && !selectedJDBC.equals(""))
			{
				selectedJDBC=selectedJDBC.trim();
			}
			
			for(int i=0;i<jdbInfos.size();i++)
			{
				String datasource=(String)jdbInfos.get(i);

				boolean isSelectedUser=false;
				if(selectedJDBC!=null && selectedJDBC.equals(com.egurkha.util.StringUtils.replace(datasource,"+","")))
					isSelectedUser=true;
%>
									
									<div id="dd1" class="dtree" style="border: 0px solid rgb(255, 0, 0); display: block;">
										<div class="dTreeNode"  oncontextmenu="return false;">
<%
				if(i==jdbInfos.size()-1)
				{
%>
										<img src="/final/admin/eg_images/tree/joinbottom.gif" alt="">
<%
				}
				else
				{
%>
										<img src="/final/admin/eg_images/tree/join.gif" alt="">
<%
				}
%>
										<img class="png" id="id2" src="/final/monitor/eg_images/user.png" alt="" border="0">
											<span><a class="<%=(isSelectedUser)?"nodeSel eg_monlink mouse":"eg_monlink mouse"%>" onclick="javascript:changeGraphType1('<%=subsystem%>','<%=tab%>','Weblogic databases','true','','','<%=datasource%>')"><%=com.egurkha.util.StringUtils.replace(datasource,"+","")%></a> </span>
										</div>
									</div>
<%
			}
%>
								</div>
								</div>
							</div>
							<table width="100%" cellspacing="0" cellpadding="0" border="0">
								<tr>
									<td class="whiteBottLeft" width="8"	><img src="/final/monitor/eg_images/spacer.gif" height="8" width="8"></td>
									<td class="eg_whitebg" width="100%"><img src="/final/monitor/eg_images/spacer.gif" height="8"></td>
									<td width="8" class="whiteBottRight"><img src="/final/monitor/eg_images/spacer.gif" height="8"></td>
								</tr>
							</table>
						</div>
					</td>
				</tr>
			</table>
		</td>
		<td style="width:6px;padding:0px;" id="hide" class="eg_cellbglits1">
			<div style="width:6px">
				<table border="0" cellspacing="0" cellpadding="0" style="width:6px">
					<tr>
						<td style="width:6px;padding:0px" class="eg_blankspace" id="expandTd"> <a href="javascript:void(0);" onclick="javascript:closeOracleTreeWindow()"><img id="expand" src="/final/monitor/eg_images/<%=monitor_Skin%>/split_left.gif" width="7" height="50" border="0"/></a> </td>
					</tr>
				</table>
			</div>
		</td>


		<td height="100%"  valign="top" class="eg_cellbglits1" style="padding-top:8px;padding-left:0px;padding-right:8px;padding-bottom:0px;">
			<div id="ctxUserRightDiv" style="width:754;height:300px;border:0px solid #ff0000;">
				<table width="100%" cellspacing="0" cellpadding="0" border="0">
					<tr>
						<td class="whiteTopLeft" width="8"><img src="/final/monitor/eg_images/spacer.gif" height="8" width="8"></td>
						<td class="eg_whitebg" width="100%"><img src="/final/monitor/eg_images/spacer.gif" height="8"></td>
						<td width="8" class="whiteTopRight"><img src="/final/monitor/eg_images/spacer.gif" height="8"></td>
					</tr>
				</table>

				<div class="div_scroll eg_whitebg" id="ctxUserRightDivInner" align="center" valign="top" style="margin:0px;padding:0px;width:754px;height:300px;border:0px solid blue">
					<table width="100%" cellpadding="6" cellspacing="0" border="0" align="center">
						<tr>
							<td valign="top"  height="100%">
<%
			Vector measures=new Vector();
			String measuresForDB="";
			String testName="";
			int digitalChartWidth=100;
			msmtHost=(String)allMsmtHosts.get(testName);
			String dataSourceTreeTestMeasures=iniObj.getValue(subject,"Application_Weblogic_databases_DataSourceTreeMetrics");
			int tdcount=0;
			boolean isMeasureAvailable=false;
			StringTokenizer stkDataSourceTreeTestMeasures=new StringTokenizer(dataSourceTreeTestMeasures,",");
			while(stkDataSourceTreeTestMeasures.hasMoreTokens())
			{
				String tempTestMeasure=stkDataSourceTreeTestMeasures.nextToken();
				test=tempTestMeasure.substring(0,tempTestMeasure.indexOf(":"));
				measure=tempTestMeasure.substring(tempTestMeasure.indexOf(":")+1);

				msmtHost=(String)allMsmtHosts.get(test);
				String measureForDB=dbInfo.getColumnForMeasure(test,measure);
				String measureValue=dashboardDAO.getCurrentMeasure(hostName,portNo,"+"+selectedJDBC,test,measureForDB,msmtHost);
				boolean isTestHas_CutOffFactor=false;
				if(UseCutOffFactor!=null && !UseCutOffFactor.equals("") && UseCutOffFactor.equalsIgnoreCase("Yes"))
				{
					if(egDashboard.isTestHasCutOffFactor(test))
					{
							boolean isTestExceededCutOffFactor=dashboardDAO.isTestExceededCutOffFactor(compType,hostName,portNo,sid,test,msmtHost,"+"+selectedJDBC);
							if(isTestExceededCutOffFactor)
							{
								isTestHas_CutOffFactor=true;
							}
					}
				}
				if(!testerInfo.getAllowNegativeValues(test,measure) && (measureValue!=null && measureValue.indexOf("-")!=-1) || isTestHas_CutOffFactor)
				{
						continue;
				}

				if(measureValue!=null && measureValue.length()>0)
					digitalChartWidth=(measureValue.length()>7)?(measureValue.length()*18):100;
				String measureMapping=iniObj.getValue("Dashboard_Digital_mapping",test+":"+measure);

				if(measureMapping==null || measureMapping.trim().equals(""))
					measureMapping=mappingInfo.getMeasureDescription(test,measure);

				String layerName=dashboardDAO.getLayerForTest(compType,test,measure);
				String compTypeForAlarm=compType;
				if(layerName!=null && (layerName.equalsIgnoreCase("HOST") || layerName.equalsIgnoreCase("NETWORK") || layerName.equalsIgnoreCase("TCP")))
					compTypeForAlarm="Host_system";

				String measureState=egDashboard.getTestMeasureState(compName,compTypeForAlarm,layerName,test+"-+"+selectedJDBC,measure);
				String layerPageUrl=response.encodeURL("/final/monitor/egDashBoardLayers.jsp?")+"qctr=2&fromPage=componentList&host="+compName+"&comptype="+compType+"&layer="+layerName+"&site="+site+"&test="+test+"-+"+selectedJDBC+"&tstate="+measureState+"&msmt_host=";
				String toolTipDisp=measureMapping+" ("+tablesInfo.getUnitForMeasure(test,measure)+")";
				if(measureMapping!=null && measureMapping.length()>20)
					measureMapping=measureMapping.substring(0,17)+"...";
%>
										<div style="float:left;border:0px green solid;padding:2px">
											<table cellpadding="2" cellspacing="0" border="0"  height="100px" valign="top" width="200px">
												<tr>
													<td align="center" valign="middle"> <span class="eg_75bold" title="<%=toolTipDisp%>" alt="<%=toolTipDisp%>"><%=measureMapping%>(<%=tablesInfo.getUnitForMeasure(test,measure)%>) </span><br><br>
														<a href="javascript:void();" class="eg_monlink" onclick="javascript:goToLayerModel('<%=layerPageUrl%>');" border="0">
															<img border="0" src="../servlet/com.egurkha.monitor.egDigitalChart?width=<%=digitalChartWidth%>&height=40&value=<%=measureValue%>&forecolor=00FF00&background=999999&background1=999999" title="<%=toolTipDisp+" ("+measureValue+")"%>" />
														</a>
													</td>
												</tr>
											</table>
										</div>

<%
				tdcount++;
			}
			if(tdcount==0)
			{
%>
										<div style="float:left;border:0px green solid;padding:2px">
										<table width="100%" height="100%" cellpadding="0" cellspacing="0" border="0" bordercolor="blue">
									<tr>
												<td align="center" valign="middle">
												<img src="/final/monitor/eg_images/<%=monitor_Skin%>/exclamation-icon.gif"> <br ><egui:intnl text="monitor.dashboard.No Measures available"/>!</td>
									</tr>
										</table>
										</div>
<%
			}
%>
							</td>
						</tr>
					</table>
				</div>
				<table width="100%" cellspacing="0" cellpadding="0" border="0">
					<tr>
						<td class="whiteBottLeft" width="8"><img src="/final/monitor/eg_images/spacer.gif" height="8" width="8"></td>
						<td class="eg_whitebg" width="100%"><img src="/final/monitor/eg_images/spacer.gif" height="8"></td>
						<td width="8" class="whiteBottRight"><img src="/final/monitor/eg_images/spacer.gif" height="8"></td>
					</tr>
				</table>
			</div>
		</td>
	</tr>
</table>

<%
		}
		else
		{
%>
<div class="div_scroll eg_cellbglits1" style="margin-left:0px;margin-top:0px;float:left;width:100%;height:400px;border:0px solid red;">
	<table width="100%" height="100%" cellpadding="0" cellspacing="0" border="0" bordercolor="blue">
		<tr>
			<td align="center" valign="middle">
			<img src="/final/monitor/eg_images/gray/exclamation-icon.gif"> <br ><egui:intnl text="monitor.dashboard.No Measures available"/>!</td>
		</tr>
	</table>
</div>
<%
		}
	}
%>
<input type="hidden" id="graphType" value="<%=graphType%>"/>
<input type="hidden" id="selectedInfo" value="<%=selectedJDBC%>"/>
<%
	
	if(request.getQueryString()!=null)
	{
		if(session!=null)
		{
			session.setAttribute("monitorLastSession","/final/servlet/com.eg.EgDashboardController?from=list&"+request.getQueryString()+"&comptype="+compType+"&subsystem="+subsystem+"&host="+compName+"&selectedInfo="+selectedJDBC+"&tab="+tab+"&graphType="+graphType+"&toDashBoardLayer=true");
			session.setAttribute("monitorDashBrdLastCompName",request.getParameter("hostName"));
		}
	}
	else
	{
		if(session!=null)
		{
			session.setAttribute("monitorLastSession","/final/servlet/com.eg.EgDashboardController?from=list&selectedInfo="+selectedJDBC+"&tab="+tab+"&subsystem="+subsystem+"&toDashBoardLayer=true");
			session.setAttribute("monitorDashBrdLastCompName",request.getParameter("hostName"));
		}
	}
}
catch(Exception ex)
{
	ex.printStackTrace();
}
%>