<%
/*****************************************************************************
*	Name			:	addTransactions.jsp
*	Purpose			:	This module allows monitor users to add new transactions.
*	Creationdate	:	13/06/2001
*	LastModified	:	18/12/2001	//Sandhya	-	Changed maxlength of transname from 64 to 20.
*						06/08/2003	//Williams	-	eG 3.0 layout modification
*						26/09/2003	//Williams	-	Footer Page Include
*						29/10/2003	//Williams	-	Fixed the border of inner boxes
*						19/11/2003	//Arun		-	Fixed error message that said more than 15 
													transaction
						29/11/2011  //S.Saravanan - for serviceDashboard version 5.4
*													are not allowed instead of 12
*	Version			:	eG 3.0
*	Author			:	Krishna Kumar.C
*******************************************************************************/
%>
<%@ include file = "EgMonitorTracker.jsp" %>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %> 

<%@ page import="com.egurkha.*" %>
<%@ page errorPage="EgProbsM.jsp"%>
<%@ page import = "com.eg.EgDbInfo" %>
<%@ page import = "com.eg.EgTopoInfo"%>
<%@ page import = "com.eg.EgAggregateInfo"%>
<%@ page import = "com.eg.EgDbAdapterTypeUI"%>
<%@ page import = "com.egurkha.ini.*" %>
<%@ page import = "com.egurkha.monitor.alarms.*" %>
<%@ page import = "egurkha.EgDbAdapterUI"%>
<%@ page import = "java.util.*" %>
<%@ page import = "java.sql.*" %>

<%@ page import="net.sf.json.*"%>
<%@ page import = "com.eg.EgMappingInfo"%>
<%@ page import="egurkha.TransactionBean"%>
<%@ page import="com.egurkha.*" %>
<%@ page import = "com.egurkha.UserRegistry"%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json");
	EgDbAdapterUI egDb;
	boolean isDouble=EgDbInfo.doubleByteEnabled;
	request.setCharacterEncoding("UTF-8");	
	
	TransactionBean trans = new TransactionBean();
	IniUI iniUI = IniUI.getInstance();
	String thisLanguage = iniUI.getDefaultLanguage();
	//EgMappingInfo mappingInfo = new EgMappingInfo(thisLanguage);
	
	JSONObject json  = new JSONObject(); 
	JSONObject screenLabels  = new JSONObject();
	JSONObject validationsMessages = new JSONObject();
	
	//User u_ser = null;
	//boolean from_sm = false;
	String currentuser=null;
	String sess_userid=null;
	//String monitor_Skin = null;
	
	IniUI ui = (IniUI)com.egurkha.ini.IniUI.getInstance();
	EgTopoInfo topoInfo = new EgTopoInfo("manager");
	EgAggregateInfo aggInfo=new EgAggregateInfo("manager");

	int trancount = 0;
	

	String s_site=request.getParameter("site");
	String s_inifilename = "eg_topology.ini";
	String s_tlist = "";
//	String s_qry = "";
	String s_conn = null;
//			s_trans = null,
//			s_user = null,
//			s_pages = null;

//	Vector	v_site_tlist = new Vector();
	List transactionList = new LinkedList();
	String fromPage=request.getParameter("fromPage");
	trans.createFile(s_inifilename);
	String strVar[] = trans.getVariables("TRANSACTIONS");
	for(int i=0; i<strVar.length; i++)
	{
//		strVar[i] = strVar[i].substring(0,strVar[i].lastIndexOf(":"));
//		if(strVar[i].equals(s_site))
//		{
//			trancount++;
//		}
		if(s_site.equals(strVar[i].substring(0, strVar[i].lastIndexOf(":"))))
		{
			trancount++;
		}
	}

	if(session.getAttribute("sessionId_SM") != null)
	{
		from_sm = true;
		currentuser = (String)session.getAttribute("sess_userid");
	}

	if(currentuser == null)
	{
		if(u_rs != null)
			currentuser = u_rs;
	}
		
	
	ResultSet rs=null;
	egDb=EgDbAdapterTypeUI.getObject();
	
	
	if(session!=null)
	{
		if(from_sm)
		{
			//u_ser = UserRegistry.getInstance().getUser(sess_userid,true);
		}
		else
		{
			//u_ser = UserRegistry.getInstance().getUser(session.getId(),true);
		}
	}
	if (u_ser!=null)
	{
			u_ser.setUserLanguageAndSkins();
			//monitor_Skin  = u_ser.getMonitorSkin();
	}
	
	try
	{
		s_conn=egDb.setConnection();
		rs = egDb.SelectEgAddMonTrans(s_site);

		while(rs.next())
		{
			transactionList.add(rs.getString("trans_name"));
			transactionList.add(rs.getString("user_id"));
			transactionList.add(rs.getString("img"));
			s_tlist = s_tlist + rs.getString("trans_name") + ";";
		}

		rs.close();
		egDb.releaseConnection(false);
		EgDbAdapterTypeUI.releaseObject(egDb);
	}
	catch(Exception e)
	{
		if(!s_conn.equals("CONNECTED"))
		{
			json.put("errorMessage",mappingInfo.getTextDescription("monitor.addnewtransaction.Connection could not be establised"));
			json.put("errorImage","/final/monitor/eg_images/"+monitor_Skin+"/exclamation-icon.gif");
		}
		if (rs != null)
		{
			try
			{
				rs.close();
			}
			catch (Exception bug123)
			{
			}
		}
		try
		{
			egDb.releaseConnection(true);
			EgDbAdapterTypeUI.releaseObject(egDb);
		}
		catch(Exception ex)
		{
		}
	}

String trans_present=request.getParameter("webTransactions");
String isCitrix=request.getParameter("isCitrix");
boolean isCitrixFlag = false;
if(isCitrix != null && isCitrix.equalsIgnoreCase("true"))
	isCitrixFlag = true;
String emul_trans_present=request.getParameter("emulTransactions");

//String headerStr="header.jsp?title=Configure Transactions&siteName="++"&webTransactions="+trans_present+"&emulTransactions="+emul_trans_present;

	screenLabels.put("Header","Service : "+s_site);
	screenLabels.put("backBtnLabel",mappingInfo.getTextDescription("monitor.common.Back"));
	screenLabels.put("backBtnURL",fromPage);
	


	if(aggInfo.isAggregateSite(s_site))
	{
				String mappedSite=(String)topoInfo.getValue("AGG_SITE_MAP",s_site);
				json.put("errorMessage",mappingInfo.getTextDescription("monitor.addnewtransaction.Transactions cannot be configured for aggregate site"));
				json.put("mappedSite",mappedSite);
				json.put("mappedSiteText",mappingInfo.getTextDescription("admin.service.Mapped site"));
				json.put("errorImage","/final/monitor/eg_images/"+monitor_Skin+"/exclamation-icon.gif");
	}
	else
	{

				JSONArray transLabelsArray = new JSONArray();
				int size = transactionList.size();
				int count = 0;
				screenLabels.put("size",size);
				if (size == 0)
				{
					json.put("Message",mappingInfo.getTextDescription("monitor.addnewtransaction.No transactions configured for this site!"));
					json.put("errorImage","/final/monitor/eg_images/"+monitor_Skin+"/exclamation-icon.gif");
				}
				else if (size >= 3)
				{
					for (int a=0; a<size; a+=3)
					{
						JSONObject transLabels = new JSONObject();
						count = a/3;
						String transaction = (String)transactionList.get(a);
						String user = (String)transactionList.get(a+1);
						String imageName = (String)transactionList.get(a+2);		// Prem
						String pages = trans.getStrValue("TRANSACTIONS", s_site+":"+transaction);
						screenLabels.put("user",user);

						transLabels.put("transactionName",transaction);
						transLabels.put("deleteBtn",mappingInfo.getTextDescription("monitor.common.Delete"));
						transLabels.put("files",pages.replace('|',','));
						transLabels.put("user",user);
						transLabels.put("img",imageName);			// Prem
						//onclick of delete button is handled on UI.
						String uiFile = "eg_ui.ini";
						String iniFileDir = EgInstallInfo.getInstallDir()+ "/manager/config/";
						IniFile egUI = new IniFile(iniFileDir + uiFile);
						String dbImgName = egUI.getValue("TRANSACTION_IMAGE_MAPPING",imageName);
						if(dbImgName != null && !dbImgName.equals(""))
						{
							dbImgName = mappingInfo.getTextDescription("monitor.addnewtransaction."+dbImgName);
							
							transLabels.put("uiImg",dbImgName);
						}
						else
						{
							dbImgName = mappingInfo.getTextDescription("monitor.addnewtransaction."+imageName);
							transLabels.put("uiImg",dbImgName);
						}
						//transLabels.put("uiImg",'<div class="x-boundlist-item"><span style="padding-left:18px" class='+dbImgName+'></span>'+mappingInfo.getTextDescription("monitor.addnewtransaction."+imageName)+'</div>' );

						transLabelsArray.add(transLabels);
					}
				}
				screenLabels.put("transHeaders",transLabelsArray);

				if (size%4 != 0)
				{
					if (size == 2)
					{// Center align
						String transaction = (String)transactionList.get(0);
						String user = (String)transactionList.get(1);
						String pages = trans.getStrValue("TRANSACTIONS", s_site+":"+transaction);
						screenLabels.put("user",user);
						
						screenLabels.put("transactionName",transaction);
						screenLabels.put("deleteBtn",mappingInfo.getTextDescription("monitor.common.Delete"));
						screenLabels.put("files",pages.replace('|',','));
						

					}
					else
					{// One blank cell needed

					}
				}
					transactionList.clear();
					
					json.put("upperGridLabels",screenLabels);
					
					JSONObject downLabels = new JSONObject();
					JSONObject icons = new JSONObject();
					JSONArray iconsArray = new JSONArray();
				
					
					downLabels.put("header",mappingInfo.getTextDescription("monitor.addnewtransaction.New Transaction Details"));
					downLabels.put("newTransType",mappingInfo.getTextDescription("monitor.addnewtransaction.Transaction Type"));
					downLabels.put("newTransName",mappingInfo.getTextDescription("monitor.addnewtransaction.Transaction Name"));
					downLabels.put("pagesToInclude",mappingInfo.getTextDescription("monitor.addnewtransaction.Pages to be Included"));
					downLabels.put("addBtnLabel",mappingInfo.getTextDescription("monitor.addnewtransaction.Add"));
					downLabels.put("info",mappingInfo.getTextDescription("monitor.addnewtransaction.Choose an image to be associated with the transaction"));
					
					
					icons.put("name",mappingInfo.getTextDescription("monitor.addnewtransaction.Shopping"));
					//icons.put("image","/final/monitor/eg_images/"+monitor_Skin+"/trans_teenycart.gif");
					icons.put("value","teenycart");
					iconsArray.add(icons);
					
					icons.put("name",mappingInfo.getTextDescription("monitor.addnewtransaction.Login"));
					//icons.put("image","/final/monitor/eg_images/"+monitor_Skin+"/trans_login.gif");
					icons.put("value","login");
					iconsArray.add(icons);
					
					icons.put("name",mappingInfo.getTextDescription("monitor.common.Search"));
					//icons.put("image","/final/monitor/eg_images/"+monitor_Skin+"/trans_search.gif");
					icons.put("value","search");
					iconsArray.add(icons);
					
					icons.put("name",mappingInfo.getTextDescription("monitor.addnewtransaction.Browse Catalog"));
					//icons.put("image","/final/monitor/eg_images/"+monitor_Skin+"/trans_catalog.gif");
					icons.put("value","catalog");
					iconsArray.add(icons);
					
					icons.put("name",mappingInfo.getTextDescription("monitor.addnewtransaction.Shipping"));
					//icons.put("image","/final/monitor/eg_images/"+monitor_Skin+"/trans_shipping.gif");
					icons.put("value","shipping");
					iconsArray.add(icons);
					
					icons.put("name",mappingInfo.getTextDescription("monitor.addnewtransaction.Wml"));
					//icons.put("image","/final/monitor/eg_images/"+monitor_Skin+"/trans_wml.gif");
					icons.put("value","wml");
					iconsArray.add(icons);
					
					icons.put("name",mappingInfo.getTextDescription("monitor.addnewtransaction.Images"));
					//icons.put("image","/final/monitor/eg_images/"+monitor_Skin+"/trans_images.gif");
					icons.put("value","image1");
					iconsArray.add(icons);
					
					icons.put("name",mappingInfo.getTextDescription("monitor.addnewtransaction.Business Logic"));
					//icons.put("image","/final/monitor/eg_images/"+monitor_Skin+"/trans_logic.gif");
					icons.put("value","business");
					iconsArray.add(icons);
					
					icons.put("name",mappingInfo.getTextDescription("monitor.addnewtransaction.Static Resources"));
					//icons.put("image","/final/monitor/eg_images/"+monitor_Skin+"/trans_static.gif");
					icons.put("value","static");
					iconsArray.add(icons);
					
					icons.put("name",mappingInfo.getTextDescription("monitor.addnewtransaction.Datatransfer"));
					//icons.put("image","/final/monitor/eg_images/"+monitor_Skin+"/trans_dbtransfer.gif");
					icons.put("value","datatransfer");
					iconsArray.add(icons);
					
					icons.put("name",mappingInfo.getTextDescription("monitor.addnewtransaction.Database Access"));
					//icons.put("image","/final/monitor/eg_images/"+monitor_Skin+"/trans_dbaccess.gif");
					icons.put("value","dbactivity");
					iconsArray.add(icons);
					
					icons.put("name",mappingInfo.getTextDescription("monitor.addnewtransaction.Registration"));
					//icons.put("image","/final/monitor/eg_images/"+monitor_Skin+"/trans_register.gif");
					icons.put("value","register");
					iconsArray.add(icons);
					
					icons.put("name",mappingInfo.getTextDescription("monitor.addnewtransaction.Payment"));
					//icons.put("image","/final/monitor/eg_images/"+monitor_Skin+"/trans_payment.gif");
					icons.put("value","payment");
					iconsArray.add(icons);
					
					icons.put("name",mappingInfo.getTextDescription("monitor.addnewtransaction.Bid"));
					//icons.put("image","/final/monitor/eg_images/"+monitor_Skin+"/trans_bid.gif");
					icons.put("value","bid");
					iconsArray.add(icons);
					
					icons.put("name",mappingInfo.getTextDescription("monitor.addnewtransaction.Others"));
					//icons.put("image","/final/monitor/eg_images/"+monitor_Skin+"/trans_others.gif");
					icons.put("value","others");
					iconsArray.add(icons);
					
					json.put("DownGridLabels",downLabels);
					json.put("IconsInfo",iconsArray);
					
					
	}//else for non-aggregate site
	
	JSONObject hiddenFields = new JSONObject();
	
	hiddenFields.put("mode","add");
	hiddenFields.put("site",s_site);
	hiddenFields.put("translist",s_tlist);
	hiddenFields.put("currentuser",currentuser);
	hiddenFields.put("trancount",trancount);
	hiddenFields.put("webTransactions",trans_present);
	hiddenFields.put("emulTransactions",emul_trans_present);
	hiddenFields.put("isDouble",isDouble);
	
	validationsMessages.put("Please enter unique transaction name",mappingInfo.getTextDescription("monitor.addnewtransaction.Please enter unique transaction name"));
	validationsMessages.put("Please enter the transaction name",mappingInfo.getTextDescription("monitor.addnewtransaction.Please enter the transaction name"));
	validationsMessages.put("Transaction Name is not allowed in DBL",mappingInfo.getTextDescription("monitor.addnewtransaction.Transaction Name is not allowed in DBL(Chinese,Korean,Japanese),since manager is SingleByte"));
	validationsMessages.put("Please enter the pages associated",mappingInfo.getTextDescription("monitor.addnewtransaction.Please enter the pages associated"));
	validationsMessages.put("Pages to be Included is not allowed in DBL",mappingInfo.getTextDescription("monitor.addnewtransaction.Pages to be Included is not allowed in DBL(Chinese,Korean,Japanese)"));
	validationsMessages.put("Please select transaction image",mappingInfo.getTextDescription("monitor.addnewtransaction.Please select transaction image"));
	validationsMessages.put("Maximum number of transactions for a website cannot exceed",mappingInfo.getTextDescription("monitor.addnewtransaction.Maximum number of transactions for a website cannot exceed"));

	validationsMessages.put("Cannot have",mappingInfo.getTextDescription("monitor.addnewtransaction.Cannot have"));
	validationsMessages.put("in consecutive positions",mappingInfo.getTextDescription("monitor.addnewtransaction.in consecutive positions"));
	validationsMessages.put("Maximum number of pages associated with a transaction can only be 6",mappingInfo.getTextDescription("monitor.addnewtransaction.Maximum number of pages associated with a transaction can only be 6"));
	validationsMessages.put("Maximum number of patterns in a page can only be 6",mappingInfo.getTextDescription("monitor.addnewtransaction.Maximum number of patterns in a page can only be 6"));
	validationsMessages.put("Please enter unique page names",mappingInfo.getTextDescription("monitor.addnewtransaction.Please enter unique page names"));
	validationsMessages.put("Maximum length of a page associated with a transaction can only be 48 characters",mappingInfo.getTextDescription("monitor.addnewtransaction.Maximum length of a page associated with a transaction can only be 48 characters"));
	
	validationsMessages.put("Cannotdelete",mappingInfo.getTextDescription("monitor.addnewtransaction.Cannot delete a transaction added by user"));
	
	json.put("HiddenFields",hiddenFields);
	json.put("validationsMessages",validationsMessages);
	response.getWriter().write(json.toString());
	
try
{
	if(!isCitrixFlag)
	{
		if(request.getQueryString()!=null)
		{
			session.setAttribute("monitorLastSession","/final/monitor/serviceDashboard.jsp?"+request.getQueryString());
		}
		else
		{
			session.setAttribute("monitorLastSession","/final/monitor/serviceDashboard.jsp");
		}
	}
	
}
catch(Exception e)
{
	response.getWriter().write("Error");
	System.out.println("Exception in serviceDashboard..");
	e.printStackTrace();
}
%>
