<%
/***************************************************************************************************** 
*
*	Name			:	EgSegmentTopologyD3JS.jsp
*	Version			:	eG 6.1v
*	Purpose			:	To display the segment topology using JSON and D3JS
*	Creation Date	:	01-06-2015
*	Last Modified	:	
*	
*-*      Author                  :--  -Prantish A
******************************************************************************************************/
%>
<%@ include file = "EgLoginTracker.jsp" %>
<%@ page import = "com.eg.EgInstallInfo" %>
<%@ page import = "egurkha.EgCrawler" %>
<%@ page import = "com.egurkha.EgConstants" %>
<%@ page import = "com.egurkha.monitor.alarms.AlarmPriorities" %>
<%@ page import = "com.egurkha.util.StringUtils" %>
<%@ page import = "com.egurkha.ini.IniUI" %>
<%@ page import = "com.egurkha.EgNewTopology" %>
<%@ page import = "com.eg.TopoRhsComp" %>
<%@ page import = "com.eg.IniFile" %>
<%@ page import = "com.eg.EgConfigFilesSync" %>
<%@ page import = "com.eg.eGComponentCategory" %>
<%@ page import = "com.eg.EgURLEncoder" %>
<%@ taglib prefix = "egui" uri = "../WEB-INF/eg-taglib.tld" %> 
<%@ page import = "java.util.*" %>
<%@ page import = "net.sf.json.*" %>
<%@ page language = "java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"  autoFlush="true"%>
<%


	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader ("Expires", -1);

	String thisLanguage = "";
	String userName = "";
	UserRegistry registry = UserRegistry.getInstance();
	User user = registry.getUser(session.getId());
	if(user!=null)
	{
		thisLanguage = user.getLanguage();	
		userName = user.getLoginID();
	}

	String contextPath = request.getContextPath();
	String segmentName = request.getParameter("segment");
	String zoomLevel = request.getParameter("zoom");
	String view = request.getParameter("view");
	String defaultPos = request.getParameter("default");
	//String site = request.getParameter("site");
	String phyTopology = request.getParameter("physical_topology");
	String isFromZone = request.getParameter("isFromZone"); 
	String iszoneName = request.getParameter("iszoneName"); 
	String iszoneNameCheck = iszoneName;
	if(iszoneNameCheck != null && iszoneNameCheck.trim().length() > 0)
		iszoneNameCheck = EgURLEncoder.encode(iszoneNameCheck,"UTF-8");

	String parentZone = request.getParameter("parentZone");
	String segmentState = request.getParameter("segmentState");
	String fromHomepage = request.getParameter("fromHomepage");
	String fromMyDashboard = request.getParameter("fromMyDashboard");
	String anonymousUser="no";
	String profileName="";
	boolean isFromMyDashboard=false;
	String setMyDashboardAsHome="no";
	String isMyDashboardPopout="no";
	if(fromMyDashboard!=null && fromMyDashboard.equalsIgnoreCase("true"))
	{
		isFromMyDashboard=true;
		String myDashboardTheme = request.getParameter("myDashboardTheme");
		anonymousUser = request.getParameter("anonymousUser");
		profileName = request.getParameter("profileName");
		if(!StringUtils.isNull(profileName))
		{
			profileName=StringUtils.decodeSecurityChar(profileName);
		}
		setMyDashboardAsHome=request.getParameter("setMonitorHome");
		isMyDashboardPopout=request.getParameter("isDisablePopupOption");
		if(!com.egurkha.util.StringUtils.isNull(myDashboardTheme) && !myDashboardTheme.equalsIgnoreCase(monitor_Skin))
		{
			monitor_Skin=myDashboardTheme;
		}
	}
	String widgetWidth=request.getParameter("widgetWidth");
	String widgetHeight=request.getParameter("widgetHeight");

	
	String iniFilePath = EgInstallInfo.getInstallDir() + "/manager/config/eg_ui.ini";
	IniFile iniFile = new IniFile(iniFilePath);
	String topologyRenderingMode = iniFile.getValue("TOPOLOGY_OPTIONS", "TopologyRenderingMode");
	/** 
	String TopologyPosition = iniFile.getValue("TOPOLOGY_OPTIONS","TopologyPosition");
	if(TopologyPosition == null){
		System.out.println("TopologyPosition == null");
		TopologyPosition = "left";
	}
	*/
	if(topologyRenderingMode == null) {
		topologyRenderingMode = "manual";
	}
	String link = "";
	if(EgInstallInfo.isSuperManager)
	{
		String currentSession = session.getId();
		if(segmentName != null)
		{
			ArrayList managerIDs = EgElementInfo.getInstance().getManagerIDs("segment", segmentName);
			if(managerIDs != null && !managerIDs.isEmpty())
			{
				SmSessionData smsData = new SmSessionData(currentSession, managerIDs);
				EgThreadLocal egtl = new EgThreadLocal();
				egtl.set(smsData);
				new SMDateTimeConverter(managerIDs);				
			}
		}
	}

	String parentZoneCheck = parentZone;
	if(parentZoneCheck != null && parentZoneCheck.trim().length() > 0)
		parentZoneCheck = EgURLEncoder.encode(parentZoneCheck,"UTF-8");

	//url
	StringBuffer topoUrl = new StringBuffer();
	topoUrl.append("/final/monitor/EgSegmentTopologyJSON.jsp?segment=" + EgURLEncoder.encode(segmentName,"UTF-8"));
	topoUrl.append("&physical_topology=1&fromHomepage=" + fromHomepage);
	topoUrl.append("&type=segment&zoom=" + EgURLEncoder.encode(zoomLevel, "UTF-8"));
	topoUrl.append("&isFromZone=" + isFromZone);
	topoUrl.append("&iszoneName=" + iszoneNameCheck);
	topoUrl.append("&parentZone=" + parentZoneCheck);
	topoUrl.append("&segmentState=" + segmentState);
	topoUrl.append("&topologyRenderingMode=" + topologyRenderingMode);
	topoUrl.append("&autoPosition=false");

	if(isFromMyDashboard)
	{
		String tmpProfName=profileName;
		if(!StringUtils.isNull(tmpProfName))
		{
			tmpProfName=StringUtils.encodeSecurityChar(tmpProfName);
		}
		topoUrl.append("&profileName="+EgURLEncoder.encode(tmpProfName,"UTF-8"));
		topoUrl.append("&fromMyDashboard="+fromMyDashboard);
		topoUrl.append("&myDashboardTheme="+monitor_Skin);
		topoUrl.append("&anonymousUser="+anonymousUser);
		topoUrl.append("&setMyDashboardAsHome="+setMyDashboardAsHome);
		topoUrl.append("&isMyDashboardPopout="+isMyDashboardPopout);
		topoUrl.append("&widgetWidth="+widgetWidth);
		topoUrl.append("&widgetHeight="+widgetHeight);
	}

	if(u_rs!=null && !u_rs.trim().equals(""))
	{
		topoUrl.append("&loginID="+EgURLEncoder.encode(u_rs.trim(),"UTF-8"));
	}
	link = topoUrl.toString(); 
	StringBuffer metaRefreshUrl = new StringBuffer(64);

	metaRefreshUrl.append(request.getRequestURI());
	String queryString = request.getQueryString();
	if (queryString != null && !queryString.equals("null"))
	{
		metaRefreshUrl.append("?");
		metaRefreshUrl.append(queryString);
	}
	String iniFileName = EgInstallInfo.getInstallDir()+"/manager/config/js_topology.ini";
	IniFile iniTopoFile = new IniFile(iniFileName);
	String subjname = userName+"~|#|~"+segmentName+"~|#|~Segment~Monitor";
	String zoomLevelTopo = iniTopoFile.getValue(subjname,"zoom");
	String translateTopo = iniTopoFile.getValue(subjname,"translate");
	double zoomLevelTopoVal = 0;
	if(zoomLevelTopo != null && zoomLevelTopo.trim().length() > 0)
		zoomLevelTopoVal = Double.parseDouble(zoomLevelTopo);	

	EgMappingInfo mappingInfo = new EgMappingInfo(thisLanguage);
	String seglbl = "Segment";
	String searchlbl = "Search";
	String fitlbl = "Fit";
	seglbl = mappingInfo.getTextDescription("monitor.common."+seglbl);
	searchlbl = mappingInfo.getTextDescription("monitor.common."+searchlbl);
	fitlbl = mappingInfo.getTextDescription("monitor.common."+fitlbl);
	
%>
<!doctype html>
<html>
<head>
<title>Toplogy with d3</title>
<link rel="stylesheet" href="/final/styles/jquery-ui.min.css">
<script>
	var fromMyDashboard='<%=isFromMyDashboard%>';
	if(fromMyDashboard!=null && fromMyDashboard=="true")
	{
		var strSkin='<%=monitor_Skin%>';
		if(strSkin!=null && strSkin=='Dark')
		{
			document.write('<link rel="stylesheet" href="/final/resources/css/ext-eg.css"  media="all"/>');
			document.write('<link rel="stylesheet" href="/final/styles/eGDarkTheme.css" media="all" />');
			document.write('<link rel="stylesheet" href="/final/styles/eGDarkThemeIcons.css"  media="all" />');
		}
		else
		{
			document.write('<link rel="stylesheet" href="/final/resources/css/ext-eg.css"  media="all"/>');
			document.write('<link rel="stylesheet" href="/final/styles/eGLightTheme.css" media="all" />');
			document.write('<link rel="stylesheet" href="/final/styles/eGLightThemeIcons.css"  media="all" />');
		}
	}
	else
	{	
		document.write('<egui:skin ui="monitor"/>');
	}
</script>

<script language="JavaScript1.2" src="/final/jquery/jquery.js"></script>
<script src="/final/scripts/lodash.core.min.js"></script>
<script src="/final/scripts/d3.min.js" charset="utf-8"></script>
<script src="/final/jquery/jquery-ui.js"></script>
<script type="text/javascript" src="/final/extjs/ext-all.js"></script>
<script type="text/javascript" src="/final/scripts/monitord3Topology.js"></script>
<meta charset="utf-8">

</head>
<body class="bg_theme">
<div id="diagram"></div>

<div  class="div_scroll" style="width:50%;height:auto;border:0px solid black;" id="alarmsListDiv">
</div>

<script>
var widgetWidth='<%=widgetWidth%>';
var widgetHeight='<%=widgetHeight%>';
var isMyDashboardTopology=false;
if(fromMyDashboard!=null && fromMyDashboard=="true")
{
	widgetWidth=parseInt(widgetWidth);
	widgetHeight=parseInt(widgetHeight)-30;
	isMyDashboardTopology=true;
}
var width = (isMyDashboardTopology)?widgetWidth:916;
var height = (isMyDashboardTopology)?widgetHeight:500;
var isAutoFit;

function closeDiv(){
	var divId = document.getElementById("alarmsListDiv");
	//divId.style.visibility='hidden';
	var alarmPopupDivId = document.getElementById("alarmPopup");
	alarmPopupDivId.style.visibility='hidden';
}
function showDiv(){
	var divId = document.getElementById("alarmsListDiv");
	//divId.style.visibility='block';
	var alarmPopupDivId = document.getElementById("alarmPopup");
	alarmPopupDivId.style.visibility='block';
}
function saveGroupOpenforMonitor(groupCompId,pageNo)
{
	parent.topoGroupSaveSeg = groupCompId+"~~"+pageNo;
}
function saveZoomPositionsforMonitor(str,zoomVal,translateVal,groupCompId,pageNo)
{
	var segmentname ='<%=segmentName%>';
	var userName ='<%=userName%>';
	//if(segmentname == 'Independent_servers')
	{
		segmentname = userName+"~|#|~"+segmentname+"~|#|~Segment~Monitor";
	}
	var url = "/final/servlet/com.eg.SegmentPositionServlet";
	//var zoomHidden = document.getElementById("zoom").value;
	var zoomHidden = zoomVal;
	var translateHidden = translateVal;
	var params;
	if (str == 'zoom')
	{
		params = "action="+str+"&segment="+segmentname+"&zoom="+zoomHidden;
		params += "&translate="+translateHidden;
	}
	xmlhttp = new getXMLObject();
	if(xmlhttp)
	{
		xmlhttp.open("POST",url,true);
		xmlhttp.onreadystatechange  = function()
		{
			if (xmlhttp.readyState == 4) 
			{
				if(xmlhttp.status != 200) 
				{
					//alert("Error occured while saving. Please try again ...."+xmlhttp.status);
				}
				else
				{					
				}
			}
		}
		xmlhttp.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
		xmlhttp.send(params);
	}
}
function getXMLObject()  //XML OBJECT
{
	var xmlHttp = false;
	try 
	{
		xmlHttp = new ActiveXObject("Msxml2.XMLHTTP");
	}
	catch (e) 
	{
		try 
		{
			xmlHttp = new ActiveXObject("Microsoft.XMLHTTP");
		}
		catch (e2) 
		{
			xmlHttp = false;
		}
	}
	if (!xmlHttp && typeof XMLHttpRequest != 'undefined') 
	{
		xmlHttp = new XMLHttpRequest();
	}
	return xmlHttp;
}
function loadPopup(qUrl)
{
	if(!Ext.isEmpty(qUrl))
	{
		var tmpUrl = qUrl.substring(qUrl.indexOf("?") + 1);
		tmpUrl = "componentMeasureTabSet.jsp?" + tmpUrl;
		window.open(tmpUrl, 'GRAPHS', 'toolbar=no,menubar=no,location=no,status=no,width=1014,height=603,left=0,top=80,screenx=0,screeny=0,resizable=yes,scrollbars=yes');
	}
}
function OpenLayerModel(url)
{
	if(!Ext.isEmpty(url))
	{
		if(isMyDashboardTopology)
		{
			var dashboardName=encodeURIComponent('<%=profileName%>');
			var backBtnPrms="&profileName="+dashboardName;
			var setMyDashboardAsHome='<%=setMyDashboardAsHome%>';
			var isMyDashboardPopout='<%=isMyDashboardPopout%>';
			if(setMyDashboardAsHome!=null && setMyDashboardAsHome=="true")
			{
				backBtnPrms+="&setMonitorHome=true";
			}
			if(isMyDashboardPopout!=null && isMyDashboardPopout=="true")
			{
				backBtnPrms+="&isDisablePopupOption=true";
			}
			backBtnPrms=filterEncode(backBtnPrms);
			url=url+"&fromPage=myDashboard&backBtnUrl="+encodeURIComponent(backBtnPrms);
		}
		parent.location.href=url;
	}
}
function filterEncode(text)
{
	//['%;()=]
	var filterEncodeChar = ['[',']','(',')','=','%','\'','&',';','"'];
	var filterDecodeText = ['|lsbr|','|rsbr|','|lbr|','|rbr|','|eq|','|per|','|squot|','|ampsnd|','|scol|','|dqt|'];
	try
	{
		if(text != null && text != undefined && !Ext.isEmpty(text))
		{
			for(var a in filterEncodeChar)
			{
				var encode_char = filterEncodeChar[a];
				var decode_char = filterDecodeText[a];
				do
				{
					text=text.replace(encode_char,decode_char);
				}
				while (text.indexOf(encode_char)>-1);
			}
		}
	}
	catch (e)
	{
	}
	return text;
}
var tip = null;
function showAlarmListOnHover(paramVal,title, pagex, pagey)
{
	if( !event ) event = window.event; 

	var tipX=event.clientX-280;
	var tipY=event.clientY-180;
	if(tip!=null && tip!=undefined)
	{
		tip.close();
		tip=null;
	}

	var url_value = '/final/monitor/alarmsList.jsp?compName=' + paramVal + '&site=<%=segmentName%>';
	if(isMyDashboardTopology)
	{
		var dashboardName=encodeURIComponent('<%=profileName%>');
		url_value = url_value+'&fromMyDashboard='+fromMyDashboard+'&anonymousUser=<%=anonymousUser%>&profileName='+dashboardName+'&widgetWidth='+widgetWidth+'&widgetHeight='+widgetHeight;
	}
	Ext.Ajax.request({
		url: url_value,
		success: function(respons)
		{
			var response = respons.responseText;
			var jsonData = Ext.decode(response);
			var gridData = jsonData.tableData;
			if(gridData != "NO_DATA"){
				/*if (tip) {
					tip.destroy();
					tip = null;
				}
			var tip = new Ext.ToolTip({
							title: title,
							closeAction : 'destroy',
							cls: 'x-tip-whitethemes d3popup',
							width: '40%',
							autoHide: false,
							mouseOffset: [pagex, pagey],
							html: gridData,
							anchorToTarget: true,
							listeners: {
									
							'render': function(tt){
								timeout = window.setTimeout(function(){
										tt.hide();
								}, 2000);

								tt.body.on('mouseout', function(e){
									if(!e.within(tt.body, true)){
										timeout = window.setTimeout(function(){
											tt.hide();
										}, 500);
									}
								},this);
										
								tt.body.on('mouseover', function(){
								window.clearTimeout(timeout);

								});
							},
							hide: function () {
								this.destroy();
								//this = null;
							}
						}
					}).show();*/
					tip = Ext.create('Ext.tip.ToolTip',{
						maxWidth:600,
						//height:105,
						trackMouse: true,
						anchor:'bottom',
						border:false,
						//closable:false,
						//closable:true,
						id:'alarmPopup',
						closeAction: 'destroy',
						//cls:'uxLogonTooltip',
						//cls: 'x-tip-whitethemes d3popup',
						ui:'newTooltipPopup',
						frame:false,
						//modal:true,
						anchorOffset:264,
						tools:[
								{
									xtype:'button',
									border:0,
									cls:'iconClosePopup',
									width:16,
									height:16,
									handler:closeDiv

								}

						],
						dismissDelay:1111144000,
						//bodyPadding:'0 5 0 5',
						bodyPadding:'5 5 5 5',
						constrainPosition : true,
						//renderTo: Ext.getBody(),
						autoScroll:false,
						padding:0,
						scroll:false,
						//header:false,
						title:"<div><span style='text-transform: uppercase;padding:0px' >Alerts for Component - "+title+"</span></div>",
						//title:"<div style='border:1px solid red;width:100% !important;text-transform: uppercase;margin-left:4px !important'>Alerts for Component - "+title+"</div>",
						//html:"<div class='alarmTooltipHeaderfont' style='width:100%'><div style='padding:5px;float:left;text-transform: uppercase;'>Alerts for Component - "+title+"</div><div class=\"iconClosePopup\" onclick=\"closeDiv()\" style='margin-top:3px;float:right'></div></div><div class='crl'/><div>"+gridData+"</div>",
						//<div style='border:0px solid red;height:92px;overflow:auto;margin-top:3px'>
						html:gridData,
						layout : {
								type : 'fit',
								//align : 'stretch'
					}
				});

				if(tip!=null && tip!=undefined)
				{
					//win.destroy();
					tip.showAt([tipX,tipY]);
				}
			}
		},
		failure: function(){
			/**Ext.Msg.show({
					title: 'Topology',
					msg: 'Request failed',
					icon: 'iconExclamation',
					buttons: Ext.Msg.OK
				});
				**/
		}
	});
}
function getPaperHeight(paperHeight)
{	
	var winHeight = $( window ).height();
	if(paperHeight < winHeight || isAutoFit === true){
		paperHeight = winHeight;
	}
	return paperHeight;
}
function getPaperWidth(paperWidth)
{	
	var winWidth = $( window ).width();
	if(paperWidth < winWidth || isAutoFit === true){
		paperWidth = winWidth;
	}
	return paperWidth;
}
$(window).ready(function(){
	var url = '<%=link%>';
	isAutoFit = ('<%=topologyRenderingMode%>' == 'auto')?true:false;
	/* if(isMyDashboardTopology)
	{
		var anonymousUser='<%=anonymousUser%>';
		if(anonymousUser!=null && anonymousUser=='true')
		{
			url=encodeURI(url);
		}
	}*/
	Ext.Ajax.request({
			url:url,
			success:function(respons)
			{
				var response = respons.responseText;
				var jsonData = Ext.decode(response);
				var rootJson = jsonData['rootJson'];

				var paperHeight = jsonData.rootJson.paper['height'];
				var paperWidth = jsonData.rootJson.paper['width'];
				var zoomLevel = jsonData.rootJson.paper['zoomLevel'];
				var pan_X = jsonData.rootJson.paper['pan_X'];
				var pan_Y = jsonData.rootJson.paper['pan_Y'];
				
				var topologyPosition = jsonData.rootJson.paper['layoutAlign'];
				paperHeight = getPaperHeight(paperHeight);
				paperWidth = getPaperWidth(paperWidth);

				if(zoomLevel == null || zoomLevel.length == 0 || zoomLevel == 100){
					zoomLevel = 1;// default zoom value is 1
				}
				if(pan_X == null || pan_X.length == 0 ){
					//pan_X = $( window ).width()/2;// default pan X value is -8
					pan_X = -8;// default pan X value is -8
				}
				if( pan_Y == null ||  pan_Y.length == 0){
					//pan_Y = $( window ).height()/2;// default pan Y value is -8
					pan_Y = -8;// default pan Y value is -8
				}
				var zoomLevelTopoValSet = -1;
				var translateTopoValSet = "";
				var zoomLevelTopoValt= <%=zoomLevelTopoVal%>;
				var translateTopoValt= '<%=translateTopo%>';
				if(zoomLevelTopoValt != null && zoomLevelTopoValt > 0)
					zoomLevelTopoValSet = zoomLevelTopoValt;
				if(translateTopoValt != undefined && translateTopoValt != null && translateTopoValt.trim().length > 0)
					translateTopoValSet = translateTopoValt;

				var groupOpenIdTopoValt= "";
				var pageNoTopoValt= "";

				if(parent.topoGroupSaveSeg != null && parent.topoGroupSaveSeg.trim().length > 0)
				{
					groupOpenIdTopoValt = parent.topoGroupSaveSeg.substring(0,parent.topoGroupSaveSeg.indexOf("~~"));
					pageNoTopoValt = parent.topoGroupSaveSeg.substring(parent.topoGroupSaveSeg.indexOf("~~")+2);
				}
				
				$('#diagram').renderSvg({
					renderTo: '#diagram',					
					initialX: pan_X,
					initialY: pan_Y,
					fromPage: '<%=seglbl%>',
					searchlbl: '<%=searchlbl%>',
					fitlbl: '<%=fitlbl%>',
					//height:$( window ).height(),
					zoom: true,
					draggable: false,
					enableFitLayout: true,
					zoomLevelTopoValSet:zoomLevelTopoValSet,
					translateTopoValSet:translateTopoValSet,
					groupOpenIdTopoValt:groupOpenIdTopoValt,
					pageNoTopoValt:pageNoTopoValt,
					//layoutAlign: topologyPosition,
					layoutAlign: "center",
					collideLayout: isAutoFit,
					segmentStateCls: '<%=segmentState%>', 
					segmentName: '<%=segmentName%>',
					width: paperWidth+15,
					height: paperHeight+15,
					isShowSegmenrServiceHeader : isMyDashboardTopology?false:true,
					//default_zoom: zoomLevel,
					//width: $( window ).width(),
					data: jsonData
				}); 
						
			},
			failure: function(){
				Ext.Msg.show({
						title: 'Topology',
						msg: 'Request failed',
						icon: 'iconExclamation',
						buttons: Ext.Msg.OK
					});
			}
			}); 

/**
$('#diagram').renderSvg({
		renderTo: '#diagram',
		//height:2780,
		zoom:true,
		draggable:false,
		width:$('#diagram').width(),
		url:url
	});
	**/
});


</script>

</body>
</html>


<% 
%>