<%
/**************************************************************************************************************
*	Name				:	EgEventHistoryFrame.jsp
*	Version				:	eG 3.0
*	Purpose				:	Top frame of Event History Page
*	Creation Date	:	13/03/2003
*	Author				:	Arun Jayaprakash
*	Last Modified		:	
				20/04/2004 M.Saravanan	pickdate.htm is replaced by EgCalendar.jsp in window.open
*				17/03/2003	Arun	Included code to validate selection of component names and types.
*									Corrected bug that would occur if the user was allowed to proceed 
*									without selecting component name or type, if All Events was not chosen.
*				18/03/2003	Arun	Integrate AlarmHistoryAdapter, Bug fixes - Goto Page, Data validation 
*									using JavaScript
*				19/03/2003	Arun	Fixed recurring bugs with pager-taglib
*				29/07/2003	John	eG 3.0 Layout Modifications
*				17/12/2003	Arun	Included check for duration filters with decimal points
*				16/03/2006	James Thomas added CSV.gif, PDF.gif files and saveMe(), saveInCSVFormat functions
				17-07-2007  Saravanan.A  Changed the action path in onShowAlarms().

Design Changes		:		Jaiwin		9-11-06
*************************************************************************************************************/
%>

<%@ include file="EgLoginTracker.jsp" %>
<%@ page errorPage = "EgProbsM.jsp" %>
<%@ page import = "com.eg.EgDateInfo"%>
<%@ page import = "com.eg.EgDbAdapterTypeUI" %>
<%@ page import = "com.eg.EgDbInfo" %>
<%@ page import = "com.eg.EgInstallInfo" %>
<%@ page import = "com.eg.IniFile" %>
<%@ page import = "com.egurkha.*" %>
<%@ page import = "com.egurkha.util.*" %>
<%@ page import = "com.egurkha.monitor.alarms.*" %>
<%@ page import = "egurkha.EgDbAdapterUI" %>
<%@ page import = "egurkha.EgSettingsTimeStamp" %>
<%@ page import = "java.util.*" %>
<%@ page import = "com.eg.LangInfo"%>
<%@ page import = "com.eg.EgMappingInfo"%>

<%@ page import = "com.egurkha.ini.IniUI"%>
<%@ page import = "com.eg.EgName" %>
<%@ page import = "com.eg.MappingNameSorter"%>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ page import = "com.egurkha.pdfmaker.*"%>
<%@ page import = "com.eg.EgURLEncoder"%>
<%@ page import="com.egurkha.monitor.EgServerDashBoardDAO"%>
<%@ page import="com.egurkha.monitor.EgServerDashboardModel"%>
<%@ page import ="com.eg.EgViewInfo" %>
<%@ page import = "egurkha.reporter.*" %>
<%@ page import ="com.eg.EgTopoInfo"%>
<%@ page import ="com.eg.EgGroupInfo"%>
<html>
<head>
<title> &nbsp; eG Manager &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; </title>
<egui:skin ui="monitor"/>
<meta name="Author" content="John Williams" />
<!--<link rel="stylesheet" href="eg_styles/eg_monitorstyle.css" />-->
<!--<link rel="stylesheet" href="eg_styles/monstyle_gray.css" />-->


<%
     response.setHeader("Cache-Control","no-store");
     response.setHeader("Pragma","no-cache");
     response.setDateHeader("Expires", -1);

	String ua = request.getHeader( "User-Agent" );
	boolean isFirefox2 = ( ua != null && ua.indexOf( "Firefox/2." ) != -1 );
	boolean isFirefox3 = ( ua != null && ua.indexOf( "Firefox/3." ) != -1 );
	boolean isMSIE6 = ( ua != null && ua.indexOf( "MSIE 6.0" ) != -1 );
	boolean isMSIE7 = ( ua != null && ua.indexOf( "MSIE 7.0" ) != -1 );
	response.setHeader( "Vary", "User-Agent" );
%>

<%
		String uiFile = "eg_ui.ini";
		String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
		IniFile egUI = new IniFile(s_iniFile_dir + uiFile);
		String currentDateFormat = egUI.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
		String fromDashBoard=request.getParameter("fromDashBoard");
		boolean isFromDashBoard=fromDashBoard!=null && fromDashBoard.equals("true");
		String layerName=request.getParameter("selectedLayer");
		String tab=request.getParameter("tab");

		UserRegistry registry = UserRegistry.getInstance();
		User user = registry.getUser(session.getId());
		
		String loginid = user.getLoginID();
		LangInfo langinfo = new LangInfo(loginid);
		String LABELS = "LABELS";
		com.egurkha.ini.IniUI uiObj = (com.egurkha.ini.IniUI)com.egurkha.ini.IniUI.getInstance();
		//String thisLanguage = "en_US";
		String thisLanguage = uiObj.getDefaultLanguage();
		if (user!=null)
		{
			String userLang = user.getLanguage();
			if (userLang!=null && !userLang.equalsIgnoreCase("NULL"))
			{
				thisLanguage=userLang;
			}
		}
		EgMappingInfo mappingInfo = new EgMappingInfo(thisLanguage);
		//added by ahamed
		String rowIncrement = egUI.getValue("ALARMS","Row_Multiplier");
		if(rowIncrement == null || rowIncrement.equals(""))
			rowIncrement = "10";

		String optionsCount = egUI.getValue("ALARMS","Options_Count");
		if(optionsCount == null || optionsCount.equals(""))
			optionsCount = "5";
		
		int increment = Integer.parseInt(rowIncrement);
		int optionCount = Integer.parseInt(optionsCount);
		String rowsPerPage[] = new String[optionCount+1];
		for(int i=0;i<=optionCount;i++)
		{
			int j=i+1;
			if(j==rowsPerPage.length)
				rowsPerPage[i] = "All";
			else
				rowsPerPage[i] = "" + j* increment;
		}
		//end

		EgDateInfo egDt = new EgDateInfo();
		java.util.Date local_date = new java.util.Date(egDt.egetUTCDate());
		Calendar cal = Calendar.getInstance();
		cal.setTime(local_date);
		cal.setTimeZone(egDt.getRealTimeZone());

		Vector layers = new Vector();
		String selectedLayer=(layerName!=null && layerName.equalsIgnoreCase("All"))?"Operating System":layerName;
		boolean showLayersSelectBox=false;
		if(isFromDashBoard)
		{
			EgServerDashBoardDAO dashboardDAO=new EgServerDashBoardDAO();
			EgServerDashboardModel dashboardModel=new EgServerDashboardModel();
			StringBuffer sb_layer=new StringBuffer();
			String selCompType=request.getParameter("compTypeList");
			String isNoComponentsSelected=request.getParameter("NoComponentsSelected");
			showLayersSelectBox=isFromDashBoard  && (selCompType!=null && selCompType.equalsIgnoreCase("Host_system")  || tab!=null && tab.equalsIgnoreCase("Application"));
			layers.add("All");
			if(isNoComponentsSelected!=null && isNoComponentsSelected.equals("true"))
			{
				Vector hostLayers=dashboardModel.getLayersForModule(selCompType,"System");
				Vector networkLayers=dashboardModel.getLayersForModule(selCompType,"Network");
				if(hostLayers!=null && !hostLayers.isEmpty())
				{
					layers.addAll(hostLayers);
				}
				if(networkLayers!=null && !networkLayers.isEmpty())
				{
					layers.addAll(networkLayers);
				}
			}
			else if(tab!=null && tab.equalsIgnoreCase("System"))
			{
				Vector hostLayers=dashboardModel.getLayersForModule(selCompType,"System");
				if(hostLayers!=null && !hostLayers.isEmpty())
				{
					layers=hostLayers;
				}
			}
			else if(tab!=null && tab.equalsIgnoreCase("Network"))
			{
				Vector networkLayers=dashboardModel.getLayersForModule(selCompType,"Network");
				if(networkLayers!=null && !networkLayers.isEmpty())
				{
					layers.addAll(networkLayers);
				}
			}
			else if(tab!=null && tab.equalsIgnoreCase("Application"))
			{
				Vector applicationLayers=dashboardModel.getLayersForModule(selCompType,"Application");
				if(applicationLayers!=null && !applicationLayers.isEmpty())
				{
					layers.addAll(applicationLayers);
				}
			}
			else if(tab!=null && tab.equalsIgnoreCase("custom"))
			{
				Vector applicationLayers=dashboardModel.getLayersForModule(selCompType,"All");
				if(applicationLayers!=null && !applicationLayers.isEmpty())
				{
					layers.addAll(applicationLayers);
				}
			}
		}
		ErUserData erdata = new ErUserData(loginid,false);
		Vector v_zone=new Vector();
		Vector v_site=new Vector();
		Vector v_segment=new Vector();
		v_zone.addAll(user.getZones());
		v_segment=erdata.getSegments();
		v_site=erdata.getSites();
		ArrayList event_for=new ArrayList();
		if(v_zone!=null && v_zone.size()>0)
		{
			event_for.add("Zone");
		}
		if(v_site!=null && v_site.size()>0)
		{
			event_for.add("Service");
		}
		if(v_segment!=null && v_segment.size()>0)
		{
			event_for.add("Segment");
		}

		event_for.add ("Component");
		Collections.sort(event_for);
%>
<script language="JavaScript1.2" src="eg_scripts/eg_date.js"></script>
<script language="JavaScript1.2" src="../scripts/<%=script_src%>"></script>

<script language="javascript">
// ---- Saravanan.A Changed this code on 16-07-07, checkwindow() to checkwindow2()
<!-- pickdate.htm is replaced by EgCalendar.jsp by M.Saravanan-->
//oCalendar=window.open("EgCalendar.jsp?cal=yes","eg_mondate","resizable=yes,width=364,height=210,scrollbar=yes");

function checkwindow2(datef,event)
{
	event=event?event:window.event;
	var datefv = formatDate(new Date(getDateFromFormat(datef.value,'<%=currentDateFormat%>')),"MM/dd/yyyy");
	if (oCalendar && !oCalendar.closed)
	{
		oCalendar.focus();
		cleanup();
	}
	else
	{
		//callcalendar(datef);
		var screenname="EgTimeLine";
		callcalendar3(datef,datefv,event,screenname);
	}
}

function cleanup()
{
	if(oCalendar != null)
	{
		oCalendar.close();
	}
}
</script>
<script language="JavaScript1.2" src="/final/monitor/eg_scripts/eg_eventhistory.js">
</script>
<script language="JavaScript1.2" src="/final/monitor/eg_scripts/eg_validate.js">
</script>
<script language="javascript">

function getDateObj(date, hour)
{
	var index = date.indexOf("/");
	var lastIndex = date.lastIndexOf("/");

	var month = date.substr(0, index)-1;
	var day = date.substr(index+1, lastIndex-index-1);
	var year = date.substr(lastIndex+1);

	var dateObj = new Date(year, month, day, hour, 0, 0);
	return dateObj;
}

var req;
function eventselection()
{
	var thisForm=document.forms[0];
	var v_event = thisForm.eventfor.options[thisForm.eventfor.selectedIndex].value;
	var paramValue="v_event="+v_event;

	try
	{
		req=new XMLHttpRequest();
	}
	catch (e)
	{
		try
		{
			req=new ActiveXObject("Msxml2.XMLHTTP");
		}
		catch (e)
		{
			try
			{
				req=new ActiveXObject("Microsoft.XMLHTTP");
			}
			catch (e)
			{
				alert('<egui:intnl text="monitor.history.Not Support the Browser"/>');
				return false;
			}
		}
	}
	try
	{
		var params = paramValue;
		var url = "/final/monitor/EgEventHistoryFrame.jsp";
		req.onreadystatechange=callback;
		req.open('POST',url,true);
		req.setRequestHeader('Content-type','application/x-www-form-urlencoded');
		req.setRequestHeader('Content-length',params.length);
		req.setRequestHeader('Connection','close');
		req.send(params);
	}
	catch(e)
	{
		alert(e);
	}
}
function subeventselect()
{
	var thisForm=document.forms[0];
	var subevent=null;
	var v_event = thisForm.eventfor.options[thisForm.eventfor.selectedIndex].value;
	if(v_event!=null && v_event!="")
		subevent=thisForm.event_select.options[thisForm.event_select.selectedIndex].value;
	if(v_event!=null && (v_event=='Service' || v_event=='Segment' || v_event=='Zone'))
	{
		subevent=thisForm.event_select.options[thisForm.event_select.selectedIndex].value;
		if(v_event!=null && v_event=='Service' && (subevent==null || subevent=='Please choose a Service' || subevent=="" || subevent=="undefined" || subevent=="-1"))
		{
			return;
		}
		else if(v_event!=null && v_event=='Segment' && (subevent==null || subevent=='Please choose a Segment' || subevent=="" || subevent=="undefined" || subevent=="-1"))
		{
			return;
		}
		else if(v_event!=null && v_event=='Zone' && (subevent==null || subevent=='Please choose a Zone' || subevent=="" || subevent=="undefined" || subevent=="-1"))
		{
			return;
		}
	}
	var paramValue="v_event="+v_event+"&subevent="+subevent;

	try
	{
		req=new XMLHttpRequest();
	}
	catch (e)
	{
		try
		{
			req=new ActiveXObject("Msxml2.XMLHTTP");
		}
		catch (e)
		{
			try
			{
				req=new ActiveXObject("Microsoft.XMLHTTP");
			}
			catch (e)
			{
				alert('<egui:intnl text="monitor.history.Not Support the Browser"/>');
				return false;
			}
		}
	}
	try
	{
		var params = paramValue;
		var url = "/final/monitor/EgEventHistoryFrame.jsp";
		req.onreadystatechange=callback;
		req.open('POST',url,true);
		req.setRequestHeader('Content-type','application/x-www-form-urlencoded');
		req.setRequestHeader('Content-length',params.length);
		req.setRequestHeader('Connection','close');
		req.send(params);
	}
	catch(e)
	{
		alert(e);
	}
}

function subZone()
{
	var thisForm=document.forms[0];
	var subevent=null;
	var v_event = thisForm.eventfor.options[thisForm.eventfor.selectedIndex].value;
	if(v_event!=null && v_event!="")
		subevent=thisForm.event_select.options[thisForm.event_select.selectedIndex].value;
	var selectedsubzone=thisForm.includeSubZone.options[thisForm.includeSubZone.selectedIndex].value;
	var paramValue="v_event="+v_event+"&subevent="+subevent+"&selectedsubzone="+selectedsubzone;
	try
	{
		req=new XMLHttpRequest();
	}
	catch (e)
	{
		try
		{
			req=new ActiveXObject("Msxml2.XMLHTTP");
		}
		catch (e)
		{
			try
			{
				req=new ActiveXObject("Microsoft.XMLHTTP");
			}
			catch (e)
			{
				alert('<egui:intnl text="monitor.history.Not Support the Browser"/>');
				return false;
			}
		}
	}
	try
	{
		var params = paramValue;
		var url = "/final/monitor/EgEventHistoryFrame.jsp";
		req.onreadystatechange=callback;
		req.open('POST',url,true);
		req.setRequestHeader('Content-type','application/x-www-form-urlencoded');
		req.setRequestHeader('Content-length',params.length);
		req.setRequestHeader('Connection','close');
		req.send(params);
	}
	catch(e)
	{
		alert(e);
	}
}
function findComponents(val)
{
	var thisForm=document.forms[0];
	var v_event = thisForm.eventfor.options[thisForm.eventfor.selectedIndex].value;
	var subevent=null;
	var selectedsubzone=null;

	if(v_event!=null && v_event!="" && (v_event=='Service' || v_event=='Zone' || v_event=='Segment'))
		subevent=thisForm.event_select.options[thisForm.event_select.selectedIndex].value;
	if(subevent!=null && subevent!="" && v_event=='Zone')
		selectedsubzone = thisForm.includeSubZone.options[thisForm.includeSubZone.selectedIndex].value;
	var ctype = document.Event.compTypeList.value;
	var cname = document.Event.compNameList.value;
	var st = document.Event.state.value;
	var dur = document.Event.duration.value;
	var ts = document.Event.timeselect.value;
	var cond = document.Event.glduration.value;
	var tline = document.Event.eg_timeline.value;
	var stdate = document.Event.eg_stdate.value;
	var enddate = document.Event.eg_enddate.value;
	var sthr = document.Event.starthr.value;
	var endhr = document.Event.endhr.value;
	var arrAlarms = document.Event.arrangeAlarms.value;
	var infosearch = document.Event.search.value;
	if(val=='Type')
	{
		document.Event.compTypeList.value=ctype;
		if(ctype=='-1' || ctype=='Host_system')
		{
			document.Event.compNameList.value='-1';
			cname='-1';
		}
	}
	
	if(cond)
	{
		dur = "0" + dur;
	}
	var paramValue=null;
	paramValue="v_event="+v_event+"&subevent="+subevent+"&selectedsubzone="+selectedsubzone+"&compTypeList=" + encodeURI(ctype) +"&compNameList=" + encodeURI(cname) +"&state=" + st + "&duration=" + dur + "&timeselect=" + ts + "&eg_timeline=" + tline + "&arrangeAlarms=" + arrAlarms+"&infosearch="+infosearch;
	if(tline == "Any")
	{
		paramValue = paramValue + "&eg_stdate=" + stdate + "&eg_enddate=" + enddate + "&starthr=" + sthr + "&endhr=" + endhr;
	}
	try
	{	// Firefox, Opera 8.0+, Safari
		req=new XMLHttpRequest();
	}
	catch (e)
	{	// Internet Explorer
		try
		{
			req=new ActiveXObject("Msxml2.XMLHTTP");
		}
		catch (e)
		{
			try
			{
				req=new ActiveXObject("Microsoft.XMLHTTP");
			}
			catch (e)
			{
				alert('<egui:intnl text="monitor.history.Not Support the Browser"/>');
				return false;
			}
		}
	}
	try
	{
		var params = paramValue;
		var url = "/final/monitor/EgEventHistoryFrame.jsp";
		req.onreadystatechange=callback;
		req.open('POST',url,true);
		req.setRequestHeader('Content-type','application/x-www-form-urlencoded');
		req.setRequestHeader('Content-length',params.length);
		req.setRequestHeader('Connection','close');
		req.send(params);
	}
	catch(e)
	{
		alert(e);
	}
}

function callback() 
{
	if(req.readyState == 4) 
	{
		if (req.status == 200) 
		{
			// update the HTML DOM based on whether or not message is valid
			document.getElementById("refframe").innerHTML=req.responseText;
		}
		
	}
}


function onShowAlarms()
{
	var thisForm=document.forms[0];
	var v_event = "";
	if (thisForm.eventfor != null)
		v_event = thisForm.eventfor.options[thisForm.eventfor.selectedIndex].value;
	var subevent=null;
	var selectedsubzone=null;

	if(v_event!=null && (v_event=='Service' || v_event=='Segment' || v_event=='Zone'))
	{
		subevent=thisForm.event_select.options[thisForm.event_select.selectedIndex].value;
		if(v_event!=null && v_event=='Service' && (subevent==null || subevent=='Please choose a Service' || subevent=="" || subevent=="undefined" || subevent=="-1"))
		{
			alert('<egui:intnl text="monitor.history.Please choose a Service"/>');
			return;
		}
		else if(v_event!=null && v_event=='Segment' && (subevent==null || subevent=='Please choose a Segment' || subevent=="" || subevent=="undefined" || subevent=="-1"))
		{
			alert('<egui:intnl text="monitor.history.Please choose a Segment"/>');
			return;
		}
		else if(v_event!=null && v_event=='Zone')
		{
			if(subevent==null || subevent=='Please choose a Zone' || subevent=="" || subevent=="undefined" || subevent=="-1")
			{
				alert('<egui:intnl text="monitor.history.Please choose a Zone"/>');
				return;
			}
			else
			{
				selectedsubzone = thisForm.includeSubZone.options[thisForm.includeSubZone.selectedIndex].value;
			}
		}
	}
	var allOk = "true";
	var selectedType = document.Event.fNameType;
	var compType = document.Event.compTypeList;
	var layers=document.Event.layers;
	var selectedCompName=document.Event.compNameList.value;	
	if(layers!=null && layers!="undefined")
	{
		var selectedLayerHid=document.Event.selectedLayer;
		var layername=layers.value;
		if(layername!=null && layername=="OS")
		{
			layername="system";
		}
		selectedLayerHid.value=layername;
	}

	if(compType!=null && compType.value=="Host_system" && selectedCompName!=null && selectedCompName=="Component name (Optional)")
	{
		var NoComponentsHiddenField=document.getElementById("NoComponentsSelected");
		if(NoComponentsHiddenField!=null && NoComponentsHiddenField!="undefined")
		{
			NoComponentsHiddenField.value="true";
		}
	}
	
	/*if (compType.selectedIndex == 0 && document.Event.compTypeList.options[0].text == "Choose a component type")
	{
		allOk = "false";
		alert("Please select a component type");
	}
	if(compType.selectedIndex > 0)
	{
			var compName = document.Event.compNameList;
			if (compName.selectedIndex == 0 && document.Event.compNameList.options[0].text == "Choose a component name")
			{
				allOk = "false";
				alert("Please select a component name");
			}
	}*/
	if (allOk == "true")
	{
		var startDate = document.Event.eg_stdate;
		var endDate = document.Event.eg_enddate;
		if ((startDate != null) && (endDate != null))
		{
			var startHr = document.Event.starthr.options[document.Event.starthr.selectedIndex];
			var endHr = document.Event.endhr.options[document.Event.endhr.selectedIndex];
			var ssdate = formatDate(new Date(getDateFromFormat(startDate.value,'<%=currentDateFormat%>')),"MM/dd/yyyy");
			var eedate = formatDate(new Date(getDateFromFormat(endDate.value,'<%=currentDateFormat%>')),"MM/dd/yyyy");
			var  s_yr = <%=cal.get(cal.YEAR)%>;
			var s_mon = <%=cal.get(cal.MONTH)%>;
			var s_day = <%=cal.get(cal.DAY_OF_MONTH)%>;
			var s_hr = <%=cal.get(cal.HOUR_OF_DAY)%>;
			s_mon=s_mon+1;
			if(checkCurrentTime(s_mon+"/"+s_day+"/"+s_yr,ssdate,eedate,s_hr,startHr,endHr))
			{
				alert('<egui:intnl text="monitor.common.From and To Date should be lesser than Current date"/>');
				return false;
			}
			if(!checktime(ssdate,eedate,startHr,endHr))
			{
				allOk = "false";
				alert('<egui:intnl text="monitor.common.Start date should be lesser than end date"/>');
			}
		}
	}

	var duration = document.Event.duration.value;
	var gldur = document.Event.glduration.value;
	var search = thisForm.search.value;
	if(duration < 0 && gldur!=null && gldur!="")
	{
		allOk = "false";
		alert('<egui:intnl text="monitor.history.Duration filter cannot be less than or equal to 0"/>');
		document.Event.duration.value = "";
		document.Event.duration.focus();
	}
	else if (!checkspecial(document.Event.duration, "."))
	{
		allOk = "false";
		alert('<egui:intnl text="monitor.history.Duration filter cannot contain decimal points"/>');
		document.Event.duration.value = "";
		document.Event.duration.focus();
	}
	else
	{
		if (onFilter() && allOk == "true")
		{
			allOk = "true";
		}
		else
		{
			allOk = "false";
		}
	}

	if (allOk == "true")
	{
		//document.Event.action = "/final/monitor/EventHistoryRedirect.jsp?eventsCount=0";
		document.Event.action = "/final/monitor/EgEventHistoryView.jsp?eventsCount=0";
		document.Event.submit();
	}
}
var	win=null;
function saveMe()
{
	
	
	if(window.document.getElementById("hidVpdfData")!=null & window.document.getElementById("hidVpdfData").value=='true')
	{
		var	blankPage =	"";
		if(location.protocol=="https:")	blankPage="/final/blank.html";
		
	
		win	=window.open(blankPage,"SaveWindow","width=400,height=150,left=300,top=200,scrollbars=no,resizable=no");
		
		win.document.write("<html>");
		win.document.write("<title>Downloading</title>");
		win.document.write("<frameset rows=	'0%,0%,*' frameborter='NO' border='0' framespacing='0'>");
		
		//win.document.write("<frame src='/final/servlet/com.eg.EgAdminPdfC'	frameborder=0 noresize scrolling=no name='Data'>");
		win.document.write("<frame src='/final/servlet/com.eg.EgPdfController?alarmhistory=Yes'	frameborder=0 noresize scrolling=no name='Data'>");
		
		win.document.write("<frame src='/final/reporter/ErSaveStatus.jsp' frameborder=0	noresize scrolling=auto>");
		win.document.write("<frame src='" +	blankPage +	"' frameborder=0 noresize scrolling=auto name='statusPanel'>");
		win.document.write("</frameset>");
		win.document.write("</html>");
		
		win.frames[2].document.open("text/html","replace");
		win.frames[2].document.write('<html><head><egui:skin ui="monitor"/></head><body id="main_bodybg"><br><br><h4 align="center" style="font-family: Verdana,Arial; font-size: 15px; color: #000000;"><img src="/final/reporter/images/load_round.gif" alt="<egui:intnl text="monitor.common.DOWNLOADING"/>" title="<egui:intnl text="monitor.common.DOWNLOADING"/>"><br><br>Downloading! Please wait...</h4></body></html>');
		win.frames[2].document.close();
	}
	else if(window.document.getElementById("hidVpdfData")==null || window.document.getElementById("hidVpdfData").value=='false')
	{
		alert('<egui:intnl text="monitor.history.No Alarm Found"/>');
		return false;
	}

	//setTimeout("closeSaveMe(win)",10000);
	
}
/*function closeSaveMe(per)
{
	if(per!=null)per.close();
}*/
function saveInCSVFormat()
{
	if(window.document.getElementById("hidVpdfData")!=null & window.document.getElementById("hidVpdfData").value=='true')
	{
		window.location.href="../servlet/egurkha.reporter.SaveInCSVFormat?alarmhistory=Yes","CSVFormat","width=1012,height=603,left=0,top=105,scrollbars=1,scrollbars=yes,resizable=yes";
	}
	else if(window.document.getElementById("hidVpdfData")==null || window.document.getElementById("hidVpdfData").value=='false')
	{
		alert('<egui:intnl text="monitor.history.No Alarm Found"/>');
		return false;
	}
}

</script>
</head>
<%! 
	String[] choices = {"All Events", "Component Name", "Component Type"};
	String[] timeOptions = {"seconds", "minutes", "hours", "days"};
	String[] showState = {"All","Critical & Major","Critical","Major","Minor"};
	String[] stateValues={"","HIGHINTERMEDIATE","HIGH","INTERMEDIATE","LOW"};
%>
<%
	boolean subzone=false;
	EgViewInfo egviewinfo=new EgViewInfo("manager");
	String eventfor =request.getParameter("eventfor");
	String event_select = request.getParameter("event_select");
	String s_event = request.getParameter("v_event");
	s_event=(s_event==null || s_event.equals(""))?"Component":s_event;
	String sub_event = request.getParameter("subevent");
	String includesubzone = request.getParameter("selectedsubzone");
	if(includesubzone==null)
		includesubzone = request.getParameter("includeSubZone");
	includesubzone=(includesubzone==null || includesubzone.equals(""))?"yes":includesubzone;
	if(includesubzone!=null && includesubzone.equalsIgnoreCase("yes"))
	{
		subzone=true;
	}

	String infosearch=request.getParameter("search");
	infosearch=(infosearch==null || infosearch.trim().length()==0 || infosearch.equals("null") || infosearch.equals(""))?"":infosearch;
	Vector v_availComps = new Vector();
	Vector v_segComp = new Vector();
	Vector v_zoneComponents = new Vector();
	String zoneComp=null;
	boolean allComps=false;
	ArrayList zoneList=new ArrayList();
	ArrayList innersubZone=new ArrayList();
	List innersubZoneComps=new LinkedList();
	ArrayList getZones=new ArrayList();
	List getServers=new LinkedList();
	List getSegmentComp=new LinkedList();
	EgTopoInfo topoInfo = new EgTopoInfo("manager");
	EgGroupInfo groupInfo = new EgGroupInfo();
	if(s_event!=null && s_event.trim().length()>0 && s_event.equals("Service"))
	{
		if(sub_event!=null && sub_event.length()>0 )
		{
			v_availComps = topoInfo.getComponentsForSite(sub_event);
		}
	}
	if(s_event!=null && s_event.trim().length()>0 && s_event.equals("Segment"))
	{
		if(sub_event!=null && sub_event.length()>0)
		{
			v_segComp = topoInfo.getComponentsForSegment(sub_event);
		}
	}

	if(s_event!=null && s_event.trim().length()>0 && s_event.equals("Zone"))
	{
		if(sub_event!=null && sub_event.length()>0)
		{
			allComps=true;
			innersubZone = groupInfo.getAllComponentsUnderZone(sub_event,subzone);
			if(!innersubZone.isEmpty())
			{
				innersubZoneComps =(List)innersubZone;
			}
		}
	}
	List servers = new LinkedList();
	List stypes = new LinkedList();
	List sNames=null;
	List nameTypes=null;
	List serverNames=null;
	servers.addAll(user.getServers(false));
	String selType = request.getParameter("compTypeList");
	String selName = request.getParameter("compNameList");
	boolean allTypes = false;
	String name = "";
	if(selType!=null && selType.equals("Component type (Optional)"))
		allTypes = true;
	int k =0;

	for(int i=0;i<v_availComps.size();i++)
	{
		String compTypes = (String)v_availComps.get(i);
		String comp_type=null;
		String comp_name=null;
		if(compTypes!=null && compTypes.trim().length()>0)
		{
			comp_name = compTypes.substring(0,compTypes.lastIndexOf(":"));
			comp_type = compTypes.substring(compTypes.lastIndexOf(":")+1);
			getServers.add(comp_type+":"+comp_name);
		}
	}

	for(int i=0;i<v_segComp.size();i++)
	{
		String compTypes = (String)v_segComp.get(i);
		String comp_type=null;
		String comp_name=null;
		if(compTypes!=null && compTypes.trim().length()>0)
		{
			comp_name = compTypes.substring(0,compTypes.lastIndexOf(":"));
			comp_type = compTypes.substring(compTypes.lastIndexOf(":")+1);
			getSegmentComp.add(comp_type+":"+comp_name);
		}
	}

	if(s_event == null || s_event.trim().length()==0 || s_event.equals("Component") )
	{
		sNames = new LinkedList();
		nameTypes = new LinkedList();
		serverNames = new LinkedList();
		for(k = 0; k < servers.size(); k++)
		{
			String server = (String)servers.get(k);
			StringTokenizer st_server = new StringTokenizer(server,":");
			String type = "";
			String comp = "";
			String port = "";
			String sid = "";
			String toAdd = "";
			int cntTokens = st_server.countTokens();
			if(st_server.hasMoreTokens())
			{
				type = st_server.nextToken();
				comp = st_server.nextToken();
				port = st_server.nextToken();
				if(cntTokens == 4)
					sid = st_server.nextToken();
			}
			if(selType !=null)
			{
				if(selName == null && allTypes)
				{
					if((type!=null && type.equals(selType)) || allTypes)
					{
						if(!port.equals("NULL"))
						{
							if(!sid.equals(""))
								toAdd = comp + ":" + port + ":" + sid;
							else
								toAdd = comp + ":" + port;
						}
						else
						{
							toAdd = comp;
						}
						if (!sNames.contains(toAdd))
							sNames.add(toAdd);
					}
					if(allTypes || selType.equals("Host_system"))
					{
						toAdd = comp;
						if (!sNames.contains(toAdd))
							sNames.add(toAdd);
					}
				}
				else if(selName!=null && allTypes)
				{
					if(!selName.equals("Component name (Optional)"))
					{
						name = selName;
						if(name.indexOf(":") < 0)
						{
							String comb = comp;
							//if(name.equals(comb))
							{
								if(port.equals("NULL"))
								{
									toAdd = comb;							
									if (!sNames.contains(toAdd))
										sNames.add(toAdd);
									if(!nameTypes.contains(type))
										nameTypes.add(type);
								}
							}
						}
						else
						{
							String comb = comp + ":" + port;
							if(!sid.equals(""))
								comb = comb + ":" + sid;
							//if(name.equals(comb))
							{
								toAdd = comb;
								if (!sNames.contains(toAdd))
									sNames.add(toAdd);
								if(!nameTypes.contains(type))
									nameTypes.add(type);
							}
						}
					}
					else
					{
						if(!port.equals("NULL"))
						{
							if(!sid.equals(""))
								toAdd = comp + ":" + port + ":" + sid;
							else
								toAdd = comp + ":" + port;
						}
						else
						{
							toAdd = comp;
						}
						if (!sNames.contains(toAdd))
							sNames.add(toAdd);
						
						if(!nameTypes.contains(type))
							nameTypes.add(type);
					}
				}
				else if(selName!=null && !allTypes)
				{
					if(!selName.equals("Component name (Optional)"))
					{
						name = "";
						name = selName;
						if(name.indexOf(":") < 0)
						{
							String comb = comp;
							
							//if(name.equals(comp))
							{
								//if(port.equals("NULL"))
								{
									if(selType.equals(type) || selType.equals("-1"))
									{
										if(!port.equalsIgnoreCase("NULL"))
										{
											comb = comb + ":" + port;
											if(!sid.equals(""))
												comb = comb + ":" + sid;
										}
										if (!sNames.contains(comb))
											sNames.add(comb);
										if(!nameTypes.contains(type))
											nameTypes.add(type);
									}
									if(selType.equals("Host_system"))
									{
										if (!sNames.contains(comb))
											sNames.add(comb);
									}
								}
							}
						}
						else
						{
							String comb = comp ;
							if(!port.equalsIgnoreCase("NULL"))
							{
								 comb = comp + ":" + port;
								if(!sid.equals(""))
									comb = comb + ":" + sid;
							}
							//if(name.equals(comb))
							{
								if(selType.equals(type) || selType.equals("-1"))
								{
									if (!sNames.contains(comb))
										sNames.add(comb);
								if(!nameTypes.contains(type))
									nameTypes.add(type);
								}
								if(selType.equals("Host_system"))
								{
									if (!sNames.contains(toAdd))
										sNames.add(comb);
								}
							}
						}

					}
					else
					{
						if(selType.equals(type) || selType.equals("-1"))
						{
							if(!port.equals("NULL"))
							{
								if(!sid.equals(""))
									toAdd = comp + ":" + port + ":" + sid;
								else
									toAdd = comp + ":" + port;
							}
							else
							{
								toAdd = comp;
							}
							if (!sNames.contains(toAdd))
								sNames.add(toAdd);
							if(!nameTypes.contains(type))
								nameTypes.add(type);
						}
						if(selType.equals("Host_system"))
						{
							if (!sNames.contains(comp))
								sNames.add(comp);
						}
					}

				}
				else if(selName == null && !allTypes)
				{
					if(selType.equals(type) || selType.equals("Host_system") || selType.equals("-1"))
					{
						if(!port.equals("NULL"))
						{
							if(!sid.equals(""))
								toAdd = comp + ":" + port + ":" + sid;
							else
								toAdd = comp + ":" + port;
						}
						else
						{
							toAdd = comp;
						}
						if (!sNames.contains(toAdd))
							sNames.add(toAdd);
						if(!nameTypes.contains(type))
							nameTypes.add(type);
					}
				}
			}
			else
			{
				if(port!=null && !port.equals("NULL"))
				{
					if(!sid.equals(""))
						toAdd = comp + ":" + port + ":" + sid;
					else
						toAdd = comp + ":" + port;
				}
				else
					toAdd = comp;
				if (!sNames.contains(toAdd))
					sNames.add(toAdd);
			}
		}
		servers = sNames;
		Collections.sort(servers);
		if(servers.size() > 1)
			serverNames.add("Component name (Optional)");
		serverNames.addAll(servers);
	}

	if(s_event!=null && s_event.trim().length()>0 && s_event.equals("Segment") && sub_event!=null && sub_event.trim().length()>0)
	{
		sNames = new LinkedList();
		nameTypes = new LinkedList();
		serverNames = new LinkedList();
		for(k = 0; k <getSegmentComp.size(); k++)
		{
			String server = (String)getSegmentComp.get(k);
			StringTokenizer st_server = new StringTokenizer(server,":");
			String type = "";
			String comp = "";
			String port = "";
			String sid = "";
			String toAdd = "";
			int cntTokens = st_server.countTokens();
			if(st_server.hasMoreTokens())
			{
				type = st_server.nextToken();
				comp = st_server.nextToken();
				port = st_server.nextToken();
				if(cntTokens == 4)
					sid = st_server.nextToken();
			}
			if(selType !=null)
			{
				if(selName == null && allTypes)
				{
					if((type!=null && type.equals(selType)) || allTypes)
					{
						if(!port.equals("NULL"))
						{
							if(!sid.equals(""))
								toAdd = comp + ":" + port + ":" + sid;
							else
								toAdd = comp + ":" + port;
						}
						else
						{
							toAdd = comp;
						}

						if (!sNames.contains(toAdd))
							sNames.add(toAdd);
					}
					if(allTypes || selType.equals("Host_system"))
					{
						toAdd = comp;
						if (!sNames.contains(toAdd))
							sNames.add(toAdd);
					}
				}
				else if(selName!=null && allTypes)
				{

					if(!selName.equals("Component name (Optional)"))
					{
						name = selName;
						if(name.indexOf(":") < 0)
						{
							String comb = comp;
							//if(name.equals(comb))
							{
								if(port.equals("NULL"))
								{
									toAdd = comb;
									if (!sNames.contains(toAdd))
										sNames.add(toAdd);
								if(!nameTypes.contains(type))
									nameTypes.add(type);
								}
							}
						}
						else
						{
							String comb = comp + ":" + port;
							if(!sid.equals(""))
								comb = comb + ":" + sid;
							//if(name.equals(comb))
							{
								toAdd = comb;
								if (!sNames.contains(toAdd))
									sNames.add(toAdd);
								if(!nameTypes.contains(type))
									nameTypes.add(type);
							}
						}
					}
					else
					{
						if(!port.equals("NULL"))
						{
							if(!sid.equals(""))
								toAdd = comp + ":" + port + ":" + sid;
							else
								toAdd = comp + ":" + port;
						}
						else
						{
							toAdd = comp;
						}
						if (!sNames.contains(toAdd))
							sNames.add(toAdd);
						
						if(!nameTypes.contains(type))
							nameTypes.add(type);
					}
				}
				else if(selName!=null && !allTypes)
				{

					if(!selName.equals("Component name (Optional)"))
					{
						name = "";
						name = selName;
						if(name.indexOf(":") < 0)
						{
							String comb = comp;
							
							//if(name.equals(comp))
							{
								//if(port.equals("NULL"))
								{
									if(selType.equals(type) || selType.equals("-1"))
									{
										if(!port.equalsIgnoreCase("NULL"))
										{
											comb = comb + ":" + port;
											if(!sid.equals(""))
												comb = comb + ":" + sid;
										}
										if (!sNames.contains(comb))
											sNames.add(comb);
										if(!nameTypes.contains(type))
											nameTypes.add(type);
									}
									if(selType.equals("Host_system"))
									{
										if (!sNames.contains(comb))
											sNames.add(comb);
									}
								}
							}
						}
						else
						{
							String comb = comp ;
							if(!port.equalsIgnoreCase("NULL"))
							{
								 comb = comp + ":" + port;
								if(!sid.equals(""))
									comb = comb + ":" + sid;
							}
							//if(name.equals(comb))
							{
								if(selType.equals(type) || selType.equals("-1"))
								{
									if (!sNames.contains(comb))
										sNames.add(comb);
								if(!nameTypes.contains(type))
									nameTypes.add(type);
								}
								if(selType.equals("Host_system"))
								{
									if (!sNames.contains(toAdd))
										sNames.add(comb);
								}
							}
						}

					}
					else
					{
						if(selType.equals(type) || selType.equals("-1"))
						{
							if(!port.equals("NULL"))
							{
								if(!sid.equals(""))
									toAdd = comp + ":" + port + ":" + sid;
								else
									toAdd = comp + ":" + port;
							}
							else
							{
								toAdd = comp;
							}
							if (!sNames.contains(toAdd))
								sNames.add(toAdd);
							if(!nameTypes.contains(type))
								nameTypes.add(type);
						}
						if(selType.equals("Host_system"))
						{
							if (!sNames.contains(comp))
								sNames.add(comp);
						}
					}
				}
				else if(selName == null && !allTypes)
				{
						if(selType.equals(type) || selType.equals("Host_system") || selType.equals("-1"))
						{
							if(!port.equals("NULL"))
							{
								if(!sid.equals(""))
									toAdd = comp + ":" + port + ":" + sid;
								else
									toAdd = comp + ":" + port;
							}
							else
							{
								toAdd = comp;
							}
							if (!sNames.contains(toAdd))
								sNames.add(toAdd);
							if(!nameTypes.contains(type))
								nameTypes.add(type);
						}
				}
			}
			else
			{
				if(port!=null && !port.equals("NULL"))
				{
					if(!sid.equals(""))
						toAdd = comp + ":" + port + ":" + sid;
					else
						toAdd = comp + ":" + port;
				}
				else
					toAdd = comp;
				if (!sNames.contains(toAdd))
					sNames.add(toAdd);
			}
		}
	

		getSegmentComp = sNames;
		Collections.sort(getSegmentComp);
		if(getSegmentComp.size() > 1)
			serverNames.add("Component name (Optional)");
		serverNames.addAll(getSegmentComp);
	}

	if(s_event!=null && s_event.trim().length()>0 && s_event.equals("Service") && sub_event!=null && sub_event.trim().length()>0)
	{
		sNames = new LinkedList();
		nameTypes = new LinkedList();
		serverNames = new LinkedList();
		for(k = 0; k <getServers.size(); k++)
		{
			String server = (String)getServers.get(k);
			StringTokenizer st_server = new StringTokenizer(server,":");
			String type = "";
			String comp = "";
			String port = "";
			String sid = "";
			String toAdd = "";
			int cntTokens = st_server.countTokens();
			if(st_server.hasMoreTokens())
			{
				type = st_server.nextToken();
				comp = st_server.nextToken();
				port = st_server.nextToken();
				if(cntTokens == 4)
					sid = st_server.nextToken();
			}
			if(selType !=null)
			{
				if(selName == null && allTypes)
				{
					if((type!=null && type.equals(selType)) || allTypes)
					{
						if(!port.equals("NULL"))
						{
							if(!sid.equals(""))
								toAdd = comp + ":" + port + ":" + sid;
							else
								toAdd = comp + ":" + port;
						}
						else
						{
							toAdd = comp;
						}

						if (!sNames.contains(toAdd))
							sNames.add(toAdd);
					}
					if(allTypes || selType.equals("Host_system"))
					{
						toAdd = comp;
						if (!sNames.contains(toAdd))
							sNames.add(toAdd);
					}
				}
				else if(selName!=null && allTypes)
				{

					if(!selName.equals("Component name (Optional)"))
					{
						name = selName;
						if(name.indexOf(":") < 0)
						{
							String comb = comp;
							//if(name.equals(comb))
							{
								if(port.equals("NULL"))
								{
									toAdd = comb;
									if (!sNames.contains(toAdd))
										sNames.add(toAdd);
								if(!nameTypes.contains(type))
									nameTypes.add(type);
								}
							}
						}
						else
						{
							String comb = comp + ":" + port;
							if(!sid.equals(""))
								comb = comb + ":" + sid;
							//if(name.equals(comb))
							{
								toAdd = comb;
								if (!sNames.contains(toAdd))
									sNames.add(toAdd);
								if(!nameTypes.contains(type))
									nameTypes.add(type);
							}
						}
					}
					else
					{
						if(!port.equals("NULL"))
						{
							if(!sid.equals(""))
								toAdd = comp + ":" + port + ":" + sid;
							else
								toAdd = comp + ":" + port;
						}
						else
						{
							toAdd = comp;
						}
						if (!sNames.contains(toAdd))
							sNames.add(toAdd);
						
						if(!nameTypes.contains(type))
							nameTypes.add(type);
					}
				}
				else if(selName!=null && !allTypes)
				{

					if(!selName.equals("Component name (Optional)"))
					{
						name = "";
						name = selName;
						if(name.indexOf(":") < 0)
						{
							String comb = comp;
							
							//if(name.equals(comp))
							{
								//if(port.equals("NULL"))
								{
									if(selType.equals(type) || selType.equals("-1"))
									{
										if(!port.equalsIgnoreCase("NULL"))
										{
											comb = comb + ":" + port;
											if(!sid.equals(""))
												comb = comb + ":" + sid;
										}
										if (!sNames.contains(comb))
											sNames.add(comb);
										if(!nameTypes.contains(type))
											nameTypes.add(type);
									}
									if(selType.equals("Host_system"))
									{
										if (!sNames.contains(comb))
											sNames.add(comb);
									}
								}
							}
						}
						else
						{
							String comb = comp ;
							if(!port.equalsIgnoreCase("NULL"))
							{
								 comb = comp + ":" + port;
								if(!sid.equals(""))
									comb = comb + ":" + sid;
							}
							//if(name.equals(comb))
							{
								if(selType.equals(type) || selType.equals("-1"))
								{
									if (!sNames.contains(comb))
										sNames.add(comb);
								if(!nameTypes.contains(type))
									nameTypes.add(type);
								}
								if(selType.equals("Host_system"))
								{
									if (!sNames.contains(toAdd))
										sNames.add(comb);
								}
							}
						}

					}
					else
					{
						if(selType.equals(type) || selType.equals("-1"))
						{
							if(!port.equals("NULL"))
							{
								if(!sid.equals(""))
									toAdd = comp + ":" + port + ":" + sid;
								else
									toAdd = comp + ":" + port;
							}
							else
							{
								toAdd = comp;
							}
							if (!sNames.contains(toAdd))
								sNames.add(toAdd);
							if(!nameTypes.contains(type))
								nameTypes.add(type);
						}
						if(selType.equals("Host_system"))
						{
							if (!sNames.contains(comp))
								sNames.add(comp);
						}
					}
				}
				else if(selName == null && !allTypes)
				{
						if(selType.equals(type) || selType.equals("Host_system") || selType.equals("-1"))
						{
							if(!port.equals("NULL"))
							{
								if(!sid.equals(""))
									toAdd = comp + ":" + port + ":" + sid;
								else
									toAdd = comp + ":" + port;
							}
							else
							{
								toAdd = comp;
							}
							if (!sNames.contains(toAdd))
								sNames.add(toAdd);
							if(!nameTypes.contains(type))
								nameTypes.add(type);
						}
				}
			}
			else
			{
				if(port!=null && !port.equals("NULL"))
				{
					if(!sid.equals(""))
						toAdd = comp + ":" + port + ":" + sid;
					else
						toAdd = comp + ":" + port;
				}
				else
					toAdd = comp;
				if (!sNames.contains(toAdd))
					sNames.add(toAdd);
			}
		}
	

		getServers = sNames;
		Collections.sort(getServers);
		if(getServers.size() > 1)
			serverNames.add("Component name (Optional)");
		serverNames.addAll(getServers);
	}

	if(s_event!=null && s_event.trim().length()>0 && s_event.equals("Zone") && sub_event!=null && sub_event.trim().length()>0)
	{
		sNames = new LinkedList();
		nameTypes = new LinkedList();
		serverNames = new LinkedList();
		if(!innersubZoneComps.isEmpty())
		{
			for(k = 0; k <innersubZoneComps.size(); k++)
			{
				String server = (String)innersubZoneComps.get(k);
				StringTokenizer st_server = new StringTokenizer(server,":");
				String type = "";
				String comp = "";
				String port = "";
				String sid = "";
				String toAdd = "";
				int cntTokens = st_server.countTokens();
				if(st_server.hasMoreTokens())
				{
					type = st_server.nextToken();
					comp = st_server.nextToken();
					port = st_server.nextToken();
					if(cntTokens == 4)
						sid = st_server.nextToken();
				}
				if(selType !=null)
				{
					if(selName == null && allTypes)
					{
						if((type!=null && type.equals(selType)) || allTypes)
						{
							if(!port.equals("NULL"))
							{
								if(!sid.equals(""))
									toAdd = comp + ":" + port + ":" + sid;
								else
									toAdd = comp + ":" + port;
							}
							else
							{
								toAdd = comp;
							}

							if (!sNames.contains(toAdd))
								sNames.add(toAdd);
						}
						if(allTypes || selType.equals("Host_system"))
						{
							toAdd = comp;
							if (!sNames.contains(toAdd))
								sNames.add(toAdd);
						}
					}
					else if(selName!=null && allTypes)
					{

						if(!selName.equals("Component name (Optional)"))
						{
							name = selName;
							if(name.indexOf(":") < 0)
							{
								String comb = comp;
								//if(name.equals(comb))
								{
									if(port.equals("NULL"))
									{
										toAdd = comb;
										if (!sNames.contains(toAdd))
											sNames.add(toAdd);
									if(!nameTypes.contains(type))
										nameTypes.add(type);
									}
								}
							}
							else
							{
								String comb = comp + ":" + port;
								if(!sid.equals(""))
									comb = comb + ":" + sid;
								//if(name.equals(comb))
								{
									toAdd = comb;
									if (!sNames.contains(toAdd))
										sNames.add(toAdd);
									if(!nameTypes.contains(type))
										nameTypes.add(type);
								}
							}
						}
						else
						{
							if(!port.equals("NULL"))
							{
								if(!sid.equals(""))
									toAdd = comp + ":" + port + ":" + sid;
								else
									toAdd = comp + ":" + port;
							}
							else
							{
								toAdd = comp;
							}
							if (!sNames.contains(toAdd))
								sNames.add(toAdd);
							
							if(!nameTypes.contains(type))
								nameTypes.add(type);
						}
					}
					else if(selName!=null && !allTypes)
					{

						if(!selName.equals("Component name (Optional)"))
						{
							name = "";
							name = selName;
							if(name.indexOf(":") < 0)
							{
								String comb = comp;
								
								//if(name.equals(comp))
								{
									//if(port.equals("NULL"))
									{
										if(selType.equals(type) || selType.equals("-1"))
										{
											if(!port.equalsIgnoreCase("NULL"))
											{
												comb = comb + ":" + port;
												if(!sid.equals(""))
													comb = comb + ":" + sid;
											}
											if (!sNames.contains(comb))
												sNames.add(comb);
											if(!nameTypes.contains(type))
												nameTypes.add(type);
										}
										if(selType.equals("Host_system"))
										{
											if (!sNames.contains(comb))
												sNames.add(comb);
										}
									}
								}
							}
							else
							{
								String comb = comp ;
								if(!port.equalsIgnoreCase("NULL"))
								{
									 comb = comp + ":" + port;
									if(!sid.equals(""))
										comb = comb + ":" + sid;
								}
								//if(name.equals(comb))
								{
									if(selType.equals(type) || selType.equals("-1"))
									{
										if (!sNames.contains(comb))
											sNames.add(comb);
									if(!nameTypes.contains(type))
										nameTypes.add(type);
									}
									if(selType.equals("Host_system"))
									{
										if (!sNames.contains(toAdd))
											sNames.add(comb);
									}
								}
							}

						}
						else
						{
							if(selType.equals(type) || selType.equals("-1"))
							{
								if(!port.equals("NULL"))
								{
									if(!sid.equals(""))
										toAdd = comp + ":" + port + ":" + sid;
									else
										toAdd = comp + ":" + port;
								}
								else
								{
									toAdd = comp;
								}
								if (!sNames.contains(toAdd))
									sNames.add(toAdd);
								if(!nameTypes.contains(type))
									nameTypes.add(type);
							}
							if(selType.equals("Host_system"))
							{
								if (!sNames.contains(comp))
									sNames.add(comp);
							}
						}
					}
					else if(selName == null && !allTypes)
					{
						if(selType.equals(type) || selType.equals("Host_system") || selType.equals("-1"))
						{
							if(!port.equals("NULL"))
							{
								if(!sid.equals(""))
									toAdd = comp + ":" + port + ":" + sid;
								else
									toAdd = comp + ":" + port;
							}
							else
							{
								toAdd = comp;
							}
							if (!sNames.contains(toAdd))
								sNames.add(toAdd);
							if(!nameTypes.contains(type))
								nameTypes.add(type);
						}
					}
				}
				else
				{
					if(port!=null && !port.equals("NULL"))
					{
						if(!sid.equals(""))
							toAdd = comp + ":" + port + ":" + sid;
						else
							toAdd = comp + ":" + port;
					}
					else
						toAdd = comp;
					if (!sNames.contains(toAdd))
						sNames.add(toAdd);
				}
			}

			innersubZoneComps = sNames;
			Collections.sort(innersubZoneComps);
			if(innersubZoneComps.size() >= 1)
				serverNames.add("Component name (Optional)");
			serverNames.addAll(innersubZoneComps);
		}
	}

	List serverTypes = new LinkedList();
	//if(selType == null)
		stypes.addAll(user.getServerTypes());		
	//else
		//stypes.addAll(nameTypes);
	Collections.sort(stypes);
	if(stypes.size() > 1)
		serverTypes.add("Component type (Optional)");
	serverTypes.addAll(stypes);

	String	selectedCompName = request.getParameter("compNameList"),

			selectedCompType = request.getParameter("compTypeList"),
			hide = request.getParameter("fNameType"),
			durationStr = request.getParameter("duration"),
			durationType = request.getParameter("timeselect");
	
	
	String gl = request.getParameter("glduration");
	char condition;
	if(gl !=null)
	{
		condition = gl.charAt(0);
	}
	else
	{
			condition = '>';
	}
	long minDuration = 0l;
	if (durationStr != null)
	{
		minDuration = Long.parseLong(durationStr);
		if (durationStr.startsWith("-"))
		{
			condition = '<';
		}
	}
		String arr_optionsArrangeDisp[]={mappingInfo.getTextDescription("monitor.current.Start Time"),mappingInfo.getTextDescription("monitor.current.Component Type"),mappingInfo.getTextDescription("monitor.current.Component Name"),mappingInfo.getTextDescription("monitor.current.Service"),mappingInfo.getTextDescription("monitor.current.Test"),mappingInfo.getTextDescription("monitor.current.Description")};

	String arr_optionsArrangeValue [] ={"-1","comp_type","comp_name","Service","Test","problem_desc"};
		String selectedArrangeOption      = request.getParameter("arrangeAlarms");
		
	if(selectedArrangeOption == null)
		selectedArrangeOption = arr_optionsArrangeValue[0];
		String pageTitle="header.jsp?title=Event History";
		String compType="",compName="";
		if(isFromDashBoard || (tab!=null && tab.equalsIgnoreCase("custom")))
		{
			compType=request.getParameter("dashboardcomptype");
			compName=request.getParameter("dashboardcompname");
			String from_page=request.getParameter("from_page");
			if(from_page!=null && from_page.trim().length()>0 && from_page.equalsIgnoreCase("insideviewDashboard"))
			{
				String s_info=request.getParameter("insideview_info");
				s_info=(s_info==null)?"":s_info;
				String layer=request.getParameter("Layer");
				layer=(layer==null)?"":layer;

				pageTitle="header.jsp?title=Event History"+"&currentSystemStatus=true&fromDashBrd=true&dashbrdCompType="+compType+"&dashbrdhostName="+EgURLEncoder.encode(compName,"UTF-8")+"&info="+EgURLEncoder.encode(s_info,"UTF-8")+"&from_page="+request.getParameter("from_page")+"&Layer="+EgURLEncoder.encode(layer,"UTF-8")+"&hostName="+request.getParameter("dashboardcompname")+"&compType="+request.getParameter("compTypeList");
			}
			else
			{
				pageTitle=pageTitle+"&currentSystemStatus=true&fromDashBrd=true&dashbrdCompType="+compType+"&dashbrdhostName="+compName;
			}
		}
%>
<body leftmargin="0" topmargin="0" marginheight="0" marginwidth="0" style="overflow:auto" id="inner_bg">
<div id="refframe">
<input type="hidden" name="hidVpdfData" id="hidVpdfData" value="">
<table align="left" cellspacing="0" cellpadding="0" width="100%"  border="0">
	<jsp:include page="<%=pageTitle%>"/>
	<tr>
		<td>
			<form method="GET" name="Event" style="margin:0px">
				<table align="left" cellspacing="0" cellpadding="0" width="100%" border="0">
					<tr>
						<td width="100%" id="eg_blankspace" class="space6" height="100%" style="padding-bottom:0px">
						<input type="hidden" name="newAlarms" value="true">
						<input type="hidden" name="v_event" value="<%=s_event%>">
						<input type="hidden" name="subevent" value="<%=sub_event%>"> 
						<input type="hidden" name="includesubzone" value="<%=includesubzone%>">
						
							<table width="100%" align="center" cellspacing="0" cellpadding="0" border="0" height="100%">
								<tr>
									<td  align="center" width="100%" id="inner_bg">
										<table cellspacing="0" cellpadding="0" width="100%" border="0" align="center" bordercolor="green">
											<tr>
												<td>
													<table cellspacing="0" cellpadding="0" width="100%" border="0" align="center"  id="cell_border3">
														<tr>
															<td align="center" width="100%">
																<table align="center" width="100%" cellspacing="0" cellpadding="3" border="0" style="table-layout-fixed" bordercolor="red"><col width="80"><col width="215"><col width="65"><col width="220"> <col width="79"><col width="120"><col width="180">
																	<tr>
																		<td  align="left"  id="eg_darktextbold" style="padding-right:0px" nowrap> <egui:intnl text="monitor.history.Analysis By"/></td>

																		<td>
																			<select name="eventfor" width="200" style="width:200px;" onChange="eventselection()">

<%
													for(int g=0;g<event_for.size();g++)
													{
														String select_event = (String)event_for.get(g);
														if(select_event!=null && select_event.trim().length()>0 && select_event.equals(s_event))
														{
%>
															<option value="<%=select_event%>"selected><egui:intnl text='<%="monitor.history."+select_event%>'/></option>
<%
														}
														else
														{
%>
															<option value="<%=select_event%>"><egui:intnl text='<%="monitor.history."+select_event%>'/></option>
<%
														}
													}
%>
																			</select>
																		</td>
<%
									if(s_event!=null && s_event.length()>0 && (s_event.equals("Zone") || s_event.equals("Segment") || s_event.equals("Service")))
									{
%>
																		<td  align="left"  id="eg_darktextbold" nowrap> <egui:intnl text='<%="monitor.history."+s_event%>'/></td>

																		<td style="padding-left:0px"><select name="event_select" width="200" style="width:200px;" onChange="subeventselect()" >
<%
										if(s_event != null && s_event.length()>0 && s_event.equalsIgnoreCase("Service"))
										{
											if(v_site!=null && !v_site.isEmpty())
											{
%>
												<option value = "-1"><egui:intnl text='<%="monitor.history.Please choose a "+s_event%>'/></option>
<%
												for(int m=0;m<v_site.size();m++)
												{
													String v_service=(String)v_site.get(m);
													
													if(v_service!=null && v_service.trim().length()>0 && v_service.equals(sub_event))
													{
%>
														<option value="<%=v_service%>"selected><egui:intnl text='<%="monitor.history."+v_service%>'/></option>
<%
													}
													else
													{
%>
														<option value="<%=v_service%>"><egui:intnl text='<%="monitor.history."+v_service%>'/></option>
<%
													}
												}
											}
										}
										else if(s_event != null && s_event.length()>0 && s_event.equalsIgnoreCase("Segment"))
										{
											if(v_segment!=null && !v_segment.isEmpty())
											{
%>
												<option value = "-1"><egui:intnl text='<%="monitor.history.Please choose a " +s_event%>'/></option>
<%
												for(int m=0; m<v_segment.size();m++ )
												{
													String v_seg=(String)v_segment.get(m);
													
													if(v_seg!=null && v_seg.trim().length()>0 && v_seg.equals(sub_event))
													{
%>
														<option value="<%=v_seg%>"selected><egui:intnl text='<%="monitor.history."+v_seg%>'/></option>
<%
													}
													else
													{
%>
														<option value="<%=v_seg%>"><egui:intnl text='<%="monitor.history."+v_seg%>'/></option>
<%
													}
												}
											}
										}
										else if(s_event!=null && s_event.length()>0 && s_event.equalsIgnoreCase("Zone"))
										{
											if(v_zone!=null && !v_zone.isEmpty())
											{
%>
												<option value = "-1"><egui:intnl text='<%="monitor.history.Please choose a " +s_event%>'/></option>
<%
												for(int z=0;z<v_zone.size(); z++)
												{
													String getZone=(String)v_zone.get(z);
													if(getZone!=null && getZone.trim().length()>0 && getZone.equals(sub_event))
													{
%>
														<option value="<%=getZone%>"selected><egui:intnl text='<%="monitor.history."+getZone%>'/></option>
<%
													}
													else
													{
%>
														<option value="<%=getZone%>"><egui:intnl text='<%="monitor.history."+getZone%>'/></option>
<%
													}
												}
											}
%>
																			</select>
																		</td>
																		<td  align="left"  nowrap colspan="3" style="padding:0px"> 
																			<table border="0" cellspacing="0" cellpadding="4">
																				<tr>
																					<td align="left" id="eg_darktextbold" style="padding-left:0px" nowrap ><egui:intnl text="monitor.history.Include Subzones"/></td>

																					<td>
																						<select name="includeSubZone" onChange="javascript:subZone()">
<%
											if(includesubzone!=null && includesubzone.trim().length()>0 && includesubzone.equalsIgnoreCase("yes"))
											{
%>
																						<option value="Yes" selected><egui:intnl text="monitor.common.Yes"/></option><option value="No"><egui:intnl text="monitor.common.No"/></option>
<%
											}
											else
											{
%>
																						<option value="Yes" ><egui:intnl text="monitor.common.Yes"/></option><option value="No" selected><egui:intnl text="monitor.common.No"/></option>
<%
											}
%>
																						</select>
																					</td>
																				</tr>
																			</table>
																		</td>
<%
										}
									}
									else
									{
%>
																		<td colspan="5">&nbsp;</td>
<%
									}
%>
																	</tr>
																	<tr>
<%
									MappingNameSorter sorter = new MappingNameSorter(thisLanguage);
									ArrayList serverList = new ArrayList();
%>
																		<td  align="left"  id="eg_darktextbold" nowrap> <egui:intnl text="monitor.history.Type"/></td>
																		<td ><select name="compTypeList" width="200" style="width:200px;" onChange="javascript:findComponents('Type')"><option value="-1"><egui:intnl text="monitor.history.Component type (Optional)"/></option> 
<%
									if(s_event == null || s_event.trim().length()==0 || s_event.equals("Component"))
									{
										Object[] types = serverTypes.toArray();
										if (StringUtils.isNull(selectedCompType) && types.length>0)
										{
											selectedCompType = (String)types[0];
										}
										for (int i=0;i<serverTypes.size();i++)
										{
											String pp = (String)serverTypes.get(i);
											if(pp.trim().equalsIgnoreCase("Component type (Optional)"))
												continue;
											serverList.add(pp);
										}
										serverList = sorter.getSortedCompTypeList(serverList);
										String tempVal = "";
										String tempDis = "";
										EgName nameObject = null;
										for(int x=0; x < serverList.size(); x++)
										{
											nameObject = (EgName)serverList.get(x);
											tempVal = nameObject.getActualName();
											tempDis = nameObject.getLocalName();
											if (selectedCompType!=null && tempVal.equals(selectedCompType))
											{
%>
												<option value="<%=tempVal%>" selected><egui:intnl type="<%=tempDis%>"/></option> 
<%
					
											}
											else
											{
%>
												<option value="<%=tempVal%>"><egui:intnl type="<%=tempDis%>"/></option> 
<%
											}
										}
									}
									else if(s_event!=null && s_event.trim().length()>0 && s_event.equals("Service"))
									{
										Vector getCompTypes=new Vector();
										if(sub_event!=null && sub_event.trim().length()>0)
										{
											getCompTypes.add("Host_system");
											for(int i=0;i<v_availComps.size();i++)
											{
												String compTypes = (String)v_availComps.get(i);
												String comp_type=null;
												if(compTypes!=null && compTypes.trim().length()>0)
												{
													comp_type = compTypes.substring(compTypes.lastIndexOf(":")+1);
													if(!getCompTypes.contains(comp_type))
													{
														getCompTypes.add(comp_type);
													}
												}
											}
											Collections.sort(getCompTypes);
											for(int gg=0;gg<getCompTypes.size();gg++)
											{
												String comp_typeSer=(String)getCompTypes.get(gg);
												if(comp_typeSer!=null && comp_typeSer.trim().length()>0)
												{
													if(selectedCompType!=null && selectedCompType.equals(comp_typeSer))
													{
%>
														<option value="<%=comp_typeSer%>" selected><%=mappingInfo.getComponentTypeDescription(comp_typeSer)%></option>
<%
													}
													else
													{
%>
														<option value="<%=comp_typeSer%>" ><%=mappingInfo.getComponentTypeDescription(comp_typeSer)%></option>
<%
													}
												}
											}
										}
									}
									else if(s_event!=null && s_event.trim().length()>0 && s_event.equals("Segment"))
									{
										Vector getCompTypes=new Vector();
										if(sub_event!=null && sub_event.trim().length()>0)
										{
											getCompTypes.add("Host_system");
											for(int i=0;i<v_segComp.size();i++)
											{
												String compTypes = (String)v_segComp.get(i);
												String comp_type=null;
												if(compTypes!=null && compTypes.trim().length()>0)
												{
													comp_type = compTypes.substring(compTypes.lastIndexOf(":")+1);
													if(!getCompTypes.contains(comp_type))
													{
														getCompTypes.add(comp_type);
													}
												}
											}
											Collections.sort(getCompTypes);
											for(int gg=0;gg<getCompTypes.size();gg++)
											{
												String comp_typeSeg=(String)getCompTypes.get(gg);
												if(comp_typeSeg!=null && comp_typeSeg.trim().length()>0)
												{
													if(selectedCompType!=null && selectedCompType.equals(comp_typeSeg))
													{
%>
															<option value="<%=comp_typeSeg%>" selected><%=mappingInfo.getComponentTypeDescription(comp_typeSeg)%></option>
																
<%
													}
													else
													{
%>
															<option value="<%=comp_typeSeg%>" ><%=mappingInfo.getComponentTypeDescription(comp_typeSeg)%></option>
<%
													}
												}
											}
										}
									}
									else if(s_event!=null && s_event.trim().length()>0 && s_event.equals("Zone"))
									{
										Vector getCompTypes=new Vector();
										if(sub_event!=null && sub_event.trim().length()>0)
										{
											if(!innersubZone.isEmpty())
												getCompTypes.add("Host_system");
											for(int i=0;i<innersubZone.size();i++)
											{
												String compTypes = (String)innersubZone.get(i);
												String comp_type=null;
												if(compTypes!=null && compTypes.trim().length()>0)
												{
													comp_type = compTypes.substring(0,compTypes.indexOf(":"));
													if(!getCompTypes.contains(comp_type))
													{
														getCompTypes.add(comp_type);
													}
												}
											}
											Collections.sort(getCompTypes);
											for(int gg=0;gg<getCompTypes.size();gg++)
											{
												String comp_typeZone=(String)getCompTypes.get(gg);
												if(comp_typeZone!=null && comp_typeZone.trim().length()>0)
												{
													if(selectedCompType!=null && selectedCompType.equals(comp_typeZone))
													{
%>
														<option value="<%=comp_typeZone%>" selected><%=mappingInfo.getComponentTypeDescription(comp_typeZone)%></option>
<%
													}
													else
													{
%>
														<option value="<%=comp_typeZone%>" ><%=mappingInfo.getComponentTypeDescription(comp_typeZone)%></option>
<%
													}
												}
											}
										}
									}
%>
																		</select>
																		</td>

																		<td  align="left" id="eg_darktextbold" nowrap ><egui:intnl text="monitor.common.Component"/>&nbsp;</td>
																		<td style="padding-left:0px">
																			<select name="compNameList" style="width:200px;"  onChange='javascript:findComponents("Component")'>
<%
			if(s_event == null ||s_event.trim().length()==0 || s_event.equals("Component"))
			{
				Object[] names = serverNames.toArray();
				
				if (StringUtils.isNull(selectedCompName) && names.length>0)
				{
					selectedCompName = (String)names[0];
				}
				
				if(names.length>0)
				{
					out.println(HtmlUtils.setSelectOptions(names, selectedCompName));	
				}
				else if(names.length<=0)
				{
%>
																		<option value="-1"><egui:intnl text="monitor.history.Component name (Optional)"/></option>
<%
				}
			}
			else if(s_event!=null && s_event.trim().length()>0 && s_event.equals("Service"))
			{
				if(sub_event!=null && sub_event.trim().length()>0)
				{
					Object[] names = serverNames.toArray();
					if (StringUtils.isNull(selectedCompName) && names.length>0)
					{
						selectedCompName = (String)names[0];
					}
					if(names.length>0)
					{
						out.println(HtmlUtils.setSelectOptions(names, selectedCompName));
					}
					else if(names.length<=0)
					{
%>
																		<option value="-1"><egui:intnl text="monitor.history.Component name (Optional)"/></option>
<%
					}
				}
				else 
				{
					
%>
																		<option value="-1"><egui:intnl text="monitor.history.Component name (Optional)"/></option>
<%
				}
			}
			else if(s_event!=null && s_event.trim().length()>0 && s_event.equals("Segment"))
			{
				if(sub_event!=null && sub_event.trim().length()>0)
				{
					Object[] names = serverNames.toArray();
					if (StringUtils.isNull(selectedCompName) && names.length>0)
					{
						selectedCompName = (String)names[0];
					}
					if(names.length>0)
					{
						out.println(HtmlUtils.setSelectOptions(names, selectedCompName));
					}
					else if(names.length<=0)
					{
%>
																		<option value="-1"><egui:intnl text="monitor.history.Component name (Optional)"/></option>
<%
					}
				}
				else 
				{
					
%>
																		<option value="-1"><egui:intnl text="monitor.history.Component name (Optional)"/></option>
<%
				}
			}
			else if(s_event!=null && s_event.trim().length()>0 && s_event.equals("Zone"))
			{
				if(sub_event!=null && sub_event.trim().length()>0)
				{
					Object[] names = serverNames.toArray();
					if (StringUtils.isNull(selectedCompName) && names.length>0)
					{
						selectedCompName = (String)names[0];
					}
					if(names.length>0)
					{
						out.println(HtmlUtils.setSelectOptions(names, selectedCompName));
					}
					else if(names.length<=0)
					{
%>
																		<option value="-1"><egui:intnl text="monitor.history.Component name (Optional)"/></option>
<%
					}
				}
				else 
				{
					
%>
																		<option value="-1"><egui:intnl text="monitor.history.Component name (Optional)"/></option>
<%
				}
			}
%>
																			</select>
																		</td>

																		<td align="left" id="eg_darktextbold" nowrap colspan="3" style="padding:0px">
																			<table border="0" cellspacing="0" cellpadding="0">
																				<tr>
																					<td style="padding-left:0px;padding-right:4px" align="left" id="eg_darktextbold" nowrap> <egui:intnl text="monitor.history.Duration is "/></td>
																					<td>
																						<select name="glduration" width="150" style="width:150px;">
<%
													if (condition == '<')
													{
%>
														<option value="<" selected><egui:intnl text="monitor.history.lesser than"/></option>
														<option value=">" ><egui:intnl text="monitor.history.greater than"/></option>
<%
													}
													else
													{
%>
														<option value="<"><egui:intnl text="monitor.history.lesser than"/></option>
														<option value=">" selected><egui:intnl text="monitor.history.greater than"/></option>
<%
													}
%>
																						</select>
																					</td>
																					<td align="right" nowrap>&nbsp;<input type="text" name="duration" size="4" value="<%=Math.abs(minDuration)%>" style="width: 34px;">&nbsp;</td>
																					<td align="right" nowrap style="padding-right:3px"> <select name="timeselect" style="width: 75px;">
<%
																		for(int i=0;i<timeOptions.length;i++)
																		{
																			if(durationType!=null && durationType.equals(timeOptions[i]))
																			{
%>
																					<option value="<%=timeOptions[i]%>" selected > <egui:intnl text='<%="monitor.history."+timeOptions[i]%>'/> </option>
<%
																			}
																			else
																			{
%>
																					<option value="<%=timeOptions[i]%>"  ><egui:intnl text='<%="monitor.history."+timeOptions[i]%>'/> </option>
<%
																			}
																		}
%>
																					</select>
																					</td>
																				</tr>
																			</table>
																		</td>
																	</tr>
										<!-- BREAK -->
																	<tr>
																		<td id="eg_darktextbold" nowrap><egui:intnl text="monitor.history.Priority"/> </td>
																		<td>
<%
															String s_state = request.getParameter("state");
															if (s_state==null) s_state="";
%>
															<select name="state" size="1" style="width:120px;">
<%
															for(int i=0;i<showState.length;i++)
															{
%>
																			<option value="<%=stateValues[i]%>" <%=s_state.equalsIgnoreCase(stateValues[i])?" Selected " : ""%>>
<%
																if(i==0)
																{
%>
																<egui:intnl
																text='<%="monitor.history."+showState[i]%>'/>
<%
																}
																else if(i==1)
																{
																	if(showState[i].indexOf("&")>-1)
																	{
																		if((showState[i].substring(0,showState[i].indexOf("&")).trim()).equals("Critical"))
																		{
																			out.print(mappingInfo.getLabelDescription("HIGH"));//out.print(langinfo.getValue(LABELS,"HIGH"));
																		out.print(" & ");
																		if((showState[i].substring(showState[i].indexOf("&")+1).trim()).equals("Major"))
																			{
																			//out.print(langinfo.getValue(LABELS,"INTERMEDIATE"));
																			out.print(mappingInfo.getLabelDescription("INTERMEDIATE"));
																			}
																		}
																	}
																}
																else
																{
																out.print(mappingInfo.getLabelDescription(stateValues[i]));
																//out.print(langinfo.getValue(LABELS,stateValues[i]));
																}
%>
																			</option>
																<!--egui:intnl
																text='<%//="monitor.history."+showState[i]%>'/-->
<%
															}
%>
																		</select>
																		</td>
																		<td colspan="5" align="left" style="padding-left:2px" >
																			<table cellspacing="0" cellpadding="0" border="0"  width="100%">
																				<tr>
																					<td nowrap height="20"><%//@ include file="EgTimeLine.jsp" %></td>
																				</tr>
																			</table>
																		</td>
																	</tr>
																	<tr>
															<!-- Code add by ahamed (events per page) -->
																		<td colspan="4">
																			<table cellpadding="2" cellspacing="0" border="0">
																				<tr>
																					<td nowrap> <b><egui:intnl text="monitor.history.Events per page" /></b> </td>
																					<td>
																						<select name="eventsPerPage" style="width:52px;">
<%
													String rowCount = request.getParameter("eventsPerPage");
													if(rowCount == null || rowCount.equals("null"))
														rowCount = rowsPerPage[0];

													for(int i=0;i<rowsPerPage.length;i++)
													{
%>
														<option value="<%=rowsPerPage[i]%>" <%=rowsPerPage[i].equals(rowCount)?"selected":""%>><%=rowsPerPage[i]%></option>
<%
													}
%>
																						</select>
																					</td>
																				
																					<td nowrap = "nowrap" align = "right"  id="eg_8bold" width="80"> <egui:intnl text = "monitor.currentAlarms.Sort by"/></td>
															<!-- end by ahamed -->
<%
												String widthForTd="";
												if(isFirefox2)
													widthForTd="17";
												if(isFirefox3)
													widthForTd="17";
												else if(isMSIE6)
													widthForTd="34";
												else if(isMSIE7)
													widthForTd="34";
%>
																					<td align = "left" style="width:130px" ><select style="width:128px" name = "arrangeAlarms">
<%
												out.println(HtmlUtils.setSelectOptions(arr_optionsArrangeDisp,arr_optionsArrangeValue,selectedArrangeOption));

%>
																						</select>
																					</td>
<%
													if(showLayersSelectBox)
													{
%>
																					<td align = "right" id="eg_8bold" style="width:80px">Layer&nbsp;</td>
																					<td style="width:140px"><select style="width:140px" name = "layers">
<%
																		for(int i=0;i<layers.size();i++)
																		{
																			String layer=(String)layers.get(i);
																			String selected=layer.equalsIgnoreCase(selectedLayer)?"selected":"";
																			if(layer!=null && !layer.equalsIgnoreCase("All"))
																			{
%>
																					<option value="<%=layer%>" <%=selected%>><%=mappingInfo.getLayerDescription(layer)%></option>
<%
																			}
																			else
																			{
%>
																					<option value="<%=layer%>" <%=selected%>><%=mappingInfo.getTextDescription("monitor.dashboard."+layer)%></option>

<%																			}
																		}
%>
																						</select>
																					</td>
<%
													}
%>
																				</tr>
																			</table>
																		</td>
																		<td colspan="3" style="padding:0px">
																			<table cellpadding="4" cellspacing="0" border="0">
																				<tr>
																					<td  nowrap id="eg_8bold">
																						<egui:intnl text="monitor.history.Description search" />
																					</td>
																					<td>
																					<input style="width:200px" type="text" name="search" value="<%=infosearch%>"></td>
																				</tr>
																			</table>
																		</td>
																	</tr>
																	<tr>
																		<td colspan="2">&nbsp; </td>

																		<td align="center"  colspan="2" style="padding-bottom:4px"> <input name="Go" onMouseDown="javascript:onShowAlarms();" onKeyPress="javascript:onShowAlarms();" id="button_bgdark" style="width: 110px;" type="button" value='<egui:intnl text="monitor.history.Show Alarms"/>'></td>
																		<td  style="padding:0px" colspan="3"valign="bottom" align="right">
																			<table  cellspacing="0" cellpadding="0" border="0"> 
																				<tr>
																					<td width="20px">&nbsp;</td>
																					<td align="center" id="inner_menu_left" ><img src="/final/monitor/eg_images/spacer.gif" height="22" width="27"> </td>
																					<td width="13" align="center"  id="inner_menu_bg"><img src="/final/monitor/eg_images/spacer.gif" height="22" width="13"></td>

																					<td width="13" align="center"  id="inner_menu_bg" valign="bottom"> <a style="text-decoration:none" href="#" onClick="javascript:saveInCSVFormat();"> <img src="/final/monitor/eg_images/csv.gif"  alt="<egui:intnl text='monitor.common.CSV'/>" border="0" title="<egui:intnl text='monitor.common.CSV'/>"></a> </td>

																					<td width="13" align="center"  id="inner_menu_bg"><img src="/final/monitor/eg_images/spacer.gif" height="20" width="13"></td>

																					<td width="13" align="center"  id="inner_menu_bg" valign="bottom"> <a style="text-decoration:none" href="javascript:void(0)" onClick="javascript:saveMe();" alt="<egui:intnl text='monitor.common.SAVE'/>" title="<egui:intnl text='monitor.common.SAVE'/>"> <img src="/final/monitor/eg_images/pdf-icon.gif"  alt="<egui:intnl text='monitor.common.SAVE'/>" border="0"></a> </td>

																					<td width="13" align="center"  id="inner_menu_bg"><img src="/final/monitor/eg_images/spacer.gif" height="20" width="13"></td>
																				</tr>
																			</table>
																		</td>
																	</tr>
															</table>
															</td>
														</tr>
													</table>
												</td>
											</tr>
									</table>
								</td>
							</tr>
						</table>
					</td>
				</tr>
			</table>
			<input type="hidden" id="fromDashBoard" name="fromDashBoard" value="<%=isFromDashBoard%>">
			<input type="hidden" id="selectedLayer"name="selectedLayer" value="<%=layerName%>">
			<input type="hidden" id="tab"name="tab" value="<%=tab%>">
			<input type="hidden" id="dashboardcomptype" name="dashboardcomptype" value="<%=compType%>">
			<input type="hidden" id="dashboardcompname"name="dashboardcompname" value="<%=compName%>">
			<input type="hidden" id="from_page"name="from_page" value="<%=request.getParameter("from_page")%>">
			<input type="hidden" id="insideview_info"name="insideview_info" value="<%=request.getParameter("insideview_info")%>">
			<input type="hidden" id="Layer"name="Layer" value="<%=request.getParameter("Layer")%>">
			<input type="hidden" id="NoComponentsSelected"name="NoComponentsSelected" value="<%=request.getParameter("NoComponentsSelected")%>">

			</form>
		</td>
	</tr>
</table>
</div>
</body>
</html>

