<%@ include file = "EgLoginTracker.jsp" %>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ page import = "com.egurkha.monitor.Dashboard" %>
<%@ page import = "com.egurkha.monitor.alarms.AlarmPriorities" %>
<%@ page import = "com.eg.EgAlarmTable" %>
<%@ page import = "com.eg.EgDateInfo"%>
<%@ page import = "com.eg.EgInstallInfo" %>
<%@ page import = "com.eg.IniFile" %>
<%@ page import = "com.eg.EgStateZone" %>
<%@ page import = "com.eg.EgGroupInfo" %>
<%@ page import = "com.egurkha.ini.IniUI" %>
<%@ page import = "java.util.List" %>
<%@ page import = "java.util.LinkedList" %>
<%@ page import = "java.util.Arrays" %>
<%@ page import = "java.util.Iterator" %>
<%@ page import = "java.util.Map" %>
<%@ page import = "java.util.HashMap" %>
<%@ page import = "java.util.Hashtable" %>
<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>
<%!
	String HIGH="RED";
	String CRITICAL="RED";
	String MEDIUM="ORANGE";
	String MAJOR="ORANGE";
	String INTERMEDIATE="PINK";
	String MINOR="PINK";
	String LOW="YELLOW";
	String GOOD="GREEN";
	String NORMAL="GREEN";
	String UNKNOWN="BLUE";

	public String getColor(String state)
	{
		if ((state.equalsIgnoreCase("HIGH"))||(state.equalsIgnoreCase("CRITICAL")))
			return HIGH;
		if ((state.equalsIgnoreCase("MEDIUM"))||(state.equalsIgnoreCase("MAJOR")))
			return MEDIUM;
		if ((state.equalsIgnoreCase("INTERMEDIATE"))||(state.equalsIgnoreCase("MINOR")))
			return INTERMEDIATE;
		if (state.equalsIgnoreCase("LOW"))
			return LOW;
		if ((state.equalsIgnoreCase("GOOD"))||(state.equalsIgnoreCase("NORMAL")))
			return GOOD;
		if (state.equalsIgnoreCase("UNKNOWN"))
			return MEDIUM;
		return "";
	}

	public String getTrimmed(String s)
	{
		s = s.substring(1, s.length()-1);
		if (s.length()>25)
			s = s.substring(0, 24)+" ... ...";
		return s;
	}
%>
<%
	try
	{
	IniUI ui = (IniUI)IniUI.getInstance();
	List order = AlarmPriorities.getStatesOrder();
	AlarmPriorities ap = AlarmPriorities.getInstance();
	UserRegistry registry = UserRegistry.getInstance();
	User user = registry.getUser(session.getId());
	EgUserRole userRole = EgUserRole.getRoleObject(user.getLoginType());
	EgGroupInfo grp=new EgGroupInfo();
	//ZONES
	List zoneNames = new LinkedList();
	zoneNames.addAll(user.getZones());
	int allZoneSize = zoneNames.size();

	boolean zoneNotNull = zoneNames!=null;
	boolean zoneFound = (zoneNotNull?zoneNames.size()>0:zoneNotNull);

	List goodZoneList = new LinkedList();
	List unknownZoneList = new LinkedList();
	List lowZoneList = new LinkedList();
	List interZoneList = new LinkedList();
	List mediumZoneList = new LinkedList();
	List highZoneList= new LinkedList();

	List zoneStatus = new LinkedList();

	String nullStr = EgConstants.NULL_STRING.toUpperCase();
	for (Iterator i=zoneNames.iterator(); i.hasNext();)
	{
		String zone = (String)i.next();
		String thisState = EgStateZone.getState("Zone:"+zone+":NULL");
		//out.println("zone:"+zone);
		if (thisState.equals("HIGH"))
		{
			highZoneList.add(zone);
			zoneStatus.add("HIGH");
		}
		else if (thisState.equals("MEDIUM"))
		{
			mediumZoneList.add(zone);
			zoneStatus.add("MEDIUM");
		}
		else if (thisState.equals("INTERMEDIATE"))
		{
			interZoneList.add(zone);
			zoneStatus.add("MEDIUM");
		}
		else if (thisState.equals("LOW"))
		{
			lowZoneList.add(zone);
			zoneStatus.add("LOW");
		}
		else if (thisState.equals("UNKNOWN"))
		{
			unknownZoneList.add(zone);
			zoneStatus.add("UNKNOWN");
		}
		else if (thisState.equals("GOOD"))
		{
			goodZoneList.add(zone);
			zoneStatus.add("GOOD");
		}
	}

	int[] allZoneState = new int[]{
														goodZoneList.size(),
														unknownZoneList.size(),
														lowZoneList.size(),
														interZoneList.size(),
														highZoneList.size()
													};


	String goodZoneString = getTrimmed(goodZoneList+"");
	String unknownZoneString = getTrimmed(unknownZoneList+"");
	String lowZoneString = getTrimmed(lowZoneList+"");
	String interZoneString = getTrimmed(interZoneList+"");
	String mediumZoneString = getTrimmed(mediumZoneList+"");
	String highZoneString= getTrimmed(highZoneList+"");
	String overAllZoneState = "GOOD";
	if (zoneStatus.size()>0)
		overAllZoneState = ap.getHighestPriority(zoneStatus.toArray());

	

	//Group calculation
	
	List groupNames = new LinkedList();
	if (userRole.hasAllComponentAccess())
	{		
		String[] groups=grp.getGroupNames();
		groupNames=Arrays.asList(groups);
	}
	else
	{
		List comp=user.getServers(false);
		if(comp!=null && comp.size()>0)
		{
			for(int i=0;i<comp.size();i++)
			{
				String tmp=(String)comp.get(i);
				String group=grp.getGroupNameForComponent(tmp);
				if(!groupNames.contains(group))
					groupNames.add(group);
			}
		}
	}
	
	
	
	int allGroupSize = groupNames.size();

	boolean groupNotNull =  groupNames!=null;
	boolean groupFound = (groupNotNull?groupNames.size()>0:groupNotNull);

	List goodGroupList = new LinkedList();
	List unknownGroupList = new LinkedList();
	List lowGroupList = new LinkedList();
	List interGroupList = new LinkedList();
	List mediumGroupList = new LinkedList();
	List highGroupList= new LinkedList();

	List groupStatus = new LinkedList();

	 nullStr = EgConstants.NULL_STRING.toUpperCase();
	for (Iterator i=groupNames .iterator(); i.hasNext();)
	{
		String group = (String)i.next();
		//String thisState =grp.getGroupState(group);
		String thisState =EgStateZone.getState("Group:"+group+":NULL");
		if (thisState.equals("HIGH"))
		{
			highGroupList.add(group);
			groupStatus.add("HIGH");
		}
		else if (thisState.equals("MEDIUM"))
		{
			mediumGroupList.add(group);
			groupStatus.add("MEDIUM");
		}
		else if (thisState.equals("INTERMEDIATE"))
		{
			interGroupList.add(group);
			groupStatus.add("MEDIUM");
		}
		else if (thisState.equals("LOW"))
		{
			lowGroupList.add(group);
			groupStatus.add("LOW");
		}
		else if (thisState.equals("UNKNOWN"))
		{
			unknownGroupList.add(group);
			groupStatus.add("UNKNOWN");
		}
		else if (thisState.equals("GOOD"))
		{
			goodGroupList.add(group);
			groupStatus.add("GOOD");
		}
	}

	int[] allGroupState = new int[]{
														goodGroupList.size(),
														unknownGroupList.size(),
														lowGroupList.size(),
														interGroupList.size(),
														highGroupList.size()
													};


	String goodGroupString = getTrimmed(goodGroupList+"");
	String unknownGroupString = getTrimmed(unknownGroupList+"");
	String lowGroupString = getTrimmed(lowGroupList+"");
	String interGroupString = getTrimmed(interGroupList+"");
	String mediumGroupString = getTrimmed(mediumGroupList+"");
	String highGroupString= getTrimmed(highGroupList+"");
	String overAllGroupState = "GOOD";
	if (groupStatus.size()>0)
		overAllGroupState = ap.getHighestPriority(groupStatus.toArray());

	//SERVICE CALCULATION
	Dashboard db = new Dashboard(user);
	List siteNames = new LinkedList();
	siteNames.addAll(user.getSites());
	siteNames.addAll(user.getServices());
	//siteNames.clear();
	boolean serviceNotNull = siteNames!=null;
	boolean serviceFound = serviceNotNull?siteNames.size()>0:serviceNotNull;

	List ubgSites = new LinkedList();
	try
	{
		ubgSites = db.getSiteStatus();
	}
	catch(Exception e)
	{
		ubgSites = new LinkedList();
	}

	List goodServiceList = new LinkedList();
	List unknownServiceList = new LinkedList();
	List lowServiceList = new LinkedList();
	List interServiceList = new LinkedList();
	List mediumServiceList = new LinkedList();
	List highServiceList= new LinkedList();

	List serviceStatus = new LinkedList();
	int serviceSize = ubgSites.size();

	for (Iterator i=ubgSites.iterator(); i.hasNext();)
	{
		List row = (List)i.next();
		if (row.get(1).equals("HIGH"))
		{
			highServiceList.add(row.get(0));
			serviceStatus.add("HIGH");
		}
		else if (row.get(1).equals("MEDIUM"))
		{
			mediumServiceList.add(row.get(0));
			serviceStatus.add("MEDIUM");
		}
		else if (row.get(1).equals("INTERMEDIATE"))
		{
			interServiceList.add(row.get(0));
			serviceStatus.add("MEDIUM");
		}
		else if (row.get(1).equals("LOW"))
		{
			lowServiceList.add(row.get(0));
			serviceStatus.add("LOW");
		}
		else if (row.get(1).equals("UNKNOWN"))
		{
			unknownServiceList.add(row.get(0));
			serviceStatus.add("UNKNOWN");
		}
		else if (row.get(1).equals("GOOD"))
		{
			goodServiceList.add(row.get(0));
			serviceStatus.add("GOOD");
		}
	}

	int[] allServiceState = new int[]{
														goodServiceList.size(),
														unknownServiceList.size(),
														lowServiceList.size(),
														interServiceList.size(),
														highServiceList.size()
													};

	String goodServiceString = getTrimmed(goodServiceList+"");
	String unknownServiceString = getTrimmed(unknownServiceList+"");
	String lowServiceString = getTrimmed(lowServiceList+"");
	String interServiceString = getTrimmed(interServiceList+"");
	String mediumServiceString = getTrimmed(mediumServiceList+"");
	String highServiceString= getTrimmed(highServiceList+"");
	String overallServiceState = "GOOD";
	if (serviceStatus.size()>0)
		overallServiceState = ap.getHighestPriority(serviceStatus.toArray());

	//SEGMENTS
	List segNames = new LinkedList();
	segNames.addAll(user.getSegments());

	boolean segmentNotNull = segNames!=null;
	boolean segmentFound = (segmentNotNull?segNames.size()>0:segmentNotNull);

	List goodSegmentList = new LinkedList();
	List unknownSegmentList = new LinkedList();
	List lowSegmentList = new LinkedList();
	List interSegmentList = new LinkedList();
	List mediumSegmentList = new LinkedList();
	List highSegmentList= new LinkedList();

	List segmentStatus = new LinkedList();

	for (Iterator i=segNames.iterator(); i.hasNext();)
	{
		String segment = (String)i.next();
		//String thisState = ap.getSegmentPriority(nullStr, segment);
		String thisState = EgStateZone.getState("Segment:"+segment+":NULL");
		if (thisState.equals("HIGH"))
		{
			highSegmentList.add(segment);
			segmentStatus.add("HIGH");
		}
		else if (thisState.equals("MEDIUM"))
		{
			mediumSegmentList.add(segment);
			segmentStatus.add("MEDIUM");
		}
		else if (thisState.equals("INTERMEDIATE"))
		{
			interSegmentList.add(segment);
			segmentStatus.add("MEDIUM");
		}
		else if (thisState.equals("LOW"))
		{
			lowSegmentList.add(segment);
			segmentStatus.add("LOW");
		}
		else if (thisState.equals("UNKNOWN"))
		{
			unknownSegmentList.add(segment);
			segmentStatus.add("UNKNOWN");
		}
		else if (thisState.equals("GOOD"))
		{
			goodSegmentList.add(segment);
			segmentStatus.add("GOOD");
		}
	}

	int[] allSegmentState = new int[]{
														goodSegmentList.size(),
														unknownSegmentList.size(),
														lowSegmentList.size(),
														interSegmentList.size(),
														highSegmentList.size()
													};


	String goodSegmentString = getTrimmed(goodSegmentList+"");
	String unknownSegmentString = getTrimmed(unknownSegmentList+"");
	String lowSegmentString = getTrimmed(lowSegmentList+"");
	String interSegmentString = getTrimmed(interSegmentList+"");
	String mediumSegmentString = getTrimmed(mediumSegmentList+"");
	String highSegmentString= getTrimmed(highSegmentList+"");
	String overAllSegmentState = "GOOD";
	System.out.println("segmentStatus:"+segmentStatus);
	try{
	if (segmentStatus.size()>0)
		overAllSegmentState = ap.getHighestPriority(segmentStatus.toArray());
	}catch (Exception e)
		{
		out.println(e);
		e.printStackTrace();
		}

	//SERVERS
	//for overall status
	int[] allServerState = new int[5];
	int allServerSize = 0;

	Map map = (HashMap)session.getAttribute("appHealth");

	/*
	 * If Servers Health applet has not finished executing, the Map object will not be bound 
	 * in the session .Using Dashboard, get the required data using getAppHealth()
	 */
	if (map == null)
	{
		map = db.getAppHealthCount();
		if (map == null)
		{
			map = new HashMap();
		}
	}
	if (map.size() > 0)
	{
		boolean lcolor=true;

		Object[] keySet2 = map.keySet().toArray();
		if (keySet2.length > 0)
		{
			Arrays.sort(keySet2);
		}
		for (int a=0; a<keySet2.length; a++)
		{
			String server = (String)keySet2[a];
			int[] states = (int[])map.get(server);		//Individual states
			for (int b=0; b<states.length; b++)
			{
				int thisCount = states[b];
				allServerSize+=thisCount;
				allServerState[b]+=thisCount;
			}
		}
	}

	Map textAttribute = new Hashtable();
	textAttribute.put("0id", "GOOD_bg");
	textAttribute.put("1id", "UNKNOWN_bg");
	textAttribute.put("2id", "LOW_bg");
	textAttribute.put("3id", "INTERMEDIATE_bg");
	textAttribute.put("4id", "HIGH_bg");
	textAttribute.put("0state", "GOOD");
	textAttribute.put("1state", "UNKNOWN");
	textAttribute.put("2state", "LOW");
	textAttribute.put("3state", "INTERMEDIATE");
	textAttribute.put("4state", "HIGH");

	int allServiceSize = siteNames.size();
	int allSegmentSize = segNames.size();
	//allServiceState

	int maxValue = Math.max(allServiceSize, allSegmentSize);
	maxValue = Math.max(maxValue, allZoneSize);
	maxValue = Math.max(maxValue, allServerSize);
	if (maxValue==0)
	{
		EgUserRole myrole = user.getUserRole();
		%>
		<jsp:forward page="EgEmpty.jsp" >
			<jsp:param name="reason" value="<%=((myrole.hasAllComponentAccess())?"No components have been enabled for monitoring":"No components have been associated for this user. <BR>Please contact your administrator.")%>"/>
		</jsp:forward>
<%
	}
%>
<html>
<head>
<style>
	#table_border{border-width:1 1px 1px 1;border-color:#999999; border-style:solid};
	#table_right_border{border-width:0 1px 0px 0;border-color:#999999; border-style:solid}
	#table_right_grey_border{border-width:0 1px 0px 0;border-color:#999999; border-style:solid}
</style>
<title>&nbsp;ELEMENTS STATUS<%//=ui.getDashboardHeading(IniUI.CURRENT_STATUS)%></title>
<link rel="stylesheet" href="eg_styles/eg_monitorstyle.css" />
</head>
<body topmargin="0" marginheight="0" leftmargin="0" marginwidth="0" bgcolor="#F6F6F6" style="over-flow:auto">
<jsp:useBean id="trans" scope ="page" class="egurkha.TransactionBean" />
<table width="100%" height="100%" cellpadding="0" cellspacing="0" border="0">
	<%
	int thisWidth = 100;
		boolean lcolor=false;
		{
			boolean exists = allZoneSize>0;
			lcolor = !lcolor;
			/*
			int thisWidth = (allZoneSize*100)/maxValue;
			if(thisWidth==0)
				thisWidth=1;
			*/	
	%>
		
		
		<tr bgcolor=<%//=lcolor?"lightgrey":"#FFFFEE"%>>
			<td nowrap align="left" height="20" class="cell_border" bgcolor="#E7E7E7">&nbsp;<a <%=(allZoneSize>0)? "href=\"EgSegmentOperations.jsp?ptype=zones&monCmd=UserZones&from=DashBoard\" target=\"eg_operations\"":"#"%> class="eg_monlink">Zones
				</a>
			</td>
			<td nowrap align="right" height="20" width="*" id="table_border2" >
				<font face="Verdana,Arial" style="font-family: Verdana,Arial; font-size: 11px; font-weight: normal; letter-spacing: 1px;">
						<%=allZoneSize%>&nbsp;&nbsp;&nbsp;&nbsp;
				</font>
			</td>
			<td nowrap align="left" height="25" width="100%" class="cell_border" bgcolor="#E7E7E7">
				<table width="<%=thisWidth%>%" border="0" cellspacing="0" cellpadding="0" height="20">
				<%
						for (int i=0; i<allZoneState.length; i++)
						{
							int thisCount = allZoneState[i];
							if (thisCount==0)
								continue;
				%>
					<!--a href="../servlet/com.eg.EgMonitorController?monCmd=UserZones&from=DashBoard&showState=<%=textAttribute.get(i+"state")%>" target="_self" -->

					<a href="EgSegmentOperations.jsp?ptype=zonestate&monCmd=UserZones&from=DashBoard&showState=<%=textAttribute.get(i+"state")%>" target="_self" >
					<span>
					<td class="mouse" 	width="<%=(thisCount*100/thisWidth)%>%" id="<%=textAttribute.get(i+"id")%>"><font face="Verdana,Arial" style="font-family: Verdana,Arial; font-size: 11px; font-weight: normal; letter-spacing: 1px;">&nbsp;<%=thisCount%>&nbsp;</font></td>
					</span>
					</a>
					<%
						}
					%>
				</table>
			</td>
		</tr>
	<%
		}

		
		
		
		
		if (siteNames!=null)
		{
			boolean exists = siteNames.size()>0;
			lcolor = !lcolor;
			/*
			int thisWidth = (serviceSize*100)/maxValue;
			
			if(thisWidth==0)
				thisWidth=1;
			*/
						
	%>

		<tr bgcolor=<%//=lcolor?"lightgrey":""%>>
			<td nowrap align="left" height="20" class="cell_border" bgcolor="#E7E7E7">&nbsp;<a <%=(serviceSize>0)? "href=\"EgMonitorOperations.jsp?display=false\" target=\"_self\"":"#"%> class="eg_monlink">Services</a>
			</td>
			<td nowrap align="right" height="20" width="50" class="cell_border" id="table_border2"><font face="Verdana,Arial" style="font-family: Verdana,Arial; font-size: 11px; font-weight: normal; letter-spacing: 1px;">
						<%=serviceSize%>&nbsp;&nbsp;&nbsp;&nbsp;</font></td>
			<td nowrap align="left" height="25" width="100%" class="cell_border" bgcolor="#E7E7E7" >
				<table width="<%=thisWidth%>%" border="0" cellspacing="0" cellpadding="0" height="20">
				<%
						for (int i=0; i<allServiceState.length; i++)
						{
							int thisCount = allServiceState[i];
							if (thisCount==0)
								continue;
				%>
					<a href="EgMonitorOperations.jsp?display=false&showState=<%=textAttribute.get(i+"state")%>" target="_self">
					
					<span>
					<td class="mouse" width="<%=(thisCount*100/thisWidth)%>%" id="<%=textAttribute.get(i+"id")%>"><font face="Verdana,Arial" style="font-family: Verdana,Arial; font-size: 11px; font-weight: normal; letter-spacing: 1px;">&nbsp;<%=thisCount%>&nbsp;</font></td>
					</span>

					<%
						}
					%>
				</table>
			</td>
		</tr>
	<%
		}
		{
			boolean exists = allSegmentSize>0;
			lcolor = !lcolor;
			/*
			int thisWidth = (allSegmentSize*100)/maxValue;
			if(thisWidth==0)
				thisWidth=1;
			*/
	%>
		
		<tr >
			<td  class="cell_border" bgcolor="#E7E7E7" nowrap align="left" height="20">&nbsp;<a class="eg_monlink" <%=(allSegmentSize>0)? "href=\"EgSegmentOperations.jsp?ptype=topology&showsitesegments=false\"":"#"%> target="_self" >Segments</a>
			</td>
			<td nowrap align="right" height="20" width="*" id="table_border2" ><font face="Verdana,Arial" style="font-family: Verdana,Arial; font-size: 11px; font-weight: normal; letter-spacing: 1px;">
						<%=allSegmentSize%>&nbsp;&nbsp;&nbsp;&nbsp;</font></td>
			<td nowrap align="left" height="25" width="100%" class="cell_border" bgcolor="#E7E7E7">
				<table width="<%=thisWidth%>%" border="0" cellspacing="0" cellpadding="0" height="20">
				<%
						for (int i=0; i<allSegmentState.length; i++)
						{
							int thisCount = allSegmentState[i];
							if (thisCount==0)
								continue;
				%>
					<!--
					<a href="EgDispSegStates.jsp?showState=<%=textAttribute.get(i+"state")%>" target="_self">
					-->
					<a href="EgSegmentOperations.jsp?showState=<%=textAttribute.get(i+"state")%>&ptype=topology&showsitesegments=false" target="_self">
					
					<span>
					<td class="mouse" 	width="<%=(thisCount*100/thisWidth)%>%" id="<%=textAttribute.get(i+"id")%>"><font face="Verdana,Arial" style="font-family: Verdana,Arial; font-size: 11px; font-weight: normal; letter-spacing: 1px;">&nbsp;<%=thisCount%>&nbsp;</font></td>
					</span>
					</a>
					<%
						}
					%>
				</table>
			</td>
		</tr>
	<%
		}
	


		boolean lcolor1=false;
		{
			boolean exists = allServerSize>0;
			lcolor = !lcolor;
			/*
			int thisWidth = (allServerSize*100)/maxValue;
			if(thisWidth==0)
				thisWidth=1;
			*/
	

	%>
		<tr bgcolor=<%//=lcolor?"lightgrey":""%>>
			<td nowrap align="left" height="20" class="cell_border" bgcolor="#E7E7E7">&nbsp;<a <%=(allServerSize>0)? "href=\"EgSegmentOperations.jsp?ptype=independent&showsitesegments=false\"":"#"%> target="_self" class="eg_monlink">Components</a>
			</td>
			<td nowrap align="right" height="20" width="*"  id="table_border2"><font face="Verdana,Arial" style="font-family: Verdana,Arial; font-size: 11px; font-weight: normal; letter-spacing: 1px;">
						<%=allServerSize%>&nbsp;&nbsp;&nbsp;&nbsp;</font></td>
			<td nowrap align="center" height="25" width="100%" bgcolor="#E7E7E7">
				<table width="<%=thisWidth%>%" border="0" cellspacing="0" cellpadding="0" height="20">
				<%
						for (int i=0; i<allServerState.length; i++)
						{
							int thisCount = allServerState[i];
							if (thisCount==0)
								continue;
				%>
				<a href="../servlet/com.egurkha.monitor.DashboardDistribution?showState=<%=textAttribute.get(i+"state")%>" target="_self">
				<span>
					<td class="mouse" width="<%=(thisCount*100/thisWidth)%>%" id="<%=textAttribute.get(i+"id")%>"><font face="Verdana,Arial" style="font-family: Verdana,Arial; font-size: 11px; font-weight: normal; letter-spacing: 1px;">&nbsp;<%=thisCount%>&nbsp;</font></td>
				</span>
				</a>
					
					<%
						}
					%>
				</table>			
			</td>
		</tr>
	<%
		}
	}
	catch(Exception e)
	{
			e.printStackTrace();
	}
	%>
</table>
</body>
</html>