<%
/*
	File					:	ecPrintAuditReport.jsp
	Purpose					:	Prints the audit reports
	Creation Date			:	26-02-2007
	Author					:	Balasigamani,Krishnamurthi
	UI Design				:	Krishnamurthi
	UI Design Changes		:	Jaiwin
*/
%>

<%@ page import="java.util.*" %>
<%@ page import="java.text.*"%>
<%@ page import="java.net.URLEncoder"%>
<%@ page import="egurkha.config.EcPrintData"%>
<%@ page import = "egurkha.config.EcUserData"%>
<%@ page import = "com.eg.EgMappingInfo"%>
<%@ page import="com.egurkha.User" %>
<%@ page import="com.egurkha.UserRegistry" %>
<%@ page import = "com.eg.EgInstallInfo" %>
<%@ page import = "com.eg.IniFile" %>
<%@ page import = "com.eg.EgURLEncoder"%>
<%@ page import="com.egurkha.ini.IniUI"%>
<%@ page import = "com.eg.EgDbInfo"%>
<%@ page import = "com.egurkha.EgTimeZoneConverter"%>
<%@ page import="egurkha.EgUIUtils" %>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>

<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>

<%!
	String[] criterias = {"Zone","Service","Segment","Component"};
%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>

<%
	UserRegistry registry = UserRegistry.getInstance();
	User user = registry.getUser(session.getId());
	IniUI iniUI = IniUI.getInstance();

	String ec_userName = request.getParameter("userName");
	String ec_user_language = request.getParameter("user_language");

	//user language
	String userLanguage = null;
	if (user != null)
	{
		userLanguage = user.getLanguage();
	}
	else if (user == null)
	{
		EcUserData ecUserData = new EcUserData(ec_userName,false);
		user = ecUserData.getUser(ec_userName);
		userLanguage = ec_user_language;
	}

	if (userLanguage == null)
	{
		userLanguage = iniUI.getDefaultLanguage();
	}

	EgMappingInfo mappingInfo = new EgMappingInfo(userLanguage);
	EgDbInfo dbInfo = new EgDbInfo("manager");

	String uiFile = "eg_ui.ini";
	String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
	IniFile iniFile = new IniFile(s_iniFile_dir + uiFile);
	String currentDateFormat = iniFile.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");

	String userDateFormat = user.getUserDateFormat();
	if (userDateFormat != null && userDateFormat.equalsIgnoreCase("default"))
	{
		userDateFormat = currentDateFormat;
	}

	// If user date format is set, assign it to current date format.
	if (userDateFormat != null)
	{
		currentDateFormat = userDateFormat;
	}

	String printType = request.getParameter("printType");
	SimpleDateFormat formatter = new SimpleDateFormat (currentDateFormat+" " +"HH:mm:ss");
	Date currentDateTime = new Date();
	String dateString = formatter.format(currentDateTime);

	/* Added by Prakash.K Starts */
	EgTimeZoneConverter timeZoneConverter = new EgTimeZoneConverter(dateString,user);
	dateString = (String)timeZoneConverter.getDateTime();
	/* Added by Prakash.K ends */

	String ec_criteria = (String)session.getAttribute("ec_criteria");
	Vector vecUserOptions = (Vector)session.getAttribute("vecUserOptions");
	String ec_userOption = (String)session.getAttribute("ec_userOption");
	String ec_criteriaPrevious = request.getParameter("ec_criteriaPrevious");
	String ec_userOptionPrevious = request.getParameter("ec_userOptionPrevious");

	Vector vecCriterias = new Vector();
	for (int g=0;g<criterias.length;g++)
	{
		String criteria = criterias[g];
		vecCriterias.add(criteria);
	}

	String ec_forPDF = request.getParameter("ec_forPDF");
	String requestFrom = request.getParameter("requestFrom");

	if (ec_forPDF != null && ec_forPDF.equalsIgnoreCase("Yes"))
	{
		ec_criteria = request.getParameter("ec_criteria");
		ec_userOption = request.getParameter("ec_userOption");
	}

	String reportTitle = "";
	if (printType != null && printType.equalsIgnoreCase("HardDisk_Audit"))
	{
		reportTitle = mappingInfo.getTextDescription("configmgmt.inventory.system.DISTRIBUTION REPORT OF MANAGED SYSTEMS")+" "+mappingInfo.getTextDescription("configmgmt.inventory.system.BY")+" "+mappingInfo.getTextDescription("configmgmt.inventory.system.HARD DISK CAPACITY");
	}
	else if (printType != null && printType.equalsIgnoreCase("RAMCapacity_Audit"))
	{
		reportTitle = mappingInfo.getTextDescription("configmgmt.inventory.system.DISTRIBUTION REPORT OF MANAGED SYSTEMS")+" "+mappingInfo.getTextDescription("configmgmt.inventory.system.BY")+" "+mappingInfo.getTextDescription("configmgmt.inventory.system.RAM SIZE");
	}
	else if (printType != null && printType.equalsIgnoreCase("ServicePack"))
	{
		reportTitle = mappingInfo.getTextDescription("configmgmt.inventory.system.DISTRIBUTION REPORT OF MANAGED SYSTEMS")+" "+mappingInfo.getTextDescription("configmgmt.inventory.system.BY")+" "+mappingInfo.getTextDescription("configmgmt.inventory.system.SERVICE PACK");
	}
	else if (printType != null && printType.equalsIgnoreCase("SystemManufacturer"))
	{
		reportTitle = mappingInfo.getTextDescription("configmgmt.inventory.system.DISTRIBUTION REPORT OF MANAGED SYSTEMS")+" "+mappingInfo.getTextDescription("configmgmt.inventory.system.BY")+" "+mappingInfo.getTextDescription("configmgmt.inventory.system.MANUFACTURER");
	}
	else if (printType != null && printType.equalsIgnoreCase("ProcessorFamily"))
	{
		reportTitle = mappingInfo.getTextDescription("configmgmt.inventory.system.DISTRIBUTION REPORT OF MANAGED SYSTEMS")+" "+mappingInfo.getTextDescription("configmgmt.inventory.system.BY")+" "+mappingInfo.getTextDescription("configmgmt.inventory.system.PROCESSOR FAMILY");
	}
	else if (printType != null && printType.equalsIgnoreCase("IPAddress_Audit"))
	{
		reportTitle = mappingInfo.getTextDescription("configmgmt.inventory.system.DISTRIBUTION REPORT OF")+" "+mappingInfo.getTextDescription("configmgmt.inventory.system.STATIC AND DYNAMIC IP ADDRESS ALLOCATED SYSTEMS");
	}
	else if (printType != null && printType.equalsIgnoreCase("Gateway_Audit"))
	{
		reportTitle = mappingInfo.getTextDescription("configmgmt.inventory.system.DISTRIBUTION REPORT OF")+" "+mappingInfo.getTextDescription("configmgmt.inventory.system.MANAGED SYSTEMS CONFIGURED WITH NETWORK GATEWAY ROUTERS");
	}
	else if (printType != null && printType.equalsIgnoreCase("PrinterInfo"))
	{
		reportTitle = mappingInfo.getTextDescription("configmgmt.inventory.printers.CONFIGURED PRINTERS REPORT");
	}

	String fontStyle = "";
	if ((dbInfo.doubleByteEnabled || !userLanguage.equals("en_US")) && 
		(ec_forPDF != null && ec_forPDF.equalsIgnoreCase("Yes")))
	{
		fontStyle = "multi_font";
	}

	boolean isBlank = false;
	boolean isDataBlank = false;

%>

<html style="background:#ffffff!important">
<head>
<title><egui:intnl text="configmgmt.common.eG Configuration Audit Report" /></title>
<egui:skin ui="config"/>
<link rel="stylesheet" type="text/css" href="/final/styles/eGLightThemeIcons.css" />

<style>
	@media print {body {-webkit-print-color-adjust: exact;}}
	header {font-size: 15px; }
	.iconPrinter { background-position: 0 -1080px; width: 16px; height: 16px; }
</style>

<script language="Javascript">
	//window.print();
</script>
</head>

<body topmargin="0" marginheight="0" leftmargin="0" marginwidth="0">
<form name="printData">
<input type="hidden" name="ec_criteriaPrevious" value="<%=ec_criteria%>">
<input type="hidden" name="ec_userOptionPrevious" value="<%=ec_userOption%>">

<table width="99%" align="center" cellspacing="0" cellpadding="0" border="0">

<%
	if (ec_forPDF != null && ec_forPDF.equalsIgnoreCase("No"))
	{
%>
	<tr>
		<td height="5">
			<img src="/final/config/images/spacer.gif" border="0" height="5">
		</td>
	</tr>

	<tr>
		<td align="center">
			<table align="center" cellspacing="0" cellpadding="0" height="24" border="0" width="100%" class="body_text">
				<tr>
					<td align="center">
						<b><egui:intnl text="configmgmt.common.Generated on" />&nbsp;<%=dateString%></b>
					</td>
				</tr>
			</table>
		</td>
	</tr>

	<tr>
		<td>
			<table width="100%" align="center" cellspacing="0" cellpadding="0" border="0" class="body_text">
				<tr>
					<td  align="center" height="24" class="cellborder">
						<table align="center" cellspacing="0" cellpadding="0" height="24" border="0" width="100%" id="pageHeader">
							<tr>
<%
		if (printType != null && printType.equalsIgnoreCase("PrinterInfo"))
		{
			if (ec_criteria != null && !ec_criteria.equalsIgnoreCase(criterias[3]) && !ec_criteria.equals("-1"))
			{
				ec_criteria = ec_criteria.toUpperCase();
				ec_userOption = ec_userOption.toUpperCase();
%>
								<td align="left" width="100%"><div style="float:left"><header><%=reportTitle.toUpperCase()%>&nbsp;<egui:intnl text="OF" />&nbsp;'<%=ec_userOption%>'&nbsp;<%=ec_criteria%></header></div>
<%
			}
			else
			{
%>
								<td align="left" width="100%"><div style="float:left"><header><%=reportTitle.toUpperCase()%></header></div>
<%
			}
		}
		else
		{
			if (ec_criteria != null && !ec_criteria.equalsIgnoreCase(criterias[3]) && !ec_criteria.equals("-1"))
			{
				ec_criteria = ec_criteria.toUpperCase();
				ec_userOption = ec_userOption.toUpperCase();
%>

								<td align="left" width="100%"><div style="float:left"><header><%=reportTitle.toUpperCase()%>&nbsp;<egui:intnl text="IN" />&nbsp;'<%=ec_userOption%>'&nbsp;<%=ec_criteria%></header></div>
<%
			}
			else
			{
%>
								<td align="left" width="100%"><div style="float:left"><header><%=reportTitle.toUpperCase()%></header></div>
<%
			}
		}
%>
								<div style="float:right">
									<img class="mouse iconPrinter" src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" border="0" onClick="javascript:print()">
									<!--<img class="mouse iconPrinter" src="../config/images/printer_print.jpg" border="0" onclick="javascript:print()"> -->
								</div>
							</td>
							</tr>
						</table>
					</td>
				</tr>
			</table>
		</td>
	</tr>

	<tr><td><table border="0" cellspacing="0" cellpadding="0" width="100%"><tr><td height="0"><img src="/final/config/images/spacer.gif" border="0" height="15"></td></tr></table></td></tr>
<%
	}
	else if (ec_forPDF != null && ec_forPDF.equalsIgnoreCase("Yes"))
	{
		//String imageName = iniUI.getConfigHomeLogo();
		String imageName = user.getConfigLogo();
%>
	<tr>
		<td>
			<table width="100%" border="0" cellspacing="0" cellpadding="0">
				<tr>
					<td align="left" width="30%" valign="bottom"><img src="<%=imageName%>" border="0"></td>
					<td width="70%" align="right" valign="bottom">
						<table width="100%" border="0" cellspacing="0" cellpadding="0">
<%
		if (printType != null && printType.equalsIgnoreCase("PrinterInfo"))
		{
			if (ec_criteria != null && !ec_criteria.equalsIgnoreCase(criterias[3]) && !ec_criteria.equals("-1"))
			{
				ec_criteria = ec_criteria.toUpperCase();
				ec_userOption = ec_userOption.toUpperCase();
%>
								<tr>
									<td align="right" class="<%=fontStyle%>"><b><%=reportTitle.toUpperCase()%>&nbsp;<egui:intnl text="OF" />&nbsp;'<%=ec_userOption%>'&nbsp;<%=ec_criteria%></b></td>
								</tr>
<%
			}
			else
			{
%>
								<tr>
									<td align="right" class="<%=fontStyle%>"><b><%=reportTitle.toUpperCase()%></b></td>
								</tr>
<%
			}
		}
		else
		{
			if (ec_criteria != null && !ec_criteria.equalsIgnoreCase(criterias[3]) && !ec_criteria.equals("-1"))
			{
				ec_criteria = ec_criteria.toUpperCase();
				ec_userOption = ec_userOption.toUpperCase();
%>

								<tr>
									<td align="right" class="<%=fontStyle%>"><b><%=reportTitle.toUpperCase()%>&nbsp;<egui:intnl text="IN" />&nbsp;'<%=ec_userOption%>'&nbsp;<%=ec_criteria%></b></td>
								</tr>
<%
			}
			else
			{
%>
								<tr>
									<td align="right" class="<%=fontStyle%>"><b><%=reportTitle.toUpperCase()%></b></td>
								</tr>
<%
			}
		}
%>
							<tr>
								<td>
									<img src="/final/config/images/spacer.gif" border="0">
								</td>
							</tr>
							<tr>
								<td align="right" valign="bottom" class="<%=fontStyle%>"><b><egui:intnl text="configmgmt.configuration.as on" />&nbsp;<%=dateString%></b></td>
							</tr>
						</table>
					</td>
				</tr>
			</table>
		</td>
	</tr>
	<tr>
		<td height="5">
			<img src="/final/config/images/spacer.gif" border="0" height="50">
		</td>
	</tr>
<%
	}

	if (printType!=null && printType.equalsIgnoreCase("ServicePack"))
	{
		TreeMap tmapServicePackDetails = null;
		String osName = "";
		String spVersion = "";
		String spChartColor = "";
		if (requestFrom != null && requestFrom.equals("Schedule"))
		{
			tmapServicePackDetails = (TreeMap)request.getAttribute("ServicePackDetails");
			osName = (String)request.getAttribute("osName");
			spVersion = (String)request.getAttribute("spVersion");
			spChartColor = (String)request.getAttribute("spChartColor");
		}
		else
		{
			tmapServicePackDetails = (TreeMap)session.getAttribute("ServicePackDetails");
			osName = (String)session.getAttribute("osName");
			spVersion = (String)session.getAttribute("spVersion");
			spChartColor = (String)session.getAttribute("spChartColor");
		}
%>
	<tr>
		<td align="center">
			<table border="0" align="center" width="100%" class="body_text">
				<tr>
					<td align="center">
<%
		if (tmapServicePackDetails != null)
		{
			StringBuffer strBuffer1 = new StringBuffer();
			StringBuffer strBuffer2 = new StringBuffer();
			String titleName = "";
			String systemcount = "";

			if (spVersion.equalsIgnoreCase("All"))
			{
				int maxCount = 0;
				Iterator spversion_keys = tmapServicePackDetails.keySet().iterator();
				while (spversion_keys.hasNext())
				{
					Double key_spversion = (Double)spversion_keys.next();

					if (key_spversion.doubleValue() == 0.0)
						strBuffer1.append("None,");
					else
						strBuffer1.append(key_spversion.toString()+",");
			
					ArrayList aList = (ArrayList)tmapServicePackDetails.get(key_spversion);
					strBuffer2.append(aList.size()+",");

					maxCount = Math.max(maxCount,aList.size());
				}

				String spversions = strBuffer1.substring(0,strBuffer1.length()-1);
				systemcount = strBuffer2.substring(0,strBuffer2.length()-1);

				titleName = mappingInfo.getTextDescription("configmgmt.inventory.system.Distribution of") + " " + osName + " " + mappingInfo.getTextDescription("configmgmt.inventory.system.systems By Service Pack");
%>
						<table border="0" align="center" width="100%" class="body_text">
							<tr align="center">
								<td width="100%" align="center">
									<img src="../servlet/com.eg.EcChartController?view=GRAPH&pageName=SERVICE_PACK_DISTRIBUTION&chartColor=<%=spChartColor%>&chartType=bar&height=290&width=550&chartTitle=<%=EgURLEncoder.encode(titleName,"UTF-8")%>&sampleValues=<%=systemcount%>&barLabels=<%=spversions%>&range=<%=maxCount%>&userName=<%=EgURLEncoder.encode(ec_userName,"UTF-8")%>" border="0" hspace="0">
								</td>
							</tr>
						</table>

						<table border="0" cellspacing="0" cellpadding="0" width="100%"><tr><td height="0"><img src="/final/config/images/spacer.gif" border="0" height="10"></td></tr></table>

<%
				spversion_keys = tmapServicePackDetails.keySet().iterator();
				while (spversion_keys.hasNext())
				{
					Double key_spversion = (Double)spversion_keys.next();
					ArrayList aList = (ArrayList)tmapServicePackDetails.get(key_spversion);

					if (aList.size() == 0) continue;
%>
						<table width="100%" border="0" cellpadding="0" cellspacing="0" class="body_text" id="bottomtable" style="border-bottom-width:0px">
							<tr>
<%
					if (key_spversion.doubleValue() == 0.0)
					{
%>
								<td height="20" id="linebottom" class="<%=fontStyle%>">
									&nbsp;<b><%=osName%>&nbsp;<egui:intnl text="configmgmt.inventory.system.systems with no service pack" />&nbsp;&nbsp;(<egui:intnl text="configmgmt.inventory.system.Count" /> : <%=aList.size()%>)</b>
								</td>
<%
					}
					else
					{
%>
								<td height="20" id="linebottom" class="<%=fontStyle%>">
									&nbsp;<b><%=osName%>&nbsp;<egui:intnl text="configmgmt.inventory.system.systems with service pack" />&nbsp;<%=key_spversion.toString()%>&nbsp;&nbsp;(<egui:intnl text="configmgmt.inventory.system.Count" /> : <%=aList.size()%>)</b>
								</td>
<%
					}
%>
							</tr>

							<tr>
								<td align="left" width="100%">
									<table border="0" width="100%" cellspacing="0" cellpadding="0" class="body_text">
<%
					for (int d=0; d<aList.size(); d=d+4)
					{
%>
										<tr>
<%
						for (int e=d; e<d+4; e++)
						{
							if (e<aList.size())
							{
								String system = (String)aList.get(e);
								if (e == d+4-1)
								{
%>
											<td id="linebottom" width="20%" height="20" class="<%=fontStyle%>">
<%
								}
								else
								{
%>
											<td id="linebottomright" width="20%" height="20" class="<%=fontStyle%>">
<%
								}
%>
												&nbsp;<%=system%>
											</td>
<%
							}
							else
							{
								if (e == d+4-1)
								{
%>
											<td id="linebottom" width="20%">
<%
								}
								else
								{
%>
											<td id="linebottomright" width="20%">
<%
								}
%>
												&nbsp;
											</td>
<%
							}
						}
%>
										</tr>
<%
					}
%>
									</table>
								</td>
							</tr>
						</table>
			
						<table border="0" cellspacing="0" cellpadding="0" width="100%"><tr><td height="0"><img src="/final/config/images/spacer.gif" border="0" height="20"></td></tr></table>
<%
				}
			}
			else
			{
				ArrayList aListAvailable = (ArrayList)tmapServicePackDetails.get("Available");
				TreeMap tmapUnavailable = (TreeMap)tmapServicePackDetails.get("Unavailable");

				if (aListAvailable != null || tmapUnavailable != null)
				{
%>
						<table border="0" align="center" width="100%" class="body_text">
							<tr>
								<td height="20" class="<%=fontStyle%>">
									&nbsp;<b><%=osName%>&nbsp;<egui:intnl text="configmgmt.inventory.system.System" /></b>
								</td>
							</tr>
						</table>
<%
				}

				if (aListAvailable != null)
				{
%>
						<table border="0" cellspacing="0" cellpadding="0" width="100%"><tr><td height="5"><img src="/final/config/images/spacer.gif" border="0" height="5"></td></tr></table>

						<table border="0" align="center" width="100%" class="body_text" cellspacing="0" cellpadding="0" id="bottomtable" style="border-bottom-width:0px">
<%
					if (spVersion == "None")
					{
%>
							<tr>
								<td id="linebottom" height="20" align="left" class="<%=fontStyle%>">
									&nbsp;<b><egui:intnl text="configmgmt.inventory.system.With no service pack" />&nbsp;&nbsp;(<egui:intnl text="configmgmt.inventory.system.Count" /> : <%=aListAvailable.size()%>)</b>
								</td><!-- <td height="15"><img src="/final/config/images/cell_corner_green.gif"></td> -->
							</tr>
<%
					}
					else
					{
%>
							<tr>
								<td id="linebottom" height="20" align="left" class="<%=fontStyle%>">
									&nbsp;<b><egui:intnl text="configmgmt.inventory.system.With service pack" />&nbsp;<%=spVersion%>&nbsp;&nbsp;(<egui:intnl text="configmgmt.inventory.system.Count" /> : <%=aListAvailable.size()%>)</b>
								</td>
							</tr>
<%
					}
%>
							<tr>
								<td align="left" width="100%" >
									<table border="0" width="100%" cellspacing="0" cellpadding="0" class="body_text">
<%
					for (int d=0; d<aListAvailable.size(); d=d+4)
					{
%>
										<tr>
<%
						for (int e=d; e<d+4; e++)
						{
							if (e<aListAvailable.size())
							{
								String system = (String)aListAvailable.get(e);
								if (e == d+4-1)
								{
%>
											<td id="linebottom" width="20%" height="20" class="<%=fontStyle%>">
<%
								}
								else
								{
%>
											<td id="linebottomright" width="20%" height="20" class="<%=fontStyle%>">
<%
								}
%>
												&nbsp;<%=system%>
											</td>
<%
							}
							else
							{
								if (e == d+4-1)
								{
%>
											<td id="linebottom" width="20%" height="20">
<%
								}
								else
								{
%>
											<td id="linebottomright" width="20%" height="20">
<%
								}
%>
												&nbsp;
											</td>
<%
							}
						}
%>
										</tr>
<%
					}
%>
									</table>
								</td>
							</tr>
						</table>

						<table border="0" cellspacing="0" cellpadding="0" width="100%"><tr><td height="5"><img src="/final/config/images/spacer.gif" border="0" height="5"></td></tr></table>
<%
				}

				if (tmapUnavailable != null)
				{
					Iterator spversion_keys = tmapUnavailable.keySet().iterator();
					int totalCount = 0;
					while (spversion_keys.hasNext())
					{
						Double key_spversion = (Double)spversion_keys.next();
						ArrayList aListComponents = (ArrayList)tmapUnavailable.get(key_spversion);
						totalCount = totalCount + aListComponents.size();
					}
%>
						<table border="0" cellspacing="0" cellpadding="0" width="100%"><tr><td height="5"><img src="/final/config/images/spacer.gif" border="0" height="5"></td></tr></table>

						<table width="100%" border="0" cellpadding="0" cellspacing="0" class="body_text" style="border-bottom-width:0px">
							<tr>
								<td height="20" id="linebottom" width="31%" class="<%=fontStyle%>">
									&nbsp;<b><egui:intnl text="configmgmt.inventory.system.Can be upgraded to service pack" />&nbsp;<%=spVersion%>&nbsp;&nbsp;(<egui:intnl text="configmgmt.inventory.system.Count" /> : <%=totalCount%>)</b>
								</td>
							</tr>

							<tr>
								<td align="center" colspan="2">
<%
					spversion_keys = tmapUnavailable.keySet().iterator();
					while (spversion_keys.hasNext())
					{
						Double key_spversion = (Double)spversion_keys.next();
						ArrayList aListComponents = (ArrayList)tmapUnavailable.get(key_spversion);
%>
									<table width="100%" border="0" cellpadding="0" cellspacing="0" class="body_text" id="bottomtable" style="border-top-width:0px;border-bottom-width:0px;">
										<tr>
<%
						if (key_spversion.doubleValue() == 0.0)
						{
%>
											<td align="left" width="50%" id="linebottom" height="20" class="<%=fontStyle%>">
												&nbsp;<b><egui:intnl text="configmgmt.inventory.system.No Service Pack Systems" />&nbsp;&nbsp;(<egui:intnl text="configmgmt.inventory.system.Count" /> : <%=aListComponents.size()%>)</b>
											</td>
<%
						}
						else
						{
%>
											<td align="left" width="50%" id="linebottom" height="20" class="<%=fontStyle%>">
												&nbsp;<b><egui:intnl text="configmgmt.inventory.system.Service Pack" />&nbsp;<%=key_spversion.toString()%>&nbsp;<egui:intnl text="configmgmt.inventory.system.Systems" />&nbsp;&nbsp;(<egui:intnl text="configmgmt.inventory.system.Count" /> : <%=aListComponents.size()%>)</b>
											</td>
<%
						}
%>
										</tr>

										<tr>
											<td align="left" width="100%">
												<table border="0" width="100%" cellspacing="0" cellpadding="0" class="body_text">
<%
						for (int d=0; d<aListComponents.size(); d=d+4)
						{
%>
													<tr>
<%
							for (int e=d; e<d+4; e++)
							{
								if (e<aListComponents.size())
								{
									String system = (String)aListComponents.get(e);
									if (e == d+4-1)
									{
%>
														<td id="linebottom" width="20%" height="20" class="<%=fontStyle%>">
<%
									}
									else
									{
%>
														<td id="linebottomright" width="20%" height="20" class="<%=fontStyle%>">
<%
									}
%>
															&nbsp;<%=system%>
														</td>
<%
								}
								else
								{
									if (e == d+4-1)
									{
%>
														<td id="linebottom" width="20%" height="20">
<%
									}
									else
									{
%>
														<td id="linebottomright" width="20%" height="20">
<%
									}
%>
															&nbsp;
														</td>
<%
								}
							}
%>
													</tr>
<%
						}
%>
												</table>
											</td>
										</tr>
									</table>
<%
					}
%>
								</td>
							</tr>
						</table>
<%
				}
			}
		}
		else
		{
%>
			<tr>
					<td align="center">
						<table border="0" cellspacing="0" cellpadding="0" width="100%"><tr><td height="0"><img src="/final/config/images/spacer.gif" border="0" height="50"></td></tr></table>
					</td>
				</tr>
				<tr>
					<td align="center">
						<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" height="100%" valign="top">
							<tr>
								<td width="100%" height="100%">
									<table border="0" align="center" width="100%" class="body_text" cellspacing="0" cellpadding="0" height="100%">
										<tr>
											<td align="center" height="100%">
												<table border="0" align="center" width="100%" height="100%" cellspacing="0" cellpadding="0">
													<tr>
														<td align="center">
															<table border="0" align="center" width="100%" class="body_text" cellspacing="0" cellpadding="0">
																<tr>
																	<td align="center"><img src="/final/config/images/unavailable-data.gif"></td>
																</tr>
																<tr>
																	<td align="center" class="<%=fontStyle%>"><b><%=mappingInfo.getTextDescription("configmgmt.common.No data found")%></b></td>
																</tr>
															</table>
														</td>
													</tr>
												</table>
											</td>
										</tr>
									</table>
								</td>
							</tr>
						</table>
					</td>
				</tr>
<%
		}
%>
					</td>
				</tr>
			</table>
		</td>
	<tr>
<%
	}
	else if (printType!=null && printType.equalsIgnoreCase("SystemManufacturer"))
	{
		TreeMap tmapSystemDetails = null;
		String manufacturer = null;
		String smChartColor = null;
		if (requestFrom != null && requestFrom.equals("Schedule"))
		{
			tmapSystemDetails = (TreeMap)request.getAttribute("SystemManufacturerDetails");
			manufacturer = (String)request.getAttribute("manufacturer");
			smChartColor = (String)request.getAttribute("smChartColor");
		}
		else
		{
			tmapSystemDetails = (TreeMap)session.getAttribute("SystemManufacturerDetails");
			manufacturer = (String)session.getAttribute("manufacturer");
			smChartColor = (String)session.getAttribute("smChartColor");
		}
%>
	<tr>
		<td align="center">
			<table border="0" align="center" width="100%" class="body_text">
				<tr>
					<td align="center">
<%
		if (tmapSystemDetails != null)
		{
			StringBuffer strBuffer1 = new StringBuffer();
			StringBuffer strBuffer2 = new StringBuffer();
			String titleName = "";
			String systemmf = "";
			String systemcount = "";

			if (manufacturer.equalsIgnoreCase("All"))
			{
				int maxCount = 0;
				Iterator manufacturer_keys = tmapSystemDetails.keySet().iterator();
				while (manufacturer_keys.hasNext())
				{
					String key_manufacturer = (String)manufacturer_keys.next();
					strBuffer1.append(key_manufacturer+",");
			
					int count = 0;
					TreeMap tmapModels = (TreeMap)tmapSystemDetails.get(key_manufacturer);
					Iterator model_keys = tmapModels.keySet().iterator();
					while (model_keys.hasNext())
					{
						String key_model = (String)model_keys.next();
						ArrayList aList = (ArrayList)tmapModels.get(key_model);
						count = count + aList.size();
					}

					maxCount = Math.max(maxCount,count);
					strBuffer2.append(count+",");
				}

				systemmf = strBuffer1.substring(0,strBuffer1.length()-1);
				systemcount = strBuffer2.substring(0,strBuffer2.length()-1);
				titleName = mappingInfo.getTextDescription("configmgmt.inventory.system.Distribution of Systems By Manufacturer");
%>
						<table border="0" width="100%" cellspacing="0" cellpadding="0" class="body_text">
							<tr align="center">
								<td width="100%" align="center">
									<img src="../servlet/com.eg.EcChartController?view=GRAPH&pageName=SYSTEM_MANUFACTURER&chartColor=<%=smChartColor%>&chartType=bar&height=250&width=650&chartTitle=<%=EgURLEncoder.encode(titleName,"UTF-8")%>&sampleValues=<%=systemcount%>&barLabels=<%=EgURLEncoder.encode(systemmf,"UTF-8")%>&range=<%=maxCount%>&barAlignment=horizontal&rangeAxisLabelAngle=270&userName=<%=EgURLEncoder.encode(ec_userName,"UTF-8")%>" border="0" hspace="0">
								</td>
							</tr>
						</table>

						<table border="0" cellspacing="0" cellpadding="0" width="100%"><tr><td height="0"><img src="/final/config/images/spacer.gif" border="0" height="10"></td></tr></table>
<%
				manufacturer_keys = tmapSystemDetails.keySet().iterator();
				while (manufacturer_keys.hasNext())
				{
					String key_manufacturer = (String)manufacturer_keys.next();
					ArrayList aListComponents = new ArrayList();
					TreeMap tmapModels = (TreeMap)tmapSystemDetails.get(key_manufacturer);
					Iterator model_keys = tmapModels.keySet().iterator();
					while (model_keys.hasNext())
					{
						String key_model = (String)model_keys.next();
						ArrayList aList = (ArrayList)tmapModels.get(key_model);
						aListComponents.addAll(aList);
					}
%>
						<table width="100%" border="0" cellpadding="0" cellspacing="0" class="body_text" id="bottomtable" style="border-bottom-width:0px">
							<tr>
								<td height="20" id="linebottom" class="<%=fontStyle%>">
									&nbsp;<b><%=key_manufacturer%>&nbsp;&nbsp;(<egui:intnl text="configmgmt.inventory.system.Count" /> : <%=aListComponents.size()%>)</b>
								</td>
							</tr>
							<tr>
								<td align="left" width="100%">
									<table border="0" width="100%" cellspacing="0" cellpadding="0" class="body_text">
<%
					for (int d=0; d<aListComponents.size(); d=d+4)
					{
%>
										<tr>
<%
						for (int e=d; e<d+4; e++)
						{
							if (e<aListComponents.size())
							{
								String system = (String)aListComponents.get(e);
								if (e == d+4-1)
								{
%>
											<td id="linebottom" width="20%" height="20" class="<%=fontStyle%>">
<%
								}
								else
								{
%>
											<td id="linebottomright" width="20%" height="20" class="<%=fontStyle%>">
<%
								}
%>
												&nbsp;<%=system%>
											</td>
<%
							}
							else
							{
								if (e == d+4-1)
								{
%>
											<td id="linebottom" width="20%" height="20">
<%
								}
								else
								{
%>
											<td id="linebottomright" width="20%" height="20">
<%
								}
%>
												&nbsp;
											</td>
<%
							}
						}
%>
										</tr>
<%
					}
%>
									</table>
								</td>
							</tr>
						</table>

						<table border="0" cellspacing="0" cellpadding="0" width="100%"><tr><td height="0"><img src="/final/config/images/spacer.gif" border="0" height="20"></td></tr></table>
<%
				}
			}
			else
			{
%>
						<table border="0" width="100%" cellspacing="0" cellpadding="0" style="border-bottom-width:0px">
							<tr>
								<td height="20" id="linebottom" class="<%=fontStyle%>">
									&nbsp;<b><%=manufacturer%></b>
								</td>
							</tr>
							<tr><td><table border="0" width="100%" cellspacing="0" cellpadding="3" class="bottomtable" style="border-top-width:0px;border-bottom-width:0px;">
<%
				Iterator model_keys = tmapSystemDetails.keySet().iterator();
				while (model_keys.hasNext())
				{
					String key_model = (String)model_keys.next();
					ArrayList aList = (ArrayList)tmapSystemDetails.get(key_model);
%>
							<tr>
								<td align="left" width="50%" colspan="4" id="linebottom" height="20" class="<%=fontStyle%>">
									&nbsp;<b><egui:intnl text="configmgmt.inventory.system.Model" /> : <%=key_model%>&nbsp;&nbsp;(<egui:intnl text="configmgmt.inventory.system.Count" /> : <%=aList.size()%>)</b>
								</td>
							</tr>

							<tr>
								<!--<td align="left" width="100%">
									<table border="0" width="100%" cellspacing="0" cellpadding="0" class="body_text">-->
<%
					for (int d=0; d<aList.size(); d=d+4)
					{
%>
										<!--<tr>-->
<%
						for (int e=d; e<d+4; e++)
						{
							if (e<aList.size())
							{
								String system = (String)aList.get(e);
								if (e == d+4-1)
								{
%>
											<td id="linebottom" width="20%" height="20" class="<%=fontStyle%>">
<%
								}
								else
								{
%>
											<td id="linebottomright" width="20%" height="20" class="<%=fontStyle%>">
<%
								}
%>
												&nbsp;<%=system%>
											</td>
<%
							}
							else
							{
								if (e == d+4-1)
								{
%>
											<td id="linebottom" width="20%" height="20">
<%
								}
								else
								{
%>
											<td id="linebottomright" width="20%" height="20">
<%
								}
%>
												&nbsp;
											</td>
<%
							}
						}
%>
										<!--</tr>-->
<%
					}
%>
									<!--</table>
								</td>-->
							</tr>
<%
				}
%>
						</table></td></tr>
						</table>
<%
			}
		}
%>
					</td>
				</tr>
			</table>
		</td>
	<tr>
<%
	}
	else if (printType!=null && printType.equalsIgnoreCase("ProcessorFamily"))
	{
		TreeMap tmapSystemDetails = null;
		String processorFamily = null;
		String pfChartColor = null;
		if (requestFrom != null && requestFrom.equals("Schedule"))
		{
			tmapSystemDetails = (TreeMap)request.getAttribute("ProcessorSystemDetails");
			processorFamily = (String)request.getAttribute("processorFamily");
			pfChartColor = (String)request.getAttribute("pfChartColor");
		}
		else
		{
			tmapSystemDetails = (TreeMap)session.getAttribute("ProcessorSystemDetails");
			processorFamily = (String)session.getAttribute("processorFamily");
			pfChartColor = (String)session.getAttribute("pfChartColor");
		}
%>
	<tr>
		<td align="center">
			<table border="0" align="center" width="100%" class="body_text">
				<tr>
					<td align="center">
<%
		if (tmapSystemDetails != null)
		{
			StringBuffer strBuffer1 = new StringBuffer();
			StringBuffer strBuffer2 = new StringBuffer();
			String titleName = "";
			String family = "";
			String systemcount = "";

			if (processorFamily.equalsIgnoreCase("All"))
			{
				int maxCount = 0;
				Iterator family_keys = tmapSystemDetails.keySet().iterator();
				while (family_keys.hasNext())
				{
					String key_family = (String)family_keys.next();
					strBuffer1.append(key_family+",");
			
					ArrayList aList = (ArrayList)tmapSystemDetails.get(key_family);
					int count = aList.size()/2;

					maxCount = Math.max(maxCount,count);
					strBuffer2.append(count+",");
				}

				family = strBuffer1.substring(0,strBuffer1.length()-1);
				systemcount = strBuffer2.substring(0,strBuffer2.length()-1);
				titleName = mappingInfo.getTextDescription("configmgmt.inventory.system.Distribution of Systems By Processor Family");
%>
						<table border="0" width="100%" cellspacing="0" cellpadding="0" class="body_text">
							<tr align="center">
								<td width="100%" align="center">
									<img src="../servlet/com.eg.EcChartController?view=GRAPH&pageName=PROCESSOR_FAMILY&chartColor=<%=pfChartColor%>&chartType=bar&height=250&width=650&chartTitle=<%=EgURLEncoder.encode(titleName,"UTF-8")%>&sampleValues=<%=systemcount%>&barLabels=<%=EgURLEncoder.encode(EgUIUtils.encodeSecurityChar(family),"UTF-8")%>&range=<%=maxCount%>&barAlignment=horizontal&rangeAxisLabelAngle=270&userName=<%=EgURLEncoder.encode(ec_userName,"UTF-8")%>" border="0" hspace="0">
								</td>
							</tr>
						</table>

						<table border="0" cellspacing="0" cellpadding="0" width="100%"><tr><td height="0"><img src="/final/config/images/spacer.gif" border="0" height="10"></td></tr></table>
<%
				family_keys = tmapSystemDetails.keySet().iterator();
				while (family_keys.hasNext())
				{
					String key_family = (String)family_keys.next();
					ArrayList aList = (ArrayList)tmapSystemDetails.get(key_family);
					ArrayList aListComponents = new ArrayList();
					for (int i=0; i<aList.size();i=i+2)
						aListComponents.add(aList.get(i));
%>
						<table width="100%" border="0" cellpadding="0" cellspacing="0" class="body_text" id="bottomtable" style="border-bottom-width:0px">
							<tr>
								<td height="20" id="linebottom" class="<%=fontStyle%>">
									&nbsp;<b><%=key_family%>&nbsp;&nbsp;(<egui:intnl text="configmgmt.inventory.system.Count" /> : <%=aListComponents.size()%>)</b>
								</td>
							</tr>
							<tr>
								<td align="left" width="100%">
									<table border="0" width="100%" cellspacing="0" cellpadding="0" class="body_text">
<%
					for (int d=0; d<aListComponents.size(); d=d+3)
					{
%>
										<tr>
<%
						for (int e=d; e<d+3; e++)
						{
							if (e<aListComponents.size())
							{
								String system = (String)aListComponents.get(e);
								if (e == d+3-1)
								{
%>
											<td id="linebottom" height="20" width="20%" class="<%=fontStyle%>">
<%
								}
								else
								{
%>
											<td id="linebottomright" height="20" width="20%" class="<%=fontStyle%>">
<%
								}
%>
												&nbsp;<%=system%>
											</td>
<%
							}
							else
							{
								if (e == d+3-1)
								{
%>
											<td id="linebottom" height="20" width="20%">
<%
								}
								else
								{
%>
											<td id="linebottomright" height="20" width="20%">
<%
								}
%>
												&nbsp;
											</td>
<%
							}
						}
%>
										</tr>
<%
					}
%>
									</table>
								</td>
							</tr>
						</table>

						<table border="0" cellspacing="0" cellpadding="0" width="100%"><tr><td height="0"><img src="/final/config/images/spacer.gif" border="0" height="20"></td></tr></table>
<%
				}
			}
			else
			{
				ArrayList aList = (ArrayList)tmapSystemDetails.get(processorFamily);
				int count = aList.size()/2;
%>
						<table border="0" width="100%" cellspacing="0" cellpadding="0" class="body_text" id="bottomtable" style="border-bottom-width:0px" >
							<tr>
								<td height="20" id="linebottom" colspan="4" class="<%=fontStyle%>">
									&nbsp;<b><%=processorFamily%>&nbsp;&nbsp;(<egui:intnl text="configmgmt.inventory.system.Count" /> : <%=count%>)</b>
								</td>
							</tr>
<%
				int countColumn = 0;
				for (int i=0; i<aList.size(); i=i+2)
				{
					if(countColumn == 3) countColumn = 0;
					if(countColumn == 0)
					{
%>
							<tr>
<%
					}
					if(countColumn == 2)
					{
%>
								<td align="left" height="20" width="20%" id="linebottom" class="<%=fontStyle%>">
<%
					}
					else
					{
%>
								<td align="left" height="20" width="20%" id="linebottomright" class="<%=fontStyle%>">
<%
					}
%>
								&nbsp;<%=aList.get(i)%>&nbsp;(<%=aList.get(i+1)%>)
								</td>
<%
					if(countColumn == 3)
					{
%>
							</tr>
<%
					}

					countColumn++;
					while(countColumn < 3 && i == aList.size() - 2)
					{
						if(countColumn == 2)
						{
%>
								<td align="left" height="20" width="20%" id="linebottom">
<%
						}
						else
						{
%>
								<td align="left" height="20" width="20%" id="linebottomright">
<%
						}
%>
									&nbsp;
								</td>
<%
						countColumn++;
					}
				}
%>
						</table>
<%
			}
		}
%>
					</td>
				</tr>
			</table>
		</td>
	<tr>
<%
	}
	else if (printType!=null && printType.equalsIgnoreCase("PrinterInfo"))
	{
		EcPrintData printData = null;
		if (requestFrom != null && requestFrom.equals("Schedule"))
		{
			printData=(EcPrintData)request.getAttribute("PrinterInfo");
		}
		else
		{
			printData=(EcPrintData)session.getAttribute("PrinterInfo");
		}
		String choice=printData.getSearchCriteria();
		String printerDefault=printData.getPrinterName();
		String searchValue=printData.getSearchValue();
		String showOutput=printData.getShowCount();
		Map data=(Hashtable)printData.getMapData();
		List contentList=printData.getListData();
%>
	<tr>
		<td align="center">
			<table width="100%" border="0" cellpadding="0" cellspacing="0">
				<tr>
					<td height="20" align="center" class="body_text <%=fontStyle%>">
<%
		if (contentList != null && !contentList.isEmpty())
		{
			if (choice!=null && choice.equalsIgnoreCase("Printer"))
			{
				if (printerDefault!=null && printerDefault.equalsIgnoreCase("True"))
				{
					if(searchValue!=null && !searchValue.equals(""))
					{
						out.println("<b>"+mappingInfo.getTextDescription("configmgmt.inventory.printers.Default Printers containing the string")+" \""+searchValue+"\"</b>");
					}
					else
					{
						out.println("<b>"+mappingInfo.getTextDescription("configmgmt.inventory.printers.The systems attached with the default printers")+"</b>");
					}
				}
				else
				{
					if (searchValue!=null && !searchValue.equals(""))
					{
						out.println("<b>"+mappingInfo.getTextDescription("configmgmt.inventory.printers.Printer containing the string")+" \""+searchValue+"\"</b>");
					}
					else
					{
						if(showOutput.equalsIgnoreCase("byPrinter"))
							out.println("<b>"+mappingInfo.getTextDescription("configmgmt.inventory.printers.A Printer-wise list of systems")+"</b>");
						else
							out.println("<b>"+mappingInfo.getTextDescription("configmgmt.inventory.printers.A System-wise list of printers")+"</b>");
					}
				}
			}
			else
			{
				if (printerDefault!=null && printerDefault.equalsIgnoreCase("True"))
				{
					if (searchValue!=null && !searchValue.equals(""))
					{
						out.println("<b>"+mappingInfo.getTextDescription("configmgmt.inventory.printers.The default printer attached systems containing the string")+" \""+searchValue+"\"</b>");
					}
					else
					{
						out.println("<b>"+mappingInfo.getTextDescription("configmgmt.inventory.printers.The default printer attached systems")+"</b>");
					}
				}
				else
				{
					if (searchValue!=null && !searchValue.equals(""))
					{
						out.println("<b>"+mappingInfo.getTextDescription("configmgmt.inventory.printers.Systems containing")+" \""+searchValue+"\" "+mappingInfo.getTextDescription("configmgmt.inventory.printers.with configured printers")+"</b>");
					}
					else
					{
						if(showOutput.equalsIgnoreCase("bySystem"))
							out.println("<b>"+mappingInfo.getTextDescription("configmgmt.inventory.printers.A system-wise list of printers")+"</b>");
						else
							out.println("<b>"+mappingInfo.getTextDescription("configmgmt.inventory.printers.A printer-wise list of systems")+"</b>");
					}
				}
			}
%>
					</td>
				</tr>
				
				<tr><td><table border="0" cellspacing="0" cellpadding="0" width="100%"><tr><td height="0"><img src="/final/config/images/spacer.gif" border="0" height="10"></td></tr></table></td></tr>
				
				<tr>
					<td width="100%" align="center">
						<table border="0" cellspacing="0" cellpadding="0" width="100%" class="body_text">
							<tr>
								<td align="right" class="<%=fontStyle%>">
									<img width="13px" height="12px" src="../config/images/default_printer.gif" border="0">&nbsp;<egui:intnl text="configmgmt.inventory.printers.Default Printer" />&nbsp;&nbsp;
								</td>
							</tr>
						</table>
					</td>
				</tr>
				
				<tr><td><table border="0" cellspacing="0" cellpadding="0" width="100%"><tr><td height="0"><img src="/final/config/images/spacer.gif" border="0" height="5"></td></tr></table></td></tr>

				<tr>
					<td width="100%" align="center">
<%
			if (showOutput!=null && showOutput.equalsIgnoreCase("byPrinter"))
			{
				for(int n=0;n<contentList.size();n++)
				{
					String name=(String)contentList.get(n);
					Hashtable systemList=(Hashtable)data.get(name);
					if(systemList==null || systemList.size()==0)
						continue;
					Object[] kSet=systemList.keySet().toArray();
%>
						<table width="99%" border="0" cellpadding="0" cellspacing="0" class="body_text" align="center" id="bottomtable" style="border-bottom-width:0px">
							<tr>
								<td width="100%" height="20" id="linebottom" class="<%=fontStyle%>">
									&nbsp;<b><%=name.substring(1)%>&nbsp;<egui:intnl text="configmgmt.inventory.printers.Printer" />&nbsp;&nbsp;(<egui:intnl text="configmgmt.inventory.printers.Count" />&nbsp;:&nbsp;<%=systemList.size()%>)</b>
								</td>
							</tr>

							<tr>
								<td width="100%" align="center">
									<table width="100%" border="0" cellpadding="0" cellspacing="0" class="body_text">
<%
					int count = kSet.length;
					int j=0;
					if (count <=3)
					{
						count = 3;
					}
					else if(count % 3 != 0)
					{
						count = count +3- count % 3;
					}
						
					for (j=0; (j<kSet.length || j < count); j++)
					{
						if (j%3 == 0)
						{
%>
										<tr>
<%
						}
						if ( j <kSet.length)
						{
							String systemName=(String)kSet[j];
							ArrayList valueList=(ArrayList)systemList.get(systemName);
							String type=(String)valueList.get(0);
							String defalt=(String)valueList.get(1);
							if((j+1)%3==0)
							{
%>
							
											<td width="30%" height="20" id="linebottom" class="<%=fontStyle%>">
												&nbsp;<%=systemName%>&nbsp;(<%=type%>)
<%
							}
							else
							{
%>
											<td width="30%" height="20" id="linebottomright" class="<%=fontStyle%>">
												&nbsp;<%=systemName%>&nbsp;(<%=type%>)
<%
							}
							if(defalt.equalsIgnoreCase("True"))
							{
%>
												<img src="../config/images/default_printer.gif" alt='<egui:intnl text="configmgmt.inventory.printers.Default Printer" />'>
<%
							}
%>
											</td>
<%						}
						else
						{
							if((j+1)%3==0)
							{
%>
											<td width="30%" id="linebottom">&nbsp;</td>
<%
							}
							else
							{
%>
											<td width="30%" id="linebottomright">&nbsp;</td>
<%
							}
						}
						if (j%3 == 2)
						{
%>
										</tr>
<%
						}
					}
%>
									</table>
								</td>
							</tr>
						</table>

						<table border="0" cellspacing="0" cellpadding="0" width="100%"><tr><td height="0"><img src="/final/config/images/spacer.gif" border="0" height="20"></td></tr></table>
<%
				}
			}
			else
			{
%>
						<table width="99%" border="0" cellpadding="0" cellspacing="0" class="body_text" align="center" id="bottomtable" style="border-bottom-width:0px">
							<tr>
								<td width="25%" height="20" align="left" class="body_text <%=fontStyle%>" id="linebottomright">
									&nbsp;<b><egui:intnl text="configmgmt.inventory.printers.System Name" /></b>
								</td>
								<td width="75%" height="20" align="center" class="body_text <%=fontStyle%>" id="linebottom">
									<b><egui:intnl text="configmgmt.inventory.printers.Configured Printers" /></b>
								</td>
							</tr>
<%
					for(int n=0;n<contentList.size();n++)
					{
						String systemName=(String)contentList.get(n);
						Hashtable printerList=(Hashtable)data.get(systemName);
						Object[] kSet=printerList.keySet().toArray();
%>
							<tr>
								<td width="25%" height="20" id="linebottomright" valign="top" style="padding:4px" class="<%=fontStyle%>">
									<%=systemName%>
								</td>
								<td width="75%" id="linebottom" height="20">
									<table width="100%" border="0" cellpadding="0" cellspacing="0" class="body_text" height="20">
<%
						int count = kSet.length;
						int j=0;
						for (j=0;j<count;j++)
						{
%>
										<tr>
<%
							String printer=(String)kSet[j];
							ArrayList valueList=(ArrayList)printerList.get(printer);
							String type=(String)valueList.get(0);
							String defalt=(String)valueList.get(1);

							if (j < count-1)
							{
%>
											<td width="50%" id="linebottom" style="padding:4px" class="<%=fontStyle%>"><%=printer.substring(1)%>&nbsp;(<%=type%>)

<%
							}
							else
							{
%>
											<td width="50%" id="line" style="padding:4px" class="<%=fontStyle%>"><%=printer.substring(1)%>&nbsp;(<%=type%>)

<%
							}
							if(defalt.equalsIgnoreCase("True"))
							{
%>
												<img src="../config/images/default_printer.gif" alt='<egui:intnl text="configmgmt.inventory.printers.Default Printer" />'>
<%
							}
%>
											</td>
										</tr>
<%
						}
%>
									</table>
								</td>
							</tr>
<%
					}
%>
						</table>
						<table border="0" cellspacing="0" cellpadding="0" width="100%"><tr><td height="0"><img src="/final/config/images/spacer.gif" border="0" height="20"></td></tr></table>
<%
				}
%>
					</td>
				</tr>
			</table>
		</td>
	</tr>
<%
		}
		else
		{
%>
			<tr>
				<td align="center">
					<table border="0" cellspacing="0" cellpadding="0" width="100%"><tr><td height="0"><img src="/final/config/images/spacer.gif" border="0" height="50"></td></tr></table>
				</td>
				</tr>
				<tr>
					<td align="center">
							<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" height="100%" valign="top">
								<tr>
									<td width="100%" height="100%">
										<table border="0" align="center" width="100%" class="body_text" cellspacing="0" cellpadding="0" height="100%">
											<tr>
												<td align="center" height="100%">
													<table border="0" align="center" width="100%" height="100%" cellspacing="0" cellpadding="0">
														<tr>
															<td align="center">
																<table border="0" align="center" width="100%" class="body_text" cellspacing="0" cellpadding="0">
																	<tr>
																		<td align="center"><img src="/final/config/images/unavailable-data.gif"></td>
																	</tr>
																	<tr>
																		<td align="center" class="<%=fontStyle%>"><b><%=mappingInfo.getTextDescription("configmgmt.common.No data found")%></b></td>
																	</tr>
																</table>
															</td>
														</tr>
													</table>
												</td>
											</tr>
										</table>
									</td>
								</tr>
							</table>
						</td>
					</tr>
<%
		}
	}
	else if(printType!=null && printType.equalsIgnoreCase("RAMCapacity_Audit"))
	{
		EcPrintData printData = null;
		if (requestFrom != null && requestFrom.equals("Schedule"))
		{
			printData = (EcPrintData)request.getAttribute("RAMCapacityAudit");
		}
		else
		{
			printData=(EcPrintData)session.getAttribute("RAMCapacityAudit");//EcPrintData object
		}
		Map capacityData=(Hashtable)printData.getMapData();
		String startRange=printData.getStartRange();
		String endRange=printData.getEndRange();
		String rangeOption=printData.getRangeOption();
		Map systemCapacity=(TreeMap)printData.getSystemData();
		Map systemOSName=(TreeMap)printData.getSystemOsData();
		List distribution=(ArrayList)printData.getListData();
		Vector capacityLabel=printData.getCapacityLabel();
		Vector capacityDisplay=printData.getCapacityDisplay();
		String chartColor = printData.getSampleColor();
%>
	<tr>
		<td align="center">
			<table width="100%" border="0" cellpadding="0" cellspacing="0">
<%
		if("BETWEEN".equalsIgnoreCase(rangeOption))
		{
			String titleName=mappingInfo.getTextDescription("configmgmt.inventory.system.Distribution of Systems By RAM Size");
			String sampleValues=printData.getSampleValue();
			//To Check if the chart is empty for schedules
			StringTokenizer st = new StringTokenizer(sampleValues,",");
			while (st.hasMoreTokens())
			{
				String aValue = (String) st.nextToken();
				if (aValue.equals("0"))
				{
					isBlank = true;
					continue;
				}
				else
				{
					isBlank = false;
					break;
				}
			}
			String barLabels=printData.getBarLabel();
			String barLabelAngle=printData.getSampleAxisLabel();
			String maxCount=printData.getMaxRange();
			if (!isBlank)
			{
%>
				<tr><td height="0"><img src="/final/config/images/spacer.gif" border="0" height="10"></td></tr>
				<tr align="center">
					<td width="100%" align="center">
						<img src="../servlet/com.eg.EcChartController?view=GRAPH&pageName=RAM_CAPACITY_DISTRIBUTION&chartColor=<%=chartColor%>&chartType=bar&height=290&width=550&chartTitle=<%=EgURLEncoder.encode(titleName,"UTF-8")%>&sampleValues=<%=EgURLEncoder.encode(sampleValues,"UTF-8")%>&barLabels=<%=EgURLEncoder.encode(barLabels,"UTF-8")%>&barLabelAngle=<%=barLabelAngle%>&range=<%=maxCount%>&userName=<%=EgURLEncoder.encode(ec_userName,"UTF-8")%>" border="0" hspace="0" alt="RAM Distribution details">
					</td>
				</tr>
<%
			}
		}
%>
				<tr><td><table border="0" cellspacing="0" cellpadding="0" width="100%"><tr><td height="0"><img src="/final/config/images/spacer.gif" border="0" height="15"></td></tr></table></td></tr>
				<tr align="center">
					<td width="100%" align="center">
<%
		for(int n=0;n<distribution.size();n++)
		{
			Hashtable osMap=new Hashtable();
			int n1=capacityLabel.indexOf(startRange);
			int n2 = 0;
			String startLabel = null;
			String endLabel = null;
			StringTokenizer st = null;

			String _capacityName=(String)distribution.get(n);
			ArrayList _systemList=(ArrayList)capacityData.get(_capacityName);

			if(capacityData.get(_capacityName)==null || _systemList==null)
			{
				isDataBlank = true;
				continue;
			}

			Collections.sort(_systemList);

			if("BETWEEN".equalsIgnoreCase(rangeOption))
			{
				st=new StringTokenizer(_capacityName,"-");
				startLabel=st.nextToken();
				endLabel=st.nextToken();
				n1=capacityLabel.indexOf(startLabel);
				n2=capacityLabel.indexOf(endLabel);
			}

			String title = null;//  variable to display purpose.
			String range = null;
			if("LESSTHAN".equalsIgnoreCase(rangeOption))
			{
				title = mappingInfo.getTextDescription("configmgmt.inventory.system.Less Than");
			}
			else if("LESSTHAN_OR_EQUAL".equalsIgnoreCase(rangeOption))
			{
				title =  mappingInfo.getTextDescription("configmgmt.inventory.system.Less Than Or Equal To");
			}
			else if("GREATERTHAN".equalsIgnoreCase(rangeOption))
			{
				title =  mappingInfo.getTextDescription("configmgmt.inventory.system.Greater Than");
			}
			else if("GREATERTHAN_OR_EQUAL".equalsIgnoreCase(rangeOption))
			{
				title = mappingInfo.getTextDescription("configmgmt.inventory.system.Greater Than Or Equal To");
			}
			else if("BETWEEN".equalsIgnoreCase(rangeOption))
			{
				title = "";
				range = " - "+capacityDisplay.get(n2).toString();
			}

			for(int i=0;i<_systemList.size();i++)
			{
				String _systemName = (String)_systemList.get(i);
				String systemOsName=(String)systemOSName.get(_systemName);
				ArrayList tempSystemList=new ArrayList();
				if(osMap!=null && osMap.containsKey(systemOsName))
				{
					tempSystemList=(ArrayList)osMap.get(systemOsName);
					tempSystemList.add(_systemName);
					osMap.put(systemOsName,tempSystemList);
				}
				else
				{
					tempSystemList.add(_systemName);
					osMap.put(systemOsName,tempSystemList);
				}
			}// for loop

			if("BETWEEN".equalsIgnoreCase(rangeOption))
			{
%>
						<table width="99%" border="0" cellpadding="0" cellspacing="0" class="body_text" style="border-bottom-width:0px">
<%
			}
			else
			{
%>
						<table width="100%" border="0" cellpadding="0" cellspacing="0" class="body_text" style="border-bottom-width:0px">
<%
			}
%>
							<tr>
								<td colspan="3" id="linebottom" height="20" class="<%=fontStyle%>">
									<b>
										&nbsp;<%=title != null ? title+"&nbsp;" : ""%> <%=capacityDisplay.get(n1)%> <%=range != null ? range : ""%>&nbsp;<egui:intnl text="configmgmt.inventory.system.RAM" /> (<egui:intnl text="configmgmt.inventory.system.Count" /> : <%=_systemList.size()%>)
									</b>
								</td>
							</tr>
							<tr>
								<td width="100%">
									<table border="0" width="100%" cellspacing="0" cellpadding="3" class="bottomtable" style="border-top-width:0px;border-bottom-width:0px;">
<%
			Enumeration keySet = osMap.keys();
			//loop based on OS
			while(keySet.hasMoreElements())
			{
				String osName = (String) keySet.nextElement();
				ArrayList systemListByOS = (ArrayList)osMap.get(osName);
				int systemCountByOS = systemListByOS.size();
%>
							<TR>
								<td height="20" width="50%" align="left" class="<%=fontStyle%>" id="linebottom" colspan="3">
									<b>&nbsp;<%=osName%>&nbsp;(<egui:intnl text="configmgmt.inventory.system.Count" /> : <%=systemCountByOS%>)</b>
								</TD>
							</TR>
<%
				int countColumn = 0;
				for(int s=0;s<systemListByOS.size();s++)
				{
					String _systemName=(String)systemListByOS.get(s);
					if(countColumn == 3) countColumn = 0;
					if(countColumn == 0)
					{
%>
							<tr>
<%
					}
					String colorId="";
					if((s+1)%3==0)
						colorId="linebottom";
					else
						colorId="linebottomright";
%>
								<td align="left" height="18" width="20%" id="<%=colorId%>" class="<%=fontStyle%>">&nbsp;<%=_systemName%>&nbsp;(<%=(String)systemCapacity.get(_systemName)%>)
								</td>
<%
					if(countColumn == 3)
					{
%>
							</tr>
<%
					}

					countColumn++;
					while(countColumn < 3 && s == systemListByOS.size()-1)
					{
						if(countColumn == 2)
						{
%>
								<td align="left" height="18" width="20%" id="linebottom">&nbsp;</td>
<%
						}
						else
						{
%>
								<td align="left" height="18" width="20%" id="<%=colorId%>">&nbsp;</td>
<%
						}
						countColumn++;
					}// End of while loop for countColumn
				}
%>
							</tr>
<%
			}// End of while for keySet
%>
									</table>
								</td>
							</tr>
						</table>
						<br>
<%
		}
%>
<%
		if (isBlank && isDataBlank)
		{
%>
				<tr>
					<td align="center">
						<table border="0" cellspacing="0" cellpadding="0" width="100%"><tr><td height="0"><img src="/final/config/images/spacer.gif" border="0" height="50"></td></tr></table>
					</td>
				</tr>
				<tr>
					<td align="center">
						<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" height="100%" valign="top">
							<tr>
								<td width="100%" height="100%">
									<table border="0" align="center" width="100%" class="body_text" cellspacing="0" cellpadding="0" height="100%">
										<tr>
											<td align="center" height="100%">
												<table border="0" align="center" width="100%" height="100%" cellspacing="0" cellpadding="0">
													<tr>
														<td align="center">
															<table border="0" align="center" width="100%" class="body_text" cellspacing="0" cellpadding="0">
																<tr>
																	<td align="center"><img src="/final/config/images/unavailable-data.gif"></td>
																</tr>
																<tr>
																	<td align="center" class="<%=fontStyle%>"><b><%=mappingInfo.getTextDescription("configmgmt.common.No data found")%></b></td>
																</tr>
															</table>
														</td>
													</tr>
												</table>
											</td>
										</tr>
									</table>
								</td>
							</tr>
						</table>
					</td>
				</tr>
<%
		}
%>
					</td>
				</tr>
			</table>
		</td>
	</tr>
<%
	}
	else if(printType!=null && printType.equalsIgnoreCase("HardDisk_Audit"))
	{
		EcPrintData printData = null;
		if (requestFrom != null && requestFrom.equals("Schedule"))
		{
			printData = (EcPrintData)request.getAttribute("DiskCapacityAudit");
		}
		else
		{
			printData=(EcPrintData)session.getAttribute("DiskCapacityAudit");//EcPrintData object
		}
		Map capacityData=(Hashtable)printData.getMapData();
		String startRange=printData.getStartRange();
		String endRange=printData.getEndRange();
		String rangeOption=printData.getRangeOption();
		Map systemCapacity=(TreeMap)printData.getSystemData();
		Map systemOSName=(TreeMap)printData.getSystemOsData();
		List distribution=(ArrayList)printData.getListData();
		Vector capacityLabel=printData.getCapacityLabel();
		Vector capacityDisplay=printData.getCapacityDisplay();
		String chartColor = printData.getSampleColor();
%>
	<tr>
		<td align="center">
			<table width="100%" border="0" cellpadding="0" cellspacing="0">
<%
		if("BETWEEN".equalsIgnoreCase(rangeOption))
		{
			String titleName="Distribution of Systems By Hard Disk Capacity";
			titleName = mappingInfo.getTextDescription("configmgmt.inventory.system."+titleName);
			String sampleValues=printData.getSampleValue();
			//To Check if the chart is empty for schedules
			StringTokenizer st = new StringTokenizer(sampleValues,",");
			while (st.hasMoreTokens())
			{
				String aValue = (String) st.nextToken();
				if (aValue.equals("0"))
				{
					isBlank = true;
					continue;
				}
				else
				{
					isBlank = false;
					break;
				}
			}
			String barLabels=printData.getBarLabel();
			String barLabelAngle=printData.getSampleAxisLabel();
			String maxCount=printData.getMaxRange();
			if (!isBlank)
			{
%>
				<tr><td height="0"><img src="/final/config/images/spacer.gif" border="0" height="10"></td></tr>
				<tr align="center">
					<td width="100%" align="center">
						<img src="../servlet/com.eg.EcChartController?view=GRAPH&pageName=HARDDISK_CAPACITY_DISTRIBUTION&chartColor=<%=chartColor%>&chartType=bar&height=290&width=550&chartTitle=<%=EgURLEncoder.encode(titleName,"UTF-8")%>&sampleValues=<%=EgURLEncoder.encode(sampleValues,"UTF-8")%>&barLabels=<%=EgURLEncoder.encode(barLabels,"UTF-8")%>&barLabelAngle=<%=EgURLEncoder.encode(barLabelAngle,"UTF-8")%>&range=<%=maxCount%>&userName=<%=EgURLEncoder.encode(ec_userName,"UTF-8")%>" border="0" hspace="0">
					</td>
				</tr>
<%
			}
		}
%>
				<tr><td><table border="0" cellspacing="0" cellpadding="0" width="100%"><tr><td height="0"><img src="/final/config/images/spacer.gif" border="0" height="15"></td></tr></table></td></tr>
				<tr align="center">
					<td width="100%" align="center">
<%
		for(int n=0;n<distribution.size();n++)
		{
			Hashtable osMap=new Hashtable();
			int n1=capacityLabel.indexOf(startRange);
			int n2 = 0;
			String startLabel = null;
			String endLabel = null;
			StringTokenizer st = null;

			String _capacityName=(String)distribution.get(n);
			ArrayList _systemList=(ArrayList)capacityData.get(_capacityName);

			if(capacityData.get(_capacityName)==null || _systemList==null)
			{
				isDataBlank = true;
				continue;
			}

			if (_systemList != null && !_systemList.isEmpty())
			{
				Collections.sort(_systemList);

				if("BETWEEN".equalsIgnoreCase(rangeOption))
				{
					st=new StringTokenizer(_capacityName,"-");
					startLabel=st.nextToken();
					endLabel=st.nextToken();
					n1=capacityLabel.indexOf(startLabel);
					n2=capacityLabel.indexOf(endLabel);
				}

				String title = null;//  variable to display purpose.
				String range = null;
				if("LESSTHAN".equalsIgnoreCase(rangeOption))
				{
					title = " " + mappingInfo.getTextDescription("configmgmt.inventory.system.Less Than") + " ";
				}
				else if ("LESSTHAN_OR_EQUAL".equalsIgnoreCase(rangeOption))
				{
					title = mappingInfo.getTextDescription("configmgmt.inventory.system.Less Than Or Equal To");
				}
				else if("GREATERTHAN".equalsIgnoreCase(rangeOption))
				{
					title = " "+mappingInfo.getTextDescription("configmgmt.inventory.system.Greater Than") + " ";
				}
				else if("GREATERTHAN_OR_EQUAL".equalsIgnoreCase(rangeOption))
				{
					title = mappingInfo.getTextDescription("configmgmt.inventory.system.Greater Than Or Equal To");
				}
				else if("BETWEEN".equalsIgnoreCase(rangeOption))
				{
					title = "";
					range = " - "+capacityDisplay.get(n2).toString();
				}

				for(int i=0;i<_systemList.size();i++)
				{
					String _systemName = (String)_systemList.get(i);
					String systemOsName=(String)systemOSName.get(_systemName);
					ArrayList tempSystemList=new ArrayList();
					if(osMap!=null && osMap.containsKey(systemOsName))
					{
						tempSystemList=(ArrayList)osMap.get(systemOsName);
						tempSystemList.add(_systemName);
						osMap.put(systemOsName,tempSystemList);
					}
					else
					{
						tempSystemList.add(_systemName);
						osMap.put(systemOsName,tempSystemList);
					}
				}// for loop

				if("BETWEEN".equalsIgnoreCase(rangeOption))
				{
%>
						<table width="98%" border="0" cellpadding="0" cellspacing="0" class="body_text" style="border-bottom-width:0px">
<%
				}
				else
				{
%>
						<table width="98%" border="0" cellpadding="0" cellspacing="0" class="body_text" style="border-bottom-width:0px">
<%
				}
%>
							<tr>
								<td colspan="3" id="linebottom" height="20" class="<%=fontStyle%>">
									<b>&nbsp;<%=title != null ? title : ""%> <%=capacityDisplay.get(n1)%> <%=range != null ? range : ""%>&nbsp;<egui:intnl text="configmgmt.inventory.system.Hard Disk" /> (<egui:intnl text="configmgmt.inventory.system.Count" /> : <%=_systemList.size()%>)</b>
								</td>
							</tr>
							<tr>
								<td width="100%">
									<table border="0" width="100%" cellspacing="0" cellpadding="3" class="bottomtable" style="border-top-width:0px;border-bottom-width:0px;">
					
<%
				Enumeration keySet = osMap.keys();
				int j=0;
				//loop based on OS
				while(keySet.hasMoreElements())
				{
					String osName = (String) keySet.nextElement();
					ArrayList systemListByOS = (ArrayList)osMap.get(osName);
					int systemCountByOS = systemListByOS.size();
%>
							<TR>
								<td height="20" width="30%" align="left" class="<%=fontStyle%>" id="linebottom" colspan="3">
									<b>&nbsp;<%=osName%>&nbsp;(<egui:intnl text="configmgmt.inventory.system.Count" /> : <%=systemCountByOS%>)</b>
								</TD>
							</TR>
<%
					int countColumn = 0;
					int systemSize = _systemList.size();
					for(int s=0;s<systemListByOS.size();s++)
					{
						String _systemName=(String)systemListByOS.get(s);
						if(countColumn == 3) countColumn = 0;
						if(countColumn == 0)
						{
%>
							<tr>
<%
						}
						String colorId="";
						if((s+1)%3==0)
							colorId="linebottom";
						else
							colorId="linebottomright";
%>
								<td align="left" height="20" width="20%" id="<%=colorId%>" class="<%=fontStyle%>">&nbsp;<%=_systemName%>&nbsp;(<%=(String)systemCapacity.get(_systemName)%>&nbsp;GB)</td>
<%
						if(countColumn == 3)
						{
%>
							</tr>
<%
						}

						countColumn++;
						while(countColumn < 3 && s == systemListByOS.size()-1)
						{
							if(countColumn == 2)
							{
%>
								<td align="left" height="20" width="20%" id="linebottom">&nbsp;</td>
<%
							}
							else
							{
%>
								<td align="left" height="20" width="20%" id="<%=colorId%>">&nbsp;</td>
<%
							}
							countColumn++;
						}// End of while loop
					}
				}
%>
				
									</table>
								</td>
							</tr>
<%
			}
%>
						</table>
						<br><br>
<%
		}
%>
<%
		if (isBlank && isDataBlank)
		{
%>
				<tr>
					<td align="center">
						<table border="0" cellspacing="0" cellpadding="0" width="100%"><tr><td height="0"><img src="/final/config/images/spacer.gif" border="0" height="50"></td></tr></table>
					</td>
				</tr>
				<tr>
					<td align="center">
						<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" height="100%" valign="top">
							<tr>
								<td width="100%" height="100%">
									<table border="0" align="center" width="100%" class="body_text" cellspacing="0" cellpadding="0" height="100%">
										<tr>
											<td align="center" height="100%">
												<table border="0" align="center" width="100%" height="100%" cellspacing="0" cellpadding="0">
													<tr>
														<td align="center">
															<table border="0" align="center" width="100%" class="body_text" cellspacing="0" cellpadding="0">
																<tr>
																	<td align="center"><img src="/final/config/images/unavailable-data.gif"></td>
																</tr>
																<tr>
																	<td align="center" class="<%=fontStyle%>"><b><%=mappingInfo.getTextDescription("configmgmt.common.No data found")%></b></td>
																</tr>
															</table>
														</td>
													</tr>
												</table>
											</td>
										</tr>
									</table>
								</td>
							</tr>
						</table>
					</td>
				</tr>
<%
		}
%>
					</td>
				</tr>
			</table>
		</td>
	</tr>
<%
	}
	else if(printType!=null && printType.equalsIgnoreCase("IPAddress_Audit"))
	{
		EcPrintData printData = null;
		if (requestFrom != null && requestFrom.equals("Schedule"))
		{
			printData=(EcPrintData)request.getAttribute("IpAddressAudit");
		}
		else
		{
			printData=(EcPrintData)session.getAttribute("IpAddressAudit");
			//EcPrintData object
		}
		String osName=printData.getOsName();
		Map data=(Hashtable)printData.getMapData();
		ArrayList fixedIPAddress=(ArrayList)data.get("NO");
		ArrayList dynamicIPAddress=(ArrayList)data.get("YES");
%>
	<tr>
		<td align="center">
			<table border="0" align="center" width="100%" cellpadding="0" cellspacing="0">
				<tr>
					<td align="center">
<%
		if(osName!=null && osName.equalsIgnoreCase("All"))
		{
			String sampleValue=printData.getSampleValue();
			String barLabels=printData.getBarLabel();
			String maxCount=printData.getMaxRange();
			String chartColor=printData.getSampleColor();
			String chartTitle = mappingInfo.getTextDescription("configmgmt.inventory.system.Distribution of Systems By IP Address Allocation");
%>
						<table border="0" width="100%" cellspacing="0" cellpadding="0" class="body_text">
							<tr align="center">
								<td width="100%" align="center">
									<img src="../servlet/com.eg.EcChartController?view=GRAPH&pageName=IPADDRESS_ALLOCATION&chartColor=<%=chartColor%>&chartType=bar&height=290&width=550&chartTitle=<%=EgURLEncoder.encode(chartTitle,"UTF-8")%>&sampleValues=<%=EgURLEncoder.encode(sampleValue,"UTF-8")%>&barLabels=<%=EgURLEncoder.encode(barLabels,"UTF-8")%>&barLabelAngle=360&range=<%=maxCount%>&userName=<%=EgURLEncoder.encode(ec_userName,"UTF-8")%>" border="0" hspace="0" alt="Ip address details">
								</td>
							</tr>
							<tr>
								<td height="0"><img src="/final/config/images/spacer.gif" border="0" height="10">
								</td>
							</tr>
						</table>
<%
		}
		else
		{
%>
						<table width="100%" border="0" cellpadding="0" cellspacing="0" class="body_text">
							<tr>
								<td height="20" class="<%=fontStyle%>">
									&nbsp;<b><%=osName%>&nbsp;</b>
								</td>
							</tr>
						</table>
<%
		}
%>
						<table width="100%" border="0" cellpadding="0" cellspacing="0" class="body_text">
							<tr><td align="center"><table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" class="body_text"><tr><td height="10"><img src="/final/config/images/spacer.gif" border="0" height="2"></td></tr></table></td></tr>
						</table>
<%
		if(fixedIPAddress!=null && fixedIPAddress.size()>0)
		{
%>
						<table width="100%" border="0" cellpadding="0" cellspacing="0" class="body_text">
							<tr>
<%
			if(osName!=null && osName.equalsIgnoreCase("All"))
			{
%>
								<td height="20" width="100%" class="<%=fontStyle%>">&nbsp;<b><egui:intnl text="configmgmt.inventory.system.Static IP address allocation" />&nbsp;&nbsp;(<egui:intnl text="configmgmt.inventory.system.Count" />&nbsp;:&nbsp;<%=fixedIPAddress.size()%>)</b></td>
<%
			}
			else
			{
%>
								<td height="20" align="left" width="100%" class="<%=fontStyle%>">&nbsp;<b><egui:intnl text="configmgmt.inventory.system.Static IP address allocation" />&nbsp;&nbsp;(<egui:intnl text="configmgmt.inventory.system.Count" />&nbsp;:&nbsp;<%=fixedIPAddress.size()%>)</b></td>
<%
			}
%>
							</tr>
						</table>
<%
			Collections.sort(fixedIPAddress);
			int count = fixedIPAddress.size();
			int j=0;
			if (count <=3)
			{
				count = 3;
			}
			else if(count % 3 != 0)
			{
				count = count+3 - count % 3;
			}
%>
						<table width="100%" border="0" cellpadding="0" cellspacing="0" class="body_text">
							<tr>
								<td align="left" width="100%">
									<table border="0" width="100%" cellspacing="0" cellpadding="0" class="body_text" id="bottomtable" style="border-bottom-width:0px">
<%
			if (fixedIPAddress!= null)
			{
				for (j=0; (j<fixedIPAddress.size() || j < count); j++)
				{
					if (j%3 == 0)
					{
%>
										<tr>
<%
					}
					if ( j <fixedIPAddress.size())
					{
						String systemName=(String)fixedIPAddress.get(j);
						if (j%3 == 2)
						{
%>
											<td id="linebottom" width="30%" height="20" class="<%=fontStyle%>">
												&nbsp;<%=systemName%>
											</td>
<%
						}
						else
						{
%>
											<td id="linebottomright" width="30%" height="20" class="<%=fontStyle%>">
												&nbsp;<%=systemName%>
											</td>
<%
						}
					}
					else
					{
						if (j%3 == 2)
						{
%>
											<td id="linebottom" width="30%" height="20">&nbsp;</td>
<%
						}
						else
						{
%>
											<td id="linebottomright" width="30%" height="20">&nbsp;</td>
<%
						}
					}
					if (j%3 == 2)
					{
%>
										</tr>
<%
					}
				}
			}
%>
									</table>
								</td>
							</tr>
						</table>

						<table width="100%" border="0" cellpadding="0" cellspacing="0" class="body_text">
							<tr><td align="center"><table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" class="body_text"><tr><td height="10"><img src="/final/config/images/spacer.gif" border="0" height="2"></td></tr></table></td></tr>
						</table>
<%
		}

		if(dynamicIPAddress!=null && dynamicIPAddress.size()>0)
		{
%>
						<table width="100%" border="0" cellpadding="0" cellspacing="0" class="body_text">
							<tr>
<%
			if(osName!=null && osName.equalsIgnoreCase("All"))
			{
%>
								<td width="100%" height="20" class="<%=fontStyle%>">&nbsp;<b><egui:intnl text="configmgmt.inventory.system.Dynamic IP address allocation" />&nbsp;&nbsp;(<egui:intnl text="configmgmt.inventory.system.Count" />&nbsp;:&nbsp;<%=dynamicIPAddress.size()%>)</b></td>
<%
			}
			else
			{
%>
								<td align="left" width="100%" height="20" class="<%=fontStyle%>">&nbsp;<b><egui:intnl text="configmgmt.inventory.system.Dynamic IP address allocation" />&nbsp;&nbsp;(<egui:intnl text="configmgmt.inventory.system.Count" />&nbsp;:&nbsp;<%=dynamicIPAddress.size()%>)</b></td>
<%
			}
%>
							</tr>
						</table>
<%
			Collections.sort(dynamicIPAddress);
			int count = dynamicIPAddress.size();
			int j=0;
			if (count <=3)
			{
				count = 3;
			}
			else if(count % 3 != 0)
			{
				count = count +3- count % 3;
			}
%>
						<table width="100%" border="0" cellpadding="0" cellspacing="0" class="body_text">
							<tr>
								<td width="100%">
									<table border="0" width="100%" cellspacing="0" cellpadding="0" class="body_text" id="bottomtable" style="border-bottom-width:0px">
<%
			if (dynamicIPAddress!= null)
			{
				for (j=0; (j<dynamicIPAddress.size() || j < count); j++)
				{
					if (j%3 == 0)
					{
%>
										<tr>
<%
					}
					if (j < dynamicIPAddress.size())
					{
						String systemName=(String)dynamicIPAddress.get(j);
						if (j%3 == 2)
						{
%>
											<td id="linebottom" width="30%" height="20" class="<%=fontStyle%>">
												&nbsp;<%=systemName%>
											</td>
<%
						}
						else
						{
%>
											<td id="linebottomright" width="30%" height="20" class="<%=fontStyle%>">
												&nbsp;<%=systemName%>
											</td>
<%
						}
					}
					else
					{
						if (j%3 == 2)
						{
%>
											<td id="linebottom" width="30%" height="20">&nbsp;</td>
<%
						}
						else
						{
%>
											<td id="linebottomright" width="30%" height="20">&nbsp;</td>
<%
						}
					}
					if (j%3 == 2)
					{
%>
										</tr>
<%
					}
				}
			}
%>
									</table>
								</td>
							</tr>
						</table>
<%
		}
%>
					</td>
				</tr>
			</table>
		</td>
	</tr>
<%
	}
	else if(printType!=null && printType.equalsIgnoreCase("Gateway_Audit"))
	{
		EcPrintData printData = null;
		if (requestFrom != null && requestFrom.equals("Schedule"))
		{
			printData=(EcPrintData)request.getAttribute("defaultGateway_Audit");
		}
		else
		{
			printData=(EcPrintData)session.getAttribute("defaultGateway_Audit");
		}
		Map data=(Hashtable)printData.getMapData();
		ArrayList displayListData=(ArrayList)printData.getListData();
		String ipAddress=printData.getRangeOption();
%>
	<tr>
		<td align="center">
			<table width="100%" border="0" cellpadding="0" cellspacing="0">
				<tr align="center">
					<td width="100%" align="center">
<%
		if(ipAddress!=null && ipAddress.equalsIgnoreCase("All"))
		{
			String sampleValues=printData.getSampleValue();
			String barLabels=printData.getBarLabel();
			String barLabelAngle=printData.getSampleAxisLabel();
			String maxCount=printData.getMaxRange();
			String chartColor=printData.getSampleColor();
			String chartTitle = mappingInfo.getTextDescription("configmgmt.inventory.system.Distribution of Systems By Gateway IP Address");
%>
						<table width="99%" border="0" cellpadding="0" cellspacing="0" class="body_text" align="center">
							<tr><td height="0"><img src="/final/config/images/spacer.gif" border="0" height="10"></td></tr>
							<tr align="center">
								<td width="100%" align="center">
									<img src="../servlet/com.eg.EcChartController?view=GRAPH&pageName=GATEWAY_REPORT&chartColor=<%=chartColor%>&chartType=bar&height=290&width=550&chartTitle=<%=EgURLEncoder.encode(chartTitle,"UTF-8")%>&sampleValues=<%=EgURLEncoder.encode(sampleValues,"UTF-8")%>&barLabels=<%=EgURLEncoder.encode(barLabels,"UTF-8")%>&barLabelAngle=<%=barLabelAngle%>&range=<%=maxCount%>&userName=<%=EgURLEncoder.encode(ec_userName,"UTF-8")%>" border="0" hspace="0" alt="Gateway details">
								</td>
							</tr>
							<tr>
								<td height="0"><img src="/final/config/images/spacer.gif" border="0" height="10">
								</td>
							</tr>
						</table>
<%
		}

		for(int n=0;n<displayListData.size();n++)
		{
			String gatwayIPAddress=(String)displayListData.get(n);
			ArrayList ip=(ArrayList)data.get(gatwayIPAddress);
			if(ip==null || ip.size()==0)
				continue;
%>
						<table width="100%" border="0" cellpadding="0" cellspacing="0" class="body_text">
							<tr>
								<td width="100%" height="20" class="<%=fontStyle%>">&nbsp;<b><egui:intnl text="configmgmt.inventory.system.Gateway" />&nbsp;<%=gatwayIPAddress%>&nbsp;&nbsp;(<egui:intnl text="configmgmt.inventory.system.Count" />&nbsp;:&nbsp;<%=ip.size()%>)</b></td>
							</tr>

<%
			int count = ip.size();
			int j=0;
			if (count <=3)
			{
				count = 3;
			}
			else if(count % 3 != 0)
			{
				count = count+3 - count % 3;
			}
%>
							<tr>
								<td width="100%" height="20">
									<table width="100%" border="0" cellpadding="0" cellspacing="0" class="body_text" id="bottomtable" style="border-bottom-width:0px">
<%
			if (ip!= null)
			{
				for (j=0; (j<ip.size() || j < count); j++)
				{
					if (j%3 == 0)
					{
%>
										<tr>
<%
					}
					if (j < ip.size())
					{
						String systemName=(String)ip.get(j);
						if (j%3 == 2)
						{
%>
											<td id="linebottom" width="30%" height="20" class="<%=fontStyle%>">
												&nbsp;<%=systemName%>
											</td>
<%
						}
						else
						{
%>
											<td id="linebottomright" width="30%" height="20" class="<%=fontStyle%>">
												&nbsp;<%=systemName%>
											</td>
<%
						}
					}
					else
					{
						if (j%3 == 2)
						{
%>
											<td id="linebottom" width="30%" height="20">&nbsp;</td>
<%
						}
						else
						{
%>
											<td id="linebottomright" width="30%" height="20">&nbsp;</td>
<%
						}
					}
					if (j%3 == 2)
					{
%>
										</tr>
<%
					}
				}
			}
%>
									</table>
								</td>
							</tr>
						</table>

						<table width="100%" border="0" cellpadding="0" cellspacing="0" class="body_text">
							<tr><td align="center"><table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" class="body_text"><tr><td height="10"><img src="/final/config/images/spacer.gif" border="0" height="2"></td></tr></table></td></tr>
						</table>
<%
		}
%>
					</td>
				</tr>
			</table>
		</td>
	</tr>
<%
	}
%>
</table>
</form>
</body>
</html>



