<%@ include file = "../../EcTrackerJson.jsp" %>
<%@ page import = "net.sf.json.*"%>
<%@ page errorPage="EcProbs.jsp"%>
<%@ page import = "egurkha.config.EcUtils"%>
<%@ page import = "java.util.*"%>
<%@ page import = "com.egurkha.pdfmaker.*"%>
<%@ page import = "com.egurkha.User"%>
<%@ page import = "com.egurkha.UserRegistry"%>
<%@ page import = "com.egurkha.ini.IniUI"%>
<%@ page import = "com.eg.EgMappingInfo"%>
<%@ page import = "com.eg.EgConfigTestsInfo"%>
<%@ page import = "com.eg.EgSpecsInfo"%>
<%@ page import = "com.eg.EgName"%>
<%@ page import = "com.eg.MappingNameSorter"%>
<%@ page import = "com.eg.EgURLEncoder"%>
<%@ page import = "com.eg.EgConfigInfo"%>
<%@ page import = "java.text.*"%>
<%@ page import = "com.egurkha.EgTimeZoneConverter"%>
<%@ page import = "com.egurkha.util.DateUtil"%>
<%@ page import = "com.eg.EgInstallInfo" %>

<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>

<%!
	String[] criterias = {"Zone","Service","Segment","Component"};
%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>

<%
	JSONObject rootJson = new JSONObject();
	JSONObject hiddenFields = new JSONObject();
	rootJson.put("success","true");

	UserRegistry registry = UserRegistry.getInstance();
	User user = registry.getUser(session.getId());
	IniUI iniUI = IniUI.getInstance();
	String userLanguage = iniUI.getDefaultLanguage();
	if (user != null)
	{
		userLanguage = user.getLanguage();
	}
	EgMappingInfo mappingInfo = new EgMappingInfo(userLanguage);

	EgSpecsInfo specsInfo = new EgSpecsInfo("manager");
	EgConfigTestsInfo configTestsInfo = new EgConfigTestsInfo("manager");
	MappingNameSorter sorter = new MappingNameSorter(userLanguage);
	String configSkin = user.getConfigSkin();

	String heading = "";
	String componentName = null;
	String componentType = null;
	String farmName = null;
	String serverName = null;
	TreeMap tmapCitrixApplicationsAndUsers = null;
	String subTitle = ""; //For PDF
	ArrayList serverList = new ArrayList();

	String uiFile = "eg_ui.ini";
	String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
	IniFile iniFile = new IniFile(s_iniFile_dir + uiFile);
	String currentDateFormat = iniFile.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
	SimpleDateFormat formatter = new SimpleDateFormat(currentDateFormat+" "+"HH:mm:ss");
	Date currentDateTime = new Date();
	String dateString = formatter.format(currentDateTime);

	/* Added by Prakash.K Starts */
	EgTimeZoneConverter timeZoneConverter = new EgTimeZoneConverter(dateString,user);
	dateString = timeZoneConverter.getDateTime();
	/* Added by Prakash.K Ends */

	String ec_comptype = request.getParameter("ec_comptype");
	String ec_component = request.getParameter("ec_component");
	String o_comptype = request.getParameter("old_comptype");

	String strThinClients = configTestsInfo.getServerDisplayValue("MISC_ARGS","ThinClients");
	ArrayList aListThinClients = new ArrayList();
	StringTokenizer stringTokens = new StringTokenizer(strThinClients,",");
	while (stringTokens.hasMoreTokens())
	{
		String token = stringTokens.nextToken();
		aListThinClients.add(token);
	}

	Vector vec_componentTypes = new Vector();
	Vector vec_components = new Vector();
	Vector allcomps = new Vector();

	String ec_criteria = (String)session.getAttribute("ec_criteria");
	String ec_criteriaPrevious = request.getParameter("ec_criteriaPrevious");

	Vector vecCriterias = new Vector();
	for (int g=0;g<criterias.length;g++)
	{
		String criteria = criterias[g];
		vecCriterias.add(criteria);
	}

	Vector vecUserOptions = (Vector)session.getAttribute("vecUserOptions");
	String ec_userOption = (String)session.getAttribute("ec_userOption");
	String ec_userOptionPrevious = request.getParameter("ec_userOptionPrevious");

	ArrayList aListAssociatedComponents = (ArrayList)session.getAttribute("associatedComponents");
	allcomps.addAll(aListAssociatedComponents);

	String request_from = request.getParameter("request_from");
	String submitOrNot = (String) request.getAttribute("isSubmit");
	Map scheduleDetails = (Map) request.getAttribute("ScheduleDetails");
	if (scheduleDetails != null && request_from != null && request_from.equalsIgnoreCase("saveSchedule"))
	{
		ec_criteria = (String)scheduleDetails.get("ec_criteria");
		ec_criteriaPrevious = (String)scheduleDetails.get("ec_criteriaPrevious");
		submitOrNot = "false";
	}

	if (scheduleDetails != null && request_from != null && request_from.equalsIgnoreCase("saveSchedule"))
	{
		vecUserOptions = (Vector) scheduleDetails.get("vecUserOptions");
		ec_comptype = (String) scheduleDetails.get("ec_comptype");
		ec_component = (String) scheduleDetails.get("ec_component");
		o_comptype = (String) scheduleDetails.get("old_comptype");
		ec_userOption = (String) scheduleDetails.get("ec_userOption");
		ec_userOptionPrevious = (String) scheduleDetails.get("ec_userOptionPrevious");
	}

	if (submitOrNot == null || "null".equals(submitOrNot))
	{
		submitOrNot = "true";
	}

	if (request_from != null && request_from.equalsIgnoreCase("saveSchedule"))
	{
		submitOrNot = "false";
	}

	if (!allcomps.isEmpty())
	{
		for (int i=0;i<allcomps.size();i++)
		{
			String str = (String) allcomps.get(i);
			String component_type = str.substring(0,str.indexOf(":"));

			if (!aListThinClients.contains(component_type)) continue;

			boolean isTestEnabled = specsInfo.isConfigTestEnabled(component_type);
			if (!isTestEnabled) continue;

			if (!vec_componentTypes.contains(component_type))
				vec_componentTypes.add(component_type);

			String component_name = str.substring(str.indexOf(":")+1);
			vec_components.add(component_name+":"+component_type);
		}
		Collections.sort(vec_componentTypes);
	}

	if (ec_component != null && !ec_component.equals("-1"))
	{
		componentName = ec_component.substring(0,ec_component.lastIndexOf(":"));
		componentType = ec_component.substring(ec_component.lastIndexOf(":")+1);
		componentType = mappingInfo.getComponentTypeDescription(componentType);
	}

	if (ec_comptype != null)
	{
		if (ec_comptype.equals("Citrix_server"))
		{
			heading = "Server Application Users";
		}
	}

	Vector v_comp = null;
	if (ec_comptype == null || ec_comptype.equals("-1"))
	{
		v_comp = vec_components;
		Collections.sort(v_comp);
		ec_comptype = "-1";
	}
	else
	{
		v_comp = new Vector();
		for (int i=0;i<vec_components.size();i++)
		{
			String s_comp = (String)vec_components.get(i);
			if (ec_comptype != null && s_comp.endsWith(ec_comptype))
			{
				v_comp.add(s_comp);
			}
		}
		Collections.sort(v_comp);
		if (!ec_comptype.equalsIgnoreCase(o_comptype))
			ec_component = "";
	}

	ArrayList aListCitrixAppUsers = (ArrayList)request.getAttribute("Citrix Application Users");
	if (aListCitrixAppUsers != null && !aListCitrixAppUsers.isEmpty())
	{
		ArrayList aListCitrixFarmDetails = (ArrayList)aListCitrixAppUsers.get(1);
		if (aListCitrixFarmDetails != null)
		{
			TreeMap tmapData = (TreeMap)aListCitrixFarmDetails.get(3);
			ArrayList aListTemp = (ArrayList)tmapData.get("+");

			if (heading.equalsIgnoreCase("List of Applications/Desktops/Contents With Users"))
				farmName = (String)aListTemp.get(0);
			else
				serverName = (String)tmapData.firstKey();
		}

		ArrayList aListTemp = null;
		if (heading.equalsIgnoreCase("List of Applications/Desktops/Contents With Users"))
		{
			if (aListCitrixAppUsers.size() > 7)
			{
				aListTemp = (ArrayList)aListCitrixAppUsers.get(7);
			}
		}
		else
		{
			if (aListCitrixAppUsers.size() > 2)
			{
				aListTemp = (ArrayList)aListCitrixAppUsers.get(2);
			}
		}

		if (aListTemp != null)
		{
			tmapCitrixApplicationsAndUsers = (TreeMap)aListTemp.get(3);

			TreeMap tmapTemp = new TreeMap();
			Iterator applicationAsKeys = tmapCitrixApplicationsAndUsers.keySet().iterator();
			while (applicationAsKeys.hasNext())
			{
				String key_application = (String)applicationAsKeys.next();
				ArrayList aListApplicationValues = (ArrayList)tmapCitrixApplicationsAndUsers.get(key_application);
				if (aListApplicationValues != null && aListApplicationValues.contains("-")) continue;
				tmapTemp.put(key_application,aListApplicationValues);
			}

			tmapCitrixApplicationsAndUsers = tmapTemp;
		}
	}

	String applicationName = (String)request.getAttribute("applicationName");
	ArrayList aListCitrixApplicationUsers = null;
	if (applicationName != null && !(applicationName.equalsIgnoreCase("All") || applicationName.equals("-1")) && tmapCitrixApplicationsAndUsers != null && !tmapCitrixApplicationsAndUsers.isEmpty())
	{
		aListCitrixApplicationUsers = (ArrayList)tmapCitrixApplicationsAndUsers.get(applicationName);
	}

	session.setAttribute("ec_component",ec_component);
	session.setAttribute("heading",heading);
	session.setAttribute("farmName",farmName);
	session.setAttribute("serverName",serverName);
	session.setAttribute("applicationName",applicationName);
	session.setAttribute("CitrixApplicationUsers",tmapCitrixApplicationsAndUsers);

	String mngrIProc = new IniFile(new EgConfigInfo("manager").getDbFile()).getValue("DB_PROPERTIES","ManagerUrl");

	String userName = (String)session.getAttribute("sess_auserid");

	String id = request.getParameter("id");

	String strBackRequest = request.getParameter("back_request");
	String strsubmitClicked = request.getParameter("submitClicked");
	if (strsubmitClicked == null)
	{
		strsubmitClicked = "false";
	}
	if (strBackRequest != null && strBackRequest.equalsIgnoreCase("ScheduleConfig") && strsubmitClicked != null && strsubmitClicked.equalsIgnoreCase("false"))
	{
		submitOrNot = "false";
	}

	hiddenFields.put("ec_rtype","CitrixApplicationsAndUsers");
	hiddenFields.put("heading",heading);
	hiddenFields.put("userOption","Application Users");
	hiddenFields.put("requestFrom","CurrentPage");
	hiddenFields.put("old_comptype",ec_comptype);
	hiddenFields.put("ec_criteriaPrevious",ec_criteria);
	hiddenFields.put("userLanguage",userLanguage);
	hiddenFields.put("userName",userName);
	if(ec_userOption == null)
	{
		hiddenFields.put("ec_userOptionPrevious","");
	}
	else
	{
		hiddenFields.put("ec_userOptionPrevious",ec_userOption);
	}

	rootJson.put("hiddenFields",hiddenFields);


	JSONObject backOperation = new JSONObject();
	if (request_from != null && request_from.equalsIgnoreCase("saveSchedule"))
	{
		backOperation.put("schedule",new Boolean(true));
	}
	rootJson.put("backOperation",backOperation);


	JSONObject viewByObj = new JSONObject();
	JSONArray viewByArr = new JSONArray();
	if (vecCriterias != null && !vecCriterias.isEmpty())
	{
		for(int i=0; i<vecCriterias.size(); i++)
		{
			String strCriteria = (String)vecCriterias.get(i);
			if(ec_criteria != null && strCriteria.equals(ec_criteria))
			{
				rootJson.put("selectedEcOpt",ec_criteria);
			}
			viewByObj.put("displayField",_mapping.getTextDescription("configmgmt.common."+strCriteria));
			viewByObj.put("valueField",strCriteria);
			viewByArr.add(viewByObj);
		}
	}
	else
	{
		rootJson.put("selectedEcOpt","-1");
		viewByObj.put("displayField",_mapping.getTextDescription("configmgmt.common.Not Applicable"));
		viewByObj.put("valueField","-1");
		viewByArr.add(viewByObj);
	}
	rootJson.put("viewByList",viewByArr);


	if (ec_criteria != null && !ec_criteria.equalsIgnoreCase(criterias[3]) && !ec_criteria.equals("-1"))
	{
		if (ec_criteria.equalsIgnoreCase(criterias[0]))
		{
			rootJson.put("specViewByTitle",_mapping.getTextDescription("configmgmt.common."+criterias[0]));
		}
		else if (ec_criteria.equalsIgnoreCase(criterias[1]))
		{
			rootJson.put("specViewByTitle",_mapping.getTextDescription("configmgmt.common."+criterias[1]));
		}
		else
		{
			rootJson.put("specViewByTitle",_mapping.getTextDescription("configmgmt.common."+criterias[2]));
		}

		JSONObject specviewByObj = new JSONObject();
		JSONArray specviewByArr = new JSONArray();

		if (vecUserOptions != null && !vecUserOptions.isEmpty())
		{
			for(int i=0; i<vecUserOptions.size(); i++)
			{
				String selected = "";
				String strUserOption = (String)vecUserOptions.get(i);
				if(ec_userOption != null && strUserOption.equals(ec_userOption))
				{
					rootJson.put("selectedUserOption",ec_userOption);
				}
				specviewByObj.put("displayField",strUserOption);
				specviewByObj.put("valueField",strUserOption);
				specviewByArr.add(specviewByObj);
			}
		}
		else
		{
			rootJson.put("selectedUserOption","-1");
			specviewByObj.put("displayField",_mapping.getTextDescription("configmgmt.inventory.system.Not Applicable"));
			specviewByObj.put("valueField","-1");
			specviewByArr.add(specviewByObj);
		}
		rootJson.put("specViewByList",specviewByArr);
	}
	else
	{
	}


	JSONObject compTypeObj = new JSONObject();
	JSONArray compTypeArr = new JSONArray();
	if(vec_componentTypes != null && !vec_componentTypes.isEmpty())
	{
		rootJson.put("selectedCompType","-1");
		compTypeObj.put("displayField",_mapping.getTextDescription("configmgmt.common.Select a component type"));
		compTypeObj.put("valueField","-1");
		compTypeArr.add(compTypeObj);

		if (ec_comptype == null || ec_comptype.equals("-1"))
		{
			serverList = sorter.getSortedCompTypeList(vec_componentTypes);
			for (int i=0;i<serverList.size();i++)
			{
				EgName nameObj = (EgName)serverList.get(i);
				String actualName = nameObj.getActualName();
				String localName = nameObj.getLocalName();

				compTypeObj.put("displayField",localName);
				compTypeObj.put("valueField",actualName);
				compTypeArr.add(compTypeObj);
			}
		}
		else
		{
			serverList = sorter.getSortedCompTypeList(vec_componentTypes);
			for (int i=0;i<serverList.size();i++)
			{
				EgName nameObj = (EgName)serverList.get(i);
				String actualName = nameObj.getActualName();
				String localName = nameObj.getLocalName();

				if (actualName != null && actualName.equals(ec_comptype))
				{
					rootJson.put("selectedCompType",actualName);
				}
				compTypeObj.put("displayField",localName);
				compTypeObj.put("valueField",actualName);
				compTypeArr.add(compTypeObj);
			}
		}
	}
	else
	{
		rootJson.put("selectedCompType","-1");
		compTypeObj.put("displayField",_mapping.getTextDescription("configmgmt.inventory.system.Not Applicable"));
		compTypeObj.put("valueField","-1");
		compTypeArr.add(compTypeObj);
	}
	rootJson.put("compTypeList",compTypeArr);


	JSONObject compNameObj = new JSONObject();
	JSONArray compNameArr = new JSONArray();
	if (v_comp != null && !v_comp.isEmpty())
	{
		rootJson.put("selectedCompName","-1");
		compNameObj.put("displayField",_mapping.getTextDescription("configmgmt.common.Select a component"));
		compNameObj.put("valueField","-1");
		compNameArr.add(compNameObj);

		for (int i=0;i<v_comp.size();i++)
		{
			String componentTemp = (String)v_comp.get(i);
			String tempCompName = "";
			String tempCompType = "";
			String selected = "";
			if (componentTemp != null)
			{
				tempCompName = componentTemp.substring(0,componentTemp.lastIndexOf(":"));
				if (tempCompName.endsWith(":NULL"))
					tempCompName = tempCompName.substring(0,tempCompName.indexOf(":"));
				tempCompType = componentTemp.substring(componentTemp.lastIndexOf(":")+1);
				//getting component type mapping name
				tempCompType = mappingInfo.getComponentTypeDescription(tempCompType);

				if (componentTemp.equals(ec_component))
				{
					rootJson.put("selectedCompName",componentTemp);
				}
			}

			String strDisplay = tempCompName + ":"+tempCompType;
			compNameObj.put("displayField",strDisplay);
			compNameObj.put("valueField",componentTemp);
			compNameArr.add(compNameObj);
		}
	}
	else
	{
		rootJson.put("selectedCompName","-1");
		compNameObj.put("displayField",_mapping.getTextDescription("configmgmt.inventory.system.Not Applicable"));
		compNameObj.put("valueField","-1");
		compNameArr.add(compNameObj);
	}
	rootJson.put("compNameList",compNameArr);


	subTitle = mappingInfo.getTextDescription("configmgmt.common.Component") + " : " + componentName + ":" + componentType;
	if (heading.equalsIgnoreCase("List of Applications/Desktops/Contents With Users"))
	{
		subTitle = subTitle + "\n" + mappingInfo.getTextDescription("configmgmt.configuration.Farm name") + " : " + farmName;

		rootJson.put("LabelName",mappingInfo.getTextDescription("configmgmt.configuration.Farm Name"));

		if (farmName == null)
		{
			rootJson.put("serverName",mappingInfo.getTextDescription("configmgmt.common.Not Applicable"));
		}
		else
		{
			rootJson.put("serverName",farmName);
		}
	}
	else
	{
		subTitle = subTitle + "\n" + mappingInfo.getTextDescription("configmgmt.configuration.Server name") + " : " + serverName;
		rootJson.put("LabelName",mappingInfo.getTextDescription("configmgmt.configuration.Server Name"));
		if (serverName == null)
		{
			rootJson.put("serverName",mappingInfo.getTextDescription("configmgmt.common.Not Applicable"));
		}
		else
		{
			rootJson.put("serverName",serverName);
		}
	}


	JSONObject appNameObj = new JSONObject();
	JSONArray appNameArr = new JSONArray();


	if (tmapCitrixApplicationsAndUsers != null && tmapCitrixApplicationsAndUsers.size()>0)
	{
		rootJson.put("selectedApplication","-1");
		appNameObj.put("displayField",_mapping.getTextDescription("configmgmt.common.Select an application"));
		appNameObj.put("valueField","-1");
		appNameArr.add(appNameObj);

		if (tmapCitrixApplicationsAndUsers.size() > 1)
		{
			if ("All".equalsIgnoreCase(applicationName))
			{
				rootJson.put("selectedApplication",applicationName);
			}
			appNameObj.put("displayField",_mapping.getTextDescription("configmgmt.common.All"));
			appNameObj.put("valueField","All");
			appNameArr.add(appNameObj);
		}

		Iterator applicationAsKeys = tmapCitrixApplicationsAndUsers.keySet().iterator();
		while (applicationAsKeys.hasNext())
		{
			String applicationKey = (String)applicationAsKeys.next();

			if (applicationKey.equalsIgnoreCase(applicationName))
			{
				rootJson.put("selectedApplication",applicationKey);
			}

			appNameObj.put("displayField",applicationKey);
			appNameObj.put("valueField",applicationKey);
			appNameArr.add(appNameObj);
		}
	}
	else
	{
		rootJson.put("selectedApplication","-1");
		appNameObj.put("displayField",_mapping.getTextDescription("configmgmt.common.Not Applicable"));
		appNameObj.put("valueField","-1");
		appNameArr.add(appNameObj);
	}

	rootJson.put("applicationList",appNameArr);


	if (request_from != null && request_from.equalsIgnoreCase("saveSchedule"))
	{
		
	}
	else
	{
		
	}

	if (aListCitrixApplicationUsers != null && submitOrNot.equals("true"))
	{
		rootJson.put("hasConfigDetails",true);

		ArrayList aList = new ArrayList();
		StringTokenizer strTokens = new StringTokenizer((String)aListCitrixApplicationUsers.get(0),",");

		//For New Pdf Framework - Krishnamurthi
		ArrayList aListPdfData = new ArrayList();
		EgPdfData pdfData = new EgPdfData();
	
		EgReportAttributes reportAttributes = new EgReportAttributes();
		String pdfTitle = "";
		if (ec_criteria != null && !ec_criteria.equalsIgnoreCase(criterias[3]) && !ec_criteria.equals("-1"))
		{
			pdfTitle = mappingInfo.getTextDescription("configmgmt.inventory.view.THIN CLIENT APPLICATIONS REPORT") + " IN" + " '" + ec_userOption + "' "  +  ec_criteria + "  " + mappingInfo.getTextDescription("configmgmt.configuration.as on") + "  " + dateString;
		}
		else
		{
			pdfTitle = mappingInfo.getTextDescription("configmgmt.inventory.view.THIN CLIENT APPLICATIONS REPORT") + "  " + mappingInfo.getTextDescription("configmgmt.configuration.as on") + "  " + dateString;
		}
		reportAttributes.setMainTitle(pdfTitle);

		reportAttributes.setReportName("ThinClientApplications");
		reportAttributes.setModule("CONFIG");
		reportAttributes.setPortrait(true);

		EgTableAttributes egTableAttributes = new EgTableAttributes();
		egTableAttributes.setTitle(mappingInfo.getTextDescription("configmgmt.configuration.Total users for")+" "+applicationName+" : "+strTokens.countTokens());

		subTitle = subTitle + "\n" + mappingInfo.getTextDescription("configmgmt.configuration.Application") + " : " + applicationName;
		reportAttributes.setSubTitle(subTitle);

		ArrayList aListColumnNames = new ArrayList();
		ArrayList aListData = new ArrayList();
		ArrayList userColumnNames = new ArrayList();

		for (int x=0; x<4; x++)
			aListColumnNames.add("C"+x);

		userColumnNames.add(mappingInfo.getTextDescription("configmgmt.configuration.List of users"));
		userColumnNames.add("");
		userColumnNames.add("");
		userColumnNames.add("");

		rootJson.put("gridSubTitle",mappingInfo.getTextDescription("configmgmt.configuration.List of users"));

		rootJson.put("gridMainTitle",mappingInfo.getTextDescription("configmgmt.configuration.Total users for")+" "+applicationName+" : "+strTokens.countTokens());

		while (strTokens.hasMoreTokens())
		{
			String token = strTokens.nextToken();
			aList.add(token);
		}

		JSONArray usersArr = new JSONArray();
		JSONObject usersObj = new JSONObject();
		int columnCount = 1;

		usersObj.put("applicationName",applicationName+" (Count: "+aList.size()+")");

		for (int d=0; d<aList.size(); d=d+4)
		{
			for (int e=d; e<d+4; e++)
			{
				if (e<aList.size())
				{
					String hidden_href = "";
					String userKey = (String)aList.get(e);
					StringBuffer strBuffer = new StringBuffer(userKey);
					strBuffer.insert(userKey.indexOf("\\")+1,"\\");
					String userValue = strBuffer.toString();

					if(farmName != null && farmName != "")
					{
						hidden_href = "../servlet/com.eg.EcConfigurationServletNew?ec_rtype=CitrixApplicationsAndUsers&userName="+userKey+"&ec_component="+ec_component+"&ec_comptype="+ec_comptype+"&ec_criteria="+ec_criteria+"&ec_criteriaPrevious="+ec_criteriaPrevious+"&ec_userOptionPrevious="+ec_userOptionPrevious+"&heading="+heading+"&old_comptype="+ec_comptype+"&requestFrom=CitrixAppUsersPage"+"&submitClicked="+strsubmitClicked+"&applicationName="+applicationName+"&userOption=User Applications&user_language="+userLanguage+"&fsctrl="+farmName;
					}
					else if(serverName != null && serverName != "")
					{
						hidden_href = "../servlet/com.eg.EcConfigurationServletNew?ec_rtype=CitrixApplicationsAndUsers&userName="+userKey+"&ec_component="+ec_component+"&ec_comptype="+ec_comptype+"&ec_criteria="+ec_criteria+"&ec_criteriaPrevious="+ec_criteriaPrevious+"&ec_userOptionPrevious="+ec_userOptionPrevious+"&heading="+heading+"&old_comptype="+ec_comptype+"&requestFrom=CitrixAppUsersPage"+"&submitClicked="+strsubmitClicked+"&applicationName="+applicationName+"&userOption=User Applications&user_language="+userLanguage+"&fsctrl="+serverName;
					}
					String userKeyWithURL = userKey +"#$#"+ hidden_href;
					usersObj.put("column_"+columnCount,userKeyWithURL);
					aListData.add(userKey);
				}
				else
				{
					aListData.add(" ");
					usersObj.put("column_"+columnCount,"");
				}
				if(columnCount == 4)
				{
					columnCount = 1;
				}
				else
				{
					columnCount++;
				}
			}
			usersArr.add(usersObj);
		}
		rootJson.put("ListOfUsers",usersArr);

		//For Pdf
		EgTableModel egTableModel = new EgTableModel(aListData,aListColumnNames);
		egTableAttributes.setColumnNames(userColumnNames);

		EgTable egTable = new EgTable();
		egTable.setModel(egTableModel);
		egTable.setAttributes(egTableAttributes);

		aListPdfData.add(egTable);

		pdfData.setAttributes(reportAttributes);
		pdfData.setData(aListPdfData);
		session.setAttribute("pdfData",pdfData);
	}
	else if (applicationName != null && applicationName.equalsIgnoreCase("All") && submitOrNot.equals("true"))
	{
		rootJson.put("hasConfigDetails",true);
		//For PDF
		ArrayList aListPdfData = new ArrayList();
		EgPdfData pdfData = new EgPdfData();

		EgReportAttributes reportAttributes = new EgReportAttributes();
		reportAttributes.setMainTitle(mappingInfo.getTextDescription("configmgmt.configuration.THIN CLIENT APPLICATIONS"));
		reportAttributes.setReportName("ThinClientApplications");
		reportAttributes.setModule("CONFIG");
		reportAttributes.setPortrait(true);

		subTitle = subTitle + "\n" + mappingInfo.getTextDescription("configmgmt.configuration.List of applications with their associated users");
		reportAttributes.setSubTitle(subTitle);

		ArrayList aListData = new ArrayList();

		ArrayList aListColumnNames = new ArrayList();
		aListColumnNames.add("Application");
		aListColumnNames.add("User1");
		aListColumnNames.add("User2");
		aListColumnNames.add("User3");

		ArrayList userColumnNames = new ArrayList();
		userColumnNames.add("");
		userColumnNames.add(mappingInfo.getTextDescription("configmgmt.configuration.Users"));
		userColumnNames.add("");
		userColumnNames.add("");

		EgTableAttributes egTableAttributes = new EgTableAttributes();
		egTableAttributes.setColumnNames(userColumnNames);
		egTableAttributes.setStartX(0);
		egTableAttributes.setDataGrouping(true);
		egTableAttributes.setDataGroupingField(0);


		rootJson.put("TitleForAllUsersGrid",mappingInfo.getTextDescription("configmgmt.configuration.List of applications with their associated users"));

		JSONArray allUsersArr = new JSONArray();
		JSONObject allUsersObj = new JSONObject();
		int colCount = 1;

		Iterator applicationAsKeys = tmapCitrixApplicationsAndUsers.keySet().iterator();
		while (applicationAsKeys.hasNext())
		{
			String applicationKey = (String)applicationAsKeys.next();
			ArrayList aListUsers = (ArrayList)tmapCitrixApplicationsAndUsers.get(applicationKey);
			ArrayList aList = new ArrayList();
			StringTokenizer strTokens = new StringTokenizer((String)aListUsers.get(0),",");
			while (strTokens.hasMoreTokens())
			{
				String token = strTokens.nextToken();
				aList.add(token);
			}
			String appWithUserCount = applicationKey + "#$#" +mappingInfo.getTextDescription("configmgmt.configuration.Count")+ " : " + aList.size();
			allUsersObj.put("application",appWithUserCount);
			for (int d=0; d<aList.size(); d=d+3)
			{
				aListData.add(mappingInfo.getTextDescription("configmgmt.configuration.Application")+" : "+applicationKey);
				for (int e=d; e<d+3; e++)
				{
					if (e<aList.size())
					{
						String hidden_href = "";
						String userKey = (String)aList.get(e);
						StringBuffer strBuffer = new StringBuffer(userKey);
						strBuffer.insert(userKey.indexOf("\\")+1,"\\");
						String userValue = strBuffer.toString();

						aListData.add(userKey);

						if(farmName != null && farmName != "")
						{
							hidden_href = "../servlet/com.eg.EcConfigurationServletNew?ec_rtype=CitrixApplicationsAndUsers&userName="+userKey+"&ec_component="+ec_component+"&ec_comptype="+ec_comptype+"&ec_criteria="+ec_criteria+"&ec_criteriaPrevious="+ec_criteriaPrevious+"&ec_userOptionPrevious="+ec_userOptionPrevious+"&heading="+heading+"&old_comptype="+ec_comptype+"&requestFrom=CitrixAppUsersPage"+"&submitClicked="+strsubmitClicked+"&applicationName="+applicationName+"&userOption=User Applications&user_language="+userLanguage+"&fsctrl="+farmName;
						}
						else if(serverName != null && serverName != "")
						{
							hidden_href = "../servlet/com.eg.EcConfigurationServletNew?ec_rtype=CitrixApplicationsAndUsers&userName="+userKey+"&ec_component="+ec_component+"&ec_comptype="+ec_comptype+"&ec_criteria="+ec_criteria+"&ec_criteriaPrevious="+ec_criteriaPrevious+"&ec_userOptionPrevious="+ec_userOptionPrevious+"&heading="+heading+"&old_comptype="+ec_comptype+"&requestFrom=CitrixAppUsersPage"+"&submitClicked="+strsubmitClicked+"&applicationName="+applicationName+"&userOption=User Applications&user_language="+userLanguage+"&fsctrl="+serverName;
						}

						String userKeyWithURL = userKey + "#$#" + hidden_href;

						allUsersObj.put("column_"+colCount,userKeyWithURL);
					}
					else
					{
						aListData.add("");
						allUsersObj.put("column_"+colCount,"");
					}
					if (colCount == 3)
					{
						colCount = 1;
					}
					else
					{
						colCount++;
					}
				}
				allUsersArr.add(allUsersObj);
			}
		}
		rootJson.put("AllUsersGridValues",allUsersArr);
		//For PDF
		EgTableModel egTableModel = new EgTableModel(aListData,aListColumnNames);
		EgTable egTable = new EgTable();
		egTable.setModel(egTableModel);
		egTable.setAttributes(egTableAttributes);
		aListPdfData.add(egTable);

		pdfData.setAttributes(reportAttributes);
		pdfData.setData(aListPdfData);
		session.setAttribute("pdfData",pdfData);
	}
	else
	{
		rootJson.put("hasConfigDetails",false);
		rootJson.put("errorText","No data found for the current selection.");
	}

	StringBuffer printQS = new StringBuffer();
	printQS.append("ec_type=Application_Users");
	printQS.append("&ec_trgttype=REPORT");
	printQS.append("&printData=yes");
	printQS.append("&userName="+EgURLEncoder.encode(userName,"UTF-8"));
	printQS.append("&user_language="+userLanguage);
	printQS.append("&ec_criteria="+ec_criteria);
	printQS.append("&ec_userOption="+((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):""));
	String s_qryString = "../servlet/com.eg.EcRepoLiteC?"+printQS.toString()+"&ec_forPDF=No";
	rootJson.put("printQueryStr",s_qryString);

	session.setAttribute("PDF_URL",mngrIProc+"/final/servlet/com.eg.EcRepoLiteC;jsessionid="+session.getId()+"?"+printQS.toString()+"&ec_forPDF=Yes");
	session.setAttribute("REPORT_NAME","ThinClientApplicationsWithUsers");
	session.setAttribute("REPORT_LAYOUT","Portrait");
	session.setAttribute("PAGE_WIDTH_PDF","1100");
	session.setAttribute("PAGE_WIDTH_MAIL_IMAGE","1300");
	session.setAttribute("PAGE_HEIGHT_MAIL_IMAGE","768");

	if(request.getQueryString()!=null)
	{
		session.setAttribute("configLastAccessedURL","/final/config/EcCitrixAppUsersIndex.jsp?"+request.getQueryString());
	}
	else
	{
		session.setAttribute("configLastAccessedURL","/final/config/EcCitrixAppUsersIndex.jsp?cmd=ThinClientUsers");
	}

	out.println(rootJson);

%>



