<%
/***********************************************************************************
*		Name					:egMaintenancePolicygroupList.jsp
*		Purpose				:List page for	policy groups  with	detailed view of associated	policies and associated	elements
*		Version					:4.3
*		CreationDate		:12/09/2008
*		Author					:	Simeon.D
***********************************************************************************/
%>

<%@	taglib prefix =	"egui" uri = "../WEB-INF/eg-taglib.tld"%>
<%@	include	file="EgTrackerA.jsp" %>
<%@	page errorPage="EgProbs.jsp"%>
<%@	page import="com.egurkha.admin.EgMaintenanceUtility"%>
<%@	page import="com.egurkha.util.DateUtil"%>
<%@	page import="com.eg.*"%>
<%@	page import="com.egurkha.util.StringUtils"%>
<%@	page import="java.util.Hashtable"%>
<%@	page import="java.util.Vector"%>
<%@	page import="java.util.Iterator"%>
<%@ page import="java.util.Collections"%>

<%@	page language="java" contentType="text/html; charset=UTF-8"	pageEncoding="UTF-8" %>

<%
	String egTitleSearchStr=request.getParameter("egTitleSearchStr");
	String groupNameFromLink=request.getParameter("groupNameFromLink");
	String linkFrom	= request.getParameter("linkFrom");
	String FromTabWork=request.getParameter("FromTabWork");
	String listPageTitle="List of Policy Groups";
	boolean	isSearchStrNotFound=true;
	if(FromTabWork==null) 
	{
		FromTabWork="false";
	}
	if(groupNameFromLink!=null)	
	{
		listPageTitle="PolicyGroup Details - "+groupNameFromLink;
	}
	if(egTitleSearchStr!=null)
		egTitleSearchStr=egTitleSearchStr.trim();
%>

<html>
	<head>
		<title>
		</title>
		<egui:skin ui="admin"/>
		<script	language="javascript" src="/final/admin/eg_scripts/MaintananceTree.js"></script>
		<script	language="javascript">
	
	function egTitleSearch()
	{
		var	egTitleSearchStr=document.getElementById("egTitleSearchStr");
		window.location.href="egMaintenancePolicygroupList.jsp?egTitleSearchStr="+egTitleSearchStr.value;
	}

	function openTreeWindow()
	{
		var	treeViewTd=window.parent.document.getElementById("treeViewTd");
		var	treeViewExpandTD=window.parent.document.getElementById("MaintananceTree").contentWindow.document.getElementById("treeViewExpandTD");
		var	expandImg=window.parent.document.getElementById("expand");
		expandImg.src="/final/admin/eg_images/split_left.gif"
		treeViewTd.style.display='block';
	}

	function closeDiv(event)
	{
		var	associatedElementsDiv=document.getElementById("associatedElementsDiv");	
		associatedElementsDiv.style.display="none";
		associatedElementsDiv.visibility='visible';
	}

	function showAssociatedElements(event,id)
	{
		var	hidd=document.getElementById(id);
		var	associatedElementsDiv=document.getElementById("associatedElementsDiv");
		var	associatedTestsTd=document.getElementById("associatedTestsTd");
		var	divTitle=document.getElementById("divTitle");
		var	values=hidd.value.split("#");
		if(navigator.appName=="Microsoft Internet Explorer")
		{
			event=window.event;
			divTitle.innerHTML=values[0];
			associatedTestsTd.innerHTML=values[1];
			var	windowHeight=document.body.clientHeight+document.body.scrollTop;
			var	divLocation=event.clientY+document.body.scrollTop+80;
			var	clickLocation=event.clientX+document.body.scrollLeft-300;
			if(clickLocation<0)
			{
				associatedElementsDiv.style.left=0;
			}
			else
			{
				associatedElementsDiv.style.left=(event.clientX)+document.body.scrollLeft-460;
			}
			if(divLocation>windowHeight)
			{
				associatedElementsDiv.style.top=windowHeight-200;
			}
			else
			{
				associatedElementsDiv.style.top=(event.clientY)+document.body.scrollTop-80;
			}
		}
		else
		{
			divTitle.innerHTML=values[0];
			associatedTestsTd.innerHTML=values[1];
			var	windowHeight=document.body.clientHeight+document.body.scrollTop;
			var	divLocation=event.clientY+document.body.scrollTop+80;
			var	clickLocation=event.clientX+document.body.scrollLeft-300;

			if(clickLocation<0)
			{
				associatedElementsDiv.style.left=0;
			}
			else
			{
				associatedElementsDiv.style.left=(event.clientX)+document.body.scrollLeft-460;
			}
			if(divLocation>windowHeight)
			{
				associatedElementsDiv.style.top=windowHeight-200;
			}
			else
			{
				associatedElementsDiv.style.top=(event.clientY)+document.body.scrollTop-80;
			}
		}
		associatedElementsDiv.style.display="block";
		associatedElementsDiv.visibility='visible';
	}

	function bodyResize()
	{
		var	bodyWidth=document.body.clientWidth;
		var	associatedElementsDiv=document.getElementById("associatedElementsDiv");
		if(bodyWidth>800)
		{
			if(associatedElementsDiv.style.display=="block")
			{
				associatedElementsDiv.style.left=450;
			}
		}
		else
		{
			if(associatedElementsDiv.style.display=="block")
			{
				associatedElementsDiv.style.left=250;
			}
		}
	}

	function showDiv(opt,index,divId)
	{
		try
		{
			var	associatedPolicyDiv=document.getElementById("associatedPolicyDiv"+index);
			var	associateServerDiv=document.getElementById("associateServerDiv"+index);
			var	elementssDivTab=document.getElementById("elementss"+divId);
			var	elementDivTab=document.getElementById("element"+divId);
			var	elementaDivTab=document.getElementById("elementa"+divId);
			var	elementsDivTab=document.getElementById("elements"+divId);

			var policiessDivTab=document.getElementById("policiess"+divId);
			var	policyDivTab=document.getElementById("policy"+divId);
			var	policyaDivTab=document.getElementById("policya"+divId);
			var policiesDivTab=document.getElementById("policies"+divId);

			if(associatedPolicyDiv==null &&	associateServerDiv==null &&	policyDivTab==null && elementDivTab==null)
			{
				return;
			}
			if(opt=="policy")
			{
				associatedPolicyDiv.style.display="block";
				associateServerDiv.style.display="none";

				policiessDivTab.className="page_tab_left_curve_light";
				policyDivTab.className="page_tab_bg_light";
				policyaDivTab.className="page_tablink";
				policiesDivTab.className="page_tab_right_curve_light";

				elementssDivTab.className="page_tab_left_curve_dark";
				elementDivTab.className="page_tab_bg_dark";
				elementaDivTab.className="page_tablink_dark";
				elementsDivTab.className="page_tab_right_curve_dark";
				
			}
			else if(opt=="associate")
			{
				associatedPolicyDiv.style.display="none";
				associateServerDiv.style.display="block";

				policiessDivTab.className="page_tab_left_curve_dark";
				policyDivTab.className="page_tab_bg_dark";
				policyaDivTab.className="page_tablink_dark";
				policiesDivTab.className="page_tab_right_curve_dark";

				elementssDivTab.className="page_tab_left_curve_light";
				elementDivTab.className="page_tab_bg_light";
				elementaDivTab.className="page_tablink";
				elementsDivTab.className="page_tab_right_curve_light";
			}
		}
		catch(ex)
		{}
	}

	function policyOnclick(nodeName,parentNodeName)
	{
		var	treeFrame=window.parent.document.getElementById("MaintananceTree");
		if(treeFrame==null)
		{
			treeFrame=parent.getTreeViewObj();
		}
		if(treeFrame!=null)
		{
			treeFrame.src="/final/admin/egMaintenanceTreeUI.jsp?process=frompolicylink&nodeName="+nodeName+"&parentNodeName="+parentNodeName;
		}
		document.location.href="/final/admin/egUnassociatedList.jsp?from="+parentNodeName+"&policyToView="+nodeName+"&linkFrom=maintenacelist";
	}

	function showAllPolicies(opt,noOfGroups)
	{
		var	showAllElemetsTr=document.getElementById("showAllElemetsTr");
		var	showAllPolicyTr=document.getElementById("showAllPolicyTr");
		if(opt=='associate')
		{
			showAllElemetsTr.style.display='none';
			showAllElemetsTr.style.visibility='hidden';
			showAllPolicyTr.style.display='block';
			showAllPolicyTr.style.visibility='visible';
		}
		else
		{
			showAllElemetsTr.style.display='block';
			showAllElemetsTr.style.visibility='visible';
			showAllPolicyTr.style.display='none';
			showAllPolicyTr.style.visibility='hidden';
		}
		for(var	i=0;i<noOfGroups;i++)
		{
				showDiv(opt,i,i)
		}	
	}

	function goback()
	{
		var	MaintananceView=window.parent.document.getElementById("MaintananceView");
		if(MaintananceView!=null)
		{
<%
				if(linkFrom!=null && linkFrom.equals("relatedGroups")) {
%>
					MaintananceView.src="/final/admin/egUnassociatedList.jsp";
<%
				} else if(linkFrom!=null &&	linkFrom.equals("AnalysisGroup")) {
		String analysisUrl=(String)session.getAttribute("paramForAnalysis");
		if(analysisUrl!=null) {
%>
						MaintananceView.src="/final/admin/egMaintenanceAnalysis.jsp?<%=analysisUrl%>&comesFrom=Tab";
<%
					} else {
%>
						MaintananceView.src="/final/admin/egMaintenanceAnalysis.jsp";
<%
					}
								}
%>
	}
}
				  </script>
	</head>
	<body onresize="javascript:bodyResize()" class="">
		<div id="associatedElementsDiv"	style="background:white;border:0px solid #FF0000;width:480px;height:180px;display:none;position:absolute;z-index:1000" wrap>
			<table border="0" cellpadding="10" cellspacing="0" width="450px" id="alarmborder" height="180px">
				<tr>
					<td	valign="top" height="20px" style="padding:0px" id="tree_bgdark">
						<table	border="0" cellpadding="0" cellspacing="0" width="100%"><col width="286px"><col	width="14px">
							<tr>
								<td	align="center" class="eg_white"><b id="divTitle" style="text-transform:	uppercase"></b></td>
								<td	align="right" style="padding:2px" valign="middle"><img class="mouse" onclick="javascript:closeDiv(event)" src="/final/monitor/eg_images/winclose.gif" border="1"	class="mouse" title="close" width="14" height="12"></td>
							</tr>
						</table>
					</td>
				</tr>
				<tr>
					<td>
						<div style="width:450px;height:120px;position:relative;border:0px solid	#ff0000;" class="div_Scroll">
							<table cellpadding="0" width="100%"	height="100%" cellspacing="0" border="0">
								<tr>
									<td	id="associatedTestsTd" valign="top"	height="120px" width="450px">
									</td>
								</tr>
							</table>
						</div>
					</td>
				</tr>
			</table>
		</div>
		
		<form name="maintenanceList" id="maintenanceList">
<%
	if(groupNameFromLink!=null && !groupNameFromLink.equals("")) 
	{
		String qryString = "listSearch.jsp?title="+listPageTitle+"&subtitle=true&searchBox=false&treeViewNeeded=true";
%>
			<jsp:include page="<%=qryString%>"/>
<%
	}
	else 
	{
		String qryString = "listSearch.jsp?title="+listPageTitle+"&subtitle=true&searchBox=true&treeViewNeeded=true";
%>
			<jsp:include page="<%=qryString%>"/>
<%
	}
	
	EgMaintenanceUtility maintenanceUtil=new EgMaintenanceUtility();
	Hashtable policyGroup=maintenanceUtil.getAllGroupsWithPolicy();
	Vector groupVec=new	Vector();
	String display="";
	int	searchNoOfOccurance=0;
	
	policyGroup.remove("default");
	groupVec.addAll(policyGroup.keySet());
	Collections.sort(groupVec,String.CASE_INSENSITIVE_ORDER);
	Iterator groupsItr=groupVec.iterator();
	
	for(int	i=0;i<groupVec.size();i++) 
	{
		String policyGroupName=(String)groupVec.get(i);
		if(egTitleSearchStr!=null && policyGroupName!=null) 
		{
			StringTokenizer st=new StringTokenizer(egTitleSearchStr," ");
			while(st.hasMoreTokens())
			{
				String searchStr=st.nextToken();
				if(searchStr!=null && policyGroupName!=null && (policyGroupName.toUpperCase()).indexOf(searchStr.toUpperCase())!=-1) 
				{
					searchNoOfOccurance++;
				}
			}
		}
		else if(egTitleSearchStr!=null)
		{
			searchNoOfOccurance++;
		}
	}
%>
			<table align="center" border="0" cellpadding="0" cellspacing="0" width="100%">
<%
	if(groupNameFromLink==null && policyGroup.size()>1 && ((egTitleSearchStr==null)	|| (egTitleSearchStr!=null && searchNoOfOccurance>1))) 
	{
%>
				<tr>
					<td	style="padding-right:70px" align="right">
						<table width="100%"	cellspacing="0"	cellpadding="0"	border="0" >
							<tr	id="showAllElemetsTr" align="right">
								<td	class="head_padding4" align="right"	width="100%" > <a class="dash_link"	style="text-decoration:none;" href="javascript:showAllPolicies('associate',<%=policyGroup.size()%>);"><egui:intnl	text="admin.role.Show All	Associated Elements"/>&nbsp;<img src="/final/admin/eg_images/icon_click.gif" border="0"></a></td>
							</tr>
							<tr	id="showAllPolicyTr" style="display:none;" align="right">
								<td	class="head_padding4" align="right"	width="100%" > <a class="dash_link"	style="text-decoration:none;" href="javascript:showAllPolicies('policy',<%=policyGroup.size()%>);"><egui:intnl text="admin.role.Show All PolicyDetails"/>&nbsp;<img src="/final/admin/eg_images/icon_click.gif" border="0"></a></td>
							</tr>
						</table>
					</td>
				</tr>
<%
	}
%>
				<tr>
					<td>
<%
	int	index=0;
	boolean	isGroupsFound=false;
	int	divId=0;
	if(groupNameFromLink!=null &&  ( (linkFrom !=null && linkFrom.equals("AnalysisGroup")) || policyGroup.size()>1)) 
	{
		isSearchStrNotFound=false;
		isGroupsFound=true;
		if((linkFrom !=null) &&	(linkFrom.equals("relatedGroups") || linkFrom.equals("AnalysisGroup")))	
		{
%>
						<table align="center" border="0" cellpadding="0" cellspacing="0" width="95%">
							<tr>
								<td	class="head_padding4" align="right"	width="100%" > <a class="dash_link"	style="text-decoration:none;" href="javascript:goback();"><span id="showallusers"><img src="/final/admin/eg_images/icon_back.gif"	border="0">&nbsp;
<%
			if(linkFrom.equals("relatedGroups")) 
			{
%>
										<egui:intnl	text="admin.mpolicy.Back to	PolicyList"/>
<%
			}
			else if(linkFrom.equals("AnalysisGroup"))	
			{
%>
										<egui:intnl	text="admin.mpolicy.Back to	Maintenance	Analysis"/>
<%
			}
%>
									</a>
								</td>
							</tr>
						</table>
<%
		}
%>
						<table align="center" border="0" cellpadding="0" cellspacing="0" width="95%">
							<tr>
								
								<td	width="100%"  >
									<table cellpadding="0" cellspacing="0" width="100%"	border="0">
										<tr>
											<td> <img src="/final/admin/eg_images/policygroup.gif"	width="20" height="20" ></td>
											<td	width="100%">&nbsp;<b> <%=groupNameFromLink%></b></td>
										</tr>
									</table>
								</td>
							</tr>
							<tr>
								<td	><img src="/final/admin/eg_images/spacer.gif" height="5"></td>
							</tr>
							<tr>
								<td>
									<table cellpadding="0" cellspacing="0" width="100%" border="0" bordercolor="red">
										<tr>
											<td class="linebottom_image">
												<table border="0" cellpadding="0" cellspacing="0" width="100%">
													<tr>
														<td valign="bottom">
															<table border="0" cellpadding="0" cellspacing="0">
																<tr>
																	<td align="left">
																		<table border="0" bordercolor="blue" cellpadding="0" cellspacing="0">
																			<tr>
																				<td id="policiess<%=index%>"  class="page_tab_left_curve_light"  width="4" height="20" ><img src="/final/admin/eg_images/spacer.gif" width="4" height="20" border="0"></td>
																				<td id="policy<%=index%>"  class="page_tab_bg_light" nowrap><a href="javascript:void(0);" id="policya<%=index%>" class="page_tablink" onclick="javascript:showDiv('policy','<%=index%>'
																				,'<%=index%>');"><egui:intnl text="admin.mpolicy.Policies"/></a> </td>
																				<td id="policies<%=index%>"  class="page_tab_right_curve_light" width="4" height="20"><img src="/final/admin/eg_images/spacer.gif" width="4" height="20" border="0"></td>
																			</tr>
																		</table>
																	</td>
																	<td>&nbsp;</td>
																	<td align="left">
																		<table border="0" cellpadding="0" cellspacing="0" >
																			<tr>
																				<td id="elementss<%=index%>" class="page_tab_left_curve_dark"  width="4" height="20"><img src="/final/monitor/eg_images/spacer.gif" width="4" height="20" border="0"></td>
																				<td id="element<%=index%>" class="page_tab_bg_dark" nowrap><a href="javascript:void(0);" id="elementa<%=index%>"  class="page_tablink_dark"  onclick="javascript:showDiv('associate','<%=index%>','<%=index%>');"><egui:intnl text="admin.mpolicy.Associated Elements"/></a></td>
																				<td id="elements<%=index%>" class="page_tab_right_curve_dark" width="4" height="20" ><img src="/final/monitor/eg_images/spacer.gif" width="4" height="20" border="0"></td>
																			</tr>
																		</table>
																	</td>
																</tr>
															</table>
														</td>
														<td width="90%" align="right">&nbsp;</td>
													</tr>
												</table>
											</td>
										</tr>


													<!------------------------------>
												</table>
											</td>
										</tr>
										
										<tr>
											<td	align="center"class="page_tab_border page_tab_bg" style="padding:4px;border-top-width:0px">
												<table border="0" cellpadding="0" cellspacing="0" width="100%">
													<tr>
														<td>
															<div id="<%="associatedPolicyDiv"+index%>" style="display:block;position:relative;border:0px solid	#ff00cc"> 
																<table border="0" class="lineborder"  style="border-bottom-width:0px" cellpadding="4" cellspacing="0"	width="100%" align="center"><col width="40%"><col width="250px"><col width="250px">
																	<tr>
																		<td	class="linebottomright linebg3"	valign="top"><egui:intnl text ="admin.mpolicy.PolicyName"/></td>
																		<td	class="linebottomright linebg3"	valign="top"><egui:intnl text ="admin.mpolicy.Time Frequency"/></td>
																		<td	class="linebottomright linebg3"	valign="top"><egui:intnl text ="admin.mpolicy.Timeline"/></td>
																	</tr>
<%
	Vector policies=(Vector)policyGroup.get(groupNameFromLink);
	boolean	policyFlag=false;
	Iterator itr=policies.iterator();
	while(itr.hasNext()) 
	{
		String policyName=(String)itr.next();
%>
																	<tr>
																		<td	valign="top" class="linebottom linebg2"><%=policyName%></td>
																		<td	valign="top" class="linebottom linebg2"	colspan="2"	>
																			<table border="0" class="tableborder_ad"
width="100%" cellspacing="0" cellpadding="4" style="table-layout:fixed"><col width="150px"><col	width="150px" >
<%
		Hashtable timeConstraints=maintenanceUtil.getPolicyTimeLines(policyName);
					Vector timeConsKeys=new Vector();
					timeConsKeys.add("Sunday");
					timeConsKeys.add("Monday");
					timeConsKeys.add("Tuesday");
					timeConsKeys.add("Wednesday");
					timeConsKeys.add("Thursday");
					timeConsKeys.add("Friday");
					timeConsKeys.add("Saturday");
					timeConsKeys.add("Daily");
					timeConsKeys.add("First Day of Month");
					timeConsKeys.add("Last Day of Month");

					Set timeKeyset=timeConstraints.keySet();
					ArrayList keyFrTimeConstaints = new ArrayList(timeKeyset);
					Collections.sort(keyFrTimeConstaints,new EgMaintenanceUtility());
					timeConsKeys.retainAll(keyFrTimeConstaints);
					Iterator timeKeysetItr=keyFrTimeConstaints.iterator();
					while(timeKeysetItr.hasNext())
					{
						String key=(String)timeKeysetItr.next();
						if(!timeConsKeys.contains(key))
						{
							timeConsKeys.add(key);
						}
					}

					Iterator timeConstraintsKeysItr=timeConsKeys.iterator();

		while(timeConstraintsKeysItr.hasNext())
		{
			String key=(String)timeConstraintsKeysItr.next();
			String timePeriods="";
			String timeConstraintStr="";
			
			Vector value=(Vector)timeConstraints.get(key);
			for(int	i=0;i<value.size();i++)	
			{
				timePeriods+=value.get(i);
				timePeriods+="<br>";
			}
%>
																				<tr>
																					<td	class="tdborder_ad"	valign="top"><%=key%></td>
																					<td	class="tdborder_ad"	valign="top"><%=timePeriods%></td>
																				</tr>
<%
		}
%>
																			</table>
																		</td>
																	</tr>
<%
	}
%>
																</table>
															</div>
															<div id="<%="associateServerDiv"+index%>" style="display:none;position:relative;border:0px solid #ff0000;"> 
<%
	if(maintenanceUtil.isAssociated(groupNameFromLink))	
	{
%>
																<table cellpadding="0" cellspacing="0" width="100%"	border="0" class="linebottom">
<%
		boolean	hostFlag=false;
		String hostStr="";
		String hostStr1="";
		Vector host=maintenanceUtil.getAssociatedHostsForPolicygroup(groupNameFromLink);
		Iterator hostItr=host.iterator();
		if(hostItr.hasNext()) 
		{
%>
																	<tr>
																		<td	width="100%">
																			<table border="0" class="lineborder" style="border-bottom-width:0px" cellpadding="4" cellspacing="0"	width="100%"><col width="130px"><col width="90%">
																				<tr>
																					<td	class="lineright linebg2" style="width:130px" valign="top" nowrap ><egui:intnl text ="admin.mpolicy.Host"/></td>
																					<td	class="eg_whitebg" valign="top">
<%
			while(hostItr.hasNext())
			{
				String hostName=(String)hostItr.next();
				hostStr1+=hostName;
				hostStr+=hostName;

				if(hostItr.hasNext()) 
				{
					hostStr+="<br>";
					hostStr1+=", ";
				}
			}
			out.println(hostStr1);
%>
																					</td>
																				</tr>
																			</table>
																		</td>
																	</tr>
<%
			}
			boolean	componentFlag=false;
			String componentStr="";
			String componentStr1="";
			Vector component=maintenanceUtil.getAssociatedComponentsForPolicygroup(groupNameFromLink);
			Iterator componentItr=component.iterator();
			if(componentItr.hasNext()) 
			{
%>
																	<tr>
																		<td>
																			<table border="0" class="lineborder" style="border-bottom-width:0px" cellpadding="4" cellspacing="0"	width="100%"><col width="130px"><col width="90%">
																				<tr>
																					<td	nowrap class="lineright	linebg2" style="width:130px" valign="top"><egui:intnl text = "admin.mpolicy.Component"/></td>
																					<td	class="eg_whitebg" valign="top">
<%
				while(componentItr.hasNext()) 
				{
					String componentName=(String)componentItr.next();
					componentStr+=componentName;
					componentStr1+=componentName;
					if(componentItr.hasNext()) 
					{
						componentStr+="<br>";
						componentStr1+=", ";
					}
				}
				out.println(componentStr1);
%>
																					</td>
																				</tr>
																			</table>
																		</td>
																	</tr>
<%
			}

			boolean	testFlag=false;
			String testStr="";
			String testStr1="";
			Vector test=maintenanceUtil.getAssociatedTestsForPolicygroup(groupNameFromLink);
			Iterator testItr=test.iterator();
			if(testItr.hasNext())
			{
			%>
																	<tr>
																		<td>
																			<table border="0" class="lineborder" style="border-bottom-width:0px" cellpadding="4" cellspacing="0"	width="100%"><col width="130px"><col width="90%">
																				<tr>
																					<td	nowrap class="lineright	linebg2" style="width:130px" valign="top"><egui:intnl text = "admin.mpolicy.Test"/></td>
																					<td	class="eg_whitebg" valign="top">
<%
					while(testItr.hasNext())
					{
						String testName=(String)testItr.next();
						testStr+=_mapping.getTestDescription(testName);
						testStr1+=_mapping.getTestDescription(testName);
						if(testItr.hasNext()) 
						{
							testStr+="<br>";
							testStr1+=", ";
						}
					}
					
					out.println(testStr1);
%>
																					</td>
																				</tr>
																			</table>
																		</td>
																	</tr>
<%
				}

				int	hostTestIndex=0;
				String hostTestStr="<table width='100%'	height='100%' class='lineborder' style='border-bottom-width:0px'	border='0' cellspacing='0' cellpadding='2' ><tr><td	class='linebottomright linebg'>Test</td><td	class='linebottom linebg'>Host</td></tr>";

				Hashtable hostTest=maintenanceUtil.getAssociatedTestForHostsInPolicygroup(groupNameFromLink);
				Vector hostTestVector=new Vector();

				hostTestVector.addAll(hostTest.keySet());
				boolean	hostTestFlag=false;

				if(hostTestVector.size()>0)	
				{
					Collections.sort(hostTestVector,String.CASE_INSENSITIVE_ORDER);
%>
																	<tr>
																		<td>
																			<table border="0" class="lineborder" style="border-bottom-width:0px" cellpadding="4" cellspacing="0"	width="100%"><col width="130px"><col width="90%">
																				<tr>
																					<td	nowrap class="lineright	linebg2" valign="top" style="width:130px"><egui:intnl text = "admin.mpolicy.Host Tests"/></td>
																					<td	style="width:100%;height:100%;padding:0px" colspan="2">
																						<table width="100%"	border="0" cellpadding="4" cellspacing="0">
																							<tr>
																								<td	class="linebottomright linebg3"	valign="top" style="width:150px"><egui:intnl	text ="admin.mpolicy.Test"/></td>
																								<td	class="linebottom linebg3" valign="top"	colspan="2"><egui:intnl	text ="admin.mpolicy.Host"/></td>
																							</tr>
																							<%
					if(hostTestVector.size()>2)
						hostTestFlag=true;

					for(int	i=0;i<hostTestVector.size();i++) 
					{
						String testname=(String)hostTestVector.get(i);
						hostTestStr+="<tr valign='top'><td class='linebottomright linebg2'>"+_mapping.getTestDescription(testname)+"</td><td class='linebottom linebg2'>";
						Vector hosts=(Vector)hostTest.get(testname);
						Collections.sort(hosts,String.CASE_INSENSITIVE_ORDER);
						String hostsInStr="";
						for(int	j=0;j<hosts.size();j++)	
						{
							hostTestStr+=hosts.get(j)+"<br>";
							hostsInStr+=hosts.get(j);
							if(j<hosts.size()-1)
								hostsInStr+=", ";
						}
						hostTestStr+="</td></tr>";
																							%>
																							<tr>
																								<td	class="<%=((i!=hostTestVector.size()-1)?"linebottom":"")%> eg_whitebg" valign="top" style="width:150px"><%=_mapping.getTestDescription(testname)%></td>
																								<td	class="<%=((i!=hostTestVector.size()-1)?"linebottom":"")%> eg_whitebg" valign="top" wrap>
<%
					out.println(hostsInStr);
%>
																									</td>
																							</tr>
<%
						hostTestIndex++;
				}
%>
																						</table>
																					</td>
																				</tr>
																			</table>
																		</td>
																	</tr>
<%
			}
			int descTestIndex=0;
			String descTestStr="<table width='100%'	height='100%' class='lineborder' style='border-bottom-width:0px'	border='0' cellspacing='0' cellpadding='2' ><tr><td	class='linebottomright linebg'>Test</td><td	class='linebottom linebg'>Host</td></tr>";
			Hashtable descTest=new Hashtable();
			if(groupNameFromLink!=null)
			{
				descTest=maintenanceUtil.getAssociatedTestDescriptorInPolicyGroup(groupNameFromLink);
			}
			Vector descTestVector=new Vector();
			descTestVector.addAll(descTest.keySet());
			boolean	descTestFlag=false;
			if(descTestVector.size()>0)	
			{
				Collections.sort(descTestVector,String.CASE_INSENSITIVE_ORDER);
%>
					<tr>
						<td>
							<table border="0" class="lineborder" style="border-bottom-width:0px" cellpadding="4" cellspacing="0"	width="100%"><col width="130px"><col width="90%">
								<tr>
									<td	nowrap class="lineright	linebg2" valign="top" style="width:130px"><egui:intnl text = "admin.mpolicy.Test Descriptors"/></td>
									<td	style="width:100%;height:100%;padding:0px" colspan="2">
										<table width="100%"	border="0" cellpadding="4" cellspacing="0">
											<tr>
												<td	class="linebottomright linebg3"	valign="top" style="width:150px"><egui:intnl	text ="admin.mpolicy.Test"/></td>
												<td	class="linebottom linebg3" valign="top"	colspan="2"><egui:intnl	text ="admin.mpolicy.Descriptors"/></td>
											</tr>
<%
					if(descTestVector.size()>2)
						descTestFlag=true;
					for(int	i=0;i<descTestVector.size();i++) 
					{
						String testname=(String)descTestVector.get(i);
						descTestStr+="<tr valign='top'><td class='linebottomright linebg2'>"+_mapping.getTestDescription(testname)+"</td><td class='linebottom linebg2'>";
						ArrayList descriptors=(ArrayList)descTest.get(testname);
						Collections.sort(descriptors,String.CASE_INSENSITIVE_ORDER);
						String descriptorsInStr="";
						for(int	j=0;j<descriptors.size();j++)	
						{
							descTestStr+=descriptors.get(j)+"<br>";
							descriptorsInStr+=descriptors.get(j);
							if(j<descriptors.size()-1)
								descriptorsInStr+=", ";
						}
						descTestStr+="</td></tr>";
%>
<tr>
					<td	class="<%=((i!=descTestVector.size()-1)?"linebottom":"")%> eg_whitebg" valign="top" style="width:150px"><%=_mapping.getTestDescription(testname)%></td>
					<td	class="<%=((i!=descTestVector.size()-1)?"linebottom":"")%> eg_whitebg" valign="top" wrap>
<%
					out.println(descriptorsInStr);
%>
					</td>
				</tr>
<%
					descTestIndex++;
				}
%>
							</table>
						</td>
					</tr>
				</table>
			</td>
			</tr>
<%
			}
			int desccompTestIndex=0;
			String desccompTestStr="<table width='100%'	height='100%' class='lineborder' style='border-bottom-width:0px'	border='0' cellspacing='0' cellpadding='2' ><tr><td	class='linebottomright linebg'>Test</td><td	class='linebottom linebg'>Host</td></tr>";
			Hashtable desccompTest=new Hashtable();
			if(groupNameFromLink!=null)
			{
				desccompTest=maintenanceUtil.getAssociatedComponentDescriptorInPolicyGroup(groupNameFromLink);
			}
			Vector desccompTestVector=new Vector();
			desccompTestVector.addAll(desccompTest.keySet());
			boolean	desccompTestFlag=false;
			if(desccompTestVector.size()>0)	
			{
				Collections.sort(desccompTestVector,String.CASE_INSENSITIVE_ORDER);
%>
					<tr>
						<td>
							<table border="0" class="lineborder" style="border-bottom-width:0px" cellpadding="4" cellspacing="0"	width="100%"><col width="130px"><col width="90%">
								<tr>
									<td	nowrap class="lineright	linebg2" valign="top" style="width:130px"><egui:intnl text = "admin.mpolicy.Component Descriptors"/></td>
									<td	style="width:100%;height:100%;padding:0px" colspan="2">
										<table width="100%"	border="0" cellpadding="4" cellspacing="0">
											<tr>
												<td	class="linebottomright linebg3"	valign="top" style="width:150px"><egui:intnl	text ="admin.mpolicy.Component"/></td>
												<td	class="linebottom linebg3" valign="top"	colspan="2"><egui:intnl	text ="admin.mpolicy.Descriptors"/></td>
											</tr>
<%
					if(desccompTestVector.size()>2)
						desccompTestFlag=true;
					for(int	i=0;i<desccompTestVector.size();i++) 
					{
						String testname=(String)desccompTestVector.get(i);
						descTestStr+="<tr valign='top'><td class='linebottomright linebg2'>"+_mapping.getTestDescription(testname)+"</td><td class='linebottom linebg2'>";
						ArrayList component_descriptors=(ArrayList)desccompTest.get(testname);
						Collections.sort(component_descriptors,String.CASE_INSENSITIVE_ORDER);
						String componentdescriptorsInStr="";
						for(int	j=0;j<component_descriptors.size();j++)	
						{
							desccompTestStr+=component_descriptors.get(j)+"<br>";
							String tmp_componentdescriptorsInStr=component_descriptors.get(j).toString();
							tmp_componentdescriptorsInStr=tmp_componentdescriptorsInStr.substring(tmp_componentdescriptorsInStr.indexOf(":")+1);
							componentdescriptorsInStr+=tmp_componentdescriptorsInStr;
							if(j<component_descriptors.size()-1)
							{
								componentdescriptorsInStr+=", ";
							}
						}
						desccompTestStr+="</td></tr>";
%>
				<tr>
					<td	class="<%=((i!=desccompTestVector.size()-1)?"linebottom":"")%> eg_whitebg" valign="top" style="width:150px"><%=_mapping.getTestDescription(testname)%></td>
					<td	class="<%=((i!=desccompTestVector.size()-1)?"linebottom":"")%> eg_whitebg" valign="top" wrap>
<%
					out.println(componentdescriptorsInStr);
%>
					</td>
				</tr>
<%
						desccompTestIndex++;
				}
%>
							</table>
						</td>
					</tr>
				</table>
			</td>
			</tr>
<%
			}
			int	componentTestIndex=0;
			boolean	componentTestFlag=false;
			String compName="";
			String compTest="";
			Hashtable componentTest=maintenanceUtil.getAssociatedTestForComponentsInPolicyGroup(groupNameFromLink);
			Vector componetTestVector=new Vector();
			componetTestVector.addAll(componentTest.keySet());
			if(componetTestVector.size()>0)	
			{
				Collections.sort(componetTestVector,String.CASE_INSENSITIVE_ORDER);
%>
																	<tr>
																		<td>
																			<table border="0" class="lineborder" style="border-bottom-width:0px" cellpadding="4" cellspacing="0"	width="100%"><col width="130px"><col width="90%">
																				<tr>
																					<td	style="width:130px"	nowrap class="lineright	linebg2" valign="top"><egui:intnl text ="admin.mpolicy.Component Tests"/></td>
																					<td	style="width:100%;height:100%;padding:0px" colspan="2" >
																						<table width="100%"	 border="0"	cellpadding="4"	cellspacing="0"	>
																							<tr>
																								<td	class="linebottomright linebg3"	valign="top" style="width:150px"><egui:intnl	text ="admin.mpolicy.Test"/></td>
																								<td	class="linebottom linebg3" valign="top"	colspan="2"><egui:intnl	text ="admin.mpolicy.Component"/></td>
																							</tr>
																							
<%
				if(componetTestVector.size()>2)
					componentTestFlag=true;
				for(int	i=0;i<componetTestVector.size();i++)
				{
					String testname=(String)componetTestVector.get(i);
					Vector components=(Vector)componentTest.get(testname);
					Collections.sort(components,String.CASE_INSENSITIVE_ORDER);
					String componentsInStr="";
					for(int	j=0;j<components.size();j++) 
					{
						componentsInStr+=components.get(j);
						if(j<components.size()-1)
							componentsInStr+=",	";
					}
%>
																							<tr>
																								<td	class="<%=((i!=componetTestVector.size()-1)?"linebottom": "")%>	eg_whitebg"	style="width:150px"	valign="top"><%=_mapping.getTestDescription(testname)%></td>
																								<td	class="<%=((i!=componetTestVector.size()-1)?"linebottom": "")%>	eg_whitebg"	valign="top" wrap >
<%
					out.println(componentsInStr);
%>
																									</td>
																							</tr>
<%
				}
%>
																						</table>
																					</td>
																				</tr>
																			</table>
																		</td>
																	</tr>
<%
			}
%>
																</table>
<%
		}
		else
		{
%>
																<table border="0" class="lineborder" cellpadding="4" cellspacing="0" width="100%">
																	<tr>
																		<td	align="center" valign="center">
																		<img src="/final/admin/eg_images/<%=admin_Skin%>/exclamation-icon.gif"/>
																			<br>
																			<b><egui:intnl text	= "admin.mpolicy.No	Associated Elements"/></b>
																		</td>
																	</tr>
																</table>
<%
		}
%>
															</div> 
														</td>
													</tr>
												</table>
											</td>
										</tr>
									</table>
								</td>
							</tr>
							<tr>
								<td	><img src="/final/admin/eg_images/spacer.gif" height="11"></td>
							</tr>
						</table>
<%
		index++;
	}
	else
	{
		while(groupsItr.hasNext())
		{
			divId++;
			isGroupsFound=true;
			String policyGroupName=(String)groupsItr.next();
			boolean isGroupMatchWithSearch=false;
			if(egTitleSearchStr!=null && egTitleSearchStr.length()>0)
			{
				StringTokenizer searchTokenizer=new StringTokenizer(egTitleSearchStr," ");
				while(searchTokenizer.hasMoreTokens())
				{
					String searchToken=searchTokenizer.nextToken();
					if((searchToken!=null) && ((policyGroupName.toUpperCase()).indexOf(searchToken.toUpperCase())!=-1))
					{
						isGroupMatchWithSearch=true;
						break;
					}
				}
			}
			else if(egTitleSearchStr!=null)
			{
				isGroupMatchWithSearch=true;
			}


			if((egTitleSearchStr==null)||(policyGroupName!=null	&& isGroupMatchWithSearch))
			{
				isSearchStrNotFound=false;
%>
						<table align="center" border="0" cellpadding="0" cellspacing="0" width="95%">
							<tr>
								<td	width="100%" >
									<table cellpadding="0" cellspacing="0" width="100%"	border="0">
										<tr>
											<td> <img src="/final/admin/eg_images/policygroup.gif"	width="20" height="20" ></td>
											<td	width="100%" >&nbsp;<b>	<%=policyGroupName%></b></td>
										</tr>
									</table>
								</td>
							</tr>
							<tr>
								<td	><img src="/final/admin/eg_images/spacer.gif" height="5"></td>
							</tr>
							<tr>
								<td>
									<table cellpadding="0" cellspacing="0" width="100%" border="0">
										<tr>
											<td class="linebottom_image">
												<table border="0" cellpadding="0" cellspacing="0" width="100%">
													<tr>
														<td valign="bottom">
															<table border="0" cellpadding="0" cellspacing="0">
																<tr>
																	<td align="left">
																		<table border="0" bordercolor="blue" cellpadding="0" cellspacing="0">
																			<tr>
																				<td id="policiess<%=index%>"  class="page_tab_left_curve_light"  width="4" height="20" ><img src="/final/admin/eg_images/spacer.gif" width="4" height="20" border="0"></td>
																				<td id="policy<%=index%>"  class="page_tab_bg_light" nowrap><a href="javascript:void(0);" id="policya<%=index%>" class="page_tablink" onclick="javascript:showDiv('policy','<%=index%>'
																				,'<%=index%>');"><egui:intnl text="admin.mpolicy.Policies"/></a> </td>
																				<td id="policies<%=index%>"  class="page_tab_right_curve_light" width="4" height="20"><img src="/final/admin/eg_images/spacer.gif" width="4" height="20" border="0"></td>
																			</tr>
																		</table>
																	</td>
																	<td>&nbsp;</td>
																	<td align="left">
																		<table border="0" cellpadding="0" cellspacing="0" >
																			<tr>
																				<td id="elementss<%=index%>" class="page_tab_left_curve_dark"  width="4" height="20"><img src="/final/monitor/eg_images/spacer.gif" width="4" height="20" border="0"></td>
																				<td id="element<%=index%>" class="page_tab_bg_dark" nowrap><a href="javascript:void(0);" id="elementa<%=index%>"  class="page_tablink_dark"  onclick="javascript:showDiv('associate','<%=index%>','<%=index%>');"><egui:intnl text="admin.mpolicy.Associated Elements"/></a></td>
																				<td id="elements<%=index%>" class="page_tab_right_curve_dark" width="4" height="20" ><img src="/final/monitor/eg_images/spacer.gif" width="4" height="20" border="0"></td>
																			</tr>
																		</table>
																	</td>
																</tr>
															</table>
														</td>
														<td width="90%" align="right">&nbsp;</td>
													</tr>
												</table>
											</td>
										</tr>

										<!------------------------------------------------>
										
										<tr>
											<td	width="100%" class="page_tab_border page_tab_bg" style="padding:4px;border-top-width:0px">
												<table border="0" cellpadding="0" cellspacing="0" width="100%" >
													<tr>
														<td>
															<div id="<%="associatedPolicyDiv"+index%>" style="display:block;position:relative;border:0px solid	#ff00cc"> 
																<table border="0" class="lineborder"  style="border-bottom-width:0px; table-layout:auto" cellpadding="4"	cellspacing="0"	width="100%" align="center"><col width="60%"><col width="150px"><col width="150px"><col width="20px">
																	<tr>
																		<td	class="linebottomright linebg3"	valign="top" style="width:60%"><egui:intnl text="admin.mpolicy.PolicyName"/></td>
																		<td	class="linebottomright linebg3"	valign="top" style="width:150px"><egui:intnl text="admin.mpolicy.Time Frequency"/></td>
																		<td	class="linebottom linebg3" valign="top"	style="width:150px"><egui:intnl	text="admin.mpolicy.Timeline"/></td>
																		<td	valign="top" class="linebottom linebg3"	style="width:20px">&nbsp;</td>
																	</tr>
<%
			Vector policies=(Vector)policyGroup.get(policyGroupName);
			boolean	policyFlag=false;
			int	policyIndex=0;
			String policyDetails="<table border='0px' width='100%' class='lineborder'  style='border-bottom-width:0px'	width=100% cellspacing='0px' cellpadding='4px' >";
			policyDetails+="<tr>";
			policyDetails+="<td	style='width:140' class='linebottomright linebg3'>PolicyName</td>";
			policyDetails+="<td	style='width:150' class='linebottomright linebg3'>Time Constraint</td>";
			policyDetails+="<td	style='width:110' class='linebottomright linebg3'>Time periods</td>";
			policyDetails+="</tr>";
			Iterator itr=policies.iterator();
			while(itr.hasNext())
			{
				String policyName=(String)itr.next();
				
				policyDetails+="<tr><td	style='width:140' valign='top' class='linebottom linebg2'>"+policyName+"</td>";
				policyDetails+="<td	style='width:274' valign='top' class='linebottom linebg2' colspan='2'>";
				policyDetails+="<table border='0'  width='100%'	cellspacing='0'	cellpadding='4'	class='tableborder_ad'>";
				if(policyIndex<2)
				{
			%>
																	<tr>
																		<td	valign="top" class="linebottom linebg2"	style="width:70%"> <%=policyName%> </td>
																		<td	valign="top" class="linebottom linebg2"	colspan="2"	style="width:300px">
																			<table border="0" class="tableborder_ad" width="100%" cellspacing="0" cellpadding="3"><col width="150px"><col	width="150px">
<%
				}
				Hashtable timeConstraints=maintenanceUtil.getPolicyTimeLines(policyName);
				Set timeKeyset = timeConstraints.keySet();
				ArrayList keyFrTimeConstaints = new ArrayList(timeKeyset);
				Collections.sort(keyFrTimeConstaints,new EgMaintenanceUtility());
				Iterator timeConstraintsKeys = keyFrTimeConstaints.iterator();
				while(timeConstraintsKeys.hasNext())
				{
					String key=(String)timeConstraintsKeys.next();
					String timePeriods="";
					String timeConstraintStr="";
					
					Vector value=(Vector)timeConstraints.get(key);
					for(int	i=0;i<value.size();i++)
					{
						timePeriods+=value.get(i);
						timePeriods+="<br>";
					}
					policyDetails+="<tr>";
					policyDetails+="<td	style='width:150' class=tdborder_ad>"+key+"</td>";
					policyDetails+="<td	style='width:110' class=tdborder_ad>"+timePeriods+"</td>";
					policyDetails+="</tr>";
					
					if(policyIndex<2)
					{
%>
																				
																				<tr>
																					<td	class=tdborder_ad nowrap  style="width:150px"><%=key%></td>
																					<td	class=tdborder_ad nowrap  style="width:150px"><%=timePeriods%></td>
																				</tr>
						<%
					}
				}
				policyDetails+="</table>";
				policyDetails+="</td>";
				policyDetails+="</tr>";

				if(policyIndex<2)
				{
%>
																			</table>
																		</td>
<%
					if(policyIndex==0 && policies.size()>2)
					{
%>
																		<td	valign="top" class="linebottom linebg2"	 style="width:20px"> <img class="mouse"	onclick="javascript:showAssociatedElements(event,'<%="policyDetails"+index%>')"	src="/final/admin/eg_images/headarrow_forward.gif" title="More Policies"/> </td>
<%
					}
					else
					{
%>
																		<td	valign="top" class="linebottom linebg2"	style="width:20px">&nbsp;</td>
<%
					}
%>
																	</tr>
<%
				}
				policyIndex++;
			}
			policyDetails+="</table>";
%>
																	
																	<input type="hidden" id="<%="policyDetails"+index%>" value="<%="Policies#"+policyDetails%>">
																	
																</table>
															</div>
															<div id="<%="associateServerDiv"+index%>" style="display:none;position:relative;border:0px solid #ff0000;"> 
<%
			if(maintenanceUtil.isAssociated(policyGroupName))
			{
%>
																<table cellpadding="0" cellspacing="0" width="100%"	border="0" class="linebottom">
<%
					boolean	hostFlag=false;
					String hostStr="";
					String hostStr1="";
					Vector host=maintenanceUtil.getAssociatedHostsForPolicygroup(policyGroupName);
					Iterator hostItr=host.iterator();
					if(hostItr.hasNext())
					{
%>
																	<tr>
																		<td	width="100%">
																			<table border="0" class="lineborder" style="border-bottom-width:0px" cellpadding="4" cellspacing="0"	width="100%"><col width="130px"><col width="85%">
																				<tr>
																					<td	class="lineright linebg2" style="width:130px" valign="top" nowrap ><egui:intnl text ="admin.mpolicy.Host"/></td>
																					<td	class="eg_whitebg" valign="top">
<%
						while(hostItr.hasNext())
						{
							String hostName=(String)hostItr.next();
							hostStr1+=hostName;
							hostStr+=hostName;
							
							if(hostItr.hasNext())
							{
								hostStr+="<br>";
								hostStr1+=", ";
							}
							}
							if(hostStr1.length()>105)
							{
								display=hostStr1.substring(0,105);
								if(display.lastIndexOf(",")==104)
								{
								display=display.substring(0,104);
								}
								out.println(display+"...");
								hostFlag=true;
								}
								else
								{
								out.println(hostStr1);
								}
%>
																					</td>
<%
								if(hostFlag)
								{
%>
																					<td	class="eg_whitebg" valign="top">
																						<input type="hidden" id="<%="host"+index%>"	value="<%="Hosts#<table	width='100%' class='lineborder' style='border-bottom-width:0px' border='0' cellspacing='0' cellpadding='2' ><tr><td	class='linebottomright linebg2' valign='top'>More Host(s)</td><td class='linebottom eg_whitebg' valign='top'>"+hostStr+"</td></tr></table>"%>">	<img class="mouse" onclick="javascript:showAssociatedElements(event,'<%="host"+index%>')" src="/final/admin/eg_images/headarrow_forward.gif" title="More Hosts"/>
																					</td>
<%
									}
									else
									{
%>
																					<td	class="eg_whitebg" valign="top">&nbsp;</td>	
<%
									}
%>
																				</tr>
																			</table>
																		</td>
																	</tr>
<%
								}
								boolean	componentFlag=false;
								String componentStr="";
								String componentStr1="";
								Vector component=maintenanceUtil.getAssociatedComponentsForPolicygroup(policyGroupName);
								Iterator componentItr=component.iterator();

								if(componentItr.hasNext())
								{
%>
																	<tr>
																		<td>
																			<table border="0" class="lineborder" style="border-bottom-width:0px" cellpadding="4" cellspacing="0"	width="100%"><col width="130px"><col width="85%">
																				<tr>
																					<td	nowrap class="lineright	linebg2" style="width:130px" valign="top"><egui:intnl text = "admin.mpolicy.Component"/></td>
																					<td	class="eg_whitebg" valign="top">
<%
								while(componentItr.hasNext())
								{
									String componentName=(String)componentItr.next();
									if ( !StringUtils.isNull(componentName) && componentName.endsWith(":NULL") )
									{
										componentName = componentName.substring(0, componentName.lastIndexOf(":") );
									}
									componentStr+=componentName;
									componentStr1+=componentName;
									if(componentItr.hasNext())
									{
										componentStr+="<br>";
										componentStr1+=", ";
									}
								}

								if(componentStr1.length()>105)
								{
									display=componentStr1.substring(0,105);
									if(display.lastIndexOf(",")==104)
									{
										display=display.substring(0,104);
									}
									out.println(display+"...");
									componentFlag=true;
								}
								else
								{
									out.println(componentStr1);
								}
%>
																					</td>
<%
								if(componentFlag)
								{
%>
																					<td	class="eg_whitebg" valign="top">
																						<input type="hidden" id="<%="component"+index%>" value="<%="Components#<table width='100%' class='lineborder' style='border-bottom-width:0px'	border='0' cellspacing='0' cellpadding='2' ><tr><td class='linebottomright	linebg2' valign='top'>More Component(s)</td><td	class='linebottom eg_whitebg' valign='top'>"+componentStr+"</td></tr></table>"%>">
																						<img class="mouse" onclick="javascript:showAssociatedElements(event,'<%="component"+index%>')" src="/final/admin/eg_images/headarrow_forward.gif"	title="More	Components"/>
																					</td>
<%
							}
							else
							{
%>
																					<td	class="eg_whitebg" valign="top">&nbsp;</td>	
<%
							}
%>
																				</tr>
																			</table>
																		</td>
																	</tr>
<%
					}

					boolean	testFlag=false;
					String testStr="";
					String testStr1="";
					Vector test=maintenanceUtil.getAssociatedTestsForPolicygroup(policyGroupName);
					Iterator testItr=test.iterator();
					if(testItr.hasNext())
					{
%>
																	<tr>
																		<td>
																			<table border="0" class="lineborder" style="border-bottom-width:0px" cellpadding="4" cellspacing="0"	width="100%"><col width="130px"><col width="85%">
																				<tr>
																					<td	nowrap class="lineright	linebg2" style="width:130px" valign="top"><egui:intnl text = "admin.mpolicy.Test"/></td>
																					<td	class="eg_whitebg" valign="top">
<%
								while(testItr.hasNext())
								{
									String testName=(String)testItr.next();
									testStr+=_mapping.getTestDescription(testName);
									testStr1+=_mapping.getTestDescription(testName);
									if(testItr.hasNext())
									{
										testStr+="<br>";
										testStr1+=", ";
									}
								}
								
								if(testStr1.length()>105)
								{
									display=testStr1.substring(0,105);
									if(display.lastIndexOf(",")==104)
									{
										display=display.substring(0,104);
									}
									out.println(display+"...");
									testFlag=true;
								}
								else
								{
									out.println(testStr1);
								}
%>
																					</td>
<%
								if(testFlag)
								{
%>
																					<td	class="eg_whitebg" valign="top">
																						<input type="hidden" id="<%="test"+index%>"	value="<%="Tests#<table	width='100%'  class='lineborder' style='border-bottom-width:0px' border='0' cellspacing='0' cellpadding='2' ><col width='30%'><col width='70%'><tr><td	class='linebottomright linebg2'	valign='top'>More Test(s)</td><td	class='linebottom eg_whitebg' valign='top'>"+testStr+"</td></tr></table>"%>">
																						<img class="mouse" onclick="javascript:showAssociatedElements(event,'<%="test"+index%>')" src="/final/admin/eg_images/headarrow_forward.gif" title="More Tests"/>
																					</td>
<%
								}
								else
								{
%>
																					<td	class="eg_whitebg" valign="top">&nbsp;</td>	
<%
								}
%>
																				</tr>
																			</table>
																		</td>
																	</tr>
<%
						}
						
						int	hostTestIndex=0;
						String hostTestStr="<table width='100%'	height='100%' class='lineborder' style='border-bottom-width:0px'	border='0' cellspacing='0' cellpadding='2' ><tr><td	class='linebottomright linebg'>Test</td><td	class='linebottom linebg'>Host</td></tr>";
						Hashtable hostTest=maintenanceUtil.getAssociatedTestForHostsInPolicygroup(policyGroupName);
						Vector hostTestVector=new Vector();
						hostTestVector.addAll(hostTest.keySet());
						boolean	hostTestFlag=false;
					
						if(hostTestVector.size()>0)
						{
							Collections.sort(hostTestVector,String.CASE_INSENSITIVE_ORDER);
%>
																	<tr>
																		<td>
																			<table border="0" class="lineborder" style="border-bottom-width:0px" cellpadding="4" cellspacing="0"	width="100%"><col width="130px"><col width="90%">
																				<tr>
																					<td	nowrap class="lineright	linebg2" valign="top" style="width:130px"><egui:intnl text = "admin.mpolicy.Host Tests"/></td>
																					<td	style="width:100%;height:100%;padding:0px" colspan="2">
																						<table width="100%"	border="0" cellpadding="2" cellspacing="0">
																							<tr>
																								<td	class="linebottomright linebg3"	valign="top" style="width:150px"><egui:intnl	text ="admin.mpolicy.Test"/></td>
																								<td	class="linebottom linebg3" valign="top"	colspan="2"><egui:intnl	text ="admin.mpolicy.Host"/></td>
																							</tr>
<%
						if(hostTestVector.size()>2)
							hostTestFlag=true;
							
						for(int	i=0;i<hostTestVector.size();i++)
						{
							String testname=(String)hostTestVector.get(i);
							hostTestStr+="<tr valign='top'><td class='linebottomright linebg2'>"+_mapping.getTestDescription(testname)+"</td><td class='linebottom eg_whitebg'>";
							Vector hosts=(Vector)hostTest.get(testname);
							Collections.sort(hosts,String.CASE_INSENSITIVE_ORDER);
							String hostsInStr="";
							for(int	j=0;j<hosts.size();j++)
							{
								hostTestStr+=hosts.get(j)+"<br>";
								hostsInStr+=hosts.get(j);
								if(j<hosts.size()-1)
									hostsInStr+=", ";
							}
							hostTestStr+="</td></tr>";
							if(i<2)
							{
%>
																							<tr>
																								<td	class="<%=((i==0)?"linebottom":"")%> eg_whitebg" valign="top" style="width:150px"><%=_mapping.getTestDescription(testname)%></td>
																								<td	class="<%=((i==0)?"linebottom":"")%> eg_whitebg" valign="top" wrap>
<%
								if(hostsInStr.length()>75)
								{
								display=hostsInStr.substring(0,75);
								if(display.lastIndexOf(",")==74)
								{
								display=display.substring(0,74);
								}
								out.println(display+"...");
								hostTestFlag=true;
								}
								else
								{
								out.println(hostsInStr);
								}
%>
																									</td>
<%
								if(hostTestFlag	&& i==0)
								{
%>
																								<td	class="<%=((i==0)?"linebottom":"")%> eg_whitebg"  align="right"	style="width:25px" valign="center">
																									<img class="mouse" onclick="javascript:showAssociatedElements(event,'<%="hostTest"+index%>')" src="/final/admin/eg_images/headarrow_forward.gif" title="More Host Tests"/>
																								</td>
<%
									hostTestFlag=false;
								}
								else
								{
%>
																								<td	align="right" class="<%=((i==0)?"linebottom":"")%> eg_whitebg">&nbsp;</td>
<%
								}
%>
																							</tr>
<%
							}
							hostTestIndex++;
						}
						hostTestStr+="</table>";
%>
																						</table>
																					</td>
																					<input type="hidden" id="<%="hostTest"+index%>"	value="<%="host	Tests#"+hostTestStr%>">
																				</tr>
																			</table>
																		</td>
																	</tr>
<%
				}

				int	componentTestIndex=0;
				boolean	componentTestFlag=false;
				String componentTestStr="<table	width='100%' height='100%' class='lineborder' style='border-bottom-width:0px'	border='0' cellspacing='0' cellpadding='2' ><tr><td	class='linebottomright linebg'>TEST</td><td	class='linebottomright linebg' >COMPONENT</td></tr>";
				String compName="";
				String compTest="";
				Hashtable componentTest=maintenanceUtil.getAssociatedTestForComponentsInPolicyGroup(policyGroupName);
				Vector componetTestVector=new Vector();
				componetTestVector.addAll(componentTest.keySet());
				if(componetTestVector.size()>0)
				{
					Collections.sort(componetTestVector,String.CASE_INSENSITIVE_ORDER);
%>
																	<tr>
																		<td>
																			<table border="0" class="lineborder" style="border-bottom-width:0px" cellpadding="4" cellspacing="0"	width="100%"><col width="130px"><col width="90%">
																				<tr>
																					<td	nowrap class="lineright	linebg2" style="width:130px" valign="top"><egui:intnl text ="admin.mpolicy.Component Tests"/></td>
																					<td	style="width:100%;height:100%;padding:0px" colspan="2">
																						<table width="100%"	 border="0"	cellpadding="2"	cellspacing="0"	>
																							<tr>
																								<td	class="linebottomright linebg3"	valign="top" style="width:150px"><egui:intnl	text ="admin.mpolicy.Test"/></td>
																								<td	class="linebottom linebg3" valign="top"	colspan="2"><egui:intnl	text ="admin.mpolicy.Component"/></td>
																							</tr>
<%
					if(componetTestVector.size()>2)
					componentTestFlag=true;
					for(int	i=0;i<componetTestVector.size();i++)
					{
						String testname=(String)componetTestVector.get(i);
						componentTestStr+="<tr valign='top'><td	class='linebottomright linebg2'>"+_mapping.getTestDescription(testname)+"</td><td	class='linebottom eg_whitebg'>";
						Vector components=(Vector)componentTest.get(testname);
						Collections.sort(components,String.CASE_INSENSITIVE_ORDER);
						String componentsInStr="";
						for(int	j=0;j<components.size();j++)
						{
								componentTestStr+=components.get(j)+"<br>";
								componentsInStr+=components.get(j);
								if(j<components.size()-1)
								componentsInStr+=",	";
								}
								componentTestStr+="</td></tr>";
								if(componentTestIndex<2)
								{
%>
																							<tr>
																								<td	class="<%=((componentTestIndex==0)?"linebottom": "")%> eg_whitebg" style="width:150px"	valign="top"><%=_mapping.getTestDescription(testname)%></td>
																								<td	class="<%=((componentTestIndex==0)?"linebottom": "")%> eg_whitebg" valign="top" wrap >
<%
									if(componentsInStr.length()>75)
									{
									display=componentsInStr.substring(0,75);
									if(display.lastIndexOf(",")==74)
									{
									display=display.substring(0,74);
									}
									out.println(display+"...");
									componentTestFlag=true;
									}
									else
									{
									out.println(componentsInStr);
									}
%>
																									</td>
<%
								if(componentTestFlag &&	componentTestIndex==0)
								{
%>
																								<td	align="right" class="<%=((componentTestIndex==0)?"linebottom": "")%> eg_whitebg"	style="width:25px" valign="center">
																									<img class="mouse" onclick="javascript:showAssociatedElements(event,'<%="componentTest"+index%>')" src="/final/admin/eg_images/headarrow_forward.gif" title="More	Component Tests"/>
																								</td>
<%
									componentTestFlag=false;
								}
								else
								{
%>
																								<td	align="right" class="<%=((componentTestIndex==0)?"linebottom": "")%> eg_whitebg">&nbsp;</td>
<%
								}
%>
																							</tr>
<%
							}
							else
							{
								componentTestFlag=true;
							}
							componentTestIndex++;
						}
						componentTestStr+="</table>";
%>
																						</table>
																					</td>
																					<input type="hidden" id="<%="componentTest"+index%>" value="<%="Component Test#"+componentTestStr%>">
																				</tr>
																			</table>
																		</td>
																	</tr>
																	<%
			}
			int	desTestIndex=0;
			boolean	desTestFlag=false;

			Hashtable testDescriptor=null;
			if(groupNameFromLink!=null)
			{
				testDescriptor=maintenanceUtil.getAssociatedTestDescriptorInPolicyGroup(groupNameFromLink);
			}
			else
			{
				testDescriptor=maintenanceUtil.getAssociatedTestDescriptorInPolicyGroup(policyGroupName);
			}
			Vector DesTestVector=new Vector();
			DesTestVector.addAll(testDescriptor.keySet());

			if(DesTestVector.size()>0)	
			{
				Collections.sort(DesTestVector,String.CASE_INSENSITIVE_ORDER);

%>
<tr>
	<td>
		<table border="0" class="lineborder" style="border-bottom-width:0px" cellpadding="4" cellspacing="0"	width="100%"><col width="130px"><col width="90%">
			<tr>
				<td	style="width:130px"	nowrap class="lineright	linebg2" valign="top"><egui:intnl text ="admin.mpolicy.Test Descriptors"/></td>
				<td	style="width:100%;height:100%;padding:0px" colspan="2" >
					<table width="100%"	 border="0"	cellpadding="4"	cellspacing="0"	>
						<tr>
							<td	class="linebottomright linebg3"	valign="top" style="width:150px"><egui:intnl	text ="admin.mpolicy.Test"/></td>
							<td	class="linebottom linebg3" valign="top"	colspan="2"><egui:intnl	text ="admin.mpolicy.Descriptors"/></td>
						</tr>
																							
<%
				if(DesTestVector.size()>2)
					desTestFlag=true;
				for(int	i=0;i<DesTestVector.size();i++)
				{
					String testname=(String)DesTestVector.get(i);
					ArrayList desobj=(ArrayList)testDescriptor.get(testname);
					Collections.sort(desobj,String.CASE_INSENSITIVE_ORDER);
					String InfoInStr="";
					for(int	j=0;j<desobj.size();j++) 
					{
						InfoInStr+=desobj.get(j);
						if(j<desobj.size()-1)
							InfoInStr+=",	";
					}
				
%>
							<tr>
								<td	class="eg_whitebg"	style="width:150px"	valign="top"><egui:intnl test="<%=testname%>"/>
								</td>
								<td	class="eg_whitebg"	valign="top" wrap ><%=InfoInStr%>

									</td>
							</tr>
<%
						}
%>
						</table>
					</td>
				</tr>
			</table>
		</td>
	</tr>
<%
			}
			int	descompIndex=0;
			boolean	descompFlag=false;
			Hashtable compDescriptor=null;
			if(groupNameFromLink!=null)
			{
			compDescriptor=maintenanceUtil.getAssociatedComponentDescriptorInPolicyGroup(groupNameFromLink);
			}
			else
			{
			compDescriptor=maintenanceUtil.getAssociatedComponentDescriptorInPolicyGroup(policyGroupName);
			}
			Vector DesCompVector=new Vector();
			DesCompVector.addAll(compDescriptor.keySet());
			if(DesCompVector.size()>0)	
			{
				Collections.sort(DesCompVector,String.CASE_INSENSITIVE_ORDER);

%>
<tr>
	<td>
		<table border="0" class="lineborder" style="border-bottom-width:0px" cellpadding="4" cellspacing="0"	width="100%"><col width="130px"><col width="90%">
			<tr>
				<td	style="width:130px"	nowrap class="lineright	linebg2" valign="top"><egui:intnl text ="admin.mpolicy.Component Descriptors"/></td>
				<td	style="width:100%;height:100%;padding:0px" colspan="2" >
					<table width="100%"	 border="0"	cellpadding="4"	cellspacing="0"	>
						<tr>
							<td	class="linebottomright linebg3"	valign="top" style="width:150px"><egui:intnl	text ="admin.mpolicy.Component"/></td>
							<td	class="linebottom linebg3" valign="top"	colspan="2"><egui:intnl	text ="admin.mpolicy.Descriptors"/></td>
						</tr>
																							
<%
				if(DesCompVector.size()>2)
					descompFlag=true;
				for(int	i=0;i<DesCompVector.size();i++)
				{
					String compname=(String)DesCompVector.get(i);
					ArrayList desob=(ArrayList)compDescriptor.get(compname);
					Collections.sort(desob,String.CASE_INSENSITIVE_ORDER);
					String InfoInSt="";
					for(int	j=0;j<desob.size();j++) 
					{
						String info1=(String)desob.get(j);
						String info2=info1.substring(info1.indexOf(":")+1,info1.length());
						InfoInSt+=info2;
						if(j<desob.size()-1)
							InfoInSt+=",	";
					}
				
%>
							<tr>
								<td	class="eg_whitebg"	style="width:150px"	valign="top"><egui:intnl test="<%=compname%>"/>
								</td>
								<td	class="eg_whitebg"	valign="top" wrap ><%=InfoInSt%>

									</td>
							</tr>
<%
						}
%>
						</table>
					</td>
				</tr>
			</table>
		</td>
	</tr>
<%
					}
%>
																</table>
<%
				}
				else
				{
%>
																<table border="0" class="page_tab_border page_tab_bg" cellpadding="4" cellspacing="0" width="100%">
																	<tr>
																		<td	align="center" valign="center">
																			<img src="/final/admin/eg_images/<%=admin_Skin%>/exclamation-icon.gif"/>
																			<br>
																			<b><egui:intnl text	= "admin.mpolicy.No	Associated Elements"/></b>
																		</td>
																	</tr>
																</table>
<%
				}
%>
															</div> 
														</td>
													</tr>
												</table>
											</td>
										</tr>
									</table>
								</td>
							</tr>
							<tr>
								<td	><img src="/final/admin/eg_images/spacer.gif" height="11"></td>
							</tr>
						</table>
<%
			index++;
			}
		}
	}
	if(isSearchStrNotFound && isGroupsFound)
	{
%>
						<table width="100%"	height="100%" align="center" valign="center">
							<tr>
								<td	style="height:400px"></td>
								<td	align="center" valign="center">
									<img src="/final/admin/eg_images/<%=admin_Skin%>/exclamation-icon.gif"/>
									<br>
									<b><egui:intnl text	= "admin.mpolicy.No	groups found for your search, "/><%=egTitleSearchStr%></b>
								</td>
							</tr>
						</table>
<%
	}

	if(!isGroupsFound)
	{
%>
						<table width="100%"	height="100%" align="center" valign="center">
							<tr>
								<td	style="height:400px"></td>
								<td	align="center" valign="center">
									<img src="/final/admin/eg_images/<%=admin_Skin%>/exclamation-icon.gif"/>
									<br>
									<b><egui:intnl text	= "admin.mpolicy.No	Policy Groups Found"/></b>
								</td>
							</tr>
						</table>
						
<%
	}
%>
					</td>
				</tr>
			</table>
		</form>
	</body>
</html>
<%

if(request.getQueryString()!=null)
	session.setAttribute("adminLastAccessedURL","/final/servlet/com.eg.EgMaintenanceServlet?opt=Tree&"+request.getQueryString()+"&showtree=maintenancetree&treeViewSrc=/final/admin/egMaintenancePolicygroupList.jsp?");
else
	session.setAttribute("adminLastAccessedURL","/final/servlet/com.eg.EgMaintenanceServlet?opt=Tree&showtree=maintenancetree&treeViewSrc=/final/admin/egMaintenancePolicygroupList.jsp?");

%>