<%
/******************************************************************************
*	Name			:	aggCreateComponent.jsp
*	Purpose			:	creating aggregate component type
*	Version			:	5.2
*	Creation Date	:	14th February 2011
*	Author			:	James Thomas P
******************************************************************************/
%>
<%@ include file = "EgTrackerA.jsp" %>
<%@ page errorPage = "EgProbs.jsp"%>
<%@ page import = "java.util.*"%>
<%@ page import="com.eg.EgName"%>
<%@ page import="com.eg.IniFile"%>
<%@ page import="com.eg.EgTablesInfo"%>
<%@ page import="com.eg.EgInstallInfo"%>
<%@ page import="com.eg.EgAggregateInfo"%>
<%@ page import="com.eg.EgThresholdInfo"%>
<%@ page import="com.eg.EgDbAdapterTypeUI"%>
<%@ page import="com.eg.MappingNameSorter"%>
<%@ page import="com.egurkha.util.StringUtils"%>
<%@ page import="com.egurkha.admin.EgTestSpecification"%>
<%@ page import="com.eg.EgRoleInfo"%>
<%@ page import="com.eg.EgDbInfo"%>
<%@ page import="com.eg.EgDiscInfo"%>
<%@ page import="egurkha.TestBean"%>
<%@ page import="egurkha.EgDbAdapterUI"%>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);

	if(!EgInstallInfo.isAggregationSupported())
	{
		Vector errors = new Vector();
		errors.addElement(_mapping.getTextDescription("admin.error.Admin Home"));
		errors.addElement("EgAdminOperations.jsp");
		errors.addElement(_mapping.getTextDescription("admin.error.Possible Reason"));
		errors.addElement(_mapping.getTextDescription("admin.error.Your license does not allow you to use this feature")+".");
		errors.addElement(_mapping.getTextDescription("admin.error.Please contact") + " <a href='mailTo:license@eginnovations.com' target='_parent' class='dash_link'><b>license@eginnovations.com</b></a> " + _mapping.getTextDescription("admin.error.for more details")+".");
		session.putValue("vec_Errors", errors);
%>
	<jsp:forward page="EgErrors.jsp" />
<%
	}
	String aggComponentType = null;
	String startBorder = "form_spacing";
	String showBackButton = "true";
	String server = request.getParameter("server");
	String imageDisplayName="";
	String[] measures = null;

	EgAggregateInfo aggregateInfo = new EgAggregateInfo("manager");
	ArrayList siteServers = new ArrayList();
	EgDiscInfo discInfo = new EgDiscInfo("manager");
	siteServers = discInfo.getSiteServers();

	String [] componentTypes = discInfo.getServerTypes();

	Vector associatedTypes = new Vector();
	String displayDescription = null;
	String component_type = aggregateInfo.getValue("COMPONENT_TYPE_MAPPING",server);
	if(server != null && !server.equals("-1") && !StringUtils.isNull(component_type))
	{
		String array[] = StringUtils.getTokens(component_type,",");
		if(array != null && array.length>0)
		{
			associatedTypes = new Vector(Arrays.asList(array));
		}
		startBorder = "form_border";
		aggComponentType = server;
		displayDescription = _mapping.getComponentTypeDescription(aggComponentType);
		imageDisplayName = aggregateInfo.getValue("COMP_DISPLAY_NICK",server);
	}
	else
	{
		component_type = "-1";
		aggComponentType="-1";
	}
	String url = "listSearch.jsp?title=Modify Aggregate Component&leftString=&subtitle=false&searchBox=false&backButton="+showBackButton;
	boolean siteServer=siteServers.contains(server);
	String siteBorder=siteServer?"form_border":"form_spacing";
	String[] strServerTypes = new EgDiscInfo("manager").getServerTypes();
%>
<html>
<head>
	<egui:skin ui = "admin"/>
	<script language="JavaScript1.2" src="eg_scripts/validate.js"></script>
	<script language="javascript">
	function reloadPage(a)
	{
		var thisForm = document.list;
		var s_component_type = thisForm.component_type.options[thisForm.component_type.selectedIndex].value;
		if(s_component_type == -1)
			window.location.href = "aggModifyComponent.jsp?server=-1";
		else
			window.location.href = "aggModifyComponent.jsp?server="+encodeURI(a);
	}
	function valform()
	{
		var thisForm = document.list;
		var flag = true;
		var cmpName=true;
		var imageDispName=true;
		var compDispName=true;
		if('<%=EgDbInfo.doubleByteEnabled%>'=="false")
		{
			cmpName = validateSingleByte(thisForm.aggComponentName.value);
			imageDispName = validateSingleByte(thisForm.imageDispName.value);
			compDispName = validateSingleByte(thisForm.compDispName.value);
		}
		
		if(!checkblank(thisForm.compDispName))
		{
			alert("<egui:intnl text='admin.ic.Please enter aggregate component display name'/>");
			thisForm.compDispName.focus();
			flag=false;
			return;
		}
		else if(!checkblank(thisForm.imageDispName))
		{
			alert("<egui:intnl text='admin.ic.Please enter image display name'/>");
			thisForm.imageDispName.focus();
			flag=false;
			return;
		}
		else if(!compDispName)
		{
			alert('<egui:intnl text="admin.ic.Component display name is not allowed in DBL(Chinese,Korean,Japanese),since manager is SingleByte"/>');
			thisForm.compDispName.focus();
			flag = false;
			return;
		}
		else if(!imageDispName)
		{
			alert('<egui:intnl text="admin.ic.Image display name is not allowed in DBL(Chinese,Korean,Japanese),since manager is SingleByte"/>');
			thisForm.imageDispName.focus();
			flag = false;
			return;
		}
		if(flag)
		{
			if(isNetscape()) targetObj = thisForm.add;
			if(isIE()) targetObj = thisForm.add;
			targetObj.disabled = true;

			if(<%=!StringUtils.isNull(aggregateInfo.getValue("AGGREGATE_GENERIC_TYPES",aggComponentType))%>)
			{
				with(document.list)
				{
					associated_normalComponentTypes="";
					for(var cnt=0;cnt<associated.options.length;cnt++)
					{
						if(associated_normalComponentTypes.length==0)
							associated_normalComponentTypes = associated.options[cnt].value;
						else
							associated_normalComponentTypes += "," + associated.options[cnt].value;
					}
					associatedServerTypes.value=associated_normalComponentTypes;
				}
			}
			else
			{
				document.list.associatedServerTypes.value="<%=component_type%>";
			}
			var thisForm = document.list;
			thisForm.action="aggModifyComponentp.jsp?server="+encodeURI('<%=server%>');
			thisForm.submit();
		}
	}
	function isNetscape()
	{
		appName= navigator.appName;
		appLongVer = navigator.appVersion;
		appVer = appLongVer.substring(0, 1);
		if((appName == "Netscape") && (appVer >= 4)) return true;
		return false;
	}
	function isIE()
	{
		appName= navigator.appName;
		appLongVer = navigator.appVersion;
		appVer = appLongVer.substring(0, 1);
		if((appName == "Microsoft Internet Explorer") && (appVer >= 4)) return true;
		return false;
	}
	function addToAssociated()
	{
		var thisForm = document.list;
		var layersSelected = "false";
		var count=0;
		var optcount=thisForm.dissociated.options.length;
		if(optcount==0)
		{
			alert('<egui:intnl text="admin.server.No Dissociated components selected"/>');
			return;
		}
		for(j=0;j<thisForm.dissociated.options.length;j++)
		{
			if(thisForm.elements['dissociated'].options[j].selected==true)
			{
				count++;
			}
		}
		if(count==0)
		{
			alert('<egui:intnl text="admin.server.No Dissociated components selected"/>');
			return;
		}
		for (i=0; ;i++)
		{
			if(thisForm.elements['dissociated'].options[i] == null)
				return;
			if(thisForm.elements['dissociated'].options[i].selected)
			{
				elem = document.createElement("option");
				elem.text = thisForm.elements['dissociated'].options[i].text;
				elem.value = thisForm.elements['dissociated'].options[i].value;
				j = 0;
				while (j < thisForm.elements['associated'].options.length &&
				elem.value > thisForm.elements['associated'].options[j].value)
					j++;
				thisForm.elements['associated'].options.add(elem,j);
				thisForm.elements['dissociated'].options[i] = null;
				i--;
			}
		}
	}
	function addToDissociated()
	{
		var thisForm = document.list;
		var layersSelected = "false";
		var count=0;
		var optcount=thisForm.associated.options.length;
		if(optcount==0)
		{
			alert('<egui:intnl text="admin.server.No Associated components selected"/>');
			return;
		}
		for(j=0;j<thisForm.associated.options.length;j++)
		{
			if(thisForm.elements['associated'].options[j].selected==true)
			{
				count++;
			}
		}
		if(count==0)
		{
			alert('<egui:intnl text="admin.server.No Associated components selected"/>');
			return;
		}
		for(i=0;;i++)
		{
			if(thisForm.elements['associated'].options[i] == null)
				return;
			if(thisForm.elements['associated'].options[i].selected)
			{
				elem = document.createElement("option");
				elem.text = thisForm.elements['associated'].options[i].text;
				elem.value = thisForm.elements['associated'].options[i].value;
				j = 0;
				while (j < thisForm.elements['dissociated'].options.length &&
				elem.value > thisForm.elements['dissociated'].options[j].value)
					j++;
				thisForm.elements['dissociated'].options.add(elem,j);
				thisForm.elements['associated'].options[i]=null;
				i--;
			}
		}
	}
	</script>
</head>
<body style="overflow:auto" leftmargin="0" topmargin="0" marginwidth="0" marginheight="0">
	<form name="list" method="post" action="javascript:valform();" style="margin:0px">
	<jsp:include page="<%=url%>"/>
		<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0">
			<tr>
				<td width="100%" id="eg_whitebg" align="center" height="100%" valign="middle">
					<table align="center" cellspacing="0" cellpadding="0" width="75%" border="0" style="table-layout:auto">
						<tr>
							<td height="6" id="inner_top_left" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
							<td height="6" id="eg_subcontentbg" width="100%" colspan="6"><img src="/final/admin/eg_images/spacer.gif" height="6"></td>
							<td height="6" id="inner_top_right" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
						</tr>
						<tr>
							<td class="eg_subcontentbg" id="<%=startBorder%>">&nbsp;</td>
							<td align="left" width="250" class="eg_subcontentbg" nowrap height="20" id="<%=startBorder%>"><egui:intnl text="admin.threshold.Aggregate component name"/></td>
							<td width="5" class="eg_subcontentbg" id="<%=startBorder%>">:</td>
							<td class="eg_subcontentbg" id="<%=startBorder%>" style="padding-left:10px;" width="73%">
								<select name="component_type" style='width:285px;' onchange="javascript:reloadPage(this.value);">
									<option value="-1" selected="true"><egui:intnl text="admin.ic.Please select a component type"/></option>
<%
								for(int i=0;i<componentTypes.length;i++)
								{
									if(componentTypes[i].startsWith("Agg_") && componentTypes[i].endsWith("_ExAgg"))
									{
%>
										<option value='<%=componentTypes[i]%>' <%=(componentTypes[i].equalsIgnoreCase(server))?"selected":""%>><%=_mapping.getComponentTypeDescription(componentTypes[i])%></option>
<%
									}
								}
%>
								</select>
							</td>
							<td colspan="4" class="eg_subcontentbg" id="<%=startBorder%>">&nbsp;</td>
						</tr>
<%
						if(!StringUtils.isNull(component_type) && !component_type.equals("-1"))
						{
%>
						<tr>
							<td class="eg_subcontentbg" id="form_border">&nbsp;</td>
							<td align="left" width="250" class="eg_subcontentbg" nowrap height="20" id="form_border"><egui:intnl text="admin.threshold.Aggregate component display name"/></td>
							<td width="5" class="eg_subcontentbg" id="form_border">:</td>
							<td class="eg_subcontentbg" id="form_border" style="padding-left:10px;"><input type='text' maxlength="32" size="47" id="compDispName" name='compDispName' value="<%=displayDescription%>" onkeydown="if (event.keyCode == 13) valform();"></td>
							<td colspan="4" class="eg_subcontentbg" id="form_border">&nbsp;</td>
						</tr>
						<input type='hidden' name='$_compDispName' value='<%=displayDescription%>'>
						<tr>
							<td class="eg_subcontentbg" id="<%=siteBorder%>">&nbsp;</td>
							<td align="left" width="250" class="eg_subcontentbg" nowrap height="20" id="<%=siteBorder%>"><egui:intnl text="admin.threshold.Image display name"/>&nbsp;[Only 6 characters allowed]</td>
							<td width="5" class="eg_subcontentbg" id="<%=siteBorder%>">:</td>
							<td class="eg_subcontentbg" id="<%=siteBorder%>" style="padding-left:10px;"><input type='text' maxlength="6" size="47" id="imageDispName" name='imageDispName' value='<%=imageDisplayName%>' onkeydown="if (event.keyCode == 13) valform();"></td>
							<td colspan="4" class="eg_subcontentbg" id="<%=siteBorder%>">&nbsp;</td>
						</tr>
						<input type='hidden' name='$_imageDispName' value='<%=imageDisplayName%>'>
<!-- new work starts -->
<%
					if(!StringUtils.isNull(aggregateInfo.getValue("AGGREGATE_GENERIC_TYPES",aggComponentType)))
					{
%>
						<tr>
							<td class="eg_subcontentbg" id="<%=siteBorder%>" colspan="4">
								<table border="0" width="100%" cellspacing="0" cellpadding="0">
									<tr>
										<td width="45%">
											<table align="center" cellspacing="0" cellpadding="0" border="0" id="table_outer_border" style="padding:0px">
												<tr>
													<th id="eg_subheadbg" class="head_padding4" style="border-top-width:0px"><egui:intnl text="admin.server.Associated component types"/></th>
												</tr>
												<tr>
													<td id="eg_subcontentbg" align="center" valign="middle">
													<select name="associated" size="12" multiple width="300" style="width:300px;">
<%
														String associatedServerTypes="";
														for(int cnt=0;cnt<associatedTypes.size();cnt++)
														{
															String currentServerType = (String)associatedTypes.get(cnt);

															if(associatedServerTypes.length()==0)
																associatedServerTypes=currentServerType;
															else
																associatedServerTypes +=","+currentServerType;
%>
															<option value="<%=currentServerType%>"><%=_mapping.getComponentTypeDescription(currentServerType)%></option>
<%
														}
%>
													</select>
													</td>
												</tr>
											</table>
										</td>
										<td id="eg_subcontentbg" width="10%">
											<table align="center" cellspacing="0" border="0" cellpadding="4">
												<tr>
													<td align="center" valign="middle" >
													<input type="button" value='<egui:intnl text="admin.server.Disassociate"/>&rsaquo;&rsaquo;' class="eg_lightbutton" onClick="javascript:addToDissociated();" name="unman" style="letter-spacing: 0px;width:100px">
													<br><br>
													<input type="button" value='&lsaquo;&lsaquo;<egui:intnl text="amin.server.Associate"/>' class="eg_lightbutton" onClick="javascript:addToAssociated();" name="man" style="letter-spacing: 0px;width:100px">
													</td>
												</tr>
											</table>
										</td>
										<td width="45%" id="eg_subcontentbg">
											<table align="center" cellspacing="0" border="0" id="table_outer_border" style="padding:0px">
												<tr>
													<th id="eg_subheadbg" class="head_padding4" style="border-top-width:0px"><egui:intnl text="admin.server.Disassociated component types"/></th>
												</tr>
												<tr>
													<td id="eg_subcontentbg" align="center" valign="middle">
													<select name="dissociated" size="12" multiple width="300" style="width:300px;">
<%
														for(int cnt=0;cnt<strServerTypes.length;cnt++)
														{
															String currentServerType = strServerTypes[cnt];
															if(currentServerType.startsWith("Agg_") || associatedTypes.contains(currentServerType))
																continue;
%>
															<option value="<%=currentServerType%>"><%=_mapping.getComponentTypeDescription(currentServerType)%></option>
<%
														}
%>
													</select>
													</td>
												</tr>
											</table>
										</td>
									</tr>
								</table>
							</td>
							<td colspan="4" class="eg_subcontentbg" id="form_border">&nbsp;</td>
						</tr>
						<input type='hidden' name='$_associatedServerTypes' value='<%=associatedServerTypes%>'>
<!-- new work ends -->
<%
					}
					else
					{
%>
						<input type='hidden' name='$_associatedServerTypes' value='<%=aggregateInfo.getValue("COMPONENT_TYPE_MAPPING",server)%>'>
<%
					}
%>
<%
							if(siteServer)
							{
%>
						<tr>
							<td class="eg_subcontentbg" id="form_spacing">&nbsp;</td>
							<td align="left" width="250" class="eg_subcontentbg" nowrap height="20" id="form_spacing"><egui:intnl text="admin.threshold.Site support"/></td>
							<td width="5" class="eg_subcontentbg" id="form_spacing">:</td>
							<td class="eg_subcontentbg" id="form_spacing" style="padding-left:10px;">
								<table width="60%" cellspacing="0" cellpadding="0" border="0">
									<tr>
										<td id="eg_subcontentbg" class="eg_subcontent" width="20">
											<input type="radio" class="eg_input" id="siteSupport" name="siteSupport" value="true">
										</td>
										<td><egui:intnl text="admin.common.Yes"/></td>
										<td id="eg_subcontentbg" class="eg_subcontent" width="20">
											<input type="radio"class="eg_input" id="siteSupport" name="siteSupport" value="false">
										</td>
										<td><egui:intnl text="admin.common.No"/></td>
									</tr>
								</table>
							</td>
							<td colspan="4" class="eg_subcontentbg" id="form_spacing">&nbsp;</td>
						</tr>
						<input type='hidden' name='$_siteSupport' value=''>
<%
							}
						}
%>
						<tr>
							<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
							<td id="eg_subcontentbg" width="100%" colspan="6" valign="top"><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
							<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
						</tr>
					</table>
				</td>
			</tr>
			<tr>
				<td id="eg_blankspace" height="10">&nbsp;</td>
			</tr>
<%
		if(!StringUtils.isNull(component_type) && !component_type.equals("-1"))
		{
%>
			<tr>
				<td align="center"><input type="button" name="add" value='<egui:intnl text="admin.common.Modify"/>' style="width:80px" class="eg_darkbutton" onClick="javascript:valform();"></td>
			</tr>
<%
		}
%>

		</table>
		<input type='hidden' name='associatedServerTypes' value=''>
	</form>
</body>
</html>

<%
	session.setAttribute("adminLastAccessedURL","/final/admin/aggModifyComponent.jsp?"+request.getQueryString());
%>
