<%
/*************************************************************************************************/
/*                 Name          : validateWebServiceURL.jsp                                     */
/*                 Purpose       : To validate WSDL url's configured for WebserviceTest          */
/*************************************************************************************************/
%>

<%@ include file="../../EgTrackerAJSON.jsp"%>
<%@ page import = "java.io.*"%>
<%@ page import = "java.util.*"%>
<%@ page import = "com.eg.IniFile"%>
<%@ page import = "com.eg.EgDiscInfo"%>
<%@ page import="com.eg.EgURLDecoder"%>
<%@ page import = "com.eg.EgInstallInfo"%>
<%@ page import = "com.eg.EgManagersIniForManager"%>
<%@ page import = "com.eg.SMClusterHelper"%>
<%@ page import = "com.eg.PMClusterHelper"%>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ page import = "com.eg.EgStateManager" %>
<%@ page import = "com.egurkha.monitor.remotecontrol.PreAgentInfo" %>
<%@ page import="com.eg.EgServerList" %>
<%@ page import="com.eg.EgURLEncoder" %>
<%@ page import="com.eg.EgLicenseInfo" %>
<%@ page import="com.eg.EgSpecsInfo" %>
<%@ page import="com.eg.EgUtils" %>
<%@ page import="com.eg.AgentConfig" %>
<%@ page import="com.eg.EgRoleInfo" %>
<%@ page import="com.eg.EgExternalInfo" %>
<%@ page import = "com.eg.EgConfigFilesSync"%>
<%@ page import = "com.eg.EgControlInfo"%>
<%@ page import = "com.eg.PollingServlet"%>
<%@ page import="com.eg.webservice.*"%>
<%@ page import="com.eg.XenMDMUrlTest"%>
<%@ page import = "com.eg.webservice.EgWebServiceBase"%>
<%@ page import="com.eg.RemoteControlTaskHelper"%>
<%@ taglib prefix="egui" uri="../../../WEB-INF/eg-taglib.tld"%>
<%@ page import = "net.sf.json.*"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>

<%
try
{
	JSONObject rootObj = new JSONObject();
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);

	boolean agentReporting = true;
	boolean fileNotCreated = true;
	String test = request.getParameter("test");
	String selectedAgent = request.getParameter("selectedAgent");
	String validation = request.getParameter("validation");
	String action = request.getParameter("action");
	String taskName = request.getParameter("taskName");
	String valForValidation=request.getParameter("valForValidation");
	valForValidation = egurkha.EgUIUtils.decodeSecurityChar(valForValidation);
	String compName=request.getParameter("compName");
	String componentType=request.getParameter("componentType");
	String isSNMP=request.getParameter("isSNMP");
	String fromPage=request.getParameter("fromPage");
	String selectedValue = request.getParameter("selectedValue");
	String credentialValue = request.getParameter("credentialValue");

	if (credentialValue != null && !credentialValue.equals(""))
	{
		if (credentialValue.startsWith(","))
		{
			credentialValue = credentialValue.substring(credentialValue.indexOf(",")+1);
		}
	}

	String wsdlUrl = request.getParameter("wsdlUrl");
	boolean isWSDL=false;
	EgSpecsInfo spec = new EgSpecsInfo("manager");
	String egServer = spec.getEGServer();
	
	if (wsdlUrl!=null && !wsdlUrl.equals(""))
	{
		isWSDL = true;
	}

	if (fromPage != null && fromPage.equals("descovery"))
	{
		fromPage="descovery";
	}
	else
	{
		fromPage="testConfig";
	}

	EgLicenseInfo licInfo = new EgLicenseInfo();
	EgServerList serverList = new EgServerList();
	List runningAgents = PreAgentInfo.getRunningAgents();
	Vector agentsNotRunning = EgStateManager.notRunningAgents;
	ArrayList allAgents=new ArrayList();
	ArrayList validationMsgs=new ArrayList();

	if(runningAgents!=null && !runningAgents.isEmpty())
	{
		allAgents.addAll(runningAgents);
	}

	if(agentsNotRunning!=null && !agentsNotRunning.isEmpty())
	{
		allAgents.addAll(agentsNotRunning);
	}

	//below condition checked to filter the agentsList for limited user
	EgUserRole userRoleObject = EgUserRole.getRoleObject(_user.getLoginType());
	if((userRoleObject!=null && !userRoleObject.hasAllComponentAccess()) && (allAgents!=null && !allAgents.isEmpty()))
	{
		//tells information about the corresponding authenticated user
		EgRoleInfo ri = EgRoleInfo.getInstance(session.getId(),(String)session.getAttribute("sess_userid"));
		EgExternalInfo egExternalInfo=new EgExternalInfo("manager");

		Vector allServersWithoutTypeForUser=ri.getAllServersWithoutType();
		ArrayList agentListForUser=new ArrayList();
		if(allServersWithoutTypeForUser!=null && !allServersWithoutTypeForUser.isEmpty())
		{
			Iterator itrServs=allServersWithoutTypeForUser.iterator();
			while(itrServs.hasNext())
			{
				String serv=(String)itrServs.next();
				String nick=serv.substring(0,serv.indexOf(":"));
				List agentList=egExternalInfo.getAgentsForHost(nick);
				agentListForUser.addAll(agentList);
			}
		}
		ArrayList tempAgents=new ArrayList();
		Iterator itrAllAgents=allAgents.iterator();
		while(itrAllAgents.hasNext())
		{
			String agent=(String)itrAllAgents.next();
			if(agentListForUser!=null && agentListForUser.contains(agent))
			{
				tempAgents.add(agent);
			}
		}
		allAgents=tempAgents;
	}

	ArrayList totalAgents=serverList.getAgentList(allAgents);

	String sep = System.getProperty("file.separator");
	String agentID =compName;
	if(agentID != null && agentID.length()>0 && agentID.indexOf(":")>0)
	{
		agentID = agentID.substring(0,agentID.indexOf(":"));
	}
	if(selectedAgent!=null && (!selectedAgent.equals("") && !selectedAgent.equalsIgnoreCase("null")))
	{
		agentID=selectedAgent;
	}
	boolean isAgentInstalled=true;
	if(agentsNotRunning!=null && agentsNotRunning.contains(agentID))
	{
		agentReporting=false;
	}

	if(totalAgents!=null && !totalAgents.isEmpty())
	{
		int agentIdx=totalAgents.indexOf(agentID);
		String agentState=(String)totalAgents.get(agentIdx+1);
		if(agentState!=null && agentState.equalsIgnoreCase("Not Installed-Not Running"))
		{
			isAgentInstalled=false;
		}
	}

	IniFile egTestParamIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_testparam.ini");
	String defaultValidationFieldsForComponent=egTestParamIni.getValue("VALIDATIONS_FIELDS",componentType+":Default");
	String specificValidationFieldsForTest=egTestParamIni.getValue("VALIDATIONS_FIELDS",test);
	if(specificValidationFieldsForTest!=null && (!specificValidationFieldsForTest.equals("") && !specificValidationFieldsForTest.equalsIgnoreCase("null")))
	{
		defaultValidationFieldsForComponent=defaultValidationFieldsForComponent+","+specificValidationFieldsForTest;
	}
	StringBuffer sbreqValsForValidation=new StringBuffer(256);
	ArrayList defaultValidationFieldList=new ArrayList();
	if(defaultValidationFieldsForComponent!=null && !defaultValidationFieldsForComponent.equals(""))
	{
		StringTokenizer stkvFields=new StringTokenizer(defaultValidationFieldsForComponent,",");
		while(stkvFields.hasMoreTokens())
		{
			String fieldName=stkvFields.nextToken();
			fieldName=fieldName.toLowerCase();
			sbreqValsForValidation.append(fieldName+",");
			defaultValidationFieldList.add(fieldName);
		}
	}
	String requiredParamNames=sbreqValsForValidation.toString()+"componentcredentialsneededtodovalidation";
	if(requiredParamNames!=null && requiredParamNames.endsWith(","))
	{
		requiredParamNames=requiredParamNames.substring(0,(requiredParamNames.length()-1));
	}
	String validationURL="/final/admin/validateWebServiceURL.jsp";
	String paramsForURL="&test="+test+"&validation="+validation+"&taskName="+taskName+"&compName="+compName+"&action=validate&componentType="+componentType+"&isSNMP="+isSNMP;
	ArrayList allExternalAndRemoteAgents=new ArrayList();
	ArrayList externalAgents=licInfo.getExternalAgents();
	ArrayList remoteAgents=licInfo.getRemoteAgents();
	if(externalAgents!=null && !externalAgents.isEmpty())
	{
		allExternalAndRemoteAgents.addAll(externalAgents);
	}
	if(remoteAgents!=null && !remoteAgents.isEmpty())
	{
		allExternalAndRemoteAgents.addAll(remoteAgents);
	}
	Vector finalAgents=new Vector();
	if(totalAgents!=null && totalAgents.size()>0)
	{
		for(int s=0;s<totalAgents.size();s=s+4)
		{
			String agentIPAdd=(String)totalAgents.get(s);
			if((agentIPAdd!=null && !agentIPAdd.equalsIgnoreCase(agentID)) && (allExternalAndRemoteAgents!=null && !allExternalAndRemoteAgents.contains(agentIPAdd)))
			{
				continue;
			}
			String agentState=(String)totalAgents.get(s+1);
			if(agentState!=null && agentState.equalsIgnoreCase("installed-running"))
			{
				finalAgents.add(agentIPAdd);
			}
		}
	}
	boolean isAgentsAvailable=true;
	boolean singleEntry=false;
	int index=0;
	if(finalAgents!=null)
	{
		if(finalAgents.isEmpty())
		{
			isAgentsAvailable=false;
		}
		//else if(finalAgents.size()==1)
		//{
			//singleEntry=true;
			//index=1;
		//}
	}
	if (action!=null && action.equals("pickAgentToValidate"))
	{
		rootObj.put("isJSONObject",new Boolean(true));
		String defaultAgentMsg="";
		rootObj.put("isAgentsAvailable",isAgentsAvailable);
		JSONObject agentListObj = new JSONObject();
		JSONArray tmpListArr = new JSONArray();
		if(isAgentsAvailable)
		{
			defaultAgentMsg="Please choose agent or manager and press go button to start validation";

			agentListObj.put("displayField",_mapping.getTextDescription("admin.common.Please choose an agent or manager"));
			agentListObj.put("valueField","-1");
			agentListObj.put("groupField","");
			tmpListArr.add(agentListObj);

			String optionValue = "eG Manager - "+egServer;
			agentListObj.put("displayField",optionValue);
			agentListObj.put("valueField","EgManager");
			agentListObj.put("groupField","");
			tmpListArr.add(agentListObj);
			for(int t=index;t<finalAgents.size();t=t+1)
			{
				agentListObj = new JSONObject();
				String s=(String)finalAgents.get(t);
				//String selected="";
				//if(s!=null && s.equalsIgnoreCase(agentID))
				{
					agentListObj.put("displayField",s);
					agentListObj.put("valueField",s);
					agentListObj.put("groupField",""); 
					tmpListArr.add(agentListObj);
				}
			}
			paramsForURL=paramsForURL+"&wsdlUrl="+EgURLEncoder.encode(wsdlUrl,"UTF-8");
			rootObj.put("paramsForURL",paramsForURL);
			rootObj.put("tmpListArr",tmpListArr);
		}
		else
		{
			paramsForURL=paramsForURL+"&wsdlUrl="+EgURLEncoder.encode(wsdlUrl,"UTF-8");
			String optionValue = "eG Manager-"+egServer;
			defaultAgentMsg="No agents available to validate";

			//agentListObj.put("displayField",_mapping.getTextDescription("admin.common.Please choose Manager for validation"));
			//agentListObj.put("valueField","-1");
			//agentListObj.put("groupField","");
			//tmpListArr.add(agentListObj);

			agentListObj.put("displayField",optionValue);
			agentListObj.put("valueField","EgManager");
			agentListObj.put("groupField","");
			tmpListArr.add(agentListObj);
			rootObj.put("isWsdlForWebService",true);
			rootObj.put("paramsForURL",paramsForURL);
			rootObj.put("tmpListArr",tmpListArr);
		}
		if(defaultAgentMsg.length()>0){
			rootObj.put("defaultAgentMsg",defaultAgentMsg);
		}
		out.println(rootObj.toString());
	}
	else if(action!=null && action.equals("validate"))
	{
		boolean fromMgr = false;
		boolean fromAgent=false;
		if(isWSDL && selectedValue!=null && !selectedValue.equals(""))
		{
			if(selectedValue.indexOf("EgManager")>-1)
				fromMgr = true;
			else
				fromAgent = true;
		}

		if(!fromMgr)
		{
			if(isAgentInstalled && agentReporting)
			{
				RemoteControlTaskHelper helper = new RemoteControlTaskHelper();
				if(helper.setAgentIntoControlMode(agentID))
				{
					helper.executeTask(taskName, session.getId(), EgURLEncoder.encode(wsdlUrl.trim(),"UTF-8")+"|#|"+EgURLEncoder.encode(credentialValue,"UTF-8")+"@#@Y");
					if(helper.isOutputAvailable())
					{
						validationMsgs = helper.getOutput();
						if(validationMsgs == null || validationMsgs.isEmpty())
						{
							validationMsgs=new ArrayList();
						}
						else
						{
							fileNotCreated=false;
						}
					}
				}
			}
			if(!agentReporting || fileNotCreated || !isAgentInstalled)
			{
				String defaultMsg="";
				if(!agentReporting || fileNotCreated)
					defaultMsg="Failed to get required validation information from agent";
				else if(!isAgentInstalled)
					defaultMsg="Agent not installed or not running";
				if(!isAgentsAvailable)
				{
					rootObj.put("validationMessage",defaultMsg);
					out.println(rootObj.toString());
					return;
				}
			}
			else
			{
				if (validationMsgs != null && !validationMsgs.isEmpty())
				{
%>
	<div class="x-table">
		<table class="x-grid-table" border="0" cellspacing="0" cellpadding="2" width="100%">
			<col width="5%"><col width="20%"><col width="65%"><col width="10%">
			<thead>
				<tr class="x-grid-row">
					<th class="x-grid-cell x-grid-cell-first" valign="middle"><div class="x-grid-cell-inner">&nbsp;</div>
					</th>
					<th class="x-grid-cell x-grid-cell-first"><div class="x-grid-cell-inner"><egui:intnl text="admin.common.Name"/></div></th>
					<th class="x-grid-cell x-grid-cell-first"><div class="x-grid-cell-inner"><egui:intnl text="admin.common.WSDL URL"/></div></th>
					<th class="x-grid-cell x-grid-cell-first" valign="middle"><div class="x-grid-cell-inner"><egui:intnl text="admin.common.Result"/></div></th>
				</tr>
			</thead>
			<tbody>
<%
					String validFlag = "User credentials";
					StringTokenizer strToken=null;
					if(wsdlUrl.indexOf(",")>-1)
						strToken = new StringTokenizer(wsdlUrl,",");
					else if(wsdlUrl.indexOf("|")>-1)
						strToken = new StringTokenizer(wsdlUrl,"|");
					else
						strToken = new StringTokenizer(wsdlUrl,"");
					while(strToken.hasMoreTokens())
					{
						String token = (String)strToken.nextToken();
						String pattern = token.substring(0,token.indexOf(":"));
						String urlOnly = token.substring(token.indexOf(":")+1);
						if (validationMsgs.contains(token))
						{
%>
				<tr class="x-grid-row">
					<td class=" x-grid-cell x-grid-cell-first" valign="middle">
						<div class="x-grid-cell-inner"><div style="float:left;" class="iconRight"></div></div>
					</td>
					<td class="x-grid-cell x-grid-cell-first" valign="middle" align="left"><b><%=pattern%></b></td>
					<td class="x-grid-cell x-grid-cell-first" valign="middle" align="left"><b><%=urlOnly%></b></td>
					<td class="x-grid-cell x-grid-cell-first" valign="middle" align="left"><div class="x-grid-cell-inner"><egui:intnl text='<%="admin.common.Valid"%>'/>&nbsp;</div>
				</tr>
<%
						}
						else
						{
%>
				<tr class="x-grid-row">
					<td class="x-grid-cell x-grid-cell-first" valign="middle">
						<div class="x-grid-cell-inner"><div style="float:left;" class="iconWrong"></div></div>
					</td>
					<td class="x-grid-cell x-grid-cell-first" valign="middle" align="left"><div class="x-grid-cell-inner"><%=pattern%></div></td>
					<td class="x-grid-cell x-grid-cell-first" valign="middle" align="left"><div class="x-grid-cell-inner"><%=validFlag%></div></td>
					<td class="x-grid-cell x-grid-cell-first" valign="middle" align="left"><div class="x-grid-cell-inner"><egui:intnl text='<%="admin.common.Invalid"%>'/>&nbsp;</div></td>
				</tr>
<%
						}
					}
%>
				<div id="retry required"></div>
			</tbody>
		</table>
	</div>
<%
				}
				else
				{
%>
	<div class="x-table">
		<table class="x-grid-table" border="0" cellspacing="0" cellpadding="2" width="100%">
			<col width="5%"><col width="20%"><col width="65%"><col width="10%">
			<thead>
				<tr class="x-grid-row">
					<th class="x-grid-cell x-grid-cell-first" valign="middle"><div class="x-grid-cell-inner">&nbsp;</div></th>
					<th class="x-grid-cell x-grid-cell-first"><div class="x-grid-cell-inner"><egui:intnl text="admin.common.Name"/></div></th>
					<th class="x-grid-cell x-grid-cell-first"><div class="x-grid-cell-inner"><egui:intnl text="admin.common.WSDL URL"/></div></th>
					<th class="x-grid-cell x-grid-cell-first"><div class="x-grid-cell-inner"><egui:intnl text="admin.common.Result"/></div></th>
				</tr>
			</thead>
			<tbody>
<%
					StringTokenizer strToken=null;
					if(wsdlUrl.indexOf(",")>-1)
						strToken = new StringTokenizer(wsdlUrl,",");
					else if(wsdlUrl.indexOf("|")>-1)
						strToken = new StringTokenizer(wsdlUrl,"|");
					else
						strToken = new StringTokenizer(wsdlUrl,"");
					while(strToken.hasMoreTokens())
					{
						String token = (String)strToken.nextToken();
						String pattern = token.substring(0,token.indexOf(":"));
						String urlOnly = token.substring(token.indexOf(":")+1);
%>
				<tr class="x-grid-row">
					<td class="x-grid-cell x-grid-cell-first" valign="middle"><div class="x-grid-cell-inner"><div style="float:left;" class="iconWrong"></div></div></td>
					<td class="x-grid-cell x-grid-cell-first" valign="middle" align="left"><div class="x-grid-cell-inner"><%=pattern%></div></td>
					<td style="text-wrap;word-wrap:break-word;" valign="middle" align="left"><b><%=urlOnly%></b></td>
					<td class="x-grid-cell x-grid-cell-first" valign="middle" align="left"><div class="x-grid-cell-inner"><egui:intnl text='<%="admin.common.Invalid"%>'/>&nbsp;</div></td>
				</tr>
<%
					}
%>
				<div id="retry required"></div>
			</tbody>
		</table>
	</div>
<%
				}
			}
		}
		else if(fromMgr)
		{
			HashMap services = null;
			ArrayList credentialList = new ArrayList();

			if (credentialValue != null && !credentialValue.equals(""))
			{
				StringTokenizer credenTok = new StringTokenizer(credentialValue,",");
				while (credenTok.hasMoreTokens())
				{
					String credentialToken = (String)credenTok.nextToken();
					credentialList.add(credentialToken);
				}
			}

			StringTokenizer strTok = null;
			if(wsdlUrl.indexOf(",")>-1)
				strTok = new StringTokenizer(wsdlUrl,",");
			else if(wsdlUrl.indexOf("|")>-1)
				strTok = new StringTokenizer(wsdlUrl,"|");
			else
				strTok = new StringTokenizer(wsdlUrl,"");
%>
	<div class="x-table">
		<table class="x-grid-table" border="0" cellspacing="0" cellpadding="2" width="100%">
			<col width="5%"><col width="20%"><col width="65%"><col width="10%">
			<thead>
				<tr class="x-grid-row">
					<th class="x-grid-cell x-grid-cell-first" valign="middle" align="center"><div class="x-grid-cell-inner">&nbsp;</div></th>
					<th class=" x-grid-cell x-grid-cell-first"><div class="x-grid-cell-inner"><egui:intnl text="admin.common.Name"/></div></th>
					<th class=" x-grid-cell x-grid-cell-first"><div class="x-grid-cell-inner"><egui:intnl text="admin.common.WSDL URL"/></div></th>
					<th class=" x-grid-cell x-grid-cell-first"><div class="x-grid-cell-inner"><egui:intnl text="admin.common.Result"/></div></th>
				</tr>
			</thead>
			<tbody>
<%
			int cnt = 0;
			String username = "";
			String password = "";
			while(strTok.hasMoreTokens())
			{
				String token = (String)strTok.nextToken();
				String pattern = token.substring(0,token.indexOf(":"));
				String urlOnly = token.substring(token.indexOf(":")+1);
				String credentials = "";
				if (credentialList != null && credentialList.size() > 0)
				{
					credentials = (String)credentialList.get(cnt);
					username = credentials.substring(0,credentials.indexOf(":"));
					password = credentials.substring(credentials.indexOf(":")+1);
					String strTokenSalt = EgCrypt.decrypt(password); //salt for pwd
					if (strTokenSalt.indexOf("~EG~") != -1)
					{
						password = strTokenSalt.substring(0,strTokenSalt.indexOf("~EG~"));
					}
				}
				EgWebServiceBase wsclient = new EgWebServiceBase(urlOnly, username, password);
				services = wsclient.getWsdlServices();
				if (services != null && services.size() > 0)
				{
%>
				<tr class="x-grid-row">
					<td class=" x-grid-cell x-grid-cell-first" valign="middle">
						<div class="x-grid-cell-inner"><div style="float:left;" class="iconRight" ></div></div>
					</td>
					<td class="x-grid-cell x-grid-cell-first" valign="middle" align="left"><div class="x-grid-cell-inner"><%=pattern%></div></td>
					<td class="x-grid-cell x-grid-cell-first" valign="middle" align="left"><div class="x-grid-cell-inner"><%=urlOnly%></div></td>
					<td class="x-grid-cell x-grid-cell-first" valign="middle" align="left"><div class="x-grid-cell-inner"><egui:intnl text='<%="admin.common.Valid"%>'/>&nbsp;</div></td>
				</tr>
<%
				}
				else
				{
%>
				<tr class="x-grid-row">
					<td class="x-grid-cell x-grid-cell-first" valign="middle"><div class="x-grid-cell-inner"><div style="float:left;" class="iconWrong"> </div></div>
					</td>
					<td class="x-grid-cell x-grid-cell-first" valign="middle" align="left"><div class="x-grid-cell-inner"><%=pattern%></div></td>
					<td class="x-grid-cell x-grid-cell-first" valign="middle" align="left"><div class="x-grid-cell-inner"><%=urlOnly%></div></td>
					<td class="x-grid-cell x-grid-cell-first" valign="middle" align="left"><div class="x-grid-cell-inner"><egui:intnl text='<%="admin.common.Invalid"%>'/>&nbsp;</div></td>
				</tr>
<%
				}
				cnt++;
			}
%>
				<div id="retry required"></div>
			</tbody>
		</table>
	</div>
<%
		}
	}
}
catch(Exception e)
{
	e.printStackTrace();
}
%>



