<%@ include file="../../EgTrackerAJSON.jsp" %>

<%@ page import="java.util.*" %>
<%@ page import="java.io.*" %>
<%@ page import="org.apache.commons.codec.binary.Base64" %>
<%@ page import="java.net.HttpURLConnection" %>
<%@ page import="java.net.URL" %>
<%@ page import="java.security.Security" %>
<%@ page import="com.eg.*" %>
<%@ page import="javax.net.ssl.*" %>
<%@ page import="org.json.simple.parser.JSONParser" %>
<%@ page import="org.json.simple.parser.ParseException" %>
<%@ page import="org.json.simple.JSONArray" %>
<%@ page import="org.json.simple.JSONObject" %>
<%@ page language="java" contentType="application/json; charset=UTF-8" pageEncoding="UTF-8" %>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>

<%!
	//NOTE:- Need to have a "Singleton" object to hold these global constants.
	//File name EMCXIOCluster.jsp
	final int j=124;
	public String decrypt(String str)
	{
		if (str!=null && str.length()<2)
			return str;
		if (str!=null && str.indexOf(":") ==-1)
			return str;
		ArrayList a = myTokenizer (str,":");
		if (a == null || a.size() == 0)
			return (null);
		int count = a.size();
		int c = count;
		byte[] b = new byte[count];
		String s = null;
		int i = count - 1;
		for (int rr=0; rr<c; rr++)
		{
			s = (String) a.get(rr);
			int x = 0;
			try {
				x = Integer.parseInt(s);
			} catch (Exception e2) {
				return (str);
			}
			int k = j - x + i * 3;
			i --;
			b[--count] = (byte)k;
			//count --;
		}
		String decStr = new String(b);
		return (decStr);
	}
		
	
	private ArrayList myTokenizer (String str, String c)
	{
		if (str == null || str.length() == 0)
			return (null);
		ArrayList a = new ArrayList();
		String sub = null;
		int i = 0;
		int j =str.indexOf(c);  // First substring
		while( j >= 0) {
			sub = str.substring(i,j);
			a.add(sub);
			i = j + 1;
			j = str.indexOf(c, i);   // Rest of substrings
		}
		sub = str.substring(i); // Last substring
		a.add(sub);
		return (a);
	}
	
	private  boolean checkForTimeout (com.eg.ConnectionThread ct)
	{
		long totalSleepTime = 0;
		long sleepTime = 250;
		long timeout=(long)2*(60*1000);
		while(true)
		{
			if (sleepTime < 120)
				sleepTime = 120;
			suspendForPeriod(sleepTime);
			if(ct.done)
			{
				return (true);
			}
			totalSleepTime += sleepTime;
			if(totalSleepTime >= timeout)
			{
				//System.out.println(" Timed out and hence going to kill the thread :"+  System.currentTimeMillis());
				ct.interrupt();
				Thread.currentThread().yield();
				//System.out.println(" Timed out and killed the thread :"+ System.currentTimeMillis());
				ct.stop();
				
				return (false);
			}
			long nextSleepTime = sleepTime;
			if(timeout - totalSleepTime < nextSleepTime)
			{
				nextSleepTime = timeout - totalSleepTime;
			}
			sleepTime = nextSleepTime;
			if(sleepTime <= 0)
			{
				//System.out.println("<BR> sleepTime less than zero in checkForTimeout :"+ System.currentTimeMillis());
				ct.interrupt();
				Thread.currentThread().yield();
				ct.stop();
				return (false);
			}
		}
	}

	private  void suspendForPeriod (long sleepPeriod)
	{
		long nextMeasureTime = System.currentTimeMillis()+sleepPeriod;
		while (sleepPeriod > 0)
		{
			try
			{
				Thread.sleep(sleepPeriod);
			}
			catch (Exception e)
			{
				//System.out.println(e);
			}
			long currentTime = System.currentTimeMillis();
			sleepPeriod = nextMeasureTime - currentTime;
		}
	}

	protected double getValueFromJSONObject(JSONObject jsonObject,String parameter,boolean isLong)
	{
		double value=1.0;
		try
		{
			if(jsonObject==null||jsonObject.isEmpty())
			{
				//System.out.println("jsonObject is  null or empty for the parameter :"+parameter);
				return value;
			}
			if(isLong)
			{
				try
				{
					long valLong=((Long)jsonObject.get(parameter)).longValue();
					value=valLong;
				}
				catch (Exception e)
				{
					value=1.0;
				}
			}
			else
			{
				String valueStr=null;
				try
				{
					valueStr=(String)jsonObject.get(parameter);	
				}
				catch (Exception e)
				{
					//System.out.println("Exception raised while parsing json object for the parmeter :"+parameter+" , Exception message :"+e.toString());
				}
				if(valueStr==null||valueStr.trim().length()==0||valueStr.equalsIgnoreCase("none")||valueStr.equalsIgnoreCase("null"))
				{
					value=1.0;
				}
				else
				{
					try
					{
						value=Double.parseDouble(valueStr);
					}
					catch (Exception e) 
					{
						value=1.0;
					}
				}
				//System.out.println("Parameter : "+parameter +" value: "+value);
			}
		}
		catch (Exception e)
		{
			//System.out.println("getValueFromJSONObject got exception "+e.toString());
		}
		return value;
	}
%>

<%
	ArrayList infoArrayList=new ArrayList();
	String address  = null;
	String userName = null;
	String password = null;
	boolean debug   = false;
	String proto    = "http";
	boolean isSsl=false;
	String urlString="";
	boolean isXIOAPIVersion1=false;
	address  = request.getParameter("host");
	userName = request.getParameter("XtremIO_user");
	password = request.getParameter("XtremIO_password");
	password = decrypt(password);
	String strTokenSalt = password; //salt for pwd
	if (strTokenSalt.indexOf("~EG~") != -1)
	{
		password = strTokenSalt.substring(0,strTokenSalt.indexOf("~EG~"));
	}

	proto    = request.getParameter("ssl");
	proto    = proto.toLowerCase();
	double restAPIVersion=1.0;

	if(proto.equalsIgnoreCase("true")||proto.equalsIgnoreCase("yes"))
	{
		proto    = "https";	
		isSsl    = true;
	}

	if (isSsl)
		urlString = "https://"+address+"/";
	else
		urlString = "http://"+address+"/";

	HttpURLConnection connection=null;
	
	try
	{
		JSONObject rootJson = new JSONObject();
		JSONArray clusterArr = new JSONArray();

		if(isSsl)
		{
			// Dynamically add the ssl provider. In our case its SUN
			Security.addProvider(new com.sun.net.ssl.internal.ssl.Provider());
			// Now set System properties
			System.setProperty( "java.protocol.handler.pkgs","com.sun.net.ssl.internal.www.protocol");
			javax.net.ssl.SSLSocketFactory sf = (javax.net.ssl.SSLSocketFactory)javax.net.ssl.SSLSocketFactory.getDefault();
			//Create a null SSLSocket
			javax.net.ssl.SSLSocket sock = null;
			// Try to connect to Secure server
			
			X509TrustManager tm = new MyX509TrustManager();
			KeyManager []km = null;
			TrustManager []tma = {tm};
			SSLContext sc = SSLContext.getInstance("SSL");
			sc.init(km,tma,new java.security.SecureRandom());
			SSLSocketFactory sf1 = sc.getSocketFactory();
			HttpsURLConnection.setDefaultSSLSocketFactory(sf1);
			HttpsURLConnection.setDefaultHostnameVerifier(new MyHostnameVerifier());
		}

		String uri=urlString+"api/json/v2/types/xms";
		//uri+=".json"; //for local testing only
		//System.out.println("uri  : "+uri);

		URL url = new URL(uri);
		String authStr = userName + ":" + password;
		byte[] authEncBytes = Base64.encodeBase64(authStr.getBytes());
		String authEncoded = new String(authEncBytes);
		connection = (HttpURLConnection) url.openConnection();
		connection.setRequestMethod("GET");
		connection.setDoInput(true);
		connection.setDoOutput(true);
		connection.setConnectTimeout(500);
		connection.setRequestProperty("Authorization", "Basic " + authEncoded);
		connection.setRequestProperty("Cache-Control","no-cache");
		connection.connect();

		com.eg.ConnectionThread ct= new com.eg.ConnectionThread(connection,false);
		int code = 0;
		boolean flag = checkForTimeout (ct);
		StringBuilder sb = new StringBuilder();

		if(flag)
		{
			code=ct.code;
			if(code != 200)
			{
				//out.println("<BR>Error in getJSONDataFromURL method REST url connection ..."+code);
			}
			ArrayList data=ct.data;
			if (data == null || data.isEmpty()|| data.size() == 0)
			{
				restAPIVersion=1.0;
				JSONObject clusterDataObj = new JSONObject();
				clusterDataObj.put("displayField","none");
				clusterDataObj.put("valueField","none");
				clusterArr.add(clusterDataObj);

				rootJson.put("restAPIVersion",new Double(restAPIVersion));
				rootJson.put("clusterArr",clusterArr);

				//out.println("<BR> Data null or empty data");
				// No data has been receieved so return
			}
			for (int n=0;n<data.size() ; n++)
			{
				//System.out.println("data.get(n) "+data.get(n));
				sb.append((String)data.get(n));
			}
		}
		if (!flag || code != 200)
		{
			//out.println("<BR> Timing out or invalid response code:"+code);
			//out.println("<BR> Please try again ,or check the input details ");
		}
		ct=null;
		connection.disconnect();
		//System.out.println("code  : "+code);
		if(code == 400)
		{
			isXIOAPIVersion1=true;
			restAPIVersion=1.0;
			infoArrayList=new ArrayList();
			infoArrayList.add(new Double(restAPIVersion));
			infoArrayList.add(new String("none"));

			JSONObject clusterDataObj = new JSONObject();
			clusterDataObj.put("displayField","none");
			clusterDataObj.put("valueField","none");
			clusterArr.add(clusterDataObj);

			rootJson.put("restAPIVersion",new Double(restAPIVersion));
			rootJson.put("clusterArr",clusterArr);
		}

		//isXIOAPIVersion1  if false return the process to back 

		if (!isXIOAPIVersion1)
		{
			String result=sb.toString();
			//System.out.println("result "+result);
			Hashtable typeHashtable=new Hashtable();
			try {
				/*uri=param;
				if(param.lastIndexOf("/")>-1)
					{
						param=param.substring(param.lastIndexOf("/")+1);
						if(param.equalsIgnoreCase("xms"))
							param+="s";
					}*/
				String param="xmss";
				String jsonText=result;
				//out.println(jsonText);
				if(jsonText != null && jsonText.length() > 0)
				{
					JSONParser parser = new JSONParser();
					JSONObject totalresultobj =null;
					try {
						totalresultobj = (JSONObject)parser.parse(jsonText);
	//					out.println("  "+totalresultobj);
					} catch (ParseException e) {
						e.printStackTrace();
					}
					
					JSONArray clusterArray = (JSONArray)totalresultobj.get(param);
					int i=0;
					while(i<clusterArray.size())
					{
						JSONObject clusterObj=(JSONObject)clusterArray.get(i);
						String  href=(String)clusterObj.get("href");
						String name=(String)clusterObj.get("name");
						//System.out.println("<BR>  HREF  :"+href);
						//System.out.println("<BR>  NAME  :"+name);
						if(href!=null&&href.trim().length()>0&&name!=null&&name.trim().length()>0)
							typeHashtable.put(name,href);
						i++;
					}
				}
			} catch (Exception e) 
			{
				//System.out.println("<BR> Error in getTypeDataHashtable  method : "+e.toString());
			}
			
			//out.println("<BR> "+result);
			//out.println("<BR> typeHashtable  :"+typeHashtable);

			Enumeration enu1=typeHashtable.keys();
			while(enu1!=null&&enu1.hasMoreElements())
			{
				String key=(String)enu1.nextElement();
				uri=(String)typeHashtable.get(key);
				//uri+=".json"; //for local testing only
				//System.out.println("uri  222 : "+uri);
				url = new URL(uri);
				connection = (HttpURLConnection) url.openConnection();
				connection.setRequestMethod("GET");
				connection.setDoInput(true);
				connection.setDoOutput(true);
				connection.setConnectTimeout(500);
				connection.setRequestProperty("Authorization", "Basic " + authEncoded);
				connection.setRequestProperty("Cache-Control","no-cache");
				connection.connect();
				ct= new com.eg.ConnectionThread(connection,false);
				code = 0;
				flag = checkForTimeout (ct);
				sb = new StringBuilder();
				if(flag)
				{
					code=ct.code;
					if(code != 200)
					{
						//out.println("<BR>Error in getJSONDataFromURL method REST url connection ..."+code);
					}
					ArrayList data=ct.data;
					if (data == null || data.isEmpty()|| data.size() == 0)
					{
						//out.println("<BR> Data null or empty data");
						// No data has been receieved so return
					}
					for (int n=0;n<data.size() ; n++)
					{
						sb.append((String)data.get(n));
					}
				}
				if (!flag || code != 200)
				{
					//out.println("<BR> Timing out or invalid response code:"+code);
					//out.println("<BR> Please try again ,or check the input details ");
				}
				ct=null;
				connection.disconnect();

				String jsonText=sb.toString();
				JSONObject totalresultobj=null;
				if(jsonText != null && jsonText.length() > 0)
				{
					JSONParser parser = new JSONParser();
					try {
						totalresultobj = (JSONObject)parser.parse(jsonText);
						//printOut(" totalresultobj  "+totalresultobj);
					} catch (ParseException e) {
						e.printStackTrace();
					}
					JSONObject clusterObject = (JSONObject)totalresultobj.get("content");
					//printOut("content : "+clusterObject);
					
					restAPIVersion=getValueFromJSONObject(clusterObject,"restapi-protocol-version",false);
					//out.println("<BR> restapi-protocol-version  :"+restAPIVersion);
				}
			}
			//System.out.println("restAPIVersion     ::    "+restAPIVersion);
			if(restAPIVersion>1)
			{
				uri=urlString+"/api/json/v2/types/clusters";
				//uri+=".json"; //for local testing only
				url = new URL(uri);
				connection = (HttpURLConnection) url.openConnection();
				connection.setRequestMethod("GET");
				connection.setDoInput(true);
				connection.setDoOutput(true);
				connection.setConnectTimeout(500);
				connection.setRequestProperty("Authorization", "Basic " + authEncoded);
				connection.setRequestProperty("Cache-Control","no-cache");
				connection.connect();
				
				ct= new com.eg.ConnectionThread(connection,false);
				code = 0;
				flag = checkForTimeout (ct);
				sb = new StringBuilder();
				if(flag)
				{
					code=ct.code;
					if(code != 200)
					{
						//out.println("<BR>Error in getJSONDataFromURL method REST url connection ..."+code);
					}
					ArrayList data=ct.data;
					if (data == null || data.isEmpty()|| data.size() == 0)
					{
						JSONObject clusterDataObj = new JSONObject();
						clusterDataObj.put("displayField","none");
						clusterDataObj.put("valueField","none");
						clusterArr.add(clusterDataObj);
						rootJson.put("clusterArr", clusterArr);
						restAPIVersion=1.0;
						rootJson.put("restAPIVersion",new Double(restAPIVersion));

						//out.println("<BR> Data null or empty data");
						// No data has been receieved so return
					}
					for (int n=0;n<data.size() ; n++)
					{
						sb.append((String)data.get(n));
					}
				}
				if (!flag || code != 200)
				{
					//out.println("<BR> Timing out or invalid response code:"+code);
					//out.println("<BR> Please try again ,or check the input details ");
				}
				ct=null;
				connection.disconnect();
				Hashtable clusterHashtable=new Hashtable();
				try {
					/*uri=param;
					if(param.lastIndexOf("/")>-1)
						{
							param=param.substring(param.lastIndexOf("/")+1);
							if(param.equalsIgnoreCase("xms"))
								param+="s";
						}*/
					String param="clusters";
					String jsonText=sb.toString();;
					//out.println(jsonText);
					if(jsonText != null && jsonText.length() > 0)
					{
						JSONParser parser = new JSONParser();
						JSONObject totalresultobj =null;
						try {
							totalresultobj = (JSONObject)parser.parse(jsonText);
		//					out.println("  "+totalresultobj);
						} catch (ParseException e) {
							e.printStackTrace();
						}
						JSONArray clusterArray = (JSONArray)totalresultobj.get(param);
						int i=0;
						infoArrayList=new ArrayList();
						infoArrayList.add(new Double(restAPIVersion));
						while(i<clusterArray.size())
						{
							JSONObject clusterObj=(JSONObject)clusterArray.get(i);
							JSONObject clusterDataObj= new JSONObject();
							String  href=(String)clusterObj.get("href");
							String name=(String)clusterObj.get("name");
							//out.println("<BR>  HREF  :"+href);
							//out.println("<BR>  NAME  :"+name);
							if(href!=null&&href.trim().length()>0&&name!=null&&name.trim().length()>0)
							{
								clusterHashtable.put(name,href);
								infoArrayList.add(new String(name));
								clusterDataObj.put("displayField",name);
								clusterDataObj.put("valueField",name);
								clusterArr.add(clusterDataObj);
							}
							i++;
						}
					}
				} catch (Exception e) {
					//System.out.println("<BR> Error in getTypeDataHashtable  method : "+e.toString());
				}
				//out.println("<BR> "+result);
				//out.println("<BR> clusterHashtable  :"+clusterHashtable);
				//out.println("<BR> infoArrayList  :"+infoArrayList);
			}
			else
			{
				restAPIVersion=1.0;
				infoArrayList=new ArrayList();
				infoArrayList.add(new Double(restAPIVersion));
				infoArrayList.add(new String("none"));

				JSONObject clusterDataObj = new JSONObject();
				clusterDataObj.put("displayField","none");
				clusterDataObj.put("valueField","none");
				clusterArr.add(clusterDataObj);
			}
			//out.println("<BR> infoArrayList  :"+infoArrayList);
			rootJson.put("clusterArr", clusterArr);
			rootJson.put("restAPIVersion",new Double(restAPIVersion));
		}
		out.println(rootJson.toString());
	}
	catch(Exception e)
	{
		//System.out.println("<br>EMCXIOCluster.jsp : Exception thrown while processing <br>" + e);
	}
	finally
	{
		try 
		{
			connection = null;
//			if (session != null)
//				session.invalidate();
		}catch (Exception e){}
	}
%>
