<%
/*****************************************************************************************************
*	Name		:	EgVMLogDetails.jsp
*	Purpose		:	To view the Log Files from the selected Agent.
******************************************************************************************************/
%>
<%@ include file="../../EgTrackerAJSON.jsp" %>
<%@ page import="com.eg.EgURLEncoder" %>
<%@ page import = "com.eg.EgURLDecoder"%>
<%@ page import="com.eg.EgLicenseInfo" %>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ page import="net.sf.json.*"%>

<%
try
{
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);

	JSONObject rootJson = new JSONObject();
	JSONObject screenLabels = new JSONObject();
	JSONObject hiddenObj = new JSONObject();

	EgRoleInfo roleInfo = EgRoleInfo.getInstance(sessionID,_user.getLoginID());
	boolean hasAllCompAccess = roleInfo.hasAllComponentAccess(); // For Limited admin
	boolean isLimitedAdmin = !hasAllCompAccess;
	EgLicenseInfo licInfo = new EgLicenseInfo();
	ArrayList agentList = new ArrayList();
	if (isLimitedAdmin)
	{
		agentList = roleInfo.getRemoteAgents();
	}
	else
	{
		agentList = licInfo.getRemoteAgents();
	}
	String from = request.getParameter("from");
	String agentId = request.getParameter("componentName");
	rootJson.put("from",from);
	rootJson.put("componentName",agentId);


	if(from!=null && !from.equals("testconfig"))
	{
		JSONArray remoteAgentArr = new JSONArray();
		JSONObject remoteAgentObj = new JSONObject();
		remoteAgentObj.put("displayField",_mapping.getTextDescription("admin.agents.Please choose a remote agent"));
		remoteAgentObj.put("valueField","-1");
		remoteAgentArr.add(remoteAgentObj);

		if (agentList!=null && agentList.size() > 0 )
		{
			for ( int i=0; i< agentList.size();i++)
			{
				String remoteAgent = (String) agentList.get(i);
				String selected="";
				remoteAgentObj.put("displayField",remoteAgent);
				remoteAgentObj.put("valueField",remoteAgent);
				remoteAgentArr.add(remoteAgentObj);
				if(agentId!=null && agentId.equals(remoteAgent))
				{
					rootJson.put("selectedRemoteAgent",remoteAgent);
					selected="selected";
				}
			}
		}
		rootJson.put("remoteAgentArr",remoteAgentArr);
	}
	else if(from!=null && from.equals("testconfig"))
	{
		JSONArray testConfigRemoteAgentArr = new JSONArray();
		JSONObject testConfigRemoteAgentObj = new JSONObject();
		testConfigRemoteAgentObj.put("displayField",_mapping.getTextDescription("admin.agents.Please choose a remote agent"));
		testConfigRemoteAgentObj.put("valueField","-1");
		testConfigRemoteAgentArr.add(testConfigRemoteAgentObj);
		if (agentList!=null && agentList.size() > 0 )
		{
			for ( int i=0; i< agentList.size();i++)
			{
				String remoteAgent = (String) agentList.get(i);
				testConfigRemoteAgentObj.put("displayField",remoteAgent);
				testConfigRemoteAgentObj.put("valueField",remoteAgent);
				testConfigRemoteAgentArr.add(testConfigRemoteAgentObj);
			}
		}
		rootJson.put("remoteAgentArr",testConfigRemoteAgentArr);
	}

	hiddenObj.put("currentFile",agentId);
	hiddenObj.put("nick","eg_vm.ini");
	rootJson.put("hiddenObj",hiddenObj);
	out.println(rootJson.toString());
}
catch(Exception e)
{
	e.printStackTrace();
}

%>



