<%@ include file = "../../EgTrackerAJSON.jsp" %>
<%@ page import = "com.egurkha.util.*"%>
<%@ page import = "java.util.*"%>
<%@ page import = "com.eg.EgExternalInfo" %>
<%@ page import = "com.egurkha.admin.AuditLogThread"%>
<%@ page import = "com.egurkha.admin.RemoteAgent"%>
<%@ page import = "net.sf.json.*"%>
<%@ page import = "com.eg.IniFile" %>
<%@ page language = "java" contentType = "text/html; charset=UTF-8" pageEncoding = "UTF-8" %>

<%
	JSONObject rootJson = new JSONObject();
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json");

	String s_mode = request.getParameter("mode");
	String s_url = request.getParameter("rumUrl");
	String s_hostname = request.getParameter("hostname");
	String s_privateurl = request.getParameter("rumPrivateUrl");
	
	s_mode = (s_mode == null? "" : s_mode);
	s_url = (s_url == null? "" : s_url);
	s_hostname = (s_hostname == null? "" : s_hostname);
	s_privateurl = ((s_privateurl == null || s_privateurl == "" )? s_url : s_privateurl);
	

	/* code for auditlog starts */
	AuditLogThread auditLogThread = new AuditLogThread();
	auditLogThread.setValue("Category","Admin");
	auditLogThread.setValue("User_id",_user.getLoginID());
	auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
	auditLogThread.setValue("Session_id",session.getId());
	auditLogThread.setValue("Module","RUM Data Collectors");
	/* code for auditlog ends */
	JSONObject errorMsg = new JSONObject();
	JSONObject resultMsg = new JSONObject();

	EgUserElementsInfo userElementsInfo = new EgUserElementsInfo();

	IniFile iniTests = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() +"/manager/config/eg_tests.ini" , true);
	if (s_mode.equalsIgnoreCase("add"))  // Add RUM Collector
	{
		if(s_hostname!=null)
		{
			EgUserRole userRole = _user.getUserRole();
			boolean hasAllComponentAccess = userRole.hasAllComponentAccess();

			iniTests.setValue("PUBLIC_RUM_COLLECTORS",s_hostname,s_url);
			iniTests.setValue("PRIVATE_RUM_COLLECTORS",s_hostname,s_privateurl);

			if(!hasAllComponentAccess)
			{
				String uname = _user.getLoginID();

				EgUuidInfo egUuidInfo = new EgUuidInfo();
				boolean isSuperOrg = egUuidInfo.isSuperOrg(uname);
				boolean isOrg = egUuidInfo.isOrg(uname);

				HashMap sharedUsersMap = egUuidInfo.getSharedUsersForAllOrgs();
				
				ArrayList userList = new ArrayList();
				if (isSuperOrg)
				{
					userList.add(uname);
					ArrayList sharedUsersList = (ArrayList)sharedUsersMap.get(uname);
					userList.addAll(sharedUsersList);
				}
				else if (isOrg)
				{
					List dependentOrgNamesList = egUuidInfo.getOrgNames(uname);
					if (dependentOrgNamesList != null && dependentOrgNamesList.size() > 0)
					{
						for (int i=0; i<dependentOrgNamesList.size(); i++)
						{
							String orgStr = (String)dependentOrgNamesList.get(i);
							userList.add(orgStr);
							ArrayList sharedUsersList = (ArrayList)sharedUsersMap.get(orgStr);
							userList.addAll(sharedUsersList);
						}
					}
				}
				else
				{
					List dependentOrgNamesList = egUuidInfo.getOrgNames(uname);
					if (dependentOrgNamesList != null && dependentOrgNamesList.size() > 0)
					{
						for (int i=0; i<dependentOrgNamesList.size(); i++)
						{
							String orgStr = (String)dependentOrgNamesList.get(i);
							userList.add(orgStr);
							ArrayList sharedUsersList = (ArrayList)sharedUsersMap.get(orgStr);
							userList.addAll(sharedUsersList);
						}
					}
					boolean isShareRole = egUuidInfo.hasOURole(uname);
					if (!isShareRole)
					{
						userList.add(uname);
					}
				}
				if (userList != null && userList.size() > 0)
				{
					for (int i=0; i<userList.size(); i++)
					{
						String usrStr = (String)userList.get(i);
						if (usrStr != null && !usrStr.equalsIgnoreCase("egenterprise"))
						{
							userElementsInfo.updateUserElements(usrStr, "RUMDataCollector", s_hostname);
						}
					}
				}
			}

			rootJson.put("requestStatus","success");
			resultMsg.put("title",_mapping.getTextDescription("admin.server.Configure RUM Data Collectors page"));
			resultMsg.put("message1",_mapping.getTextDescription("admin.server.The RUM Data Collector")+"&nbsp;"+"'"+s_hostname+"'"+"&nbsp;"+_mapping.getTextDescription("admin.server.has been configured successfully")+".");
			rootJson.put("result",resultMsg);
				
		}
		else
		{
			errorMsg.put("title",_mapping.getTextDescription("admin.error.Add new RUM Data Collector"));
			errorMsg.put("message1",_mapping.getTextDescription("admin.error.The RUM Data Collector Nick Name")+" ("+"<b>"+s_hostname+"</b>"+") ");
			rootJson.put("error",errorMsg);
		}
			
		auditLogThread.setValue("Activity","Add/Modify/Delete");
		auditLogThread.setCurrentValue("RUM Url",s_url);
		auditLogThread.setCurrentValue("RUM Private Url",s_privateurl);
		auditLogThread.setCurrentValue("RUM Data Collector Nick Name",s_hostname);
		auditLogThread.setValue("Description","RUM Data Collector has been created");
		auditLogThread.sendItToDB();

		
	}
	if (s_mode.equalsIgnoreCase("modifyUrl")) //Modify RUM Collector
	{
		boolean rumModification=false;
		if(s_hostname!=null)
		{
			String pre_s_url = iniTests.getValue("PUBLIC_RUM_COLLECTORS",s_hostname);
			String pre_s_privateurl = iniTests.getValue("PRIVATE_RUM_COLLECTORS",s_hostname);

			iniTests.setValue("PUBLIC_RUM_COLLECTORS",s_hostname,s_url);
			iniTests.setValue("PRIVATE_RUM_COLLECTORS",s_hostname,s_privateurl);

			auditLogThread.setValue("Activity","Add/Modify/Delete");
			auditLogThread.setPreviousValue("RUM Url",pre_s_url);
			auditLogThread.setCurrentValue("RUM Url",s_url);
			auditLogThread.setPreviousValue("RUM Private Url",pre_s_privateurl);
			auditLogThread.setCurrentValue("RUM Private Url",s_privateurl);
			auditLogThread.setValue("Description","RUM Data Collector has been modified");

			if (!pre_s_url.equals(s_url) || !pre_s_privateurl.equals(s_privateurl))
			{
				auditLogThread.sendItToDB();
			}

			rootJson.put("requestStatus","success");
			resultMsg.put("title",_mapping.getTextDescription("admin.server.Configure RUM Data Collectors page"));
			resultMsg.put("message1",_mapping.getTextDescription("admin.server.The RUM Data Collector ")+"&nbsp;"+"'"+s_hostname+"'"+"&nbsp;"+_mapping.getTextDescription("admin.server.has been updated successfully")+".");
		}
		
		rootJson.put("result",resultMsg);

		
	}
	if(s_mode.equalsIgnoreCase("del")) // Delete RUM Collector
	{
		boolean isRUMdeleted=false;
		if(s_hostname!=null)
		{
			userElementsInfo.deleteAgentDetails("RUMDataCollector",s_hostname);
			iniTests.deleteValue("PUBLIC_RUM_COLLECTORS",s_hostname);
			iniTests.deleteValue("PRIVATE_RUM_COLLECTORS",s_hostname);
			isRUMdeleted=true;
		}
		if (isRUMdeleted)
		{
			rootJson.put("requestStatus","success");
			resultMsg.put("title",_mapping.getTextDescription("admin.server.Configure RUM Data Collectors page"));
			resultMsg.put("message1",_mapping.getTextDescription("admin.server.The RUM Data Collector")+"&nbsp;"+"'"+s_hostname+"'"+"&nbsp;"+_mapping.getTextDescription("admin.server.has been deleted successfully")+".");
			rootJson.put("result",resultMsg);
			auditLogThread.setValue("Activity","Add/Modify/Delete");
			auditLogThread.setCurrentValue("RUM Data Collector Nick Name",s_hostname);
			auditLogThread.setValue("Description","RUM Collector has been deleted");
			auditLogThread.sendItToDB();
		}else
		{
			errorMsg.put("title",_mapping.getTextDescription("admin.error.Delete RUM Data Collector"));
			errorMsg.put("message1",_mapping.getTextDescription("admin.error.RUM Data Collector has not been deleted"));
			rootJson.put("error",errorMsg);
			
		}
	}
	iniTests.saveFile();
	EgConfigFilesSync.releaseInstance(iniTests);
	out.println(rootJson.toString());
%>



