<%@ include file="../../EgTrackerAJSON.jsp" %>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ page import="org.json.simple.*"%>
<%@ page import="java.io.*"%>
<%@ page import="java.util.*"%>
<%@ page import="com.egurkha.EgUserRole"%>
<%@ page import="com.egurkha.EgUserPermission"%>

<%
	JSONObject rootJson = new JSONObject();
	JSONObject jsonObj = new JSONObject();
	JSONArray jsonArr = new JSONArray();
	String from = request.getParameter("from");

	IniFile clsIni = new IniFile (EgInstallInfo.getInstallDir()+"/manager/config/eg_ls_portal.ini");
	String cloudModel = clsIni.getValue("LS_TRIAL_SETTINGS","cloudModel");

	EgUserRole userRole = _user.getUserRole();
	boolean allCompAccess=userRole.hasAllComponentAccess();
	String roleName     = userRole.getRoleName();
	EgUserPermission sas = EgUserPermission.getInstance();
	long perValue = userRole.getAdminPerm();
	ArrayList adminPermCheckList = sas.getPrivilegeList(roleName,perValue,0);//admin role privilege list.
	String[][] allGroupNames = sas.getAdminDesc();//all admin groups.
	boolean hasUserManagementEnabled = false;
	boolean hasMaintenancePolicyEnabled = false;
	boolean hasComponentMangamentEnabled = false;
	boolean hasSegmentConfigEnabled = false;
	boolean hasServiceConfigEnabled = false;
	boolean hasAgentTestEnabled = false;
	boolean hasAgentThreshEnabled = false;
	boolean hasZonesEnabled = false;
	boolean hasComponentGrpEnabled = false;
	boolean hasGlobalThreshEnabled = false;
	boolean hasGlobalTestEnabled = false;
	boolean hasExtRemAgentsEnabled = false;

	for (int i=0;i<allGroupNames.length;i++)
	{
		String temp = allGroupNames[i][0];
		if (!adminPermCheckList.contains(temp))
		{
			continue;
		}
		if (temp.equalsIgnoreCase("User Management"))
		{
			hasUserManagementEnabled = true;
		}
		else if (temp.equalsIgnoreCase("Maintenance Policy Configuration"))
		{
			hasMaintenancePolicyEnabled = true;
		}
		else if (temp.equalsIgnoreCase("Component Management"))
		{
			hasComponentMangamentEnabled = true;
		}
		else if (temp.equalsIgnoreCase("Segment Configuration"))
		{
			hasSegmentConfigEnabled = true;
		}
		else if (temp.equalsIgnoreCase("Service Configuration"))
		{
			hasServiceConfigEnabled = true;
		}
		else if (temp.equalsIgnoreCase("Agent Test Configuration"))
		{
			hasAgentTestEnabled = true;
		}
		else if (temp.equalsIgnoreCase("Agent Threshold Configuration"))
		{
			hasAgentThreshEnabled = true;
		}
		else if (temp.equalsIgnoreCase("Zone Configuration"))
		{
			hasZonesEnabled = true;
		}
		else if (temp.equalsIgnoreCase("Group Configuration"))
		{
			hasComponentGrpEnabled = true;
		}
		else if (temp.equalsIgnoreCase("Global Threshold Configuration"))
		{
			hasGlobalThreshEnabled = true;
		}
		else if (temp.equalsIgnoreCase("Global Agent Test Configuration"))
		{
			hasGlobalTestEnabled = true;
		}
		else if (temp.equalsIgnoreCase("External/Remote Agent Configuration"))
		{
			hasExtRemAgentsEnabled = true;
		}
	}
	

	boolean isUserManagementEnabled = false;
	if (hasUserManagementEnabled)
	{
		isUserManagementEnabled = true;
	}

	boolean hasTestEnabled = false;
	if (hasGlobalTestEnabled || hasAgentTestEnabled)
	{
		hasTestEnabled = true;
	}

	boolean hasThreshEnabled = false;
	if (hasGlobalThreshEnabled || hasAgentThreshEnabled)
	{
		hasThreshEnabled = true;
	}
	
	boolean hasAggComponentMangamentEnabled = false;
	boolean aggregateEnabled = EgInstallInfo.isAggSupported;
	if (aggregateEnabled && hasComponentMangamentEnabled)
	{
		hasAggComponentMangamentEnabled = true;
	}

	if (from != null && from.equalsIgnoreCase("manageInfraItems"))
	{
		if (hasComponentMangamentEnabled)
		{
			jsonObj = new JSONObject();
			jsonObj.put("displayField",_mapping.getTextDescription("admin.la.Add/Modify Component"));
			jsonObj.put("valueField","gotoComponentsPage");
			jsonObj.put("content",_mapping.getTextDescription("admin.la.Add/Modify a component")+".");
			jsonObj.put("image","comp-server");
			jsonArr.add(jsonObj);

			if (allCompAccess || (cloudModel != null && !cloudModel.equalsIgnoreCase("phoenix") && !allCompAccess))
			{
				jsonObj = new JSONObject();
				jsonObj.put("displayField",_mapping.getTextDescription("admin.la.Manage/Unmanage Component"));
				jsonObj.put("valueField","gotoManageComponentsPage");
				jsonObj.put("content",_mapping.getTextDescription("admin.la.Manage/Unmanage/Delete a component")+".");
				jsonObj.put("image","comp-server");
				jsonArr.add(jsonObj);
			}
		}
		
		if (hasExtRemAgentsEnabled)
		{
			jsonObj = new JSONObject();
			jsonObj.put("displayField",_mapping.getTextDescription("admin.la.Configure External Agent"));
			jsonObj.put("valueField","specificExternalAgentsWindow");
			jsonObj.put("content",_mapping.getTextDescription("admin.la.Add/Modify/Delete an external agent")+".");
			jsonObj.put("image","gen-external-agent");
			jsonArr.add(jsonObj);

			jsonObj = new JSONObject();
			jsonObj.put("displayField",_mapping.getTextDescription("admin.la.Configure Remote Agent"));
			jsonObj.put("valueField","configureRemoteAgents");
			jsonObj.put("content",_mapping.getTextDescription("admin.la.Add/Modify/Delete a remote agent")+".");
			jsonObj.put("image","gen-remoteagent");
			jsonArr.add(jsonObj);
		}

		if (hasComponentMangamentEnabled)
		{
			jsonObj = new JSONObject();
			jsonObj.put("displayField",_mapping.getTextDescription("admin.la.Configure RUM Data Collector"));
			jsonObj.put("valueField","configureRUMDataCollectors");
			jsonObj.put("content",_mapping.getTextDescription("admin.la.Add/Modify/Delete a RUM data collector")+".");
			jsonObj.put("image","gen-rum-data-collector");
			jsonArr.add(jsonObj);
		}

		if (cloudModel != null && cloudModel.equalsIgnoreCase("phoenix"))
		{
			jsonObj = new JSONObject();
			jsonObj.put("displayField",_mapping.getTextDescription("admin.la.Download Internal Agent"));
			jsonObj.put("valueField","downloadInternalAgents");
			jsonObj.put("content",_mapping.getTextDescription("admin.la.Download an internal agent")+".");
			jsonObj.put("image","comp-user-server");
			jsonArr.add(jsonObj);
			
			jsonObj = new JSONObject();
			jsonObj.put("displayField",_mapping.getTextDescription("admin.la.Download VM Agent"));
			jsonObj.put("valueField","downloadVMAgents");
			jsonObj.put("content",_mapping.getTextDescription("admin.la.Download a VM agent")+".");
			jsonObj.put("image","comp-vm-server");
			jsonArr.add(jsonObj);
		}
		
		if (allCompAccess || (cloudModel != null && !cloudModel.equalsIgnoreCase("phoenix") && !allCompAccess))
		{
			if (hasComponentGrpEnabled)
			{
				jsonObj = new JSONObject();
				jsonObj.put("displayField",_mapping.getTextDescription("admin.la.Configure Group"));
				jsonObj.put("valueField","gotoGroupsPage");
				jsonObj.put("content",_mapping.getTextDescription("admin.la.Add/Modify/Delete a group")+".");
				jsonObj.put("image","gen-servicegroups");
				jsonArr.add(jsonObj);
			}
			
			if (hasSegmentConfigEnabled)
			{
				jsonObj = new JSONObject();
				jsonObj.put("displayField",_mapping.getTextDescription("admin.la.Configure Segment"));
				jsonObj.put("valueField","gotoSegmentsPage");
				jsonObj.put("content",_mapping.getTextDescription("admin.la.Add/Modify/Delete a segment")+".");
				jsonObj.put("image","gen-segment");
				jsonArr.add(jsonObj);
			}
			
			if (hasServiceConfigEnabled)
			{
				jsonObj = new JSONObject();
				jsonObj.put("displayField",_mapping.getTextDescription("admin.la.Configure Service"));
				jsonObj.put("valueField","gotoServicesPage");
				jsonObj.put("content",_mapping.getTextDescription("admin.la.Add/Modify/Delete a service")+".");
				jsonObj.put("image","gen-services");
				jsonArr.add(jsonObj);
			}
			
			if (hasZonesEnabled)
			{
				jsonObj = new JSONObject();
				jsonObj.put("displayField",_mapping.getTextDescription("admin.la.Configure Zone"));
				jsonObj.put("valueField","gotoZonePage");
				jsonObj.put("content",_mapping.getTextDescription("admin.la.Add/Modify/Delete a zone")+".");
				jsonObj.put("image","gen-zones");
				jsonArr.add(jsonObj);
			}
			
			if (hasAggComponentMangamentEnabled)
			{
				jsonObj = new JSONObject();
				jsonObj.put("displayField",_mapping.getTextDescription("admin.la.Add/Modify Aggregates"));
				jsonObj.put("valueField","gotoAggComponentsPage");
				jsonObj.put("content",_mapping.getTextDescription("admin.la.Add/Modify an aggregate component")+".");
				jsonObj.put("image","comp-aggregates");
				jsonArr.add(jsonObj);

				jsonObj = new JSONObject();
				jsonObj.put("displayField",_mapping.getTextDescription("admin.la.Manage/Unmanage Aggregates"));
				jsonObj.put("valueField","gotoAggManageComponentsPage");
				jsonObj.put("content",_mapping.getTextDescription("admin.la.Manage/Unmanage/Delete an aggregate component")+".");
				jsonObj.put("image","comp-aggregates");
				jsonArr.add(jsonObj);
			}
		}
		rootJson.put("manageInfraItems",jsonArr);
	}
	else if (from != null && from.equalsIgnoreCase("refineConfigItems"))
	{
		if (hasTestEnabled)
		{
			jsonObj = new JSONObject();
			jsonObj.put("displayField",_mapping.getTextDescription("admin.la.Configure Tests"));
			jsonObj.put("valueField","specificTestConfigWindow");
			jsonObj.put("content",_mapping.getTextDescription("admin.la.Configure the tests executed by the agents")+".");
			jsonObj.put("image","gen-testconfiguration");
			jsonArr.add(jsonObj);
		}
		
		if (hasThreshEnabled)
		{
			jsonObj = new JSONObject();
			jsonObj.put("displayField",_mapping.getTextDescription("admin.la.Set Thresholds"));
			jsonObj.put("valueField","specificThresholdConfigWindow");
			jsonObj.put("content",_mapping.getTextDescription("admin.la.Set thresholds for the measures associated with a test")+".");
			jsonObj.put("image","gen-thresholds");
			jsonArr.add(jsonObj);
		}
		
		if (hasMaintenancePolicyEnabled)
		{
			jsonObj = new JSONObject();
			jsonObj.put("displayField",_mapping.getTextDescription("admin.la.Set Maintenance Policy"));
			jsonObj.put("valueField","gotoMaintenancePolicyPage");
			jsonObj.put("content",_mapping.getTextDescription("admin.la.Set maintenance policy for a component, test or descriptor")+".");
			jsonObj.put("image","gen-maintenance");
			jsonArr.add(jsonObj);
		}
		rootJson.put("refineConfigItems",jsonArr);
	}
	else if (from != null && from.equalsIgnoreCase("usermanage"))
	{
		if (isUserManagementEnabled)
		{
			jsonObj = new JSONObject();
			jsonObj.put("displayField",_mapping.getTextDescription("admin.la.Add User"));
			jsonObj.put("valueField","gotoAddUserPage");
			jsonObj.put("content",_mapping.getTextDescription("admin.la.Add new users")+".");
			jsonObj.put("image","gen-add-user");
			jsonArr.add(jsonObj);

			jsonObj = new JSONObject();
			jsonObj.put("displayField",_mapping.getTextDescription("admin.la.Modify User"));
			jsonObj.put("valueField","gotoModifyUserPage");
			jsonObj.put("content",_mapping.getTextDescription("admin.la.Modify existing users")+".");
			jsonObj.put("image","gen-edit-user");
			jsonArr.add(jsonObj);

			jsonObj = new JSONObject();
			jsonObj.put("displayField",_mapping.getTextDescription("admin.la.Delete User"));
			jsonObj.put("valueField","gotoDeleteUserPage");
			jsonObj.put("content",_mapping.getTextDescription("admin.la.Delete existing users")+".");
			jsonObj.put("image","gen-delete-user");
			jsonArr.add(jsonObj);

			jsonObj = new JSONObject();
			jsonObj.put("displayField",_mapping.getTextDescription("admin.la.Clone User"));
			jsonObj.put("valueField","gotoCloneUserPage");
			jsonObj.put("content",_mapping.getTextDescription("admin.la.Replicate the preferences/settings of existing users")+".");
			jsonObj.put("image","gen-clone-user");
			jsonArr.add(jsonObj);

			jsonObj = new JSONObject();
			jsonObj.put("displayField",_mapping.getTextDescription("admin.la.View User"));
			jsonObj.put("valueField","gotoViewUserPage");
			jsonObj.put("content",_mapping.getTextDescription("admin.la.View existing users")+".");
			jsonObj.put("image","gen-view-user");
			jsonArr.add(jsonObj);
		}
		rootJson.put("userManageItems",jsonArr);
	}

	session.setAttribute("adminLastAccessedURL","/final/admin/EgAdminOperations.jsp?"+request.getQueryString());
	out.println(rootJson.toString());
%>



