<%@ include file="../../EgTrackerAJSON.jsp" %>
<%@ page import = "org.json.simple.*"%>
<%@ page import = "java.io.*" %>
<%@ page import="java.util.*" %>
<%@ page import="com.eg.EgInstallInfo" %>
<%@ page import="com.egurkha.util.StringUtils"%>
<%@ page import="com.egurkha.ini.IniUI"%>
<%@ page import = "com.egurkha.admin.AuditLogThread"%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json");
	
	JSONObject rootObj = new JSONObject();
	JSONObject resultMsg = new JSONObject();
	rootObj.put("success","true");

	
	String from = request.getParameter("from");
	String agentName = request.getParameter("agent");
	String fromAction = request.getParameter("fromAction");

	IniFile extMonIni = new IniFile(EgInstallInfo.getInstallDir() +"/manager/config/eg_externalDiscovery.ini");
	String [] subjects = extMonIni.getSubjects();
	String [] variables = extMonIni.getVariables(agentName);

	/* code for auditlog starts */
	boolean auditFlag = false;
	AuditLogThread auditLogThread = new AuditLogThread();
	auditLogThread.setValue("Category","Admin");
	auditLogThread.setValue("User_id",_user.getLoginID());
	auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
	auditLogThread.setValue("Session_id",session.getId());
	auditLogThread.setValue("Module","Discover/Monitor Network Devices");
	/* code for auditlog ends */

	if (!StringUtils.isNull(from) && from.equalsIgnoreCase("addExternal"))
	{
		String iprange = request.getParameter("iprange");
		String discEnabled = request.getParameter("EnableDiscovery");
		String icmpEnabled = request.getParameter("icmp");

		String versionOne = request.getParameter("SNMP_v1");
		String versionTwo = request.getParameter("SNMP_v2");
		String versionThree = request.getParameter("SNMP_v3");

		if(!StringUtils.isNull(discEnabled))
		{
			IniFile extMonIniWrite = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() +"/manager/config/eg_externalDiscovery.ini",true);
			extMonIniWrite.setValue(agentName,"DiscoveryEnabled",discEnabled);
	
			auditLogThread.setValue("Activity","Discovery preferences");
			auditLogThread.setCurrentValue("00~~External agent",agentName);
			auditLogThread.setCurrentValue("01~~Discovery enabled",(discEnabled.equalsIgnoreCase("True") || discEnabled.equalsIgnoreCase("Yes"))?"Yes":"No");

			if(discEnabled.equalsIgnoreCase("yes"))
			{
				String newiprange = iprange;
				StringBuffer newip = new StringBuffer();
				StringTokenizer toks = new StringTokenizer(newiprange,"\n");
				while(toks.hasMoreTokens())
				{
					newip.append(toks.nextToken());
					if (toks.hasMoreTokens()) newip.append(",");
				}

				extMonIniWrite.setValue(agentName,"IP_RANGES",newip.toString());
				extMonIniWrite.setValue(agentName,"UseIcmpForDiscovery",icmpEnabled);

				ArrayList auditAppList = new ArrayList();
				ArrayList auditNtwDeviceList = new ArrayList();

				ArrayList newList = new ArrayList();
				ArrayList oldList = new ArrayList();
				String newPortVal = request.getParameter("changedPorts");
				String oldPortVal = request.getParameter("$_changedPorts");
				String delim = ":,";
				if (newPortVal != null && newPortVal.length()>0)
				{
					if(newPortVal.endsWith(":"))
					{
						newPortVal = newPortVal.substring(0,newPortVal.length()-1);
					}

					String newPortValues[] = StringUtils.getTrimmedTokens(newPortVal, delim);
					newList = new ArrayList(Arrays.asList(newPortValues));
					Collections.sort(newList);
				}

				int ntkSize = newList.size();
				if(newList != null && ntkSize > 0)
				{
					auditFlag = true;
					extMonIniWrite.setValue(agentName,"SNMPRetryCount","0");

					ArrayList srvrsList = new ArrayList();
					for(int i=0; i<ntkSize; i++)
					{
						String newportVal = (String) newList.get(i);

						int index = newportVal.indexOf('$');
						String discserver = newportVal.substring(0,index);
						String portVal = newportVal.substring(index+1);
						if(portVal.indexOf(",")>=0)
						{
							portVal = portVal.replace(',',':');
						}

						String actualServName = discserver.substring(0,discserver.indexOf("~|~"));
						if (!discserver.endsWith(portVal))
						{
							String tmpStr = discserver.substring(0,discserver.lastIndexOf("~|~"));
							discserver = tmpStr +"~|~"+portVal;
						}
						srvrsList.add(discserver);
						if (!StringUtils.isNull(portVal) && !portVal.equals("-"))
						{						
							auditNtwDeviceList.add(_mapping.getComponentTypeDescription(actualServName)+ " - " +portVal);
						}
					}

					String strDiscServers = StringUtils.getString(srvrsList);
					extMonIniWrite.setValue(agentName,"NetworkDevices",strDiscServers);
				}

				ArrayList newAppList = new ArrayList();
				ArrayList oldAppList = new ArrayList();
				String newAppSrvrVal = request.getParameter("appservers");
				String oldAppSrvrVal = request.getParameter("$_appservers");
				if (newAppSrvrVal != null && newAppSrvrVal.length()>0)
				{
					if(newAppSrvrVal.endsWith(":"))
					{
						newAppSrvrVal = newAppSrvrVal.substring(0,newAppSrvrVal.length()-1);
					}

					String newPortValues[] = StringUtils.getTrimmedTokens(newAppSrvrVal, delim);
					newAppList = new ArrayList(Arrays.asList(newPortValues));
					Collections.sort(newAppList);
				}

				int size = newAppList.size();
				if(newAppList != null && size > 0)
				{
					auditFlag = true;

					ArrayList appSrvrsList = new ArrayList();
					for(int i=0; i<size; i++)
					{
						String newAppSrvr = (String) newAppList.get(i);

						int index = newAppSrvr.indexOf('$');
						String discserver = newAppSrvr.substring(0,index);
						String portVal = newAppSrvr.substring(index+1);
						if(portVal.indexOf(",") >= 0)
						{
							portVal = portVal.replace(',',':');
						}

						String actualServName = discserver.substring(0,discserver.indexOf("~|~"));
						if (!discserver.endsWith(portVal))
						{
							String tmpStr = discserver.substring(0,discserver.lastIndexOf("~|~"));
							discserver = tmpStr +"~|~"+portVal;
						}
						appSrvrsList.add(discserver);
						if (!StringUtils.isNull(portVal) && !portVal.equals("-"))
						{
							auditAppList.add(_mapping.getComponentTypeDescription(actualServName)+ " - " +portVal);
						}
					}

					String strDiscAppServers = StringUtils.getString(appSrvrsList);
					extMonIniWrite.setValue(agentName,"Applications",strDiscAppServers);
				}

				/*code for audit log starts*/
				auditLogThread.setCurrentValue("02~~IP RANGES",iprange);
				auditLogThread.setCurrentValue("03~~ICMP enabled",(icmpEnabled.equalsIgnoreCase("True") || icmpEnabled.equalsIgnoreCase("Yes"))?"Yes":"No");
				if (auditAppList != null && !auditAppList.isEmpty())
				{
					auditLogThread.setCurrentValue("04~~Discover applications/servers also?","Yes");
				}
				else
				{
					auditLogThread.setCurrentValue("04~~Discover applications/servers also?","No");
				}

				if (auditNtwDeviceList != null && !auditNtwDeviceList.isEmpty())
				{
					auditLogThread.setCurrentValue("05~~Network Devices",StringUtils.getString(auditNtwDeviceList));
				}
				else
				{
					auditLogThread.setCurrentValue("05~~Network Devices","-");
				}

				if (auditAppList != null && !auditAppList.isEmpty())
				{
					auditLogThread.setCurrentValue("06~~Applications/Servers",StringUtils.getString(auditAppList));
				}
				else
				{
					auditLogThread.setCurrentValue("06~~Applications/Servers","-");
				}
				/*code for audit log ends*/
			}
			extMonIniWrite.saveFile();
			EgConfigFilesSync.releaseInstance(extMonIniWrite);

			auditLogThread.setValue("Description","Discovery preferences have been configured");
			auditLogThread.sendItToDB();

			rootObj.put("success",true);
			rootObj.put("requestStatus","success");
			resultMsg.put("message1",_mapping.getTextDescription("admin.discovery.Discovery preferences have been configured successfully"));
			rootObj.put("result",resultMsg);
		}

		if(iprange == null && icmpEnabled == null && discEnabled == null)
		{
			rootObj.put("success",false);
			rootObj.put("requestStatus","failed");
			resultMsg.put("message1",_mapping.getTextDescription("admin.discovery.Discovery preferences have not been configured successfully"));
			rootObj.put("error",resultMsg);
		}
	}
	else if (!StringUtils.isNull(from) && from.equalsIgnoreCase("modifyExternal"))
	{
		String iprange = request.getParameter("iprange");
		String discEnabled = request.getParameter("EnableDiscovery");
		String icmpEnabled = request.getParameter("icmp");

		String preDiscovery = extMonIni.getValue(agentName,"DiscoveryEnabled");
		String preIPrange = extMonIni.getValue(agentName,"IP_RANGES");
		String preICMPEnabled = extMonIni.getValue(agentName,"UseIcmpForDiscovery");
		String prevRetryCnt = extMonIni.getValue(agentName,"SNMPRetryCount");

		String versionOne = request.getParameter("SNMP_v1");
		String versionTwo = request.getParameter("SNMP_v2");
		String versionThree = request.getParameter("SNMP_v3");

		if (!StringUtils.isNull(discEnabled))
		{
			IniFile extMonIniWrite = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() +"/manager/config/eg_externalDiscovery.ini",true);
			extMonIniWrite.setValue(agentName,"DiscoveryEnabled",discEnabled);
			
			//auditLogThread.setValue("Activity","Network Devices - Discovery Preferences");
			auditLogThread.setValue("Activity","Discovery preferences");
			//auditLogThread.setCurrentValue("00~~External agent",agentName);

			if (discEnabled.equalsIgnoreCase("yes"))
			{
				String newiprange = iprange;
				StringBuffer newip = new StringBuffer();
				StringTokenizer toks = new StringTokenizer(newiprange,"\n");
				while(toks.hasMoreTokens())
				{
					newip.append(toks.nextToken());
					if (toks.hasMoreTokens()) newip.append(",");
				}

				extMonIniWrite.setValue(agentName,"IP_RANGES",newip.toString());
				extMonIniWrite.setValue(agentName,"UseIcmpForDiscovery",icmpEnabled);

				if (StringUtils.isNull(prevRetryCnt))
				{
					extMonIniWrite.setValue(agentName,"SNMPRetryCount","0");
				}

				if(!StringUtils.isNull(versionOne))
				{
					extMonIniWrite.setValue(agentName,"SNMP_v1",versionOne);
				}

				if(!StringUtils.isNull(versionTwo))
				{
					extMonIniWrite.setValue(agentName,"SNMP_v2",versionTwo);
				}

				if(!StringUtils.isNull(versionThree))
				{
					extMonIniWrite.setValue(agentName,"SNMP_v3",versionThree);
				}

				ArrayList currNtwDeviceList = new ArrayList();
				ArrayList prevNtwDeviceList = new ArrayList();
				ArrayList newList = new ArrayList();
				ArrayList oldList = new ArrayList();
				String newPortVal = request.getParameter("changedPorts");
				String oldPortVal = request.getParameter("$_changedPorts");
				String delim = ":,";
				if(newPortVal != null && newPortVal.length()>0 )
				{
					if(newPortVal.endsWith(":"))
					{
						newPortVal = newPortVal.substring(0,newPortVal.length()-1);
					}

					String newPortValues[] = StringUtils.getTrimmedTokens(newPortVal, delim);
					newList = new ArrayList(Arrays.asList(newPortValues));
					Collections.sort(newList);

				}

				if (oldPortVal != null && oldPortVal.length()>0)
				{
					if(oldPortVal.endsWith(":"))
					{
						oldPortVal = oldPortVal.substring(0,oldPortVal.length()-1);
					}

					String oldPortValues[] = StringUtils.getTrimmedTokens(oldPortVal, delim);
					oldList = new ArrayList(Arrays.asList(oldPortValues));
					Collections.sort(oldList);

				}

				int ntkSize = newList.size();
				if(newList != null && ntkSize > 0)
				{
					auditFlag = true;

					ArrayList srvrsList = new ArrayList();
					for(int i=0; i<ntkSize; i++)
					{
						String newportVal = (String) newList.get(i);

						int index = newportVal.indexOf('$');
						String discserver = newportVal.substring(0,index);
						String portVal = newportVal.substring(index+1);
						if(portVal.indexOf(",")>=0)
						{
							portVal = portVal.replace(',',':');
						}

						String actualNtwServName = discserver.substring(0,discserver.indexOf("~|~"));

						if (!discserver.endsWith(portVal))
						{
							String tmpStr = discserver.substring(0,discserver.lastIndexOf("~|~"));
							discserver = tmpStr +"~|~"+portVal;
						}
						srvrsList.add(discserver);
						if (!StringUtils.isNull(portVal) && !portVal.equals("-"))
						{						
							currNtwDeviceList.add(_mapping.getComponentTypeDescription(actualNtwServName)+ " - "+ portVal);
						}
					}

					String strDiscServers = "";
					String servTypeFromIni = extMonIni.getValue(agentName,"NetworkDevices");
					if (StringUtils.isNull(servTypeFromIni))
					{
						strDiscServers = StringUtils.getString(srvrsList);
						extMonIniWrite.setValue(agentName,"NetworkDevices",strDiscServers);
					}
					else
					{
						ArrayList servTypeFromIniList = StringUtils.egTokenizer(servTypeFromIni,",");
						ArrayList existingServTypeList =new ArrayList();
						for (int c=0;c<srvrsList.size();c++)
						{
							String changedStr = (String) srvrsList.get(c);
							for (int s=0;s<servTypeFromIniList.size();s++)
							{
								String strServerFromIni = (String) servTypeFromIniList.get(s);
								if (changedStr.startsWith(strServerFromIni))
								{
									strServerFromIni = changedStr;
									if (existingServTypeList != null && !existingServTypeList.contains(strServerFromIni))
									{
										existingServTypeList.add(strServerFromIni);
									}
									break;
								}
							}

							if (existingServTypeList != null && !existingServTypeList.contains(changedStr))
							{
								existingServTypeList.add(changedStr);
							}
						}

						if (existingServTypeList != null && !existingServTypeList.isEmpty())
						{
							strDiscServers = StringUtils.getString(existingServTypeList);
						}
						extMonIniWrite.setValue(agentName,"NetworkDevices",strDiscServers);
					}
				}
				else
				{
					extMonIniWrite.deleteValue(agentName,"NetworkDevices");
				}

				int ntwCnt = oldList.size();
				if(oldList != null && ntwCnt > 0)
				{
					for(int i=0; i<ntwCnt; i++)
					{
						String strPrevAppName = (String) oldList.get(i);

						int index = strPrevAppName.indexOf('$');
						String discserver = strPrevAppName.substring(0,index);
						String portVal = strPrevAppName.substring(index+1);
						if(portVal.indexOf(",")>=0)
						{
							portVal = portVal.replace(',',':');
						}
						String actualNtwServName = discserver.substring(0,discserver.indexOf("~|~"));
						if (!StringUtils.isNull(portVal) && !portVal.equals("-"))
						{				
							prevNtwDeviceList.add(_mapping.getComponentTypeDescription(actualNtwServName)+ " - "+ portVal);
						}
					}
				}

				ArrayList currAppList = new ArrayList();
				ArrayList prevAppList = new ArrayList();
				ArrayList newAppList = new ArrayList();
				ArrayList oldAppList = new ArrayList();
				String newAppSrvrVal = request.getParameter("appservers");
				String oldAppSrvrVal = request.getParameter("$_appservers");
				if(newAppSrvrVal != null && newAppSrvrVal.length()>0 )
				{
					if(newAppSrvrVal.endsWith(":"))
					{
						newAppSrvrVal = newAppSrvrVal.substring(0,newAppSrvrVal.length()-1);
					}

					String newPortValues[] = StringUtils.getTrimmedTokens(newAppSrvrVal, delim);
					newAppList = new ArrayList(Arrays.asList(newPortValues));
					Collections.sort(newAppList);
				}

				if (oldAppSrvrVal != null && oldAppSrvrVal.length()>0)
				{
					if(oldAppSrvrVal.endsWith(":"))
					{
						oldAppSrvrVal = oldAppSrvrVal.substring(0,oldAppSrvrVal.length()-1);
					}

					String oldAppSrvrValues[] = StringUtils.getTrimmedTokens(oldAppSrvrVal, delim);
					oldAppList = new ArrayList(Arrays.asList(oldAppSrvrValues));
					Collections.sort(oldAppList);
				}

				int size = newAppList.size();
				if(newAppList != null && size > 0)
				{
					auditFlag = true;

					ArrayList appSrvrsList = new ArrayList();
					for(int i=0; i<size; i++)
					{
						String strAppName = (String) newAppList.get(i);

						int index = strAppName.indexOf('$');
						String discserver = strAppName.substring(0,index);
						String portVal = strAppName.substring(index+1);
						if(portVal.indexOf(",")>=0)
						{
							portVal = portVal.replace(',',':');
						}

						String actualServName = discserver.substring(0,discserver.indexOf("~|~"));

						if (!discserver.endsWith(portVal))
						{
							String tmpStr = discserver.substring(0,discserver.lastIndexOf("~|~"));
							discserver = tmpStr +"~|~"+portVal;
						}
						appSrvrsList.add(discserver);
						if (!StringUtils.isNull(portVal) && !portVal.equals("-"))
						{						
							currAppList.add(_mapping.getComponentTypeDescription(actualServName+" - "+portVal));
						}
					}

					String strDiscAppServers = "";
					String appSrvrFromIni = extMonIni.getValue(agentName,"Applications");
					if (StringUtils.isNull(appSrvrFromIni))
					{
						strDiscAppServers = StringUtils.getString(appSrvrsList);
						extMonIniWrite.setValue(agentName,"Applications",strDiscAppServers);
					}
					else
					{
						ArrayList appSrvrFromIniList = StringUtils.egTokenizer(appSrvrFromIni,",");

						ArrayList existAppSrvrsList =new ArrayList();
						for (int c=0;c<appSrvrsList.size();c++)
						{
							String changedStr = (String) appSrvrsList.get(c);
							for (int s=0;s<appSrvrFromIniList.size();s++)
							{
								String strServerFromIni = (String) appSrvrFromIniList.get(s);
								if (changedStr.startsWith(strServerFromIni))
								{
									strServerFromIni = changedStr;
									if (existAppSrvrsList != null && !existAppSrvrsList.contains(strServerFromIni))
									{
										existAppSrvrsList.add(strServerFromIni);
									}
									break;
								}
								
							}

							if (existAppSrvrsList != null && !existAppSrvrsList.contains(changedStr))
							{
								existAppSrvrsList.add(changedStr);
							}
						}

						if (existAppSrvrsList != null && !existAppSrvrsList.isEmpty())
						{
							strDiscAppServers = StringUtils.getString(existAppSrvrsList);
						}
						extMonIniWrite.setValue(agentName,"Applications",strDiscAppServers);
					}
				}
				else
				{
					extMonIniWrite.deleteValue(agentName,"Applications");
				}

				/*code for audit log starts*/
				int cnt = oldAppList.size();
				if(oldAppList != null && cnt > 0)
				{
					for(int i=0; i<cnt; i++)
					{
						String strPrevAppName = (String) oldAppList.get(i);

						int index = strPrevAppName.indexOf('$');
						String discserver = strPrevAppName.substring(0,index);
						String portVal = strPrevAppName.substring(index+1);
						if(portVal.indexOf(",")>=0)
						{
							portVal = portVal.replace(',',':');
						}
						String actualServName = discserver.substring(0,discserver.indexOf("~|~"));
						if (!StringUtils.isNull(portVal) && !portVal.equals("-"))
						{
							prevAppList.add(_mapping.getComponentTypeDescription(actualServName+" - "+portVal));
						}
					}
				}

				if(!((iprange.equals(preIPrange)) && (discEnabled.equals(preDiscovery)) && (currNtwDeviceList.size() == prevNtwDeviceList.size()) && (currAppList.size() == prevAppList.size()) && (icmpEnabled.equals(preICMPEnabled))))
				{
					auditFlag = true;
				}

				auditLogThread.setValue("Activity","Discovery preferences");

				auditLogThread.setPreviousValue("00~~Discovery enabled",(preDiscovery.equalsIgnoreCase("True") || preDiscovery.equalsIgnoreCase("Yes")) ?"Yes":"No");
				auditLogThread.setCurrentValue("00~~Discovery enabled",(discEnabled.equalsIgnoreCase("True") || discEnabled.equalsIgnoreCase("Yes"))?"Yes":"No");

				auditLogThread.setPreviousValue("01~~ICMP enabled",(preICMPEnabled.equalsIgnoreCase("True") || preICMPEnabled.equalsIgnoreCase("Yes"))? "Yes" : (StringUtils.isNull(preIPrange)) ? "-" : "No");
				auditLogThread.setCurrentValue("01~~ICMP enabled",(icmpEnabled.equalsIgnoreCase("True") || icmpEnabled.equalsIgnoreCase("Yes"))?"Yes":"No");

				if (StringUtils.isNull(preIPrange))
				{
					preIPrange = "-";
				}
				auditLogThread.setPreviousValue("02~~IP RANGES",preIPrange);
				auditLogThread.setCurrentValue("02~~IP RANGES",iprange);

				if (currAppList != null && !currAppList.isEmpty())
				{
					auditLogThread.setCurrentValue("03~~Discover applications/servers also?","Yes");
				}
				else
				{
					auditLogThread.setCurrentValue("03~~Discover applications/servers also?","No");
				}

				if (prevNtwDeviceList != null && !prevNtwDeviceList.isEmpty())
				{
					auditLogThread.setPreviousValue("04~~Network Devices",StringUtils.getString(prevNtwDeviceList));
				}
				else
				{
					auditLogThread.setPreviousValue("04~~Network Devices","-");
				}

				if (currNtwDeviceList != null && !currNtwDeviceList.isEmpty())
				{
					auditLogThread.setCurrentValue("04~~Network Devices",StringUtils.getString(currNtwDeviceList));
				}
				else
				{
					auditLogThread.setCurrentValue("04~~Network Devices","-");
				}

				if (prevAppList != null && !prevAppList.isEmpty())
				{
					auditLogThread.setPreviousValue("05~~Applications/Servers",StringUtils.getString(prevAppList));
				}
				else
				{
					auditLogThread.setPreviousValue("05~~Applications/Servers","-");
				}

				if (currAppList != null && !currAppList.isEmpty())
				{
					auditLogThread.setCurrentValue("05~~Applications/Servers",StringUtils.getString(currAppList));
				}
				else
				{
					auditLogThread.setCurrentValue("05~~Applications/Servers","-");
				}
				/*code for audit log ends*/
			}
			else
			{
				auditLogThread.setPreviousValue("00~~Discovery enabled",(preDiscovery.equalsIgnoreCase("True") || preDiscovery.equalsIgnoreCase("Yess"))?"Yes":"No");
				auditLogThread.setCurrentValue("00~~Discovery enabled",(discEnabled.equalsIgnoreCase("True") || discEnabled.equalsIgnoreCase("Yes"))?"Yes":"No");
			}

			extMonIniWrite.saveFile();
			EgConfigFilesSync.releaseInstance(extMonIniWrite);

			auditLogThread.setValue("Description","The "+agentName +" external agent discovery preferences have been modified");
			if (auditFlag)
				auditLogThread.sendItToDB();
			/*code for audit log ends*/

			rootObj.put("success",true);
			rootObj.put("requestStatus","success");
			resultMsg.put("message1",_mapping.getTextDescription("admin.discovery.Discovery preferences have been modified successfully"));
			rootObj.put("result",resultMsg);
		}

		if(iprange == null && discEnabled == null && icmpEnabled == null)
		{
			rootObj.put("success",false);
			rootObj.put("requestStatus","failed");
			resultMsg.put("message1",_mapping.getTextDescription("admin.discovery.Discovery preferences have not been modified successfully"));
			rootObj.put("error",resultMsg);
		}
	}
	else if (!StringUtils.isNull(from) && from.equalsIgnoreCase("snmpconfigure"))
	{
		String isNewConfiguration = request.getParameter("isNewConfiguration");
		String snmpPrefName = request.getParameter("snmpPrefName");
		String prevSnmpPrefName = request.getParameter("$_snmpPrefName");
		String version = request.getParameter("snmpversion");
		String preversion = request.getParameter("$_snmpversion");
		String newData = "";
		String preData = "";

		String community = "";
		String username = "";
		String authpass = "";
		String authtype = "";
		String context = "";
		String dataovertcp = "";
		String encryptflag = "";
		String encrypttype = "";
		String engineid = "";
		String encryptpassword = "";

		if (!StringUtils.isNull(version))
		{
			if (version.equals("v3"))
			{
				username = request.getParameter("username");
				authpass = request.getParameter("authpass");
				authtype = request.getParameter("authtype");
				context = request.getParameter("context");
				dataovertcp = request.getParameter("dataovertcp");
				encryptflag = request.getParameter("encryptflag");
				encrypttype = request.getParameter("encrypttype");
				engineid = request.getParameter("engineid");
				if (StringUtils.isNull(encrypttype))
				{
					encrypttype = "none";
				}
				encryptpassword = request.getParameter("encryptpassword");
				if (StringUtils.isNull(encryptpassword))
				{
					encryptpassword = "none";
				}

				newData = snmpPrefName+"#eghash#"+username+"#eghash#"+EgCrypt.encrypt(authpass)+"#eghash#"+authtype+"#eghash#"+context+"#eghash#"+dataovertcp+"#eghash#"+encryptflag+"#eghash#"+encrypttype+"#eghash#"+EgCrypt.encrypt(encryptpassword)+"#eghash#"+engineid;
			}
			else
			{
				community = request.getParameter("snmpcommunity");
				dataovertcp = request.getParameter("dataovertcp");

				/*if (!StringUtils.isNull(community) && community.indexOf(",") != -1)
				{
					community = StringUtils.replace(community, ",", ",egcomma,");
				}*/
				newData = snmpPrefName+"#eghash#"+community+"#eghash#"+dataovertcp;
			}

		}

		if (!StringUtils.isNull(isNewConfiguration) && isNewConfiguration.equalsIgnoreCase("true"))
		{
			String iprange = request.getParameter("iprange");
			String discEnabled = request.getParameter("EnableDiscovery");
			String icmpEnabled = request.getParameter("icmp");

			if (!StringUtils.isNull(discEnabled))
			{
				IniFile extMonIniWrite = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() +"/manager/config/eg_externalDiscovery.ini",true);
				extMonIniWrite.setValue(agentName,"DiscoveryEnabled",discEnabled);

				/*code for audit log starts*/
				auditLogThread.setValue("Activity","Discovery and SNMP preferences");
				auditLogThread.setCurrentValue("00~~External agent",agentName);
				auditLogThread.setCurrentValue("01~~Discovery enabled",(discEnabled.equalsIgnoreCase("True") || discEnabled.equalsIgnoreCase("Yes"))?"Yes":"No");

				if(discEnabled.equalsIgnoreCase("yes"))
				{
					String newiprange = iprange;
					StringBuffer newip = new StringBuffer();
					StringTokenizer toks = new StringTokenizer(newiprange,"\n");
					while(toks.hasMoreTokens())
					{
						newip.append(toks.nextToken());
						if (toks.hasMoreTokens()) newip.append(",");
					}

					extMonIniWrite.setValue(agentName,"IP_RANGES",newip.toString());
					extMonIniWrite.setValue(agentName,"UseIcmpForDiscovery",icmpEnabled);

					ArrayList auditAppList = new ArrayList();
					ArrayList auditNtwDeviceList = new ArrayList();
					
					ArrayList newList = new ArrayList();
					String newPortVal = request.getParameter("changedPorts");
					String delim = ":,";
					if (newPortVal != null && newPortVal.length()>0)
					{
						if(newPortVal.endsWith(":"))
						{
							newPortVal = newPortVal.substring(0,newPortVal.length()-1);
						}

						String newPortValues[] = StringUtils.getTrimmedTokens(newPortVal, delim);
						newList = new ArrayList(Arrays.asList(newPortValues));
						Collections.sort(newList);
					}

					int ntkSize = newList.size();
					if(newList != null && ntkSize > 0)
					{
						auditFlag = true;

						ArrayList srvrsList = new ArrayList();
						for(int i=0; i<ntkSize; i++)
						{
							String newportVal = (String) newList.get(i);

							int index = newportVal.indexOf('$');
							String discserver = newportVal.substring(0,index);
							String portVal = newportVal.substring(index+1);
							if(portVal.indexOf(",")>=0)
							{
								portVal = portVal.replace(',',':');
							}

							String actualServName = discserver.substring(0,discserver.indexOf("~|~"));
							if (!discserver.endsWith(portVal))
							{
								String tmpStr = discserver.substring(0,discserver.lastIndexOf("~|~"));
								discserver = tmpStr +"~|~"+portVal;
							}
							srvrsList.add(discserver);
							if (!StringUtils.isNull(portVal) && !portVal.equals("-"))
							{
								auditNtwDeviceList.add(_mapping.getComponentTypeDescription(actualServName)+ " - " +portVal);
							}
						}

						String strDiscServers = "";
						String servTypeFromIni = extMonIni.getValue(agentName,"NetworkDevices");
						if (StringUtils.isNull(servTypeFromIni))
						{
							strDiscServers = StringUtils.getString(srvrsList);
							extMonIniWrite.setValue(agentName,"NetworkDevices",strDiscServers);
						}
						else
						{
							ArrayList servTypeFromIniList = StringUtils.egTokenizer(servTypeFromIni,",");
							ArrayList existingServTypeList =new ArrayList();
							for (int c=0;c<srvrsList.size();c++)
							{
								String changedStr = (String) srvrsList.get(c);
								for (int s=0;s<servTypeFromIniList.size();s++)
								{
									String strServerFromIni = (String) servTypeFromIniList.get(s);
									if (changedStr.startsWith(strServerFromIni))
									{
										strServerFromIni = changedStr;
										if (existingServTypeList != null && !existingServTypeList.contains(strServerFromIni))
										{
											existingServTypeList.add(strServerFromIni);
										}
										break;
									}
									
								}

								if (existingServTypeList != null && !existingServTypeList.contains(changedStr))
								{
									existingServTypeList.add(changedStr);
								}
							}

							if (existingServTypeList != null && !existingServTypeList.isEmpty())
							{
								strDiscServers = StringUtils.getString(existingServTypeList);
							}
							extMonIniWrite.setValue(agentName,"NetworkDevices",strDiscServers);
						}
						extMonIniWrite.setValue(agentName,"SNMPRetryCount","0");
					}

					ArrayList newAppList = new ArrayList();
					String newAppSrvrVal = request.getParameter("appservers");
					if (newAppSrvrVal != null && newAppSrvrVal.length()>0)
					{
						if(newAppSrvrVal.endsWith(":"))
						{
							newAppSrvrVal = newAppSrvrVal.substring(0,newAppSrvrVal.length()-1);
						}

						String newPortValues[] = StringUtils.getTrimmedTokens(newAppSrvrVal, delim);
						newAppList = new ArrayList(Arrays.asList(newPortValues));
						Collections.sort(newAppList);
					}

					int size = newAppList.size();
					if(newAppList != null && size > 0)
					{
						auditFlag = true;

						ArrayList appSrvrsList = new ArrayList();
						for(int i=0; i<size; i++)
						{
							String newAppSrvr = (String) newAppList.get(i);
							int index = newAppSrvr.indexOf('$');
							String discserver = newAppSrvr.substring(0,index);
							String portVal = newAppSrvr.substring(index+1);
							if(portVal.indexOf(",") >= 0)
							{
								portVal = portVal.replace(',',':');
							}

							String actualServName = discserver.substring(0,discserver.indexOf("~|~"));
							if (!discserver.endsWith(portVal))
							{
								String tmpStr = discserver.substring(0,discserver.lastIndexOf("~|~"));
								discserver = tmpStr +"~|~"+portVal;
							}
							appSrvrsList.add(discserver);
							if (!StringUtils.isNull(portVal) && !portVal.equals("-"))
							{
								auditAppList.add(_mapping.getComponentTypeDescription(actualServName)+ " - " +portVal);
							}
							
						}

						String strDiscAppServers = "";
						String appSrvrFromIni = extMonIni.getValue(agentName,"Applications");
						if (StringUtils.isNull(appSrvrFromIni))
						{
							strDiscAppServers = StringUtils.getString(appSrvrsList);
							extMonIniWrite.setValue(agentName,"Applications",strDiscAppServers);
						}
						else
						{
							ArrayList appSrvrFromIniList = StringUtils.egTokenizer(appSrvrFromIni,",");
							ArrayList existAppSrvrsList =new ArrayList();
							for (int c=0;c<appSrvrsList.size();c++)
							{
								String changedStr = (String) appSrvrsList.get(c);
								for (int s=0;s<appSrvrFromIniList.size();s++)
								{
									String strAppSrvrFromIni = (String) appSrvrFromIniList.get(s);
									if (changedStr.startsWith(strAppSrvrFromIni))
									{
										strAppSrvrFromIni = changedStr;
										if (existAppSrvrsList != null && !existAppSrvrsList.contains(strAppSrvrFromIni))
										{
											existAppSrvrsList.add(strAppSrvrFromIni);
										}
										break;
									}
								}

								if (existAppSrvrsList != null && !existAppSrvrsList.contains(changedStr))
								{
									existAppSrvrsList.add(changedStr);
								}
							}

							if (existAppSrvrsList != null && !existAppSrvrsList.isEmpty())
							{
								strDiscAppServers = StringUtils.getString(existAppSrvrsList);
							}
							extMonIniWrite.setValue(agentName,"Applcations",strDiscAppServers);
						}
					}
					else
					{
						extMonIniWrite.deleteValue(agentName,"Applcations");
					}


					if (!StringUtils.isNull(newData))
					{
						extMonIniWrite.setValue(agentName,"SNMP_"+version,newData);
					}

					/*code for audit log starts*/

					auditLogThread.setCurrentValue("02~~IP RANGES",iprange);
					auditLogThread.setCurrentValue("03~~ICMP enabled",(icmpEnabled.equalsIgnoreCase("True") || icmpEnabled.equalsIgnoreCase("Yes"))?"Yes":"No");
					if (auditAppList != null && !auditAppList.isEmpty())
					{
						auditLogThread.setCurrentValue("04~~Discover applications/servers also?","Yes");
					}
					else
					{
						auditLogThread.setCurrentValue("04~~Discover applications/servers also?","No");
					}

					if (auditNtwDeviceList != null && !auditNtwDeviceList.isEmpty())
					{
						auditLogThread.setCurrentValue("05~~Network Devices",StringUtils.getString(auditNtwDeviceList));
					}
					else
					{
						auditLogThread.setCurrentValue("05~~Network Devices","-");
					}

					if (auditAppList != null && !auditAppList.isEmpty())
					{
						auditLogThread.setCurrentValue("06~~Applications/Servers",StringUtils.getString(auditAppList));
					}
					else
					{
						auditLogThread.setCurrentValue("06~~Applications/Servers","-");
					}

					if (!StringUtils.isNull(version))
					{
						auditLogThread.setCurrentValue("07~~Name",snmpPrefName);
						auditLogThread.setCurrentValue("08~~Version",version);

						if (version.equals("v3"))
						{
							auditLogThread.setCurrentValue("09~~Context",context);
							auditLogThread.setCurrentValue("10~~Username",username);
							auditLogThread.setCurrentValue("11~~Auth password","*****");
							auditLogThread.setCurrentValue("12~~Auth type",authtype);
							auditLogThread.setCurrentValue("13~~Encryption enabled",encryptflag);
							auditLogThread.setCurrentValue("14~~Encryption type",encrypttype);
							auditLogThread.setCurrentValue("15~~Encryption password",encryptpassword);
							auditLogThread.setCurrentValue("16~~Data over TCP",dataovertcp);
							auditLogThread.setCurrentValue("17~~Engine ID",engineid);
						}
						else
						{
							auditLogThread.setCurrentValue("09~~Community",community);
							auditLogThread.setCurrentValue("10~~Data over TCP",dataovertcp);
						}
					}
					/*code for audit log ends*/
				}

				extMonIniWrite.saveFile();
				EgConfigFilesSync.releaseInstance(extMonIniWrite);

				auditLogThread.setValue("Description","Discovery and SNMP preferences have been configured");
				auditLogThread.sendItToDB();

				rootObj.put("success",true);
				rootObj.put("requestStatus","success");
				resultMsg.put("message1",_mapping.getTextDescription("admin.discovery.Discovery and SNMP preferences have been configured successfully"));
				rootObj.put("result",resultMsg);
			}

			if(iprange == null && discEnabled == null && icmpEnabled == null)
			{
				rootObj.put("success",false);
				rootObj.put("requestStatus","failed");
				resultMsg.put("message1",_mapping.getTextDescription("admin.discovery.Discovery preferences have not been configured successfully"));
				rootObj.put("error",resultMsg);
			}
		}
		else
		{
			boolean isModifySNMPVal = false;
			boolean isModifyEixstSNMPVal = false;
			if (!StringUtils.isNull(preversion))
			{
				isModifySNMPVal = true;
				if (version.equals(preversion))
				{
					isModifyEixstSNMPVal = true;
				}
			}

			if (!StringUtils.isNull(version))
			{
				String existSNMP = extMonIni.getValue(agentName,"SNMP_"+version);
				if(!StringUtils.isNull(existSNMP))
				{
					boolean isExistSNMPDetails = false;
					if (isModifySNMPVal)
					{
						String tmpusername = request.getParameter("$_username");
						String tmpauthpass = request.getParameter("$_authpass");
						String tmpauthtype = request.getParameter("$_authtype");
						String tmpcontext = request.getParameter("$_context");
						String tmpdataovertcp = request.getParameter("$_dataovertcp");
						String tmpencryptflag = request.getParameter("$_encryptflag");
						String tmpencrypttype = request.getParameter("$_encrypttype");
						String tmpencryptpassword = request.getParameter("$_encryptpassword");
						String tmpengineid = request.getParameter("$_engineid");

						String prevDataForModifyData = tmpusername+"#eghash#"+EgCrypt.encrypt(tmpauthpass)+"#eghash#"+tmpauthtype+"#eghash#"+tmpcontext+"#eghash#"+tmpdataovertcp+"#eghash#"+tmpencryptflag+"#eghash#"+tmpencrypttype+"#eghash#"+EgCrypt.encrypt(tmpencryptpassword)+"#eghash#"+tmpengineid;

						ArrayList existSNMPList = StringUtils.egTokenizer(existSNMP,"~|~");
						int matchCnt = 0;
						int existCnt = existSNMPList.size();
						for (int e=0;e<existCnt;e++)
						{
							String existSNMPData = (String) existSNMPList.get(e);
							if (existSNMPData.equals(prevDataForModifyData))
							{
								continue;
							}

							if(existSNMPData.equals(newData))
							{
								matchCnt++;
							}
						}

						if (matchCnt > 0)
						{
							isExistSNMPDetails = true;
						}
					}
					else
					{
						if (existSNMP.equals(newData) && !isModifyEixstSNMPVal)
						{
							isExistSNMPDetails = true;
						}
						else
						{
							ArrayList existSNMPList = StringUtils.egTokenizer(existSNMP,"~|~");

							int existCnt = existSNMPList.size();
							for (int e=0;e<existCnt;e++)
							{
								String existSNMPData = (String) existSNMPList.get(e);
								if(existSNMPData.equals(newData) && !isModifyEixstSNMPVal)
								{
									isExistSNMPDetails = true;
									break;
								}
							}
						}
					}

					if (isExistSNMPDetails)
					{
						rootObj.put("success",true);
						rootObj.put("requestStatus","failed");
						//resultMsg.put("message1",_mapping.getTextDescription("admin.discovery.SNMP preferences (")+agentName+_mapping.getTextDescription(") have not been modified"));
						resultMsg.put("message1",_mapping.getTextDescription("admin.discovery.SNMP preferences you are trying to add already exists"));
						rootObj.put("error",resultMsg);

						out.println(rootObj);
						return;
					}
				}
			}

			if(!StringUtils.isNull(newData))
			{
				IniFile extMonIniWrite = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() +"/manager/config/eg_externalDiscovery.ini",true);

				String preusername = request.getParameter("$_username");
				String preauthpass = request.getParameter("$_authpass");
				String preauthtype = request.getParameter("$_authtype");
				String precontext = request.getParameter("$_context");
				String predataovertcp = request.getParameter("$_dataovertcp");
				String preencryptflag = request.getParameter("$_encryptflag");
				String preencrypttype = request.getParameter("$_encrypttype");
				String preencryptpassword = request.getParameter("$_encryptpassword");
				String preengineid = request.getParameter("$_engineid");
				String precommunity = request.getParameter("$_snmpcommunity");

				auditLogThread.setValue("Activity","SNMP preferences");
				if (!isModifySNMPVal)
				{
					String existSNMPVals = extMonIni.getValue(agentName,"SNMP_"+version);
					if (!StringUtils.isNull(existSNMPVals))
					{
						newData = existSNMPVals+"~|~" + newData;
					}

					extMonIniWrite.setValue(agentName,"SNMP_"+version,newData);
					auditLogThread.setCurrentValue("00~~External agent",agentName);
					auditLogThread.setCurrentValue("01~~Name",snmpPrefName);
					auditLogThread.setCurrentValue("02~~Version",version);
					if (version.equals("v3"))
					{
						auditLogThread.setCurrentValue("03~~Context",context);
						auditLogThread.setCurrentValue("04~~Username",username);
						auditLogThread.setCurrentValue("05~~Auth password","*****");
						auditLogThread.setCurrentValue("06~~Auth type",authtype);
						auditLogThread.setCurrentValue("07~~Encryption enabled",encryptflag);
						auditLogThread.setCurrentValue("08~~Encryption type",encrypttype);
						auditLogThread.setCurrentValue("09~~Encryption password","*****");
						auditLogThread.setCurrentValue("10~~Data over TCP",dataovertcp);
						auditLogThread.setCurrentValue("11~~Engine ID",engineid);
					}
					else
					{
						auditLogThread.setCurrentValue("03~~Community",community);
						auditLogThread.setCurrentValue("04~~Data over TCP",dataovertcp);
					}
				}
				else
				{
					if (preversion.equals("v3"))
					{
						preData = prevSnmpPrefName+"#eghash#"+preusername+"#eghash#"+EgCrypt.encrypt(preauthpass)+"#eghash#"+preauthtype+"#eghash#"+precontext+"#eghash#"+predataovertcp+"#eghash#"+preencryptflag+"#eghash#"+preencrypttype+"#eghash#"+EgCrypt.encrypt(preencryptpassword)+"#eghash#"+preengineid;
					}
					else
					{
						/*if (!StringUtils.isNull(precommunity) && precommunity.indexOf(",") != -1)
						{
							precommunity = StringUtils.replace(precommunity, ",", ",egcomma,");
						}*/
						preData = prevSnmpPrefName+"#eghash#"+precommunity+"#eghash#"+predataovertcp;
					}

					String existSNMPModVals = extMonIni.getValue(agentName,"SNMP_"+preversion);
					if (version.equals(preversion))
					{
						ArrayList existSNMPModValList = StringUtils.egTokenizer(existSNMPModVals,"~|~");
						String changedVal = "";
						int existSize = existSNMPModValList.size();
						for (int e=0;e<existSize;e++)
						{
							String existData = (String) existSNMPModValList.get(e);
							if(existData.equals(preData))
							{
								existData = newData;
							}
							changedVal += "~|~"+existData;
						}

						if (changedVal.startsWith("~|~"))
						{
							changedVal = changedVal.substring(changedVal.indexOf("~|~")+3);
						}
						extMonIniWrite.setValue(agentName,"SNMP_"+version,changedVal);
					}
					else
					{
						if (!StringUtils.isNull(existSNMPModVals))
						{
							if (existSNMPModVals.equals(preData))
							{
								extMonIniWrite.deleteValue(agentName,"SNMP_"+preversion);
							}
							else
							{
								ArrayList existSNMPModPreList = StringUtils.egTokenizer(existSNMPModVals,"~|~");
								String changedPreVal = "";
								int existPreSize = existSNMPModPreList.size();
								for (int e=0;e<existPreSize;e++)
								{
									String existPreData = (String) existSNMPModPreList.get(e);
									if(existPreData.equals(preData))
									{
										continue;
									}
									changedPreVal += "~|~"+existPreData;
								}

								if (changedPreVal.startsWith("~|~"))
								{
									changedPreVal = changedPreVal.substring(changedPreVal.indexOf("~|~")+3);
								}
								extMonIniWrite.setValue(agentName,"SNMP_"+preversion,changedPreVal);
							}
						}

						String existSNMPModVal = extMonIni.getValue(agentName,"SNMP_"+version);
						if (!StringUtils.isNull(existSNMPModVal))
						{
							newData = existSNMPModVal+"~|~"+ newData;
						}
						extMonIniWrite.setValue(agentName,"SNMP_"+version,newData);
					}

					/*code for audit log starts*/
					auditLogThread.setCurrentValue("00~~External agent",agentName);
					auditLogThread.setCurrentValue("01~~Name",snmpPrefName);
					auditLogThread.setPreviousValue("02~~Version",preversion);
					auditLogThread.setCurrentValue("02~~Version",version);
					if (version.equals("v3"))
					{
						auditLogThread.setPreviousValue("03~~Context",precontext);
						auditLogThread.setCurrentValue("03~~Context",context);

						auditLogThread.setPreviousValue("04~~Username",preusername);
						auditLogThread.setCurrentValue("04~~Username",username);

						auditLogThread.setPreviousValue("05~~Auth password","*****");
						auditLogThread.setCurrentValue("05~~Auth password","*****");

						auditLogThread.setPreviousValue("06~~Auth type",preauthtype);
						auditLogThread.setCurrentValue("06~~Auth type",authtype);

						auditLogThread.setPreviousValue("07~~Encryption enabled",preencryptflag);
						auditLogThread.setCurrentValue("07~~Encryption enabled",encryptflag);

						auditLogThread.setPreviousValue("08~~Encryption type",preencrypttype);
						auditLogThread.setCurrentValue("08~~Encryption type",encrypttype);

						auditLogThread.setPreviousValue("09~~Encryption password","*****");
						auditLogThread.setCurrentValue("09~~Encryption password","*****");

						auditLogThread.setPreviousValue("10~~Data over TCP",predataovertcp);
						auditLogThread.setCurrentValue("10~~Data over TCP",dataovertcp);

						auditLogThread.setPreviousValue("11~~Engine ID",preengineid);
						auditLogThread.setCurrentValue("11~~Engine ID",engineid);
					}
					else
					{
						auditLogThread.setPreviousValue("03~~Community",precommunity);
						auditLogThread.setCurrentValue("03~~Community",community);

						auditLogThread.setPreviousValue("04~~Data over TCP",predataovertcp);
						auditLogThread.setCurrentValue("04~~Data over TCP",dataovertcp);
					}
				}
				extMonIniWrite.saveFile();
				EgConfigFilesSync.releaseInstance(extMonIniWrite);

				/*code for audit log ends*/

				rootObj.put("success",true);
				rootObj.put("requestStatus","success");
				if (!isModifySNMPVal)
				{
					resultMsg.put("message1",_mapping.getTextDescription("admin.discovery.SNMP preferences have been configured successfully"));
					auditLogThread.setValue("Description","SNMP preferences have been configured");
				}
				else
				{
					resultMsg.put("message1",_mapping.getTextDescription("admin.discovery.SNMP preferences have been modified successfully"));
					auditLogThread.setValue("Description","SNMP preferences have been modified");
				}

				auditLogThread.sendItToDB();
				rootObj.put("result",resultMsg);
			}
			else
			{
				rootObj.put("success",true);
				rootObj.put("requestStatus","failed");
				resultMsg.put("message1",_mapping.getTextDescription("admin.discovery.SNMP preferences have not been configured successfully"));
				rootObj.put("error",resultMsg);
			}
		}
	}
	else if (from.equalsIgnoreCase("deletesnmpdata"))
	{
		String snmpPrefName = request.getParameter("snmpPrefName");
		String snmpVersion = request.getParameter("version");
		String deletedValues = request.getParameter("deletedValues");
		if (deletedValues != null)
		{
			String variable = "SNMP_"+snmpVersion;
			String strNewValue = "";

			ArrayList delValList = StringUtils.egTokenizer(deletedValues,"#eghash#");
			int size = delValList.size();
			if (variable.endsWith("v3"))
			{
				for (int d=0;d<size;d++)
				{
					String data = (String) delValList.get(d);
					if (d == 1 || (d == (size-1)))
					{
						data = EgCrypt.encrypt(data);
					}
					strNewValue += "#eghash#"+data;
				}
			}
			else
			{
				for (int d=0;d<size;d++)
				{
					String data = (String) delValList.get(d);
					/*if (data.indexOf(",") != -1)
					{
						data = StringUtils.replace(data,",", ",egcomma,");
					}*/
					strNewValue += "#eghash#"+data;
				}
			}

			if (strNewValue.startsWith("#eghash#"))
			{
				strNewValue = strNewValue.substring(strNewValue.indexOf("#eghash#")+8);
			}

			String existDeletedSNMPvalue = extMonIni.getValue(agentName,"SNMP_"+snmpVersion);
			IniFile agentlessdiscIniWrite = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() +"/manager/config/eg_externalDiscovery.ini",true);
			if (!StringUtils.isNull(existDeletedSNMPvalue))
			{
				ArrayList existSNMPValList = StringUtils.egTokenizer(existDeletedSNMPvalue,"~|~");

				if (existSNMPValList.size() == 1)
				{
					agentlessdiscIniWrite.deleteValue(agentName,variable);
				}
				else
				{
					String changedVal = "";
					int existSize = existSNMPValList.size();
					for (int e=0;e<existSize;e++)
					{
						String existData = (String) existSNMPValList.get(e);
						if(existData.equals(strNewValue))
						{
							continue;
						}
						changedVal += "~|~"+existData;
					}

					if (changedVal.startsWith("~|~"))
					{
						changedVal = changedVal.substring(changedVal.indexOf("~|~")+3);
					}
					agentlessdiscIniWrite.setValue(agentName,variable,changedVal);
				}
			}
			agentlessdiscIniWrite.saveFile();
			EgConfigFilesSync.releaseInstance(agentlessdiscIniWrite);
			
			/*code for audit log starts*/
			auditLogThread.setValue("Activity","SNMP preferences");
			//auditLogThread.setCurrentValue("ColumnName","SNMP  Deleted");
			//auditLogThread.setCurrentValue("00~~Deleted SNMP identity ("+snmpVersion+")","" +agentName);
			auditLogThread.setCurrentValue("00~~External agent",agentName);
			auditLogThread.setCurrentValue("01~~Name",snmpPrefName);
			auditLogThread.setValue("Description","SNMP preferences have been deleted");
			auditLogThread.sendItToDB();
			/*code for audit log ends*/
			rootObj.put("requestStatus","success");
		}
	}

	session.setAttribute("adminLastAccessedURL","/final/admin/EgAdminOperations.jsp?"+request.getQueryString());
	out.println(rootObj.toString());
%>




