<%
/**
 *	Enables the administrator to configure eG's mail settings.
 *
 *	@author		Sandhya.K
 *	@created	30/12/2000
 *
 *	@modified	03/02/2003	Sandhya Configure subject
 *				18/02/2003	Sandhya SmsFormat
 *				19/02/2003	Willie	Layout problem
 *				08/05/2003	Arun	Allowed blank mail host and email address for updating mail configuration
 *				08/07/2004	Arun	Included option for mail authentication
 *				14/07/2004	Arun	Fixed user/pwd validation (tries to validate when authenticate is No)
 *				21/07/2004	Arun	Gave appropriate error messages if user/password fields are blank.
 *									Moved ADMIN MAIL ID to below MAIL HOST
  *	Design Changes	:	Jaiwin
 */
%>

<%@ include file="EgTrackerA.jsp" %>
<%@ page errorPage="EgProbs.jsp"%>
<%@ page import = "com.eg.EgCrypt" %>
<%@ page import = "com.eg.EgMemInfo"%>
<%@ page import = "com.eg.EgDbInfo"%>
<%@ page import = "com.egurkha.EgConstants"%>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<!-- skm (03/03/2006) -->
<%@ page import="com.eg.IniFile"%>
<%@ page import="com.eg.EgInstallInfo"%>

<%!
	String licenseCheck = "me";
	String subject = "";
	String strHost = "";
	String strPort = "";
	String strProtocol = "";
	String[] strProtocolValues = {"SMTP","SMTP-SSL","SMTP-TLS"};
	String strSender = "";
	String strmSub = "";
	String strsSub = "";
	String strsFormat = "";
	String strmailFormat="";
	String strmailseparate="";
	String strsmsseparate="";
	String normalMail = "";
	String ddMail = "";
	boolean isDouble=EgDbInfo.doubleByteEnabled;
%>

<jsp:useBean id="mailconfig" scope="page" class="egurkha.TransactionBean"/>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);

	boolean smsEnabled = false;
	synchronized(licenseCheck)
	{
		smsEnabled = EgMemInfo.smsEnabled;
	}

	subject = "MISC_ARGS";
	mailconfig.createFile("eg_services.ini");
	strHost = mailconfig.getStrValue(subject,"MailHost");
	strPort = mailconfig.getStrValue(subject,"MailPort");
	strProtocol = mailconfig.getStrValue(subject,"MailHostProtocol");
	strSender = mailconfig.getStrValue(subject,"MailSender");
	strmSub = mailconfig.getStrValue(subject,"MailSubject");
	strsSub = mailconfig.getStrValue(subject,"SmsSubject");
	strsFormat = mailconfig.getStrValue(subject,"SmsFormat");
	strmailseparate=mailconfig.getStrValue(subject,"MailSeparate");
	strsmsseparate=mailconfig.getStrValue(subject,"SeparateSms");
	strmailFormat=mailconfig.getStrValue(subject,"MailFormat");
	normalMail = mailconfig.getStrValue(subject,"MailNormal");
	ddMail = mailconfig.getStrValue(subject,"ShowDDinMail");
	String strUser = mailconfig.getStrValue(subject,"MailUser");
	String strPwd = mailconfig.getStrValue(subject,"MailPasswd");
	String mailAsAttachment = mailconfig.getStrValue(subject,"SendMailAlertAsAttachment");
%>

<html>
<head>
<title>Mail Configuration</title>
<meta name="created" content="30/12/2k">
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<egui:skin ui="admin"/>
<!-- <link rel="stylesheet" href="eg_styles/eg_adminstyle.css" />  -->

<script language="JavaScript1.2" src="eg_scripts/validate.js"></script>
<script language="JavaScript1.2" src="../scripts/<%=script_src%>"></script>
<script language="JavaScript">

var flag = false;
function setFlag()
{
	flag = true;
}

function alertMessage()
{
	if(flag)
	{
		var msg = '<egui:intnl text="admin.mail.Your changes have not been updated"/>! <egui:intnl text="admin.mail.Do you want to continue without saving the changes"/>?';
		flag1 = confirm(msg);

		if(flag1)
		{
			window.location.href="./advancedOptions.jsp";
		}
		else
		{
			return;
		}
	}
	else
	{
		window.location.href="./advancedOptions.jsp";
	}
}

function validateUserAuth()
{
	document.mailconfig.mailhost.focus();
	/*if (StringUtils.isNull(strUser))
	{
		authenticateYes = EgConstants.BLANK_STRING;
		authenticateNo = "checked";
		disabled = " disabled ";
	}*/

	var authentication ='<%=StringUtils.isNull(strUser)%>';
	if (authentication=='true')
	{
		document.getElementById('authUser').style.visibility = 'hidden';
		document.getElementById('authUser').style.display = 'none';
		document.getElementById('authPwd').style.visibility = 'hidden';
		document.getElementById('authPwd').style.display = 'none';
		document.getElementById('authCPwd').style.visibility = 'hidden';
		document.getElementById('authCPwd').style.display = 'none';
	}
	else
	{
		if (isNetscape())
		{
			document.getElementById('authUser').style.visibility = 'visible';
			document.getElementById('authUser').style.display = 'table-row';
			document.getElementById('authPwd').style.visibility = 'visible';
			document.getElementById('authPwd').style.display = 'table-row';
			document.getElementById('authCPwd').style.visibility = 'visible';
			document.getElementById('authCPwd').style.display = 'table-row';
		}

		if (isIE())
		{
			document.getElementById('authUser').style.visibility = 'visible';
			document.getElementById('authUser').style.display = 'block';
			document.getElementById('authPwd').style.visibility = 'visible';
			document.getElementById('authPwd').style.display = 'block';
			document.getElementById('authCPwd').style.visibility = 'visible';
			document.getElementById('authCPwd').style.display = 'block';
		}
	}
}

function showOrHide()
{
	var thisForm=document.mailconfig;
	var format;
	for( i = 0; i < thisForm.MailSubjectFormatToUse.length; i++ )
	{
		if(thisForm.MailSubjectFormatToUse[i].checked == true)
		format = thisForm.MailSubjectFormatToUse[i].value;
	}
	if(format=="CustomFormat")
	{
		document.getElementById("id1").style.display = '';
		document.getElementById("id2").style.display = 'none';
		document.getElementById("id3").style.display = '';
		document.getElementById("id31").style.display = '';
		document.getElementById("id4").style.display = 'none';
		document.getElementById("id5").style.display = 'none';
	}
	else
	{
		document.getElementById("id1").style.display = 'none';
		document.getElementById("id2").style.display = '';
		document.getElementById("id3").style.display = '';
		document.getElementById("id31").style.display = 'none';
		document.getElementById("id4").style.display = '';
		document.getElementById("id5").style.display = '';
	}
}
function onAuthenticate()
{
	var thisForm = document.mailconfig;
	if (thisForm.authenticate[0].checked)
	{
		//Enable
		/*
		thisForm.user.disabled = false;
		thisForm.password.disabled = false;
		thisForm.confirm.disabled = false;
		*/

		if (isNetscape())
		{
			document.getElementById('authUser').style.visibility = 'visible';
			document.getElementById('authUser').style.display = 'table-row';
			document.getElementById('authPwd').style.visibility = 'visible';
			document.getElementById('authPwd').style.display = 'table-row';
			document.getElementById('authCPwd').style.visibility = 'visible';
			document.getElementById('authCPwd').style.display = 'table-row';
		}

		if (isIE())
		{
			document.getElementById('authUser').style.visibility = 'visible';
			document.getElementById('authUser').style.display = 'block';
			document.getElementById('authPwd').style.visibility = 'visible';
			document.getElementById('authPwd').style.display = 'block';
			document.getElementById('authCPwd').style.visibility = 'visible';
			document.getElementById('authCPwd').style.display = 'block';
		}
	}
	else
	{
		//Disable
		/*
		thisForm.user.disabled = true;
		thisForm.password.disabled = true;
		thisForm.confirm.disabled = true;
		*/

		document.getElementById('authUser').style.visibility = 'hidden';
		document.getElementById('authUser').style.display = 'none';
		document.getElementById('authPwd').style.visibility = 'hidden';
		document.getElementById('authPwd').style.display = 'none';
		document.getElementById('authCPwd').style.visibility = 'hidden';
		document.getElementById('authCPwd').style.display = 'none';
	}
}

function checkdots(fieldvalue)
{
	var val = fieldvalue;
	if(val.charAt(0) == '.' || val.charAt(val.length - 1) == '.')
	{
		return false;
	}
	else
	{
		for(var k=0;k < val.length;k++)
		{
			if(val.charAt(k) == '.' && val.charAt(k + 1) == '.')
			{
				alert('<egui:intnl text="admin.mail.Cannot have a dot in consecutive positions"/>');
				return false;
			}
			else
			{
				continue;
			}
		}
	}

	return true;
}

function checkUserPwd()
{
	var thisForm = document.mailconfig;
	if (thisForm.authenticate[0].checked)
	{
		var user = thisForm.user.value;
		var pwd = thisForm.authpassword.value;
		var conf = thisForm.confirm.value;

		var auth_usr=true;
		var auth_pwd=true;
		if('<%=isDouble%>'=="false")
		{
			auth_usr= validateSingleByte(user);
			auth_pwd= validateSingleByte(pwd);
		}
		if (user=="null")
		{
			alert('<egui:intnl text="admin.mail.User field cannot have a null value"/>');
			//document.addserver.aluser.value="";
			thisForm.user.focus();
			return false;
		}
		else if (user=="")
		{
			alert('<egui:intnl text="admin.mail.User field cannot be blank"/>');
			//document.addserver.aluser.value="";
			thisForm.user.focus();
			return false;
		}
		else if(user!=null && !checkspecial(user,"*+=|:;\"\'<>\/[]?,"))
		{
			thisForm.user.focus();
			return false;
		}
		else if(user!=null && trim(user) == "")
		{
			alert('<egui:intnl text="admin.snmp.Field value cannot be blank"/>.');
			thisForm.user.focus();
			return false;
		}
		else if(user!=null && user.indexOf("..") > -1)
		{
			alert(_checkdots);
			thisForm.user.focus();
			return false;
		}
		else if (user != null && user.indexOf("  ") > -1)
		{
			alert(_checkSpaces);
			thisForm.user.focus();
			return false;
		}
		else if(!auth_usr)
		{
			alert('<egui:intnl text="admin.user.User is not allowed in DBL(Chinese,Korean,Japanese),since manager is SingleByte"/>');
			thisForm.user.focus();
			return false;
		}
		else if (pwd =="null")
		{
			alert('<egui:intnl text="admin.mail.Password field cannot have a null value"/>');
			//document.addserver.alpwd.value="";
			thisForm.authpassword.focus();
			return false;
		}
		else if (pwd == "")
		{
			alert('<egui:intnl text="admin.mail.Password field cannot be blank"/>');
			//document.addserver.alpwd.value="";
			thisForm.authpassword.focus();
			return false;
		}
		else if (pwd != conf)
		{
			alert('<egui:intnl text="admin.mail.Passwords do not match"/>. <egui:intnl text="admin.mail.Please enter the passwords correctly"/>.');
			//document.addserver.alpwd.value="";
			thisForm.authpassword.focus();
			return false;
		}
		//else if(!checkspecial(thisForm.password,"	`~!@#$%^&*()+={}[]|\\:;\"\'<>,?\/"))
		else if(!checkspecialnomess(thisForm.authpassword,"\'\"}~|"))
		{
			//alert("The characters <Tab> ` ~ ! @ # $ % ^ & * ( ) + = { } [ ] | \\ : ; \" \' < > , ? \ / cannot be used in the password.");
			alert('<egui:intnl text="admin.mail.The characters"/> \' \" } ~ |<egui:intnl text="admin.mail.cannot be used in the password"/>');
//			alert("The characters ' \" } ~ | # $ cannot be used in the password.");
			thisForm.authpassword.focus();
			return false;
		}
		else if(!auth_pwd)
		{
			alert('<egui:intnl text="admin.user.Password is not allowed in DBL(Chinese,Korean,Japanese),since manager is SingleByte"/>');
			thisForm.authpassword.focus();
			return false;
		}
		return true;
	}
	else
	{
		return true;
	}
}

function checkMailSubject()
{
	var thisForm=document.mailconfig;
	var subFormat;
	var val;
	for( i = 0; i < thisForm.MailSubjectFormatToUse.length; i++ )
	{
		if(thisForm.MailSubjectFormatToUse[i].checked == true)
		subFormat = thisForm.MailSubjectFormatToUse[i].value;
	}
	if(subFormat =="CustomFormat")
	{
		val=thisForm.mailsub.value;
		if(val==''||val.length<0)
		{
			alert('<egui:intnl text="admin.mail.Mail subject should not be blank"/>');
			thisForm.mailsub.focus();
			return false;
		}
	}
	if(subFormat =="DefinedFormat")
	{
		var startMailSub= true;
		val=thisForm.MailSubjectStart.value;
		if(val.length==0)
		{
			alert('<egui:intnl text="admin.mail.Start of mail subject should not be blank"/>');
			thisForm.MailSubjectStart.focus();
			return false;
		}
		if('<%=isDouble%>'=="false")
		{
			startMailSub = validateSingleByte(val);
			if(!startMailSub)
			{
				alert('<egui:intnl text="admin.user.Mail subject is not allowed in DBL(Chinese,Korean,Japanese),since manager is SingleByte"/>');
				thisForm.MailSubjectStart.focus();
				return false;
			}
		}

		if (thisForm.mailSubjectService.checked == false &&
			thisForm.mailSubjectCompName.checked == false &&
			thisForm.mailSubjectCompType.checked == false &&
			thisForm.mailSubjectLayer.checked == false &&
			thisForm.mailSubjectTest.checked == false &&
			thisForm.mailSubjectDesc.checked == false &&
			thisForm.mailSubjectPrior.checked == false &&
			thisForm.mailSubjectAlarmId.checked == false)
		{
			if(thisForm.mailSubjectLMV!=null && thisForm.mailSubjectLMV.checked == false)
			{
				alert('<egui:intnl text="admin.mail.Please select atleast one option under Contents of mail subject"/>');
				return false;
			}
			else
			{
				alert('<egui:intnl text="admin.mail.Please select atleast one option under Contents of mail subject"/>');
				return false;
			}
		}

		val=thisForm.MailSubjectLength.value;
		if(isNaN(val))
		{
			alert("' "+val+" '  " + '<egui:intnl text=" admin.mail.is not a valid number"/>');
			thisForm.MailSubjectLength.focus();
			return false;
		}
		if(val.length==0||val.indexOf('0')==0||parseInt(val)<=0||val.indexOf(".")>-1)
		{
			alert('<egui:intnl text="admin.mail.Maximum components in mail subject should be a valid positive whole number"/>');
			thisForm.MailSubjectLength.focus();
			return false;
		}
	}
	return true;
}

function populate()
{
	var thisForm = document.mailconfig;
	//Code for mail senders ids validation starts here
	var mailsendersIds = thisForm.mailsenders.value;
	var proceedFlag = true;
	var mail_Sub=true;
	var sms_Sub=true;
	var regExp = /([a-zA-Z0-9]+[\ \_\.\-]?)*[a-zA-Z0-9]\@[a-zA-Z0-9][\w\.-]*[a-zA-Z0-9]\.[a-zA-Z][a-zA-Z\.]*[a-zA-Z]/g;

	if('<%=isDouble%>'=="false")
	{
		mail_Sub= validateSingleByte(thisForm.mailsub.value);
		if (<%=smsEnabled%>)
		{
			sms_Sub= validateSingleByte(thisForm.smssub.value);
		}
	}
	if (mailsendersIds.length > 0)
	{
		var mailIDs = mailsendersIds.replace("\r","").split("\n");
		for (var i=0;i<mailIDs.length && mailIDs[i] !="";i++)
		{
			var tempResult=mailIDs[i].match(regExp);
			if(tempResult==null || tempResult!=mailIDs[i])
			{
				alert('<egui:intnl text="admin.mail.Please enter valid e-mail address(es)"/>');
				thisForm.mailsenders.focus();
				proceedFlag = false;
				break;
			}
			else if(!validateSingleByte(mailIDs[i]))
			{
				alert('<egui:intnl text="admin.user.Mail sender ID is not allowed in DBL(Chinese,Korean,Japanese)"/>');
				thisForm.mailsenders.focus();
				proceedFlag = false;
				return;
			}
		}
	}
	//Ends here

	var numbers = "0123456789 ";
	var alpha = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
	var check_char = "";
	var check_num = "";
	var flag = "false";
	var mail_host = thisForm.mailhost.value;
	var mail_port = thisForm.mailport.value;

	if(mail_host != "")
	{
		for(var m=0; m < mail_host.length; m++)
		{
			check_char = alpha.indexOf(mail_host.charAt(m))
			check_num = numbers.indexOf(mail_host.charAt(m))
			//Returns value 1 if the character listed is found
			if(check_char >= 1)
			{
				flag = "true";
				break;
			}
			else if(check_num >= 1)
			{
				flag = "false";
				break;
			}
		}
	}

	if (!checkUserPwd())
	{
		return;
	}

	if(!checkMailSubject())
	{
		return;
	}
	if(!mail_Sub)
	{
		alert('<egui:intnl text="admin.mail.Mail subject is not allowed in DBL(Chinese,Korean,Japanese),since manager is SingleByte"/>');
		thisForm.mailsub.focus();
		return false;
	}
	if(!sms_Sub)
	{
		alert('<egui:intnl text="admin.mail.SMS subject is not allowed in DBL(Chinese,Korean,Japanese),since manager is SingleByte"/>');
		thisForm.smssub.focus();
		return false;
	}

	var regExp = /([a-zA-Z0-9]+[\ \_\.\-]?)*[a-zA-Z0-9]\@[a-zA-Z0-9][\w\.-]*[a-zA-Z0-9]\.[a-zA-Z][a-zA-Z\.]*[a-zA-Z]/g;
	var mailSenderValue = thisForm.mailsender.value;
	var result=mailSenderValue.match(regExp);
	if (!checkblank(thisForm.mailhost) && !checkblank(thisForm.mailsender))
	{
		if (confirm('<egui:intnl text="admin.mail.Mail configuration settings will be cleared"/>.<egui:intnl text="admin.mail.Do you want to proceed?"/>'))
		{
			if (isNetscape()) targetObj = document.mailconfig.update;
			if (isIE()) targetObj = document.mailconfig.update;
			targetObj.value = '<egui:intnl text="admin.common.Updating"/>...';
			targetObj.disabled = true;
			thisForm.submit();
		}
		else
		{
			thisForm.reset();
		}
	}
	else if(!checkblank(thisForm.mailhost))
	{
		alert('<egui:intnl text="admin.mail.Mail host cannot be blank"/>');
		thisForm.mailhost.focus();
	}
	else if(!checkspace(thisForm.mailport))
	{
		thisForm.mailport.focus();
	}
	else if(!checkdots(mail_port))
	{
		alert('<egui:intnl text="admin.mail.Mail port should not start or end with a dot"/>');
		thisForm.mailport.focus();
	}
	else if(!checkspecial(thisForm.mailport,"`~!@#$%^&*()+={}[]|\\:;\"\'<>,?\/"))
	{
		thisForm.mailport.focus();
	}
	else if(!checknumber("+",thisForm.mailport))
	{
		alert('<egui:intnl text="admin.mail.Port should be a valid number"/>');
		thisForm.mailport.focus();
	}
	else if(!checkfordecimal(thisForm.mailport))
	{
		thisForm.mailport.focus();
	}
	else if(thisForm.mailport.value == "0")
	{
		alert('<egui:intnl text="admin.mail.Only valid integers are allowed"/>.');
		thisForm.mailport.focus();
	}
	else if(thisForm.mailport.value > 99999)
	{
		thisForm.mailport.focus();
		alert('<egui:intnl text="admin.common.Invalid port number"/>.');
	}
	else if(!checkspecial(thisForm.mailhost,"`~!@#$%^&*()+={}[]|\\:;\"\'<>,?\/"))
	{
		thisForm.mailhost.focus();
	}
	else if(!validateSingleByte(thisForm.mailhost.value))
	{
		alert('<egui:intnl text="admin.user.Mail host is not allowed in DBL(Chinese,Korean,Japanese)"/>');
		thisForm.mailhost.focus();
	}
	else if(!checkblank(thisForm.mailsender))
	{
		alert('<egui:intnl text="admin.mail.Please enter a valid e-mail address"/>');
		thisForm.mailsender.focus();
	}
	else if(result==null || result!=mailSenderValue)
	{
		alert('<egui:intnl text="admin.mail.Please enter a valid e-mail address"/>');
		thisForm.mailsender.focus();
	}

	else if(!validateSingleByte(thisForm.mailsender.value))
	{
		alert('<egui:intnl text="admin.user.Admin mail ID is not allowed in DBL(Chinese,Korean,Japanese)"/>');
		thisForm.mailsender.focus();
	}
	else if(flag == "true")
	{
		if(!checkspace(thisForm.mailhost))
		{
			thisForm.mailhost.focus();
		}
		//Checks for dots before & after hostname as well as dots in consecutive positions.
		else if(!checkdots(mail_host))
		{
			alert('<egui:intnl text="admin.mail.Mail host should not start or end with a dot"/>');
			thisForm.mailhost.focus();
		}
		else
		{
			if (proceedFlag)
			{
				thisForm.submit();
			}
		}
	}
	else if(!checkdots(mail_host))
	{
		alert('<egui:intnl text="admin.mail.Mail host should not start or end with a dot"/>');
		thisForm.mailhost.focus();
	}
	else if(!validateMailHost(mail_host))
	{
		thisForm.mailhost.focus();
	}
	else if(!checkspace(thisForm.mailhost))
	{
		thisForm.mailhost.focus();
	}
	else
	{
		if (proceedFlag)
		{
			if (isNetscape()) targetObj = document.mailconfig.update;
			if (isIE()) targetObj = document.mailconfig.update;
			targetObj.value = '<egui:intnl text="admin.common.Updating"/>...';
			targetObj.disabled = true;
			thisForm.submit();
		}
	}
}

function isNetscape()
{
	// get browser info.
	appName= navigator.appName;
	//alert(appName);
	appLongVer = navigator.appVersion;
	appVer = appLongVer.substring(0, 1);

	// check for Navigator ver 4+.
	if ((appName == "Netscape") && (appVer >= 4)) return true;
	return false;
}

function isIE()
{
	// get browser info.
	appName= navigator.appName;
	//alert(appName);
	appLongVer = navigator.appVersion;
	appVer = appLongVer.substring(0, 1);

	// check for IE ver 4+.
	if ((appName == "Microsoft Internet Explorer") && (appVer >= 4)) return true;
	return false;
}

function call()
{
	window.location.href = "./EgAdminOperations.jsp";
}

//skm (10/03/2006)
function enableTestAndMeasure()
{
	var thisForm = document.mailconfig;

	if (thisForm.maildesc.checked)
	{
		thisForm.mailtest.checked = true;
	}
	else
	{
		if (thisForm.measureFlag.value == "true")
			thisForm.mailmeasure.checked = false;
	}

	if (<%=smsEnabled%> == true)
	{
		if(thisForm.desc.checked)
		{
			thisForm.test.checked = true;
		}
		else
		{
			if (thisForm.smsMeasureFlag.value == "true")
				thisForm.measure.checked = false;
		}
	}

	if (thisForm.mailSubjectDesc.checked)
	{
		thisForm.mailSubjectTest.checked = true;
	}
	else
	{
		if (thisForm.mailSubjectMeasureFlag.value == "true")
		{
			thisForm.mailSubjectLMV.checked = false;
		}
	}
}

function enableTestAndDesc()
{
	var thisForm = document.mailconfig;

	if (thisForm.mailmeasure.checked)
	{
		thisForm.mailtest.checked = true;
		thisForm.maildesc.checked = true
	}
	if (<%=smsEnabled%> == true)
	{
		if(thisForm.measure.checked)
		{
			thisForm.test.checked = true;
			thisForm.desc.checked = true
		}
	}

	if (thisForm.mailSubjectLMV.checked)
	{
		thisForm.mailSubjectTest.checked = true;
		thisForm.mailSubjectDesc.checked = true;
	}
}

function checkDescAndMeasure()
{
	var thisForm = document.mailconfig;

	if (!thisForm.mailtest.checked)
	{
		if (thisForm.maildesc.checked)
			thisForm.maildesc.checked = false;

		if (thisForm.measureFlag.value=="true")
			if (thisForm.mailmeasure.checked)
				thisForm.mailmeasure.checked = false;
	}

	if (<%=smsEnabled%> == true)
	{
		if(!thisForm.test.checked)
		{
			if (thisForm.desc.checked)
				thisForm.desc.checked = false;

			if (thisForm.smsMeasureFlag.value=="true")
				if (thisForm.measure.checked)
					thisForm.measure.checked = false;
		}
	}

	if (!thisForm.mailSubjectTest.checked)
	{
		if (thisForm.mailSubjectDesc.checked)
		{
			thisForm.mailSubjectDesc.checked = false;
		}

		if (thisForm.mailSubjectMeasureFlag.value=="true")
		{
			if (thisForm.mailSubjectLMV.checked)
			{
				thisForm.mailSubjectLMV.checked = false;
			}
		}
	}
}
//skm (10/03/2006)
</script>
</head>

<body style="overflow:auto" id="space6" scroll="yes" onload="validateUserAuth()">
<%
	session.setAttribute("egPageDesc","This page enables the administrator to configure eG's mail settings");

	//For Mail senders IDs
	String[] mailIDs =  mailconfig.getVariables("MAIL_SENDERS");
	StringBuffer mailBuff = new StringBuffer();
	for (int i=0;i<mailIDs.length;i++)
	{
		mailBuff.append(mailIDs[i]);
		if (!(mailIDs.length==(i+1)))
			mailBuff.append("\n");
	}
	String authenticateYes = null;
	String authenticateNo = null;

	if (StringUtils.isNull(strUser))
	{
		authenticateYes = EgConstants.BLANK_STRING;
		authenticateNo = "checked";
	}
	else
	{
		authenticateYes = "checked";
		authenticateNo = EgConstants.BLANK_STRING;
		strPwd = EgCrypt.decrypt(strPwd);
	}

	String type1 = "";
	String type2 = "";
	String type3 = "";
	String type4 = "";
	String type5 = "";
	String type6 = "";
	String type7 = "";
	String type8 = "";
	String type9 = "";

	String mail1 = "";
	String mail2 = "";
	String mail3 = "";
	String mail4 = "";
	String mail5 = "";
	String mail6 = "";
	String mail7 = "";
	String mail8 = "";

	//skm (03/03/2006)
	IniFile servicesInfo = new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_services.ini");
	String mailLastValue = null;
	if (servicesInfo != null)
		mailLastValue = servicesInfo.getValue("MISC_ARGS","MailLastValue");
	//skm (03/03/2006)

	StringTokenizer st = new StringTokenizer(strsFormat, ",");
	while(st.hasMoreTokens())
	{
		String strTok = st.nextToken();
		if(strTok.equals("cname"))
			type1 = "checked";
		else if(strTok.equals("ctype"))
			type2 = "checked";
		else if(strTok.equals("desc"))
			type3 = "checked";
		else if(strTok.equals("site"))
			type4 = "checked";
		else if(strTok.equals("test"))
			type5 = "checked";
		else if(strTok.equals("measure"))
			type6 = "checked";
		else if(strTok.equals("mHost"))
			type7 = "checked";
		else if(strTok.equals("layer"))
			type8 = "checked";
		else if(strTok.equals("prior"))
			type9 = "checked";
	}

	StringTokenizer stmail = new StringTokenizer(strmailFormat, ",");
	while(stmail.hasMoreTokens())
	{
		String strTok = stmail.nextToken();
		if(strTok.equals("cname"))
			mail1 = "checked";
		else if(strTok.equals("ctype"))
			mail2 = "checked";
		else if(strTok.equals("layer"))
			mail3 = "checked";
		else if(strTok.equals("desc"))
			mail4 = "checked";
		else if(strTok.equals("site"))
			mail5 = "checked";
		else if(strTok.equals("test"))
			mail6 = "checked";
		else if(strTok.equals("measure"))
			mail7 = "checked";
		else if(strTok.equals("mHost"))
			mail8 = "checked";
	}
%>

<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" >
<%
	session.setAttribute("egPageDesc","EgMailSettings.jsp");
%>
	<jsp:include page="listSearch.jsp?title=MAIL/SMS SETTINGS&leftString=Add New Role&subtitle=false"/>
	<!-- <tr>
		<td width="100%" id="body_headbg">
			<table align="center" width="100%" cellspacing="0" cellpadding="0" border="0" id="padding2">
				<tr>
					<td   id="eg_maintitle" nowrap align="right"> &nbsp; MAIL/SMS SETTINGS &nbsp; >> MAIL CONFIGURATION</td>
					<td  nowrap  width="90%" align="right"><input type="button" value="<<&nbsp;Back" style="width: 60px; height: 19;" id="eg_back" onClick="javascript:history.back();">&nbsp;&nbsp;</td>
				</tr>
			</table>
		</td>
	</tr> -->
<!-- 	<tr>
		<td width="100%" height="24"  id="eg_subtitle" class="eg_cellbglits">&nbsp;&nbsp;This page enables the administrator to configure eG's mail settings.</td>
	</tr> -->
	<tr>
		<td width="100%" id="eg_whitebg" align="center" height="100%" valign="top">
			<form name="mailconfig" method="post" action="Egmailsettingsp.jsp">
				<table align="center" width="85%" cellspacing="0" cellpadding="4" border="0">
					<tr>
						<td align="center" valign="top">
							<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" id="eg_subcontentbg" style="table-layout:clopsed"><col width="7"><col width="320"><col width="20"><col width="350"><col width="7">
								<tr>
									<td colspan="5">
										<table cellspacing="0" cellpadding="0" width="100%" border="0" height="22">
											<tr>
												<td id="subhead_left" width="7"> <img src="/final/admin/eg_images/spacer.gif" border="0" width="7"> </td>
												<td id="eg_subheadbg" style="border-left-width: 0px; border-right-width: 0px;" align="center" width="100%"> <strong><egui:intnl text="admin.mail.Mail/SMS settings"/></strong> </td>
												<td id="subhead_right" width="7"> <img src="/final/admin/eg_images/spacer.gif" border="0" width="7"> </td>
											</tr>
										</table>
									</td>
								</tr>
								<!-- <tr>
									<td height="6" id="inner_top_left" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
									<td height="6" id="eg_subcontentbg" colspan="3"><img src="/final/admin/eg_images/spacer.gif" height="6" width="7" border="0"></td>
									<td height="6" id="inner_top_right" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
								</tr> -->
								<tr>
									<th width="7" class="eg_subcontentbg" id="form_border"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6" ></th>
									<td class="form_border"  nowrap><egui:intnl text="admin.mail.Mail host"/></td>
									<td class="form_border" align="center" nowrap>:</td>
									<td class="form_border" id="paddingright" ><input type="text" name="mailhost" maxlength="256" style="width: 300px;" value="<%= strHost%>" onChange="javascript:setFlag()"></td>
									<td width="7" class="eg_subcontentbg" id="form_border"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
								</tr>
								<input type='hidden' name='$_mailhost' value='Mail host$<%=strHost%>'>
								<tr>
									<th width="7" class="eg_subcontentbg" id="form_border"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6" ></th>
									<td class="form_border"  nowrap><egui:intnl text="admin.mail.Mail port"/></td>
									<td class="form_border" align="center" nowrap>:</td>
									<td class="form_border" id="paddingright" ><input type="text" name="mailport" maxlength="256" style="width: 300px;" value="<%= strPort%>" onChange="javascript:setFlag()"></td>
									<td width="7" class="eg_subcontentbg" id="form_border"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
								</tr>
								<input type='hidden' name='$_mailport' value='Mail port$<%=strPort%>'>
								<tr>
									<th width="7" class="eg_subcontentbg" id="form_border"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6" ></th>
									<td class="form_border"  nowrap><egui:intnl text="admin.mail.Mail protocol"/></td>
									<td class="form_border" align="center" nowrap>:</td>
									<td class="form_border" id="paddingright" ><select name="mailprotocol" maxlength="100" style="width: 100px;">
<%
	for(int i=0;i<strProtocolValues.length;i++)
	{
		String tempProtocol = strProtocolValues[i];
		if(strProtocol.equalsIgnoreCase(tempProtocol))
		{
%>
										<option value=<%=tempProtocol%> selected><egui:intnl text='<%="admin.mail."+strProtocolValues[i]%>'/></option>
<%
		}
		else
		{
%>
										<option value=<%=tempProtocol%>><egui:intnl text='<%="admin.mail."+strProtocolValues[i]%>'/></option>
<%
		}
	}
%>
									</select></td>
									<td width="7" class="eg_subcontentbg" id="form_border"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
								</tr>
								<input type='hidden' name='$_mailprotocol' value='Mail protocol$<%=strProtocol%>'>
								<tr>
									<td width="7" class="eg_subcontentbg" id="form_border"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
									<td class="form_border" nowrap><egui:intnl text="admin.mail.Admin mail ID"/></td>
									<td class="form_border"  align="center" nowrap>:</td>
									<td class="form_border" ><input type="text"  name="mailsender" maxlength="256" style="width: 300px;" value="<%= strSender%>" onChange="javascript:setFlag()"></td>
									<td width="7" class="eg_subcontentbg" id="form_border"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
								</tr>
								<input type='hidden' name='$_mailsender' value='Admin mail ID$<%=strSender%>'>
								<!-- Code for User specific Mail sender code starts here-->
								<tr>
									<td width="7" class="eg_subcontentbg" id="form_border"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6" ></td>
									<td class="form_border" nowrap valign="top"><egui:intnl text="admin.mail.Mail sender ID"/><br>* <egui:intnl text="admin.mail.Provide multiple mail IDs, one row at a time"/>.</td>
									<td class="form_border"  align="center" nowrap valign="top">:</td>
									<td class="form_border"><textarea name='mailsenders' rows='4' cols='30' wrap='virtual' style="width: 300px;" onChange="javascript:setFlag()"><%=mailBuff.toString()%></textarea></td>
									<td width="7" class="eg_subcontentbg" id="form_border"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
								</tr>
								<input type='hidden' name='$_mailsenders' value='Mail senders ID$<%=mailBuff.toString()%>'>
								<!-- Code for User specific Mail sender code ends here-->
								<tr>
									<td width="7" class="eg_subcontentbg" id="form_border"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
									<td class="form_border" nowrap><egui:intnl text="admin.mail.Authenticate"/></td>
									<td class="form_border" align="center" nowrap>:</td>
									<td class="form_border" valign="top" >
										<table cellspacing="0" cellpadding="0" align="left" border="0" width="35%">
											<tr>
												<td id="eg_subcontentbg" class="eg_subcontent" width="10"><input type="radio"class="eg_input" name="authenticate" value="true" <%=authenticateYes%> onClick="javascript:onAuthenticate();" onChange="javascript:setFlag()"></td>
												<td id="eg_subcontentbg" class="eg_subcontent"><egui:intnl text="admin.common.Yes"/></td>
												<td id="eg_subcontentbg" class="eg_subcontent" width="10"><input type="radio"class="eg_input" name="authenticate" value="false" <%=authenticateNo%> onClick="javascript:onAuthenticate();" onChange="javascript:setFlag()"></td>
												<td id="eg_subcontentbg" class="eg_subcontent"><egui:intnl text="admin.common.No"/></td>
											</tr>
										</table>
									</td>
									<td width="7" class="eg_subcontentbg" id="form_border"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
								</tr>
								<input type='hidden' name='$_authenticate' value='Authenticate$<%=authenticateYes.equals("checked")?"true":"false"%>'>
								<!-- <tr>
									<td colspan="3" id="eg_blankspace" height="10" nowrap>&nbsp;</td>
								</tr> -->
								<tr id="authUser">
									<td width="7" class="eg_subcontentbg" id="form_border"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
									<td class="form_border" nowrap><egui:intnl text="admin.mail.User"/></td>
									<td class="form_border"  align="center" nowrap>:</td>
									<td class="form_border" align="left" ><input type="text" name="user" maxlength="256" style="width: 300px;" value="<%=strUser%>" onChange="javascript:setFlag()"></td>
									<td width="7" class="eg_subcontentbg" id="form_border"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
								</tr>
								<input type='hidden' name='$_user' value='User$<%=strUser%>'>
								<!-- <tr>
									<td colspan="3" id="eg_blankspace" height="10" nowrap>&nbsp;</td>
								</tr> -->
								<tr  id="authPwd">
									<td width="7" class="eg_subcontentbg" id="form_border"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
									<td class="form_border"  nowrap><egui:intnl text="admin.mail.Password"/></td>
									<td class="form_border" align="center" nowrap>:</td>
									<td class="form_border" ><input type="password" name="authpassword" maxlength="256" style="width: 300px;"  value="<%=strPwd%>" onChange="javascript:setFlag()"></td>
									<td width="7" class="eg_subcontentbg" id="form_border"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
								</tr>
								<input type='hidden' name='$_password' value='Password$<%=strPwd%>'>
								<!-- <tr>
									<td colspan="3" id="eg_blankspace" height="10" nowrap>&nbsp;</td>
								</tr> -->
								<tr id="authCPwd">
									<td width="7" class="eg_subcontentbg" id="form_border"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
									<td class="form_border"  nowrap><egui:intnl text="admin.mail.Confirm password"/></td>
									<td class="form_border"  align="center" nowrap>:</td>
									<td class="form_border"><input type="password" name="confirm" maxlength="256" style="width: 300px;" onChange="javascript:setFlag()" value="<%=strPwd%>"></td>
									<td width="7" class="eg_subcontentbg" id="form_border"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
								</tr>
<%
	String mailSubjectFormatToUse = mailconfig.getStrValue(subject,"MailSubjectFormatToUse");
	if (mailSubjectFormatToUse.equals(""))
		mailSubjectFormatToUse="CustomFormat";
%>
								<tr>
									<td width="7" class="eg_subcontentbg" id="form_border"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
									<td class="form_border"  nowrap valign="top"><egui:intnl text="admin.mail.Mail subject format"/></td>
									<td class="form_border" align="center" nowrap valign="top">:</td>
									<td class="form_border" nowrap>
										<table cellspacing="0" cellpadding="0" border="0" width="44%" align="left">
											<tr>
												<td id="eg_subcontentbg" class="eg_subcontent" width="10"><input type="radio" class="eg_input" name="MailSubjectFormatToUse" value="CustomFormat" <%=mailSubjectFormatToUse.equalsIgnoreCase("CustomFormat") ? "checked":""%> onClick="javascript:showOrHide();" onChange="javascript:setFlag()"></td>
												<td id="eg_subcontentbg" class="eg_subcontent"><egui:intnl text="admin.mail.Concise"/></td>
												<td id="eg_subcontentbg" class="eg_subcontent" width="10"><input type="radio" class="eg_input" name="MailSubjectFormatToUse" value="DefinedFormat" <%=mailSubjectFormatToUse.equalsIgnoreCase("DefinedFormat") ? "checked":""%> onClick="javascript:showOrHide();" onChange="javascript:setFlag()"></td>
												<td id="eg_subcontentbg" class="eg_subcontent"><egui:intnl text="admin.mail.Descriptive"/></td>
											</tr>
										</table>
									</td>
									<td width="7" class="eg_subcontentbg" id="form_border"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
								</tr>
								<input type='hidden' name='$_MailSubjectFormatToUse' value='Mail subject format$<%=mailSubjectFormatToUse.equalsIgnoreCase("DefinedFormat") ? "Descriptive":"Concise"%>'>

								<tr id="id1" style="display:none">
									<td width="7" class="eg_subcontentbg" id="form_border"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
									<td class="form_border" nowrap valign="top"><egui:intnl text="admin.mail.Mail subject"/></td>
									<td class="form_border" align="center" nowrap valign="top">:</td>
									<td class="form_border" valign="top"><textarea name='mailsub' rows='4' cols='30' wrap='virtual'  style="width: 300px;" onChange="javascript:setFlag()"><%= strmSub%></textarea></td>
									<td width="7" class="eg_subcontentbg" id="form_border"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
								</tr>
								<input type='hidden' name='$_mailsub' value='Mail subject$<%=strmSub%>'>
<%
	String mailSubjectStart = mailconfig.getStrValue(subject,"MailSubjectStart");
	if (StringUtils.isNull(mailSubjectStart))
	{
		mailSubjectStart = EgConstants.BLANK_STRING;
	}
%>
								<tr id="id2" style="display:none">
									<td width="7" class="eg_subcontentbg" id="form_border"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
									<td class="form_border" id="form_border" nowrap valign="top"><egui:intnl text="admin.mail.Start of mail subject"/></td>
									<td class="form_border"nowrap align="center" valign="top">:</td>
									<td class="form_border" nowrap><input type='text' name='MailSubjectStart' onChange="javascript:setFlag()" value="<%=mailSubjectStart%>" maxlength="256" style="width: 300px;"></td>
									<td width="7" class="eg_subcontentbg" id="form_border"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
								</tr>
								<input type='hidden' name='$_MailSubjectStart' value='Start of mail subject$<%=mailSubjectStart%>'>
<%
	String mailSubjectFormat = mailconfig.getStrValue(subject,"MailSubjectFormat");
	if (StringUtils.isNull(mailSubjectFormat))
	{
		mailSubjectFormat = "CompName:Priority";
	}
	String mailSubjectCFormat = mailconfig.getStrValue(subject,"MailSubjectCFormat");

	String mailSubject_SV = "";
	String mailSubject_CN = "";
	String mailSubject_CT = "";
	String mailSubject_LY = "";
	String mailSubject_TN = "";
	String mailSubject_DC = "";
	String mailSubject_LM = "";
	String mailSubject_PT = "";
	String mailSubject_AID = "";
	String mailSubject_CPT = "";
	String mailSubject_CAID = "";

	if(mailSubjectCFormat!=null && !mailSubjectCFormat.equals(""))
	{
		StringTokenizer strTokens_c = new StringTokenizer(mailSubjectCFormat,":");
		while (strTokens_c.hasMoreTokens())
		{
			String strToken1 = strTokens_c.nextToken();
			if(strToken1.equalsIgnoreCase("Priority"))
			{
				mailSubject_CPT = "checked";
			}
			else if(strToken1.equalsIgnoreCase("AlarmId"))
			{
				mailSubject_CAID = "checked";
			}
		}
	}
	
	StringTokenizer strTokens = new StringTokenizer(mailSubjectFormat,":");
	while (strTokens.hasMoreTokens())
	{
		String strToken = strTokens.nextToken();
		if (strToken.equalsIgnoreCase("Service"))
		{
			mailSubject_SV = "checked";
		}
		else if (strToken.equalsIgnoreCase("CompName"))
		{
			mailSubject_CN = "checked";
		}
		else if (strToken.equalsIgnoreCase("CompType"))
		{
			mailSubject_CT = "checked";
		}
		else if (strToken.equalsIgnoreCase("Layer"))
		{
			mailSubject_LY = "checked";
		}
		else if (strToken.equalsIgnoreCase("Test"))
		{
			mailSubject_TN = "checked";
		}
		else if (strToken.equalsIgnoreCase("Description"))
		{
			mailSubject_DC = "checked";
		}
		else if (strToken.equalsIgnoreCase("LMV"))
		{
			mailSubject_LM = "checked";
		}
		else if(strToken.equalsIgnoreCase("Priority"))
		{
			mailSubject_PT = "checked";
		}
		else if(strToken.equalsIgnoreCase("AlarmId"))
		{
			mailSubject_AID = "checked";
		}
	}
%>
								<tr id="id3" style="display:none">
									<td width="7" class="eg_subcontentbg" id="form_border"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
									<td class="form_border" id="form_border" nowrap valign="top"><egui:intnl text="admin.mail.Contents of mail subject"/></td>
									<td class="form_border" nowrap align="center" valign="top" >:</td>
									<td class="form_border" valign="top" style="padding:0px" id="id31" style="display:none">
									<table width="100%" cellspacing="0" cellpadding="2"  border="0"><col width="5%"><col width="95%">
										<tr>
											<td id="eg_subcontentbg" class="eg_subcontent"><input type="checkbox" class="eg_input" onChange="javascript:setFlag()" name="mailSubjectCPrior" value="Priority" <%=mailSubject_CPT%>></td>
											<td id="eg_subcontentbg" class="eg_subcontent"><egui:intnl text="admin.common.Priority"/></td>
										</tr>
										<input type='hidden' name='$_mailSubjectCPrior' value='Contents of concise mail subject$<%=mailSubject_CPT.equals("checked")?"Priority":""%>'>
										<tr>
											<td id="eg_subcontentbg" class="eg_subcontent"><input type="checkbox" class="eg_input" onChange="javascript:setFlag()" name="mailSubjectCAlarmId" value="AlarmId" <%=mailSubject_CAID%>></td>
											<td id="eg_subcontentbg" class="eg_subcontent"><egui:intnl text="admin.common.AlarmID"/></td>
										</tr>
										<input type='hidden' name='$_mailSubjectCAlarmId' value='Contents of concise mail subject$<%=mailSubject_CAID.equals("checked")?"AlarmId":""%>'>
									</table>
									</td>
									<td class="form_border" valign="top" style="padding:0px" id="id4" style="display:none">
										<table width="100%" cellspacing="0" cellpadding="2"  border="0"><col width="5%"><col width="95%">
											<tr>
												<td id="eg_subcontentbg" class="eg_subcontent"><input type="checkbox" class="eg_input" onChange="javascript:setFlag()" name="mailSubjectService" value="Service" <%=mailSubject_SV%>></td>
												<td id="eg_subcontentbg" class="eg_subcontent"><egui:intnl text="admin.common.Services"/></td>
											</tr>
											<input type='hidden' name='$_mailSubjectService' value='Contents of descriptive mail subject$<%=mailSubject_SV.equals("checked")?"Services":""%>'>
											<tr>
												<td id="eg_subcontentbg" class="eg_subcontent"><input type="checkbox" class="eg_input" onChange="javascript:setFlag()" name="mailSubjectCompName" value="CompName" <%=mailSubject_CN%>></td>
												<td id="eg_subcontentbg" class="eg_subcontent"><egui:intnl text="admin.common.Component name"/></td>
											</tr>
											<input type='hidden' name='$_mailSubjectCompName' value='Contents of descriptive mail subject$<%=mailSubject_CN.equals("checked")?"Component name":""%>'>
											<tr>
												<td id="eg_subcontentbg" class="eg_subcontent"><input type="checkbox" class="eg_input" onChange="javascript:setFlag()" name="mailSubjectCompType" value="CompType" <%=mailSubject_CT%>></td>
												<td id="eg_subcontentbg" class="eg_subcontent"><egui:intnl text="admin.common.Component type"/></td>
											</tr>
											<input type='hidden' name='$_mailSubjectCompType' value='Contents of descriptive mail subject$<%=mailSubject_CT.equals("checked")?"Component type":""%>'>
											<tr>
												<td id="eg_subcontentbg" class="eg_subcontent"><input type="checkbox" class="eg_input" onChange="javascript:setFlag()" name="mailSubjectLayer" value="Layer" <%=mailSubject_LY%>></td>
												<td id="eg_subcontentbg" class="eg_subcontent"><egui:intnl text="admin.common.Layer"/></td>
											</tr>
											<input type='hidden' name='$_mailSubjectLayer' value='Contents of descriptive mail subject$<%=mailSubject_LY.equals("checked")?"Layer":""%>'>
											<tr>
												<td id="eg_subcontentbg" class="eg_subcontent"><input type="checkbox" class="eg_input" name="mailSubjectTest" value="Test" <%=mailSubject_TN%> onClick="javascript:checkDescAndMeasure()"></td>
												<td id="eg_subcontentbg" class="eg_subcontent"><egui:intnl text="admin.common.Test"/></td>
											</tr>
											<input type='hidden' name='$_mailSubjectTest' value='Contents of descriptive mail subject$<%=mailSubject_TN.equals("checked")?"Test":""%>'>
											<tr>
												<td id="eg_subcontentbg" class="eg_subcontent"><input type="checkbox" class="eg_input" name="mailSubjectDesc" value="Description" <%=mailSubject_DC%> onClick="javascript:enableTestAndMeasure()"></td>
												<td id="eg_subcontentbg" class="eg_subcontent"><egui:intnl text="admin.common.Description"/></td>
											</tr>
											<input type='hidden' name='$_mailSubjectDesc' value='Contents of descriptive mail subject$<%=mailSubject_DC.equals("checked")?"Description":""%>'>

<%
	if (mailLastValue != null && (mailLastValue.equalsIgnoreCase("yes") || mailLastValue.equalsIgnoreCase("true")))
	{
%>
											<tr>
												<td id="eg_subcontentbg" class="eg_subcontent"><input type="checkbox" class="eg_input" name="mailSubjectLMV" value="LMV" <%=mailSubject_LM%> onClick="javascript:enableTestAndDesc()"></td>
												<td id="eg_subcontentbg" class="eg_subcontent" ><egui:intnl text="admin.common.Last measure value" /></td>
											</tr>
											<input type='hidden' name='$_mailSubjectLMV' value='Contents of descriptive mail subject$<%=mailSubject_LM.equals("checked")?"Last measure value":""%>'>
<%
	}
%>
											<tr>
													<td id="eg_subcontentbg" class="eg_subcontent"><input type="checkbox" class="eg_input" onChange="javascript:setFlag()" name="mailSubjectPrior" value="Priority" <%=mailSubject_PT%>></td>
													<td id="eg_subcontentbg" class="eg_subcontent"><egui:intnl text="admin.common.Priority"/></td>
											</tr>
											<input type='hidden' name='$_mailSubjectPrior' value='Contents of descriptive mail subject$<%=mailSubject_PT.equals("checked")?"Priority":""%>'>
											<tr>
												<td id="eg_subcontentbg" class="eg_subcontent"><input type="checkbox" class="eg_input" onChange="javascript:setFlag()" name="mailSubjectAlarmId" value="AlarmId" <%=mailSubject_AID%>></td>
												<td id="eg_subcontentbg" class="eg_subcontent"><egui:intnl text="admin.common.AlarmID"/></td>
											</tr>
											<input type='hidden' name='$_mailSubjectAlarmId' value='Contents of descriptive mail subject$<%=mailSubject_AID.equals("checked")?"AlarmId":""%>'>

										</table>
									</td>
									<td width="7" class="eg_subcontentbg" id="form_border"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
								</tr>
<%
	String mailSubjectLength = mailconfig.getStrValue(subject,"MailSubjectLength");
	if (StringUtils.isNull(mailSubjectLength))
	{
		mailSubjectLength = EgConstants.BLANK_STRING;
	}
%>
								<tr id="id5" style="display:none">
									<td width="7" class="eg_subcontentbg" id="form_border"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
									<td class="form_spacing" id="form_border" nowrap valign="top"><egui:intnl text="admin.mail.Maximum components in mail subject"/></td>
									<td class="form_border"  nowrap align="center">:</td>
									<td class="form_border"  nowrap><input type='text' name='MailSubjectLength' onChange="javascript:setFlag()"  value="<%=mailSubjectLength%>" maxlength="256" style="width: 300px;"></td>
									<td width="7" class="eg_subcontentbg" id="form_border"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
								</tr>
								<input type='hidden' name='$_MailSubjectLength' value='Max components in mail subject$<%=mailSubjectLength%>'>

								<script language="JavaScript">
									showOrHide();
								</script>

								<tr>
									<td width="7" class="eg_subcontentbg" id="form_border"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
									<td class="form_border"  nowrap  valign="top"><egui:intnl text="admin.mail.Mail preferences"/></td>
									<td class="form_border"  align="center" nowrap valign="top">:</td>
									<td  class="form_border" valign="top" style="padding:0px">
										<table width="100%" cellspacing="0" cellpadding="2"  border="0"><col width="5%"><col width="95%">
											<tr>
												<td id="eg_subcontentbg" class="eg_subcontent"><input type="checkbox"class="eg_input" name="mailsite" onChange="javascript:setFlag()" value="site" <%=mail5%>></td>
												<td id="eg_subcontentbg" class="eg_subcontent" > <egui:intnl text="admin.common.Services"/></td>
											</tr>
											<input type='hidden' name='$_mailsite' value='Mail preferences$<%=mail5.equals("checked")?"site":""%>'>
											<tr>
												<td id="eg_subcontentbg" class="eg_subcontent" ><input type="checkbox" class="eg_input"name="mailcname" onChange="javascript:setFlag()" value="cname" <%=mail1%>></td>
												<td id="eg_subcontentbg" class="eg_subcontent" > <egui:intnl text="admin.common.Component name"/></td>
											</tr>
											<input type='hidden' name='$_mailcname' value='Mail preferences$<%=mail1.equals("checked")?"cname":""%>'>
											<tr>
												<td id="eg_subcontentbg" class="eg_subcontent"><input type="checkbox"class="eg_input" name="mailctype" onChange="javascript:setFlag()" value="ctype" <%=mail2%>></td>
												<td id="eg_subcontentbg" class="eg_subcontent" > <egui:intnl text="admin.common.Component type"/></td>
											</tr>
											<input type='hidden' name='$_mailctype' value='Mail preferences$<%=mail2.equals("checked")?"ctype":""%>'>
											<tr>
												<td id="eg_subcontentbg" class="eg_subcontent"><input type="checkbox"class="eg_input" name="maillayer" onChange="javascript:setFlag()" value="layer" <%=mail3%>></td>
												<td id="eg_subcontentbg" class="eg_subcontent" > <egui:intnl text="admin.common.Layer"/></td>
											</tr>
											<input type='hidden' name='$_maillayer' value='Mail preferences$<%=mail3.equals("checked")?"layer":""%>'>
											<tr>
												<td id="eg_subcontentbg" class="eg_subcontent"><input type="checkbox"class="eg_input" name="mailtest" onChange="javascript:setFlag()" value="test" <%=mail6%> onClick="javascript:checkDescAndMeasure()">
												</td>
												<td id="eg_subcontentbg" class="eg_subcontent" > <egui:intnl text="admin.common.Test"/></td>
											</tr>
											<input type='hidden' name='$_mailtest' value='Mail preferences$<%=mail6.equals("checked")?"test":""%>'>
											<tr>
												<td id="eg_subcontentbg" class="eg_subcontent"><input type="checkbox"class="eg_input" name="maildesc" onChange="javascript:setFlag()" value="desc" <%=mail4%> onClick="javascript:enableTestAndMeasure()"></td>
												<td id="eg_subcontentbg" class="eg_subcontent" > <egui:intnl text="admin.common.Description"/></td>
											</tr>
											<input type='hidden' name='$_maildesc' value='Mail preferences$<%=mail4.equals("checked")?"desc":""%>'>
<%
	if (mailLastValue!=null && (mailLastValue.equalsIgnoreCase("yes") || mailLastValue.equalsIgnoreCase("true")))	//skm (03/03/2006)
	{
%>
											<tr>
												<td id="eg_subcontentbg" class="eg_subcontent"><input type="checkbox"class="eg_input" name="mailmeasure" onChange="javascript:setFlag()" value="measure" <%=mail7%> onClick="javascript:enableTestAndDesc()"></td>
												<td id="eg_subcontentbg" class="eg_subcontent" > <egui:intnl text="admin.common.Last measure value"/></td>
											</tr>
											<input type='hidden' name='$_mailmeasure' value='Mail preferences$<%=mail7.equals("checked")?"measure":""%>'>
<%
	}
%>
											<tr>
												<td id="eg_subcontentbg" class="eg_subcontent"><input type="checkbox"class="eg_input" name="mailmhost" onChange="javascript:setFlag()" value="mhost" <%=mail8%>></td>
												<td id="eg_subcontentbg" class="eg_subcontent" > <egui:intnl text="admin.common.Measurement host"/></td>
											</tr>
											<input type='hidden' name='$_mailmhost' value='Mail preferences$<%=mail8.equals("checked")?"mhost":""%>'>
										</table>
									</td>
									<td width="7" class="eg_subcontentbg" id="form_border"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
								</tr>
										<!-- Mail setting ends here -->
<%
	String idClass = "form_spacing";
	if(smsEnabled)
	{
		idClass = "form_border";
	}
%>
								<tr>
									<td width="7" class="eg_subcontentbg" id="form_border"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
									<td class="form_border"  nowrap  valign="middle" height="35"><egui:intnl text="admin.mail.Send separate mails for each alert"/></td>
									<td class="form_border"  align="center" nowrap valign="middle">:</td>
									<td class="form_border" style="padding:0px">
										<table   width="35%" cellspacing="0" cellpadding="0"  border="0">
											<tr>
<%
	if (strmailseparate.equalsIgnoreCase("true"))
	{
%>
												<td id="eg_subcontentbg" class="eg_subcontent" width="10"><input type="radio"class="eg_input" name="separatemail"   value="true" Checked ></td>
												<td><egui:intnl text="admin.common.Yes"/></td>
												<td id="eg_subcontentbg" class="eg_subcontent" width="10"><input type="radio" class="eg_input" name="separatemail" onChange="javascript:setFlag()" value="false" ></td>
												<td><egui:intnl text="admin.common.No"/></td>
<%
	}
	else
	{
%>
												<td id="eg_subcontentbg" class="eg_subcontent" ><input type="radio"class="eg_input" name="separatemail" onChange="javascript:setFlag()" value="true"><egui:intnl text="admin.common.Yes"/></td>
												<td id="eg_subcontentbg" class="eg_subcontent"><input type="radio" class="eg_input" name="separatemail"  value="false" Checked ><egui:intnl text="admin.common.No"/></td>
<%
	}
%>
											</tr>
											<input type='hidden' name='$_separatemail' value='Send separate mails for each alert$<%=strmailseparate.equalsIgnoreCase("true")?"Yes":"No"%>'>
										</table>
									</td>
									<td width="7" class="eg_subcontentbg" id="form_border"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
								</tr>
<!-- Alert mail attachment starts here-->
								<tr>
									<td width="7" class="eg_subcontentbg" id="form_border"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
									<td class="form_border"  nowrap  valign="middle" height="35"><egui:intnl text="admin.mail.Send alert as attachment"/></td>
									<td class="form_border"  align="center" nowrap valign="middle">:</td>
									<td class="form_border" style="padding:0px">
										<table width="35%" cellspacing="0" cellpadding="0"  border="0">
											<tr>
<%
	if (mailAsAttachment.equalsIgnoreCase("true") || mailAsAttachment.equalsIgnoreCase("yes"))
	{
%>
												<td id="eg_subcontentbg" class="eg_subcontent" width="10"><input type="radio"class="eg_input" name="mailAsAttachment" value="true" Checked ></td>
												<td><egui:intnl text="admin.common.Yes"/></td>
												<td id="eg_subcontentbg" class="eg_subcontent" width="10"><input type="radio" class="eg_input" name="mailAsAttachment" value="false" ></td>
												<td><egui:intnl text="admin.common.No"/></td>
<%
	}
	else
	{
%>
												<td id="eg_subcontentbg" class="eg_subcontent" ><input type="radio"class="eg_input" name="mailAsAttachment" value="true"><egui:intnl text="admin.common.Yes"/></td>
												<td id="eg_subcontentbg" class="eg_subcontent"><input type="radio" class="eg_input" name="mailAsAttachment" value="false" Checked ><egui:intnl text="admin.common.No"/></td>
<%
	}
%>
											</tr>
											<input type='hidden' name='$_mailAsAttachment' value='Send alert as attachment$<%=(mailAsAttachment.equalsIgnoreCase("true") || mailAsAttachment.equalsIgnoreCase("yes"))?"Yes":"No"%>'>
										</table>
									</td>
									<td width="7" class="eg_subcontentbg" id="form_border"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
								</tr>
<!--Alert mail attachment ends here-->
<!-- Normal Mail alert Starts here-->
								<tr>
									<td width="7" class="eg_subcontentbg" id="form_border"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
									<td class="form_border"  nowrap  valign="middle" height="35"><egui:intnl text="admin.mail.Send mails/sms when alarms are cleared"/></td>
									<td class="form_border"  align="center" nowrap valign="middle">:</td>
									<td class="form_border" style="padding:0px">
										<table   width="35%" cellspacing="0" cellpadding="0"  border="0">
											<tr>
<%
	if (normalMail.equalsIgnoreCase("true"))
	{
%>
												<td id="eg_subcontentbg" class="eg_subcontent" width="10"><input type="radio"class="eg_input" name="normalmail" value="true" Checked></td>
												<td><egui:intnl text="admin.common.Yes"/></td>
												<td id="eg_subcontentbg" class="eg_subcontent" width="10"><input type="radio" class="eg_input" name="normalmail" onChange="javascript:setFlag()"
												value="false" ></td>
												<td><egui:intnl text="admin.common.No"/></td>
<%
	}
	else
	{
%>
												<td id="eg_subcontentbg" class="eg_subcontent" ><input type="radio"class="eg_input" name="normalmail" onChange="javascript:setFlag()" value="true"><egui:intnl text="admin.common.Yes"/></td>
												<td id="eg_subcontentbg" class="eg_subcontent"><input type="radio" class="eg_input" name="normalmail" value="false" Checked ><egui:intnl text="admin.common.No"/></td>
<%
	}
%>
											</tr>
											<input type='hidden' name='$_normalmail' value='Send mails/sms when alarms are cleared$<%=normalMail.equalsIgnoreCase("true")?"Yes":"No"%>'>
										</table>
									</td>
									<td width="7" class="eg_subcontentbg" id="form_border"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
								</tr>
<!-- Normal Mail alert Ends here-->
<!-- DD in mail alerts code starts here-->
								<tr>
									<td width="7" class="eg_subcontentbg" id="<%=idClass%>"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
									<td class="<%=idClass%>"  nowrap  valign="middle" height="35"><egui:intnl text="admin.mail.Include detailed diagnosis(DD) in mail alerts"/></td>
									<td class="<%=idClass%>"  align="center" nowrap valign="middle">:</td>
									<td class="<%=idClass%>" style="padding:0px">
										<table width="35%" cellspacing="0" cellpadding="0" border="0">
											<tr>
<%
	if (ddMail.equalsIgnoreCase("yes"))
	{
%>
												<td id="eg_subcontentbg" class="eg_subcontent" width="10"><input type="radio"class="eg_input" name="ddmail"
												value="yes" Checked ></td>
												<td><egui:intnl text="admin.common.Yes"/></td>
												<td id="eg_subcontentbg" class="eg_subcontent" width="10"><input type="radio" class="eg_input" name="ddmail" onChange="javascript:setFlag()"
												value="no" ></td>
												<td><egui:intnl text="admin.common.No"/></td>
<%
	}
	else
	{
%>
												<td id="eg_subcontentbg" class="eg_subcontent" ><input type="radio"class="eg_input" name="ddmail" onChange="javascript:setFlag()"
												value="yes"><egui:intnl text="admin.common.Yes"/></td>
												<td id="eg_subcontentbg" class="eg_subcontent"><input type="radio" class="eg_input" name="ddmail"
												value="no" Checked ><egui:intnl text="admin.common.No"/></td>
<%
	}
%>
											</tr>
											<input type='hidden' name='$_ddmail' value='Include detailed diagnosis(DD) in mail alerts$<%=ddMail.equalsIgnoreCase("yes")?"Yes":"No"%>'>
										</table>
									</td>
									<td width="7" class="eg_subcontentbg" id="<%=idClass%>"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
								</tr>
<!-- DD in mail alerts code ends here-->
								<!-- <tr>
									<td colspan="3" id="eg_blankspace" height="10" nowrap>&nbsp;</td>
								</tr> -->
<%
	if(smsEnabled)
	{
%>
								<tr>
									<td width="7" class="eg_subcontentbg" id="form_border"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
									<td class="form_border" nowrap  valign="top"><egui:intnl text="admin.mail.SMS subject"/></td>
									<td class="form_border"  align="center" nowrap valign="top">:</td>
									<td class="form_border"><textarea name='smssub' rows='4' cols='30' wrap='virtual'  style="width: 300px;" onChange="javascript:setFlag()"><%=strsSub%></textarea></td>
									<td width="7" class="eg_subcontentbg" id="form_border"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
								</tr>
								<input type='hidden' name='$_smssub' value='SMS subject$<%=strsSub%>'>
								<!-- <tr>
									<td colspan="3" id="eg_blankspace" height="10" nowrap>&nbsp;</td>
								</tr> -->
								<tr>
									<td width="7" class="eg_subcontentbg" id="form_border"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
									<td class="form_border"  nowrap  valign="top"><egui:intnl text="admin.mail.SMS preferences"/></td>
									<td class="form_border"  align="center" nowrap valign="top">:</td>
									<td  class="form_border" valign="top" style="padding:0px">
										<table width="100%" cellspacing="0" cellpadding="2"  border="0"><col width="5%"><col width="95%">
											<tr>
												<td id="eg_subcontentbg" class="eg_subcontent"><input type="checkbox"class="eg_input" name="site" onChange="javascript:setFlag()" value="site" <%=type4%>> </td>
												<td id="eg_subcontentbg" class="eg_subcontent"><egui:intnl text="admin.common.Services"/></td>
											</tr>
											<input type='hidden' name='$_site' value='SMS preferences$<%=type4.equals("checked")?"site":""%>'>
											<tr>
												<td id="eg_subcontentbg" class="eg_subcontent" ><input type="checkbox" class="eg_input" name="cname" onChange="javascript:setFlag()" value="cname_sms" <%=type1%>></td>
												<td id="eg_subcontentbg" class="eg_subcontent"><egui:intnl text="admin.common.Component name"/></td>
											</tr>
											<input type='hidden' name='$_cname' value='SMS preferences$<%=type1.equals("checked")?"cname_sms":""%>'>
											<tr>
												<td id="eg_subcontentbg" class="eg_subcontent"><input type="checkbox"class="eg_input" name="ctype" onChange="javascript:setFlag()" value="ctype" <%=type2%>></td>
												<td id="eg_subcontentbg" class="eg_subcontent"><egui:intnl text="admin.common.Component type"/></td>
											</tr>
											<input type='hidden' name='$_ctype' value='SMS preferences$<%=type2.equals("checked")?"ctype":""%>'>
											<tr>
												<td id="eg_subcontentbg" class="eg_subcontent"><input type="checkbox" class="eg_input" name="layer" onChange="javascript:setFlag()" value="layer" <%=type8%>></td>
												<td id="eg_subcontentbg" class="eg_subcontent"><egui:intnl text="admin.common.Layer"/></td>
											</tr>
											<input type='hidden' name='$_layer' value='SMS preferences$<%=type8.equals("checked")?"layer":""%>'>
											<tr>
												<td id="eg_subcontentbg" class="eg_subcontent"><input type="checkbox"class="eg_input" name="test" onChange="javascript:setFlag()" value="test" <%=type5%> onclick="javascript:checkDescAndMeasure()"></td>
												<td id="eg_subcontentbg" class="eg_subcontent"><egui:intnl text="admin.common.Test"/></td>
											</tr>
											<input type='hidden' name='$_test' value='SMS preferences$<%=type5.equals("checked")?"test":""%>'>
											<tr>
												<td id="eg_subcontentbg" class="eg_subcontent"><input type="checkbox"class="eg_input" name="desc" onChange="javascript:setFlag()" value="desc" <%=type3%> onClick="javascript:enableTestAndMeasure()"></td>
												<td id="eg_subcontentbg" class="eg_subcontent"><egui:intnl text="admin.common.Description"/></td>
											</tr>
											<input type='hidden' name='$_desc' value='SMS preferences$<%=type3.equals("checked")?"desc":""%>'>
<%
		if (mailLastValue!=null && (mailLastValue.equalsIgnoreCase("yes") || mailLastValue.equalsIgnoreCase("true")))	//skm (03/03/2006)
		{
%>
											<tr>
												<td id="eg_subcontentbg" class="eg_subcontent"><input type="checkbox"class="eg_input" name="measure" onChange="javascript:setFlag()" value="measure" <%=type6%> onClick="javascript:enableTestAndDesc()"></td>
												<td id="eg_subcontentbg" class="eg_subcontent"><egui:intnl text="admin.common.Last measure value"/></td>
											</tr>
											<input type='hidden' name='$_measure' value='SMS preferences$<%=type6.equals("checked")?"measure":""%>'>
<%
		}
%>
											<tr>
												<td id="eg_subcontentbg" class="eg_subcontent"><input type="checkbox"class="eg_input" name="mhost" onChange="javascript:setFlag()" value="mhost" <%=type7%>></td>
												<td id="eg_subcontentbg" class="eg_subcontent"><egui:intnl text="admin.common.Measurement host"/></td>
											</tr>
											<input type='hidden' name='$_mhost' value='SMS preferences$<%=type7.equals("checked")?"mhost":""%>'>
											<tr>
												<td id="eg_subcontentbg" class="eg_subcontent"><input type="checkbox"class="eg_input" name="prior" onChange="javascript:setFlag()" value="prior" <%=type9%>></td>
												<td id="eg_subcontentbg" class="eg_subcontent"><egui:intnl text="admin.common.Priority"/></td>
											</tr>
											<input type='hidden' name='$_prior' value='SMS preferences$<%=type9.equals("checked")?"prior":""%>'>
										</table>
									</td>
									<td width="7" class="eg_subcontentbg" id="form_border"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
								</tr>
								<!-- <tr>
									<td colspan="3" id="eg_blankspace" height="10" nowrap>&nbsp;</td>
								</tr> -->
								<tr>
									<td width="7" class="eg_subcontentbg" id="form_spacing"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
									<td class="form_spacing"  nowrap  valign="middle" height="35"><egui:intnl text="admin.mail.Send separate SMS for each alert"/></td>
									<td class="form_spacing"  align="center" nowrap valign="middle">:</td>
									<td class="form_spacing" style="padding:0px">
										<table   width="35%" cellspacing="0" cellpadding="0"  border="0">
											<tr>
<%
		if (strsmsseparate.equalsIgnoreCase("yes"))
		{
%>
												<td id="eg_subcontentbg" width="10" class="eg_subcontent">
												<input type="radio"class="eg_input" name="separatesms" value="Yes" Checked ><egui:intnl text="admin.common.Yes"/></td>
												<td id="eg_subcontentbg" width="10" class="eg_subcontent"><input type="radio"class="eg_input" name="separatesms" onChange="javascript:setFlag()" value="No" ><egui:intnl text="admin.common.No"/></td>
<%
		}
		else
		{
%>
												<td id="eg_subcontentbg" width="10" class="eg_subcontent" ><input type="radio"class="eg_input" name="separatesms" value="Yes"><egui:intnl text="admin.common.Yes"/></td>
												<td id="eg_subcontentbg" width="10" class="eg_subcontent"><input type="radio"class="eg_input" name="separatesms" value="No" Checked onChange="javascript:setFlag()"><egui:intnl text="admin.common.No"/></td>
<%
		}
%>
											</tr>
											<input type='hidden' name='$_separatesms' value='Send separate SMS for each alert$<%=strsmsseparate.equalsIgnoreCase("yes")?"Yes":"No"%>'>
										</table>
									</td>
									<td width="7" class="eg_subcontentbg" id="form_spacing"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
								</tr>
<%
	}
%>
								<!-- <tr>
									<td colspan="3" id="eg_blankspace" height="10" nowrap>&nbsp;</td>
								</tr> -->
								<tr>
									<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
									<td id="eg_subcontentbg"  width="100%"  valign="top" colspan="3"><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
									<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
								</tr>
								<tr>
									<!-- <td colspan="2" id="eg_whitebg">&nbsp;</td> -->
									<td height="30" valign="bottom" id="eg_whitebg" colspan="5" align="center">
												<!--
													<SPAN ID="updateImg" STYLE="position:relative; visibility:visible;">
												-->
									<input type="button" name="update" value='<egui:intnl text="admin.common.Update"/>' style="width: 80px;" class="eg_darkbutton" onClick="javascript:populate()" >&nbsp;&nbsp;
									<input type="button" name="update" value='<egui:intnl text="admin.mail.Advanced Settings"/>' style="width: 150px;" class="eg_darkbutton" onClick="javascript:alertMessage()" >
												<!--
													</SPAN>
												-->
									</td>
								</tr>
							</table>
						</td>
					</tr>
				</table>
<%
	if (mailLastValue!=null && (mailLastValue.equalsIgnoreCase("yes")||mailLastValue.equalsIgnoreCase("true")))	//skm (09/03/2006)
	{
%>
				<input type="hidden" name="measureFlag" value="true">
				<input type="hidden" name="smsMeasureFlag" value="true">
				<input type="hidden" name="mailSubjectMeasureFlag" value="true">
<%
	}
	else
	{
%>
				<input type="hidden" name="measureFlag" value="false">
				<input type="hidden" name="smsMeasureFlag" value="false">
				<input type="hidden" name="mailSubjectMeasureFlag" value="false">
<%
	}
%>
				</form>
			</td>
		</tr>
	</table>
<%
	if (request.getQueryString() != null)
	{
		session.setAttribute("adminLastAccessedURL","/final/admin/EgMailSettings.jsp?"+request.getQueryString());
	}
	else
	{
		session.setAttribute("adminLastAccessedURL","/final/admin/EgMailSettings.jsp");
	}
%>
</body>
</html>



