<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">

<%
/***************************************************************
 *  File         : 	EgGroupThreshPolicies.jsp
 *  Purpose      : Configure threshold for a test.
 ***************************************************************/
%>

<%@ taglib prefix = "egui" uri = "../WEB-INF/eg-taglib.tld"%>
<%@ include file="EgTrackerA.jsp" %>
<%@ page errorPage="EgProbs.jsp"%>
<%@ page import="java.util.*" %>
<%@ page import="com.eg.EgServerGroupBean" %>
<%@ page import="com.eg.EgInstallInfo"%>
<%@ page import="com.eg.EgSpecsInfo" %>
<%@ page import="com.eg.EgRoleInfo" %>
<%@ page import="com.eg.EgThresholdInfo" %>
<%@ page import = "com.eg.EgTesterInfo" %>
<%@ page import = "com.eg.EgTablesInfo" %>
<%@ page import="com.egurkha.ini.*" %>
<%@ page import="com.egurkha.util.*" %>
<%@ page import="com.eg.EgName"%>
<%@ page import="com.eg.MappingNameSorter"%>
<%@ page import="com.egurkha.ini.IniUI"%>
<%@ page import = "com.eg.EgURLEncoder" %>

<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>

<%!
	EgSpecsInfo egSpecs = new EgSpecsInfo("manager");
	EgTesterInfo testerInfo = new EgTesterInfo("manager");
	EgThresholdInfo egThresh = new EgThresholdInfo("manager");
	EgTablesInfo tablesInfo = new EgTablesInfo("manager");
%>

<%
	EgRoleInfo egRoleInfo=EgRoleInfo.getInstance(session.getId(),(String)session.getAttribute("sess_userid"));
	List listManagedComponents = egRoleInfo.getAllServers();

	String[] threshPol = new String[]{"absolute","relative","none"};
	String includePage = "listSearch.jsp?title=AGENT - THRESHOLDS&leftString=Add User&backButton=true&subtitle=false";

	IniUI ui = (IniUI)com.egurkha.ini.IniUI.getInstance();
	String[] priorArr = new String[] 
		{
			ui.getStateDisplayLabel("LOW"),
			ui.getStateDisplayLabel("INTERMEDIATE"),
			ui.getStateDisplayLabel("HIGH")
		};

	String pg = request.getParameter("page");
	String server=request.getParameter("server");
	String serv=request.getParameter("serv"); 
	String testthr=request.getParameter("testthr");
	String backUrl = null;
	String updateParam = "";
	if (pg == null)
		backUrl="Javascript:call()";
	else
	{
		updateParam = "EgUDTest.jsp";
		backUrl="EgUDTest.jsp";
	}

	StringTokenizer st = null;
	StringTokenizer st1 = null;
	StringTokenizer st2 = null;
	String strIniVar[];
	String strIniVal = null;
	String measure = "";
	String policy = "";
	String min = "";
	String max = ""; 
	String minimum = "";
	String maximum = ""; 
	String priority = ""; 
	String alarmString = ""; 
	String alarmpolicy = "";
	String pol="";
	String prior = "";
	String temp = "";
	String wholeStr = "";
	String entry = "first";
	int count=0;
	Vector v_abs = new Vector();
	Vector v_temp = new Vector();
	String alarm_type="";

	String absA = "";
	String absB = "";
	String relA = "";
	String relB = "";
	String absoluteA = "";
	String absoluteB = "";
	String relativeA = "";
	String relativeB = "";
	String strTok = "";
	ArrayList tmpList = new ArrayList();
	String userLanguage = _user.getLanguage();
	String loginId = _user.getLoginID();

	IniUI  iniUI = IniUI.getInstance();
	if (userLanguage == null)
		userLanguage = iniUI.getDefaultLanguage();

	EgMappingInfo mappingInfo = new EgMappingInfo(userLanguage);
	MappingNameSorter sorter = new MappingNameSorter(userLanguage);

	String q_ctr=request.getParameter("qctr");

	final String subject2 = "GROUP_THRESHOLD_MAPPING";
	EgServerGroupBean descGrpp = new EgServerGroupBean();
	String Threshsubject = "THRESHOLDPOLICIES";

	String s_testName = "";
	String s_compType = "";
	String s_policyName = "";

//	List defaultPolicies=new ArrayList();
//	defaultPolicies.add("immediate");
//	defaultPolicies.add("shortterm");
//	defaultPolicies.add("standard");
//	defaultPolicies.add("longterm");

	// from EgSpecificThresh.jsp operation for find policyname
	String action=request.getParameter("actionFrom");
	String specsThreshPage=request.getParameter("specthreshpage");
	String strServer = request.getParameter("strServer");
	String component = request.getParameter("component");
	String strComeFrom = request.getParameter("comeFrom");
	String test = request.getParameter("test");
	String fromMon = null;
	String strDescName = null;
	String strTestState = null;
	String strLayerName = null;
	boolean isMonBack = false;

	if(!StringUtils.isNull(strComeFrom))
	{
		session.removeAttribute("fromMon");
		session.removeAttribute("strServer");
		session.removeAttribute("component");
		session.removeAttribute("testFromMon");
		session.removeAttribute("descName");
		session.removeAttribute("testState");
		session.removeAttribute("layerName");
		isMonBack = false;
	}

	if(StringUtils.isNull(strComeFrom))
	{
		fromMon = (String) session.getAttribute("fromMon");
		if(!StringUtils.isNull(fromMon) && fromMon.equalsIgnoreCase("yes"))
		{
			if(StringUtils.isNull(strServer))
			{
				strServer = (String) session.getAttribute("strServer");
			}
			if(StringUtils.isNull(component))
			{
				component = (String) session.getAttribute("component");
			}
			if(StringUtils.isNull(test))
			{
				test = (String) session.getAttribute("testFromMon");
				includePage = "listSearch.jsp?title=AGENT - THRESHOLDS&leftString=Add User&backButton=false&subtitle=false";
			}
			isMonBack = true;
			strDescName = (String) session.getAttribute("descName");
			strTestState = (String) session.getAttribute("testState");
			strLayerName = (String) session.getAttribute("layerName");
		}
	}

session.setAttribute("componentType",strServer);
session.setAttribute("componentName",component);
session.setAttribute("testName",test);

	action = (action!=null && action.length()>0 ? action:"");
	specsThreshPage = (specsThreshPage!=null && specsThreshPage.length()>0 ? specsThreshPage:"");
	fromMon = (fromMon!=null && fromMon.length()>0 ? fromMon:"");
	component = (component!=null && component.length()>0 ? component:"");
	test = (test!=null && test.length()>0 ? test:"");
	if((specsThreshPage != null && specsThreshPage.equalsIgnoreCase("yes")) || (!StringUtils.isNull(fromMon) && fromMon.equalsIgnoreCase("yes")))
	{
		boolean portRelevant_grpTest = egSpecs.isPortRelevantForTest(test);
		Vector serverGroup = descGrpp.getServerGroupUI(component,test,portRelevant_grpTest);
		String policyName = "";
		Vector _vec = new Vector();
		TreeSet set = null;
		if (serverGroup != null && serverGroup.size() > 0)
		{
			set = descGrpp.getManagedInfos((String)serverGroup.get(0),test);
		}
		if (set != null && set.size() > 0)
		{
			Iterator u = set.iterator();
			while (u.hasNext())
			{
				policyName = (String)u.next();
				_vec.add(policyName);
			}
		}
		
		s_policyName = policyName;

		//action value define
		String tmpTestName = descGrpp.getTestNameForPolicy(s_policyName);
		Vector tmpVec = descGrpp.getServerGroupForPolicy(s_policyName);

		if(tmpVec == null || tmpVec.size() == 0)
		{
			action = "modify";
		}
		else
		{
			Vector allCompWithType = new Vector();
			for(int j=0;j<tmpVec.size();j++)
			{
				String strGrpName = (String) tmpVec.get(j);
				Vector allComps = descGrpp.getComponentNames(strGrpName);
				String serverName = descGrpp.getServerType(strGrpName);
				if(allComps != null && allComps.size() > 0)
				{
					for(int ac= 0;ac<allComps.size();ac++)
					{
						String tmpComp = (String) allComps.get(ac);
						String strCompWithType = serverName+":"+tmpComp;
						if(!allCompWithType.contains(strCompWithType))
						{
							allCompWithType.add(strCompWithType);
						}
					}
				}
			}

			if(listManagedComponents.containsAll(allCompWithType))
			{
				action = "modify";
			}
			else
			{
				action = "view";
			}
		}
	}
	else
	{
		s_policyName = request.getParameter("policyName");
	}

	if(s_policyName != null && !s_policyName.equals(""))
	{
		s_testName = descGrpp.getTestNameForPolicy(s_policyName);
	}
	else
	{
		s_testName = request.getParameter("testName");
		s_policyName = "";
	}
	// Group name for process page
	session.setAttribute("PolicyName",s_policyName);
	String testName = s_testName;
	String serverName= "";//s_compType;
	session.setAttribute("server",serverName);

	String reqFrom = request.getParameter("from");
	String strpre="";
//	String action=request.getParameter("action");
//	action = (action!=null && action.length()>0 ? action:"");
	String[] arr_Threshgroup = {""};
	if(reqFrom != null && !reqFrom.equals(""))
	{
		Vector vec_pol = descGrpp.getAllPolicyName(Threshsubject);
		String[] arr_len = new String[vec_pol.size()];
		arr_Threshgroup = (String[]) vec_pol.toArray(arr_len);
	}
	if(action != null && action.equals("modify"))
	{
		entry="notFirst";
	}
%>

<html>
<head>
<title>Default Thresholds</title>
<!-- <link rel="stylesheet" href="eg_styles/eg_adminstyle.css" /> -->
<egui:skin ui = "admin"/>
<script language="JavaScript" src="eg_scripts/validate.js"></script>
<script language="JavaScript1.2" src="../scripts/<%=script_src%>"></script>
<script language="JavaScript">

function configureThresholds(measure,
		absMinCritical,absMinMajor,absMinMinor,
		relMinCritical,relMinMajor,relMinMinor,
		absMaxCritical,absMaxMajor,absMaxMinor,
		relMaxCritical,relMaxMajor,relMaxMinor,
		alarmPolicy)
{
	var thisForm = document.testconfig;
	var entryVal = thisForm.entry.value;
	if(entryVal != null && entryVal == "first")
	{
		var policyname = thisForm.ThresholdPolicy.value;
		var regExp = /[@#*&,~^!$()+%=:<>;?\"\'\]\|\}\/\[\{]/;
		var patCheck = regExp.test(policyname)||(policyname.indexOf('\\')>=0);
		var policyNames = new Array();
		if(policyname == '' || policyname == 'null')
		{
			alert('<egui:intnl text="admin.threshold.Please Enter Rule Name"/>');
			thisForm.ThresholdPolicy.focus();
			return;
		}
		if (policyname.indexOf(" ") > -1)
		{
			alert('<egui:intnl text="admin.threshold.Space not allowed."/>');
			thisForm.ThresholdPolicy.focus();
			return;
		}
		else if(patCheck)
		{
			alert('<egui:intnl text="admin.threshold.Special characters are not allowed."/>');
			thisForm.ThresholdPolicy.focus();
			return;
		}

		policyNames = <% out.print(getArrayString(arr_Threshgroup)); %>;//tttt
		if(policyNames != "")
		{
			for(var x=0;x<policyNames.length;x++)
			{
				if(policyNames[x] == policyname)
				{
					alert('<egui:intnl text="admin.threshold.Policy name already exist"/>');
					thisForm.ThresholdPolicy.focus();
					return;
				}
			}
		}
		thisForm.strPolicyName.value = policyname;
		createRuleName1();
	}
	thisForm.measure.value = measure;
	thisForm.absMinCritical.value = absMinCritical;
	thisForm.absMinMajor.value = absMinMajor;
	thisForm.absMinMinor.value = absMinMinor;
	thisForm.relMinCritical.value = relMinCritical;
	thisForm.relMinMajor.value = relMinMajor;
	thisForm.relMinMinor.value = relMinMinor;
	thisForm.absMaxCritical.value = absMaxCritical;
	thisForm.absMaxMajor.value = absMaxMajor;
	thisForm.absMaxMinor.value = absMaxMinor;
	thisForm.relMaxCritical.value = relMaxCritical;
	thisForm.relMaxMajor.value = relMaxMajor;
	thisForm.relMaxMinor.value = relMaxMinor;
	thisForm.alarmPolicy.value = alarmPolicy;
	thisForm.action = "EgConfigureGroupThresholds.jsp";
	thisForm.submit();
}

function check(fieldvalue)
{
	var dot_count = 0;
	s_val = fieldvalue;
	for(var i=0;i < s_val.length;i++)
	{
		if(s_val.charAt(i) == '.')
		{
			dot_count = dot_count + 1;
		}
		else
		{
			continue;
		}
	}
	if(dot_count > 1)
	{
		alert('<egui:intnl text="admin.threshold.Invalid number"/>.');
		return false;
	}
	if(s_val.charAt(s_val.length - 1) == '.')
	{
		alert('<egui:intnl text="admin.threshold.Invalid number"/>.');
		return false;
	}
	return true;
}

//validation for space
function checkspace(fieldvalue)
{
	s_val = fieldvalue;
	for(count = 0; count < s_val.length; count++)
	{
		if(s_val.charAt(count) == ' ')
		{
			alert('<egui:intnl text="admin.threshold.Space not allowed"/>.');
			return false;
		}
	}
	return true;
}

function isNetscape()
{
	// get browser info.
	appName= navigator.appName;
	appLongVer = navigator.appVersion;
	appVer = appLongVer.substring(0, 1);

	// check for Navigator ver 4+.
	if ((appName == "Netscape") && (appVer >= 4)) return true;
	return false;
}

function isIE()
{
	// get browser info.
	appName= navigator.appName;
	appLongVer = navigator.appVersion;
	appVer = appLongVer.substring(0, 1);

	// check for IE ver 4+. 
	if ((appName == "Microsoft Internet Explorer") && (appVer >= 4)) return true;
	return false;
}

function createRuleName()
{
	var thisForm = document.testconfig;
	var testName = thisForm.testName.options[thisForm.testName.selectedIndex].value;
	var policyname = thisForm.ThresholdPolicy.value;
	var regExp = /[@#*&,~^!$()+%=:<>;?\"\'\]\|\}\/\[\{]/;
	var patCheck = regExp.test(policyname)||(policyname.indexOf('\\')>=0);
	var policyNames = new Array();
	if(policyname == '' || policyname == 'null')
	{
		alert('<egui:intnl text="admin.threshold.Please Enter Rule Name"/>');
		thisForm.ThresholdPolicy.focus();
		return;
	}
	if (policyname.indexOf(" ") > -1)
	{
		alert('<egui:intnl text="admin.threshold.Space not allowed."/>');
		thisForm.ThresholdPolicy.focus();
		return;
	}
	else if(patCheck)
	{
		alert('<egui:intnl text="admin.threshold.Special characters are not allowed."/>');
		thisForm.ThresholdPolicy.focus();
		return;
	}

	policyNames = <% out.print(getArrayString(arr_Threshgroup)); %>;//tttt
	if(policyNames != "")
	{
		for(var x=0;x<policyNames.length;x++)
		{
			if(policyNames[x] == policyname)
			{
				alert('<egui:intnl text="admin.threshold.Policy name already exist"/>');
				thisForm.ThresholdPolicy.focus();
				return;
			}
		}
	}
	xmlhttp = null;
	if (window.XMLHttpRequest)
	{
		xmlhttp=new XMLHttpRequest();
	}
	else if (window.ActiveXObject)
	{
		xmlhttp=new ActiveXObject("Microsoft.XMLHTTP");
	}
	if (isNetscape()) targetObj = thisForm.update;
	if (isIE()) targetObj = thisForm.update;
	targetObj.disabled = true;
	thisForm.update.value ='<egui:intnl text="admin.common.Updating"/>...';

	if (xmlhttp != null)
	{
		var params = "testName="+testName+"&policyName="+policyname+"&operation=newRuleName";
		var url = "/final/admin/EgApplyGroupThresholds.jsp";
		xmlhttp.onreadystatechange = state_Change3;
		xmlhttp.open('POST',url,true);
		xmlhttp.setRequestHeader('Content-type','application/x-www-form-urlencoded');
		xmlhttp.setRequestHeader('Content-length',params.length);
		xmlhttp.setRequestHeader('Connection','close');
		xmlhttp.send(params);
	}
	else
	{
		alert('<egui:intnl text="admin.login.Your browser does not support XMLHTTP"/>');
	}
}

function createRuleName1()
{
	var thisForm = document.testconfig;
	var testName = thisForm.testName.options[thisForm.testName.selectedIndex].value;
	var policyname = thisForm.ThresholdPolicy.value;
	var regExp = /[@#*&,~^!$()+%=:<>;?\"\'\]\|\}\/\[\{]/;
	var patCheck = regExp.test(policyname)||(policyname.indexOf('\\')>=0);
	var policyNames = new Array();
	if(policyname == '' || policyname == 'null')
	{
		alert('<egui:intnl text="admin.threshold.Please Enter Rule Name"/>');
		thisForm.ThresholdPolicy.focus();
		return;
	}
	if (policyname.indexOf(" ") > -1)
	{
		alert('<egui:intnl text="admin.threshold.Space not allowed."/>');
		thisForm.ThresholdPolicy.focus();
		return;
	}
	else if(patCheck)
	{
		alert('<egui:intnl text="admin.threshold.Special characters are not allowed."/>');
		thisForm.ThresholdPolicy.focus();
		return;
	}

	policyNames = <% out.print(getArrayString(arr_Threshgroup)); %>;//tttt
	if(policyNames != "")
	{
		for(var x=0;x<policyNames.length;x++)
		{
			if(policyNames[x] == policyname)
			{
				alert('<egui:intnl text="admin.threshold.Policy name already exist"/>');
				thisForm.ThresholdPolicy.focus();
				return;
			}
		}
	}
	xmlhttp = null;
	if (window.XMLHttpRequest)
	{
		xmlhttp=new XMLHttpRequest();
	}
	else if (window.ActiveXObject)
	{
		xmlhttp=new ActiveXObject("Microsoft.XMLHTTP");
	}
	if (isNetscape()) targetObj = thisForm.update;
	if (isIE()) targetObj = thisForm.update;
	targetObj.disabled = true;

	if (xmlhttp != null)
	{
		var params = "testName="+testName+"&policyName="+policyname+"&operation=newRuleName";
		var url = "/final/admin/EgApplyGroupThresholds.jsp";
		//xmlhttp.onreadystatechange = state_Change2;
		xmlhttp.open('POST',url,true);
		xmlhttp.setRequestHeader('Content-type','application/x-www-form-urlencoded');
		xmlhttp.setRequestHeader('Content-length',params.length);
		xmlhttp.setRequestHeader('Connection','close');
		xmlhttp.send(params);
	}
	else
	{
		alert('<egui:intnl text="admin.login.Your browser does not support XMLHTTP"/>');
	}
}

function state_Change3()
{
	if (xmlhttp.readyState == 4)
	{
		try
		{
			if (xmlhttp.status == 200)
			{
				var thisForm = document.testconfig;
				var policyname = thisForm.ThresholdPolicy.value;
				//var url = "EgGroupThreshPolicies.jsp?policyName="+policyname+"&action=modify";
				var url = "/final/admin/EgShowThresholdPolicies.jsp?ServerType=null&serv=null&test=null";
				window.location.href = url;
			}
		}
		catch (error)
		{
			//error
		}
	}
}

//function state_Change2()
//{
//alert("called state_Change2 xmlhttp.readyState value is  : "+xmlhttp.readyState);
//
//	if (xmlhttp.readyState == 4)
//	{
//		try
//		{
//			if (xmlhttp.status == 200)
//			{
//				alert("called state_Change2 xmlhttp value is  : "+xmlhttp.status);
////				var thisForm = document.testconfig;
////				var policyname = thisForm.ThresholdPolicy.value;
////				//var url = "EgGroupThreshPolicies.jsp?policyName="+policyname+"&action=modify";
////				var url = "EgShowThresholdPolicies.jsp?ServerType=null&serv=null&test=null";
////				window.location.href = url;
//			}
//		}
//		catch (error)
//		{
//			//error
//		}
//	}
//}

function populateNEW()
{
	var thisForm = document.testconfig;
	var policyname = thisForm.ThresholdPolicy.value;
	var regExp = /[@#*&,~^!$()+%=:<>;?\"\'\]\|\}\/\[\{]/;
	var patCheck = regExp.test(policyname)||(policyname.indexOf('\\')>=0);
	var policyNames = new Array();
	if(policyname == '' || policyname == 'null')
	{
		alert('<egui:intnl text="admin.threshold.Please Enter Rule Name"/>');
		thisForm.ThresholdPolicy.focus();
		return;
	}
	if (policyname.indexOf(" ") > -1)
	{
		alert('<egui:intnl text="admin.threshold.Space not allowed."/>');
		thisForm.ThresholdPolicy.focus();
		return;
	}
	else if(patCheck)
	{
		alert('<egui:intnl text="admin.threshold.Special characters are not allowed."/>');
		thisForm.ThresholdPolicy.focus();
		return;
	}

	policyNames = <% out.print(getArrayString(arr_Threshgroup)); %>;//tttt
	if(policyNames != "")
	{
		for(var x=0;x<policyNames.length;x++)
		{
			if(policyNames[x] == policyname)
			{
				alert('<egui:intnl text="admin.threshold.Policy name already exist"/>');
				thisForm.ThresholdPolicy.focus();
				return;
			}
		}
	}

	var res = true;
	var num = document.testconfig.measNum.value;

	for(var i=0; i < num; i++)
	{
		var absA = "absA"+i;
		var absB = "absB"+i;
		var relA = "relA"+i;
		var relB = "relB"+i;

		var absoluteA = document.testconfig[absA].value;
		var absoluteB = document.testconfig[absB].value;
		var relativeA = document.testconfig[relA].value;
		var relativeB = document.testconfig[relB].value;

		// Negative value check
		var description = document.getElementById("ANV"+i).value;
		var arr = description.split(":");
		var measurement = arr[0];
		var isNegativeValuesAllowed = arr[1];

		// Absolute minimum - start
		if(!checkWithRegExp(absoluteA,0))
		{
			alert('<egui:intnl text="admin.threshold.Invalid threshold entry"/>'+".\n"+'<egui:intnl text="admin.threshold.Possible reasons could be"/>'+" : \n"+
			"1) "+'<egui:intnl text="admin.threshold.Threshold values are not set for one/more measures"/>'+".\n"+
			"2) "+"<egui:intnl text='admin.threshold.Threshold specifications are not in the \'Critical/Major/Minor\' format'/>"+".\n"+
			"3) "+'<egui:intnl text="admin.threshold.One/more threshold entries contain special characters"/>'+".");
			document.testconfig[absA].focus();
			res=false;
			break;
		}

		// Negative value check
		if(isNegativeValuesAllowed == "false")
		{
			if(absoluteA.toLowerCase() != "none" && checkNegativeVal(absoluteA))
			{
				alert("<egui:intnl text='admin.threshold.Absolute minimum'/> <egui:intnl text='admin.threshold.for'/>"+" \'"+measurement+"\' "+"<egui:intnl text='admin.threshold.should not contain negative values'/>.");
				document.testconfig[absA].focus();
				res=false;
				break;
			}
		}

		//check ascending order
		if(absoluteA.toLowerCase() != "none" && !checkAscendingOrder(absoluteA,0))
		{
			alert('<egui:intnl text="admin.threshold.Absolute Minimum threshold values representing Critical/Major/Minor should be in ascending order"/>');
			document.testconfig[absA].focus();
			res=false;
			break;
		}
		// end

		//Relative minimum - start
		if(!checkWithRegExp(relativeA,1))
		{
			alert('<egui:intnl text="admin.threshold.Invalid threshold entry"/>'+".\n"+'<egui:intnl text="admin.threshold.Possible reasons could be"/>'+" : \n"+
			"1) "+'<egui:intnl text="admin.threshold.Threshold values are not set for one/more measures"/>'+".\n"+
			"2) "+"<egui:intnl text='admin.threshold.Threshold specifications are not in the \'Critical/Major/Minor\' format'/>"+".\n"+
			"3) "+'<egui:intnl text="admin.threshold.One/more threshold entries contain special characters"/>'+".\n"+
			"4) "+"<egui:intnl text='admin.threshold.Relative threshold specifications are not in \'n1*sqc/n2*sqc/n3*sqc\' format where n1<n2<n3'/>"+".");
			document.testconfig[relA].focus();
			res=false;
			break;
		}

		// Negative value check
		if(isNegativeValuesAllowed == "false")
		{
			if(relativeA.toLowerCase() != "none" && checkNegativeVal(relativeA))
			{
				alert("<egui:intnl text='admin.threshold.Relative minimum'/> <egui:intnl text='admin.threshold.for'/>"+" \'"+measurement+"\' "+"<egui:intnl text='admin.threshold.should not contain negative values'/>.");
				document.testconfig[relA].focus();
				res=false;
				break;
			}
		}

		//check ascending order
		if(relativeA.toLowerCase() != "none" && !checkAscendingOrder(relativeA,1))
		{
			alert('<egui:intnl text="admin.threshold.Relative Minimum threshold values representing Critical/Major/Minor should be in ascending order"/>');
			document.testconfig[relA].focus();
			res=false;
			break;
		}
		//end

		//Absolute maximum -start
		if(!checkWithRegExp(absoluteB,0))
		{
			alert('<egui:intnl text="admin.threshold.Invalid threshold entry"/>'+".\n"+'<egui:intnl text="admin.threshold.Possible reasons could be"/>'+" : \n"+
			"1) "+'<egui:intnl text="admin.threshold.Threshold values are not set for one/more measures"/>'+".\n"+
			"2) "+"<egui:intnl text='admin.threshold.Threshold specifications are not in the \'Critical/Major/Minor\' format'/>"+".\n"+
			"3) "+'<egui:intnl text="admin.threshold.One/more threshold entries contain special characters"/>'+".");
			document.testconfig[absB].focus();
			res=false;
			break;
		}

		// Negative value check
		if(isNegativeValuesAllowed == "false")
		{
			if(absoluteB.toLowerCase() != "none" && checkNegativeVal(absoluteB))
			{
				alert("<egui:intnl text='admin.threshold.Absolute maximum'/> <egui:intnl text='admin.threshold.for'/>"+" \'"+measurement+"\' "+"<egui:intnl text='admin.threshold.should not contain negative values'/>.");
				document.testconfig[absB].focus();
				res=false;
				break;
			}
		}

		//check descending order
		if(absoluteB.toLowerCase() != "none" && !checkDescendingOrder(absoluteB,0))
		{
			alert('<egui:intnl text="admin.threshold.Absolute Maximum threshold values representing Critical/Major/Minor should be in descending order"/>');
			document.testconfig[absB].focus();
			res=false;
			break;
		}
		//end

		//Relative maximum - start
		if(!checkWithRegExp(relativeB,1))
		{
			alert('<egui:intnl text="admin.threshold.Invalid threshold entry"/>'+".\n"+'<egui:intnl text="admin.threshold.Possible reasons could be"/>'+" : \n"+
			"1) "+'<egui:intnl text="admin.threshold.Threshold values are not set for one/more measures"/>'+".\n"+
			"2) "+"<egui:intnl text='admin.threshold.Threshold specifications are not in the \'Critical/Major/Minor\' format'/>"+".\n"+
			"3) "+'<egui:intnl text="admin.threshold.One/more threshold entries contain special characters"/>'+".\n"+
			"4) "+"<egui:intnl text='admin.threshold.Relative threshold specifications are not in \'n1*sqc/n2*sqc/n3*sqc\' format where n1>n2>n3'/>"+".");
			document.testconfig[relB].focus();
			res=false;
			break;
		}

		// Negative value check
		if(isNegativeValuesAllowed == "false")
		{
			if(relativeB.toLowerCase() != "none" && checkNegativeVal(relativeB))
			{
				alert("<egui:intnl text='admin.threshold.Relative maximum'/> <egui:intnl text='admin.threshold.for'/>"+" \'"+measurement+"\' "+"<egui:intnl text='admin.threshold.should not contain negative values'/>.");
				document.testconfig[relB].focus();
				res=false;
				break;
			}
		}

		//check descending order
		if(relativeB.toLowerCase() != "none" && !checkDescendingOrder(relativeB,1))
		{
			alert('<egui:intnl text="admin.threshold.Relative Maximum threshold values representing Critical/Major/Minor should be in descending order"/>');
			document.testconfig[relB].focus();
			res=false;
			break;
		}
		//end
	}

	if(res)
	{
		//if (isNetscape()) targetObj = document.testconfig.update;
		//if (isIE()) targetObj = document.testconfig.update;
		//targetObj.disabled = true;
		alert("<egui:intnl text='admin.threshold.This operation might take some time,please wait'/>....");
		document.testconfig.submit();
	}
}

function checkWithRegExp(val,c)
{
	var regExp;
	if(c==0)
	{
		regExp = /^(none)$|^(\-|\-?(([0-9]+\.|\.)?[0-9]+))\/(\-|\-?(([0-9]+\.|\.)?[0-9]+))\/(\-|\-?(([0-9]+\.|\.)?[0-9]+))$/i;
	}
	else
	{
		regExp = /^(none)$|^(\-|\-?(([0-9]+\.|\.)?[0-9]+\*)?sqc)\/(\-|\-?(([0-9]+\.|\.)?[0-9]+\*)?sqc)\/(\-|\-?(([0-9]+\.|\.)?[0-9]+\*)?sqc)$/i;
	}
	var ret = regExp.test(val);
	return ret;
}

function checkNegativeVal(val,c)
{
	var arr = val.split("/");
	var Cri,Maj,Min;
	Cri = arr[0];
	Maj = arr[1];
	Min = arr[2];

	if (Cri == "-")
	{
		Cri = "0";
	}

	if (Maj == "-")
	{
		Maj = "0";
	}

	if (Min == "-")
	{
		Min = "0";
	}

	var regExp = /^\-([0-9]+\.|\.)?[0-9]+/;
	var ret = regExp.test(Cri);
	if(!ret)
	{
		ret = regExp.test(Maj);
	}
	if(!ret)
	{
		ret = regExp.test(Min);
	}
	return ret;
}

function checkAscendingOrder(val,c)
{
	var arr = val.split("/");
	var Cri,Maj,Min;
	Cri = arr[0];
	Maj = arr[1];
	Min = arr[2];
	if (c==1)
	{
		Cri = Cri.replace(/(\*sqc)/gi,"");
		Cri = Cri.replace(/sqc/g,"1");
		Maj = Maj.replace(/(\*sqc)/gi,"");
		Maj = Maj.replace(/sqc/g,"1");
		Min = Min.replace(/(\*sqc)/gi,"");
		Min = Min.replace(/sqc/g,"1");
	}

	var ret = true;
	if (Cri != "-" && Maj != "-")
	{
		if (parseFloat(Cri) >= parseFloat(Maj))
		{
			ret = false;
		}
	}
	if (Maj != "-" && Min != "-")
	{
		if (parseFloat(Maj) >= parseFloat(Min))
		{
			ret = false;
		}
	}
	if (Cri != "-" && Min != "-")
	{
		if (parseFloat(Cri) >= parseFloat(Min))
		{
			ret = false;
		}
	}
	return ret;
}

function checkDescendingOrder(val,c)
{
	var arr = val.split("/");
	var Cri,Maj,Min;
	Cri = arr[0];
	Maj = arr[1];
	Min = arr[2];
	if (c==1)
	{
		Cri = Cri.replace(/(\*sqc)/gi,"");
		Cri = Cri.replace(/sqc/g,"1");
		Maj = Maj.replace(/(\*sqc)/gi,"");
		Maj = Maj.replace(/sqc/g,"1");
		Min = Min.replace(/(\*sqc)/gi,"");
		Min = Min.replace(/sqc/g,"1");
	}

	var ret = true;
	if (Cri != "-" && Maj != "-")
	{
		if (parseFloat(Cri) <= parseFloat(Maj))
		{
			ret = false;
		}
	}
	if (Maj != "-" && Min != "-")
	{
		if (parseFloat(Maj) <= parseFloat(Min))
		{
			ret = false;
		}
	}
	if (Cri != "-" && Min != "-")
	{
		if (parseFloat(Cri) <= parseFloat(Min))
		{
			ret = false;
		}
	}
	return ret;
}



function trim(s)
{
	if(s != null)
	{
		while (s.substring(0,1) == ' ') 
		{
			s = s.substring(1,s.length);
		}
		while (s.substring(s.length-1,s.length) == ' ') 
		{
			s = s.substring(0,s.length-1);
		}
	}
	return s;
}

function isNegative(val1,val2,val3)
{
	if ((val1 >= 0 || val1 == '-1' || val1 == '-') &&
		(val2 >= 0 || val2 == '-1' || val2 == '-') &&
		(val3 >= 0 || val3 == '-1' || val3 == '-'))
	{
		return false;
	}
	else
	{
		return true;
	}
}

function isValidSqcFactor(value,isNegative)
{
	var tokens = value.split("*");
	if (tokens.length == 2)
	{
		if (!isNegative)
		{
			if ((isNumber("+", tokens[0]) && tokens[1] == 'sqc'))
			{
				return true;
			}
		}else
		{
			if ((isNumber("+", tokens[0]) && tokens[1] == 'sqc')||(isNumber("-", tokens[0]) && tokens[1] == 'sqc'))
			{
				return true;
			}
		}

	}
	else if (tokens.length == 1 && (tokens[0] == 'sqc' || tokens[0] == "-"))
	{
		return true;
	}

	return false;
}

function call()
{
	window.location.href ="EgTestList.jsp?&server=" + "<%= request.getParameter("server")%>" + "&qctr=1";
}

function popTestName()
{
	var thisForm = document.testconfig;
	var compT = thisForm.componentType.options[thisForm.componentType.selectedIndex].value;
	if(compT != "-1")
	{
		window.location.href = "EgGroupThreshPolicies.jsp?from=addPolicy&compType="+compT+"&testName=Groups&comeFrom=admin";
	}
	else
	{
		window.location.href = "EgGroupThreshPolicies.jsp?from=addPolicy&compType=Groups&testName=Groups&comeFrom=admin";
	}
}

function popThreshold()
{
	var thisForm = document.testconfig;
	var compT = thisForm.componentType.options[thisForm.componentType.selectedIndex].value;
	var testN = thisForm.testName.options[thisForm.testName.selectedIndex].value;
	if(testN != "-1" )
	{
		window.location.href = "EgGroupThreshPolicies.jsp?from=addPolicy&compType="+compT+"&testName="+testN+"&comeFrom=admin";
	}
	else
	{
		window.location.href = "EgGroupThreshPolicies.jsp?from=addPolicy&compType="+compT+"&testName=Groups&comeFrom=admin";
	}
}

function gotoMonitor()
{
	window.parent.location.href = '/final/egIndex.jsp?entry=monitor&displayTab=all&newwindow=&uname=<%=loginId%>';
}

</script>
</head>
<body style="overflow:auto" id="space6" > 
<form name="testconfig" method="get" style="margin:0px">
<input type = "hidden" name="updateparam" value="<%= updateParam %>">
<input type="hidden" name="serv" value="<%=serv%>">
<input type="hidden" name="server" value="<%=server%>">
<input type="hidden" name="actionFrom" value="<%=action%>">
<input type="hidden" name="reqFrom" value="<%=reqFrom%>">
<input type="hidden" name="measure" value="">
<input type="hidden" name="absMinCritical" value="">
<input type="hidden" name="absMinMajor" value="">
<input type="hidden" name="absMinMinor" value="">
<input type="hidden" name="relMinCritical" value="">
<input type="hidden" name="relMinMajor" value="">
<input type="hidden" name="relMinMinor" value="">
<input type="hidden" name="absMaxCritical" value="">
<input type="hidden" name="absMaxMajor" value="">
<input type="hidden" name="absMaxMinor" value="">
<input type="hidden" name="relMaxCritical" value="">
<input type="hidden" name="relMaxMajor" value="">
<input type="hidden" name="relMaxMinor" value="">
<input type="hidden" name="alarmPolicy" value="">
<input type="hidden" name="entry" value="<%=entry%>">
<input type="hidden" name="strPolicyName" value="<%=s_policyName%>">
<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0">
	<jsp:include page="<%=includePage%>"/>
<%
	String reqCompType = request.getParameter("compType");
	String reqTest = request.getParameter("testName");
	reqTest = (reqTest != null && !reqTest.equals("null") && reqTest.length()>0 ? reqTest:"");
	reqCompType = (reqCompType != null && !reqCompType.equals("null") && reqCompType.length()>0 ? reqCompType:"");
	String[] compTypesArray = egRoleInfo.getServerTypes(); //get the comp types for the specified User

	if(compTypesArray.length > 0)
	{
		if(StringUtils.isNull(action) && (!action.equalsIgnoreCase("modify") && !action.equalsIgnoreCase("view")))
		{
%>
	<tr>
		<td width="100%" id="eg_whitebg" align="center" height="100%" valign="top">
			<table align="center" cellspacing="0" cellpadding="0" width="90%" border="0">
				<tr>
					<td height="6" id="inner_top_left" width="7" class="eg_subcontentbg eg_blankspace"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
					<td height="6" id="eg_subcontentbg" class="eg_blankspace" width="100%" colspan="6"><img src="/final/admin/eg_images/spacer.gif" height="6"></td>
					<td height="6" id="inner_top_right" width="7" class="eg_subcontentbg eg_blankspace"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
				</tr>
<%
			ArrayList compTypes = new ArrayList();
			ArrayList testForServer = new ArrayList();
			ArrayList globalThresholds = testerInfo.getGlobalThresholds(); // get the global threshold tests 
			for(int i=0;i<compTypesArray.length;i++)
			{
				String tempTestList[] = egSpecs.getTestsForServer(compTypesArray[i]);
				if(tempTestList != null && tempTestList.length > 0)
				{
					ArrayList tests = new ArrayList(Arrays.asList(tempTestList));
					if(!globalThresholds.containsAll(tests) && !compTypes.contains(compTypesArray[i])) 
					{
						//remove the global threshold tests from the "tests" List 
						compTypes.add(compTypesArray[i]);
						if(reqCompType.equalsIgnoreCase(compTypesArray[i]))
						{
							testForServer = tests;
							testForServer.removeAll(globalThresholds);
						}
					}
				}
			}
			ArrayList configTests = egSpecs.getConfigTestsForServer(reqCompType);
			if(configTests != null)
				testForServer.removeAll(configTests);
%>
				<tr>
					<td class="eg_subcontentbg" id="form_spacing">&nbsp; </td> 
					<td align="left" width="130" class="eg_subcontentbg" nowrap height="20" id="form_spacing">&nbsp;<egui:intnl text="admin.groups.Component type"/></td>
					<td width="5" class="eg_subcontentbg" id="form_spacing">:</td>
					<td class="eg_subcontentbg" id="form_spacing"> &nbsp;&nbsp;&nbsp;&nbsp; 
						<select name="componentType" onChange="javascript:popTestName()">
<%
			if(compTypes.size()>0)
			{
%>
						<option value="-1"><egui:intnl text="admin.common.Choose a server type"/></option>
<%
			}
			tmpList = sorter.getSortedCompTypeList(compTypes);

			for(int i=0;i<tmpList.size();i++)
			{
				EgName nameObj = (EgName)tmpList.get(i);
				String tmpVal = nameObj.getActualName();
				String tmpDis = nameObj.getLocalName();
%>
						<option name='<%=tmpVal%>' value='<%=tmpVal%>' <%=tmpVal.equalsIgnoreCase(reqCompType)?"selected":""%>><%=tmpDis%></option>
<%
			}
%>
						</select>
					</td>
					<td align="right" class="eg_subcontentbg" nowrap height="20" id="form_spacing" width="130">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<egui:intnl text="admin.groups.Test name"/></td>
					<td class="eg_subcontentbg" id="form_spacing">:</td>
					<td class="eg_subcontentbg" id="form_spacing">&nbsp;&nbsp;&nbsp;&nbsp;
						<select name="testName" style='width:190px;' onChange="javascript:popThreshold()">
<%
			if(reqCompType.equalsIgnoreCase("Groups"))
			{
%>
						<option name="choose" value="-1">
							<egui:intnl text="admin.groups.Not Applicable"/>
						</option>
<%
			}
			else if(testForServer != null && testForServer.size()>0)
			{
%>
						<option name="choose" value="-1">
							<egui:intnl text="admin.groups.Choose a test  name"/>
						</option>
<%
				tmpList = sorter.getSortedTestList(testForServer);	
				for(int i=0;i<tmpList.size();i++)
				{
					EgName nameObj = (EgName)tmpList.get(i);
					String tmpVal = nameObj.getActualName();
					String tmpDis = nameObj.getLocalName();
					if(EgInstallInfo.isConfigTest(tmpVal))
					{
						continue;
					}
%>
						<option name='<%=tmpVal%>' value='<%=tmpVal%>' <%=tmpVal.equalsIgnoreCase(reqTest)?"selected":""%>><%=tmpDis%></option>
<%
				}
			}
			else if(testForServer != null && testForServer.size() == 0)
			{
%>
						<option name="choose" value="-1">
							<egui:intnl text="admin.groups.Not Applicable"/>
						</option>
<%
			}
%>
						</select>
					</td>
					<td class="eg_subcontentbg" id="form_spacing">&nbsp;</td>
				</tr>
				<tr>
					<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg eg_blankspace"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
					<td id="eg_subcontentbg" class="eg_blankspace" width="100%" colspan="6" valign="top" ><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
					<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg eg_blankspace"> <img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
				</tr>
<%
			if((!StringUtils.isNull(reqCompType) && !reqCompType.equals("Groups")) && (!StringUtils.isNull(reqTest) && !reqTest.equals("Groups")))
			{
%>
				<tr>
					<td height="10" id="eg_blankspace">&nbsp;</td>
				</tr>
				<tr>
					<td id="eg_whitebg" align="center" valign="top" colspan="8">
						<table align="center" cellspacing="0" cellpadding="0" width="85%" border="0">
							<tr>
								<td align="right" nowrap width="300px"><strong><egui:intnl text="admin.threshold.Rule Name"/></strong>&nbsp;:&nbsp;</td>
								<td align="left" width="250px"><input type="text" maxlength = "32" name="ThresholdPolicy" value="" size="8" style="width:230px"></td>
								<td align="left" width="300px"><input type="button" name="update" value='<egui:intnl text="admin.threshold.Update"/>' class="eg_back" onClick="javascript:createRuleName()"></td>
							</tr>
						</table>
					</td>
				</tr>
<%
			}
%>
				<tr>
					<td height="10" id="eg_blankspace">&nbsp;</td>
				</tr>
			</table>
		</td>
	</tr>
<%
		}

		/* threshold values for the selected test */
		if(!reqCompType.equalsIgnoreCase("Groups") && !reqTest.equalsIgnoreCase("Groups"))
		{
			//serverName = reqCompType;
			String[] alarmPolicies= egThresh.getAllAlarmPolicies();
			strIniVar = egThresh.getDefaultThresholds();
			boolean multiThresh = false;
			for(int i=0; i<strIniVar.length; i++)
			{
				if(strIniVar[i].startsWith(";"))
				{
					continue;
				}
				if(strIniVar[i].equals(testName))
				{
					Vector vec = descGrpp.getAllPolicyName(Threshsubject);
					if(vec != null && vec.size() > 0 && vec.contains(s_policyName))
					{
						strIniVal = descGrpp.getPolicyValue(s_policyName);
					}
					else
					{
						strIniVal = egThresh.getDefaultThresholdValue(strIniVar[i]);
					}
				}
			}
%>

<%
	if(isMonBack)
	{
%>
	<tr>
		<td align="center" valign="middle" width="100%">
			<table width="90%" border="0" align="center">
				<tbody>
					<tr>
						<td nowrap="" height="10" align="right">
						<a href="javascript:void(0);" class="eg_monlink" onclick="javascript:gotoMonitor();">
						<b>Click here</b>&nbsp;<img border="0" src="/final/admin/eg_images/icon_click.gif">
						</a>to go to the layer model</td>
					</tr>
				</tbody>
			</table>
		</td>
	</tr>
<%
	String qryTestVal = null;
	if(!StringUtils.isNull(strDescName) && !strDescName.equals("NONE"))
	{
		qryTestVal = test+"- "+strDescName;
	}
	else
	{
		qryTestVal = test+"- ";
	}

	String monURL = "/final/servlet/com.eg.EgDashboardController?from=list&comptype="+EgURLEncoder.encode(strServer,"UTF-8")+"&host="+EgURLEncoder.encode(component,"UTF-8")+"&tab=LayerModel&comesFrom=LayerModel&site=NULL&host="+EgURLEncoder.encode(component,"UTF-8")+"&layer="+strLayerName+"&qctr=2&comptype="+EgURLEncoder.encode(strServer,"UTF-8")+"&fromalarm=null&msmt_host=&test="+EgURLEncoder.encode(qryTestVal,"UTF-8")+"&tstate="+strTestState+"&checkedAll=true&showDashBoardLink=true";
	session.setAttribute("monitorLastSession",monURL);
	session.setAttribute("fromAdmin","Yes");
	}
%>

	<tr>
		<td width="100%" id="eg_whitebg" align="center" height="100%" valign="top">
			<table align="center" width="90%" cellspacing="0" cellpadding="0" border="0">
				<tr>
<%
						if(pg != null)
						{
%>
					<td align="left" class="table_head"  width="100%" style="padding:4px"><b> <egui:intnl text="admin.threshold.Test Name"/>&nbsp;&nbsp;:&nbsp;<egui:intnl test="<%=s_testName%>"/>
<%
						}
						else
						{
							if(s_policyName != null && !s_policyName.equals(""))
							{
%>
					<td align="left" class="table_head"  width="50%" style="padding:4px"><b> <egui:intnl text="admin.threshold.Test Name"/>&nbsp;&nbsp;:&nbsp;<egui:intnl test="<%=s_testName%>"/>
<%
							}
							else
							{
%>
					<td align="left" class="table_head"  width="100%" style="padding:4px"><b> <egui:intnl text="admin.threshold.Test Name"/>&nbsp;&nbsp;:&nbsp;<egui:intnl test="<%=s_testName%>"/>
<%
							}
						}
%>
					</b></td>
<%
						if(s_policyName.length() > 0)
						{
%>
					<td align="right" class="table_head"  width="50%" style="padding:4px"><b> <egui:intnl text="admin.threshold.Rule Name"/>&nbsp;&nbsp;:&nbsp;<%=s_policyName%></b></td>
<%
						}
						else
						{
%>
												<!-- <td id="eg_subheadbg" style="border-left-width: 0px; border-right-width: 0px;" align="right" width="30%"><strong><egui:intnl text="admin.threshold.Rule Name"/>&nbsp;&nbsp;<input type="text" maxlength = "32" name="ThresholdPolicy" value="" size="8" style="width:130px"></td> -->
<%
						}
%>
				</tr>
			</table>
		</td>
	</tr>
	<tr>
		<td align="center">
			<table border="0" width="90%" cellpadding="0" cellspacing="0" class="linesquare">
				<tr>
					<td><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="15"></td>
				</tr>
				<tr>
					<td align="center">
						<table border="0" width="98%" cellpadding="0" cellspacing="0">
<%
	if (!StringUtils.isNull(action) && action.equalsIgnoreCase("view"))
	{
%>
							<tr>
								<td>
									<table align="center" width="100%" cellspacing="0" cellpadding="0" border="0"><col width="auto"><col width="65%"><col width="15%">
<%
		boolean heading_flag = false;
		ArrayList aListTestWithNoThresholds = new ArrayList();
		boolean cellFlag = false;
		boolean isTestWithThresholds = false;
		st = new StringTokenizer(strIniVal,",");
		while (st.hasMoreTokens())
		{
			strTok = st.nextToken();
			st1 = new StringTokenizer(strTok,":");
			while (st1.hasMoreTokens())
			{
				measure = st1.nextToken();
				policy = st1.nextToken();
				min = st1.nextToken();
				max = st1.nextToken();
				String alarmPolicy = st1.nextToken();
				String lastToken = st1.nextToken();

				String absMinCritical = "-";
				String relMinCritical = "-";

				String absMinMajor = "-";
				String relMinMajor = "-";

				String absMinMinor = "-";
				String relMinMinor = "-";

				String absMaxCritical = "-";
				String relMaxCritical = "-";

				String absMaxMajor = "-";
				String relMaxMajor = "-";

				String absMaxMinor = "-";
				String relMaxMinor = "-";

				if (policy.equalsIgnoreCase("none"))
				{
					policy = "mix";
				}
				else if (policy.equalsIgnoreCase("absolute"))
				{
					if (!min.equals("-1"))
					{
						StringTokenizer stAbsMin = new StringTokenizer(min,"/");
						absMinCritical = stAbsMin.nextToken();
						absMinMajor = stAbsMin.nextToken();
						absMinMinor = stAbsMin.nextToken();
					}

					if (!max.equals("-1"))
					{
						StringTokenizer stAbsMax = new StringTokenizer(max,"/");
						absMaxCritical = stAbsMax.nextToken();
						absMaxMajor = stAbsMax.nextToken();
						absMaxMinor = stAbsMax.nextToken();
					}
				}
				else if (policy.equalsIgnoreCase("relative"))
				{
					if (!min.equals("-1"))
					{
						StringTokenizer stRelMin = new StringTokenizer(min,"/");
						relMinCritical = stRelMin.nextToken();
						relMinMajor = stRelMin.nextToken();
						relMinMinor = stRelMin.nextToken();
					}

					if (!max.equals("-1"))
					{
						StringTokenizer stRelMax = new StringTokenizer(max,"/");
						relMaxCritical = stRelMax.nextToken();
						relMaxMajor = stRelMax.nextToken();
						relMaxMinor = stRelMax.nextToken();
					}
				}
				else if (policy.equalsIgnoreCase("mix"))
				{
					Vector vec = getAbsAndRel(min);
					absA = (String) vec.get(0);
					relA = (String) vec.get(1);
					Vector vec1 = getAbsAndRel(max);
					absB = (String) vec1.get(0);
					relB = (String) vec1.get(1);

					if (!absA.equals("none"))
					{
						StringTokenizer stmixMin = new StringTokenizer(absA,"/");
						absMinCritical = stmixMin.nextToken();
						absMinMajor = stmixMin.nextToken();
						absMinMinor = stmixMin.nextToken();
					}

					if (!absB.equals("none"))
					{
						StringTokenizer stmixMax = new StringTokenizer(absB,"/");
						absMaxCritical = stmixMax.nextToken();
						absMaxMajor = stmixMax.nextToken();
						absMaxMinor = stmixMax.nextToken();
					}

					if (!relA.equals("none"))
					{
						StringTokenizer stRelMin = new StringTokenizer(relA,"/");
						relMinCritical = stRelMin.nextToken();
						relMinMajor = stRelMin.nextToken();
						relMinMinor = stRelMin.nextToken();
					}

					if (!relB.equals("none"))
					{
						StringTokenizer stmixMax = new StringTokenizer(relB,"/");
						relMaxCritical = stmixMax.nextToken();
						relMaxMajor = stmixMax.nextToken();
						relMaxMinor = stmixMax.nextToken();
					}
				}

				String minCritical = getThresholdValue("min",absMinCritical,relMinCritical);
				String minMajor = getThresholdValue("min",absMinMajor,relMinMajor);
				String minMinor = getThresholdValue("min",absMinMinor,relMinMinor);

				String maxCritical = getThresholdValue("max",absMaxCritical,relMaxCritical);
				String maxMajor = getThresholdValue("max",absMaxMajor,relMaxMajor);
				String maxMinor = getThresholdValue("max",absMaxMinor,relMaxMinor);

				if (minCritical.equals("-")  && minMajor.equals("-") && minMinor.equals("-") && 
				maxCritical.equals("-") && maxMajor.equals("-") && maxMinor.equals("-"))
				{
					aListTestWithNoThresholds.add(measure);
					cellFlag = !cellFlag;
					continue;
				}
				else
				{
					isTestWithThresholds = true;
				}

				if (!heading_flag)
				{
					heading_flag = true;
%>
								<!-- Heading -->
										<tr>
											<td align="center" class="lineright padding4 table_head">Measure</td>
											<td align="center" style="padding:0px">
												<table cellpadding="0" cellspacing="0" border="0" width="100%"><col width="19%"><col width="27%"><col width="27%"><col width="27%">
													<tr>
														<td align="center" class="lineright padding4 table_head">Min/Max</td>
														<td align="center" class="lineright padding4 table_head">Critical</td>
														<td align="center" class="lineright padding4 table_head">Major</td>
														<td align="center" class="lineright padding4 table_head">Minor</td>
													</tr>
												</table>
											</td>
											<td class="padding4 table_head" align="center">Alarm Policy</td>
										</tr>
<%
				}
				String unit = tablesInfo.getUnitForMeasure(s_testName,measure);

%>
										<tr>
											<td align="left" valign="middle" id="<%=cellFlag?"cell_border3":"cell_border4"%>" class="padding4" style="border-left-width:1px">
												<table cellpadding="0" cellspacing="0" border="0" width="100%">
													<tr>
														<td width="5%" valign="center" valign="middle"></td>
														<td width="95%" valign="middle" nowrap>
															<%=mappingInfo.getMeasureDescription(s_testName,measure)%></td>
														<td class="eg_7">&nbsp;<i>(<%=unit%>)</i>&nbsp;</td>
													</tr>
												</table>
											</td>
											<td align="left" valign="top" id="<%=cellFlag?"cell_border3":"cell_border4"%>" class="padding4" >
												<table cellpadding="0" cellspacing="0" border="0" width="100%" class="tableborder_ad"><col width="19%"><col width="27%"><col width="27%"><col width="27%" >
<%
				if(!minCritical.equals("-") || !minMajor.equals("-") || !minMinor.equals("-"))
				{
%>
													<tr class="linebottom">
														<td align="center" class="padding4 tdborder_ad"><b>Min</b></td>
														<td align="center" class="padding4 tdborder_ad" name="absMin"><%=minCritical%></td>
														<td align="center" class="padding4 tdborder_ad"><%=minMajor%></td>
														<td align="center" class="padding4 tdborder_ad"><%=minMinor%></td>
													</tr>
<%
				}

				if(!maxCritical.equals("-") || !maxMajor.equals("-") || !maxMinor.equals("-"))
				{
%>
													<tr>
														<td align="center" class="padding4 tdborder_ad"><b>Max</b></td>
														<td align="center" class="padding4 tdborder_ad" name="absMin"><%=maxCritical%></td>
														<td align="center" class="padding4 tdborder_ad"><%=maxMajor%></td>
														<td align="center" class="padding4 tdborder_ad"><%=maxMinor%></td>
													</tr>
<%
				}
%>
												</table>
											</td>
											<td id="<%=cellFlag?"cell_border3":"cell_border4"%>" class="padding4" align="left" valign="middle" title="<%=alarmPolicy%>"><egui:display name="<%=alarmPolicy%>" length="<%=Integer.toString(alarmPolicyLength)%>"/></td>
										</tr>
<%
			}

			cellFlag = !cellFlag;
		}
%>
									</table>
								</td>
							</tr>
<%
		if (aListTestWithNoThresholds != null && !aListTestWithNoThresholds.isEmpty())
		{
			if(isTestWithThresholds)
			{
%>
							<tr>
								<td><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="15"></td>
							</tr>
<%
			}
%>
							<tr>
								<td>
									<table align="center" width="100%" cellspacing="0" cellpadding="0" border="0">
										<tr>
											<td height="20" class="padding4 table_head">Measures without thresholds</td>
										</tr>
										<tr>
											<td width="100%">
												<table width="100%" cellspacing="0" cellpadding="0" border="0" class="tableborder_ad2" style="border-collapse: collapse;"><col width="33%"><col width="33%"><col width="34%">
<%
			for (int d=0; d<aListTestWithNoThresholds.size(); d=d+3)
			{
%>
													<tr>
<%
				int k = 1;
				for (int e=d; e<d+3; e++)
				{
					if (e<aListTestWithNoThresholds.size())
					{
						String strMeasure = (String)aListTestWithNoThresholds.get(e);
						String tmpStyple="";
						if(k==1)
						{
						tmpStyple="border-left-width:1px";
						k++;
						}

%>
														<td class="tdborder_ad2 padding4" valign="top" align="left" >
															<%=mappingInfo.getMeasureDescription(s_testName,strMeasure)%>
														</td>
<%
					}
					else
					{
%>
														<td class="tdborder_ad2 padding4" valign="top" align="left" >&nbsp;</td>
<%
					}
				}
%>
													</tr>
<%
			}
%>
												</table>
											</td>
										</tr>
									</table>
								</td>
							</tr>
<%
		}
	}
	else
	{
%>
							<tr>
								<td>
									<table align="center" width="100%" cellspacing="0" cellpadding="0" border="0"><col width="auto"><col width="65%"><col width="15%">
<%
		boolean heading_flag = false;
		ArrayList aListTestWithNoThresholds = new ArrayList();
		boolean cellFlag = false;
		boolean isTestWithThresholds = false;
		st = new StringTokenizer(strIniVal,",");
		while (st.hasMoreTokens())
		{
			strTok = st.nextToken();
			st1 = new StringTokenizer(strTok,":");
			while (st1.hasMoreTokens())
			{
				measure = st1.nextToken();
				policy = st1.nextToken();
				min = st1.nextToken();
				max = st1.nextToken();
				String alarmPolicy = st1.nextToken();
				String lastToken = st1.nextToken();

				String absMinCritical = "-";
				String relMinCritical = "-";

				String absMinMajor = "-";
				String relMinMajor = "-";

				String absMinMinor = "-";
				String relMinMinor = "-";

				String absMaxCritical = "-";
				String relMaxCritical = "-";

				String absMaxMajor = "-";
				String relMaxMajor = "-";

				String absMaxMinor = "-";
				String relMaxMinor = "-";

				if (policy.equalsIgnoreCase("none"))
				{
					policy = "mix";
				}
				else if (policy.equalsIgnoreCase("absolute"))
				{
					if (!min.equals("-1"))
					{
						StringTokenizer stAbsMin = new StringTokenizer(min,"/");
						absMinCritical = stAbsMin.nextToken();
						absMinMajor = stAbsMin.nextToken();
						absMinMinor = stAbsMin.nextToken();
					}

					if (!max.equals("-1"))
					{
						StringTokenizer stAbsMax = new StringTokenizer(max,"/");
						absMaxCritical = stAbsMax.nextToken();
						absMaxMajor = stAbsMax.nextToken();
						absMaxMinor = stAbsMax.nextToken();
					}
				}
				else if (policy.equalsIgnoreCase("relative"))
				{
					if (!min.equals("-1"))
					{
						StringTokenizer stRelMin = new StringTokenizer(min,"/");
						relMinCritical = stRelMin.nextToken();
						relMinMajor = stRelMin.nextToken();
						relMinMinor = stRelMin.nextToken();
					}

					if (!max.equals("-1"))
					{
						StringTokenizer stRelMax = new StringTokenizer(max,"/");
						relMaxCritical = stRelMax.nextToken();
						relMaxMajor = stRelMax.nextToken();
						relMaxMinor = stRelMax.nextToken();
					}
				}
				else if (policy.equalsIgnoreCase("mix"))
				{
					Vector vec = getAbsAndRel(min);
					absA = (String) vec.get(0);
					relA = (String) vec.get(1);
					Vector vec1 = getAbsAndRel(max);
					absB = (String) vec1.get(0);
					relB = (String) vec1.get(1);

					if (!absA.equals("none"))
					{
						StringTokenizer stmixMin = new StringTokenizer(absA,"/");
						absMinCritical = stmixMin.nextToken();
						absMinMajor = stmixMin.nextToken();
						absMinMinor = stmixMin.nextToken();
					}

					if (!absB.equals("none"))
					{
						StringTokenizer stmixMax = new StringTokenizer(absB,"/");
						absMaxCritical = stmixMax.nextToken();
						absMaxMajor = stmixMax.nextToken();
						absMaxMinor = stmixMax.nextToken();
					}

					if (!relA.equals("none"))
					{
						StringTokenizer stRelMin = new StringTokenizer(relA,"/");
						relMinCritical = stRelMin.nextToken();
						relMinMajor = stRelMin.nextToken();
						relMinMinor = stRelMin.nextToken();
					}

					if (!relB.equals("none"))
					{
						StringTokenizer stmixMax = new StringTokenizer(relB,"/");
						relMaxCritical = stmixMax.nextToken();
						relMaxMajor = stmixMax.nextToken();
						relMaxMinor = stmixMax.nextToken();
					}
				}

				String minCritical = getThresholdValue("min",absMinCritical,relMinCritical);
				String minMajor = getThresholdValue("min",absMinMajor,relMinMajor);
				String minMinor = getThresholdValue("min",absMinMinor,relMinMinor);

				String maxCritical = getThresholdValue("max",absMaxCritical,relMaxCritical);
				String maxMajor = getThresholdValue("max",absMaxMajor,relMaxMajor);
				String maxMinor = getThresholdValue("max",absMaxMinor,relMaxMinor);

				if (minCritical.equals("-")  && minMajor.equals("-") && minMinor.equals("-") && 
				maxCritical.equals("-") && maxMajor.equals("-") && maxMinor.equals("-"))
				{
					aListTestWithNoThresholds.add(measure);
					cellFlag = !cellFlag;
					continue;
				}
				else
				{
					isTestWithThresholds = true;
				}

				if (!heading_flag)
				{
					heading_flag = true;
%>
								<!-- Heading -->
										<tr>
											<td align="center" class="lineright padding4 table_head">Measure</td>
											<td align="center" style="padding:0px">
												<table cellpadding="0" cellspacing="0" border="0" width="100%"><col width="19%"><col width="27%"><col width="27%"><col width="27%">
													<tr>
														<td align="center" class="lineright padding4 table_head">Min/Max</td>
														<td align="center" class="lineright padding4 table_head">Critical</td>
														<td align="center" class="lineright padding4 table_head">Major</td>
														<td align="center" class="lineright padding4 table_head">Minor</td>
													</tr>
												</table>
											</td>
											<td class="padding4 table_head" align="center">Alarm Policy</td>
										</tr>
<%
				}
				String unit = tablesInfo.getUnitForMeasure(s_testName,measure);

%>
										<tr>
											<td align="left" valign="middle" id="<%=cellFlag?"cell_border3":"cell_border4"%>" class="padding4" style="border-left-width:1px">
												<table cellpadding="0" cellspacing="0" border="0" width="100%">
													<tr>
														<td width="5%" valign="center" valign="middle">
															<img src="/final/images/pencil_gray.png" title="Click here to configure threshold values" class="leftmouse" align="left" onclick="javascript:configureThresholds('<%=measure%>','<%=absMinCritical%>','<%=absMinMajor%>','<%=absMinMinor%>','<%=relMinCritical%>','<%=relMinMajor%>','<%=relMinMinor%>','<%=absMaxCritical%>','<%=absMaxMajor%>','<%=absMaxMinor%>','<%=relMaxCritical%>','<%=relMaxMajor%>','<%=relMaxMinor%>','<%=alarmPolicy%>')">
														</td>
														<td width="95%" valign="middle" nowrap>
															<a href="javascript:void(0);" class="eg_monlink" onclick="javascript:configureThresholds('<%=measure%>','<%=absMinCritical%>','<%=absMinMajor%>','<%=absMinMinor%>','<%=relMinCritical%>','<%=relMinMajor%>','<%=relMinMinor%>','<%=absMaxCritical%>','<%=absMaxMajor%>','<%=absMaxMinor%>','<%=relMaxCritical%>','<%=relMaxMajor%>','<%=relMaxMinor%>','<%=alarmPolicy%>')"><%=mappingInfo.getMeasureDescription(s_testName,measure)%></a>
														</td>
														<td class="eg_7">&nbsp;<i>(<%=unit%>)</i>&nbsp;</td>
													</tr>
												</table>
											</td>
											<td align="left" valign="top" id="<%=cellFlag?"cell_border3":"cell_border4"%>" class="padding4" >
												<table cellpadding="0" cellspacing="0" border="0" width="100%" class="tableborder_ad"><col width="19%"><col width="27%"><col width="27%"><col width="27%" >
<%
				if(!minCritical.equals("-") || !minMajor.equals("-") || !minMinor.equals("-"))
				{
%>
													<tr class="linebottom">
														<td align="center" class="padding4 tdborder_ad"><b>Min</b></td>
														<td align="center" class="padding4 tdborder_ad" name="absMin"><a href="javascript:void(0);" class="eg_monlink" onclick="javascript:configureThresholds('<%=measure%>','<%=absMinCritical%>','<%=absMinMajor%>','<%=absMinMinor%>','<%=relMinCritical%>','<%=relMinMajor%>','<%=relMinMinor%>','<%=absMaxCritical%>','<%=absMaxMajor%>','<%=absMaxMinor%>','<%=relMaxCritical%>','<%=relMaxMajor%>','<%=relMaxMinor%>','<%=alarmPolicy%>')"><%=minCritical%></a></td>
														<td align="center" class="padding4 tdborder_ad"><a href="javascript:void(0);" class="eg_monlink" onclick="javascript:configureThresholds('<%=measure%>','<%=absMinCritical%>','<%=absMinMajor%>','<%=absMinMinor%>','<%=relMinCritical%>','<%=relMinMajor%>','<%=relMinMinor%>','<%=absMaxCritical%>','<%=absMaxMajor%>','<%=absMaxMinor%>','<%=relMaxCritical%>','<%=relMaxMajor%>','<%=relMaxMinor%>','<%=alarmPolicy%>')"><%=minMajor%></a></td>
														<td align="center" class="padding4 tdborder_ad"><a href="javascript:void(0);" class="eg_monlink" onclick="javascript:configureThresholds('<%=measure%>','<%=absMinCritical%>','<%=absMinMajor%>','<%=absMinMinor%>','<%=relMinCritical%>','<%=relMinMajor%>','<%=relMinMinor%>','<%=absMaxCritical%>','<%=absMaxMajor%>','<%=absMaxMinor%>','<%=relMaxCritical%>','<%=relMaxMajor%>','<%=relMaxMinor%>','<%=alarmPolicy%>')"><%=minMinor%><a/></td>
													</tr>
<%
				}

				if(!maxCritical.equals("-") || !maxMajor.equals("-") || !maxMinor.equals("-"))
				{
%>
													<tr>
														<td align="center" class="padding4 tdborder_ad"><b>Max</b></td>
														<td align="center" class="padding4 tdborder_ad" name="absMin"><a href="javascript:void(0);" class="eg_monlink" onclick="javascript:configureThresholds('<%=measure%>','<%=absMinCritical%>','<%=absMinMajor%>','<%=absMinMinor%>','<%=relMinCritical%>','<%=relMinMajor%>','<%=relMinMinor%>','<%=absMaxCritical%>','<%=absMaxMajor%>','<%=absMaxMinor%>','<%=relMaxCritical%>','<%=relMaxMajor%>','<%=relMaxMinor%>','<%=alarmPolicy%>')"><%=maxCritical%></a></td>
														<td align="center" class="padding4 tdborder_ad"><a href="javascript:void(0);" class="eg_monlink" onclick="javascript:configureThresholds('<%=measure%>','<%=absMinCritical%>','<%=absMinMajor%>','<%=absMinMinor%>','<%=relMinCritical%>','<%=relMinMajor%>','<%=relMinMinor%>','<%=absMaxCritical%>','<%=absMaxMajor%>','<%=absMaxMinor%>','<%=relMaxCritical%>','<%=relMaxMajor%>','<%=relMaxMinor%>','<%=alarmPolicy%>')"><%=maxMajor%></a></td>
														<td align="center" class="padding4 tdborder_ad"><a href="javascript:void(0);" class="eg_monlink" onclick="javascript:configureThresholds('<%=measure%>','<%=absMinCritical%>','<%=absMinMajor%>','<%=absMinMinor%>','<%=relMinCritical%>','<%=relMinMajor%>','<%=relMinMinor%>','<%=absMaxCritical%>','<%=absMaxMajor%>','<%=absMaxMinor%>','<%=relMaxCritical%>','<%=relMaxMajor%>','<%=relMaxMinor%>','<%=alarmPolicy%>')"><%=maxMinor%></a></td>
													</tr>
<%
				}
%>

												</table>
											</td>
											<td id="<%=cellFlag?"cell_border3":"cell_border4"%>" class="padding4" align="left" valign="middle" title="<%=alarmPolicy%>"><a href="javascript:void(0);" class="eg_monlink" onclick="javascript:configureThresholds('<%=measure%>','<%=absMinCritical%>','<%=absMinMajor%>','<%=absMinMinor%>','<%=relMinCritical%>','<%=relMinMajor%>','<%=relMinMinor%>','<%=absMaxCritical%>','<%=absMaxMajor%>','<%=absMaxMinor%>','<%=relMaxCritical%>','<%=relMaxMajor%>','<%=relMaxMinor%>','<%=alarmPolicy%>')"><egui:display name="<%=alarmPolicy%>" length="<%=Integer.toString(alarmPolicyLength)%>"/></a></td>
										</tr>
<%
			}

			cellFlag = !cellFlag;
		}
%>
									</table>
								</td>
							</tr>
<%
		if (aListTestWithNoThresholds != null && !aListTestWithNoThresholds.isEmpty())
		{
			if(isTestWithThresholds)
			{
%>
							<tr>
								<td><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="15"></td>
							</tr>
<%
			}
%>
							<tr>
								<td>
									<table align="center" width="100%" cellspacing="0" cellpadding="0" border="0">
										<tr>
											<td height="20" class="padding4 table_head">Measures without thresholds</td>
										</tr>
										<tr>
											<td width="100%">
												<table width="100%" cellspacing="0" cellpadding="0" border="0" class="tableborder_ad2" style="border-collapse: collapse;"><col width="33%"><col width="33%"><col width="34%">
<%
			for (int d=0; d<aListTestWithNoThresholds.size(); d=d+3)
			{
%>
													<tr>
<%
				int k = 1;
				for (int e=d; e<d+3; e++)
				{
					if (e<aListTestWithNoThresholds.size())
					{
						String strMeasure = (String)aListTestWithNoThresholds.get(e);
						String tmpStyple="";
						if(k==1)
						{
						tmpStyple="border-left-width:1px";
						k++;
						}
%>
														<td class="tdborder_ad2 padding4" valign="top" align="left" >
															<table cellpadding="0" cellspacing="0" border="0" width="100%">
																<tr>
																	<td width="5%" valign="center" valign="middle">
																	<img src="/final/images/pencil_gray.png" title="Click here to configure threshold values" class="leftmouse" align="left" onclick="javascript:configureThresholds('<%=strMeasure%>','-','-','-','-','-','-','-','-','-','-','-','-','-')">
																	</td>
																	<td width="95%" valign="middle">
																	<a href="javascript:void(0);" class="eg_monlink" onclick="javascript:configureThresholds('<%=strMeasure%>','-','-','-','-','-','-','-','-','-','-','-','-','-')"><%=mappingInfo.getMeasureDescription(s_testName,strMeasure)%></a>
																	</td>
																</tr>
															</table>
														</td>
<%
							}
							else
							{
%>
														<td class="tdborder_ad2" >&nbsp;</td>
<%
							}
					}
%>
													</tr>
<%
				}
%>
												</table>
											</td>
										</tr>
									</table>
								</td>
							</tr>
<%
		}
%>
							<tr>
								<td><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="15"></td>
							</tr>
<%
	}
%>
							
						</table>
					</td>
				</tr>
			</table>
		</td>
	</tr>
					<!-- <input type="hidden" name="threshType" value="Multiple"> -->
<%
					session.setAttribute("strTestName",s_testName);
					session.setAttribute("v_compare",v_temp);
%>
				
<!-- 		<input type="hidden" name="measNum" value=<%//=count%>> 
		<input type="hidden" name="previous" value="<%//=strpre%>"> -->
		<!-- <tr>
			<td colspan="5" align="center">&nbsp;</td>
		</tr>
		<tr>
			<td colspan="5" align="center"><input type="button" name="update" value='<egui:intnl text="admin.threshold.Update"/>' class="eg_back" onClick="javascript:populateNEW()"></td>
		</tr> -->
<%
		}
	}
	else
	{
%>
	<tr>
		<td height = "70">&nbsp;</td>
	</tr>
	<tr>
		<td align="center"><img src="/final/admin/eg_images/<%=admin_Skin%>/exclamation-icon.gif"></td>
	</tr>
	<tr>
		<td align="center" id="eg_errorsmall"><egui:intnl text="admin.threshold.No Managed Components"/></td>
	</tr>
<%
	}
%>
</table>
</form>
</body>
</html>
<%!
	public String getArrayString (String [] a)
	{
		String s = "[ ";
		for (int i = 0; a.length>i; i++)
		{
			if (i != 0)
			{
				s += ", ";
			}
			s+="\""+a[i]+"\"";
		}
		s+=" ];";
		return s;
	}

//	public Vector getAbsAndRel(String format) // for mix format in threshold ,introduced by BOSS
//	{
//		Vector vect = new Vector();	// [absolute,relative]
//		StringTokenizer stok1 = new StringTokenizer(format,"/");
//		if (!format.equals("-1") && stok1.countTokens() == 3)
//		{
//			String h;
//			String m;
//			String l;
//			String H = stok1.nextToken();
//			String M = stok1.nextToken();
//			String L = stok1.nextToken();
//			if (!(H.equals("-")))
//			{
//				if (H.indexOf("&") > -1)
//				{
//					StringTokenizer st = new StringTokenizer(H,"&");
//					H = st.nextToken();
//					h = st.nextToken();
//				}
//				else
//				{
//					if (H.indexOf("sqc") > -1)
//					{
//						h = H;
//						H = "-";
//					}
//					else
//						h = "-";
//				}
//			}
//			else
//			{
//				h = "-";
//			}
//			if (!(M.equals("-")))
//			{
//				if (M.indexOf("&") > -1)
//				{
//					StringTokenizer st = new StringTokenizer(M,"&");
//					M = st.nextToken();
//					m = st.nextToken();
//				}
//				else
//				{
//					if (M.indexOf("sqc") > -1)
//					{
//						m = M;
//						M = "-";
//					}
//					else
//						m = "-";
//				}
//			}
//			else
//			{
//				m = "-";
//			}
//			if (!(L.equals("-")))
//			{
//				if (L.indexOf("&") > -1)
//				{
//					StringTokenizer st = new StringTokenizer(L,"&");
//					L = st.nextToken();
//					l = st.nextToken();
//				}
//				else
//				{
//					if (L.indexOf("sqc") > -1)
//					{
//						l = L;
//						L = "-";
//					}
//					else
//						l = "-";
//				}
//			}
//			else
//			{
//				l = "-";
//			}
//			StringBuffer sb2 = new StringBuffer();
//			StringBuffer sb1 = new StringBuffer();
//			String s1 = null;
//			if (H.equals("-") && M.equals("-") && L.equals("-"))
//			{
//				s1 = "none";
//			}
//			else
//			{
//				sb1.append(H);
//				sb1.append("/");
//				sb1.append(M);
//				sb1.append("/");
//				sb1.append(L);
//				s1 = sb1.toString();
//			}
//			String s2 = null;
//			if (h.equals("-") && m.equals("-") && l.equals("-"))
//			{
//				vect.add(s1);
//				vect.add("none");
//			}
//			else
//			{
//				sb2.append(h);
//				sb2.append("/");
//				sb2.append(m);
//				sb2.append("/");
//				sb2.append(l);
//				s2 = sb2.toString();
//				vect.add(s1);
//				vect.add(s2);
//			}
//		}
//		else
//		{
//			vect.add("none");
//			vect.add("none");
//		}
//		return vect;
//	}

	int alarmPolicyLength = 15;

	private String get1(String H)
	{
		String h;
		if (!(H.equals("-")))
		{
			if (H.indexOf("&") > -1)
			{
				StringTokenizer st = new StringTokenizer(H,"&");
				H = st.nextToken();
				h = st.nextToken();
			}
			else
			{
				if (H.indexOf("sqc") > -1)
				{
					h = H;
					H = "-";
				}
				else
				{
					h = "-";
				}
			}
		}
		else
		{
			h = "-";
		}
		return(H+"_"+h);
	}

	private Vector getAbsAndRel(String format)
	{
		Vector vect = new Vector();
		StringTokenizer stok1 = new StringTokenizer(format,"/");
		if (!format.equals("-1") && stok1.countTokens() == 3)
		{
			String H1 = stok1.nextToken();
			String h2=get1(H1);
			String M = stok1.nextToken();
			String m1=get1(M);
			String L = stok1.nextToken();
			String l1=get1(L);
			StringTokenizer h1 = new StringTokenizer(h2,"_");
			String High= h1.nextToken();
			String high = h1.nextToken();
			StringTokenizer m = new StringTokenizer(m1,"_");
			String Mid = m.nextToken();
			String mid = m.nextToken();
			StringTokenizer l = new StringTokenizer(l1,"_");
			String Low = l.nextToken();
			String low = l.nextToken();
			StringBuffer sb2 = new StringBuffer();
			StringBuffer sb1 = new StringBuffer();
			String s1 = null;
			if (High.equals("-") && Mid.equals("-") && Low.equals("-"))
			{
				s1 = "none";
			}
			else
			{
				sb1.append(High);
				sb1.append("/");
				sb1.append(Mid);
				sb1.append("/");
				sb1.append(Low);
				s1 = sb1.toString();
			}
			String s2 = null;
			if (high.equals("-") && mid.equals("-") && low.equals("-"))
			{
				vect.add(s1);
				vect.add("none");
			}
			else
			{
				sb2.append(high);
				sb2.append("/");
				sb2.append(mid);
				sb2.append("/");
				sb2.append(low);
				s2 = sb2.toString();
				vect.add(s1);
				vect.add(s2);
			}
		}
		else
		{
			vect.add("none");
			vect.add("none");
		}
		return vect;
	}

	private String getThresholdValue(String grpFunction, String absValue,String relValue)
	{
		String strValue = "-";

		if (absValue.equals("-") && relValue.equals("-"))
		{
			strValue = "-";
		}
		else if (!absValue.equals("-") && !relValue.equals("-"))
		{
			strValue = grpFunction+"("+absValue+", "+getRelativeThreshold(relValue)+")";
		}
		else if (!absValue.equals("-"))
		{
			strValue = absValue;
		}
		else if (!relValue.equals("-"))
		{
			strValue = getRelativeThreshold(relValue);
		}

		return strValue;
	}

	private String getRelativeThreshold(String relValue)
	{
		//relValue: 3*sqc
		String strValue = "";
		if (relValue.indexOf("*") != -1)
		{
			int idx = relValue.indexOf("*");
			String s1 = relValue.substring(0,idx);
			double d_value = Double.valueOf(s1.trim()).doubleValue();
			d_value = d_value * 100;
			int i_value = (new Double(d_value)).intValue();
			strValue = Integer.toString(i_value) + "% of auto";
		}
		else
		{
			strValue = "auto";
		}
		return strValue;
	}







%>

<%
	if(request.getQueryString()!=null)
	{
		session.setAttribute("adminLastAccessedURL","/final/admin/EgGroupThreshPolicies.jsp?"+request.getQueryString());
	}
	//else
	//{
	//	session.setAttribute("adminLastAccessedURL","/final/admin/EgGroupThreshPolicies.jsp");
	//}
%>
