<%
/*
 *  File		:	EgEnableAndDisableTestsResult.jsp
 *  Purpose	:	This page shows the administrator which performance/configuration tests are enable/disable for a component type.
 *  Author		:	Chittibabu (10-05-2012)
*/
%>

<%@ include file="EgTrackerA.jsp"%>
<%@ page import = "java.util.*"%>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ page errorPage = "EgProbs.jsp" %>
<%@ page import="com.eg.EgSpecsInfo"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%
	String refFreq = _user.getRefreshFrequency();
	refFreq = (refFreq != null && refFreq.length() > 0)?refFreq:"90";
	String componentType = request.getParameter("componentType");
	String enabledTestList = request.getParameter("enabledTestsListOnly");
	String disabledTestList = request.getParameter("disabledTestsListOnly");
	String testType = request.getParameter("testType");
	
	enabledTestList = (enabledTestList==null)?"":enabledTestList;
	disabledTestList = (disabledTestList==null)?"":disabledTestList;
	componentType = (componentType==null)?"":componentType;
	testType = (testType==null)?"":testType;

	ArrayList enabledList = new ArrayList();
	ArrayList disabledList = new ArrayList();
	StringTokenizer stnEnable = new StringTokenizer(enabledTestList,",");
	StringTokenizer stnDisable = new StringTokenizer(disabledTestList,",");
	while(stnEnable.hasMoreTokens())
	{
		enabledList.add(stnEnable.nextToken());
		
	}
	while(stnDisable.hasMoreTokens())
	{
		disabledList.add(stnDisable.nextToken());
		
	}
	String typeTest = "";
	if(testType.equals("") || testType.equals("PerformanceTest"))
	{
		typeTest = "performance";
	}
	else
	{
		typeTest = "configuration";
	}
%>
 
<html>
<head>
<META HTTP-EQUIV="REFRESH" Content="<%=refFreq%>;url=EgAdminOperations.jsp">
<egui:skin ui="admin"/>
</head>
<body>
<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0">
	<jsp:include page="listSearch.jsp?title=ENABLE / DISABLE TESTS&subtitle=false&egPageDesc=false"/>
<center>
<table  width="100%">
	<tr>
		<td valign="top" height="100%">
			<table align="center" cellspacing="0" cellpadding="0" width="85%" id="eg_subcontentbg" border="0">
				<tr>
					<td valign="top">
						<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" style="padding:0px" >
							<tr>
								<td id="subhead_left" width="7"> <img src="/final/admin/eg_images/spacer.gif" border="0" width="7"> </td>
								<td id="eg_subheadbg_lower" width="100%" height="20" align="center" colspan="2"><b><egui:intnl text="admin.common.Component type "/> : <%=_mapping.getComponentTypeDescription(componentType)%>&nbsp;</b></td>
								<td id="subhead_right" width="7"> <img src="/final/admin/eg_images/spacer.gif" border="0" width="7"> </td>
							</tr>
						</table>
					</td>
				</tr>
				<tr>
					<td>
						<strong>&nbsp;&nbsp;<egui:intnl text="admin.ic.Test type"/> : <%=typeTest%></strong>
					</td>
				</tr>
				<tr height="20px">
					<td>&nbsp;</td>
				</tr>
				
				<tr>
					<td align="center">
							<div style="width:95%;height:100%;border:0px solid black;">
								<table cellpadding="0" cellspacing="0" class="linesquare">
<%
	int noOfEnabledTests = enabledList.size();
	int noOfDisabledTests = disabledList.size();
	String displayEnableText = "";
	if(noOfEnabledTests == 1)
	{
		displayEnableText = "admin.test.Newly enabled test";
	}
	else
	{
		displayEnableText = "admin.test.Newly enabled tests";
	}

	if (noOfEnabledTests > 0)
	{
		int vRowCount  = noOfEnabledTests / 3;
		int vCellCount  = noOfEnabledTests % 3;
		if(vCellCount != 0)
		{
			vRowCount = vRowCount+1;
		}
%>
									<tr>
										<td class="eg_cellbgmedium">
											<table border="0" cellpadding="0" cellspacing="0">
												<tr>

													<td width="100%" height="20" align="left"><b>&nbsp;<egui:intnl text="<%=displayEnableText%>"/></b></td>

												</tr>
											</table>
										</td>
									</tr>

									<tr>
										<td align="center"  style="padding:4px;border-top-width:0px">
											<table align="center" border="0" width="100%" class="tableborder_ad" cellpadding="4" cellspacing="0">
<%
			int j=0;
			int k=0;
			for (int i=0;i < vRowCount;i++)
			{
				k=0;
%>
												<tr>
<%
				for (j=j; k<3 && j < noOfEnabledTests;j++,k++)
				{
%>
													<td class="tdborder_ad" valign="top" style="width:250px">
													<%=enabledList.get(j).toString()%>
													</td>
<%
				}
%>
												</tr>
<%
			}
			
%>

											</table>
										</td>
									</tr>
<%
	}
	String displayDisableText = "";
	if(noOfDisabledTests == 1)
	{
		displayDisableText = "admin.test.Newly disabled test";
	}
	else
	{
		displayDisableText = "admin.test.Newly disabled tests";
	}

	if (noOfDisabledTests > 0)
	{
		int vRowCount  = disabledList.size() / 3;
		int vCellCount  = disabledList.size() % 3;
		if(vCellCount != 0)
		{
			vRowCount = vRowCount+1;
		}
%>
									<tr>
										<td class="eg_cellbgmedium">
											<table border="0" cellpadding="0" cellspacing="0">
												<tr>

													<td width="100%" height="20" align="left"><b>&nbsp;<egui:intnl text="<%=displayDisableText%>"/></b></td>


												</tr>
											</table>
										</td>
									</tr>
									<tr>
										<td align="center" style="padding:4px;border-top-width:0px">
											<table align="center" border="0" width="100%" class="tableborder_ad" cellpadding="4" cellspacing="0">
<%
			int j=0;
			int k=0;
			for (int i=0;i < vRowCount;i++)
			{
				k=0;
%>
												<tr>
<%
				for (j=j; k<3 && j < noOfDisabledTests;j++,k++)
				{
%>
													<td class="tdborder_ad" valign="top" style="width:250px"><%=disabledList.get(j).toString()%></td>
<%
				}
%>
												</tr>
<%
			}
%>								
											</table>
										</td>
									</tr>
<%
	}
%>
							</div>
					</td>
				</tr>
				
			</table>
		</td>
	</tr>
		<tr>
			<td>&nbsp;&nbsp;</td>
		</tr>
</table>

	<tr><td align="center" colspan="3" id="eg_blankspace" height="5">&nbsp;</td></tr>
	<tr>
		<td nowrap valign="top" align="center" >&nbsp;<egui:intnl text="admin.common.This page redirects to Admin Home in"/>&nbsp;<%=refFreq%>&nbsp;<egui:intnl text="admin.common.seconds, else you can go back to"/>&nbsp;<a class="eg_monlink" href="EgEnableAndDisableTests.jsp?componentType=<%=componentType%>&testType=<%=testType%>">&nbsp;<strong><egui:intnl text="admin.test.Enable/Disable tests page"/></strong>&nbsp;<img src="/final/admin/eg_images/icon_click.gif" border="0"></a>
		</td>
	</tr>
	<tr>
<%
		EgSpecsInfo egSpecs = new EgSpecsInfo("manager");
		boolean isConfigSupport = EgInstallInfo.isConfigSupported;
		if (isConfigSupport)
		{
			ArrayList aListEnabledTestForCompType = null;
			if (!componentType.equals("") && !componentType.equals("-1"))
			{
				if (testType.equals("PerformanceTest"))
				{
					aListEnabledTestForCompType = egSpecs.getEnabledTests(componentType,true);
					if(aListEnabledTestForCompType.size()>0)
					{
						testType="ConfigurationTest";
%>
						<td nowrap valign="top" align="center" >&nbsp;<egui:intnl text="Click here to"/>&nbsp;<a class="eg_monlink" href="EgEnableAndDisableTests.jsp?componentType=<%=componentType%>&testType=<%=testType%>">&nbsp;<strong><egui:intnl text="admin.test.Enable/Disable configuration tests"/></strong>&nbsp;<img src="/final/admin/eg_images/icon_click.gif" border="0"></a></td>
<%
					}
				}
			}
		}
%>
	</tr>
</center>
</body>
</html>



