<%
/*******************************************************************************
 *      File name               :       EgDispRemoteAgents.jsp
 *      Purpose                 :       To display the list of remote agents
					in the system.
 *      Version                 :       3.0
 *      Creation Date           :       18/10/2003
 *      Author                  :       Babu S
 *		Design Changes			:		Jaiwin
 ******************************************************************************/
%>

<%@ include file="EgTrackerA.jsp" %>
<%@ page errorPage="EgProbs.jsp"%>
<%@ taglib prefix ="egui" uri="../WEB-INF/eg-taglib.tld"%>
<%@ page import="com.eg.EgURLEncoder"%>
<%@ page import ="com.eg.EgSpecsInfo"%>
<%@ page import ="com.eg.EgServicesInfo"%>
<%@ page import ="com.eg.EgExternalInfo"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%
     response.setHeader("Cache-Control","no-store");
     response.setHeader("Pragma","no-cache");
     response.setDateHeader("Expires", -1);
	 String egTitleSearchStr = request.getParameter("egTitleSearchStr");
	boolean isSearchResult =egTitleSearchStr!=null;
	ArrayList searchList = new ArrayList();
	if (isSearchResult)
	{
		StringTokenizer st = new StringTokenizer(egTitleSearchStr);
		while (st.hasMoreTokens())
		{
			String thisToken = st.nextToken().trim();
			if (thisToken.equals(""))
				continue;
			searchList.add(thisToken);
		}
	}
%>

<html>
<head>
<title>External Agents</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<egui:skin ui="admin"/>
<!-- <link rel="stylesheet" href="eg_styles/eg_adminstyle.css">  -->

<script language="JavaScript">

function populate()
{
        document.list.submit();
}

function egTitleSearch()
{
	var thisForm=document.ExternalAgents;
	var searchSt=thisForm.egTitleSearchStr.value;
	if (searchSt==null || searchSt=="")
	{
		window.location.href = "EgDispRemoteAgents.jsp";
	}
	else if(searchSt!=null)
	{
		window.location.href = "EgDispRemoteAgents.jsp?egTitleSearchStr="+encodeURI(searchSt);
	}
}
function deleteRemoteAgent(remoteAgent)
{
	if(confirm("<egui:intnl text='admin.remote.Are you sure you want to delete the Remote agent'/>, '"+remoteAgent+"' ?"))
	window.location.href = "Egnewremoteagentsp.jsp?mode=del&eagent="+encodeURI(remoteAgent);
}

</script>

</head>

<jsp:useBean id="trans" scope="page" class="egurkha.TransactionBean"/>

<%
	trans.createFile("eg_external.ini");
	String [] s_eagents = trans.getVariables("Eg_Remote_Agents");
	EgSpecsInfo specs = new EgSpecsInfo("manager");
	EgServicesInfo servicesInfo = new EgServicesInfo("manager");
	EgExternalInfo externalInfo = new EgExternalInfo("manager");
	boolean searchItemFound=false;
	ArrayList remAgents = new ArrayList();
	if (s_eagents!=null)
	{
		Arrays.sort(s_eagents,String.CASE_INSENSITIVE_ORDER);
		for(int i=0;i < s_eagents.length;i++)
		{
			if (isSearchResult && !doesExist(searchList, s_eagents[i]))
				continue;
			searchItemFound=true;
			remAgents.add(s_eagents[i]);
		}
	}

	List tmpList = new ArrayList();
	String defaultRemAgent = "";
	for (int j=0; j <remAgents.size();j++)
	{
		String tmpExtagent = (String)remAgents.get(j);
		if (specs.getEGServer().equals(tmpExtagent))
		{
			defaultRemAgent = tmpExtagent;
		}
		else
		{
			tmpList.add(tmpExtagent);
		}
	}
	if (!defaultRemAgent.equals(""))
	{
		tmpList.add(0,defaultRemAgent);
	}
	remAgents = new ArrayList(tmpList);
	
%>

<body style="overflow:auto" id="space6" >
<form name="ExternalAgents" method="post" style="margin:0px" action="javascript:egTitleSearch();">
<table border="0" align="center" cellspacing="0" cellpadding="0" width="100%" >
<%
session.setAttribute("egPageDesc","EgDispRemoteAgents.jsp");
session.setAttribute("egTitlehref", "/final/admin/EgNewRemoteAgents.jsp?Rtype=addNew");
%>
	<jsp:include page="listSearch.jsp?title=REMOTE AGENT CONFIGURATION&leftString=Add New Agent&backButton=false&subtitle=true&searchBox=true"/>
	<tr>
		<td width="100%" id="eg_whitebg" align="center" valign="top" height="100%">
<%
	if(remAgents != null && remAgents.size() > 0 && searchItemFound)
	{
		for(int i=0;i < remAgents.size();i++)
		{
			String remoteAgentIP = externalInfo.getIpForRemoteAgent((String)remAgents.get(i));
			boolean border=(i+1)< remAgents.size();
			if (i == 0)
			{
%>
				<br>
<%
			}
%>
			<table align="center" width="85%" cellspacing="0" cellpadding="0" border="0" 
			class="eg_subcontentbg" bordercolor="cyan">
				<tr>
					<td height="6" id="inner_top_left" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
					<td height="6" id="eg_subcontentbg" colspan="4"><img src="/final/admin/eg_images/spacer.gif" height="6"></td>
					<td height="6" id="inner_top_right" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
				</tr>

				<tr>
					<td width="7" class="eg_subcontentbg" id="form_spacing>"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
					<td width="62%" class="eg_subcontentbg" id="form_spacing" height="35">&nbsp;&nbsp;&nbsp;&nbsp;<strong><%=(String)remAgents.get(i)%></strong></td>
<%

				//if (servicesInfo.isAllowIPModification() && !remoteAgentIP.equals(s_eagents[i]))
				//if (!remoteAgentIP.equals((String)remAgents.get(i)))
				if(!specs.getEGServer().equals((String)remAgents.get(i)))
				{
%>
					<td width="90" id="eg_subcontentbg" class="form_spacing"><input type="button" value='<egui:intnl text="admin.remote.Change IP"/>' style="width: 80px;height: 20px;" class="eg_lightbutton" onClick='javascript:window.location.href="EgNewRemoteAgents.jsp?Rtype=changeip&ragent=<%=EgURLEncoder.encode((String)remAgents.get(i),"UTF-8")%>";'></td>
<%
				}
				else
				{
%>				
					<td width="90" id="eg_subcontentbg" class="form_spacing">&nbsp;</td>
<%
				}
%>
					<td width="90" id="eg_subcontentbg" class="form_spacing"><input type="button" value='<egui:intnl text="admin.remote.View"/>' style="width: 80px;height: 20px;" class="eg_lightbutton" onClick='javascript:window.location.href="EgNewRemoteAgents.jsp?Rtype=viewR&ragent=<%=EgURLEncoder.encode((String)remAgents.get(i),"UTF-8")%>";'></td>
<%
				if(!specs.getEGServer().equals((String)remAgents.get(i)))
				{
%>
					<td width="90" id="eg_subcontentbg" class="form_spacing"><input type="button" value='<egui:intnl text="admin.remote.Delete"/>' style="width: 80px;height: 20px;" class="eg_lightbutton" onClick='javascript:deleteRemoteAgent("<%=(String)remAgents.get(i)%>")'></td>
<%
				}
				else
				{
%>
					<td width="90" id="eg_subcontentbg" class="form_spacing">&nbsp;</td>
<% 					
				}
%>
					<td width="7" class="eg_subcontentbg" id="form_spacing"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
				</tr>
				<tr>
					<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
					<td id="eg_subcontentbg" colspan="4"><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
					<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
				</tr>
			</table>
			<br>
<%
		}
	}
	else
	{
%>
			<table align="center" width="85%" cellspacing="0" cellpadding="0" border="0" 
			class="eg_subcontentbg">
				<tr>
					<td id="eg_subcontentbg" colspan="6">
						<table border="0" cellspacing="0" cellpadding="4" width="100%" >
							<tr> 
								<td width="100%" align="center"> <img src="/final/admin/eg_images/<%=admin_Skin%>/exclamation-icon.gif"> </td>
							</tr>
							<tr>
								<td width="100%" align="center">
									<b>
<%
		if (!isSearchResult && s_eagents == null || s_eagents.length == 0)
		{
%>
			<egui:intnl text="admin.remote.No remote agents present in the system"/>
<%
		}
		else if (isSearchResult && remAgents.size() ==0)
		{
%>
			<egui:intnl text="admin.remote.No remote agent(s) found for your current search"/>,&nbsp;"<%=egTitleSearchStr%>"
<%
		}
%>
									</b>
								</td>
							</tr>
						</table>
					</td>
				</tr>
				<tr>
					<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
					<td id="eg_subcontentbg"  colspan="4" valign="top" ><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
					<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
				</tr>
			</table>
<%
	}
%>
			<br>
		</td>
	</tr>
</table>
</form>
</html>
<%!
	private boolean doesExist(List searchList, String thisGroup)
	{
		Iterator i = searchList.iterator();
		while(i.hasNext())
		{
			String nextStr = (String) i.next();
			if (thisGroup.indexOf(nextStr)!=-1||(thisGroup.toUpperCase().indexOf(nextStr.toUpperCase()))!=-1)
				return true;
		}
		return false;
	}
%>
<%
if(request.getQueryString()!=null)
session.setAttribute("adminLastAccessedURL","/final/admin/EgDispRemoteAgents.jsp?"+request.getQueryString());
else session.setAttribute("adminLastAccessedURL","/final/admin/EgDispRemoteAgents.jsp");
%>
