
<%
/*
File			:	EgDisoveredComponents.jsp
Purpose			:	To display the list of discovered components by component type wise
Created date	:	21-08-2009
*/
%>


<%@ include file="EgTrackerA.jsp"%>
<%@ page import="java.io.File"%>
<%@ page import="com.eg.IniFile"%>
<%@ page import="com.eg.EgName"%>
<%@ page import = "com.eg.EgURLEncoder"%>
<%@ page import="com.eg.EgConfigInfo"%>
<%@ page import="com.eg.EgMappingInfo"%>
<%@ page import="com.eg.EgStartStopDisc"%>
<%@ page import="com.eg.MappingNameSorter"%>
<%@ page import="com.egurkha.ini.IniUI"%>
<%@ page import="com.egurkha.util.StringUtils"%>
<%@ page errorPage="EgProbs.jsp"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld"%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>
<egui:skin ui = "admin"/>
<html>
<head>
</head>
<script language="Javascript">
function hideDiscoveredCompsPopUpDiv()
{
	window.parent.hideDiscoveredCompsPopUpDiv();
}

function disableAutoHide()
{
	window.parent.disableAutoHide();
}

function disableDiscCompsPopup(popup)
{
	if(!popup.checked)
	{
		popup.title = '<egui:intnl text="admin.discover.Check to enable the pop-up"/>';
	}
	else
	{
		popup.title = '<egui:intnl text="admin.discover.Uncheck to disable the pop-up"/>';
	}
	window.parent.setProperties('<%=request.getScheme()+"://"+request.getServerName()+":"+request.getServerPort()+"/final"%>');
	window.parent.disableDiscCompsPopup(popup);
}

function loadEnabledCloseImage()
{
	var closeID = document.getElementById("close");
	if(closeID != null)
	{
		closeID.src = "/final/admin/eg_images/winclose_over.gif";
	}
}

function loadDisabledCloseImage()
{
	var closeID = document.getElementById("close");
	if(closeID != null)
	{
		closeID.src = "/final/admin/eg_images/winclose.gif";
	}
}

function showImage(index)
{
	var result="des";
	var hide = new Array();
	hide = document.getElementsByTagName("img");
	for (i=0; i<hide.length; i++)
	{
		img_id = hide[i].id;
		if(img_id==null || img_id.length==0)
			continue;
		img_id = img_id.substring(3);
		if(img_id==index)
		{
			src = hide[i].src;
			if(src.indexOf("arrow_up_black_small.gif")=="-1")
			{
				hide[i].src="/final/monitor/eg_images/arrow_up_black_small.gif";
				result = "asc";
			}
			else
			{
				hide[i].src="/final/monitor/eg_images/arrow_down_black_small.gif";
				result = "des";
			}
			hide[i].style.display = '';
		}
	}
	return result;
}

var reverseSort = new Array(false,false,false,false,false,false,false,false,false,false);
var previousColumn  = 1;
var currentColumn = 1;
var res = "";
function sortTable(col,pos)
{
	currentColumn = col;
	var tblEl = document.getElementById('rsTable'+pos);
	if(tblEl.rows.length >= 50)
	{
		return false;
	}
	if (col == previousColumn)
		previousColumn = col;

	var oldDsply = tblEl.style.display;
	tblEl.style.display = "none";
	res = showImage(pos);
	if(res=="des")
	{
		reverseSort[col] = true;
	}
	else
	{
		reverseSort[col] = false;
	}
	var tmpEl;
	var i, j;
	var minVal, minIdx;
	var testVal;
	var cmp;
	for (i = 0; i < tblEl.rows.length - 1; i++)
	{
		// Assume the current row has the minimum value.
		minIdx = i;
		minVal = getTextValue(tblEl.rows[i].cells[col]);
		// Search the rows that follow the current one for a smaller value.
		for (j = i + 1; j < tblEl.rows.length; j++)
		{
			testVal = getTextValue(tblEl.rows[j].cells[col]);
			cmp = compareValues(minVal,testVal);
			// Negate the comparison result if the reverse sort flag is set.
			if (reverseSort[col])
				cmp = -cmp;
			// Sort by the second column (team name) if those values are equal.
			if (cmp == 0 && col != 1)
				cmp = compareValues(getTextValue(tblEl.rows[minIdx].cells[1]),getTextValue(tblEl.rows[j].cells[1]));
			// If this row has a smaller value than the current minimum, remember its
			// position and update the current minimum value.
			if (cmp > 0)
			{
				minIdx = j;
				minVal = testVal;
			}
		}
		// By now, we have the row with the smallest value. Remove it from the
		// table and insert it before the current row.
		if (minIdx > i)
		{
			tmpEl = tblEl.removeChild(tblEl.rows[minIdx]);
			tblEl.insertBefore(tmpEl, tblEl.rows[i]);
		}
	}
	// Restore the table's display style.
	tblEl.style.display = oldDsply;
	return false;
}
//-----------------------------------------------------------------------------
// Functions to get and compare values during a sort.
//-----------------------------------------------------------------------------
// This code is necessary for browsers that don't reflect the DOM constants
// (like IE).
if (document.ELEMENT_NODE == null)
{
	document.ELEMENT_NODE = 1;
	document.TEXT_NODE = 3;
}

function getTextValue(el)
{
	var i;
	var s;
	// Find and concatenate the values of all text nodes contained within the  element.
	s = "";
	for (i = 0; i < el.childNodes.length; i++)
	{
		if (el.childNodes[i].nodeType == document.TEXT_NODE)
		{
			s += el.childNodes[i].nodeValue;
		}
		else if (el.childNodes[i].nodeType == document.ELEMENT_NODE && el.childNodes[i].tagName == "BR")
		{
			s += " ";
		}
		else
		{
			// Use recursion to get text within sub-elements.
			s += getTextValue(el.childNodes[i]);
		}
	}
	return normalizeString(s);
}

function compareValues(v1, v2)
{
	v1 = v1.toUpperCase();
	v2 = v2.toUpperCase();
	// Compare the two values.
	if (v1 == v2)
		return 0;
	if (v1 > v2)
		return 1

	return -1;
}

// Regular expressions for normalizing white space.
var whtSpEnds = new RegExp("^\\s*|\\s*$", "g");
var whtSpMult = new RegExp("\\s\\s+", "g");

function normalizeString(s)
{
	s = s.replace(whtSpMult, " ");  // Collapse any multiple whites space.
	s = s.replace(whtSpEnds, "");   // Remove leading or trailing white space.
	return s;
}

</script>
<body>

<%
	String title = null;
	IniUI iniUI = IniUI.getInstance();
	boolean isDiscoveredCompsPopupEnabled = iniUI.isDiscoveredCompsPopupEnabled();
	if(isDiscoveredCompsPopupEnabled)
	{
		title = "admin.discover.Uncheck to disable the pop-up";
	}
	else
	{
		title = "admin.discover.Check to enable the pop-up";
	}

	EgStartStopDisc disc = EgStartStopDisc.getInstance();
	EgConfigInfo configInfo = new EgConfigInfo("manager");
	File egDiscoverFile = new File(configInfo.egDiscTrackingFile);
	if(egDiscoverFile.canRead())
	{
		if(disc.isDiscAlive())
		{
%>
			<table cellspacing='0' cellpadding='0' border='0' width='100%' height='100%'>
				<tr>
					<td align='left' ><input type='checkbox' onClick='javascipt:disableDiscCompsPopup(this)' title='<egui:intnl text="<%=title%>"/>' name="popup" class="eg_input" id="popup" <%=isDiscoveredCompsPopupEnabled?"checked":""%>></td>

					<td align = 'right' width = '20%' class='padding6'> <input type='image' id="close" name="close" onClick='javascript:hideDiscoveredCompsPopUpDiv();' title='<egui:intnl text="admin.discover.Click here to close"/>' src='/final/monitor/eg_images/winclose.gif' onmouseover="javascript:loadEnabledCloseImage()" onmouseout="javascript:loadDisabledCloseImage()"></td>
				</tr>
				<tr>
					<td valign='top' colspan="2">
						<table cellspacing='0' cellpadding='0' border='0' width='100%'>
							<tr>
								<td width='100%' height='125' align='center'>
									<img src='/final/monitor/eg_images/indicator_medium.gif'><br><br><egui:intnl text="admin.discover.Discovery in progress"/>. <egui:intnl text="admin.discover.Please wait"/>.....
								</td>
							</tr>
						</table>
					</td>
				</tr>
			</table>
<%
		}
		return;
	}
	String reqServerType = request.getParameter("serverType");
	String showDiscCompsPopupInBack = request.getParameter("showDiscCompsPopupInBack");

	int totalDiscoveredComps = 0;
	ArrayList discoveredCompsList = null;
	ArrayList discoveredCompTypetList = null;
	ArrayList discoveredCompsWithIPList = null;

	IniFile egDiscoverIni = new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_discover.ini");
	if(egDiscoverIni == null)
	{
		return;
	}
	String[] allSubjects = egDiscoverIni.getSubjects();
	if(allSubjects == null || allSubjects.length == 0)
	{
		return;
	}

	for(int i=0;i<allSubjects.length;i++)
	{
		String serverType = allSubjects[i].trim();
		if(reqServerType != null && !reqServerType.equals(serverType))
		{
			continue;
		}

		String [] allLines = egDiscoverIni.getLinesUnderSubject(serverType);
		if(allLines == null || allLines.length == 0)
		{
			continue;
		}

		int count = 0;
		String IP = "";
		String discoveredComps = "";
		for(int j=0;j<allLines.length;j++)
		{
			String line = allLines[j].trim();
			if(!line.startsWith("#New")) continue;

			if(discoveredCompsWithIPList == null)
			{
				discoveredCompsWithIPList = new ArrayList();
			}

			count += 1;
			IP = line.substring(line.indexOf("=")+1);
			IP = IP.substring(IP.indexOf(",")+1);
			IP = IP.substring(0,IP.indexOf(","));

			line = line.substring(0,line.indexOf("="));
			line = line.substring(line.indexOf("|")+1);
			line = line.substring(line.indexOf(":")+1);
			discoveredComps = discoveredComps + line + ",";

			discoveredCompsWithIPList.add(serverType+":"+line);
			discoveredCompsWithIPList.add(IP);
		}

		if(count != 0)
		{
			totalDiscoveredComps += count;
			if(discoveredCompsList == null)
			{
				discoveredCompsList = new ArrayList();
			}
			if(discoveredCompTypetList == null)
			{
				discoveredCompTypetList = new ArrayList();
			}
			discoveredComps = discoveredComps.substring(0,discoveredComps.length()-1);
			discoveredCompTypetList.add(serverType);
			discoveredCompsList.add(serverType);
			discoveredCompsList.add(discoveredComps);
		}
	}

	if(discoveredCompTypetList != null && discoveredCompTypetList.size() > 0)
	{
		String userLanguage = _user.getLanguage();
		if (userLanguage == null)
		{
			userLanguage = iniUI.getDefaultLanguage();
		}
		EgMappingInfo mappingInfo =  new EgMappingInfo(userLanguage);
		MappingNameSorter sorter = new MappingNameSorter(userLanguage);
		discoveredCompTypetList = sorter.getSortedCompTypeList(discoveredCompTypetList);
%>
			<table cellspacing='0' cellpadding='0' border='0' width='100%' onclick='javascript:disableAutoHide()'>
				<tr>
					<td align='center' valign='top' style='padding:0px'>
						<table cellspacing='0' cellpadding='0' border='0' width='100%'>
							<tr>
								<td align='left' style="width:12px" ><input type='checkbox' onClick='javascipt:disableDiscCompsPopup(this)' title='<egui:intnl text="<%=title%>"/>' name="popup" class="eg_input" id="popup" <%=isDiscoveredCompsPopupEnabled?"checked":""%>></td>

								<td align='center' class='eg_75bold'><egui:intnl text="admin.discover.Discovered components"/> : <%=totalDiscoveredComps%></td>

								<td align='right' style="width:20px" ><input type='image' id="close" name="close" onClick='javascript:hideDiscoveredCompsPopUpDiv();' title='<egui:intnl text="admin.discover.Click here to close"/>' src='/final/monitor/eg_images/winclose.gif' onmouseover="javascript:loadEnabledCloseImage()" onmouseout="javascript:loadDisabledCloseImage()"></td>
							</tr>
						</table>
					</td>

				</tr>
				<tr>
					<td>
						<table cellspacing='0' cellpadding='4' border='0' width='100%' class='tableborder_mail2'>
							<tr>
								<th align='left' class='cell_border3' style='border-right-width:0px' width='200'><egui:intnl text="admin.discover.Component type"/>
<%
		if(discoveredCompTypetList.size() >1)
		{
%>
								<img id='img0' src='/final/monitor/eg_images/arrow_up_black_small.gif' style='display:\"\"' align='absmiddle' onclick='this.blur();return sortTable(0,0);'>
<%
		}
%>
								</th>
								<th align='left' class='cell_border3' style='border-left-width:0px' width='40%'><egui:intnl text="admin.discover.Component"/></th>
							</tr>
							<tr>
								<td colspan='2' style='padding:0px'>
									<div class='div_scroll' style='height:144px;border:0px solid #ff0000;' onscroll='javascript:disableAutoHide()'>
										<table cellpadding='2' cellspacing='0' border='0' width='100%'>
											<tbody id='rsTable0'>
<%

		String classI = "";
		String classII = "";
		for(int i=0;i<discoveredCompTypetList.size();i++)
		{
			EgName nameObj = (EgName)discoveredCompTypetList.get(i);
			String dispName = nameObj.getLocalName();
			String actualName = nameObj.getActualName();
%>
												<tr>
<%
			if(dispName.length() <= 23)
			{
%>
													<td class='mail_bottomright2' valign='top'><a target='main' STYLE='text-decoration:none' class='dash_link' href='<%="/final/admin/EgConfigEnv.jsp?backButNeed=yes&server="+actualName+"&showDiscCompsPopupInBack="+showDiscCompsPopupInBack%>'><%=dispName%></a></td>
<%
			}
			else
			{
%>
													<td class='mail_bottomright2' valign='top' nowrap><a target='main' STYLE='text-decoration:none' class='dash_link' title='<%=dispName%>' href='<%="/final/admin/EgConfigEnv.jsp?backButNeed=yes&server="+actualName+"&showDiscCompsPopupInBack="+showDiscCompsPopupInBack%>'><%=dispName.substring(0,20)%>...</a></td>
<%
			}
%>
													<td width='70%' valign='top' style='padding:0px' class='mail_bottom2'>
														<table cellpadding='2' cellspacing='0' border='0' width='100%'>
<%
			int idx = discoveredCompsList.indexOf(actualName);
			String compNames = (String)discoveredCompsList.get(idx+1);
			ArrayList aListCompnames = StringUtils.myTokenizer(compNames,",");
			Collections.sort(aListCompnames,String.CASE_INSENSITIVE_ORDER);

			boolean lastRow = false;
			int size = aListCompnames.size();
			for(int j=0;j<aListCompnames.size();j++)
			{
				String element1 = "";
				String element2 = "";
				String hostName1 = "";
				String hostName2 = "";
				String port1 = "";
				String port2 = "";

				element1 = (String)aListCompnames.get(j);
				hostName1 =  element1.substring(0,element1.indexOf(":"));
				port1 = element1.substring(element1.indexOf(":")+1);

				j = j+1;
				if(j < aListCompnames.size())
				{
					element2 = (String)aListCompnames.get(j);
					hostName2 =  element2.substring(0,element2.indexOf(":"));
					port2 = element2.substring(element2.indexOf(":")+1);
				}

				int idx1 = discoveredCompsWithIPList.indexOf(actualName+":"+element1);
				String IP1 = (String)discoveredCompsWithIPList.get(idx1+1);

				String IP2 = "";
				if(element2.length() > 0)
				{
					idx1 = discoveredCompsWithIPList.indexOf(actualName+":"+element2);
					IP2 = (String)discoveredCompsWithIPList.get(idx1+1);
				}

				if(!lastRow)
				{
					if(size/2 == 0 || (size/2== 1 && size%2 == 0)) lastRow = true;
				}
%>
															<tr>
<%
				if(element1.endsWith(":NULL"))
				{
					element1 = element1.substring(0,element1.lastIndexOf(":NULL"));
				}
				if(element2.endsWith(":NULL"))
				{
					element2 = element2.substring(0,element2.lastIndexOf(":NULL"));
				}

				if(lastRow)
				{
					classI = "mail_right";
					classII = "";
				}
				else
				{
					classI = "mail_bottomright";
					classII = "mail_bottom";
				}

				if(element1.length() <= 24)
				{
%>
																<td width = '50%' class='<%=classI%>'><a target='main' STYLE='text-decoration:none' class='dash_link' href='<%="/final/admin/EgNewServer.jsp?server=new&from=inventory&serverType="+actualName+"&allExternalTests=false&hostcheck=true&hostip="+EgURLEncoder.encode(IP1,"UTF-8")+"&hostname="+EgURLEncoder.encode(hostName1,"UTF-8")+"&discPort="+port1+"&showDiscCompsPopupInBack="+showDiscCompsPopupInBack+"&fromHomePopup=yes"%>'><%=element1%></a></td>
<%
				}
				else
				{
%>
																<td width = '50%' class='<%=classI%>'><a target='main' STYLE='text-decoration:none' class='dash_link' title='<%=element1%>' href='<%="/final/admin/EgNewServer.jsp?server=new&from=inventory&serverType="+actualName+"&allExternalTests=false&hostcheck=true&hostip="+EgURLEncoder.encode(IP1,"UTF-8")+"&hostname="+EgURLEncoder.encode(hostName1,"UTF-8")+"&discPort="+port1+"&showDiscCompsPopupInBack="+showDiscCompsPopupInBack+"&fromHomePopup=yes"%>'><%=element1.substring(0,21)%>...</a></td>
<%
				}

				if(element2.length() <= 24)
				{
%>
																<td width = '50%' class='<%=classII%>'><a target='main' STYLE='text-decoration:none' class='dash_link' href='<%="/final/admin/EgNewServer.jsp?server=new&from=inventory&serverType="+actualName+"&allExternalTests=false&hostcheck=true&hostip="+EgURLEncoder.encode(IP2,"UTF-8")+"&hostname="+EgURLEncoder.encode(hostName2,"UTF-8")+"&discPort="+port2+"&showDiscCompsPopupInBack="+showDiscCompsPopupInBack+"&fromHomePopup=yes"%>'><%=element2%></a></td>
<%
				}
				else
				{
%>
																<td width = '50%' class='<%=classII%>'><a target='main' STYLE='text-decoration:none' class='dash_link' title='<%=element2%>' href='<%="/final/admin/EgNewServer.jsp?server=new&from=inventory&serverType="+actualName+"&allExternalTests=false&hostcheck=true&hostip="+EgURLEncoder.encode(IP2,"UTF-8")+"&hostname="+EgURLEncoder.encode(hostName2,"UTF-8")+"&discPort="+port2+"&showDiscCompsPopupInBack="+showDiscCompsPopupInBack+"&fromHomePopup=yes"%>'><%=element2.substring(0,21)%>...</a></td>
<%
				}
%>
															</tr>
<%
				size = size-2;
			}
%>
														</table>
													</td>
												</tr>
<%
		}
%>
											</tbody>
										</table>
									</div>
								</td>
							</tr>
						</table>
					</td>
				</tr>
			</table>
<%
	}
%>
<body>
</html>

