<%@ include file="../../EgTrackerAJSON.jsp" %>
<%@ page import="com.eg.EgName" %>
<%@ page import = "java.io.*" %>
<%@ page import = "java.util.*" %>
<%@ page import="com.eg.EgInstallInfo" %>
<%@ page import="com.eg.MappingNameSorter" %>
<%@ page import="com.egurkha.ini.IniUI" %>
<%@ page import="com.eg.EgRoleInfo" %>
<%@ page import="egurkha.TransactionBean" %>
<%@ page import="net.sf.json.*"%>
<%@ page import="com.egurkha.util.*" %>
<%@ page import = "egurkha.EgUIUtils" %>

<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%
	response.setContentType("application/json");
	JSONObject rootJson = new JSONObject();
	JSONObject compTypesJson = new JSONObject();
	JSONObject searchJson = new JSONObject();
	JSONArray gridJson = new JSONArray();
	JSONArray componentList = new JSONArray();
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>

<%
	String egTitleSearchStr = request.getParameter("egTitleSearchStr");
	egTitleSearchStr = EgUIUtils.decodeSecurityChar(egTitleSearchStr);
	boolean isSearchResult = (egTitleSearchStr != null && !egTitleSearchStr.equals(""));
	ArrayList searchList = new ArrayList();
	boolean searchItemFound = false;

	IniUI iniUI = IniUI.getInstance();
	String userLanguage = iniUI.getDefaultLanguage();
	if (_user != null)
	{
		userLanguage = _user.getLanguage();
	}

	String uiFile = "eg_ui.ini";
	String iniFileDir = EgInstallInfo.getInstallDir()+ "/manager/config/";
	IniFile egUI = new IniFile(iniFileDir + uiFile);
	String currentDateFormat = egUI.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
	Date date = new Date(System.currentTimeMillis());
	String currentDateTime = DateUtil.formatDate(date,currentDateFormat+" HH:mm:ss");
	String finalCurrDateTime = currentDateTime;
	if (currentDateTime.indexOf(", ") > -1)
	{
		String dateVal = currentDateTime.substring(0,currentDateTime.indexOf(", "));
		String time = currentDateTime.substring(currentDateTime.indexOf(", ")+1);
		finalCurrDateTime =  dateVal + "" +time;
	}

	List csvList = new LinkedList();
	Vector headingForCSV = new Vector();
	Vector headerForCSV1 = new Vector();

	String componentType = request.getParameter("componentType");
	String testType = request.getParameter("testType");
	componentType = (componentType != null)?componentType:"All";
	MappingNameSorter sorter = new MappingNameSorter(userLanguage);
	session.setAttribute("Component_type",componentType);
	session.setAttribute("egTitleSearchStr",egTitleSearchStr);
	String selectedCompTypeDispName = "";

	List selectedCompList = new ArrayList();
	if (!componentType.equals("") && !componentType.equalsIgnoreCase("All"))
	{
		selectedCompList.add(componentType);
		selectedCompList = sorter.getSortedCompTypeList(selectedCompList);
		EgName compNameObj = (EgName)selectedCompList.get(0);
		selectedCompTypeDispName = compNameObj.getLocalName();
	}
	else
	{
		selectedCompTypeDispName = "All";
	}

	headingForCSV.add("Data Purge Periods Report");
	csvList.add(headingForCSV);
	csvList.add("Generated on,"+finalCurrDateTime);

	headerForCSV1.add("Component Type,"+selectedCompTypeDispName);
	csvList.add(headerForCSV1);

	ArrayList aListDbTest = new ArrayList();
	ArrayList aListResultantCtype = new ArrayList();
	ArrayList aListTempDbTest = new ArrayList();
	
	//for pdf work
	String csrfToken = request.getParameter("com.eg.CSRF_NONCE");
	String tmp=(String)request.getQueryString();
	String mngrIProc = new IniFile(new EgConfigInfo("manager").getDbFile()).getValue("DB_PROPERTIES","ManagerUrl");
	String htmlFileName =mngrIProc+"/final/admin/EgDbSettings/data/EgPrintDBPurgePeriodDetails.jsp;jsessionid="+session.getId()+"?"+tmp+"&print=pdfpage&com.eg.CSRF_NONCE="+csrfToken;
	session.setAttribute("PDF_URL",htmlFileName);
	session.setAttribute("REPORT_NAME","Purge_details");
	session.setAttribute("REPORT_LAYOUT","Portrait");
	session.setAttribute("PAGE_WIDTH_PDF","1100");

	IniFile egSpecsIni = new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_specs.ini");

	EgRoleInfo ri = EgRoleInfo.getInstance(session.getId(),(String)session.getAttribute("sess_userid"));
	List listComponentTypes = Arrays.asList(ri.getServerTypes());
	boolean isConfigSupported = EgInstallInfo.isConfigSupported;
	EgUserRole userRole = _user.getUserRole();
	if (_user != null && isConfigSupported)
	{
		isConfigSupported = userRole.hasAnyConfigRole(EgUserPermission.CONFIG);
	}

	// To list those component types only which has associated tests with it in eg_db.ini
	for(int i=0;i<listComponentTypes.size();i++)
	{
		String strComponentType = (String)listComponentTypes.get(i);
		String strTests = egSpecsIni.getValue("TEST_MAPPING",strComponentType);
		if (strTests != null)
		{
			ArrayList aListTempTests = new ArrayList();
			StringTokenizer strTokens = new StringTokenizer(strTests,",");
			while (strTokens.hasMoreTokens())
			{
				String strToken = strTokens.nextToken().trim();
				if (!isConfigSupported)
				{
					if (EgInstallInfo.isConfigTest(strToken))
					{
						continue;
					}
				}
				aListTempTests.add(strToken);
			}
			for (int j=0;j<aListTempTests.size();j++)
			{
				String strTest = (String)aListTempTests.get(j);
				if(!aListResultantCtype.contains(strComponentType))
				{
					aListResultantCtype.add(strComponentType);
				}
				if(!aListTempDbTest.contains(strTest))
				{
					aListTempDbTest.add(strTest);
				}
			}
		}
	}

	aListDbTest = aListTempDbTest; // Assigns Clubbed Tests of Managed Comp Types

	listComponentTypes = sorter.getSortedCompTypeList(aListResultantCtype);

	// To list the tests for the selected component type
	ArrayList aListShowTests = new ArrayList();
	if (!componentType.equals("") && !componentType.equalsIgnoreCase("All"))
	{
		String strTests = egSpecsIni.getValue("TEST_MAPPING",componentType);
		StringTokenizer strTokens = new StringTokenizer(strTests,",");
		while (strTokens.hasMoreTokens())
		{
			String strToken = strTokens.nextToken().trim();
			if (!isConfigSupported)
			{
				if (EgInstallInfo.isConfigTest(strToken))
				{
					continue;
				}
			}
			aListShowTests.add(strToken);
		}
		aListDbTest = aListShowTests;
		rootJson.put("aListDDDTestForComp",aListDbTest);
	}
	// Ends

	// Added for search button 
	if (isSearchResult)
	{
		StringTokenizer st = new StringTokenizer(egTitleSearchStr);
		while (st.hasMoreTokens())
		{
			String thisToken = st.nextToken().trim();
			if (thisToken.equals(""))
			{
				continue;
			}
			searchList.add(thisToken);
		}

		ArrayList searchList_final=new ArrayList();
		for (int i=0;i<aListDbTest.size();i++)
		{
			String dbDisplay_test=(String)aListDbTest.get(i);
			String label=_mapping.getTestDescription(dbDisplay_test);
			for (int j=0;j<searchList.size();j++)
			{
				String search_String=(String)searchList.get(j);
				if (label != null && label.toLowerCase().indexOf(search_String.toLowerCase()) != -1)
				{
					if (!searchList_final.contains(dbDisplay_test))
					{
						searchList_final.add(dbDisplay_test);
					}
				}
			}
		}
		if (searchList_final != null && searchList_final.size() > 0)
		{
			aListDbTest=searchList_final;
			searchItemFound = true;
		}
		else
		{
			searchItemFound = false;
		}
	}
	// Ends

	aListDbTest = sorter.getSortedTestList(aListDbTest);

	rootJson.put("aListTest",aListDbTest);
	rootJson.put("listComponentTypes",listComponentTypes);

	JSONObject jObj = new JSONObject();
	jObj.put("displayField","All");
	jObj.put("valueField","All");
	componentList.add(jObj);
	for (int j=0; j<listComponentTypes.size(); j++)
	{
		JSONObject jObjOne = new JSONObject();
		EgName nameObj = (EgName)listComponentTypes.get(j);
		String actualname = nameObj.getActualName();
		String localname = nameObj.getLocalName();
		jObjOne.put("displayField",localname);
		jObjOne.put("valueField",actualname);
		componentList.add(jObjOne);
	}

	if (aListDbTest != null && aListDbTest.size() != 0)
	{
		String dbFile = "eg_db.ini";
		IniFile dbcleanup = new IniFile(iniFileDir + dbFile);
		String measureCleanPeriod = dbcleanup.getValue("MANAGER_SETTINGS","MeasurementCleanPeriod");
		HashMap testCleanPeriodMap = new HashMap();
		String[] testVars = dbcleanup.getVariables("TABLE_DELETE_PERIODS");
		Vector allValues = dbcleanup.getAllValues("TABLE_DELETE_PERIODS");
		if (testVars != null)
		{
			int testVarsLen = testVars.length;
			for (int i=0; i<testVarsLen; i++)
			{
				String testVar = testVars[i];
				String testVal = (String) allValues.get(i);
				testCleanPeriodMap.put(testVar,testVal);
			}
		}

		csvList.add("Test,Purge Period (In Days)");
		int aListDDDTestSize = aListDbTest.size();
		for (int j=0;j<aListDDDTestSize;j++)
		{
			JSONObject jObjMeasure = new JSONObject();
			EgName name = (EgName)aListDbTest.get(j);
			String dbValue = name.getActualName();
			String dddDisplay = name.getLocalName();
			String strVal = (String)testCleanPeriodMap.get(dbValue);
			if (strVal == null || strVal.length() == 0)
			{
				strVal = measureCleanPeriod;
			}
			int newStrVal = Integer.parseInt(strVal);
			jObjMeasure.put("Test",dddDisplay);
			jObjMeasure.put("purgePeriod",newStrVal);
			gridJson.add(jObjMeasure);
			String csvData = dddDisplay+","+strVal;
			csvList.add(csvData);
		}
	}
	session.setAttribute("list",csvList);

	if (!searchItemFound && egTitleSearchStr != null && !egTitleSearchStr.equals(""))
	{
		searchJson.put("Test","No Search Data Found");
	}
	else
	{
		searchJson.put("Test","Search Data Found");
	}

	if (request.getQueryString() != null)
	{
		session.setAttribute("adminLastAccessedURL","/final/admin/EgDbSettings.jsp?"+request.getQueryString());
	}
	else
	{
		session.setAttribute("adminLastAccessedURL","/final/admin/EgDbSettings.jsp");
	}
	rootJson.put("searchJson",searchJson);
	rootJson.put("gridJson",gridJson);
	rootJson.put("componentList",componentList);
	rootJson.put("testType",testType);
	out.println(rootJson);
%>



