<%
/*
 *   File			:	EgConfigureVCEvents.jsp
 *   Purpose		:	UI for configuring events for vCenter server
 *   Creation Date	:	07/05/2009
 *   Author			:	Vaathsalya
 *   UI Design		:	Jaiwin & Krishnamurthi
*/
%>

<%@ include file="EgTrackerA.jsp" %>
<%@ page errorPage="EgProbs.jsp"%>
<%@ page import = "com.eg.IniFile" %>
<%@ page import="com.eg.EgInstallInfo"%>

<%@ taglib prefix ="egui" uri="../WEB-INF/eg-taglib.tld"%>

<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>

<%
	IniFile egTestsini = new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_tests.ini");
	String strDescriptor = request.getParameter("descriptor");
	strDescriptor = (strDescriptor == null?"":strDescriptor);
%>

<%
	String[] descriptor_arr = egTestsini.getVariables("VCEventFilterTypes");
	ArrayList aListDescriptor = new ArrayList();
	String events ="";
	String eventsEntry = "";
	ArrayList aListIncludedEvents = new ArrayList();
	ArrayList aListExcludedEvents = new ArrayList();

	for (int i=0; i<descriptor_arr.length; i++)
	{
		String strDesc = "";
		String strTestAndDescriptor = descriptor_arr[i];
		strDesc = strTestAndDescriptor.substring(strTestAndDescriptor.lastIndexOf(":")+1);
		aListDescriptor.add(strDesc);
	}
	Collections.sort(aListDescriptor,String.CASE_INSENSITIVE_ORDER);

	if (strDescriptor != null)
	{
		String thisToken = "";
		events = egTestsini.getValue("VirtualCenterEvents","VCEventsTest:"+strDescriptor).trim();
		eventsEntry = egTestsini.getValue("VCEventFilterTypes","VCEventsTest:"+strDescriptor).trim();
		StringTokenizer st1 = new StringTokenizer(events,",");
		if (eventsEntry.equalsIgnoreCase("all:none"))
		{
			while (st1.hasMoreTokens())
			{
				thisToken = st1.nextToken().trim();
				aListIncludedEvents.add(thisToken);
			}
		}
		else if (eventsEntry.equalsIgnoreCase("none:all"))
		{
			while (st1.hasMoreTokens())
			{
				thisToken = st1.nextToken().trim();
				aListExcludedEvents.add(thisToken);
			}
		}
		else if (!eventsEntry.startsWith("all:") && eventsEntry.endsWith("none"))
		{
			String temp = eventsEntry.substring(0,eventsEntry.indexOf(":"));
			StringTokenizer st2 = new StringTokenizer(temp,",");
	
			while (st2.hasMoreTokens())
			{
				thisToken = st2.nextToken().trim();
				aListIncludedEvents.add(thisToken);
			}

			while (st1.hasMoreTokens())
			{
				String token = st1.nextToken().trim();
				if (aListIncludedEvents.contains(token)) continue;
				aListExcludedEvents.add(token);
			}
		}
		else if (eventsEntry.startsWith("all")&& !eventsEntry.endsWith(":none"))
		{
			String temp = eventsEntry.substring(eventsEntry.lastIndexOf(":")+1);
			StringTokenizer st3 = new StringTokenizer(temp,",");

			while (st3.hasMoreTokens())
			{
				thisToken = st3.nextToken().trim();
				aListExcludedEvents.add(thisToken);
			}

			while (st1.hasMoreTokens())
			{
				String token = st1.nextToken().trim();
				if (aListExcludedEvents.contains(token)) continue;
				aListIncludedEvents.add(token);
			}
		}
	}

	String fromPage = request.getParameter("fromPage");
	fromPage = (fromPage != null)?fromPage:"";

	String tmpUrl = "listSearch.jsp?title=VCENTER EVENTS&subtitle=false";
	if (fromPage != null && fromPage.equalsIgnoreCase("TestConfiguration"))
	{
		tmpUrl = tmpUrl + "&backButton=true";
	}

	String requestFrom = request.getParameter("requestFrom");
	if (requestFrom != null && requestFrom.equals("EgConfigureComponentTests.jsp"))
	{
		String componentType = request.getParameter("componentType");
		String componentName = request.getParameter("componentName");
		String testName = request.getParameter("testName");
	}
%>

<html>
<head>
<egui:skin ui="admin"/>
<SCRIPT LANGUAGE="JavaScript">

function selectType()
{
	var thisForm = document.vcevent;
	var selectedDesc =  thisForm.descriptor.options[thisForm.descriptor.selectedIndex].value;
	var fromPage = thisForm.fromPage.value;
	if (selectedDesc != "-1")
	{
		if (fromPage == "TestConfiguration")
		{
			window.location.href = "EgConfigureVCEvents.jsp?descriptor="+encodeURI(selectedDesc)+"&fromPage=TestConfiguration";
		}
		else
		{
			window.location.href = "EgConfigureVCEvents.jsp?descriptor="+encodeURI(selectedDesc);
		}
	}
	else
	{
		if (fromPage == "TestConfiguration")
		{
			window.location.href = "EgConfigureVCEvents.jsp?fromPage=TestConfiguration";
		}
		else
		{
			window.location.href = "EgConfigureVCEvents.jsp";
		}
	}
}

function addToExcluded()
{
	var thisForm = document.vcevent;
	var includedEventsLen = thisForm.includedEvents.options.length;
	var excludedEventsLen = thisForm.excludedEvents.options.length;
	var includedEventsList = thisForm.includedEvents;
	var excludedEventsList = thisForm.excludedEvents;

	for (i=0;i<includedEventsLen;i++)
	{
		if (includedEventsList.options[i].selected==true)
		{
			testTxt = includedEventsList.options[i].text;
			testVal = includedEventsList.options[i].value;
			excludedEventsList.options[excludedEventsLen++]=new Option(testTxt,testVal);
		}
	}

	for (i=includedEventsLen;i>0;i--)
	{
		if (includedEventsList.options[i-1].selected==true)
		{
			includedEventsList.options[i-1]=null;
		}
	}
}

function addToIncluded()
{
	var thisForm = document.vcevent;
	var includedEventsLen = thisForm.includedEvents.options.length;
	var excludedEventsLen = thisForm.excludedEvents.options.length;
	var includedEventsList = thisForm.includedEvents;
	var excludedEventsList = thisForm.excludedEvents;

	for (i=0;i<excludedEventsLen;i++)
	{
		if (excludedEventsList.options[i].selected==true)
		{
			testTxt = excludedEventsList.options[i].text;
			testVal = excludedEventsList.options[i].value;
			includedEventsList.options[includedEventsLen++]=new Option(testTxt,testVal);
		}
	}

	for (i=excludedEventsLen;i>0;i--)
	{
		if (excludedEventsList.options[i-1].selected==true)
		{
			excludedEventsList.options[i-1]=null;
		}
	}
}

function updateData()
{
	var thisForm = document.vcevent;
	var prevIncludedEvents = "<%=aListIncludedEvents%>";
	var prevExcludedEvents = "<%=aListExcludedEvents%>";
	var selectedDescriptor  = thisForm.descriptor.options[thisForm.descriptor.selectedIndex].value;
	var includedEventsLen = thisForm.includedEvents.options.length;
	var excludedEventsLen = thisForm.excludedEvents.options.length;
	var includedEventsList = thisForm.includedEvents;
	var excludedEventsList = thisForm.excludedEvents;
	var includedEvents_arr = new Array();
	var excludedEvents_arr = new Array();

	if (selectedDescriptor == "-1")
	{
		alert('<egui:intnl text="admin.vcevent.Please choose an event category"/>');
		return false;
	}

	for (var i=0;i<includedEventsLen;i++)
	{
		includedEvents_arr[i] = includedEventsList.options[i].value;
	}

	for (var i=0;i<excludedEventsLen;i++)
	{
		excludedEvents_arr[i] = excludedEventsList.options[i].value;
	}

	thisForm.strIncludedEvents.value = includedEvents_arr;
	thisForm.strExcludedEvents.value = excludedEvents_arr;
	thisForm.prevIncludedEvents.value = prevIncludedEvents;
	thisForm.prevExcludedEvents.value = prevExcludedEvents;
	thisForm.submit();
}
</SCRIPT>
</head>

<body style="overflow:auto" id="space6">
<form name="vcevent" method="post" action="EgConfigureVCEventsp.jsp" style="margin:0px">
<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0">
	<jsp:include page="<%=tmpUrl%>" />
	<tr>
		<td width="100%" id="eg_whitebg" align="center" valign="middle">
			<table align="center" cellspacing="0" cellpadding="0" border="0" width="85%">
				<tr>
					<td height="6" id="inner_top_left" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
					<td height="6" id="eg_subcontentbg" width="100%" colspan="2"><img src="/final/admin/eg_images/spacer.gif" height="6"></td>
					<td height="6" id="inner_top_right" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
				</tr>
				<tr>
					<td colspan="4" id="eg_subcontentbg" class="form_border">
						<table align="center" cellspacing="0" cellpadding="0" border="0">
							<tr>
								<td width="35%" align="right" nowrap><egui:intnl text="admin.vcevent.Event category"/></td>
								<td>&nbsp;&nbsp;:&nbsp;&nbsp;</td>
								<td id="eg_subcontentbg" align="left" class="paddingright">
									<select name="descriptor" style="width:150px" onchange="javascript:selectType()">
<%
	if (aListDescriptor != null && aListDescriptor.size() > 0)
	{
%>
		<option value="-1"><egui:intnl text="admin.common.Choose one" /></option>
<%
		for (int j=0;j<aListDescriptor.size();j++)
		{
			String descVal = (String)aListDescriptor.get(j);
%>
			<option value="<%=descVal%>" <%=descVal.equals(strDescriptor)?"selected":""%>><%=descVal%></option>
<%
		}
	}
	else
	{
%>
		<option value="-1"><egui:intnl text="admin.vcevent.Not Applicable" /></option>
<%
	}
%>
									</select>
								</td>
								<td width="50">&nbsp;</td>
							</tr>
						</table>
					</td>
				</tr>
				<tr>
					<td colspan="4" id="eg_subcontentbg" class="padding4"><br>
						<table align="center" cellspacing="0" cellpadding="0" border="0">
							<tr>
								<td width="45%">
									<table align="center" cellspacing="0" cellpadding="0" border="0">
										<tr>
											<td id="eg_subheadbg" align='center' valign='middle' class="head_padding4"><strong><egui:intnl text="admin.vcevent.Included Events"/></strong></td>
										</tr>
										<tr>
											<td align="center" valign="middle">
												<select name="includedEvents" size="25" multiple width="320" style="width:320px;margin:0px;">
<%
	Collections.sort(aListIncludedEvents,String.CASE_INSENSITIVE_ORDER);
	for (int m=0;m<aListIncludedEvents.size();m++)
	{
		String inclEvents = (String)aListIncludedEvents.get(m);
%>
		<option value="<%=inclEvents%>"><%=inclEvents%></option>
<%
	}
%>
												</select>
											</td>
										</tr>
										<tr>
											<td>&nbsp;</td>
										</tr>
									</table>
								</td>
								<td id="tablebg2"  nowrap>&nbsp;&nbsp;&nbsp;</td>
								<td width="10%" align="center" valign="middle" id="head_padding2">
									<input type="button" value='&rsaquo;&rsaquo;' class="eg_lightbutton" name="Exclude" style="width: 85px; letter-spacing: 0px;" onclick="addToExcluded()">
									<br><br><br>
									<input type="button" value='&lsaquo;&lsaquo;' class="eg_lightbutton" name="include" style="width: 85px; letter-spacing: 0px;" onclick="addToIncluded()">
								</td>
								<td id="tablebg2"  nowrap>&nbsp;&nbsp;&nbsp;</td>
								<td width="45%">
									<table align="center" cellspacing="0" cellpadding="0" border="0">
										<tr>
											<td id="eg_subheadbg" align='center' valign='middle' class="head_padding4" style="border-left-width:1px"><strong><egui:intnl text="admin.vcevent.Excluded Events"/></strong></td>
										</tr>
										<tr>
											<td align="center" valign="middle">
												<select name="excludedEvents" size="25" multiple width="320" style="width:320px;margin:0px;">
<%
	Collections.sort(aListExcludedEvents,String.CASE_INSENSITIVE_ORDER);
	for (int mm=0;mm<aListExcludedEvents.size();mm++)
	{
		String exclEvents = (String)aListExcludedEvents.get(mm);
%>
		<option value="<%=exclEvents%>"><%=exclEvents%></option>
<%
	}
%>
												</select>
											</td>
										</tr>
										<tr>
											<td>&nbsp;</td>
										</tr>
									</table>
								</td>
							</tr>
						</table>
					</td>
				</tr>
				<tr>
					<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
					<td id="eg_subcontentbg"  width="100%" colspan="2" valign="top" ><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
					<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
				</tr>
				<tr>
					<td colspan="4" align="center" height="40" valign="middle">
						<input type="button" name="updateButton" value='<egui:intnl text="admin.common.Update"/>' class="eg_back" style="width: 90px;" onClick="updateData()">
					</td>
				</tr>
			</table>
		</td>
	</tr>
</table>

<input type="hidden" name="strIncludedEvents" value="">
<input type="hidden" name="strExcludedEvents" value="">
<input type="hidden" name="prevIncludedEvents" value="">
<input type="hidden" name="prevExcludedEvents" value="">
<input type="hidden" name="fromPage" value="<%=fromPage%>">
</form>

<%
	session.setAttribute("adminLastAccessedURL","/final/admin/EgConfigureVCEvents.jsp?"+request.getQueryString());
%>

</body>
</html>



